/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditioncontract;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConditionContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>ConditionContractType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ConditionContract extends VdmEntity<ConditionContract> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.ConditionContractType";
    /**
     * Selector for all available fields of ConditionContract.
     * 
     */
    public final static SimpleProperty<ConditionContract> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @return Condition Record
     */
    @Nullable
    @ElementName( "ConditionContract" )
    private java.lang.String conditionContract;
    public final static SimpleProperty.String<ConditionContract> CONDITION_CONTRACT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "ConditionContract");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrType</b>
     * </p>
     * 
     * @return Condition Contract Type
     */
    @Nullable
    @ElementName( "CndnContrType" )
    private java.lang.String cndnContrType;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_TYPE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrProcVar</b>
     * </p>
     * 
     * @return Condition Contract Process Variant
     */
    @Nullable
    @ElementName( "CndnContrProcVar" )
    private java.lang.String cndnContrProcVar;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_PROC_VAR =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrProcVar");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @return Supplier as Partner of a Condition Contract
     */
    @Nullable
    @ElementName( "Supplier" )
    private java.lang.String supplier;
    public final static SimpleProperty.String<ConditionContract> SUPPLIER =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     * 
     * @return Customer as Partner of a Condition Contract
     */
    @Nullable
    @ElementName( "Customer" )
    private java.lang.String customer;
    public final static SimpleProperty.String<ConditionContract> CUSTOMER =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "Customer");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrActvtnStatus</b>
     * </p>
     * 
     * @return Condition Contract Activation Status
     */
    @Nullable
    @ElementName( "CndnContrActvtnStatus" )
    private java.lang.String cndnContrActvtnStatus;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_ACTVTN_STATUS =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrActvtnStatus");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrValidFrom</b>
     * </p>
     * 
     * @return Valid From
     */
    @Nullable
    @ElementName( "CndnContrValidFrom" )
    private LocalDate cndnContrValidFrom;
    public final static SimpleProperty.Date<ConditionContract> CNDN_CONTR_VALID_FROM =
        new SimpleProperty.Date<ConditionContract>(ConditionContract.class, "CndnContrValidFrom");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrValidTo</b>
     * </p>
     * 
     * @return Valid To
     */
    @Nullable
    @ElementName( "CndnContrValidTo" )
    private LocalDate cndnContrValidTo;
    public final static SimpleProperty.Date<ConditionContract> CNDN_CONTR_VALID_TO =
        new SimpleProperty.Date<ConditionContract>(ConditionContract.class, "CndnContrValidTo");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrClassfctnType</b>
     * </p>
     * 
     * @return Condition Contract Category
     */
    @Nullable
    @ElementName( "CndnContrClassfctnType" )
    private java.lang.String cndnContrClassfctnType;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_CLASSFCTN_TYPE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrClassfctnType");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     * 
     * @return Condition Contract: Reference
     */
    @Nullable
    @ElementName( "DocumentReferenceID" )
    private java.lang.String documentReferenceID;
    public final static SimpleProperty.String<ConditionContract> DOCUMENT_REFERENCE_ID =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "DocumentReferenceID");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrAssgmtRef</b>
     * </p>
     * 
     * @return Condition Contract: Assignment
     */
    @Nullable
    @ElementName( "CndnContrAssgmtRef" )
    private java.lang.String cndnContrAssgmtRef;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_ASSGMT_REF =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrAssgmtRef");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocumentReferenceID</b>
     * </p>
     * 
     * @return External Document Identifier
     */
    @Nullable
    @ElementName( "ExternalDocumentReferenceID" )
    private java.lang.String externalDocumentReferenceID;
    public final static SimpleProperty.String<ConditionContract> EXTERNAL_DOCUMENT_REFERENCE_ID =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "ExternalDocumentReferenceID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrExternalPartner</b>
     * </p>
     * 
     * @return Condition Contract: External Partner
     */
    @Nullable
    @ElementName( "CndnContrExternalPartner" )
    private java.lang.String cndnContrExternalPartner;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_EXTERNAL_PARTNER =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrExternalPartner");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceDocCat</b>
     * </p>
     * 
     * @return External Reference Document Category
     */
    @Nullable
    @ElementName( "CndnContrSourceDocCat" )
    private java.lang.String cndnContrSourceDocCat;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_SOURCE_DOC_CAT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrSourceDocCat");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceDoc</b>
     * </p>
     * 
     * @return External Reference
     */
    @Nullable
    @ElementName( "CndnContrSourceDoc" )
    private java.lang.String cndnContrSourceDoc;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_SOURCE_DOC =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrSourceDoc");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceDocItem</b>
     * </p>
     * 
     * @return External Reference Item
     */
    @Nullable
    @ElementName( "CndnContrSourceDocItem" )
    private java.lang.String cndnContrSourceDocItem;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_SOURCE_DOC_ITEM =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrSourceDocItem");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceUUID</b>
     * </p>
     * 
     * @return External Condition Contract GUID
     */
    @Nullable
    @ElementName( "CndnContrSourceUUID" )
    private UUID cndnContrSourceUUID;
    public final static SimpleProperty.Guid<ConditionContract> CNDN_CONTR_SOURCE_UUID =
        new SimpleProperty.Guid<ConditionContract>(ConditionContract.class, "CndnContrSourceUUID");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationUTCDateTime</b>
     * </p>
     * 
     * @return UTC Time Stamp of Condition Contract Creation
     */
    @Nullable
    @ElementName( "CreationUTCDateTime" )
    private OffsetDateTime creationUTCDateTime;
    public final static SimpleProperty.DateTime<ConditionContract> CREATION_UTC_DATE_TIME =
        new SimpleProperty.DateTime<ConditionContract>(ConditionContract.class, "CreationUTCDateTime");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeUTCDateTime</b>
     * </p>
     * 
     * @return UTC Time Stamp of Last Condition Contract Change
     */
    @Nullable
    @ElementName( "LastChangeUTCDateTime" )
    private OffsetDateTime lastChangeUTCDateTime;
    public final static SimpleProperty.DateTime<ConditionContract> LAST_CHANGE_UTC_DATE_TIME =
        new SimpleProperty.DateTime<ConditionContract>(ConditionContract.class, "LastChangeUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<ConditionContract> COMPANY_CODE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @return Purchasing Organization
     */
    @Nullable
    @ElementName( "PurchasingOrganization" )
    private java.lang.String purchasingOrganization;
    public final static SimpleProperty.String<ConditionContract> PURCHASING_ORGANIZATION =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     * 
     * @return Purchasing Group
     */
    @Nullable
    @ElementName( "PurchasingGroup" )
    private java.lang.String purchasingGroup;
    public final static SimpleProperty.String<ConditionContract> PURCHASING_GROUP =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     * 
     * @return Sales Organization
     */
    @Nullable
    @ElementName( "SalesOrganization" )
    private java.lang.String salesOrganization;
    public final static SimpleProperty.String<ConditionContract> SALES_ORGANIZATION =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     * 
     * @return Distribution Channel
     */
    @Nullable
    @ElementName( "DistributionChannel" )
    private java.lang.String distributionChannel;
    public final static SimpleProperty.String<ConditionContract> DISTRIBUTION_CHANNEL =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @return Division
     */
    @Nullable
    @ElementName( "Division" )
    private java.lang.String division;
    public final static SimpleProperty.String<ConditionContract> DIVISION =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "Division");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     * 
     * @return Sales Group
     */
    @Nullable
    @ElementName( "SalesGroup" )
    private java.lang.String salesGroup;
    public final static SimpleProperty.String<ConditionContract> SALES_GROUP =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     * 
     * @return Sales Office
     */
    @Nullable
    @ElementName( "SalesOffice" )
    private java.lang.String salesOffice;
    public final static SimpleProperty.String<ConditionContract> SALES_OFFICE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSuplrSettlmtCat</b>
     * </p>
     * 
     * @return Settlement Type Supplier
     */
    @Nullable
    @ElementName( "CndnContrSuplrSettlmtCat" )
    private java.lang.String cndnContrSuplrSettlmtCat;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_SUPLR_SETTLMT_CAT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrSuplrSettlmtCat");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrCustSettlmtCat</b>
     * </p>
     * 
     * @return Settlement Type Customer
     */
    @Nullable
    @ElementName( "CndnContrCustSettlmtCat" )
    private java.lang.String cndnContrCustSettlmtCat;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_CUST_SETTLMT_CAT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrCustSettlmtCat");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProduct</b>
     * </p>
     * 
     * @return Settlement Product
     */
    @Nullable
    @ElementName( "SettlmtProduct" )
    private java.lang.String settlmtProduct;
    public final static SimpleProperty.String<ConditionContract> SETTLMT_PRODUCT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "SettlmtProduct");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrExtensionCalendar</b>
     * </p>
     * 
     * @return Calendar for Condition Contract Extension
     */
    @Nullable
    @ElementName( "CndnContrExtensionCalendar" )
    private java.lang.String cndnContrExtensionCalendar;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_EXTENSION_CALENDAR =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrExtensionCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PriorSupplier</b>
     * </p>
     * 
     * @return Prior Supplier
     */
    @Nullable
    @ElementName( "PriorSupplier" )
    private java.lang.String priorSupplier;
    public final static SimpleProperty.String<ConditionContract> PRIOR_SUPPLIER =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "PriorSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolTableGroup</b>
     * </p>
     * 
     * @return Business Volume Table Group
     */
    @Nullable
    @ElementName( "BusVolTableGroup" )
    private java.lang.String busVolTableGroup;
    public final static SimpleProperty.String<ConditionContract> BUS_VOL_TABLE_GROUP =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "BusVolTableGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AmountFieldGroup</b>
     * </p>
     * 
     * @return Amount Fields Group
     */
    @Nullable
    @ElementName( "AmountFieldGroup" )
    private java.lang.String amountFieldGroup;
    public final static SimpleProperty.String<ConditionContract> AMOUNT_FIELD_GROUP =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "AmountFieldGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FinalSettlmtCalendar</b>
     * </p>
     * 
     * @return Calendar for Final Settlement
     */
    @Nullable
    @ElementName( "FinalSettlmtCalendar" )
    private java.lang.String finalSettlmtCalendar;
    public final static SimpleProperty.String<ConditionContract> FINAL_SETTLMT_CALENDAR =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "FinalSettlmtCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartialSettlmtCalendar</b>
     * </p>
     * 
     * @return Calendar for Partial Settlement
     */
    @Nullable
    @ElementName( "PartialSettlmtCalendar" )
    private java.lang.String partialSettlmtCalendar;
    public final static SimpleProperty.String<ConditionContract> PARTIAL_SETTLMT_CALENDAR =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "PartialSettlmtCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeltaSettlmtCalendar</b>
     * </p>
     * 
     * @return Calendar for Delta Settlement
     */
    @Nullable
    @ElementName( "DeltaSettlmtCalendar" )
    private java.lang.String deltaSettlmtCalendar;
    public final static SimpleProperty.String<ConditionContract> DELTA_SETTLMT_CALENDAR =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "DeltaSettlmtCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeltaAccrualSettlmtCalendar</b>
     * </p>
     * 
     * @return Calendar for Delta Accruals Settlement
     */
    @Nullable
    @ElementName( "DeltaAccrualSettlmtCalendar" )
    private java.lang.String deltaAccrualSettlmtCalendar;
    public final static SimpleProperty.String<ConditionContract> DELTA_ACCRUAL_SETTLMT_CALENDAR =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "DeltaAccrualSettlmtCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccrualClearingSettlmtCalendar</b>
     * </p>
     * 
     * @return Calendar for Accruals Deferral Settlement
     */
    @Nullable
    @ElementName( "AccrualClearingSettlmtCalendar" )
    private java.lang.String accrualClearingSettlmtCalendar;
    public final static SimpleProperty.String<ConditionContract> ACCRUAL_CLEARING_SETTLMT_CALENDAR =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "AccrualClearingSettlmtCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingConditionContract</b>
     * </p>
     * 
     * @return Predecessor Condition Contract
     */
    @Nullable
    @ElementName( "PrecedingConditionContract" )
    private java.lang.String precedingConditionContract;
    public final static SimpleProperty.String<ConditionContract> PRECEDING_CONDITION_CONTRACT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "PrecedingConditionContract");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrUUID</b>
     * </p>
     * 
     * @return Condition Contract GUID
     */
    @Nullable
    @ElementName( "CndnContrUUID" )
    private UUID cndnContrUUID;
    public final static SimpleProperty.Guid<ConditionContract> CNDN_CONTR_UUID =
        new SimpleProperty.Guid<ConditionContract>(ConditionContract.class, "CndnContrUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPurposeCat</b>
     * </p>
     * 
     * @return Condition Contract Purpose
     */
    @Nullable
    @ElementName( "CndnContrPurposeCat" )
    private java.lang.String cndnContrPurposeCat;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_PURPOSE_CAT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrPurposeCat");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrCurrency</b>
     * </p>
     * 
     * @return Currency of Condition Contract
     */
    @Nullable
    @ElementName( "CndnContrCurrency" )
    private java.lang.String cndnContrCurrency;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_CURRENCY =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrUnit</b>
     * </p>
     * 
     * @return Settlement Unit of Measure
     */
    @Nullable
    @ElementName( "CndnContrUnit" )
    private java.lang.String cndnContrUnit;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_UNIT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrUnitISOCode</b>
     * </p>
     * 
     * @return Settlement Unit of Measure in ISO Code
     */
    @Nullable
    @ElementName( "CndnContrUnitISOCode" )
    private java.lang.String cndnContrUnitISOCode;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_UNIT_ISO_CODE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrUnitSAPCode</b>
     * </p>
     * 
     * @return Settlement Unit of Measure in SAP Code
     */
    @Nullable
    @ElementName( "CndnContrUnitSAPCode" )
    private java.lang.String cndnContrUnitSAPCode;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_UNIT_SAP_CODE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrWeightUnit</b>
     * </p>
     * 
     * @return Settlement Unit of Weight
     */
    @Nullable
    @ElementName( "CndnContrWeightUnit" )
    private java.lang.String cndnContrWeightUnit;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_WEIGHT_UNIT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrWeightUnitISOCode</b>
     * </p>
     * 
     * @return Settlement Unit of Weight in ISO Code
     */
    @Nullable
    @ElementName( "CndnContrWeightUnitISOCode" )
    private java.lang.String cndnContrWeightUnitISOCode;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_WEIGHT_UNIT_ISO_CODE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrWeightUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrWeightUnitSAPCode</b>
     * </p>
     * 
     * @return Settlement Unit of Weight in SAP Code
     */
    @Nullable
    @ElementName( "CndnContrWeightUnitSAPCode" )
    private java.lang.String cndnContrWeightUnitSAPCode;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_WEIGHT_UNIT_SAP_CODE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrWeightUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrVolumeUnit</b>
     * </p>
     * 
     * @return Settlement Unit of Volume
     */
    @Nullable
    @ElementName( "CndnContrVolumeUnit" )
    private java.lang.String cndnContrVolumeUnit;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_VOLUME_UNIT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrVolumeUnitISOCode</b>
     * </p>
     * 
     * @return Settlement Unit of Volume in ISO Code
     */
    @Nullable
    @ElementName( "CndnContrVolumeUnitISOCode" )
    private java.lang.String cndnContrVolumeUnitISOCode;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_VOLUME_UNIT_ISO_CODE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrVolumeUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrVolumeUnitSAPCode</b>
     * </p>
     * 
     * @return Settlement Unit of Volume in SAP Code
     */
    @Nullable
    @ElementName( "CndnContrVolumeUnitSAPCode" )
    private java.lang.String cndnContrVolumeUnitSAPCode;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_VOLUME_UNIT_SAP_CODE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrVolumeUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPointsQtyUnit</b>
     * </p>
     * 
     * @return Settlement Points Unit
     */
    @Nullable
    @ElementName( "CndnContrPointsQtyUnit" )
    private java.lang.String cndnContrPointsQtyUnit;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_POINTS_QTY_UNIT =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrPointsQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPointsQtyUnitISOCode</b>
     * </p>
     * 
     * @return Settlement Points Unit in ISO Code
     */
    @Nullable
    @ElementName( "CndnContrPointsQtyUnitISOCode" )
    private java.lang.String cndnContrPointsQtyUnitISOCode;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_POINTS_QTY_UNIT_ISO_CODE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrPointsQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPointsQtyUnitSAPCode</b>
     * </p>
     * 
     * @return Settlement Points Unit in SAP Code
     */
    @Nullable
    @ElementName( "CndnContrPointsQtyUnitSAPCode" )
    private java.lang.String cndnContrPointsQtyUnitSAPCode;
    public final static SimpleProperty.String<ConditionContract> CNDN_CONTR_POINTS_QTY_UNIT_SAP_CODE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "CndnContrPointsQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     * 
     * @return Exchange Rate (no Conversion)
     */
    @Nullable
    @ElementName( "ExchangeRate" )
    @DecimalDescriptor( precision = 9, scale = 5 )
    private BigDecimal exchangeRate;
    public final static SimpleProperty.NumericDecimal<ConditionContract> EXCHANGE_RATE =
        new SimpleProperty.NumericDecimal<ConditionContract>(ConditionContract.class, "ExchangeRate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     * 
     * @return Conversion Date
     */
    @Nullable
    @ElementName( "ExchangeRateDate" )
    private LocalDate exchangeRateDate;
    public final static SimpleProperty.Date<ConditionContract> EXCHANGE_RATE_DATE =
        new SimpleProperty.Date<ConditionContract>(ConditionContract.class, "ExchangeRateDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateType</b>
     * </p>
     * 
     * @return Exchange Rate Type
     */
    @Nullable
    @ElementName( "ExchangeRateType" )
    private java.lang.String exchangeRateType;
    public final static SimpleProperty.String<ConditionContract> EXCHANGE_RATE_TYPE =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "ExchangeRateType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     * 
     * @return Terms of Payment Key
     */
    @Nullable
    @ElementName( "PaymentTerms" )
    private java.lang.String paymentTerms;
    public final static SimpleProperty.String<ConditionContract> PAYMENT_TERMS =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     * 
     * @return First Payment in Days
     */
    @Nullable
    @ElementName( "CashDiscount1Days" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal cashDiscount1Days;
    public final static SimpleProperty.NumericDecimal<ConditionContract> CASH_DISCOUNT1_DAYS =
        new SimpleProperty.NumericDecimal<ConditionContract>(ConditionContract.class, "CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     * 
     * @return Discount for First Payment in %
     */
    @Nullable
    @ElementName( "CashDiscount1Percent" )
    @DecimalDescriptor( precision = 5, scale = 3 )
    private BigDecimal cashDiscount1Percent;
    public final static SimpleProperty.NumericDecimal<ConditionContract> CASH_DISCOUNT1_PERCENT =
        new SimpleProperty.NumericDecimal<ConditionContract>(ConditionContract.class, "CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     * 
     * @return Second Payment in Days
     */
    @Nullable
    @ElementName( "CashDiscount2Days" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal cashDiscount2Days;
    public final static SimpleProperty.NumericDecimal<ConditionContract> CASH_DISCOUNT2_DAYS =
        new SimpleProperty.NumericDecimal<ConditionContract>(ConditionContract.class, "CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     * 
     * @return Discount for Second Payment in %
     */
    @Nullable
    @ElementName( "CashDiscount2Percent" )
    @DecimalDescriptor( precision = 5, scale = 3 )
    private BigDecimal cashDiscount2Percent;
    public final static SimpleProperty.NumericDecimal<ConditionContract> CASH_DISCOUNT2_PERCENT =
        new SimpleProperty.NumericDecimal<ConditionContract>(ConditionContract.class, "CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     * 
     * @return Cash Discount Days
     */
    @Nullable
    @ElementName( "NetPaymentDays" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal netPaymentDays;
    public final static SimpleProperty.NumericDecimal<ConditionContract> NET_PAYMENT_DAYS =
        new SimpleProperty.NumericDecimal<ConditionContract>(ConditionContract.class, "NetPaymentDays");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     * 
     * @return Payment Method
     */
    @Nullable
    @ElementName( "PaymentMethod" )
    private java.lang.String paymentMethod;
    public final static SimpleProperty.String<ConditionContract> PAYMENT_METHOD =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "PaymentMethod");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AccrualUpdateIsRequired</b>
     * </p>
     * 
     * @return Accruals Update Required
     */
    @Nullable
    @ElementName( "AccrualUpdateIsRequired" )
    private java.lang.Boolean accrualUpdateIsRequired;
    public final static SimpleProperty.Boolean<ConditionContract> ACCRUAL_UPDATE_IS_REQUIRED =
        new SimpleProperty.Boolean<ConditionContract>(ConditionContract.class, "AccrualUpdateIsRequired");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPartTxRegnNmbr</b>
     * </p>
     * 
     * @return VAT Registration Number
     */
    @Nullable
    @ElementName( "SettlmtPartTxRegnNmbr" )
    private java.lang.String settlmtPartTxRegnNmbr;
    public final static SimpleProperty.String<ConditionContract> SETTLMT_PART_TX_REGN_NMBR =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "SettlmtPartTxRegnNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     * 
     * @return Tax Reporting Country/Region
     */
    @Nullable
    @ElementName( "TaxCountry" )
    private java.lang.String taxCountry;
    public final static SimpleProperty.String<ConditionContract> TAX_COUNTRY =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "TaxCountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPartTxRegnCntry</b>
     * </p>
     * 
     * @return Partner Tax Country/Region
     */
    @Nullable
    @ElementName( "SettlmtPartTxRegnCntry" )
    private java.lang.String settlmtPartTxRegnCntry;
    public final static SimpleProperty.String<ConditionContract> SETTLMT_PART_TX_REGN_CNTRY =
        new SimpleProperty.String<ConditionContract>(ConditionContract.class, "SettlmtPartTxRegnCntry");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<ConditionContract, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<ConditionContract, SAP__Message>(
            ConditionContract.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_CndnContrActiveStatus</b> for <b>ConditionContract</b> to multiple
     * <b>ConditionContractStatus</b>.
     * 
     */
    @ElementName( "_CndnContrActiveStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ConditionContractStatus> to_CndnContrActiveStatus;
    /**
     * Navigation property <b>_CndnContrBusVolSelCriteria</b> for <b>ConditionContract</b> to multiple
     * <b>BusVolSelectionCriteria</b>.
     * 
     */
    @ElementName( "_CndnContrBusVolSelCriteria" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusVolSelectionCriteria> to_CndnContrBusVolSelCriteria;
    /**
     * Navigation property <b>_CndnContrCndnRecord</b> for <b>ConditionContract</b> to multiple
     * <b>CndnContrConditionRecord</b>.
     * 
     */
    @ElementName( "_CndnContrCndnRecord" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CndnContrConditionRecord> to_CndnContrCndnRecord;
    /**
     * Navigation property <b>_CndnContrSettlmtCal</b> for <b>ConditionContract</b> to multiple
     * <b>CndnContrSettlementCalendar</b>.
     * 
     */
    @ElementName( "_CndnContrSettlmtCal" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CndnContrSettlementCalendar> to_CndnContrSettlmtCal;
    /**
     * Use with available request builders to apply the <b>_CndnContrActiveStatus</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ConditionContract, ConditionContractStatus> TO__CNDN_CONTR_ACTIVE_STATUS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ConditionContract, ConditionContractStatus>(
            ConditionContract.class,
            "_CndnContrActiveStatus",
            ConditionContractStatus.class);
    /**
     * Use with available request builders to apply the <b>_CndnContrBusVolSelCriteria</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ConditionContract, BusVolSelectionCriteria> TO__CNDN_CONTR_BUS_VOL_SEL_CRITERIA =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ConditionContract, BusVolSelectionCriteria>(
            ConditionContract.class,
            "_CndnContrBusVolSelCriteria",
            BusVolSelectionCriteria.class);
    /**
     * Use with available request builders to apply the <b>_CndnContrCndnRecord</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ConditionContract, CndnContrConditionRecord> TO__CNDN_CONTR_CNDN_RECORD =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ConditionContract, CndnContrConditionRecord>(
            ConditionContract.class,
            "_CndnContrCndnRecord",
            CndnContrConditionRecord.class);
    /**
     * Use with available request builders to apply the <b>_CndnContrSettlmtCal</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ConditionContract, CndnContrSettlementCalendar> TO__CNDN_CONTR_SETTLMT_CAL =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ConditionContract, CndnContrSettlementCalendar>(
            ConditionContract.class,
            "_CndnContrSettlmtCal",
            CndnContrSettlementCalendar.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ConditionContract> getType()
    {
        return ConditionContract.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @param conditionContract
     *            Condition Record
     */
    public void setConditionContract( @Nullable final java.lang.String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrType</b>
     * </p>
     * 
     * @param cndnContrType
     *            Condition Contract Type
     */
    public void setCndnContrType( @Nullable final java.lang.String cndnContrType )
    {
        rememberChangedField("CndnContrType", this.cndnContrType);
        this.cndnContrType = cndnContrType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrProcVar</b>
     * </p>
     * 
     * @param cndnContrProcVar
     *            Condition Contract Process Variant
     */
    public void setCndnContrProcVar( @Nullable final java.lang.String cndnContrProcVar )
    {
        rememberChangedField("CndnContrProcVar", this.cndnContrProcVar);
        this.cndnContrProcVar = cndnContrProcVar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @param supplier
     *            Supplier as Partner of a Condition Contract
     */
    public void setSupplier( @Nullable final java.lang.String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     * 
     * @param customer
     *            Customer as Partner of a Condition Contract
     */
    public void setCustomer( @Nullable final java.lang.String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrActvtnStatus</b>
     * </p>
     * 
     * @param cndnContrActvtnStatus
     *            Condition Contract Activation Status
     */
    public void setCndnContrActvtnStatus( @Nullable final java.lang.String cndnContrActvtnStatus )
    {
        rememberChangedField("CndnContrActvtnStatus", this.cndnContrActvtnStatus);
        this.cndnContrActvtnStatus = cndnContrActvtnStatus;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrValidFrom</b>
     * </p>
     * 
     * @param cndnContrValidFrom
     *            Valid From
     */
    public void setCndnContrValidFrom( @Nullable final LocalDate cndnContrValidFrom )
    {
        rememberChangedField("CndnContrValidFrom", this.cndnContrValidFrom);
        this.cndnContrValidFrom = cndnContrValidFrom;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrValidTo</b>
     * </p>
     * 
     * @param cndnContrValidTo
     *            Valid To
     */
    public void setCndnContrValidTo( @Nullable final LocalDate cndnContrValidTo )
    {
        rememberChangedField("CndnContrValidTo", this.cndnContrValidTo);
        this.cndnContrValidTo = cndnContrValidTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrClassfctnType</b>
     * </p>
     * 
     * @param cndnContrClassfctnType
     *            Condition Contract Category
     */
    public void setCndnContrClassfctnType( @Nullable final java.lang.String cndnContrClassfctnType )
    {
        rememberChangedField("CndnContrClassfctnType", this.cndnContrClassfctnType);
        this.cndnContrClassfctnType = cndnContrClassfctnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     * 
     * @param documentReferenceID
     *            Condition Contract: Reference
     */
    public void setDocumentReferenceID( @Nullable final java.lang.String documentReferenceID )
    {
        rememberChangedField("DocumentReferenceID", this.documentReferenceID);
        this.documentReferenceID = documentReferenceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrAssgmtRef</b>
     * </p>
     * 
     * @param cndnContrAssgmtRef
     *            Condition Contract: Assignment
     */
    public void setCndnContrAssgmtRef( @Nullable final java.lang.String cndnContrAssgmtRef )
    {
        rememberChangedField("CndnContrAssgmtRef", this.cndnContrAssgmtRef);
        this.cndnContrAssgmtRef = cndnContrAssgmtRef;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocumentReferenceID</b>
     * </p>
     * 
     * @param externalDocumentReferenceID
     *            External Document Identifier
     */
    public void setExternalDocumentReferenceID( @Nullable final java.lang.String externalDocumentReferenceID )
    {
        rememberChangedField("ExternalDocumentReferenceID", this.externalDocumentReferenceID);
        this.externalDocumentReferenceID = externalDocumentReferenceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrExternalPartner</b>
     * </p>
     * 
     * @param cndnContrExternalPartner
     *            Condition Contract: External Partner
     */
    public void setCndnContrExternalPartner( @Nullable final java.lang.String cndnContrExternalPartner )
    {
        rememberChangedField("CndnContrExternalPartner", this.cndnContrExternalPartner);
        this.cndnContrExternalPartner = cndnContrExternalPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceDocCat</b>
     * </p>
     * 
     * @param cndnContrSourceDocCat
     *            External Reference Document Category
     */
    public void setCndnContrSourceDocCat( @Nullable final java.lang.String cndnContrSourceDocCat )
    {
        rememberChangedField("CndnContrSourceDocCat", this.cndnContrSourceDocCat);
        this.cndnContrSourceDocCat = cndnContrSourceDocCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceDoc</b>
     * </p>
     * 
     * @param cndnContrSourceDoc
     *            External Reference
     */
    public void setCndnContrSourceDoc( @Nullable final java.lang.String cndnContrSourceDoc )
    {
        rememberChangedField("CndnContrSourceDoc", this.cndnContrSourceDoc);
        this.cndnContrSourceDoc = cndnContrSourceDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceDocItem</b>
     * </p>
     * 
     * @param cndnContrSourceDocItem
     *            External Reference Item
     */
    public void setCndnContrSourceDocItem( @Nullable final java.lang.String cndnContrSourceDocItem )
    {
        rememberChangedField("CndnContrSourceDocItem", this.cndnContrSourceDocItem);
        this.cndnContrSourceDocItem = cndnContrSourceDocItem;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceUUID</b>
     * </p>
     * 
     * @param cndnContrSourceUUID
     *            External Condition Contract GUID
     */
    public void setCndnContrSourceUUID( @Nullable final UUID cndnContrSourceUUID )
    {
        rememberChangedField("CndnContrSourceUUID", this.cndnContrSourceUUID);
        this.cndnContrSourceUUID = cndnContrSourceUUID;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationUTCDateTime</b>
     * </p>
     * 
     * @param creationUTCDateTime
     *            UTC Time Stamp of Condition Contract Creation
     */
    public void setCreationUTCDateTime( @Nullable final OffsetDateTime creationUTCDateTime )
    {
        rememberChangedField("CreationUTCDateTime", this.creationUTCDateTime);
        this.creationUTCDateTime = creationUTCDateTime;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeUTCDateTime</b>
     * </p>
     * 
     * @param lastChangeUTCDateTime
     *            UTC Time Stamp of Last Condition Contract Change
     */
    public void setLastChangeUTCDateTime( @Nullable final OffsetDateTime lastChangeUTCDateTime )
    {
        rememberChangedField("LastChangeUTCDateTime", this.lastChangeUTCDateTime);
        this.lastChangeUTCDateTime = lastChangeUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final java.lang.String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     * 
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final java.lang.String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     * 
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final java.lang.String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     * 
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final java.lang.String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final java.lang.String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     * 
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final java.lang.String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     * 
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final java.lang.String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSuplrSettlmtCat</b>
     * </p>
     * 
     * @param cndnContrSuplrSettlmtCat
     *            Settlement Type Supplier
     */
    public void setCndnContrSuplrSettlmtCat( @Nullable final java.lang.String cndnContrSuplrSettlmtCat )
    {
        rememberChangedField("CndnContrSuplrSettlmtCat", this.cndnContrSuplrSettlmtCat);
        this.cndnContrSuplrSettlmtCat = cndnContrSuplrSettlmtCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrCustSettlmtCat</b>
     * </p>
     * 
     * @param cndnContrCustSettlmtCat
     *            Settlement Type Customer
     */
    public void setCndnContrCustSettlmtCat( @Nullable final java.lang.String cndnContrCustSettlmtCat )
    {
        rememberChangedField("CndnContrCustSettlmtCat", this.cndnContrCustSettlmtCat);
        this.cndnContrCustSettlmtCat = cndnContrCustSettlmtCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProduct</b>
     * </p>
     * 
     * @param settlmtProduct
     *            Settlement Product
     */
    public void setSettlmtProduct( @Nullable final java.lang.String settlmtProduct )
    {
        rememberChangedField("SettlmtProduct", this.settlmtProduct);
        this.settlmtProduct = settlmtProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrExtensionCalendar</b>
     * </p>
     * 
     * @param cndnContrExtensionCalendar
     *            Calendar for Condition Contract Extension
     */
    public void setCndnContrExtensionCalendar( @Nullable final java.lang.String cndnContrExtensionCalendar )
    {
        rememberChangedField("CndnContrExtensionCalendar", this.cndnContrExtensionCalendar);
        this.cndnContrExtensionCalendar = cndnContrExtensionCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PriorSupplier</b>
     * </p>
     * 
     * @param priorSupplier
     *            Prior Supplier
     */
    public void setPriorSupplier( @Nullable final java.lang.String priorSupplier )
    {
        rememberChangedField("PriorSupplier", this.priorSupplier);
        this.priorSupplier = priorSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolTableGroup</b>
     * </p>
     * 
     * @param busVolTableGroup
     *            Business Volume Table Group
     */
    public void setBusVolTableGroup( @Nullable final java.lang.String busVolTableGroup )
    {
        rememberChangedField("BusVolTableGroup", this.busVolTableGroup);
        this.busVolTableGroup = busVolTableGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AmountFieldGroup</b>
     * </p>
     * 
     * @param amountFieldGroup
     *            Amount Fields Group
     */
    public void setAmountFieldGroup( @Nullable final java.lang.String amountFieldGroup )
    {
        rememberChangedField("AmountFieldGroup", this.amountFieldGroup);
        this.amountFieldGroup = amountFieldGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FinalSettlmtCalendar</b>
     * </p>
     * 
     * @param finalSettlmtCalendar
     *            Calendar for Final Settlement
     */
    public void setFinalSettlmtCalendar( @Nullable final java.lang.String finalSettlmtCalendar )
    {
        rememberChangedField("FinalSettlmtCalendar", this.finalSettlmtCalendar);
        this.finalSettlmtCalendar = finalSettlmtCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartialSettlmtCalendar</b>
     * </p>
     * 
     * @param partialSettlmtCalendar
     *            Calendar for Partial Settlement
     */
    public void setPartialSettlmtCalendar( @Nullable final java.lang.String partialSettlmtCalendar )
    {
        rememberChangedField("PartialSettlmtCalendar", this.partialSettlmtCalendar);
        this.partialSettlmtCalendar = partialSettlmtCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeltaSettlmtCalendar</b>
     * </p>
     * 
     * @param deltaSettlmtCalendar
     *            Calendar for Delta Settlement
     */
    public void setDeltaSettlmtCalendar( @Nullable final java.lang.String deltaSettlmtCalendar )
    {
        rememberChangedField("DeltaSettlmtCalendar", this.deltaSettlmtCalendar);
        this.deltaSettlmtCalendar = deltaSettlmtCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeltaAccrualSettlmtCalendar</b>
     * </p>
     * 
     * @param deltaAccrualSettlmtCalendar
     *            Calendar for Delta Accruals Settlement
     */
    public void setDeltaAccrualSettlmtCalendar( @Nullable final java.lang.String deltaAccrualSettlmtCalendar )
    {
        rememberChangedField("DeltaAccrualSettlmtCalendar", this.deltaAccrualSettlmtCalendar);
        this.deltaAccrualSettlmtCalendar = deltaAccrualSettlmtCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccrualClearingSettlmtCalendar</b>
     * </p>
     * 
     * @param accrualClearingSettlmtCalendar
     *            Calendar for Accruals Deferral Settlement
     */
    public void setAccrualClearingSettlmtCalendar( @Nullable final java.lang.String accrualClearingSettlmtCalendar )
    {
        rememberChangedField("AccrualClearingSettlmtCalendar", this.accrualClearingSettlmtCalendar);
        this.accrualClearingSettlmtCalendar = accrualClearingSettlmtCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingConditionContract</b>
     * </p>
     * 
     * @param precedingConditionContract
     *            Predecessor Condition Contract
     */
    public void setPrecedingConditionContract( @Nullable final java.lang.String precedingConditionContract )
    {
        rememberChangedField("PrecedingConditionContract", this.precedingConditionContract);
        this.precedingConditionContract = precedingConditionContract;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrUUID</b>
     * </p>
     * 
     * @param cndnContrUUID
     *            Condition Contract GUID
     */
    public void setCndnContrUUID( @Nullable final UUID cndnContrUUID )
    {
        rememberChangedField("CndnContrUUID", this.cndnContrUUID);
        this.cndnContrUUID = cndnContrUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPurposeCat</b>
     * </p>
     * 
     * @param cndnContrPurposeCat
     *            Condition Contract Purpose
     */
    public void setCndnContrPurposeCat( @Nullable final java.lang.String cndnContrPurposeCat )
    {
        rememberChangedField("CndnContrPurposeCat", this.cndnContrPurposeCat);
        this.cndnContrPurposeCat = cndnContrPurposeCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrCurrency</b>
     * </p>
     * 
     * @param cndnContrCurrency
     *            Currency of Condition Contract
     */
    public void setCndnContrCurrency( @Nullable final java.lang.String cndnContrCurrency )
    {
        rememberChangedField("CndnContrCurrency", this.cndnContrCurrency);
        this.cndnContrCurrency = cndnContrCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrUnit</b>
     * </p>
     * 
     * @param cndnContrUnit
     *            Settlement Unit of Measure
     */
    public void setCndnContrUnit( @Nullable final java.lang.String cndnContrUnit )
    {
        rememberChangedField("CndnContrUnit", this.cndnContrUnit);
        this.cndnContrUnit = cndnContrUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrUnitISOCode</b>
     * </p>
     * 
     * @param cndnContrUnitISOCode
     *            Settlement Unit of Measure in ISO Code
     */
    public void setCndnContrUnitISOCode( @Nullable final java.lang.String cndnContrUnitISOCode )
    {
        rememberChangedField("CndnContrUnitISOCode", this.cndnContrUnitISOCode);
        this.cndnContrUnitISOCode = cndnContrUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrUnitSAPCode</b>
     * </p>
     * 
     * @param cndnContrUnitSAPCode
     *            Settlement Unit of Measure in SAP Code
     */
    public void setCndnContrUnitSAPCode( @Nullable final java.lang.String cndnContrUnitSAPCode )
    {
        rememberChangedField("CndnContrUnitSAPCode", this.cndnContrUnitSAPCode);
        this.cndnContrUnitSAPCode = cndnContrUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrWeightUnit</b>
     * </p>
     * 
     * @param cndnContrWeightUnit
     *            Settlement Unit of Weight
     */
    public void setCndnContrWeightUnit( @Nullable final java.lang.String cndnContrWeightUnit )
    {
        rememberChangedField("CndnContrWeightUnit", this.cndnContrWeightUnit);
        this.cndnContrWeightUnit = cndnContrWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrWeightUnitISOCode</b>
     * </p>
     * 
     * @param cndnContrWeightUnitISOCode
     *            Settlement Unit of Weight in ISO Code
     */
    public void setCndnContrWeightUnitISOCode( @Nullable final java.lang.String cndnContrWeightUnitISOCode )
    {
        rememberChangedField("CndnContrWeightUnitISOCode", this.cndnContrWeightUnitISOCode);
        this.cndnContrWeightUnitISOCode = cndnContrWeightUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrWeightUnitSAPCode</b>
     * </p>
     * 
     * @param cndnContrWeightUnitSAPCode
     *            Settlement Unit of Weight in SAP Code
     */
    public void setCndnContrWeightUnitSAPCode( @Nullable final java.lang.String cndnContrWeightUnitSAPCode )
    {
        rememberChangedField("CndnContrWeightUnitSAPCode", this.cndnContrWeightUnitSAPCode);
        this.cndnContrWeightUnitSAPCode = cndnContrWeightUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrVolumeUnit</b>
     * </p>
     * 
     * @param cndnContrVolumeUnit
     *            Settlement Unit of Volume
     */
    public void setCndnContrVolumeUnit( @Nullable final java.lang.String cndnContrVolumeUnit )
    {
        rememberChangedField("CndnContrVolumeUnit", this.cndnContrVolumeUnit);
        this.cndnContrVolumeUnit = cndnContrVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrVolumeUnitISOCode</b>
     * </p>
     * 
     * @param cndnContrVolumeUnitISOCode
     *            Settlement Unit of Volume in ISO Code
     */
    public void setCndnContrVolumeUnitISOCode( @Nullable final java.lang.String cndnContrVolumeUnitISOCode )
    {
        rememberChangedField("CndnContrVolumeUnitISOCode", this.cndnContrVolumeUnitISOCode);
        this.cndnContrVolumeUnitISOCode = cndnContrVolumeUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrVolumeUnitSAPCode</b>
     * </p>
     * 
     * @param cndnContrVolumeUnitSAPCode
     *            Settlement Unit of Volume in SAP Code
     */
    public void setCndnContrVolumeUnitSAPCode( @Nullable final java.lang.String cndnContrVolumeUnitSAPCode )
    {
        rememberChangedField("CndnContrVolumeUnitSAPCode", this.cndnContrVolumeUnitSAPCode);
        this.cndnContrVolumeUnitSAPCode = cndnContrVolumeUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPointsQtyUnit</b>
     * </p>
     * 
     * @param cndnContrPointsQtyUnit
     *            Settlement Points Unit
     */
    public void setCndnContrPointsQtyUnit( @Nullable final java.lang.String cndnContrPointsQtyUnit )
    {
        rememberChangedField("CndnContrPointsQtyUnit", this.cndnContrPointsQtyUnit);
        this.cndnContrPointsQtyUnit = cndnContrPointsQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPointsQtyUnitISOCode</b>
     * </p>
     * 
     * @param cndnContrPointsQtyUnitISOCode
     *            Settlement Points Unit in ISO Code
     */
    public void setCndnContrPointsQtyUnitISOCode( @Nullable final java.lang.String cndnContrPointsQtyUnitISOCode )
    {
        rememberChangedField("CndnContrPointsQtyUnitISOCode", this.cndnContrPointsQtyUnitISOCode);
        this.cndnContrPointsQtyUnitISOCode = cndnContrPointsQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrPointsQtyUnitSAPCode</b>
     * </p>
     * 
     * @param cndnContrPointsQtyUnitSAPCode
     *            Settlement Points Unit in SAP Code
     */
    public void setCndnContrPointsQtyUnitSAPCode( @Nullable final java.lang.String cndnContrPointsQtyUnitSAPCode )
    {
        rememberChangedField("CndnContrPointsQtyUnitSAPCode", this.cndnContrPointsQtyUnitSAPCode);
        this.cndnContrPointsQtyUnitSAPCode = cndnContrPointsQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     * 
     * @param exchangeRate
     *            Exchange Rate (no Conversion)
     */
    public void setExchangeRate( @Nullable final BigDecimal exchangeRate )
    {
        rememberChangedField("ExchangeRate", this.exchangeRate);
        this.exchangeRate = exchangeRate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     * 
     * @param exchangeRateDate
     *            Conversion Date
     */
    public void setExchangeRateDate( @Nullable final LocalDate exchangeRateDate )
    {
        rememberChangedField("ExchangeRateDate", this.exchangeRateDate);
        this.exchangeRateDate = exchangeRateDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateType</b>
     * </p>
     * 
     * @param exchangeRateType
     *            Exchange Rate Type
     */
    public void setExchangeRateType( @Nullable final java.lang.String exchangeRateType )
    {
        rememberChangedField("ExchangeRateType", this.exchangeRateType);
        this.exchangeRateType = exchangeRateType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     * 
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final java.lang.String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     * 
     * @param cashDiscount1Days
     *            First Payment in Days
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     * 
     * @param cashDiscount1Percent
     *            Discount for First Payment in %
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     * 
     * @param cashDiscount2Days
     *            Second Payment in Days
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     * 
     * @param cashDiscount2Percent
     *            Discount for Second Payment in %
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     * 
     * @param netPaymentDays
     *            Cash Discount Days
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     * 
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final java.lang.String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AccrualUpdateIsRequired</b>
     * </p>
     * 
     * @param accrualUpdateIsRequired
     *            Accruals Update Required
     */
    public void setAccrualUpdateIsRequired( @Nullable final java.lang.Boolean accrualUpdateIsRequired )
    {
        rememberChangedField("AccrualUpdateIsRequired", this.accrualUpdateIsRequired);
        this.accrualUpdateIsRequired = accrualUpdateIsRequired;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPartTxRegnNmbr</b>
     * </p>
     * 
     * @param settlmtPartTxRegnNmbr
     *            VAT Registration Number
     */
    public void setSettlmtPartTxRegnNmbr( @Nullable final java.lang.String settlmtPartTxRegnNmbr )
    {
        rememberChangedField("SettlmtPartTxRegnNmbr", this.settlmtPartTxRegnNmbr);
        this.settlmtPartTxRegnNmbr = settlmtPartTxRegnNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     * 
     * @param taxCountry
     *            Tax Reporting Country/Region
     */
    public void setTaxCountry( @Nullable final java.lang.String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPartTxRegnCntry</b>
     * </p>
     * 
     * @param settlmtPartTxRegnCntry
     *            Partner Tax Country/Region
     */
    public void setSettlmtPartTxRegnCntry( @Nullable final java.lang.String settlmtPartTxRegnCntry )
    {
        rememberChangedField("SettlmtPartTxRegnCntry", this.settlmtPartTxRegnCntry);
        this.settlmtPartTxRegnCntry = settlmtPartTxRegnCntry;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ConditionContract";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionContract", getConditionContract());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionContract", getConditionContract());
        values.put("CndnContrType", getCndnContrType());
        values.put("CndnContrProcVar", getCndnContrProcVar());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("CndnContrActvtnStatus", getCndnContrActvtnStatus());
        values.put("CndnContrValidFrom", getCndnContrValidFrom());
        values.put("CndnContrValidTo", getCndnContrValidTo());
        values.put("CndnContrClassfctnType", getCndnContrClassfctnType());
        values.put("DocumentReferenceID", getDocumentReferenceID());
        values.put("CndnContrAssgmtRef", getCndnContrAssgmtRef());
        values.put("ExternalDocumentReferenceID", getExternalDocumentReferenceID());
        values.put("CndnContrExternalPartner", getCndnContrExternalPartner());
        values.put("CndnContrSourceDocCat", getCndnContrSourceDocCat());
        values.put("CndnContrSourceDoc", getCndnContrSourceDoc());
        values.put("CndnContrSourceDocItem", getCndnContrSourceDocItem());
        values.put("CndnContrSourceUUID", getCndnContrSourceUUID());
        values.put("CreationUTCDateTime", getCreationUTCDateTime());
        values.put("LastChangeUTCDateTime", getLastChangeUTCDateTime());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SalesGroup", getSalesGroup());
        values.put("SalesOffice", getSalesOffice());
        values.put("CndnContrSuplrSettlmtCat", getCndnContrSuplrSettlmtCat());
        values.put("CndnContrCustSettlmtCat", getCndnContrCustSettlmtCat());
        values.put("SettlmtProduct", getSettlmtProduct());
        values.put("CndnContrExtensionCalendar", getCndnContrExtensionCalendar());
        values.put("PriorSupplier", getPriorSupplier());
        values.put("BusVolTableGroup", getBusVolTableGroup());
        values.put("AmountFieldGroup", getAmountFieldGroup());
        values.put("FinalSettlmtCalendar", getFinalSettlmtCalendar());
        values.put("PartialSettlmtCalendar", getPartialSettlmtCalendar());
        values.put("DeltaSettlmtCalendar", getDeltaSettlmtCalendar());
        values.put("DeltaAccrualSettlmtCalendar", getDeltaAccrualSettlmtCalendar());
        values.put("AccrualClearingSettlmtCalendar", getAccrualClearingSettlmtCalendar());
        values.put("PrecedingConditionContract", getPrecedingConditionContract());
        values.put("CndnContrUUID", getCndnContrUUID());
        values.put("CndnContrPurposeCat", getCndnContrPurposeCat());
        values.put("CndnContrCurrency", getCndnContrCurrency());
        values.put("CndnContrUnit", getCndnContrUnit());
        values.put("CndnContrUnitISOCode", getCndnContrUnitISOCode());
        values.put("CndnContrUnitSAPCode", getCndnContrUnitSAPCode());
        values.put("CndnContrWeightUnit", getCndnContrWeightUnit());
        values.put("CndnContrWeightUnitISOCode", getCndnContrWeightUnitISOCode());
        values.put("CndnContrWeightUnitSAPCode", getCndnContrWeightUnitSAPCode());
        values.put("CndnContrVolumeUnit", getCndnContrVolumeUnit());
        values.put("CndnContrVolumeUnitISOCode", getCndnContrVolumeUnitISOCode());
        values.put("CndnContrVolumeUnitSAPCode", getCndnContrVolumeUnitSAPCode());
        values.put("CndnContrPointsQtyUnit", getCndnContrPointsQtyUnit());
        values.put("CndnContrPointsQtyUnitISOCode", getCndnContrPointsQtyUnitISOCode());
        values.put("CndnContrPointsQtyUnitSAPCode", getCndnContrPointsQtyUnitSAPCode());
        values.put("ExchangeRate", getExchangeRate());
        values.put("ExchangeRateDate", getExchangeRateDate());
        values.put("ExchangeRateType", getExchangeRateType());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("AccrualUpdateIsRequired", getAccrualUpdateIsRequired());
        values.put("SettlmtPartTxRegnNmbr", getSettlmtPartTxRegnNmbr());
        values.put("TaxCountry", getTaxCountry());
        values.put("SettlmtPartTxRegnCntry", getSettlmtPartTxRegnCntry());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrType") ) {
                final Object value = values.remove("CndnContrType");
                if( (value == null) || (!value.equals(getCndnContrType())) ) {
                    setCndnContrType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrProcVar") ) {
                final Object value = values.remove("CndnContrProcVar");
                if( (value == null) || (!value.equals(getCndnContrProcVar())) ) {
                    setCndnContrProcVar(((java.lang.String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrActvtnStatus") ) {
                final Object value = values.remove("CndnContrActvtnStatus");
                if( (value == null) || (!value.equals(getCndnContrActvtnStatus())) ) {
                    setCndnContrActvtnStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrValidFrom") ) {
                final Object value = values.remove("CndnContrValidFrom");
                if( (value == null) || (!value.equals(getCndnContrValidFrom())) ) {
                    setCndnContrValidFrom(((LocalDate) value));
                }
            }
            if( values.containsKey("CndnContrValidTo") ) {
                final Object value = values.remove("CndnContrValidTo");
                if( (value == null) || (!value.equals(getCndnContrValidTo())) ) {
                    setCndnContrValidTo(((LocalDate) value));
                }
            }
            if( values.containsKey("CndnContrClassfctnType") ) {
                final Object value = values.remove("CndnContrClassfctnType");
                if( (value == null) || (!value.equals(getCndnContrClassfctnType())) ) {
                    setCndnContrClassfctnType(((java.lang.String) value));
                }
            }
            if( values.containsKey("DocumentReferenceID") ) {
                final Object value = values.remove("DocumentReferenceID");
                if( (value == null) || (!value.equals(getDocumentReferenceID())) ) {
                    setDocumentReferenceID(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrAssgmtRef") ) {
                final Object value = values.remove("CndnContrAssgmtRef");
                if( (value == null) || (!value.equals(getCndnContrAssgmtRef())) ) {
                    setCndnContrAssgmtRef(((java.lang.String) value));
                }
            }
            if( values.containsKey("ExternalDocumentReferenceID") ) {
                final Object value = values.remove("ExternalDocumentReferenceID");
                if( (value == null) || (!value.equals(getExternalDocumentReferenceID())) ) {
                    setExternalDocumentReferenceID(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrExternalPartner") ) {
                final Object value = values.remove("CndnContrExternalPartner");
                if( (value == null) || (!value.equals(getCndnContrExternalPartner())) ) {
                    setCndnContrExternalPartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrSourceDocCat") ) {
                final Object value = values.remove("CndnContrSourceDocCat");
                if( (value == null) || (!value.equals(getCndnContrSourceDocCat())) ) {
                    setCndnContrSourceDocCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrSourceDoc") ) {
                final Object value = values.remove("CndnContrSourceDoc");
                if( (value == null) || (!value.equals(getCndnContrSourceDoc())) ) {
                    setCndnContrSourceDoc(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrSourceDocItem") ) {
                final Object value = values.remove("CndnContrSourceDocItem");
                if( (value == null) || (!value.equals(getCndnContrSourceDocItem())) ) {
                    setCndnContrSourceDocItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrSourceUUID") ) {
                final Object value = values.remove("CndnContrSourceUUID");
                if( (value == null) || (!value.equals(getCndnContrSourceUUID())) ) {
                    setCndnContrSourceUUID(((UUID) value));
                }
            }
            if( values.containsKey("CreationUTCDateTime") ) {
                final Object value = values.remove("CreationUTCDateTime");
                if( (value == null) || (!value.equals(getCreationUTCDateTime())) ) {
                    setCreationUTCDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("LastChangeUTCDateTime") ) {
                final Object value = values.remove("LastChangeUTCDateTime");
                if( (value == null) || (!value.equals(getLastChangeUTCDateTime())) ) {
                    setLastChangeUTCDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((java.lang.String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrSuplrSettlmtCat") ) {
                final Object value = values.remove("CndnContrSuplrSettlmtCat");
                if( (value == null) || (!value.equals(getCndnContrSuplrSettlmtCat())) ) {
                    setCndnContrSuplrSettlmtCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrCustSettlmtCat") ) {
                final Object value = values.remove("CndnContrCustSettlmtCat");
                if( (value == null) || (!value.equals(getCndnContrCustSettlmtCat())) ) {
                    setCndnContrCustSettlmtCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtProduct") ) {
                final Object value = values.remove("SettlmtProduct");
                if( (value == null) || (!value.equals(getSettlmtProduct())) ) {
                    setSettlmtProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrExtensionCalendar") ) {
                final Object value = values.remove("CndnContrExtensionCalendar");
                if( (value == null) || (!value.equals(getCndnContrExtensionCalendar())) ) {
                    setCndnContrExtensionCalendar(((java.lang.String) value));
                }
            }
            if( values.containsKey("PriorSupplier") ) {
                final Object value = values.remove("PriorSupplier");
                if( (value == null) || (!value.equals(getPriorSupplier())) ) {
                    setPriorSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusVolTableGroup") ) {
                final Object value = values.remove("BusVolTableGroup");
                if( (value == null) || (!value.equals(getBusVolTableGroup())) ) {
                    setBusVolTableGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("AmountFieldGroup") ) {
                final Object value = values.remove("AmountFieldGroup");
                if( (value == null) || (!value.equals(getAmountFieldGroup())) ) {
                    setAmountFieldGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("FinalSettlmtCalendar") ) {
                final Object value = values.remove("FinalSettlmtCalendar");
                if( (value == null) || (!value.equals(getFinalSettlmtCalendar())) ) {
                    setFinalSettlmtCalendar(((java.lang.String) value));
                }
            }
            if( values.containsKey("PartialSettlmtCalendar") ) {
                final Object value = values.remove("PartialSettlmtCalendar");
                if( (value == null) || (!value.equals(getPartialSettlmtCalendar())) ) {
                    setPartialSettlmtCalendar(((java.lang.String) value));
                }
            }
            if( values.containsKey("DeltaSettlmtCalendar") ) {
                final Object value = values.remove("DeltaSettlmtCalendar");
                if( (value == null) || (!value.equals(getDeltaSettlmtCalendar())) ) {
                    setDeltaSettlmtCalendar(((java.lang.String) value));
                }
            }
            if( values.containsKey("DeltaAccrualSettlmtCalendar") ) {
                final Object value = values.remove("DeltaAccrualSettlmtCalendar");
                if( (value == null) || (!value.equals(getDeltaAccrualSettlmtCalendar())) ) {
                    setDeltaAccrualSettlmtCalendar(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrualClearingSettlmtCalendar") ) {
                final Object value = values.remove("AccrualClearingSettlmtCalendar");
                if( (value == null) || (!value.equals(getAccrualClearingSettlmtCalendar())) ) {
                    setAccrualClearingSettlmtCalendar(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrecedingConditionContract") ) {
                final Object value = values.remove("PrecedingConditionContract");
                if( (value == null) || (!value.equals(getPrecedingConditionContract())) ) {
                    setPrecedingConditionContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrUUID") ) {
                final Object value = values.remove("CndnContrUUID");
                if( (value == null) || (!value.equals(getCndnContrUUID())) ) {
                    setCndnContrUUID(((UUID) value));
                }
            }
            if( values.containsKey("CndnContrPurposeCat") ) {
                final Object value = values.remove("CndnContrPurposeCat");
                if( (value == null) || (!value.equals(getCndnContrPurposeCat())) ) {
                    setCndnContrPurposeCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrCurrency") ) {
                final Object value = values.remove("CndnContrCurrency");
                if( (value == null) || (!value.equals(getCndnContrCurrency())) ) {
                    setCndnContrCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrUnit") ) {
                final Object value = values.remove("CndnContrUnit");
                if( (value == null) || (!value.equals(getCndnContrUnit())) ) {
                    setCndnContrUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrUnitISOCode") ) {
                final Object value = values.remove("CndnContrUnitISOCode");
                if( (value == null) || (!value.equals(getCndnContrUnitISOCode())) ) {
                    setCndnContrUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrUnitSAPCode") ) {
                final Object value = values.remove("CndnContrUnitSAPCode");
                if( (value == null) || (!value.equals(getCndnContrUnitSAPCode())) ) {
                    setCndnContrUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrWeightUnit") ) {
                final Object value = values.remove("CndnContrWeightUnit");
                if( (value == null) || (!value.equals(getCndnContrWeightUnit())) ) {
                    setCndnContrWeightUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrWeightUnitISOCode") ) {
                final Object value = values.remove("CndnContrWeightUnitISOCode");
                if( (value == null) || (!value.equals(getCndnContrWeightUnitISOCode())) ) {
                    setCndnContrWeightUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrWeightUnitSAPCode") ) {
                final Object value = values.remove("CndnContrWeightUnitSAPCode");
                if( (value == null) || (!value.equals(getCndnContrWeightUnitSAPCode())) ) {
                    setCndnContrWeightUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrVolumeUnit") ) {
                final Object value = values.remove("CndnContrVolumeUnit");
                if( (value == null) || (!value.equals(getCndnContrVolumeUnit())) ) {
                    setCndnContrVolumeUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrVolumeUnitISOCode") ) {
                final Object value = values.remove("CndnContrVolumeUnitISOCode");
                if( (value == null) || (!value.equals(getCndnContrVolumeUnitISOCode())) ) {
                    setCndnContrVolumeUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrVolumeUnitSAPCode") ) {
                final Object value = values.remove("CndnContrVolumeUnitSAPCode");
                if( (value == null) || (!value.equals(getCndnContrVolumeUnitSAPCode())) ) {
                    setCndnContrVolumeUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrPointsQtyUnit") ) {
                final Object value = values.remove("CndnContrPointsQtyUnit");
                if( (value == null) || (!value.equals(getCndnContrPointsQtyUnit())) ) {
                    setCndnContrPointsQtyUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrPointsQtyUnitISOCode") ) {
                final Object value = values.remove("CndnContrPointsQtyUnitISOCode");
                if( (value == null) || (!value.equals(getCndnContrPointsQtyUnitISOCode())) ) {
                    setCndnContrPointsQtyUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrPointsQtyUnitSAPCode") ) {
                final Object value = values.remove("CndnContrPointsQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getCndnContrPointsQtyUnitSAPCode())) ) {
                    setCndnContrPointsQtyUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ExchangeRate") ) {
                final Object value = values.remove("ExchangeRate");
                if( (value == null) || (!value.equals(getExchangeRate())) ) {
                    setExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExchangeRateDate") ) {
                final Object value = values.remove("ExchangeRateDate");
                if( (value == null) || (!value.equals(getExchangeRateDate())) ) {
                    setExchangeRateDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ExchangeRateType") ) {
                final Object value = values.remove("ExchangeRateType");
                if( (value == null) || (!value.equals(getExchangeRateType())) ) {
                    setExchangeRateType(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((java.lang.String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrualUpdateIsRequired") ) {
                final Object value = values.remove("AccrualUpdateIsRequired");
                if( (value == null) || (!value.equals(getAccrualUpdateIsRequired())) ) {
                    setAccrualUpdateIsRequired(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("SettlmtPartTxRegnNmbr") ) {
                final Object value = values.remove("SettlmtPartTxRegnNmbr");
                if( (value == null) || (!value.equals(getSettlmtPartTxRegnNmbr())) ) {
                    setSettlmtPartTxRegnNmbr(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtPartTxRegnCntry") ) {
                final Object value = values.remove("SettlmtPartTxRegnCntry");
                if( (value == null) || (!value.equals(getSettlmtPartTxRegnCntry())) ) {
                    setSettlmtPartTxRegnCntry(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_CndnContrActiveStatus") ) {
                final Object value = (values).remove("_CndnContrActiveStatus");
                if( value instanceof Iterable ) {
                    if( to_CndnContrActiveStatus == null ) {
                        to_CndnContrActiveStatus = Lists.newArrayList();
                    } else {
                        to_CndnContrActiveStatus = Lists.newArrayList(to_CndnContrActiveStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ConditionContractStatus entity;
                        if( to_CndnContrActiveStatus.size() > i ) {
                            entity = to_CndnContrActiveStatus.get(i);
                        } else {
                            entity = new ConditionContractStatus();
                            to_CndnContrActiveStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_CndnContrBusVolSelCriteria") ) {
                final Object value = (values).remove("_CndnContrBusVolSelCriteria");
                if( value instanceof Iterable ) {
                    if( to_CndnContrBusVolSelCriteria == null ) {
                        to_CndnContrBusVolSelCriteria = Lists.newArrayList();
                    } else {
                        to_CndnContrBusVolSelCriteria = Lists.newArrayList(to_CndnContrBusVolSelCriteria);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusVolSelectionCriteria entity;
                        if( to_CndnContrBusVolSelCriteria.size() > i ) {
                            entity = to_CndnContrBusVolSelCriteria.get(i);
                        } else {
                            entity = new BusVolSelectionCriteria();
                            to_CndnContrBusVolSelCriteria.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_CndnContrCndnRecord") ) {
                final Object value = (values).remove("_CndnContrCndnRecord");
                if( value instanceof Iterable ) {
                    if( to_CndnContrCndnRecord == null ) {
                        to_CndnContrCndnRecord = Lists.newArrayList();
                    } else {
                        to_CndnContrCndnRecord = Lists.newArrayList(to_CndnContrCndnRecord);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CndnContrConditionRecord entity;
                        if( to_CndnContrCndnRecord.size() > i ) {
                            entity = to_CndnContrCndnRecord.get(i);
                        } else {
                            entity = new CndnContrConditionRecord();
                            to_CndnContrCndnRecord.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_CndnContrSettlmtCal") ) {
                final Object value = (values).remove("_CndnContrSettlmtCal");
                if( value instanceof Iterable ) {
                    if( to_CndnContrSettlmtCal == null ) {
                        to_CndnContrSettlmtCal = Lists.newArrayList();
                    } else {
                        to_CndnContrSettlmtCal = Lists.newArrayList(to_CndnContrSettlmtCal);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CndnContrSettlementCalendar entity;
                        if( to_CndnContrSettlmtCal.size() > i ) {
                            entity = to_CndnContrSettlmtCal.get(i);
                        } else {
                            entity = new CndnContrSettlementCalendar();
                            to_CndnContrSettlmtCal.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ConditionContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CndnContrActiveStatus != null ) {
            (values).put("_CndnContrActiveStatus", to_CndnContrActiveStatus);
        }
        if( to_CndnContrBusVolSelCriteria != null ) {
            (values).put("_CndnContrBusVolSelCriteria", to_CndnContrBusVolSelCriteria);
        }
        if( to_CndnContrCndnRecord != null ) {
            (values).put("_CndnContrCndnRecord", to_CndnContrCndnRecord);
        }
        if( to_CndnContrSettlmtCal != null ) {
            (values).put("_CndnContrSettlmtCal", to_CndnContrSettlmtCal);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ConditionContractStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_CndnContrActiveStatus</b>.
     * <p>
     * If the navigation property for an entity <b>ConditionContract</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CndnContrActiveStatus</b> is already loaded, the result
     *         will contain the <b>ConditionContractStatus</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ConditionContractStatus>> getCndnContrActiveStatusIfPresent()
    {
        return Option.of(to_CndnContrActiveStatus);
    }

    /**
     * Overwrites the list of associated <b>ConditionContractStatus</b> entities for the loaded navigation property
     * <b>_CndnContrActiveStatus</b>.
     * <p>
     * If the navigation property <b>_CndnContrActiveStatus</b> of a queried <b>ConditionContract</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>ConditionContractStatus</b> entities.
     */
    public void setCndnContrActiveStatus( @Nonnull final List<ConditionContractStatus> value )
    {
        if( to_CndnContrActiveStatus == null ) {
            to_CndnContrActiveStatus = Lists.newArrayList();
        }
        to_CndnContrActiveStatus.clear();
        to_CndnContrActiveStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ConditionContractStatus</b> entities. This corresponds to the OData
     * navigation property <b>_CndnContrActiveStatus</b>.
     * <p>
     * If the navigation property <b>_CndnContrActiveStatus</b> of a queried <b>ConditionContract</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>ConditionContractStatus</b> entities.
     */
    public void addCndnContrActiveStatus( ConditionContractStatus... entity )
    {
        if( to_CndnContrActiveStatus == null ) {
            to_CndnContrActiveStatus = Lists.newArrayList();
        }
        to_CndnContrActiveStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>BusVolSelectionCriteria</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_CndnContrBusVolSelCriteria</b>.
     * <p>
     * If the navigation property for an entity <b>ConditionContract</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CndnContrBusVolSelCriteria</b> is already loaded, the
     *         result will contain the <b>BusVolSelectionCriteria</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusVolSelectionCriteria>> getCndnContrBusVolSelCriteriaIfPresent()
    {
        return Option.of(to_CndnContrBusVolSelCriteria);
    }

    /**
     * Overwrites the list of associated <b>BusVolSelectionCriteria</b> entities for the loaded navigation property
     * <b>_CndnContrBusVolSelCriteria</b>.
     * <p>
     * If the navigation property <b>_CndnContrBusVolSelCriteria</b> of a queried <b>ConditionContract</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>BusVolSelectionCriteria</b> entities.
     */
    public void setCndnContrBusVolSelCriteria( @Nonnull final List<BusVolSelectionCriteria> value )
    {
        if( to_CndnContrBusVolSelCriteria == null ) {
            to_CndnContrBusVolSelCriteria = Lists.newArrayList();
        }
        to_CndnContrBusVolSelCriteria.clear();
        to_CndnContrBusVolSelCriteria.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusVolSelectionCriteria</b> entities. This corresponds to the OData
     * navigation property <b>_CndnContrBusVolSelCriteria</b>.
     * <p>
     * If the navigation property <b>_CndnContrBusVolSelCriteria</b> of a queried <b>ConditionContract</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>BusVolSelectionCriteria</b> entities.
     */
    public void addCndnContrBusVolSelCriteria( BusVolSelectionCriteria... entity )
    {
        if( to_CndnContrBusVolSelCriteria == null ) {
            to_CndnContrBusVolSelCriteria = Lists.newArrayList();
        }
        to_CndnContrBusVolSelCriteria.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>CndnContrConditionRecord</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_CndnContrCndnRecord</b>.
     * <p>
     * If the navigation property for an entity <b>ConditionContract</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CndnContrCndnRecord</b> is already loaded, the result will
     *         contain the <b>CndnContrConditionRecord</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CndnContrConditionRecord>> getCndnContrCndnRecordIfPresent()
    {
        return Option.of(to_CndnContrCndnRecord);
    }

    /**
     * Overwrites the list of associated <b>CndnContrConditionRecord</b> entities for the loaded navigation property
     * <b>_CndnContrCndnRecord</b>.
     * <p>
     * If the navigation property <b>_CndnContrCndnRecord</b> of a queried <b>ConditionContract</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>CndnContrConditionRecord</b> entities.
     */
    public void setCndnContrCndnRecord( @Nonnull final List<CndnContrConditionRecord> value )
    {
        if( to_CndnContrCndnRecord == null ) {
            to_CndnContrCndnRecord = Lists.newArrayList();
        }
        to_CndnContrCndnRecord.clear();
        to_CndnContrCndnRecord.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CndnContrConditionRecord</b> entities. This corresponds to the OData
     * navigation property <b>_CndnContrCndnRecord</b>.
     * <p>
     * If the navigation property <b>_CndnContrCndnRecord</b> of a queried <b>ConditionContract</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>CndnContrConditionRecord</b> entities.
     */
    public void addCndnContrCndnRecord( CndnContrConditionRecord... entity )
    {
        if( to_CndnContrCndnRecord == null ) {
            to_CndnContrCndnRecord = Lists.newArrayList();
        }
        to_CndnContrCndnRecord.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>CndnContrSettlementCalendar</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_CndnContrSettlmtCal</b>.
     * <p>
     * If the navigation property for an entity <b>ConditionContract</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CndnContrSettlmtCal</b> is already loaded, the result will
     *         contain the <b>CndnContrSettlementCalendar</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CndnContrSettlementCalendar>> getCndnContrSettlmtCalIfPresent()
    {
        return Option.of(to_CndnContrSettlmtCal);
    }

    /**
     * Overwrites the list of associated <b>CndnContrSettlementCalendar</b> entities for the loaded navigation property
     * <b>_CndnContrSettlmtCal</b>.
     * <p>
     * If the navigation property <b>_CndnContrSettlmtCal</b> of a queried <b>ConditionContract</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>CndnContrSettlementCalendar</b> entities.
     */
    public void setCndnContrSettlmtCal( @Nonnull final List<CndnContrSettlementCalendar> value )
    {
        if( to_CndnContrSettlmtCal == null ) {
            to_CndnContrSettlmtCal = Lists.newArrayList();
        }
        to_CndnContrSettlmtCal.clear();
        to_CndnContrSettlmtCal.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CndnContrSettlementCalendar</b> entities. This corresponds to the
     * OData navigation property <b>_CndnContrSettlmtCal</b>.
     * <p>
     * If the navigation property <b>_CndnContrSettlmtCal</b> of a queried <b>ConditionContract</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>CndnContrSettlementCalendar</b> entities.
     */
    public void addCndnContrSettlmtCal( CndnContrSettlementCalendar... entity )
    {
        if( to_CndnContrSettlmtCal == null ) {
            to_CndnContrSettlmtCal = Lists.newArrayList();
        }
        to_CndnContrSettlmtCal.addAll(Lists.newArrayList(entity));
    }

    /**
     * Function that can be applied to any entity object of this class.
     * </p>
     * 
     * @param settlmtAccrsRsltSetCat
     *            Constraints: Not nullable, Maximum length: 1
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SettlmtAccrsRsltSetCat</b>
     *            </p>
     * @param settlmtAccrsGroupCategory
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SettlmtAccrsGroupCategory</b>
     *            </p>
     * @param settlmtAccrsOrgDataGrpCategory
     *            Constraints: Not nullable, Maximum length: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SettlmtAccrsOrgDataGrpCategory</b>
     *            </p>
     * @param settlmtAccrsTimeSeriesCategory
     *            Constraints: Not nullable, Maximum length: 1
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SettlmtAccrsTimeSeriesCategory</b>
     *            </p>
     * @return Function object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyFunction(thisFunction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundFunction.SingleToCollection<ConditionContract, AccrualAmountsResult_Type>
        determineAccrualAmounts(
            @Nonnull final java.lang.String settlmtAccrsGroupCategory,
            @Nonnull final java.lang.String settlmtAccrsOrgDataGrpCategory,
            @Nonnull final java.lang.String settlmtAccrsTimeSeriesCategory,
            @Nonnull final java.lang.String settlmtAccrsRsltSetCat )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("SettlmtAccrsGroupCategory", settlmtAccrsGroupCategory);
        parameters.put("SettlmtAccrsOrgDataGrpCategory", settlmtAccrsOrgDataGrpCategory);
        parameters.put("SettlmtAccrsTimeSeriesCategory", settlmtAccrsTimeSeriesCategory);
        parameters.put("SettlmtAccrsRsltSetCat", settlmtAccrsRsltSetCat);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundFunction.SingleToCollection<ConditionContract, AccrualAmountsResult_Type>(
            ConditionContract.class,
            AccrualAmountsResult_Type.class,
            "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.DetermineAccrualAmounts",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<ConditionContract, Void>
        lockForSettlement()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<ConditionContract, Void>(
            ConditionContract.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.LockForSettlement",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<ConditionContract, Void> release()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<ConditionContract, Void>(
            ConditionContract.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.Release",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<ConditionContract, Void>
        releaseForSettlement()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<ConditionContract, Void>(
            ConditionContract.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.ReleaseForSettlement",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of ConditionContract instances.
     * 
     */
    public final static class ConditionContractBuilder
    {

        private List<ConditionContractStatus> to_CndnContrActiveStatus = Lists.newArrayList();
        private List<BusVolSelectionCriteria> to_CndnContrBusVolSelCriteria = Lists.newArrayList();
        private List<CndnContrConditionRecord> to_CndnContrCndnRecord = Lists.newArrayList();
        private List<CndnContrSettlementCalendar> to_CndnContrSettlmtCal = Lists.newArrayList();

        private ConditionContract.ConditionContractBuilder to_CndnContrActiveStatus(
            final List<ConditionContractStatus> value )
        {
            to_CndnContrActiveStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CndnContrActiveStatus</b> for <b>ConditionContract</b> to multiple
         * <b>ConditionContractStatus</b>.
         * 
         * @param value
         *            The ConditionContractStatuss to build this ConditionContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConditionContract.ConditionContractBuilder cndnContrActiveStatus( ConditionContractStatus... value )
        {
            return to_CndnContrActiveStatus(Lists.newArrayList(value));
        }

        private ConditionContract.ConditionContractBuilder to_CndnContrBusVolSelCriteria(
            final List<BusVolSelectionCriteria> value )
        {
            to_CndnContrBusVolSelCriteria.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CndnContrBusVolSelCriteria</b> for <b>ConditionContract</b> to multiple
         * <b>BusVolSelectionCriteria</b>.
         * 
         * @param value
         *            The BusVolSelectionCriterias to build this ConditionContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConditionContract.ConditionContractBuilder cndnContrBusVolSelCriteria( BusVolSelectionCriteria... value )
        {
            return to_CndnContrBusVolSelCriteria(Lists.newArrayList(value));
        }

        private ConditionContract.ConditionContractBuilder to_CndnContrCndnRecord(
            final List<CndnContrConditionRecord> value )
        {
            to_CndnContrCndnRecord.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CndnContrCndnRecord</b> for <b>ConditionContract</b> to multiple
         * <b>CndnContrConditionRecord</b>.
         * 
         * @param value
         *            The CndnContrConditionRecords to build this ConditionContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConditionContract.ConditionContractBuilder cndnContrCndnRecord( CndnContrConditionRecord... value )
        {
            return to_CndnContrCndnRecord(Lists.newArrayList(value));
        }

        private ConditionContract.ConditionContractBuilder to_CndnContrSettlmtCal(
            final List<CndnContrSettlementCalendar> value )
        {
            to_CndnContrSettlmtCal.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CndnContrSettlmtCal</b> for <b>ConditionContract</b> to multiple
         * <b>CndnContrSettlementCalendar</b>.
         * 
         * @param value
         *            The CndnContrSettlementCalendars to build this ConditionContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConditionContract.ConditionContractBuilder cndnContrSettlmtCal( CndnContrSettlementCalendar... value )
        {
            return to_CndnContrSettlmtCal(Lists.newArrayList(value));
        }

    }

}
