/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditioncontract;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConditionContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Contract Status
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ConditionContractStatusType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ConditionContractStatus extends VdmEntity<ConditionContractStatus> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.ConditionContractStatusType";
    /**
     * Selector for all available fields of ConditionContractStatus.
     * 
     */
    public final static SimpleProperty<ConditionContractStatus> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @return Condition Contract
     */
    @Nullable
    @ElementName( "ConditionContract" )
    private java.lang.String conditionContract;
    public final static SimpleProperty.String<ConditionContractStatus> CONDITION_CONTRACT =
        new SimpleProperty.String<ConditionContractStatus>(ConditionContractStatus.class, "ConditionContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StatusCode</b>
     * </p>
     * 
     * @return Object Status
     */
    @Nullable
    @ElementName( "StatusCode" )
    private java.lang.String statusCode;
    public final static SimpleProperty.String<ConditionContractStatus> STATUS_CODE =
        new SimpleProperty.String<ConditionContractStatus>(ConditionContractStatus.class, "StatusCode");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsUserStatus</b>
     * </p>
     * 
     * @return Is User Status
     */
    @Nullable
    @ElementName( "IsUserStatus" )
    private java.lang.Boolean isUserStatus;
    public final static SimpleProperty.Boolean<ConditionContractStatus> IS_USER_STATUS =
        new SimpleProperty.Boolean<ConditionContractStatus>(ConditionContractStatus.class, "IsUserStatus");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>StatusProfile</b>
     * </p>
     * 
     * @return Status Profile
     */
    @Nullable
    @ElementName( "StatusProfile" )
    private java.lang.String statusProfile;
    public final static SimpleProperty.String<ConditionContractStatus> STATUS_PROFILE =
        new SimpleProperty.String<ConditionContractStatus>(ConditionContractStatus.class, "StatusProfile");
    /**
     * Navigation property <b>_ConditionContract</b> for <b>ConditionContractStatus</b> to single
     * <b>ConditionContract</b>.
     * 
     */
    @ElementName( "_ConditionContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConditionContract to_ConditionContract;
    /**
     * Use with available request builders to apply the <b>_ConditionContract</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ConditionContractStatus, ConditionContract> TO__CONDITION_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ConditionContractStatus, ConditionContract>(
            ConditionContractStatus.class,
            "_ConditionContract",
            ConditionContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ConditionContractStatus> getType()
    {
        return ConditionContractStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @param conditionContract
     *            Condition Contract
     */
    public void setConditionContract( @Nullable final java.lang.String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StatusCode</b>
     * </p>
     * 
     * @param statusCode
     *            Object Status
     */
    public void setStatusCode( @Nullable final java.lang.String statusCode )
    {
        rememberChangedField("StatusCode", this.statusCode);
        this.statusCode = statusCode;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsUserStatus</b>
     * </p>
     * 
     * @param isUserStatus
     *            Is User Status
     */
    public void setIsUserStatus( @Nullable final java.lang.Boolean isUserStatus )
    {
        rememberChangedField("IsUserStatus", this.isUserStatus);
        this.isUserStatus = isUserStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>StatusProfile</b>
     * </p>
     * 
     * @param statusProfile
     *            Status Profile
     */
    public void setStatusProfile( @Nullable final java.lang.String statusProfile )
    {
        rememberChangedField("StatusProfile", this.statusProfile);
        this.statusProfile = statusProfile;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ConditionContractStatus";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionContract", getConditionContract());
        entityKey.addKeyProperty("StatusCode", getStatusCode());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionContract", getConditionContract());
        values.put("StatusCode", getStatusCode());
        values.put("IsUserStatus", getIsUserStatus());
        values.put("StatusProfile", getStatusProfile());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("StatusCode") ) {
                final Object value = values.remove("StatusCode");
                if( (value == null) || (!value.equals(getStatusCode())) ) {
                    setStatusCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("IsUserStatus") ) {
                final Object value = values.remove("IsUserStatus");
                if( (value == null) || (!value.equals(getIsUserStatus())) ) {
                    setIsUserStatus(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("StatusProfile") ) {
                final Object value = values.remove("StatusProfile");
                if( (value == null) || (!value.equals(getStatusProfile())) ) {
                    setStatusProfile(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ConditionContract") ) {
                final Object value = (values).remove("_ConditionContract");
                if( value instanceof Map ) {
                    if( to_ConditionContract == null ) {
                        to_ConditionContract = new ConditionContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ConditionContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ConditionContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ConditionContract != null ) {
            (values).put("_ConditionContract", to_ConditionContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ConditionContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_ConditionContract</b>.
     * <p>
     * If the navigation property for an entity <b>ConditionContractStatus</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ConditionContract</b> is already loaded, the result will
     *         contain the <b>ConditionContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConditionContract> getConditionContractIfPresent()
    {
        return Option.of(to_ConditionContract);
    }

    /**
     * Overwrites the associated <b>ConditionContract</b> entity for the loaded navigation property
     * <b>_ConditionContract</b>.
     * 
     * @param value
     *            New <b>ConditionContract</b> entity.
     */
    public void setConditionContract( final ConditionContract value )
    {
        to_ConditionContract = value;
    }

    /**
     * Helper class to allow for fluent creation of ConditionContractStatus instances.
     * 
     */
    public final static class ConditionContractStatusBuilder
    {

        private ConditionContract to_ConditionContract;
        private java.lang.String conditionContract = null;

        private ConditionContractStatus.ConditionContractStatusBuilder to_ConditionContract(
            final ConditionContract value )
        {
            to_ConditionContract = value;
            return this;
        }

        /**
         * Navigation property <b>_ConditionContract</b> for <b>ConditionContractStatus</b> to single
         * <b>ConditionContract</b>.
         * 
         * @param value
         *            The ConditionContract to build this ConditionContractStatus with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConditionContractStatus.ConditionContractStatusBuilder conditionContract( final ConditionContract value )
        {
            return to_ConditionContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ConditionContract</b>
         * </p>
         * 
         * @param value
         *            The conditionContract to build this ConditionContractStatus with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ConditionContractStatus.ConditionContractStatusBuilder conditionContract( final java.lang.String value )
        {
            conditionContract = value;
            return this;
        }

    }

}
