/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditiontableforpricinginsales;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConditionTableForPricingInSalesService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Tables
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesPricingConditionTableType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SalesPricingConditionTable extends VdmEntity<SalesPricingConditionTable> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_slsprcgconditiontable.v0001.SalesPricingConditionTableType";
    /**
     * Selector for all available fields of SalesPricingConditionTable.
     * 
     */
    public final static SimpleProperty<SalesPricingConditionTable> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @return Usage of the condition table
     */
    @Nullable
    @ElementName( "ConditionUsage" )
    private java.lang.String conditionUsage;
    public final static SimpleProperty.String<SalesPricingConditionTable> CONDITION_USAGE =
        new SimpleProperty.String<SalesPricingConditionTable>(SalesPricingConditionTable.class, "ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<SalesPricingConditionTable> CONDITION_APPLICATION =
        new SimpleProperty.String<SalesPricingConditionTable>(SalesPricingConditionTable.class, "ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @return Three-digit character field for IDocs
     */
    @Nullable
    @ElementName( "ConditionTable" )
    private java.lang.String conditionTable;
    public final static SimpleProperty.String<SalesPricingConditionTable> CONDITION_TABLE =
        new SimpleProperty.String<SalesPricingConditionTable>(SalesPricingConditionTable.class, "ConditionTable");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTableHasValidityPeriod</b>
     * </p>
     * 
     * @return ID: Condition structure has validity period
     */
    @Nullable
    @ElementName( "PrcgCndnTableHasValidityPeriod" )
    private java.lang.Boolean prcgCndnTableHasValidityPeriod;
    public final static SimpleProperty.Boolean<SalesPricingConditionTable> PRCG_CNDN_TABLE_HAS_VALIDITY_PERIOD =
        new SimpleProperty.Boolean<SalesPricingConditionTable>(
            SalesPricingConditionTable.class,
            "PrcgCndnTableHasValidityPeriod");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTableHasReleaseStatus</b>
     * </p>
     * 
     * @return Indicator: Structure has release status
     */
    @Nullable
    @ElementName( "PrcgCndnTableHasReleaseStatus" )
    private java.lang.Boolean prcgCndnTableHasReleaseStatus;
    public final static SimpleProperty.Boolean<SalesPricingConditionTable> PRCG_CNDN_TABLE_HAS_RELEASE_STATUS =
        new SimpleProperty.Boolean<SalesPricingConditionTable>(
            SalesPricingConditionTable.class,
            "PrcgCndnTableHasReleaseStatus");
    /**
     * Navigation property <b>_SlsPrcgConditionTableField</b> for <b>SalesPricingConditionTable</b> to multiple
     * <b>SlsPrcgConditionTableField</b>.
     * 
     */
    @ElementName( "_SlsPrcgConditionTableField" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPrcgConditionTableField> to_SlsPrcgConditionTableField;
    /**
     * Navigation property <b>_Text</b> for <b>SalesPricingConditionTable</b> to multiple
     * <b>SlsPricingConditionTableText</b>.
     * 
     */
    @ElementName( "_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPricingConditionTableText> to_Text;
    /**
     * Use with available request builders to apply the <b>_SlsPrcgConditionTableField</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingConditionTable, SlsPrcgConditionTableField> TO__SLS_PRCG_CONDITION_TABLE_FIELD =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingConditionTable, SlsPrcgConditionTableField>(
            SalesPricingConditionTable.class,
            "_SlsPrcgConditionTableField",
            SlsPrcgConditionTableField.class);
    /**
     * Use with available request builders to apply the <b>_Text</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingConditionTable, SlsPricingConditionTableText> TO__TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingConditionTable, SlsPricingConditionTableText>(
            SalesPricingConditionTable.class,
            "_Text",
            SlsPricingConditionTableText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SalesPricingConditionTable> getType()
    {
        return SalesPricingConditionTable.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final java.lang.String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @param conditionTable
     *            Three-digit character field for IDocs
     */
    public void setConditionTable( @Nullable final java.lang.String conditionTable )
    {
        rememberChangedField("ConditionTable", this.conditionTable);
        this.conditionTable = conditionTable;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTableHasValidityPeriod</b>
     * </p>
     * 
     * @param prcgCndnTableHasValidityPeriod
     *            ID: Condition structure has validity period
     */
    public void setPrcgCndnTableHasValidityPeriod( @Nullable final java.lang.Boolean prcgCndnTableHasValidityPeriod )
    {
        rememberChangedField("PrcgCndnTableHasValidityPeriod", this.prcgCndnTableHasValidityPeriod);
        this.prcgCndnTableHasValidityPeriod = prcgCndnTableHasValidityPeriod;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTableHasReleaseStatus</b>
     * </p>
     * 
     * @param prcgCndnTableHasReleaseStatus
     *            Indicator: Structure has release status
     */
    public void setPrcgCndnTableHasReleaseStatus( @Nullable final java.lang.Boolean prcgCndnTableHasReleaseStatus )
    {
        rememberChangedField("PrcgCndnTableHasReleaseStatus", this.prcgCndnTableHasReleaseStatus);
        this.prcgCndnTableHasReleaseStatus = prcgCndnTableHasReleaseStatus;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SalesPricingConditionTable";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionUsage", getConditionUsage());
        entityKey.addKeyProperty("ConditionApplication", getConditionApplication());
        entityKey.addKeyProperty("ConditionTable", getConditionTable());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionTable", getConditionTable());
        values.put("PrcgCndnTableHasValidityPeriod", getPrcgCndnTableHasValidityPeriod());
        values.put("PrcgCndnTableHasReleaseStatus", getPrcgCndnTableHasReleaseStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionTable") ) {
                final Object value = values.remove("ConditionTable");
                if( (value == null) || (!value.equals(getConditionTable())) ) {
                    setConditionTable(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgCndnTableHasValidityPeriod") ) {
                final Object value = values.remove("PrcgCndnTableHasValidityPeriod");
                if( (value == null) || (!value.equals(getPrcgCndnTableHasValidityPeriod())) ) {
                    setPrcgCndnTableHasValidityPeriod(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("PrcgCndnTableHasReleaseStatus") ) {
                final Object value = values.remove("PrcgCndnTableHasReleaseStatus");
                if( (value == null) || (!value.equals(getPrcgCndnTableHasReleaseStatus())) ) {
                    setPrcgCndnTableHasReleaseStatus(((java.lang.Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SlsPrcgConditionTableField") ) {
                final Object value = (values).remove("_SlsPrcgConditionTableField");
                if( value instanceof Iterable ) {
                    if( to_SlsPrcgConditionTableField == null ) {
                        to_SlsPrcgConditionTableField = Lists.newArrayList();
                    } else {
                        to_SlsPrcgConditionTableField = Lists.newArrayList(to_SlsPrcgConditionTableField);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPrcgConditionTableField entity;
                        if( to_SlsPrcgConditionTableField.size() > i ) {
                            entity = to_SlsPrcgConditionTableField.get(i);
                        } else {
                            entity = new SlsPrcgConditionTableField();
                            to_SlsPrcgConditionTableField.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_Text") ) {
                final Object value = (values).remove("_Text");
                if( value instanceof Iterable ) {
                    if( to_Text == null ) {
                        to_Text = Lists.newArrayList();
                    } else {
                        to_Text = Lists.newArrayList(to_Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPricingConditionTableText entity;
                        if( to_Text.size() > i ) {
                            entity = to_Text.get(i);
                        } else {
                            entity = new SlsPricingConditionTableText();
                            to_Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ConditionTableForPricingInSalesService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SlsPrcgConditionTableField != null ) {
            (values).put("_SlsPrcgConditionTableField", to_SlsPrcgConditionTableField);
        }
        if( to_Text != null ) {
            (values).put("_Text", to_Text);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SlsPrcgConditionTableField</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SlsPrcgConditionTableField</b>.
     * <p>
     * If the navigation property for an entity <b>SalesPricingConditionTable</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SlsPrcgConditionTableField</b> is already loaded, the
     *         result will contain the <b>SlsPrcgConditionTableField</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPrcgConditionTableField>> getSlsPrcgConditionTableFieldIfPresent()
    {
        return Option.of(to_SlsPrcgConditionTableField);
    }

    /**
     * Overwrites the list of associated <b>SlsPrcgConditionTableField</b> entities for the loaded navigation property
     * <b>_SlsPrcgConditionTableField</b>.
     * <p>
     * If the navigation property <b>_SlsPrcgConditionTableField</b> of a queried <b>SalesPricingConditionTable</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SlsPrcgConditionTableField</b> entities.
     */
    public void setSlsPrcgConditionTableField( @Nonnull final List<SlsPrcgConditionTableField> value )
    {
        if( to_SlsPrcgConditionTableField == null ) {
            to_SlsPrcgConditionTableField = Lists.newArrayList();
        }
        to_SlsPrcgConditionTableField.clear();
        to_SlsPrcgConditionTableField.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPrcgConditionTableField</b> entities. This corresponds to the OData
     * navigation property <b>_SlsPrcgConditionTableField</b>.
     * <p>
     * If the navigation property <b>_SlsPrcgConditionTableField</b> of a queried <b>SalesPricingConditionTable</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SlsPrcgConditionTableField</b> entities.
     */
    public void addSlsPrcgConditionTableField( SlsPrcgConditionTableField... entity )
    {
        if( to_SlsPrcgConditionTableField == null ) {
            to_SlsPrcgConditionTableField = Lists.newArrayList();
        }
        to_SlsPrcgConditionTableField.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SlsPricingConditionTableText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_Text</b>.
     * <p>
     * If the navigation property for an entity <b>SalesPricingConditionTable</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Text</b> is already loaded, the result will contain the
     *         <b>SlsPricingConditionTableText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPricingConditionTableText>> getTextIfPresent()
    {
        return Option.of(to_Text);
    }

    /**
     * Overwrites the list of associated <b>SlsPricingConditionTableText</b> entities for the loaded navigation property
     * <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>SalesPricingConditionTable</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SlsPricingConditionTableText</b> entities.
     */
    public void setText( @Nonnull final List<SlsPricingConditionTableText> value )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.clear();
        to_Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPricingConditionTableText</b> entities. This corresponds to the
     * OData navigation property <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>SalesPricingConditionTable</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SlsPricingConditionTableText</b> entities.
     */
    public void addText( SlsPricingConditionTableText... entity )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesPricingConditionTable instances.
     * 
     */
    public final static class SalesPricingConditionTableBuilder
    {

        private List<SlsPrcgConditionTableField> to_SlsPrcgConditionTableField = Lists.newArrayList();
        private List<SlsPricingConditionTableText> to_Text = Lists.newArrayList();

        private SalesPricingConditionTable.SalesPricingConditionTableBuilder to_SlsPrcgConditionTableField(
            final List<SlsPrcgConditionTableField> value )
        {
            to_SlsPrcgConditionTableField.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SlsPrcgConditionTableField</b> for <b>SalesPricingConditionTable</b> to multiple
         * <b>SlsPrcgConditionTableField</b>.
         * 
         * @param value
         *            The SlsPrcgConditionTableFields to build this SalesPricingConditionTable with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesPricingConditionTable.SalesPricingConditionTableBuilder slsPrcgConditionTableField(
            SlsPrcgConditionTableField... value )
        {
            return to_SlsPrcgConditionTableField(Lists.newArrayList(value));
        }

        private SalesPricingConditionTable.SalesPricingConditionTableBuilder to_Text(
            final List<SlsPricingConditionTableText> value )
        {
            to_Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_Text</b> for <b>SalesPricingConditionTable</b> to multiple
         * <b>SlsPricingConditionTableText</b>.
         * 
         * @param value
         *            The SlsPricingConditionTableTexts to build this SalesPricingConditionTable with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesPricingConditionTable.SalesPricingConditionTableBuilder text(
            SlsPricingConditionTableText... value )
        {
            return to_Text(Lists.newArrayList(value));
        }

    }

}
