/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditiontableforpricinginsales;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConditionTableForPricingInSalesService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Fields
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SlsPrcgConditionTableFieldType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SlsPrcgConditionTableField extends VdmEntity<SlsPrcgConditionTableField> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_slsprcgconditiontable.v0001.SlsPrcgConditionTableFieldType";
    /**
     * Selector for all available fields of SlsPrcgConditionTableField.
     * 
     */
    public final static SimpleProperty<SlsPrcgConditionTableField> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @return Usage of the condition table
     */
    @Nullable
    @ElementName( "ConditionUsage" )
    private java.lang.String conditionUsage;
    public final static SimpleProperty.String<SlsPrcgConditionTableField> CONDITION_USAGE =
        new SimpleProperty.String<SlsPrcgConditionTableField>(SlsPrcgConditionTableField.class, "ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<SlsPrcgConditionTableField> CONDITION_APPLICATION =
        new SimpleProperty.String<SlsPrcgConditionTableField>(SlsPrcgConditionTableField.class, "ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @return Three-digit character field for IDocs
     */
    @Nullable
    @ElementName( "ConditionTable" )
    private java.lang.String conditionTable;
    public final static SimpleProperty.String<SlsPrcgConditionTableField> CONDITION_TABLE =
        new SimpleProperty.String<SlsPrcgConditionTableField>(SlsPrcgConditionTableField.class, "ConditionTable");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionField</b>
     * </p>
     * 
     * @return Field Name
     */
    @Nullable
    @ElementName( "PricingConditionField" )
    private java.lang.String pricingConditionField;
    public final static SimpleProperty.String<SlsPrcgConditionTableField> PRICING_CONDITION_FIELD =
        new SimpleProperty.String<SlsPrcgConditionTableField>(
            SlsPrcgConditionTableField.class,
            "PricingConditionField");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTableFieldIsKey</b>
     * </p>
     * 
     * @return Identifies a key field of a table
     */
    @Nullable
    @ElementName( "PrcgCndnTableFieldIsKey" )
    private java.lang.Boolean prcgCndnTableFieldIsKey;
    public final static SimpleProperty.Boolean<SlsPrcgConditionTableField> PRCG_CNDN_TABLE_FIELD_IS_KEY =
        new SimpleProperty.Boolean<SlsPrcgConditionTableField>(
            SlsPrcgConditionTableField.class,
            "PrcgCndnTableFieldIsKey");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTableFieldIsItem</b>
     * </p>
     * 
     * @return Field to appear on fast entry screen (item)
     */
    @Nullable
    @ElementName( "PrcgCndnTableFieldIsItem" )
    private java.lang.Boolean prcgCndnTableFieldIsItem;
    public final static SimpleProperty.Boolean<SlsPrcgConditionTableField> PRCG_CNDN_TABLE_FIELD_IS_ITEM =
        new SimpleProperty.Boolean<SlsPrcgConditionTableField>(
            SlsPrcgConditionTableField.class,
            "PrcgCndnTableFieldIsItem");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTableFieldHasText</b>
     * </p>
     * 
     * @return Text field for fast entry
     */
    @Nullable
    @ElementName( "PrcgCndnTableFieldHasText" )
    private java.lang.Boolean prcgCndnTableFieldHasText;
    public final static SimpleProperty.Boolean<SlsPrcgConditionTableField> PRCG_CNDN_TABLE_FIELD_HAS_TEXT =
        new SimpleProperty.Boolean<SlsPrcgConditionTableField>(
            SlsPrcgConditionTableField.class,
            "PrcgCndnTableFieldHasText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionGlobalFieldName</b>
     * </p>
     * 
     * @return DD: Field Name Original Spelling
     */
    @Nullable
    @ElementName( "PrcgConditionGlobalFieldName" )
    private java.lang.String prcgConditionGlobalFieldName;
    public final static SimpleProperty.String<SlsPrcgConditionTableField> PRCG_CONDITION_GLOBAL_FIELD_NAME =
        new SimpleProperty.String<SlsPrcgConditionTableField>(
            SlsPrcgConditionTableField.class,
            "PrcgConditionGlobalFieldName");
    /**
     * Navigation property <b>_SalesPricingConditionTable</b> for <b>SlsPrcgConditionTableField</b> to single
     * <b>SalesPricingConditionTable</b>.
     * 
     */
    @ElementName( "_SalesPricingConditionTable" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesPricingConditionTable to_SalesPricingConditionTable;
    /**
     * Use with available request builders to apply the <b>_SalesPricingConditionTable</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SlsPrcgConditionTableField, SalesPricingConditionTable> TO__SALES_PRICING_CONDITION_TABLE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SlsPrcgConditionTableField, SalesPricingConditionTable>(
            SlsPrcgConditionTableField.class,
            "_SalesPricingConditionTable",
            SalesPricingConditionTable.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SlsPrcgConditionTableField> getType()
    {
        return SlsPrcgConditionTableField.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final java.lang.String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @param conditionTable
     *            Three-digit character field for IDocs
     */
    public void setConditionTable( @Nullable final java.lang.String conditionTable )
    {
        rememberChangedField("ConditionTable", this.conditionTable);
        this.conditionTable = conditionTable;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionField</b>
     * </p>
     * 
     * @param pricingConditionField
     *            Field Name
     */
    public void setPricingConditionField( @Nullable final java.lang.String pricingConditionField )
    {
        rememberChangedField("PricingConditionField", this.pricingConditionField);
        this.pricingConditionField = pricingConditionField;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTableFieldIsKey</b>
     * </p>
     * 
     * @param prcgCndnTableFieldIsKey
     *            Identifies a key field of a table
     */
    public void setPrcgCndnTableFieldIsKey( @Nullable final java.lang.Boolean prcgCndnTableFieldIsKey )
    {
        rememberChangedField("PrcgCndnTableFieldIsKey", this.prcgCndnTableFieldIsKey);
        this.prcgCndnTableFieldIsKey = prcgCndnTableFieldIsKey;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTableFieldIsItem</b>
     * </p>
     * 
     * @param prcgCndnTableFieldIsItem
     *            Field to appear on fast entry screen (item)
     */
    public void setPrcgCndnTableFieldIsItem( @Nullable final java.lang.Boolean prcgCndnTableFieldIsItem )
    {
        rememberChangedField("PrcgCndnTableFieldIsItem", this.prcgCndnTableFieldIsItem);
        this.prcgCndnTableFieldIsItem = prcgCndnTableFieldIsItem;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnTableFieldHasText</b>
     * </p>
     * 
     * @param prcgCndnTableFieldHasText
     *            Text field for fast entry
     */
    public void setPrcgCndnTableFieldHasText( @Nullable final java.lang.Boolean prcgCndnTableFieldHasText )
    {
        rememberChangedField("PrcgCndnTableFieldHasText", this.prcgCndnTableFieldHasText);
        this.prcgCndnTableFieldHasText = prcgCndnTableFieldHasText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionGlobalFieldName</b>
     * </p>
     * 
     * @param prcgConditionGlobalFieldName
     *            DD: Field Name Original Spelling
     */
    public void setPrcgConditionGlobalFieldName( @Nullable final java.lang.String prcgConditionGlobalFieldName )
    {
        rememberChangedField("PrcgConditionGlobalFieldName", this.prcgConditionGlobalFieldName);
        this.prcgConditionGlobalFieldName = prcgConditionGlobalFieldName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SlsPrcgConditionTableField";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionUsage", getConditionUsage());
        entityKey.addKeyProperty("ConditionApplication", getConditionApplication());
        entityKey.addKeyProperty("ConditionTable", getConditionTable());
        entityKey.addKeyProperty("PricingConditionField", getPricingConditionField());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionTable", getConditionTable());
        values.put("PricingConditionField", getPricingConditionField());
        values.put("PrcgCndnTableFieldIsKey", getPrcgCndnTableFieldIsKey());
        values.put("PrcgCndnTableFieldIsItem", getPrcgCndnTableFieldIsItem());
        values.put("PrcgCndnTableFieldHasText", getPrcgCndnTableFieldHasText());
        values.put("PrcgConditionGlobalFieldName", getPrcgConditionGlobalFieldName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionTable") ) {
                final Object value = values.remove("ConditionTable");
                if( (value == null) || (!value.equals(getConditionTable())) ) {
                    setConditionTable(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingConditionField") ) {
                final Object value = values.remove("PricingConditionField");
                if( (value == null) || (!value.equals(getPricingConditionField())) ) {
                    setPricingConditionField(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgCndnTableFieldIsKey") ) {
                final Object value = values.remove("PrcgCndnTableFieldIsKey");
                if( (value == null) || (!value.equals(getPrcgCndnTableFieldIsKey())) ) {
                    setPrcgCndnTableFieldIsKey(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("PrcgCndnTableFieldIsItem") ) {
                final Object value = values.remove("PrcgCndnTableFieldIsItem");
                if( (value == null) || (!value.equals(getPrcgCndnTableFieldIsItem())) ) {
                    setPrcgCndnTableFieldIsItem(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("PrcgCndnTableFieldHasText") ) {
                final Object value = values.remove("PrcgCndnTableFieldHasText");
                if( (value == null) || (!value.equals(getPrcgCndnTableFieldHasText())) ) {
                    setPrcgCndnTableFieldHasText(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("PrcgConditionGlobalFieldName") ) {
                final Object value = values.remove("PrcgConditionGlobalFieldName");
                if( (value == null) || (!value.equals(getPrcgConditionGlobalFieldName())) ) {
                    setPrcgConditionGlobalFieldName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SalesPricingConditionTable") ) {
                final Object value = (values).remove("_SalesPricingConditionTable");
                if( value instanceof Map ) {
                    if( to_SalesPricingConditionTable == null ) {
                        to_SalesPricingConditionTable = new SalesPricingConditionTable();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SalesPricingConditionTable.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ConditionTableForPricingInSalesService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SalesPricingConditionTable != null ) {
            (values).put("_SalesPricingConditionTable", to_SalesPricingConditionTable);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SalesPricingConditionTable</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_SalesPricingConditionTable</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgConditionTableField</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SalesPricingConditionTable</b> is already loaded, the
     *         result will contain the <b>SalesPricingConditionTable</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesPricingConditionTable> getSalesPricingConditionTableIfPresent()
    {
        return Option.of(to_SalesPricingConditionTable);
    }

    /**
     * Overwrites the associated <b>SalesPricingConditionTable</b> entity for the loaded navigation property
     * <b>_SalesPricingConditionTable</b>.
     * 
     * @param value
     *            New <b>SalesPricingConditionTable</b> entity.
     */
    public void setSalesPricingConditionTable( final SalesPricingConditionTable value )
    {
        to_SalesPricingConditionTable = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsPrcgConditionTableField instances.
     * 
     */
    public final static class SlsPrcgConditionTableFieldBuilder
    {

        private SalesPricingConditionTable to_SalesPricingConditionTable;

        private SlsPrcgConditionTableField.SlsPrcgConditionTableFieldBuilder to_SalesPricingConditionTable(
            final SalesPricingConditionTable value )
        {
            to_SalesPricingConditionTable = value;
            return this;
        }

        /**
         * Navigation property <b>_SalesPricingConditionTable</b> for <b>SlsPrcgConditionTableField</b> to single
         * <b>SalesPricingConditionTable</b>.
         * 
         * @param value
         *            The SalesPricingConditionTable to build this SlsPrcgConditionTableField with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgConditionTableField.SlsPrcgConditionTableFieldBuilder salesPricingConditionTable(
            final SalesPricingConditionTable value )
        {
            return to_SalesPricingConditionTable(value);
        }

    }

}
