/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditiontableforpricinginsales;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConditionTableForPricingInSalesService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SlsPricingConditionTableTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SlsPricingConditionTableText extends VdmEntity<SlsPricingConditionTableText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_slsprcgconditiontable.v0001.SlsPricingConditionTableTextType";
    /**
     * Selector for all available fields of SlsPricingConditionTableText.
     * 
     */
    public final static SimpleProperty<SlsPricingConditionTableText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<SlsPricingConditionTableText> LANGUAGE =
        new SimpleProperty.String<SlsPricingConditionTableText>(SlsPricingConditionTableText.class, "Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @return Usage of the condition table
     */
    @Nullable
    @ElementName( "ConditionUsage" )
    private java.lang.String conditionUsage;
    public final static SimpleProperty.String<SlsPricingConditionTableText> CONDITION_USAGE =
        new SimpleProperty.String<SlsPricingConditionTableText>(SlsPricingConditionTableText.class, "ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<SlsPricingConditionTableText> CONDITION_APPLICATION =
        new SimpleProperty.String<SlsPricingConditionTableText>(
            SlsPricingConditionTableText.class,
            "ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @return Three-digit character field for IDocs
     */
    @Nullable
    @ElementName( "ConditionTable" )
    private java.lang.String conditionTable;
    public final static SimpleProperty.String<SlsPricingConditionTableText> CONDITION_TABLE =
        new SimpleProperty.String<SlsPricingConditionTableText>(SlsPricingConditionTableText.class, "ConditionTable");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTableText</b>
     * </p>
     * 
     * @return Explanatory Short Text
     */
    @Nullable
    @ElementName( "ConditionTableText" )
    private java.lang.String conditionTableText;
    public final static SimpleProperty.String<SlsPricingConditionTableText> CONDITION_TABLE_TEXT =
        new SimpleProperty.String<SlsPricingConditionTableText>(
            SlsPricingConditionTableText.class,
            "ConditionTableText");
    /**
     * Navigation property <b>_SalesPricingConditionTable</b> for <b>SlsPricingConditionTableText</b> to single
     * <b>SalesPricingConditionTable</b>.
     * 
     */
    @ElementName( "_SalesPricingConditionTable" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesPricingConditionTable to_SalesPricingConditionTable;
    /**
     * Use with available request builders to apply the <b>_SalesPricingConditionTable</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SlsPricingConditionTableText, SalesPricingConditionTable> TO__SALES_PRICING_CONDITION_TABLE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SlsPricingConditionTableText, SalesPricingConditionTable>(
            SlsPricingConditionTableText.class,
            "_SalesPricingConditionTable",
            SalesPricingConditionTable.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SlsPricingConditionTableText> getType()
    {
        return SlsPricingConditionTableText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final java.lang.String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @param conditionTable
     *            Three-digit character field for IDocs
     */
    public void setConditionTable( @Nullable final java.lang.String conditionTable )
    {
        rememberChangedField("ConditionTable", this.conditionTable);
        this.conditionTable = conditionTable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTableText</b>
     * </p>
     * 
     * @param conditionTableText
     *            Explanatory Short Text
     */
    public void setConditionTableText( @Nullable final java.lang.String conditionTableText )
    {
        rememberChangedField("ConditionTableText", this.conditionTableText);
        this.conditionTableText = conditionTableText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SlsPricingConditionTableText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Language", getLanguage());
        entityKey.addKeyProperty("ConditionUsage", getConditionUsage());
        entityKey.addKeyProperty("ConditionApplication", getConditionApplication());
        entityKey.addKeyProperty("ConditionTable", getConditionTable());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionTable", getConditionTable());
        values.put("ConditionTableText", getConditionTableText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionTable") ) {
                final Object value = values.remove("ConditionTable");
                if( (value == null) || (!value.equals(getConditionTable())) ) {
                    setConditionTable(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionTableText") ) {
                final Object value = values.remove("ConditionTableText");
                if( (value == null) || (!value.equals(getConditionTableText())) ) {
                    setConditionTableText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SalesPricingConditionTable") ) {
                final Object value = (values).remove("_SalesPricingConditionTable");
                if( value instanceof Map ) {
                    if( to_SalesPricingConditionTable == null ) {
                        to_SalesPricingConditionTable = new SalesPricingConditionTable();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SalesPricingConditionTable.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ConditionTableForPricingInSalesService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SalesPricingConditionTable != null ) {
            (values).put("_SalesPricingConditionTable", to_SalesPricingConditionTable);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SalesPricingConditionTable</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_SalesPricingConditionTable</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPricingConditionTableText</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SalesPricingConditionTable</b> is already loaded, the
     *         result will contain the <b>SalesPricingConditionTable</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesPricingConditionTable> getSalesPricingConditionTableIfPresent()
    {
        return Option.of(to_SalesPricingConditionTable);
    }

    /**
     * Overwrites the associated <b>SalesPricingConditionTable</b> entity for the loaded navigation property
     * <b>_SalesPricingConditionTable</b>.
     * 
     * @param value
     *            New <b>SalesPricingConditionTable</b> entity.
     */
    public void setSalesPricingConditionTable( final SalesPricingConditionTable value )
    {
        to_SalesPricingConditionTable = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsPricingConditionTableText instances.
     * 
     */
    public final static class SlsPricingConditionTableTextBuilder
    {

        private SalesPricingConditionTable to_SalesPricingConditionTable;

        private SlsPricingConditionTableText.SlsPricingConditionTableTextBuilder to_SalesPricingConditionTable(
            final SalesPricingConditionTable value )
        {
            to_SalesPricingConditionTable = value;
            return this;
        }

        /**
         * Navigation property <b>_SalesPricingConditionTable</b> for <b>SlsPricingConditionTableText</b> to single
         * <b>SalesPricingConditionTable</b>.
         * 
         * @param value
         *            The SalesPricingConditionTable to build this SlsPricingConditionTableText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPricingConditionTableText.SlsPricingConditionTableTextBuilder salesPricingConditionTable(
            final SalesPricingConditionTable value )
        {
            return to_SalesPricingConditionTable(value);
        }

    }

}
