/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.result.ElementName;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>BusPartInvoiceType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BusPartInvoice extends VdmEntity<BusPartInvoice>
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_cabuspartinvoice.v0001.BusPartInvoiceType";
    /**
     * Selector for all available fields of BusPartInvoice.
     * 
     */
    public final static SimpleProperty<BusPartInvoice> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerUUID</b>
     * </p>
     * 
     * @return Document Container ID
     */
    @Nullable
    @ElementName( "CADocumentContainerUUID" )
    private UUID cADocumentContainerUUID;
    public final static SimpleProperty.Guid<BusPartInvoice> CA_DOCUMENT_CONTAINER_UUID =
        new SimpleProperty.Guid<BusPartInvoice>(BusPartInvoice.class, "CADocumentContainerUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerInvoiceStatus</b>
     * </p>
     * 
     * @return Invoice Status
     */
    @Nullable
    @ElementName( "CADocContainerInvoiceStatus" )
    private java.lang.String cADocContainerInvoiceStatus;
    public final static SimpleProperty.String<BusPartInvoice> CA_DOC_CONTAINER_INVOICE_STATUS =
        new SimpleProperty.String<BusPartInvoice>(BusPartInvoice.class, "CADocContainerInvoiceStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerInvoiceStatusTxt</b>
     * </p>
     * 
     * @return Short Text for Fixed Values
     */
    @Nullable
    @ElementName( "CADocContainerInvoiceStatusTxt" )
    private java.lang.String cADocContainerInvoiceStatusTxt;
    public final static SimpleProperty.String<BusPartInvoice> CA_DOC_CONTAINER_INVOICE_STATUS_TXT =
        new SimpleProperty.String<BusPartInvoice>(BusPartInvoice.class, "CADocContainerInvoiceStatusTxt");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefType</b>
     * </p>
     * 
     * @return Document Container - Reference Type
     */
    @Nullable
    @ElementName( "CADocumentContainerRefType" )
    private java.lang.String cADocumentContainerRefType;
    public final static SimpleProperty.String<BusPartInvoice> CA_DOCUMENT_CONTAINER_REF_TYPE =
        new SimpleProperty.String<BusPartInvoice>(BusPartInvoice.class, "CADocumentContainerRefType");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefTypeText</b>
     * </p>
     * 
     * @return Reference Type of Document Conainer Text
     */
    @Nullable
    @ElementName( "CADocumentContainerRefTypeText" )
    private java.lang.String cADocumentContainerRefTypeText;
    public final static SimpleProperty.String<BusPartInvoice> CA_DOCUMENT_CONTAINER_REF_TYPE_TEXT =
        new SimpleProperty.String<BusPartInvoice>(BusPartInvoice.class, "CADocumentContainerRefTypeText");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerReference</b>
     * </p>
     * 
     * @return Document Container - Identification for Reference Category
     */
    @Nullable
    @ElementName( "CADocumentContainerReference" )
    private java.lang.String cADocumentContainerReference;
    public final static SimpleProperty.String<BusPartInvoice> CA_DOCUMENT_CONTAINER_REFERENCE =
        new SimpleProperty.String<BusPartInvoice>(BusPartInvoice.class, "CADocumentContainerReference");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Day On Which Accounting Document Was Entered
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<BusPartInvoice> CREATION_DATE =
        new SimpleProperty.Date<BusPartInvoice>(BusPartInvoice.class, "CreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @return Time of Entry
     */
    @Nullable
    @ElementName( "CreationTime" )
    private LocalTime creationTime;
    public final static SimpleProperty.Time<BusPartInvoice> CREATION_TIME =
        new SimpleProperty.Time<BusPartInvoice>(BusPartInvoice.class, "CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisplayCurrency</b>
     * </p>
     * 
     * @return The displayCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "DisplayCurrency" )
    private java.lang.String displayCurrency;
    public final static SimpleProperty.String<BusPartInvoice> DISPLAY_CURRENCY =
        new SimpleProperty.String<BusPartInvoice>(BusPartInvoice.class, "DisplayCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAInvoiceAmountInDisplayCrcy</b>
     * </p>
     * 
     * @return The cAInvoiceAmountInDisplayCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAInvoiceAmountInDisplayCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAInvoiceAmountInDisplayCrcy;
    public final static SimpleProperty.NumericDecimal<BusPartInvoice> CA_INVOICE_AMOUNT_IN_DISPLAY_CRCY =
        new SimpleProperty.NumericDecimal<BusPartInvoice>(BusPartInvoice.class, "CAInvoiceAmountInDisplayCrcy");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpenAmountInDisplayCrcy</b>
     * </p>
     * 
     * @return The openAmountInDisplayCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "OpenAmountInDisplayCrcy" )
    @DecimalDescriptor( precision = 14, scale = 0 )
    private BigDecimal openAmountInDisplayCrcy;
    public final static SimpleProperty.NumericDecimal<BusPartInvoice> OPEN_AMOUNT_IN_DISPLAY_CRCY =
        new SimpleProperty.NumericDecimal<BusPartInvoice>(BusPartInvoice.class, "OpenAmountInDisplayCrcy");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmountInDspCrcy</b>
     * </p>
     * 
     * @return The cashDiscountAmountInDspCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CashDiscountAmountInDspCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cashDiscountAmountInDspCrcy;
    public final static SimpleProperty.NumericDecimal<BusPartInvoice> CASH_DISCOUNT_AMOUNT_IN_DSP_CRCY =
        new SimpleProperty.NumericDecimal<BusPartInvoice>(BusPartInvoice.class, "CashDiscountAmountInDspCrcy");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAEligibleAmountForCshDiscInDC</b>
     * </p>
     * 
     * @return The cAEligibleAmountForCshDiscInDC contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAEligibleAmountForCshDiscInDC" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAEligibleAmountForCshDiscInDC;
    public final static SimpleProperty.NumericDecimal<BusPartInvoice> CA_ELIGIBLE_AMOUNT_FOR_CSH_DISC_IN_DC =
        new SimpleProperty.NumericDecimal<BusPartInvoice>(BusPartInvoice.class, "CAEligibleAmountForCshDiscInDC");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInDisplayCurrency</b>
     * </p>
     * 
     * @return The cAReleasedAmtInDisplayCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAReleasedAmtInDisplayCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAReleasedAmtInDisplayCurrency;
    public final static SimpleProperty.NumericDecimal<BusPartInvoice> CA_RELEASED_AMT_IN_DISPLAY_CURRENCY =
        new SimpleProperty.NumericDecimal<BusPartInvoice>(BusPartInvoice.class, "CAReleasedAmtInDisplayCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingAmountInDisplayCrcy</b>
     * </p>
     * 
     * @return The cAClearingAmountInDisplayCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAClearingAmountInDisplayCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAClearingAmountInDisplayCrcy;
    public final static SimpleProperty.NumericDecimal<BusPartInvoice> CA_CLEARING_AMOUNT_IN_DISPLAY_CRCY =
        new SimpleProperty.NumericDecimal<BusPartInvoice>(BusPartInvoice.class, "CAClearingAmountInDisplayCrcy");
    /**
     * Navigation property <b>Parameters</b> for <b>BusPartInvoice</b> to single <b>BusPartInvoiceParameters</b>.
     * 
     */
    @ElementName( "Parameters" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusPartInvoiceParameters toParameters;
    /**
     * Navigation property <b>_BusPartInvoiceCorrespnc</b> for <b>BusPartInvoice</b> to multiple
     * <b>BusPartInvoiceCorrespnc</b>.
     * 
     */
    @ElementName( "_BusPartInvoiceCorrespnc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusPartInvoiceCorrespnc> to_BusPartInvoiceCorrespnc;
    /**
     * Use with available request builders to apply the <b>Parameters</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusPartInvoice, BusPartInvoiceParameters> TO_PARAMETERS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusPartInvoice, BusPartInvoiceParameters>(
            BusPartInvoice.class,
            "Parameters",
            BusPartInvoiceParameters.class);
    /**
     * Use with available request builders to apply the <b>_BusPartInvoiceCorrespnc</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<BusPartInvoice, BusPartInvoiceCorrespnc> TO__BUS_PART_INVOICE_CORRESPNC =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<BusPartInvoice, BusPartInvoiceCorrespnc>(
            BusPartInvoice.class,
            "_BusPartInvoiceCorrespnc",
            BusPartInvoiceCorrespnc.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BusPartInvoice> getType()
    {
        return BusPartInvoice.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerUUID</b>
     * </p>
     * 
     * @param cADocumentContainerUUID
     *            Document Container ID
     */
    public void setCADocumentContainerUUID( @Nullable final UUID cADocumentContainerUUID )
    {
        rememberChangedField("CADocumentContainerUUID", this.cADocumentContainerUUID);
        this.cADocumentContainerUUID = cADocumentContainerUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerInvoiceStatus</b>
     * </p>
     * 
     * @param cADocContainerInvoiceStatus
     *            Invoice Status
     */
    public void setCADocContainerInvoiceStatus( @Nullable final java.lang.String cADocContainerInvoiceStatus )
    {
        rememberChangedField("CADocContainerInvoiceStatus", this.cADocContainerInvoiceStatus);
        this.cADocContainerInvoiceStatus = cADocContainerInvoiceStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerInvoiceStatusTxt</b>
     * </p>
     * 
     * @param cADocContainerInvoiceStatusTxt
     *            Short Text for Fixed Values
     */
    public void setCADocContainerInvoiceStatusTxt( @Nullable final java.lang.String cADocContainerInvoiceStatusTxt )
    {
        rememberChangedField("CADocContainerInvoiceStatusTxt", this.cADocContainerInvoiceStatusTxt);
        this.cADocContainerInvoiceStatusTxt = cADocContainerInvoiceStatusTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefType</b>
     * </p>
     * 
     * @param cADocumentContainerRefType
     *            Document Container - Reference Type
     */
    public void setCADocumentContainerRefType( @Nullable final java.lang.String cADocumentContainerRefType )
    {
        rememberChangedField("CADocumentContainerRefType", this.cADocumentContainerRefType);
        this.cADocumentContainerRefType = cADocumentContainerRefType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefTypeText</b>
     * </p>
     * 
     * @param cADocumentContainerRefTypeText
     *            Reference Type of Document Conainer Text
     */
    public void setCADocumentContainerRefTypeText( @Nullable final java.lang.String cADocumentContainerRefTypeText )
    {
        rememberChangedField("CADocumentContainerRefTypeText", this.cADocumentContainerRefTypeText);
        this.cADocumentContainerRefTypeText = cADocumentContainerRefTypeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerReference</b>
     * </p>
     * 
     * @param cADocumentContainerReference
     *            Document Container - Identification for Reference Category
     */
    public void setCADocumentContainerReference( @Nullable final java.lang.String cADocumentContainerReference )
    {
        rememberChangedField("CADocumentContainerReference", this.cADocumentContainerReference);
        this.cADocumentContainerReference = cADocumentContainerReference;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Day On Which Accounting Document Was Entered
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @param creationTime
     *            Time of Entry
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisplayCurrency</b>
     * </p>
     * 
     * @param displayCurrency
     *            The displayCurrency to set.
     */
    public void setDisplayCurrency( @Nullable final java.lang.String displayCurrency )
    {
        rememberChangedField("DisplayCurrency", this.displayCurrency);
        this.displayCurrency = displayCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAInvoiceAmountInDisplayCrcy</b>
     * </p>
     * 
     * @param cAInvoiceAmountInDisplayCrcy
     *            The cAInvoiceAmountInDisplayCrcy to set.
     */
    public void setCAInvoiceAmountInDisplayCrcy( @Nullable final BigDecimal cAInvoiceAmountInDisplayCrcy )
    {
        rememberChangedField("CAInvoiceAmountInDisplayCrcy", this.cAInvoiceAmountInDisplayCrcy);
        this.cAInvoiceAmountInDisplayCrcy = cAInvoiceAmountInDisplayCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpenAmountInDisplayCrcy</b>
     * </p>
     * 
     * @param openAmountInDisplayCrcy
     *            The openAmountInDisplayCrcy to set.
     */
    public void setOpenAmountInDisplayCrcy( @Nullable final BigDecimal openAmountInDisplayCrcy )
    {
        rememberChangedField("OpenAmountInDisplayCrcy", this.openAmountInDisplayCrcy);
        this.openAmountInDisplayCrcy = openAmountInDisplayCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmountInDspCrcy</b>
     * </p>
     * 
     * @param cashDiscountAmountInDspCrcy
     *            The cashDiscountAmountInDspCrcy to set.
     */
    public void setCashDiscountAmountInDspCrcy( @Nullable final BigDecimal cashDiscountAmountInDspCrcy )
    {
        rememberChangedField("CashDiscountAmountInDspCrcy", this.cashDiscountAmountInDspCrcy);
        this.cashDiscountAmountInDspCrcy = cashDiscountAmountInDspCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAEligibleAmountForCshDiscInDC</b>
     * </p>
     * 
     * @param cAEligibleAmountForCshDiscInDC
     *            The cAEligibleAmountForCshDiscInDC to set.
     */
    public void setCAEligibleAmountForCshDiscInDC( @Nullable final BigDecimal cAEligibleAmountForCshDiscInDC )
    {
        rememberChangedField("CAEligibleAmountForCshDiscInDC", this.cAEligibleAmountForCshDiscInDC);
        this.cAEligibleAmountForCshDiscInDC = cAEligibleAmountForCshDiscInDC;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInDisplayCurrency</b>
     * </p>
     * 
     * @param cAReleasedAmtInDisplayCurrency
     *            The cAReleasedAmtInDisplayCurrency to set.
     */
    public void setCAReleasedAmtInDisplayCurrency( @Nullable final BigDecimal cAReleasedAmtInDisplayCurrency )
    {
        rememberChangedField("CAReleasedAmtInDisplayCurrency", this.cAReleasedAmtInDisplayCurrency);
        this.cAReleasedAmtInDisplayCurrency = cAReleasedAmtInDisplayCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingAmountInDisplayCrcy</b>
     * </p>
     * 
     * @param cAClearingAmountInDisplayCrcy
     *            The cAClearingAmountInDisplayCrcy to set.
     */
    public void setCAClearingAmountInDisplayCrcy( @Nullable final BigDecimal cAClearingAmountInDisplayCrcy )
    {
        rememberChangedField("CAClearingAmountInDisplayCrcy", this.cAClearingAmountInDisplayCrcy);
        this.cAClearingAmountInDisplayCrcy = cAClearingAmountInDisplayCrcy;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "Set";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentContainerUUID", getCADocumentContainerUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentContainerUUID", getCADocumentContainerUUID());
        values.put("CADocContainerInvoiceStatus", getCADocContainerInvoiceStatus());
        values.put("CADocContainerInvoiceStatusTxt", getCADocContainerInvoiceStatusTxt());
        values.put("CADocumentContainerRefType", getCADocumentContainerRefType());
        values.put("CADocumentContainerRefTypeText", getCADocumentContainerRefTypeText());
        values.put("CADocumentContainerReference", getCADocumentContainerReference());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("DisplayCurrency", getDisplayCurrency());
        values.put("CAInvoiceAmountInDisplayCrcy", getCAInvoiceAmountInDisplayCrcy());
        values.put("OpenAmountInDisplayCrcy", getOpenAmountInDisplayCrcy());
        values.put("CashDiscountAmountInDspCrcy", getCashDiscountAmountInDspCrcy());
        values.put("CAEligibleAmountForCshDiscInDC", getCAEligibleAmountForCshDiscInDC());
        values.put("CAReleasedAmtInDisplayCurrency", getCAReleasedAmtInDisplayCurrency());
        values.put("CAClearingAmountInDisplayCrcy", getCAClearingAmountInDisplayCrcy());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentContainerUUID") ) {
                final Object value = values.remove("CADocumentContainerUUID");
                if( (value == null) || (!value.equals(getCADocumentContainerUUID())) ) {
                    setCADocumentContainerUUID(((UUID) value));
                }
            }
            if( values.containsKey("CADocContainerInvoiceStatus") ) {
                final Object value = values.remove("CADocContainerInvoiceStatus");
                if( (value == null) || (!value.equals(getCADocContainerInvoiceStatus())) ) {
                    setCADocContainerInvoiceStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocContainerInvoiceStatusTxt") ) {
                final Object value = values.remove("CADocContainerInvoiceStatusTxt");
                if( (value == null) || (!value.equals(getCADocContainerInvoiceStatusTxt())) ) {
                    setCADocContainerInvoiceStatusTxt(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentContainerRefType") ) {
                final Object value = values.remove("CADocumentContainerRefType");
                if( (value == null) || (!value.equals(getCADocumentContainerRefType())) ) {
                    setCADocumentContainerRefType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentContainerRefTypeText") ) {
                final Object value = values.remove("CADocumentContainerRefTypeText");
                if( (value == null) || (!value.equals(getCADocumentContainerRefTypeText())) ) {
                    setCADocumentContainerRefTypeText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentContainerReference") ) {
                final Object value = values.remove("CADocumentContainerReference");
                if( (value == null) || (!value.equals(getCADocumentContainerReference())) ) {
                    setCADocumentContainerReference(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("DisplayCurrency") ) {
                final Object value = values.remove("DisplayCurrency");
                if( (value == null) || (!value.equals(getDisplayCurrency())) ) {
                    setDisplayCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAInvoiceAmountInDisplayCrcy") ) {
                final Object value = values.remove("CAInvoiceAmountInDisplayCrcy");
                if( (value == null) || (!value.equals(getCAInvoiceAmountInDisplayCrcy())) ) {
                    setCAInvoiceAmountInDisplayCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpenAmountInDisplayCrcy") ) {
                final Object value = values.remove("OpenAmountInDisplayCrcy");
                if( (value == null) || (!value.equals(getOpenAmountInDisplayCrcy())) ) {
                    setOpenAmountInDisplayCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscountAmountInDspCrcy") ) {
                final Object value = values.remove("CashDiscountAmountInDspCrcy");
                if( (value == null) || (!value.equals(getCashDiscountAmountInDspCrcy())) ) {
                    setCashDiscountAmountInDspCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAEligibleAmountForCshDiscInDC") ) {
                final Object value = values.remove("CAEligibleAmountForCshDiscInDC");
                if( (value == null) || (!value.equals(getCAEligibleAmountForCshDiscInDC())) ) {
                    setCAEligibleAmountForCshDiscInDC(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAReleasedAmtInDisplayCurrency") ) {
                final Object value = values.remove("CAReleasedAmtInDisplayCurrency");
                if( (value == null) || (!value.equals(getCAReleasedAmtInDisplayCurrency())) ) {
                    setCAReleasedAmtInDisplayCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAClearingAmountInDisplayCrcy") ) {
                final Object value = values.remove("CAClearingAmountInDisplayCrcy");
                if( (value == null) || (!value.equals(getCAClearingAmountInDisplayCrcy())) ) {
                    setCAClearingAmountInDisplayCrcy(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Parameters") ) {
                final Object value = (values).remove("Parameters");
                if( value instanceof Map ) {
                    if( toParameters == null ) {
                        toParameters = new BusPartInvoiceParameters();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    toParameters.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_BusPartInvoiceCorrespnc") ) {
                final Object value = (values).remove("_BusPartInvoiceCorrespnc");
                if( value instanceof Iterable ) {
                    if( to_BusPartInvoiceCorrespnc == null ) {
                        to_BusPartInvoiceCorrespnc = Lists.newArrayList();
                    } else {
                        to_BusPartInvoiceCorrespnc = Lists.newArrayList(to_BusPartInvoiceCorrespnc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusPartInvoiceCorrespnc entity;
                        if( to_BusPartInvoiceCorrespnc.size() > i ) {
                            entity = to_BusPartInvoiceCorrespnc.get(i);
                        } else {
                            entity = new BusPartInvoiceCorrespnc();
                            to_BusPartInvoiceCorrespnc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( toParameters != null ) {
            (values).put("Parameters", toParameters);
        }
        if( to_BusPartInvoiceCorrespnc != null ) {
            (values).put("_BusPartInvoiceCorrespnc", to_BusPartInvoiceCorrespnc);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>BusPartInvoiceParameters</b> entity (one to one). This corresponds to the OData
     * navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property for an entity <b>BusPartInvoice</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>Parameters</b> is already loaded, the result will contain
     *         the <b>BusPartInvoiceParameters</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusPartInvoiceParameters> getParametersIfPresent()
    {
        return Option.of(toParameters);
    }

    /**
     * Overwrites the associated <b>BusPartInvoiceParameters</b> entity for the loaded navigation property
     * <b>Parameters</b>.
     * 
     * @param value
     *            New <b>BusPartInvoiceParameters</b> entity.
     */
    public void setParameters( final BusPartInvoiceParameters value )
    {
        toParameters = value;
    }

    /**
     * Retrieval of associated <b>BusPartInvoiceCorrespnc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_BusPartInvoiceCorrespnc</b>.
     * <p>
     * If the navigation property for an entity <b>BusPartInvoice</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_BusPartInvoiceCorrespnc</b> is already loaded, the result
     *         will contain the <b>BusPartInvoiceCorrespnc</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusPartInvoiceCorrespnc>> getBusPartInvoiceCorrespncIfPresent()
    {
        return Option.of(to_BusPartInvoiceCorrespnc);
    }

    /**
     * Overwrites the list of associated <b>BusPartInvoiceCorrespnc</b> entities for the loaded navigation property
     * <b>_BusPartInvoiceCorrespnc</b>.
     * <p>
     * If the navigation property <b>_BusPartInvoiceCorrespnc</b> of a queried <b>BusPartInvoice</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>BusPartInvoiceCorrespnc</b> entities.
     */
    public void setBusPartInvoiceCorrespnc( @Nonnull final List<BusPartInvoiceCorrespnc> value )
    {
        if( to_BusPartInvoiceCorrespnc == null ) {
            to_BusPartInvoiceCorrespnc = Lists.newArrayList();
        }
        to_BusPartInvoiceCorrespnc.clear();
        to_BusPartInvoiceCorrespnc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusPartInvoiceCorrespnc</b> entities. This corresponds to the OData
     * navigation property <b>_BusPartInvoiceCorrespnc</b>.
     * <p>
     * If the navigation property <b>_BusPartInvoiceCorrespnc</b> of a queried <b>BusPartInvoice</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>BusPartInvoiceCorrespnc</b> entities.
     */
    public void addBusPartInvoiceCorrespnc( BusPartInvoiceCorrespnc... entity )
    {
        if( to_BusPartInvoiceCorrespnc == null ) {
            to_BusPartInvoiceCorrespnc = Lists.newArrayList();
        }
        to_BusPartInvoiceCorrespnc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusPartInvoice instances.
     * 
     */
    public final static class BusPartInvoiceBuilder
    {

        private BusPartInvoiceParameters toParameters;
        private List<BusPartInvoiceCorrespnc> to_BusPartInvoiceCorrespnc = Lists.newArrayList();

        private BusPartInvoice.BusPartInvoiceBuilder toParameters( final BusPartInvoiceParameters value )
        {
            toParameters = value;
            return this;
        }

        /**
         * Navigation property <b>Parameters</b> for <b>BusPartInvoice</b> to single <b>BusPartInvoiceParameters</b>.
         * 
         * @param value
         *            The BusPartInvoiceParameters to build this BusPartInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusPartInvoice.BusPartInvoiceBuilder parameters( final BusPartInvoiceParameters value )
        {
            return toParameters(value);
        }

        private BusPartInvoice.BusPartInvoiceBuilder to_BusPartInvoiceCorrespnc(
            final List<BusPartInvoiceCorrespnc> value )
        {
            to_BusPartInvoiceCorrespnc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_BusPartInvoiceCorrespnc</b> for <b>BusPartInvoice</b> to multiple
         * <b>BusPartInvoiceCorrespnc</b>.
         * 
         * @param value
         *            The BusPartInvoiceCorrespncs to build this BusPartInvoice with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusPartInvoice.BusPartInvoiceBuilder busPartInvoiceCorrespnc( BusPartInvoiceCorrespnc... value )
        {
            return to_BusPartInvoiceCorrespnc(Lists.newArrayList(value));
        }

    }

}
