/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice;

import java.net.URI;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingBusinessPartnerInvoiceService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>BusPartInvoiceCorrespncType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BusPartInvoiceCorrespnc extends VdmEntity<BusPartInvoiceCorrespnc> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_cabuspartinvoice.v0001.BusPartInvoiceCorrespncType";
    /**
     * Selector for all available fields of BusPartInvoiceCorrespnc.
     * 
     */
    public final static SimpleProperty<BusPartInvoiceCorrespnc> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerUUID</b>
     * </p>
     * 
     * @return Document Container ID
     */
    @Nullable
    @ElementName( "CADocumentContainerUUID" )
    private UUID cADocumentContainerUUID;
    public final static SimpleProperty.Guid<BusPartInvoiceCorrespnc> CA_DOCUMENT_CONTAINER_UUID =
        new SimpleProperty.Guid<BusPartInvoiceCorrespnc>(BusPartInvoiceCorrespnc.class, "CADocumentContainerUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CACorrespondenceType</b>
     * </p>
     * 
     * @return Correspondence Type
     */
    @Nullable
    @ElementName( "CACorrespondenceType" )
    private java.lang.String cACorrespondenceType;
    public final static SimpleProperty.String<BusPartInvoiceCorrespnc> CA_CORRESPONDENCE_TYPE =
        new SimpleProperty.String<BusPartInvoiceCorrespnc>(BusPartInvoiceCorrespnc.class, "CACorrespondenceType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>CACorrespondence</b>
     * </p>
     * 
     * @return Correspondence key
     */
    @Nullable
    @ElementName( "CACorrespondence" )
    private java.lang.String cACorrespondence;
    public final static SimpleProperty.String<BusPartInvoiceCorrespnc> CA_CORRESPONDENCE =
        new SimpleProperty.String<BusPartInvoiceCorrespnc>(BusPartInvoiceCorrespnc.class, "CACorrespondence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CADocCtnCorrespncSqncNumber</b>
     * </p>
     * 
     * @return Sequence Number
     */
    @Nullable
    @ElementName( "CADocCtnCorrespncSqncNumber" )
    private java.lang.String cADocCtnCorrespncSqncNumber;
    public final static SimpleProperty.String<BusPartInvoiceCorrespnc> CA_DOC_CTN_CORRESPNC_SQNC_NUMBER =
        new SimpleProperty.String<BusPartInvoiceCorrespnc>(
            BusPartInvoiceCorrespnc.class,
            "CADocCtnCorrespncSqncNumber");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondencePrintDate</b>
     * </p>
     * 
     * @return Print Date
     */
    @Nullable
    @ElementName( "CorrespondencePrintDate" )
    private LocalDate correspondencePrintDate;
    public final static SimpleProperty.Date<BusPartInvoiceCorrespnc> CORRESPONDENCE_PRINT_DATE =
        new SimpleProperty.Date<BusPartInvoiceCorrespnc>(BusPartInvoiceCorrespnc.class, "CorrespondencePrintDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceCreationDate</b>
     * </p>
     * 
     * @return Day On Which Accounting Document Was Entered
     */
    @Nullable
    @ElementName( "CorrespondenceCreationDate" )
    private LocalDate correspondenceCreationDate;
    public final static SimpleProperty.Date<BusPartInvoiceCorrespnc> CORRESPONDENCE_CREATION_DATE =
        new SimpleProperty.Date<BusPartInvoiceCorrespnc>(BusPartInvoiceCorrespnc.class, "CorrespondenceCreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceCreationTime</b>
     * </p>
     * 
     * @return Time of Entry
     */
    @Nullable
    @ElementName( "CorrespondenceCreationTime" )
    private LocalTime correspondenceCreationTime;
    public final static SimpleProperty.Time<BusPartInvoiceCorrespnc> CORRESPONDENCE_CREATION_TIME =
        new SimpleProperty.Time<BusPartInvoiceCorrespnc>(BusPartInvoiceCorrespnc.class, "CorrespondenceCreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 1255
     * <p>
     * Original property name from the Odata EDM: <b>MimeType</b>
     * </p>
     * 
     * @return The mimeType contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "MimeType" )
    private java.lang.String mimeType;
    public final static SimpleProperty.String<BusPartInvoiceCorrespnc> MIME_TYPE =
        new SimpleProperty.String<BusPartInvoiceCorrespnc>(BusPartInvoiceCorrespnc.class, "MimeType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CACorrespondenceBinary</b>
     * </p>
     * 
     * @return Form Processing: Content from XFT, XFD, PDF, and so on
     */
    @Nullable
    @ElementName( "CACorrespondenceBinary" )
    private URI cACorrespondenceBinary;
    /**
     * Navigation property <b>_BusPartInvoice</b> for <b>BusPartInvoiceCorrespnc</b> to single <b>BusPartInvoice</b>.
     * 
     */
    @ElementName( "_BusPartInvoice" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusPartInvoice to_BusPartInvoice;
    /**
     * Use with available request builders to apply the <b>_BusPartInvoice</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusPartInvoiceCorrespnc, BusPartInvoice> TO__BUS_PART_INVOICE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusPartInvoiceCorrespnc, BusPartInvoice>(
            BusPartInvoiceCorrespnc.class,
            "_BusPartInvoice",
            BusPartInvoice.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BusPartInvoiceCorrespnc> getType()
    {
        return BusPartInvoiceCorrespnc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerUUID</b>
     * </p>
     * 
     * @param cADocumentContainerUUID
     *            Document Container ID
     */
    public void setCADocumentContainerUUID( @Nullable final UUID cADocumentContainerUUID )
    {
        rememberChangedField("CADocumentContainerUUID", this.cADocumentContainerUUID);
        this.cADocumentContainerUUID = cADocumentContainerUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CACorrespondenceType</b>
     * </p>
     * 
     * @param cACorrespondenceType
     *            Correspondence Type
     */
    public void setCACorrespondenceType( @Nullable final java.lang.String cACorrespondenceType )
    {
        rememberChangedField("CACorrespondenceType", this.cACorrespondenceType);
        this.cACorrespondenceType = cACorrespondenceType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>CACorrespondence</b>
     * </p>
     * 
     * @param cACorrespondence
     *            Correspondence key
     */
    public void setCACorrespondence( @Nullable final java.lang.String cACorrespondence )
    {
        rememberChangedField("CACorrespondence", this.cACorrespondence);
        this.cACorrespondence = cACorrespondence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CADocCtnCorrespncSqncNumber</b>
     * </p>
     * 
     * @param cADocCtnCorrespncSqncNumber
     *            Sequence Number
     */
    public void setCADocCtnCorrespncSqncNumber( @Nullable final java.lang.String cADocCtnCorrespncSqncNumber )
    {
        rememberChangedField("CADocCtnCorrespncSqncNumber", this.cADocCtnCorrespncSqncNumber);
        this.cADocCtnCorrespncSqncNumber = cADocCtnCorrespncSqncNumber;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondencePrintDate</b>
     * </p>
     * 
     * @param correspondencePrintDate
     *            Print Date
     */
    public void setCorrespondencePrintDate( @Nullable final LocalDate correspondencePrintDate )
    {
        rememberChangedField("CorrespondencePrintDate", this.correspondencePrintDate);
        this.correspondencePrintDate = correspondencePrintDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceCreationDate</b>
     * </p>
     * 
     * @param correspondenceCreationDate
     *            Day On Which Accounting Document Was Entered
     */
    public void setCorrespondenceCreationDate( @Nullable final LocalDate correspondenceCreationDate )
    {
        rememberChangedField("CorrespondenceCreationDate", this.correspondenceCreationDate);
        this.correspondenceCreationDate = correspondenceCreationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceCreationTime</b>
     * </p>
     * 
     * @param correspondenceCreationTime
     *            Time of Entry
     */
    public void setCorrespondenceCreationTime( @Nullable final LocalTime correspondenceCreationTime )
    {
        rememberChangedField("CorrespondenceCreationTime", this.correspondenceCreationTime);
        this.correspondenceCreationTime = correspondenceCreationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1255
     * <p>
     * Original property name from the Odata EDM: <b>MimeType</b>
     * </p>
     * 
     * @param mimeType
     *            The mimeType to set.
     */
    public void setMimeType( @Nullable final java.lang.String mimeType )
    {
        rememberChangedField("MimeType", this.mimeType);
        this.mimeType = mimeType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CACorrespondenceBinary</b>
     * </p>
     * 
     * @param cACorrespondenceBinary
     *            Form Processing: Content from XFT, XFD, PDF, and so on
     */
    public void setCACorrespondenceBinary( @Nullable final URI cACorrespondenceBinary )
    {
        rememberChangedField("CACorrespondenceBinary", this.cACorrespondenceBinary);
        this.cACorrespondenceBinary = cACorrespondenceBinary;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "BusPartInvoiceCorrespnc";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentContainerUUID", getCADocumentContainerUUID());
        entityKey.addKeyProperty("CACorrespondenceType", getCACorrespondenceType());
        entityKey.addKeyProperty("CACorrespondence", getCACorrespondence());
        entityKey.addKeyProperty("CADocCtnCorrespncSqncNumber", getCADocCtnCorrespncSqncNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentContainerUUID", getCADocumentContainerUUID());
        values.put("CACorrespondenceType", getCACorrespondenceType());
        values.put("CACorrespondence", getCACorrespondence());
        values.put("CADocCtnCorrespncSqncNumber", getCADocCtnCorrespncSqncNumber());
        values.put("CorrespondencePrintDate", getCorrespondencePrintDate());
        values.put("CorrespondenceCreationDate", getCorrespondenceCreationDate());
        values.put("CorrespondenceCreationTime", getCorrespondenceCreationTime());
        values.put("MimeType", getMimeType());
        values.put("CACorrespondenceBinary", getCACorrespondenceBinary());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentContainerUUID") ) {
                final Object value = values.remove("CADocumentContainerUUID");
                if( (value == null) || (!value.equals(getCADocumentContainerUUID())) ) {
                    setCADocumentContainerUUID(((UUID) value));
                }
            }
            if( values.containsKey("CACorrespondenceType") ) {
                final Object value = values.remove("CACorrespondenceType");
                if( (value == null) || (!value.equals(getCACorrespondenceType())) ) {
                    setCACorrespondenceType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACorrespondence") ) {
                final Object value = values.remove("CACorrespondence");
                if( (value == null) || (!value.equals(getCACorrespondence())) ) {
                    setCACorrespondence(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocCtnCorrespncSqncNumber") ) {
                final Object value = values.remove("CADocCtnCorrespncSqncNumber");
                if( (value == null) || (!value.equals(getCADocCtnCorrespncSqncNumber())) ) {
                    setCADocCtnCorrespncSqncNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CorrespondencePrintDate") ) {
                final Object value = values.remove("CorrespondencePrintDate");
                if( (value == null) || (!value.equals(getCorrespondencePrintDate())) ) {
                    setCorrespondencePrintDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CorrespondenceCreationDate") ) {
                final Object value = values.remove("CorrespondenceCreationDate");
                if( (value == null) || (!value.equals(getCorrespondenceCreationDate())) ) {
                    setCorrespondenceCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CorrespondenceCreationTime") ) {
                final Object value = values.remove("CorrespondenceCreationTime");
                if( (value == null) || (!value.equals(getCorrespondenceCreationTime())) ) {
                    setCorrespondenceCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MimeType") ) {
                final Object value = values.remove("MimeType");
                if( (value == null) || (!value.equals(getMimeType())) ) {
                    setMimeType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACorrespondenceBinary") ) {
                final Object value = values.remove("CACorrespondenceBinary");
                if( (value == null) || (!value.equals(getCACorrespondenceBinary())) ) {
                    setCACorrespondenceBinary(((URI) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_BusPartInvoice") ) {
                final Object value = (values).remove("_BusPartInvoice");
                if( value instanceof Map ) {
                    if( to_BusPartInvoice == null ) {
                        to_BusPartInvoice = new BusPartInvoice();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_BusPartInvoice.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingBusinessPartnerInvoiceService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_BusPartInvoice != null ) {
            (values).put("_BusPartInvoice", to_BusPartInvoice);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>BusPartInvoice</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_BusPartInvoice</b>.
     * <p>
     * If the navigation property for an entity <b>BusPartInvoiceCorrespnc</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_BusPartInvoice</b> is already loaded, the result will
     *         contain the <b>BusPartInvoice</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusPartInvoice> getBusPartInvoiceIfPresent()
    {
        return Option.of(to_BusPartInvoice);
    }

    /**
     * Overwrites the associated <b>BusPartInvoice</b> entity for the loaded navigation property <b>_BusPartInvoice</b>.
     * 
     * @param value
     *            New <b>BusPartInvoice</b> entity.
     */
    public void setBusPartInvoice( final BusPartInvoice value )
    {
        to_BusPartInvoice = value;
    }

    /**
     * Helper class to allow for fluent creation of BusPartInvoiceCorrespnc instances.
     * 
     */
    public final static class BusPartInvoiceCorrespncBuilder
    {

        private BusPartInvoice to_BusPartInvoice;

        private BusPartInvoiceCorrespnc.BusPartInvoiceCorrespncBuilder to_BusPartInvoice( final BusPartInvoice value )
        {
            to_BusPartInvoice = value;
            return this;
        }

        /**
         * Navigation property <b>_BusPartInvoice</b> for <b>BusPartInvoiceCorrespnc</b> to single
         * <b>BusPartInvoice</b>.
         * 
         * @param value
         *            The BusPartInvoice to build this BusPartInvoiceCorrespnc with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusPartInvoiceCorrespnc.BusPartInvoiceCorrespncBuilder busPartInvoice( final BusPartInvoice value )
        {
            return to_BusPartInvoice(value);
        }

    }

}
