/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.result.ElementName;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>BusPartInvoiceItemType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BusPartInvoiceItem extends VdmEntity<BusPartInvoiceItem>
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_cabuspartinvoice.v0001.BusPartInvoiceItemType";
    /**
     * Selector for all available fields of BusPartInvoiceItem.
     * 
     */
    public final static SimpleProperty<BusPartInvoiceItem> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerUUID</b>
     * </p>
     * 
     * @return Document Container ID
     */
    @Nullable
    @ElementName( "CADocumentContainerUUID" )
    private UUID cADocumentContainerUUID;
    public final static SimpleProperty.Guid<BusPartInvoiceItem> CA_DOCUMENT_CONTAINER_UUID =
        new SimpleProperty.Guid<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocumentContainerUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerSqncNumber</b>
     * </p>
     * 
     * @return Sequence Number
     */
    @Nullable
    @ElementName( "CADocumentContainerSqncNumber" )
    private java.lang.String cADocumentContainerSqncNumber;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOCUMENT_CONTAINER_SQNC_NUMBER =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocumentContainerSqncNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerInvoiceItmStatus</b>
     * </p>
     * 
     * @return Status of Item of an Invoice
     */
    @Nullable
    @ElementName( "CADocContainerInvoiceItmStatus" )
    private java.lang.String cADocContainerInvoiceItmStatus;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOC_CONTAINER_INVOICE_ITM_STATUS =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocContainerInvoiceItmStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerInvoiceItmStsTxt</b>
     * </p>
     * 
     * @return Short Text for Fixed Values
     */
    @Nullable
    @ElementName( "CADocContainerInvoiceItmStsTxt" )
    private java.lang.String cADocContainerInvoiceItmStsTxt;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOC_CONTAINER_INVOICE_ITM_STS_TXT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocContainerInvoiceItmStsTxt");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefType</b>
     * </p>
     * 
     * @return Document Container - Reference Type
     */
    @Nullable
    @ElementName( "CADocumentContainerRefType" )
    private java.lang.String cADocumentContainerRefType;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOCUMENT_CONTAINER_REF_TYPE =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocumentContainerRefType");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefTypeText</b>
     * </p>
     * 
     * @return Reference Type of Document Conainer Text
     */
    @Nullable
    @ElementName( "CADocumentContainerRefTypeText" )
    private java.lang.String cADocumentContainerRefTypeText;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOCUMENT_CONTAINER_REF_TYPE_TEXT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocumentContainerRefTypeText");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerReference</b>
     * </p>
     * 
     * @return Document Container - Identification for Reference Category
     */
    @Nullable
    @ElementName( "CADocumentContainerReference" )
    private java.lang.String cADocumentContainerReference;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOCUMENT_CONTAINER_REFERENCE =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocumentContainerReference");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Day On Which Accounting Document Was Entered
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<BusPartInvoiceItem> CREATION_DATE =
        new SimpleProperty.Date<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @return Time of Entry
     */
    @Nullable
    @ElementName( "CreationTime" )
    private LocalTime creationTime;
    public final static SimpleProperty.Time<BusPartInvoiceItem> CREATION_TIME =
        new SimpleProperty.Time<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocument</b>
     * </p>
     * 
     * @return Document
     */
    @Nullable
    @ElementName( "CADocument" )
    private java.lang.String cADocument;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOCUMENT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocument");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CARepetitionItemNumber</b>
     * </p>
     * 
     * @return Repetition Item in FI-CA Document
     */
    @Nullable
    @ElementName( "CARepetitionItemNumber" )
    private java.lang.String cARepetitionItemNumber;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_REPETITION_ITEM_NUMBER =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CARepetitionItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CABPItemNumber</b>
     * </p>
     * 
     * @return Item Number in FI-CA Document
     */
    @Nullable
    @ElementName( "CABPItemNumber" )
    private java.lang.String cABPItemNumber;
    public final static SimpleProperty.String<BusPartInvoiceItem> CABP_ITEM_NUMBER =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CABPItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @return Business Partner Number
     */
    @Nullable
    @ElementName( "BusinessPartner" )
    private java.lang.String businessPartner;
    public final static SimpleProperty.String<BusPartInvoiceItem> BUSINESS_PARTNER =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFullName</b>
     * </p>
     * 
     * @return The businessPartnerFullName contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "BusinessPartnerFullName" )
    private java.lang.String businessPartnerFullName;
    public final static SimpleProperty.String<BusPartInvoiceItem> BUSINESS_PARTNER_FULL_NAME =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "BusinessPartnerFullName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @return Contract Account
     */
    @Nullable
    @ElementName( "ContractAccount" )
    private java.lang.String contractAccount;
    public final static SimpleProperty.String<BusPartInvoiceItem> CONTRACT_ACCOUNT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "ContractAccount");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccountName</b>
     * </p>
     * 
     * @return Description of Contract Account
     */
    @Nullable
    @ElementName( "ContractAccountName" )
    private java.lang.String contractAccountName;
    public final static SimpleProperty.String<BusPartInvoiceItem> CONTRACT_ACCOUNT_NAME =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "ContractAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAContract</b>
     * </p>
     * 
     * @return Reference Specifications from Contract
     */
    @Nullable
    @ElementName( "CAContract" )
    private java.lang.String cAContract;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_CONTRACT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAContract");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplication</b>
     * </p>
     * 
     * @return Subapplication in Contract Accounts Receivable and Payable
     */
    @Nullable
    @ElementName( "CASubApplication" )
    private java.lang.String cASubApplication;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_SUB_APPLICATION =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CASubApplication");
    /**
     * Constraints: Not nullable, Maximum length: 250
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplicationText</b>
     * </p>
     * 
     * @return Description (250 Characters)
     */
    @Nullable
    @ElementName( "CASubApplicationText" )
    private java.lang.String cASubApplicationText;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_SUB_APPLICATION_TEXT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CASubApplicationText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<BusPartInvoiceItem> COMPANY_CODE =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     * 
     * @return Name of Company Code or Company
     */
    @Nullable
    @ElementName( "CompanyCodeName" )
    private java.lang.String companyCodeName;
    public final static SimpleProperty.String<BusPartInvoiceItem> COMPANY_CODE_NAME =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CompanyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CAReferenceDocument</b>
     * </p>
     * 
     * @return Reference Document Number
     */
    @Nullable
    @ElementName( "CAReferenceDocument" )
    private java.lang.String cAReferenceDocument;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_REFERENCE_DOCUMENT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCode</b>
     * </p>
     * 
     * @return Document Origin Key
     */
    @Nullable
    @ElementName( "CADocumentOriginCode" )
    private java.lang.String cADocumentOriginCode;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOCUMENT_ORIGIN_CODE =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocumentOriginCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCodeName</b>
     * </p>
     * 
     * @return Description of Document Origin
     */
    @Nullable
    @ElementName( "CADocumentOriginCodeName" )
    private java.lang.String cADocumentOriginCodeName;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOCUMENT_ORIGIN_CODE_NAME =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocumentOriginCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentType</b>
     * </p>
     * 
     * @return Document Type
     */
    @Nullable
    @ElementName( "CADocumentType" )
    private java.lang.String cADocumentType;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOCUMENT_TYPE =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentTypeName</b>
     * </p>
     * 
     * @return Document Type Description
     */
    @Nullable
    @ElementName( "CADocumentTypeName" )
    private java.lang.String cADocumentTypeName;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_DOCUMENT_TYPE_NAME =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADocumentTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     * 
     * @return Reference Document Type
     */
    @Nullable
    @ElementName( "ReferenceDocumentType" )
    private java.lang.String referenceDocumentType;
    public final static SimpleProperty.String<BusPartInvoiceItem> REFERENCE_DOCUMENT_TYPE =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OriginalReferenceDocument</b>
     * </p>
     * 
     * @return Object key
     */
    @Nullable
    @ElementName( "OriginalReferenceDocument" )
    private java.lang.String originalReferenceDocument;
    public final static SimpleProperty.String<BusPartInvoiceItem> ORIGINAL_REFERENCE_DOCUMENT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "OriginalReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     * 
     * @return Logical system of source document
     */
    @Nullable
    @ElementName( "LogicalSystem" )
    private java.lang.String logicalSystem;
    public final static SimpleProperty.String<BusPartInvoiceItem> LOGICAL_SYSTEM =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CABPItemText</b>
     * </p>
     * 
     * @return The cABPItemText contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CABPItemText" )
    private java.lang.String cABPItemText;
    public final static SimpleProperty.String<BusPartInvoiceItem> CABP_ITEM_TEXT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CABPItemText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     * 
     * @return The businessArea contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "BusinessArea" )
    private java.lang.String businessArea;
    public final static SimpleProperty.String<BusPartInvoiceItem> BUSINESS_AREA =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     * 
     * @return Business Area Description
     */
    @Nullable
    @ElementName( "BusinessAreaName" )
    private java.lang.String businessAreaName;
    public final static SimpleProperty.String<BusPartInvoiceItem> BUSINESS_AREA_NAME =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "BusinessAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     * 
     * @return The segment contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "Segment" )
    private java.lang.String segment;
    public final static SimpleProperty.String<BusPartInvoiceItem> SEGMENT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "Segment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SegmentName</b>
     * </p>
     * 
     * @return Segment Name
     */
    @Nullable
    @ElementName( "SegmentName" )
    private java.lang.String segmentName;
    public final static SimpleProperty.String<BusPartInvoiceItem> SEGMENT_NAME =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "SegmentName");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscountRate</b>
     * </p>
     * 
     * @return The cACashDiscountRate contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CACashDiscountRate" )
    @DecimalDescriptor( precision = 5, scale = 3 )
    private BigDecimal cACashDiscountRate;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> CA_CASH_DISCOUNT_RATE =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CACashDiscountRate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingForPayment</b>
     * </p>
     * 
     * @return The cAGroupingForPayment contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAGroupingForPayment" )
    private java.lang.String cAGroupingForPayment;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_GROUPING_FOR_PAYMENT =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAGroupingForPayment");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAMainTransaction</b>
     * </p>
     * 
     * @return The cAMainTransaction contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAMainTransaction" )
    private java.lang.String cAMainTransaction;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_MAIN_TRANSACTION =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAMainTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CAMainTransactionName</b>
     * </p>
     * 
     * @return Name of Main Transaction
     */
    @Nullable
    @ElementName( "CAMainTransactionName" )
    private java.lang.String cAMainTransactionName;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_MAIN_TRANSACTION_NAME =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAMainTransactionName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CASubTransaction</b>
     * </p>
     * 
     * @return The cASubTransaction contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CASubTransaction" )
    private java.lang.String cASubTransaction;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_SUB_TRANSACTION =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CASubTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CASubTransactionName</b>
     * </p>
     * 
     * @return Name of Subtransaction
     */
    @Nullable
    @ElementName( "CASubTransactionName" )
    private java.lang.String cASubTransactionName;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_SUB_TRANSACTION_NAME =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CASubTransactionName");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountBaseAmtIsNetAmt</b>
     * </p>
     * 
     * @return Indicator: Discount base amount is the net value
     */
    @Nullable
    @ElementName( "CashDiscountBaseAmtIsNetAmt" )
    private java.lang.Boolean cashDiscountBaseAmtIsNetAmt;
    public final static SimpleProperty.Boolean<BusPartInvoiceItem> CASH_DISCOUNT_BASE_AMT_IS_NET_AMT =
        new SimpleProperty.Boolean<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CashDiscountBaseAmtIsNetAmt");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingReason</b>
     * </p>
     * 
     * @return The cAClearingReason contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAClearingReason" )
    private java.lang.String cAClearingReason;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_CLEARING_REASON =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAClearingReason");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingReasonName</b>
     * </p>
     * 
     * @return Name
     */
    @Nullable
    @ElementName( "CAClearingReasonName" )
    private java.lang.String cAClearingReasonName;
    public final static SimpleProperty.String<BusPartInvoiceItem> CA_CLEARING_REASON_NAME =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAClearingReasonName");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     * 
     * @return The documentDate contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "DocumentDate" )
    private LocalDate documentDate;
    public final static SimpleProperty.Date<BusPartInvoiceItem> DOCUMENT_DATE =
        new SimpleProperty.Date<BusPartInvoiceItem>(BusPartInvoiceItem.class, "DocumentDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDate</b>
     * </p>
     * 
     * @return The cAPostingDate contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAPostingDate" )
    private LocalDate cAPostingDate;
    public final static SimpleProperty.Date<BusPartInvoiceItem> CA_POSTING_DATE =
        new SimpleProperty.Date<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAPostingDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CANetDueDate</b>
     * </p>
     * 
     * @return The cANetDueDate contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CANetDueDate" )
    private LocalDate cANetDueDate;
    public final static SimpleProperty.Date<BusPartInvoiceItem> CA_NET_DUE_DATE =
        new SimpleProperty.Date<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CANetDueDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADeferralDate</b>
     * </p>
     * 
     * @return The cADeferralDate contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CADeferralDate" )
    private LocalDate cADeferralDate;
    public final static SimpleProperty.Date<BusPartInvoiceItem> CA_DEFERRAL_DATE =
        new SimpleProperty.Date<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CADeferralDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscountDueDate</b>
     * </p>
     * 
     * @return The cACashDiscountDueDate contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CACashDiscountDueDate" )
    private LocalDate cACashDiscountDueDate;
    public final static SimpleProperty.Date<BusPartInvoiceItem> CA_CASH_DISCOUNT_DUE_DATE =
        new SimpleProperty.Date<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CACashDiscountDueDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAValueDateForClearing</b>
     * </p>
     * 
     * @return The cAValueDateForClearing contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAValueDateForClearing" )
    private LocalDate cAValueDateForClearing;
    public final static SimpleProperty.Date<BusPartInvoiceItem> CA_VALUE_DATE_FOR_CLEARING =
        new SimpleProperty.Date<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAValueDateForClearing");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingDate</b>
     * </p>
     * 
     * @return The cAClearingDate contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAClearingDate" )
    private LocalDate cAClearingDate;
    public final static SimpleProperty.Date<BusPartInvoiceItem> CA_CLEARING_DATE =
        new SimpleProperty.Date<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAClearingDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     * 
     * @return The exchangeRateDate contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ExchangeRateDate" )
    private LocalDate exchangeRateDate;
    public final static SimpleProperty.Date<BusPartInvoiceItem> EXCHANGE_RATE_DATE =
        new SimpleProperty.Date<BusPartInvoiceItem>(BusPartInvoiceItem.class, "ExchangeRateDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @return Transaction Currency
     */
    @Nullable
    @ElementName( "TransactionCurrency" )
    private java.lang.String transactionCurrency;
    public final static SimpleProperty.String<BusPartInvoiceItem> TRANSACTION_CURRENCY =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @return The cAAmountInTransactionCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInTransactionCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInTransactionCurrency;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> CA_AMOUNT_IN_TRANSACTION_CURRENCY =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(
            BusPartInvoiceItem.class,
            "CAAmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAOpenAmountInTransactionCrcy</b>
     * </p>
     * 
     * @return The cAOpenAmountInTransactionCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAOpenAmountInTransactionCrcy" )
    @DecimalDescriptor( precision = 14, scale = 0 )
    private BigDecimal cAOpenAmountInTransactionCrcy;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> CA_OPEN_AMOUNT_IN_TRANSACTION_CRCY =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(
            BusPartInvoiceItem.class,
            "CAOpenAmountInTransactionCrcy");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscountAmtInTransCrcy</b>
     * </p>
     * 
     * @return The cACashDiscountAmtInTransCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CACashDiscountAmtInTransCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cACashDiscountAmtInTransCrcy;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> CA_CASH_DISCOUNT_AMT_IN_TRANS_CRCY =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CACashDiscountAmtInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAEligibleAmountForCshDiscInTC</b>
     * </p>
     * 
     * @return The cAEligibleAmountForCshDiscInTC contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAEligibleAmountForCshDiscInTC" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAEligibleAmountForCshDiscInTC;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> CA_ELIGIBLE_AMOUNT_FOR_CSH_DISC_IN_TC =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(
            BusPartInvoiceItem.class,
            "CAEligibleAmountForCshDiscInTC");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInTransCurrency</b>
     * </p>
     * 
     * @return The cAReleasedAmtInTransCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAReleasedAmtInTransCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAReleasedAmtInTransCurrency;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> CA_RELEASED_AMT_IN_TRANS_CURRENCY =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CAReleasedAmtInTransCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisplayCurrency</b>
     * </p>
     * 
     * @return The displayCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "DisplayCurrency" )
    private java.lang.String displayCurrency;
    public final static SimpleProperty.String<BusPartInvoiceItem> DISPLAY_CURRENCY =
        new SimpleProperty.String<BusPartInvoiceItem>(BusPartInvoiceItem.class, "DisplayCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AmountInDisplayCurrency</b>
     * </p>
     * 
     * @return The amountInDisplayCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "AmountInDisplayCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal amountInDisplayCurrency;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> AMOUNT_IN_DISPLAY_CURRENCY =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(BusPartInvoiceItem.class, "AmountInDisplayCurrency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpenAmountInDisplayCrcy</b>
     * </p>
     * 
     * @return The openAmountInDisplayCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "OpenAmountInDisplayCrcy" )
    @DecimalDescriptor( precision = 14, scale = 0 )
    private BigDecimal openAmountInDisplayCrcy;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> OPEN_AMOUNT_IN_DISPLAY_CRCY =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(BusPartInvoiceItem.class, "OpenAmountInDisplayCrcy");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmountInDspCrcy</b>
     * </p>
     * 
     * @return The cashDiscountAmountInDspCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CashDiscountAmountInDspCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cashDiscountAmountInDspCrcy;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> CASH_DISCOUNT_AMOUNT_IN_DSP_CRCY =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(BusPartInvoiceItem.class, "CashDiscountAmountInDspCrcy");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAEligibleAmountForCshDiscInDC</b>
     * </p>
     * 
     * @return The cAEligibleAmountForCshDiscInDC contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAEligibleAmountForCshDiscInDC" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAEligibleAmountForCshDiscInDC;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> CA_ELIGIBLE_AMOUNT_FOR_CSH_DISC_IN_DC =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(
            BusPartInvoiceItem.class,
            "CAEligibleAmountForCshDiscInDC");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInDisplayCurrency</b>
     * </p>
     * 
     * @return The cAReleasedAmtInDisplayCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAReleasedAmtInDisplayCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAReleasedAmtInDisplayCurrency;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> CA_RELEASED_AMT_IN_DISPLAY_CURRENCY =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(
            BusPartInvoiceItem.class,
            "CAReleasedAmtInDisplayCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingAmountInDisplayCrcy</b>
     * </p>
     * 
     * @return The cAClearingAmountInDisplayCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAClearingAmountInDisplayCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAClearingAmountInDisplayCrcy;
    public final static SimpleProperty.NumericDecimal<BusPartInvoiceItem> CA_CLEARING_AMOUNT_IN_DISPLAY_CRCY =
        new SimpleProperty.NumericDecimal<BusPartInvoiceItem>(
            BusPartInvoiceItem.class,
            "CAClearingAmountInDisplayCrcy");
    /**
     * Navigation property <b>Parameters</b> for <b>BusPartInvoiceItem</b> to single
     * <b>BusPartInvoiceItemParameters</b>.
     * 
     */
    @ElementName( "Parameters" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusPartInvoiceItemParameters toParameters;
    /**
     * Use with available request builders to apply the <b>Parameters</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusPartInvoiceItem, BusPartInvoiceItemParameters> TO_PARAMETERS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusPartInvoiceItem, BusPartInvoiceItemParameters>(
            BusPartInvoiceItem.class,
            "Parameters",
            BusPartInvoiceItemParameters.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BusPartInvoiceItem> getType()
    {
        return BusPartInvoiceItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerUUID</b>
     * </p>
     * 
     * @param cADocumentContainerUUID
     *            Document Container ID
     */
    public void setCADocumentContainerUUID( @Nullable final UUID cADocumentContainerUUID )
    {
        rememberChangedField("CADocumentContainerUUID", this.cADocumentContainerUUID);
        this.cADocumentContainerUUID = cADocumentContainerUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerSqncNumber</b>
     * </p>
     * 
     * @param cADocumentContainerSqncNumber
     *            Sequence Number
     */
    public void setCADocumentContainerSqncNumber( @Nullable final java.lang.String cADocumentContainerSqncNumber )
    {
        rememberChangedField("CADocumentContainerSqncNumber", this.cADocumentContainerSqncNumber);
        this.cADocumentContainerSqncNumber = cADocumentContainerSqncNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerInvoiceItmStatus</b>
     * </p>
     * 
     * @param cADocContainerInvoiceItmStatus
     *            Status of Item of an Invoice
     */
    public void setCADocContainerInvoiceItmStatus( @Nullable final java.lang.String cADocContainerInvoiceItmStatus )
    {
        rememberChangedField("CADocContainerInvoiceItmStatus", this.cADocContainerInvoiceItmStatus);
        this.cADocContainerInvoiceItmStatus = cADocContainerInvoiceItmStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerInvoiceItmStsTxt</b>
     * </p>
     * 
     * @param cADocContainerInvoiceItmStsTxt
     *            Short Text for Fixed Values
     */
    public void setCADocContainerInvoiceItmStsTxt( @Nullable final java.lang.String cADocContainerInvoiceItmStsTxt )
    {
        rememberChangedField("CADocContainerInvoiceItmStsTxt", this.cADocContainerInvoiceItmStsTxt);
        this.cADocContainerInvoiceItmStsTxt = cADocContainerInvoiceItmStsTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefType</b>
     * </p>
     * 
     * @param cADocumentContainerRefType
     *            Document Container - Reference Type
     */
    public void setCADocumentContainerRefType( @Nullable final java.lang.String cADocumentContainerRefType )
    {
        rememberChangedField("CADocumentContainerRefType", this.cADocumentContainerRefType);
        this.cADocumentContainerRefType = cADocumentContainerRefType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefTypeText</b>
     * </p>
     * 
     * @param cADocumentContainerRefTypeText
     *            Reference Type of Document Conainer Text
     */
    public void setCADocumentContainerRefTypeText( @Nullable final java.lang.String cADocumentContainerRefTypeText )
    {
        rememberChangedField("CADocumentContainerRefTypeText", this.cADocumentContainerRefTypeText);
        this.cADocumentContainerRefTypeText = cADocumentContainerRefTypeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerReference</b>
     * </p>
     * 
     * @param cADocumentContainerReference
     *            Document Container - Identification for Reference Category
     */
    public void setCADocumentContainerReference( @Nullable final java.lang.String cADocumentContainerReference )
    {
        rememberChangedField("CADocumentContainerReference", this.cADocumentContainerReference);
        this.cADocumentContainerReference = cADocumentContainerReference;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Day On Which Accounting Document Was Entered
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @param creationTime
     *            Time of Entry
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocument</b>
     * </p>
     * 
     * @param cADocument
     *            Document
     */
    public void setCADocument( @Nullable final java.lang.String cADocument )
    {
        rememberChangedField("CADocument", this.cADocument);
        this.cADocument = cADocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CARepetitionItemNumber</b>
     * </p>
     * 
     * @param cARepetitionItemNumber
     *            Repetition Item in FI-CA Document
     */
    public void setCARepetitionItemNumber( @Nullable final java.lang.String cARepetitionItemNumber )
    {
        rememberChangedField("CARepetitionItemNumber", this.cARepetitionItemNumber);
        this.cARepetitionItemNumber = cARepetitionItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CABPItemNumber</b>
     * </p>
     * 
     * @param cABPItemNumber
     *            Item Number in FI-CA Document
     */
    public void setCABPItemNumber( @Nullable final java.lang.String cABPItemNumber )
    {
        rememberChangedField("CABPItemNumber", this.cABPItemNumber);
        this.cABPItemNumber = cABPItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final java.lang.String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFullName</b>
     * </p>
     * 
     * @param businessPartnerFullName
     *            The businessPartnerFullName to set.
     */
    public void setBusinessPartnerFullName( @Nullable final java.lang.String businessPartnerFullName )
    {
        rememberChangedField("BusinessPartnerFullName", this.businessPartnerFullName);
        this.businessPartnerFullName = businessPartnerFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @param contractAccount
     *            Contract Account
     */
    public void setContractAccount( @Nullable final java.lang.String contractAccount )
    {
        rememberChangedField("ContractAccount", this.contractAccount);
        this.contractAccount = contractAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccountName</b>
     * </p>
     * 
     * @param contractAccountName
     *            Description of Contract Account
     */
    public void setContractAccountName( @Nullable final java.lang.String contractAccountName )
    {
        rememberChangedField("ContractAccountName", this.contractAccountName);
        this.contractAccountName = contractAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAContract</b>
     * </p>
     * 
     * @param cAContract
     *            Reference Specifications from Contract
     */
    public void setCAContract( @Nullable final java.lang.String cAContract )
    {
        rememberChangedField("CAContract", this.cAContract);
        this.cAContract = cAContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplication</b>
     * </p>
     * 
     * @param cASubApplication
     *            Subapplication in Contract Accounts Receivable and Payable
     */
    public void setCASubApplication( @Nullable final java.lang.String cASubApplication )
    {
        rememberChangedField("CASubApplication", this.cASubApplication);
        this.cASubApplication = cASubApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 250
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplicationText</b>
     * </p>
     * 
     * @param cASubApplicationText
     *            Description (250 Characters)
     */
    public void setCASubApplicationText( @Nullable final java.lang.String cASubApplicationText )
    {
        rememberChangedField("CASubApplicationText", this.cASubApplicationText);
        this.cASubApplicationText = cASubApplicationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     * 
     * @param companyCodeName
     *            Name of Company Code or Company
     */
    public void setCompanyCodeName( @Nullable final java.lang.String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CAReferenceDocument</b>
     * </p>
     * 
     * @param cAReferenceDocument
     *            Reference Document Number
     */
    public void setCAReferenceDocument( @Nullable final java.lang.String cAReferenceDocument )
    {
        rememberChangedField("CAReferenceDocument", this.cAReferenceDocument);
        this.cAReferenceDocument = cAReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCode</b>
     * </p>
     * 
     * @param cADocumentOriginCode
     *            Document Origin Key
     */
    public void setCADocumentOriginCode( @Nullable final java.lang.String cADocumentOriginCode )
    {
        rememberChangedField("CADocumentOriginCode", this.cADocumentOriginCode);
        this.cADocumentOriginCode = cADocumentOriginCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCodeName</b>
     * </p>
     * 
     * @param cADocumentOriginCodeName
     *            Description of Document Origin
     */
    public void setCADocumentOriginCodeName( @Nullable final java.lang.String cADocumentOriginCodeName )
    {
        rememberChangedField("CADocumentOriginCodeName", this.cADocumentOriginCodeName);
        this.cADocumentOriginCodeName = cADocumentOriginCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentType</b>
     * </p>
     * 
     * @param cADocumentType
     *            Document Type
     */
    public void setCADocumentType( @Nullable final java.lang.String cADocumentType )
    {
        rememberChangedField("CADocumentType", this.cADocumentType);
        this.cADocumentType = cADocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentTypeName</b>
     * </p>
     * 
     * @param cADocumentTypeName
     *            Document Type Description
     */
    public void setCADocumentTypeName( @Nullable final java.lang.String cADocumentTypeName )
    {
        rememberChangedField("CADocumentTypeName", this.cADocumentTypeName);
        this.cADocumentTypeName = cADocumentTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     * 
     * @param referenceDocumentType
     *            Reference Document Type
     */
    public void setReferenceDocumentType( @Nullable final java.lang.String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OriginalReferenceDocument</b>
     * </p>
     * 
     * @param originalReferenceDocument
     *            Object key
     */
    public void setOriginalReferenceDocument( @Nullable final java.lang.String originalReferenceDocument )
    {
        rememberChangedField("OriginalReferenceDocument", this.originalReferenceDocument);
        this.originalReferenceDocument = originalReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     * 
     * @param logicalSystem
     *            Logical system of source document
     */
    public void setLogicalSystem( @Nullable final java.lang.String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CABPItemText</b>
     * </p>
     * 
     * @param cABPItemText
     *            The cABPItemText to set.
     */
    public void setCABPItemText( @Nullable final java.lang.String cABPItemText )
    {
        rememberChangedField("CABPItemText", this.cABPItemText);
        this.cABPItemText = cABPItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     * 
     * @param businessArea
     *            The businessArea to set.
     */
    public void setBusinessArea( @Nullable final java.lang.String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     * 
     * @param businessAreaName
     *            Business Area Description
     */
    public void setBusinessAreaName( @Nullable final java.lang.String businessAreaName )
    {
        rememberChangedField("BusinessAreaName", this.businessAreaName);
        this.businessAreaName = businessAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     * 
     * @param segment
     *            The segment to set.
     */
    public void setSegment( @Nullable final java.lang.String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SegmentName</b>
     * </p>
     * 
     * @param segmentName
     *            Segment Name
     */
    public void setSegmentName( @Nullable final java.lang.String segmentName )
    {
        rememberChangedField("SegmentName", this.segmentName);
        this.segmentName = segmentName;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscountRate</b>
     * </p>
     * 
     * @param cACashDiscountRate
     *            The cACashDiscountRate to set.
     */
    public void setCACashDiscountRate( @Nullable final BigDecimal cACashDiscountRate )
    {
        rememberChangedField("CACashDiscountRate", this.cACashDiscountRate);
        this.cACashDiscountRate = cACashDiscountRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingForPayment</b>
     * </p>
     * 
     * @param cAGroupingForPayment
     *            The cAGroupingForPayment to set.
     */
    public void setCAGroupingForPayment( @Nullable final java.lang.String cAGroupingForPayment )
    {
        rememberChangedField("CAGroupingForPayment", this.cAGroupingForPayment);
        this.cAGroupingForPayment = cAGroupingForPayment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAMainTransaction</b>
     * </p>
     * 
     * @param cAMainTransaction
     *            The cAMainTransaction to set.
     */
    public void setCAMainTransaction( @Nullable final java.lang.String cAMainTransaction )
    {
        rememberChangedField("CAMainTransaction", this.cAMainTransaction);
        this.cAMainTransaction = cAMainTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CAMainTransactionName</b>
     * </p>
     * 
     * @param cAMainTransactionName
     *            Name of Main Transaction
     */
    public void setCAMainTransactionName( @Nullable final java.lang.String cAMainTransactionName )
    {
        rememberChangedField("CAMainTransactionName", this.cAMainTransactionName);
        this.cAMainTransactionName = cAMainTransactionName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CASubTransaction</b>
     * </p>
     * 
     * @param cASubTransaction
     *            The cASubTransaction to set.
     */
    public void setCASubTransaction( @Nullable final java.lang.String cASubTransaction )
    {
        rememberChangedField("CASubTransaction", this.cASubTransaction);
        this.cASubTransaction = cASubTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CASubTransactionName</b>
     * </p>
     * 
     * @param cASubTransactionName
     *            Name of Subtransaction
     */
    public void setCASubTransactionName( @Nullable final java.lang.String cASubTransactionName )
    {
        rememberChangedField("CASubTransactionName", this.cASubTransactionName);
        this.cASubTransactionName = cASubTransactionName;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountBaseAmtIsNetAmt</b>
     * </p>
     * 
     * @param cashDiscountBaseAmtIsNetAmt
     *            Indicator: Discount base amount is the net value
     */
    public void setCashDiscountBaseAmtIsNetAmt( @Nullable final java.lang.Boolean cashDiscountBaseAmtIsNetAmt )
    {
        rememberChangedField("CashDiscountBaseAmtIsNetAmt", this.cashDiscountBaseAmtIsNetAmt);
        this.cashDiscountBaseAmtIsNetAmt = cashDiscountBaseAmtIsNetAmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingReason</b>
     * </p>
     * 
     * @param cAClearingReason
     *            The cAClearingReason to set.
     */
    public void setCAClearingReason( @Nullable final java.lang.String cAClearingReason )
    {
        rememberChangedField("CAClearingReason", this.cAClearingReason);
        this.cAClearingReason = cAClearingReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingReasonName</b>
     * </p>
     * 
     * @param cAClearingReasonName
     *            Name
     */
    public void setCAClearingReasonName( @Nullable final java.lang.String cAClearingReasonName )
    {
        rememberChangedField("CAClearingReasonName", this.cAClearingReasonName);
        this.cAClearingReasonName = cAClearingReasonName;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     * 
     * @param documentDate
     *            The documentDate to set.
     */
    public void setDocumentDate( @Nullable final LocalDate documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDate</b>
     * </p>
     * 
     * @param cAPostingDate
     *            The cAPostingDate to set.
     */
    public void setCAPostingDate( @Nullable final LocalDate cAPostingDate )
    {
        rememberChangedField("CAPostingDate", this.cAPostingDate);
        this.cAPostingDate = cAPostingDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CANetDueDate</b>
     * </p>
     * 
     * @param cANetDueDate
     *            The cANetDueDate to set.
     */
    public void setCANetDueDate( @Nullable final LocalDate cANetDueDate )
    {
        rememberChangedField("CANetDueDate", this.cANetDueDate);
        this.cANetDueDate = cANetDueDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADeferralDate</b>
     * </p>
     * 
     * @param cADeferralDate
     *            The cADeferralDate to set.
     */
    public void setCADeferralDate( @Nullable final LocalDate cADeferralDate )
    {
        rememberChangedField("CADeferralDate", this.cADeferralDate);
        this.cADeferralDate = cADeferralDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscountDueDate</b>
     * </p>
     * 
     * @param cACashDiscountDueDate
     *            The cACashDiscountDueDate to set.
     */
    public void setCACashDiscountDueDate( @Nullable final LocalDate cACashDiscountDueDate )
    {
        rememberChangedField("CACashDiscountDueDate", this.cACashDiscountDueDate);
        this.cACashDiscountDueDate = cACashDiscountDueDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAValueDateForClearing</b>
     * </p>
     * 
     * @param cAValueDateForClearing
     *            The cAValueDateForClearing to set.
     */
    public void setCAValueDateForClearing( @Nullable final LocalDate cAValueDateForClearing )
    {
        rememberChangedField("CAValueDateForClearing", this.cAValueDateForClearing);
        this.cAValueDateForClearing = cAValueDateForClearing;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingDate</b>
     * </p>
     * 
     * @param cAClearingDate
     *            The cAClearingDate to set.
     */
    public void setCAClearingDate( @Nullable final LocalDate cAClearingDate )
    {
        rememberChangedField("CAClearingDate", this.cAClearingDate);
        this.cAClearingDate = cAClearingDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     * 
     * @param exchangeRateDate
     *            The exchangeRateDate to set.
     */
    public void setExchangeRateDate( @Nullable final LocalDate exchangeRateDate )
    {
        rememberChangedField("ExchangeRateDate", this.exchangeRateDate);
        this.exchangeRateDate = exchangeRateDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final java.lang.String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @param cAAmountInTransactionCurrency
     *            The cAAmountInTransactionCurrency to set.
     */
    public void setCAAmountInTransactionCurrency( @Nullable final BigDecimal cAAmountInTransactionCurrency )
    {
        rememberChangedField("CAAmountInTransactionCurrency", this.cAAmountInTransactionCurrency);
        this.cAAmountInTransactionCurrency = cAAmountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAOpenAmountInTransactionCrcy</b>
     * </p>
     * 
     * @param cAOpenAmountInTransactionCrcy
     *            The cAOpenAmountInTransactionCrcy to set.
     */
    public void setCAOpenAmountInTransactionCrcy( @Nullable final BigDecimal cAOpenAmountInTransactionCrcy )
    {
        rememberChangedField("CAOpenAmountInTransactionCrcy", this.cAOpenAmountInTransactionCrcy);
        this.cAOpenAmountInTransactionCrcy = cAOpenAmountInTransactionCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscountAmtInTransCrcy</b>
     * </p>
     * 
     * @param cACashDiscountAmtInTransCrcy
     *            The cACashDiscountAmtInTransCrcy to set.
     */
    public void setCACashDiscountAmtInTransCrcy( @Nullable final BigDecimal cACashDiscountAmtInTransCrcy )
    {
        rememberChangedField("CACashDiscountAmtInTransCrcy", this.cACashDiscountAmtInTransCrcy);
        this.cACashDiscountAmtInTransCrcy = cACashDiscountAmtInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAEligibleAmountForCshDiscInTC</b>
     * </p>
     * 
     * @param cAEligibleAmountForCshDiscInTC
     *            The cAEligibleAmountForCshDiscInTC to set.
     */
    public void setCAEligibleAmountForCshDiscInTC( @Nullable final BigDecimal cAEligibleAmountForCshDiscInTC )
    {
        rememberChangedField("CAEligibleAmountForCshDiscInTC", this.cAEligibleAmountForCshDiscInTC);
        this.cAEligibleAmountForCshDiscInTC = cAEligibleAmountForCshDiscInTC;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInTransCurrency</b>
     * </p>
     * 
     * @param cAReleasedAmtInTransCurrency
     *            The cAReleasedAmtInTransCurrency to set.
     */
    public void setCAReleasedAmtInTransCurrency( @Nullable final BigDecimal cAReleasedAmtInTransCurrency )
    {
        rememberChangedField("CAReleasedAmtInTransCurrency", this.cAReleasedAmtInTransCurrency);
        this.cAReleasedAmtInTransCurrency = cAReleasedAmtInTransCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisplayCurrency</b>
     * </p>
     * 
     * @param displayCurrency
     *            The displayCurrency to set.
     */
    public void setDisplayCurrency( @Nullable final java.lang.String displayCurrency )
    {
        rememberChangedField("DisplayCurrency", this.displayCurrency);
        this.displayCurrency = displayCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AmountInDisplayCurrency</b>
     * </p>
     * 
     * @param amountInDisplayCurrency
     *            The amountInDisplayCurrency to set.
     */
    public void setAmountInDisplayCurrency( @Nullable final BigDecimal amountInDisplayCurrency )
    {
        rememberChangedField("AmountInDisplayCurrency", this.amountInDisplayCurrency);
        this.amountInDisplayCurrency = amountInDisplayCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpenAmountInDisplayCrcy</b>
     * </p>
     * 
     * @param openAmountInDisplayCrcy
     *            The openAmountInDisplayCrcy to set.
     */
    public void setOpenAmountInDisplayCrcy( @Nullable final BigDecimal openAmountInDisplayCrcy )
    {
        rememberChangedField("OpenAmountInDisplayCrcy", this.openAmountInDisplayCrcy);
        this.openAmountInDisplayCrcy = openAmountInDisplayCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountAmountInDspCrcy</b>
     * </p>
     * 
     * @param cashDiscountAmountInDspCrcy
     *            The cashDiscountAmountInDspCrcy to set.
     */
    public void setCashDiscountAmountInDspCrcy( @Nullable final BigDecimal cashDiscountAmountInDspCrcy )
    {
        rememberChangedField("CashDiscountAmountInDspCrcy", this.cashDiscountAmountInDspCrcy);
        this.cashDiscountAmountInDspCrcy = cashDiscountAmountInDspCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAEligibleAmountForCshDiscInDC</b>
     * </p>
     * 
     * @param cAEligibleAmountForCshDiscInDC
     *            The cAEligibleAmountForCshDiscInDC to set.
     */
    public void setCAEligibleAmountForCshDiscInDC( @Nullable final BigDecimal cAEligibleAmountForCshDiscInDC )
    {
        rememberChangedField("CAEligibleAmountForCshDiscInDC", this.cAEligibleAmountForCshDiscInDC);
        this.cAEligibleAmountForCshDiscInDC = cAEligibleAmountForCshDiscInDC;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInDisplayCurrency</b>
     * </p>
     * 
     * @param cAReleasedAmtInDisplayCurrency
     *            The cAReleasedAmtInDisplayCurrency to set.
     */
    public void setCAReleasedAmtInDisplayCurrency( @Nullable final BigDecimal cAReleasedAmtInDisplayCurrency )
    {
        rememberChangedField("CAReleasedAmtInDisplayCurrency", this.cAReleasedAmtInDisplayCurrency);
        this.cAReleasedAmtInDisplayCurrency = cAReleasedAmtInDisplayCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingAmountInDisplayCrcy</b>
     * </p>
     * 
     * @param cAClearingAmountInDisplayCrcy
     *            The cAClearingAmountInDisplayCrcy to set.
     */
    public void setCAClearingAmountInDisplayCrcy( @Nullable final BigDecimal cAClearingAmountInDisplayCrcy )
    {
        rememberChangedField("CAClearingAmountInDisplayCrcy", this.cAClearingAmountInDisplayCrcy);
        this.cAClearingAmountInDisplayCrcy = cAClearingAmountInDisplayCrcy;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "Set";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentContainerUUID", getCADocumentContainerUUID());
        entityKey.addKeyProperty("CADocumentContainerSqncNumber", getCADocumentContainerSqncNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentContainerUUID", getCADocumentContainerUUID());
        values.put("CADocumentContainerSqncNumber", getCADocumentContainerSqncNumber());
        values.put("CADocContainerInvoiceItmStatus", getCADocContainerInvoiceItmStatus());
        values.put("CADocContainerInvoiceItmStsTxt", getCADocContainerInvoiceItmStsTxt());
        values.put("CADocumentContainerRefType", getCADocumentContainerRefType());
        values.put("CADocumentContainerRefTypeText", getCADocumentContainerRefTypeText());
        values.put("CADocumentContainerReference", getCADocumentContainerReference());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("CADocument", getCADocument());
        values.put("CARepetitionItemNumber", getCARepetitionItemNumber());
        values.put("CABPItemNumber", getCABPItemNumber());
        values.put("BusinessPartner", getBusinessPartner());
        values.put("BusinessPartnerFullName", getBusinessPartnerFullName());
        values.put("ContractAccount", getContractAccount());
        values.put("ContractAccountName", getContractAccountName());
        values.put("CAContract", getCAContract());
        values.put("CASubApplication", getCASubApplication());
        values.put("CASubApplicationText", getCASubApplicationText());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("CAReferenceDocument", getCAReferenceDocument());
        values.put("CADocumentOriginCode", getCADocumentOriginCode());
        values.put("CADocumentOriginCodeName", getCADocumentOriginCodeName());
        values.put("CADocumentType", getCADocumentType());
        values.put("CADocumentTypeName", getCADocumentTypeName());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("OriginalReferenceDocument", getOriginalReferenceDocument());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("CABPItemText", getCABPItemText());
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessAreaName", getBusinessAreaName());
        values.put("Segment", getSegment());
        values.put("SegmentName", getSegmentName());
        values.put("CACashDiscountRate", getCACashDiscountRate());
        values.put("CAGroupingForPayment", getCAGroupingForPayment());
        values.put("CAMainTransaction", getCAMainTransaction());
        values.put("CAMainTransactionName", getCAMainTransactionName());
        values.put("CASubTransaction", getCASubTransaction());
        values.put("CASubTransactionName", getCASubTransactionName());
        values.put("CashDiscountBaseAmtIsNetAmt", getCashDiscountBaseAmtIsNetAmt());
        values.put("CAClearingReason", getCAClearingReason());
        values.put("CAClearingReasonName", getCAClearingReasonName());
        values.put("DocumentDate", getDocumentDate());
        values.put("CAPostingDate", getCAPostingDate());
        values.put("CANetDueDate", getCANetDueDate());
        values.put("CADeferralDate", getCADeferralDate());
        values.put("CACashDiscountDueDate", getCACashDiscountDueDate());
        values.put("CAValueDateForClearing", getCAValueDateForClearing());
        values.put("CAClearingDate", getCAClearingDate());
        values.put("ExchangeRateDate", getExchangeRateDate());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("CAAmountInTransactionCurrency", getCAAmountInTransactionCurrency());
        values.put("CAOpenAmountInTransactionCrcy", getCAOpenAmountInTransactionCrcy());
        values.put("CACashDiscountAmtInTransCrcy", getCACashDiscountAmtInTransCrcy());
        values.put("CAEligibleAmountForCshDiscInTC", getCAEligibleAmountForCshDiscInTC());
        values.put("CAReleasedAmtInTransCurrency", getCAReleasedAmtInTransCurrency());
        values.put("DisplayCurrency", getDisplayCurrency());
        values.put("AmountInDisplayCurrency", getAmountInDisplayCurrency());
        values.put("OpenAmountInDisplayCrcy", getOpenAmountInDisplayCrcy());
        values.put("CashDiscountAmountInDspCrcy", getCashDiscountAmountInDspCrcy());
        values.put("CAEligibleAmountForCshDiscInDC", getCAEligibleAmountForCshDiscInDC());
        values.put("CAReleasedAmtInDisplayCurrency", getCAReleasedAmtInDisplayCurrency());
        values.put("CAClearingAmountInDisplayCrcy", getCAClearingAmountInDisplayCrcy());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentContainerUUID") ) {
                final Object value = values.remove("CADocumentContainerUUID");
                if( (value == null) || (!value.equals(getCADocumentContainerUUID())) ) {
                    setCADocumentContainerUUID(((UUID) value));
                }
            }
            if( values.containsKey("CADocumentContainerSqncNumber") ) {
                final Object value = values.remove("CADocumentContainerSqncNumber");
                if( (value == null) || (!value.equals(getCADocumentContainerSqncNumber())) ) {
                    setCADocumentContainerSqncNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocContainerInvoiceItmStatus") ) {
                final Object value = values.remove("CADocContainerInvoiceItmStatus");
                if( (value == null) || (!value.equals(getCADocContainerInvoiceItmStatus())) ) {
                    setCADocContainerInvoiceItmStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocContainerInvoiceItmStsTxt") ) {
                final Object value = values.remove("CADocContainerInvoiceItmStsTxt");
                if( (value == null) || (!value.equals(getCADocContainerInvoiceItmStsTxt())) ) {
                    setCADocContainerInvoiceItmStsTxt(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentContainerRefType") ) {
                final Object value = values.remove("CADocumentContainerRefType");
                if( (value == null) || (!value.equals(getCADocumentContainerRefType())) ) {
                    setCADocumentContainerRefType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentContainerRefTypeText") ) {
                final Object value = values.remove("CADocumentContainerRefTypeText");
                if( (value == null) || (!value.equals(getCADocumentContainerRefTypeText())) ) {
                    setCADocumentContainerRefTypeText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentContainerReference") ) {
                final Object value = values.remove("CADocumentContainerReference");
                if( (value == null) || (!value.equals(getCADocumentContainerReference())) ) {
                    setCADocumentContainerReference(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CADocument") ) {
                final Object value = values.remove("CADocument");
                if( (value == null) || (!value.equals(getCADocument())) ) {
                    setCADocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("CARepetitionItemNumber") ) {
                final Object value = values.remove("CARepetitionItemNumber");
                if( (value == null) || (!value.equals(getCARepetitionItemNumber())) ) {
                    setCARepetitionItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CABPItemNumber") ) {
                final Object value = values.remove("CABPItemNumber");
                if( (value == null) || (!value.equals(getCABPItemNumber())) ) {
                    setCABPItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartnerFullName") ) {
                final Object value = values.remove("BusinessPartnerFullName");
                if( (value == null) || (!value.equals(getBusinessPartnerFullName())) ) {
                    setBusinessPartnerFullName(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractAccount") ) {
                final Object value = values.remove("ContractAccount");
                if( (value == null) || (!value.equals(getContractAccount())) ) {
                    setContractAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractAccountName") ) {
                final Object value = values.remove("ContractAccountName");
                if( (value == null) || (!value.equals(getContractAccountName())) ) {
                    setContractAccountName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAContract") ) {
                final Object value = values.remove("CAContract");
                if( (value == null) || (!value.equals(getCAContract())) ) {
                    setCAContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubApplication") ) {
                final Object value = values.remove("CASubApplication");
                if( (value == null) || (!value.equals(getCASubApplication())) ) {
                    setCASubApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubApplicationText") ) {
                final Object value = values.remove("CASubApplicationText");
                if( (value == null) || (!value.equals(getCASubApplicationText())) ) {
                    setCASubApplicationText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAReferenceDocument") ) {
                final Object value = values.remove("CAReferenceDocument");
                if( (value == null) || (!value.equals(getCAReferenceDocument())) ) {
                    setCAReferenceDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentOriginCode") ) {
                final Object value = values.remove("CADocumentOriginCode");
                if( (value == null) || (!value.equals(getCADocumentOriginCode())) ) {
                    setCADocumentOriginCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentOriginCodeName") ) {
                final Object value = values.remove("CADocumentOriginCodeName");
                if( (value == null) || (!value.equals(getCADocumentOriginCodeName())) ) {
                    setCADocumentOriginCodeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentType") ) {
                final Object value = values.remove("CADocumentType");
                if( (value == null) || (!value.equals(getCADocumentType())) ) {
                    setCADocumentType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentTypeName") ) {
                final Object value = values.remove("CADocumentTypeName");
                if( (value == null) || (!value.equals(getCADocumentTypeName())) ) {
                    setCADocumentTypeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((java.lang.String) value));
                }
            }
            if( values.containsKey("OriginalReferenceDocument") ) {
                final Object value = values.remove("OriginalReferenceDocument");
                if( (value == null) || (!value.equals(getOriginalReferenceDocument())) ) {
                    setOriginalReferenceDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((java.lang.String) value));
                }
            }
            if( values.containsKey("CABPItemText") ) {
                final Object value = values.remove("CABPItemText");
                if( (value == null) || (!value.equals(getCABPItemText())) ) {
                    setCABPItemText(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessAreaName") ) {
                final Object value = values.remove("BusinessAreaName");
                if( (value == null) || (!value.equals(getBusinessAreaName())) ) {
                    setBusinessAreaName(((java.lang.String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((java.lang.String) value));
                }
            }
            if( values.containsKey("SegmentName") ) {
                final Object value = values.remove("SegmentName");
                if( (value == null) || (!value.equals(getSegmentName())) ) {
                    setSegmentName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACashDiscountRate") ) {
                final Object value = values.remove("CACashDiscountRate");
                if( (value == null) || (!value.equals(getCACashDiscountRate())) ) {
                    setCACashDiscountRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAGroupingForPayment") ) {
                final Object value = values.remove("CAGroupingForPayment");
                if( (value == null) || (!value.equals(getCAGroupingForPayment())) ) {
                    setCAGroupingForPayment(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAMainTransaction") ) {
                final Object value = values.remove("CAMainTransaction");
                if( (value == null) || (!value.equals(getCAMainTransaction())) ) {
                    setCAMainTransaction(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAMainTransactionName") ) {
                final Object value = values.remove("CAMainTransactionName");
                if( (value == null) || (!value.equals(getCAMainTransactionName())) ) {
                    setCAMainTransactionName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubTransaction") ) {
                final Object value = values.remove("CASubTransaction");
                if( (value == null) || (!value.equals(getCASubTransaction())) ) {
                    setCASubTransaction(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubTransactionName") ) {
                final Object value = values.remove("CASubTransactionName");
                if( (value == null) || (!value.equals(getCASubTransactionName())) ) {
                    setCASubTransactionName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CashDiscountBaseAmtIsNetAmt") ) {
                final Object value = values.remove("CashDiscountBaseAmtIsNetAmt");
                if( (value == null) || (!value.equals(getCashDiscountBaseAmtIsNetAmt())) ) {
                    setCashDiscountBaseAmtIsNetAmt(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAClearingReason") ) {
                final Object value = values.remove("CAClearingReason");
                if( (value == null) || (!value.equals(getCAClearingReason())) ) {
                    setCAClearingReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAClearingReasonName") ) {
                final Object value = values.remove("CAClearingReasonName");
                if( (value == null) || (!value.equals(getCAClearingReasonName())) ) {
                    setCAClearingReasonName(((java.lang.String) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAPostingDate") ) {
                final Object value = values.remove("CAPostingDate");
                if( (value == null) || (!value.equals(getCAPostingDate())) ) {
                    setCAPostingDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CANetDueDate") ) {
                final Object value = values.remove("CANetDueDate");
                if( (value == null) || (!value.equals(getCANetDueDate())) ) {
                    setCANetDueDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CADeferralDate") ) {
                final Object value = values.remove("CADeferralDate");
                if( (value == null) || (!value.equals(getCADeferralDate())) ) {
                    setCADeferralDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CACashDiscountDueDate") ) {
                final Object value = values.remove("CACashDiscountDueDate");
                if( (value == null) || (!value.equals(getCACashDiscountDueDate())) ) {
                    setCACashDiscountDueDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAValueDateForClearing") ) {
                final Object value = values.remove("CAValueDateForClearing");
                if( (value == null) || (!value.equals(getCAValueDateForClearing())) ) {
                    setCAValueDateForClearing(((LocalDate) value));
                }
            }
            if( values.containsKey("CAClearingDate") ) {
                final Object value = values.remove("CAClearingDate");
                if( (value == null) || (!value.equals(getCAClearingDate())) ) {
                    setCAClearingDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ExchangeRateDate") ) {
                final Object value = values.remove("ExchangeRateDate");
                if( (value == null) || (!value.equals(getExchangeRateDate())) ) {
                    setExchangeRateDate(((LocalDate) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAmountInTransactionCurrency") ) {
                final Object value = values.remove("CAAmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getCAAmountInTransactionCurrency())) ) {
                    setCAAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAOpenAmountInTransactionCrcy") ) {
                final Object value = values.remove("CAOpenAmountInTransactionCrcy");
                if( (value == null) || (!value.equals(getCAOpenAmountInTransactionCrcy())) ) {
                    setCAOpenAmountInTransactionCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CACashDiscountAmtInTransCrcy") ) {
                final Object value = values.remove("CACashDiscountAmtInTransCrcy");
                if( (value == null) || (!value.equals(getCACashDiscountAmtInTransCrcy())) ) {
                    setCACashDiscountAmtInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAEligibleAmountForCshDiscInTC") ) {
                final Object value = values.remove("CAEligibleAmountForCshDiscInTC");
                if( (value == null) || (!value.equals(getCAEligibleAmountForCshDiscInTC())) ) {
                    setCAEligibleAmountForCshDiscInTC(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAReleasedAmtInTransCurrency") ) {
                final Object value = values.remove("CAReleasedAmtInTransCurrency");
                if( (value == null) || (!value.equals(getCAReleasedAmtInTransCurrency())) ) {
                    setCAReleasedAmtInTransCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("DisplayCurrency") ) {
                final Object value = values.remove("DisplayCurrency");
                if( (value == null) || (!value.equals(getDisplayCurrency())) ) {
                    setDisplayCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("AmountInDisplayCurrency") ) {
                final Object value = values.remove("AmountInDisplayCurrency");
                if( (value == null) || (!value.equals(getAmountInDisplayCurrency())) ) {
                    setAmountInDisplayCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpenAmountInDisplayCrcy") ) {
                final Object value = values.remove("OpenAmountInDisplayCrcy");
                if( (value == null) || (!value.equals(getOpenAmountInDisplayCrcy())) ) {
                    setOpenAmountInDisplayCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscountAmountInDspCrcy") ) {
                final Object value = values.remove("CashDiscountAmountInDspCrcy");
                if( (value == null) || (!value.equals(getCashDiscountAmountInDspCrcy())) ) {
                    setCashDiscountAmountInDspCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAEligibleAmountForCshDiscInDC") ) {
                final Object value = values.remove("CAEligibleAmountForCshDiscInDC");
                if( (value == null) || (!value.equals(getCAEligibleAmountForCshDiscInDC())) ) {
                    setCAEligibleAmountForCshDiscInDC(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAReleasedAmtInDisplayCurrency") ) {
                final Object value = values.remove("CAReleasedAmtInDisplayCurrency");
                if( (value == null) || (!value.equals(getCAReleasedAmtInDisplayCurrency())) ) {
                    setCAReleasedAmtInDisplayCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAClearingAmountInDisplayCrcy") ) {
                final Object value = values.remove("CAClearingAmountInDisplayCrcy");
                if( (value == null) || (!value.equals(getCAClearingAmountInDisplayCrcy())) ) {
                    setCAClearingAmountInDisplayCrcy(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Parameters") ) {
                final Object value = (values).remove("Parameters");
                if( value instanceof Map ) {
                    if( toParameters == null ) {
                        toParameters = new BusPartInvoiceItemParameters();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    toParameters.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( toParameters != null ) {
            (values).put("Parameters", toParameters);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>BusPartInvoiceItemParameters</b> entity (one to one). This corresponds to the OData
     * navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property for an entity <b>BusPartInvoiceItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>Parameters</b> is already loaded, the result will contain
     *         the <b>BusPartInvoiceItemParameters</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusPartInvoiceItemParameters> getParametersIfPresent()
    {
        return Option.of(toParameters);
    }

    /**
     * Overwrites the associated <b>BusPartInvoiceItemParameters</b> entity for the loaded navigation property
     * <b>Parameters</b>.
     * 
     * @param value
     *            New <b>BusPartInvoiceItemParameters</b> entity.
     */
    public void setParameters( final BusPartInvoiceItemParameters value )
    {
        toParameters = value;
    }

    /**
     * Helper class to allow for fluent creation of BusPartInvoiceItem instances.
     * 
     */
    public final static class BusPartInvoiceItemBuilder
    {

        private BusPartInvoiceItemParameters toParameters;

        private BusPartInvoiceItem.BusPartInvoiceItemBuilder toParameters( final BusPartInvoiceItemParameters value )
        {
            toParameters = value;
            return this;
        }

        /**
         * Navigation property <b>Parameters</b> for <b>BusPartInvoiceItem</b> to single
         * <b>BusPartInvoiceItemParameters</b>.
         * 
         * @param value
         *            The BusPartInvoiceItemParameters to build this BusPartInvoiceItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusPartInvoiceItem.BusPartInvoiceItemBuilder parameters( final BusPartInvoiceItemParameters value )
        {
            return toParameters(value);
        }

    }

}
