/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.result.ElementName;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>BusPartPaymentType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BusPartPayment extends VdmEntity<BusPartPayment>
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_cabuspartpayment.v0001.BusPartPaymentType";
    /**
     * Selector for all available fields of BusPartPayment.
     * 
     */
    public final static SimpleProperty<BusPartPayment> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerUUID</b>
     * </p>
     * 
     * @return Document Container ID
     */
    @Nullable
    @ElementName( "CADocumentContainerUUID" )
    private UUID cADocumentContainerUUID;
    public final static SimpleProperty.Guid<BusPartPayment> CA_DOCUMENT_CONTAINER_UUID =
        new SimpleProperty.Guid<BusPartPayment>(BusPartPayment.class, "CADocumentContainerUUID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentDocument</b>
     * </p>
     * 
     * @return Document
     */
    @Nullable
    @ElementName( "CAPaymentDocument" )
    private java.lang.String cAPaymentDocument;
    public final static SimpleProperty.String<BusPartPayment> CA_PAYMENT_DOCUMENT =
        new SimpleProperty.String<BusPartPayment>(BusPartPayment.class, "CAPaymentDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCode</b>
     * </p>
     * 
     * @return Document Origin Key
     */
    @Nullable
    @ElementName( "CADocumentOriginCode" )
    private java.lang.String cADocumentOriginCode;
    public final static SimpleProperty.String<BusPartPayment> CA_DOCUMENT_ORIGIN_CODE =
        new SimpleProperty.String<BusPartPayment>(BusPartPayment.class, "CADocumentOriginCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCodeName</b>
     * </p>
     * 
     * @return Description of Document Origin
     */
    @Nullable
    @ElementName( "CADocumentOriginCodeName" )
    private java.lang.String cADocumentOriginCodeName;
    public final static SimpleProperty.String<BusPartPayment> CA_DOCUMENT_ORIGIN_CODE_NAME =
        new SimpleProperty.String<BusPartPayment>(BusPartPayment.class, "CADocumentOriginCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefType</b>
     * </p>
     * 
     * @return Document Container - Reference Type
     */
    @Nullable
    @ElementName( "CADocumentContainerRefType" )
    private java.lang.String cADocumentContainerRefType;
    public final static SimpleProperty.String<BusPartPayment> CA_DOCUMENT_CONTAINER_REF_TYPE =
        new SimpleProperty.String<BusPartPayment>(BusPartPayment.class, "CADocumentContainerRefType");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefTypeText</b>
     * </p>
     * 
     * @return Reference Type of Document Conainer Text
     */
    @Nullable
    @ElementName( "CADocumentContainerRefTypeText" )
    private java.lang.String cADocumentContainerRefTypeText;
    public final static SimpleProperty.String<BusPartPayment> CA_DOCUMENT_CONTAINER_REF_TYPE_TEXT =
        new SimpleProperty.String<BusPartPayment>(BusPartPayment.class, "CADocumentContainerRefTypeText");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Day On Which Accounting Document Was Entered
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<BusPartPayment> CREATION_DATE =
        new SimpleProperty.Date<BusPartPayment>(BusPartPayment.class, "CreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @return Time of Entry
     */
    @Nullable
    @ElementName( "CreationTime" )
    private LocalTime creationTime;
    public final static SimpleProperty.Time<BusPartPayment> CREATION_TIME =
        new SimpleProperty.Time<BusPartPayment>(BusPartPayment.class, "CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisplayCurrency</b>
     * </p>
     * 
     * @return The displayCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "DisplayCurrency" )
    private java.lang.String displayCurrency;
    public final static SimpleProperty.String<BusPartPayment> DISPLAY_CURRENCY =
        new SimpleProperty.String<BusPartPayment>(BusPartPayment.class, "DisplayCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentAmountInDC</b>
     * </p>
     * 
     * @return The cAPaymentAmountInDC contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAPaymentAmountInDC" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAPaymentAmountInDC;
    public final static SimpleProperty.NumericDecimal<BusPartPayment> CA_PAYMENT_AMOUNT_IN_DC =
        new SimpleProperty.NumericDecimal<BusPartPayment>(BusPartPayment.class, "CAPaymentAmountInDC");
    /**
     * Navigation property <b>Parameters</b> for <b>BusPartPayment</b> to single <b>BusPartPaymentParameters</b>.
     * 
     */
    @ElementName( "Parameters" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusPartPaymentParameters toParameters;
    /**
     * Use with available request builders to apply the <b>Parameters</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusPartPayment, BusPartPaymentParameters> TO_PARAMETERS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusPartPayment, BusPartPaymentParameters>(
            BusPartPayment.class,
            "Parameters",
            BusPartPaymentParameters.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BusPartPayment> getType()
    {
        return BusPartPayment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerUUID</b>
     * </p>
     * 
     * @param cADocumentContainerUUID
     *            Document Container ID
     */
    public void setCADocumentContainerUUID( @Nullable final UUID cADocumentContainerUUID )
    {
        rememberChangedField("CADocumentContainerUUID", this.cADocumentContainerUUID);
        this.cADocumentContainerUUID = cADocumentContainerUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentDocument</b>
     * </p>
     * 
     * @param cAPaymentDocument
     *            Document
     */
    public void setCAPaymentDocument( @Nullable final java.lang.String cAPaymentDocument )
    {
        rememberChangedField("CAPaymentDocument", this.cAPaymentDocument);
        this.cAPaymentDocument = cAPaymentDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCode</b>
     * </p>
     * 
     * @param cADocumentOriginCode
     *            Document Origin Key
     */
    public void setCADocumentOriginCode( @Nullable final java.lang.String cADocumentOriginCode )
    {
        rememberChangedField("CADocumentOriginCode", this.cADocumentOriginCode);
        this.cADocumentOriginCode = cADocumentOriginCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCodeName</b>
     * </p>
     * 
     * @param cADocumentOriginCodeName
     *            Description of Document Origin
     */
    public void setCADocumentOriginCodeName( @Nullable final java.lang.String cADocumentOriginCodeName )
    {
        rememberChangedField("CADocumentOriginCodeName", this.cADocumentOriginCodeName);
        this.cADocumentOriginCodeName = cADocumentOriginCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefType</b>
     * </p>
     * 
     * @param cADocumentContainerRefType
     *            Document Container - Reference Type
     */
    public void setCADocumentContainerRefType( @Nullable final java.lang.String cADocumentContainerRefType )
    {
        rememberChangedField("CADocumentContainerRefType", this.cADocumentContainerRefType);
        this.cADocumentContainerRefType = cADocumentContainerRefType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerRefTypeText</b>
     * </p>
     * 
     * @param cADocumentContainerRefTypeText
     *            Reference Type of Document Conainer Text
     */
    public void setCADocumentContainerRefTypeText( @Nullable final java.lang.String cADocumentContainerRefTypeText )
    {
        rememberChangedField("CADocumentContainerRefTypeText", this.cADocumentContainerRefTypeText);
        this.cADocumentContainerRefTypeText = cADocumentContainerRefTypeText;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Day On Which Accounting Document Was Entered
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @param creationTime
     *            Time of Entry
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisplayCurrency</b>
     * </p>
     * 
     * @param displayCurrency
     *            The displayCurrency to set.
     */
    public void setDisplayCurrency( @Nullable final java.lang.String displayCurrency )
    {
        rememberChangedField("DisplayCurrency", this.displayCurrency);
        this.displayCurrency = displayCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentAmountInDC</b>
     * </p>
     * 
     * @param cAPaymentAmountInDC
     *            The cAPaymentAmountInDC to set.
     */
    public void setCAPaymentAmountInDC( @Nullable final BigDecimal cAPaymentAmountInDC )
    {
        rememberChangedField("CAPaymentAmountInDC", this.cAPaymentAmountInDC);
        this.cAPaymentAmountInDC = cAPaymentAmountInDC;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "Set";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentContainerUUID", getCADocumentContainerUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentContainerUUID", getCADocumentContainerUUID());
        values.put("CAPaymentDocument", getCAPaymentDocument());
        values.put("CADocumentOriginCode", getCADocumentOriginCode());
        values.put("CADocumentOriginCodeName", getCADocumentOriginCodeName());
        values.put("CADocumentContainerRefType", getCADocumentContainerRefType());
        values.put("CADocumentContainerRefTypeText", getCADocumentContainerRefTypeText());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("DisplayCurrency", getDisplayCurrency());
        values.put("CAPaymentAmountInDC", getCAPaymentAmountInDC());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentContainerUUID") ) {
                final Object value = values.remove("CADocumentContainerUUID");
                if( (value == null) || (!value.equals(getCADocumentContainerUUID())) ) {
                    setCADocumentContainerUUID(((UUID) value));
                }
            }
            if( values.containsKey("CAPaymentDocument") ) {
                final Object value = values.remove("CAPaymentDocument");
                if( (value == null) || (!value.equals(getCAPaymentDocument())) ) {
                    setCAPaymentDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentOriginCode") ) {
                final Object value = values.remove("CADocumentOriginCode");
                if( (value == null) || (!value.equals(getCADocumentOriginCode())) ) {
                    setCADocumentOriginCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentOriginCodeName") ) {
                final Object value = values.remove("CADocumentOriginCodeName");
                if( (value == null) || (!value.equals(getCADocumentOriginCodeName())) ) {
                    setCADocumentOriginCodeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentContainerRefType") ) {
                final Object value = values.remove("CADocumentContainerRefType");
                if( (value == null) || (!value.equals(getCADocumentContainerRefType())) ) {
                    setCADocumentContainerRefType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentContainerRefTypeText") ) {
                final Object value = values.remove("CADocumentContainerRefTypeText");
                if( (value == null) || (!value.equals(getCADocumentContainerRefTypeText())) ) {
                    setCADocumentContainerRefTypeText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("DisplayCurrency") ) {
                final Object value = values.remove("DisplayCurrency");
                if( (value == null) || (!value.equals(getDisplayCurrency())) ) {
                    setDisplayCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPaymentAmountInDC") ) {
                final Object value = values.remove("CAPaymentAmountInDC");
                if( (value == null) || (!value.equals(getCAPaymentAmountInDC())) ) {
                    setCAPaymentAmountInDC(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Parameters") ) {
                final Object value = (values).remove("Parameters");
                if( value instanceof Map ) {
                    if( toParameters == null ) {
                        toParameters = new BusPartPaymentParameters();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    toParameters.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( toParameters != null ) {
            (values).put("Parameters", toParameters);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>BusPartPaymentParameters</b> entity (one to one). This corresponds to the OData
     * navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property for an entity <b>BusPartPayment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>Parameters</b> is already loaded, the result will contain
     *         the <b>BusPartPaymentParameters</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusPartPaymentParameters> getParametersIfPresent()
    {
        return Option.of(toParameters);
    }

    /**
     * Overwrites the associated <b>BusPartPaymentParameters</b> entity for the loaded navigation property
     * <b>Parameters</b>.
     * 
     * @param value
     *            New <b>BusPartPaymentParameters</b> entity.
     */
    public void setParameters( final BusPartPaymentParameters value )
    {
        toParameters = value;
    }

    /**
     * Helper class to allow for fluent creation of BusPartPayment instances.
     * 
     */
    public final static class BusPartPaymentBuilder
    {

        private BusPartPaymentParameters toParameters;

        private BusPartPayment.BusPartPaymentBuilder toParameters( final BusPartPaymentParameters value )
        {
            toParameters = value;
            return this;
        }

        /**
         * Navigation property <b>Parameters</b> for <b>BusPartPayment</b> to single <b>BusPartPaymentParameters</b>.
         * 
         * @param value
         *            The BusPartPaymentParameters to build this BusPartPayment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusPartPayment.BusPartPaymentBuilder parameters( final BusPartPaymentParameters value )
        {
            return toParameters(value);
        }

    }

}
