/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingBusinessPartnerPaymentService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Business Partner Payment Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BusPartPaymentHeaderType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BusPartPaymentHeader extends VdmEntity<BusPartPaymentHeader> implements VdmEntitySet
{

    @Getter
    private final String odataType = "com.sap.gateway.srvd_a2x.api_cabuspartpayment.v0001.BusPartPaymentHeaderType";
    /**
     * Selector for all available fields of BusPartPaymentHeader.
     * 
     */
    public final static SimpleProperty<BusPartPaymentHeader> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerPaymentUUID</b>
     * </p>
     * 
     * @return Document Container ID
     */
    @Nullable
    @ElementName( "CADocumentContainerPaymentUUID" )
    private UUID cADocumentContainerPaymentUUID;
    public final static SimpleProperty.Guid<BusPartPaymentHeader> CA_DOCUMENT_CONTAINER_PAYMENT_UUID =
        new SimpleProperty.Guid<BusPartPaymentHeader>(BusPartPaymentHeader.class, "CADocumentContainerPaymentUUID");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<BusPartPaymentHeader, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<BusPartPaymentHeader, SAP__Message>(
            BusPartPaymentHeader.class,
            "SAP__Messages",
            SAP__Message.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BusPartPaymentHeader> getType()
    {
        return BusPartPaymentHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerPaymentUUID</b>
     * </p>
     * 
     * @param cADocumentContainerPaymentUUID
     *            Document Container ID
     */
    public void setCADocumentContainerPaymentUUID( @Nullable final UUID cADocumentContainerPaymentUUID )
    {
        rememberChangedField("CADocumentContainerPaymentUUID", this.cADocumentContainerPaymentUUID);
        this.cADocumentContainerPaymentUUID = cADocumentContainerPaymentUUID;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BusPartPaymentHeader";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentContainerPaymentUUID", getCADocumentContainerPaymentUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CADocumentContainerPaymentUUID", getCADocumentContainerPaymentUUID());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentContainerPaymentUUID") ) {
                final Object value = values.remove("CADocumentContainerPaymentUUID");
                if( (value == null) || (!value.equals(getCADocumentContainerPaymentUUID())) ) {
                    setCADocumentContainerPaymentUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<String, Object> inputMap = ((Map<String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected String getDefaultServicePath()
    {
        return ContractAccountingBusinessPartnerPaymentService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Action that can be applied to a collection of entities of this class.
     * </p>
     * 
     * @param cAAuthznByDigitalPaytSrvc
     *            Constraints: Not nullable, Maximum length: 25
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAAuthznByDigitalPaytSrvc</b>
     *            </p>
     * @param authorizedAmountInAuthznCrcy
     *            Constraints: Not nullable, Precision: 15, Scale: 0
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizedAmountInAuthznCrcy</b>
     *            </p>
     * @param authorizationDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizationDate</b>
     *            </p>
     * @param cADocumentNumber
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADocumentNumber</b>
     *            </p>
     * @param paymentCardHolderName
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardHolderName</b>
     *            </p>
     * @param cAAuthorizationType
     *            Constraints: Not nullable, Maximum length: 1
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAAuthorizationType</b>
     *            </p>
     * @param cARepetitionItemNumber
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CARepetitionItemNumber</b>
     *            </p>
     * @param cASubItemNumber
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASubItemNumber</b>
     *            </p>
     * @param paymentCardType
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardType</b>
     *            </p>
     * @param authorizationExpirationDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizationExpirationDate</b>
     *            </p>
     * @param cAAltvBPForPayment
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAAltvBPForPayment</b>
     *            </p>
     * @param paytCardByDigitalPaymentSrvc
     *            Constraints: Not nullable, Maximum length: 25
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaytCardByDigitalPaymentSrvc</b>
     *            </p>
     * @param authorizationCurrency
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizationCurrency</b>
     *            </p>
     * @param cADocumentContainerInvoiceUUID
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADocumentContainerInvoiceUUID</b>
     *            </p>
     * @param merchantByClearingHouse
     *            Constraints: Not nullable, Maximum length: 15
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MerchantByClearingHouse</b>
     *            </p>
     * @param cAPaymentIDAuthznWithBilling
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAPaymentIDAuthznWithBilling</b>
     *            </p>
     * @param authorizationTime
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizationTime</b>
     *            </p>
     * @param cAPaymentAmountInPaytCurrency
     *            Constraints: Not nullable, Precision: 13, Scale: 0
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAPaymentAmountInPaytCurrency</b>
     *            </p>
     * @param cAAuthorizationByAcquirer
     *            Constraints: Not nullable, Maximum length: 25
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAAuthorizationByAcquirer</b>
     *            </p>
     * @param cABPItemNumber
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CABPItemNumber</b>
     *            </p>
     * @param paymentCardValidityStartDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardValidityStartDate</b>
     *            </p>
     * @param paymentCardValidityEndDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardValidityEndDate</b>
     *            </p>
     * @param paymentCardSequenceNumber
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardSequenceNumber</b>
     *            </p>
     * @param paymentCurrency
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCurrency</b>
     *            </p>
     * @param authorizationExpirationTime
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizationExpirationTime</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to a collection of entities of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<BusPartPaymentHeader, BusPartPaymentHeader>
        payByPaymentCard(
            @Nonnull final String paymentCurrency,
            @Nonnull final BigDecimal cAPaymentAmountInPaytCurrency,
            @Nonnull final String paymentCardType,
            @Nonnull final String paytCardByDigitalPaymentSrvc,
            @Nonnull final String paymentCardSequenceNumber,
            @Nonnull final LocalDate paymentCardValidityStartDate,
            @Nonnull final LocalDate paymentCardValidityEndDate,
            @Nonnull final String paymentCardHolderName,
            @Nonnull final String cAAuthznByDigitalPaytSrvc,
            @Nonnull final String cAAuthorizationByAcquirer,
            @Nonnull final LocalDate authorizationDate,
            @Nonnull final LocalTime authorizationTime,
            @Nonnull final LocalDate authorizationExpirationDate,
            @Nonnull final LocalTime authorizationExpirationTime,
            @Nonnull final String cAAuthorizationType,
            @Nonnull final String authorizationCurrency,
            @Nonnull final BigDecimal authorizedAmountInAuthznCrcy,
            @Nonnull final String merchantByClearingHouse,
            @Nonnull final String cAPaymentIDAuthznWithBilling,
            @Nonnull final UUID cADocumentContainerInvoiceUUID,
            @Nonnull final String cADocumentNumber,
            @Nonnull final String cARepetitionItemNumber,
            @Nonnull final String cABPItemNumber,
            @Nonnull final String cASubItemNumber,
            @Nonnull final String cAAltvBPForPayment )
    {
        final Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("PaymentCurrency", paymentCurrency);
        parameters.put("CAPaymentAmountInPaytCurrency", cAPaymentAmountInPaytCurrency);
        parameters.put("PaymentCardType", paymentCardType);
        parameters.put("PaytCardByDigitalPaymentSrvc", paytCardByDigitalPaymentSrvc);
        parameters.put("PaymentCardSequenceNumber", paymentCardSequenceNumber);
        parameters.put("PaymentCardValidityStartDate", paymentCardValidityStartDate);
        parameters.put("PaymentCardValidityEndDate", paymentCardValidityEndDate);
        parameters.put("PaymentCardHolderName", paymentCardHolderName);
        parameters.put("CAAuthznByDigitalPaytSrvc", cAAuthznByDigitalPaytSrvc);
        parameters.put("CAAuthorizationByAcquirer", cAAuthorizationByAcquirer);
        parameters.put("AuthorizationDate", authorizationDate);
        parameters.put("AuthorizationTime", authorizationTime);
        parameters.put("AuthorizationExpirationDate", authorizationExpirationDate);
        parameters.put("AuthorizationExpirationTime", authorizationExpirationTime);
        parameters.put("CAAuthorizationType", cAAuthorizationType);
        parameters.put("AuthorizationCurrency", authorizationCurrency);
        parameters.put("AuthorizedAmountInAuthznCrcy", authorizedAmountInAuthznCrcy);
        parameters.put("MerchantByClearingHouse", merchantByClearingHouse);
        parameters.put("CAPaymentIDAuthznWithBilling", cAPaymentIDAuthznWithBilling);
        parameters.put("CADocumentContainerInvoiceUUID", cADocumentContainerInvoiceUUID);
        parameters.put("CADocumentNumber", cADocumentNumber);
        parameters.put("CARepetitionItemNumber", cARepetitionItemNumber);
        parameters.put("CABPItemNumber", cABPItemNumber);
        parameters.put("CASubItemNumber", cASubItemNumber);
        parameters.put("CAAltvBPForPayment", cAAltvBPForPayment);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<BusPartPaymentHeader, BusPartPaymentHeader>(
            BusPartPaymentHeader.class,
            BusPartPaymentHeader.class,
            "com.sap.gateway.srvd_a2x.api_cabuspartpayment.v0001.PayByPaymentCard",
            parameters);
    }

    /**
     * Action that can be applied to a collection of entities of this class.
     * </p>
     * 
     * @param cAAuthznByDigitalPaytSrvc
     *            Constraints: Not nullable, Maximum length: 25
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAAuthznByDigitalPaytSrvc</b>
     *            </p>
     * @param authorizationCurrency
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizationCurrency</b>
     *            </p>
     * @param authorizedAmountInAuthznCrcy
     *            Constraints: Not nullable, Precision: 15, Scale: 0
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizedAmountInAuthznCrcy</b>
     *            </p>
     * @param cADocumentContainerInvoiceUUID
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADocumentContainerInvoiceUUID</b>
     *            </p>
     * @param authorizationDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizationDate</b>
     *            </p>
     * @param merchantByClearingHouse
     *            Constraints: Not nullable, Maximum length: 15
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MerchantByClearingHouse</b>
     *            </p>
     * @param cADocumentNumber
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADocumentNumber</b>
     *            </p>
     * @param paymentCardHolderName
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardHolderName</b>
     *            </p>
     * @param cAAuthorizationType
     *            Constraints: Not nullable, Maximum length: 1
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAAuthorizationType</b>
     *            </p>
     * @param cARepetitionItemNumber
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CARepetitionItemNumber</b>
     *            </p>
     * @param cAPaymentIDAuthznWithBilling
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAPaymentIDAuthznWithBilling</b>
     *            </p>
     * @param authorizationTime
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizationTime</b>
     *            </p>
     * @param cASubItemNumber
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASubItemNumber</b>
     *            </p>
     * @param paymentCardType
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardType</b>
     *            </p>
     * @param cAPaymentAmountInPaytCurrency
     *            Constraints: Not nullable, Precision: 13, Scale: 0
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAPaymentAmountInPaytCurrency</b>
     *            </p>
     * @param cAAuthorizationByAcquirer
     *            Constraints: Not nullable, Maximum length: 25
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAAuthorizationByAcquirer</b>
     *            </p>
     * @param cABPItemNumber
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CABPItemNumber</b>
     *            </p>
     * @param authorizationExpirationDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizationExpirationDate</b>
     *            </p>
     * @param paymentCardValidityStartDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardValidityStartDate</b>
     *            </p>
     * @param paymentCardValidityEndDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardValidityEndDate</b>
     *            </p>
     * @param paymentCardSequenceNumber
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardSequenceNumber</b>
     *            </p>
     * @param paymentCurrency
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCurrency</b>
     *            </p>
     * @param authorizationExpirationTime
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>AuthorizationExpirationTime</b>
     *            </p>
     * @param paytCardByDigitalPaymentSrvc
     *            Constraints: Not nullable, Maximum length: 25
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaytCardByDigitalPaymentSrvc</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to a collection of entities of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<BusPartPaymentHeader, BusPartPaymentHeader>
        releasePaymentByPaymentCard(
            @Nonnull final String paymentCurrency,
            @Nonnull final BigDecimal cAPaymentAmountInPaytCurrency,
            @Nonnull final String paymentCardType,
            @Nonnull final String paytCardByDigitalPaymentSrvc,
            @Nonnull final String paymentCardSequenceNumber,
            @Nonnull final LocalDate paymentCardValidityStartDate,
            @Nonnull final LocalDate paymentCardValidityEndDate,
            @Nonnull final String paymentCardHolderName,
            @Nonnull final String cAAuthznByDigitalPaytSrvc,
            @Nonnull final String cAAuthorizationByAcquirer,
            @Nonnull final LocalDate authorizationDate,
            @Nonnull final LocalTime authorizationTime,
            @Nonnull final LocalDate authorizationExpirationDate,
            @Nonnull final LocalTime authorizationExpirationTime,
            @Nonnull final String cAAuthorizationType,
            @Nonnull final String authorizationCurrency,
            @Nonnull final BigDecimal authorizedAmountInAuthznCrcy,
            @Nonnull final String merchantByClearingHouse,
            @Nonnull final String cAPaymentIDAuthznWithBilling,
            @Nonnull final UUID cADocumentContainerInvoiceUUID,
            @Nonnull final String cADocumentNumber,
            @Nonnull final String cARepetitionItemNumber,
            @Nonnull final String cABPItemNumber,
            @Nonnull final String cASubItemNumber )
    {
        final Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("PaymentCurrency", paymentCurrency);
        parameters.put("CAPaymentAmountInPaytCurrency", cAPaymentAmountInPaytCurrency);
        parameters.put("PaymentCardType", paymentCardType);
        parameters.put("PaytCardByDigitalPaymentSrvc", paytCardByDigitalPaymentSrvc);
        parameters.put("PaymentCardSequenceNumber", paymentCardSequenceNumber);
        parameters.put("PaymentCardValidityStartDate", paymentCardValidityStartDate);
        parameters.put("PaymentCardValidityEndDate", paymentCardValidityEndDate);
        parameters.put("PaymentCardHolderName", paymentCardHolderName);
        parameters.put("CAAuthznByDigitalPaytSrvc", cAAuthznByDigitalPaytSrvc);
        parameters.put("CAAuthorizationByAcquirer", cAAuthorizationByAcquirer);
        parameters.put("AuthorizationDate", authorizationDate);
        parameters.put("AuthorizationTime", authorizationTime);
        parameters.put("AuthorizationExpirationDate", authorizationExpirationDate);
        parameters.put("AuthorizationExpirationTime", authorizationExpirationTime);
        parameters.put("CAAuthorizationType", cAAuthorizationType);
        parameters.put("AuthorizationCurrency", authorizationCurrency);
        parameters.put("AuthorizedAmountInAuthznCrcy", authorizedAmountInAuthznCrcy);
        parameters.put("MerchantByClearingHouse", merchantByClearingHouse);
        parameters.put("CAPaymentIDAuthznWithBilling", cAPaymentIDAuthznWithBilling);
        parameters.put("CADocumentContainerInvoiceUUID", cADocumentContainerInvoiceUUID);
        parameters.put("CADocumentNumber", cADocumentNumber);
        parameters.put("CARepetitionItemNumber", cARepetitionItemNumber);
        parameters.put("CABPItemNumber", cABPItemNumber);
        parameters.put("CASubItemNumber", cASubItemNumber);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<BusPartPaymentHeader, BusPartPaymentHeader>(
            BusPartPaymentHeader.class,
            BusPartPaymentHeader.class,
            "com.sap.gateway.srvd_a2x.api_cabuspartpayment.v0001.ReleasePaymentByPaymentCard",
            parameters);
    }

    /**
     * Action that can be applied to a collection of entities of this class.
     * </p>
     * 
     * @param cAPaymentAmountInPaytCurrency
     *            Constraints: Not nullable, Precision: 13, Scale: 0
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAPaymentAmountInPaytCurrency</b>
     *            </p>
     * @param cADocumentContainerInvoiceUUID
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADocumentContainerInvoiceUUID</b>
     *            </p>
     * @param cADocumentNumber
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADocumentNumber</b>
     *            </p>
     * @param cABPItemNumber
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CABPItemNumber</b>
     *            </p>
     * @param bankIdentification
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BankIdentification</b>
     *            </p>
     * @param cARepetitionItemNumber
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CARepetitionItemNumber</b>
     *            </p>
     * @param paymentCurrency
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCurrency</b>
     *            </p>
     * @param cASubItemNumber
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASubItemNumber</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to a collection of entities of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<BusPartPaymentHeader, BusPartPaymentHeader>
        releasePaymentByBankID(
            @Nonnull final String paymentCurrency,
            @Nonnull final BigDecimal cAPaymentAmountInPaytCurrency,
            @Nonnull final String bankIdentification,
            @Nonnull final UUID cADocumentContainerInvoiceUUID,
            @Nonnull final String cADocumentNumber,
            @Nonnull final String cARepetitionItemNumber,
            @Nonnull final String cABPItemNumber,
            @Nonnull final String cASubItemNumber )
    {
        final Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("PaymentCurrency", paymentCurrency);
        parameters.put("CAPaymentAmountInPaytCurrency", cAPaymentAmountInPaytCurrency);
        parameters.put("BankIdentification", bankIdentification);
        parameters.put("CADocumentContainerInvoiceUUID", cADocumentContainerInvoiceUUID);
        parameters.put("CADocumentNumber", cADocumentNumber);
        parameters.put("CARepetitionItemNumber", cARepetitionItemNumber);
        parameters.put("CABPItemNumber", cABPItemNumber);
        parameters.put("CASubItemNumber", cASubItemNumber);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<BusPartPaymentHeader, BusPartPaymentHeader>(
            BusPartPaymentHeader.class,
            BusPartPaymentHeader.class,
            "com.sap.gateway.srvd_a2x.api_cabuspartpayment.v0001.ReleasePaymentByBankID",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<BusPartPaymentHeader, Void>
        withdrawPayment()
    {
        final Map<String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<BusPartPaymentHeader, Void>(
            BusPartPaymentHeader.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_cabuspartpayment.v0001.WithdrawPayment",
            parameters);
    }

    /**
     * Action that can be applied to a collection of entities of this class.
     * </p>
     * 
     * @param cAPaymentAmountInPaytCurrency
     *            Constraints: Not nullable, Precision: 13, Scale: 0
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAPaymentAmountInPaytCurrency</b>
     *            </p>
     * @param cADocumentContainerInvoiceUUID
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADocumentContainerInvoiceUUID</b>
     *            </p>
     * @param paymentCardID
     *            Constraints: Not nullable, Maximum length: 6
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCardID</b>
     *            </p>
     * @param cADocumentNumber
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADocumentNumber</b>
     *            </p>
     * @param cABPItemNumber
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CABPItemNumber</b>
     *            </p>
     * @param cARepetitionItemNumber
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CARepetitionItemNumber</b>
     *            </p>
     * @param paymentCurrency
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCurrency</b>
     *            </p>
     * @param cASubItemNumber
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASubItemNumber</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to a collection of entities of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<BusPartPaymentHeader, BusPartPaymentHeader>
        releasePaymentByPaymentCardID(
            @Nonnull final String paymentCurrency,
            @Nonnull final BigDecimal cAPaymentAmountInPaytCurrency,
            @Nonnull final String paymentCardID,
            @Nonnull final UUID cADocumentContainerInvoiceUUID,
            @Nonnull final String cADocumentNumber,
            @Nonnull final String cARepetitionItemNumber,
            @Nonnull final String cABPItemNumber,
            @Nonnull final String cASubItemNumber )
    {
        final Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("PaymentCurrency", paymentCurrency);
        parameters.put("CAPaymentAmountInPaytCurrency", cAPaymentAmountInPaytCurrency);
        parameters.put("PaymentCardID", paymentCardID);
        parameters.put("CADocumentContainerInvoiceUUID", cADocumentContainerInvoiceUUID);
        parameters.put("CADocumentNumber", cADocumentNumber);
        parameters.put("CARepetitionItemNumber", cARepetitionItemNumber);
        parameters.put("CABPItemNumber", cABPItemNumber);
        parameters.put("CASubItemNumber", cASubItemNumber);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<BusPartPaymentHeader, BusPartPaymentHeader>(
            BusPartPaymentHeader.class,
            BusPartPaymentHeader.class,
            "com.sap.gateway.srvd_a2x.api_cabuspartpayment.v0001.ReleasePaymentByPaymentCardID",
            parameters);
    }

    /**
     * Action that can be applied to a collection of entities of this class.
     * </p>
     * 
     * @param cAPaymentAmountInPaytCurrency
     *            Constraints: Not nullable, Precision: 13, Scale: 0
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAPaymentAmountInPaytCurrency</b>
     *            </p>
     * @param cADocumentContainerInvoiceUUID
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADocumentContainerInvoiceUUID</b>
     *            </p>
     * @param cADocumentNumber
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADocumentNumber</b>
     *            </p>
     * @param cABPItemNumber
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CABPItemNumber</b>
     *            </p>
     * @param paymentServiceProvider
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentServiceProvider</b>
     *            </p>
     * @param originalSourceOfCredit
     *            Constraints: Not nullable, Maximum length: 1
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OriginalSourceOfCredit</b>
     *            </p>
     * @param cARepetitionItemNumber
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CARepetitionItemNumber</b>
     *            </p>
     * @param paymentRefByPaytSrvcProvider
     *            Constraints: Not nullable, Maximum length: 35
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentRefByPaytSrvcProvider</b>
     *            </p>
     * @param paymentCurrency
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PaymentCurrency</b>
     *            </p>
     * @param cAAltvBPForPayment
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAAltvBPForPayment</b>
     *            </p>
     * @param origlPaytRefByPaytSrvcProvider
     *            Constraints: Not nullable, Maximum length: 35
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OriglPaytRefByPaytSrvcProvider</b>
     *            </p>
     * @param cASubItemNumber
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASubItemNumber</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to a collection of entities of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<BusPartPaymentHeader, BusPartPaymentHeader>
        payByPaymentServiceProvider(
            @Nonnull final String paymentCurrency,
            @Nonnull final BigDecimal cAPaymentAmountInPaytCurrency,
            @Nonnull final String paymentServiceProvider,
            @Nonnull final String paymentRefByPaytSrvcProvider,
            @Nonnull final String origlPaytRefByPaytSrvcProvider,
            @Nonnull final String originalSourceOfCredit,
            @Nonnull final UUID cADocumentContainerInvoiceUUID,
            @Nonnull final String cADocumentNumber,
            @Nonnull final String cARepetitionItemNumber,
            @Nonnull final String cABPItemNumber,
            @Nonnull final String cASubItemNumber,
            @Nonnull final String cAAltvBPForPayment )
    {
        final Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("PaymentCurrency", paymentCurrency);
        parameters.put("CAPaymentAmountInPaytCurrency", cAPaymentAmountInPaytCurrency);
        parameters.put("PaymentServiceProvider", paymentServiceProvider);
        parameters.put("PaymentRefByPaytSrvcProvider", paymentRefByPaytSrvcProvider);
        parameters.put("OriglPaytRefByPaytSrvcProvider", origlPaytRefByPaytSrvcProvider);
        parameters.put("OriginalSourceOfCredit", originalSourceOfCredit);
        parameters.put("CADocumentContainerInvoiceUUID", cADocumentContainerInvoiceUUID);
        parameters.put("CADocumentNumber", cADocumentNumber);
        parameters.put("CARepetitionItemNumber", cARepetitionItemNumber);
        parameters.put("CABPItemNumber", cABPItemNumber);
        parameters.put("CASubItemNumber", cASubItemNumber);
        parameters.put("CAAltvBPForPayment", cAAltvBPForPayment);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<BusPartPaymentHeader, BusPartPaymentHeader>(
            BusPartPaymentHeader.class,
            BusPartPaymentHeader.class,
            "com.sap.gateway.srvd_a2x.api_cabuspartpayment.v0001.PayByPaymentServiceProvider",
            parameters);
    }

}
