/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.result.ElementName;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>BusPartPaymentItemType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BusPartPaymentItem extends VdmEntity<BusPartPaymentItem>
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_cabuspartpayment.v0001.BusPartPaymentItemType";
    /**
     * Selector for all available fields of BusPartPaymentItem.
     * 
     */
    public final static SimpleProperty<BusPartPaymentItem> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerUUID</b>
     * </p>
     * 
     * @return Document Container ID
     */
    @Nullable
    @ElementName( "CADocumentContainerUUID" )
    private UUID cADocumentContainerUUID;
    public final static SimpleProperty.Guid<BusPartPaymentItem> CA_DOCUMENT_CONTAINER_UUID =
        new SimpleProperty.Guid<BusPartPaymentItem>(BusPartPaymentItem.class, "CADocumentContainerUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerSqncNumber</b>
     * </p>
     * 
     * @return Sequence Number
     */
    @Nullable
    @ElementName( "CADocumentContainerSqncNumber" )
    private java.lang.String cADocumentContainerSqncNumber;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_DOCUMENT_CONTAINER_SQNC_NUMBER =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CADocumentContainerSqncNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentDocument</b>
     * </p>
     * 
     * @return Document
     */
    @Nullable
    @ElementName( "CAPaymentDocument" )
    private java.lang.String cAPaymentDocument;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_PAYMENT_DOCUMENT =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CAPaymentDocument");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Day On Which Accounting Document Was Entered
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<BusPartPaymentItem> CREATION_DATE =
        new SimpleProperty.Date<BusPartPaymentItem>(BusPartPaymentItem.class, "CreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @return Time of Entry
     */
    @Nullable
    @ElementName( "CreationTime" )
    private LocalTime creationTime;
    public final static SimpleProperty.Time<BusPartPaymentItem> CREATION_TIME =
        new SimpleProperty.Time<BusPartPaymentItem>(BusPartPaymentItem.class, "CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerDocItemRefType</b>
     * </p>
     * 
     * @return Document Item Reference Category
     */
    @Nullable
    @ElementName( "CADocContainerDocItemRefType" )
    private java.lang.String cADocContainerDocItemRefType;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_DOC_CONTAINER_DOC_ITEM_REF_TYPE =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CADocContainerDocItemRefType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerDocItmRefTypeTxt</b>
     * </p>
     * 
     * @return Short Text for Fixed Values
     */
    @Nullable
    @ElementName( "CADocContainerDocItmRefTypeTxt" )
    private java.lang.String cADocContainerDocItmRefTypeTxt;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_DOC_CONTAINER_DOC_ITM_REF_TYPE_TXT =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CADocContainerDocItmRefTypeTxt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @return Business Partner Number
     */
    @Nullable
    @ElementName( "BusinessPartner" )
    private java.lang.String businessPartner;
    public final static SimpleProperty.String<BusPartPaymentItem> BUSINESS_PARTNER =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFullName</b>
     * </p>
     * 
     * @return The businessPartnerFullName contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "BusinessPartnerFullName" )
    private java.lang.String businessPartnerFullName;
    public final static SimpleProperty.String<BusPartPaymentItem> BUSINESS_PARTNER_FULL_NAME =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "BusinessPartnerFullName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @return Contract Account
     */
    @Nullable
    @ElementName( "ContractAccount" )
    private java.lang.String contractAccount;
    public final static SimpleProperty.String<BusPartPaymentItem> CONTRACT_ACCOUNT =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "ContractAccount");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccountName</b>
     * </p>
     * 
     * @return Description of Contract Account
     */
    @Nullable
    @ElementName( "ContractAccountName" )
    private java.lang.String contractAccountName;
    public final static SimpleProperty.String<BusPartPaymentItem> CONTRACT_ACCOUNT_NAME =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "ContractAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAContract</b>
     * </p>
     * 
     * @return Reference Specifications from Contract
     */
    @Nullable
    @ElementName( "CAContract" )
    private java.lang.String cAContract;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_CONTRACT =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CAContract");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplication</b>
     * </p>
     * 
     * @return Subapplication in Contract Accounts Receivable and Payable
     */
    @Nullable
    @ElementName( "CASubApplication" )
    private java.lang.String cASubApplication;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_SUB_APPLICATION =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CASubApplication");
    /**
     * Constraints: Not nullable, Maximum length: 250
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplicationText</b>
     * </p>
     * 
     * @return Description (250 Characters)
     */
    @Nullable
    @ElementName( "CASubApplicationText" )
    private java.lang.String cASubApplicationText;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_SUB_APPLICATION_TEXT =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CASubApplicationText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<BusPartPaymentItem> COMPANY_CODE =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     * 
     * @return Name of Company Code or Company
     */
    @Nullable
    @ElementName( "CompanyCodeName" )
    private java.lang.String companyCodeName;
    public final static SimpleProperty.String<BusPartPaymentItem> COMPANY_CODE_NAME =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CompanyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingForPayment</b>
     * </p>
     * 
     * @return Grouping field for automatic payments
     */
    @Nullable
    @ElementName( "CAGroupingForPayment" )
    private java.lang.String cAGroupingForPayment;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_GROUPING_FOR_PAYMENT =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CAGroupingForPayment");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerInvoiceUUID</b>
     * </p>
     * 
     * @return Document Container ID
     */
    @Nullable
    @ElementName( "CADocumentContainerInvoiceUUID" )
    private UUID cADocumentContainerInvoiceUUID;
    public final static SimpleProperty.Guid<BusPartPaymentItem> CA_DOCUMENT_CONTAINER_INVOICE_UUID =
        new SimpleProperty.Guid<BusPartPaymentItem>(BusPartPaymentItem.class, "CADocumentContainerInvoiceUUID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerInvoiceSqncNmbr</b>
     * </p>
     * 
     * @return Sequence Number
     */
    @Nullable
    @ElementName( "CADocContainerInvoiceSqncNmbr" )
    private java.lang.String cADocContainerInvoiceSqncNmbr;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_DOC_CONTAINER_INVOICE_SQNC_NMBR =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CADocContainerInvoiceSqncNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     * 
     * @return Business Area
     */
    @Nullable
    @ElementName( "BusinessArea" )
    private java.lang.String businessArea;
    public final static SimpleProperty.String<BusPartPaymentItem> BUSINESS_AREA =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     * 
     * @return Business Area Description
     */
    @Nullable
    @ElementName( "BusinessAreaName" )
    private java.lang.String businessAreaName;
    public final static SimpleProperty.String<BusPartPaymentItem> BUSINESS_AREA_NAME =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "BusinessAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     * 
     * @return Segment for Segmental Reporting
     */
    @Nullable
    @ElementName( "Segment" )
    private java.lang.String segment;
    public final static SimpleProperty.String<BusPartPaymentItem> SEGMENT =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "Segment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SegmentName</b>
     * </p>
     * 
     * @return Segment Name
     */
    @Nullable
    @ElementName( "SegmentName" )
    private java.lang.String segmentName;
    public final static SimpleProperty.String<BusPartPaymentItem> SEGMENT_NAME =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "SegmentName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingReason</b>
     * </p>
     * 
     * @return The cAClearingReason contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAClearingReason" )
    private java.lang.String cAClearingReason;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_CLEARING_REASON =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CAClearingReason");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingReasonName</b>
     * </p>
     * 
     * @return Name
     */
    @Nullable
    @ElementName( "CAClearingReasonName" )
    private java.lang.String cAClearingReasonName;
    public final static SimpleProperty.String<BusPartPaymentItem> CA_CLEARING_REASON_NAME =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "CAClearingReasonName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisplayCurrency</b>
     * </p>
     * 
     * @return The displayCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "DisplayCurrency" )
    private java.lang.String displayCurrency;
    public final static SimpleProperty.String<BusPartPaymentItem> DISPLAY_CURRENCY =
        new SimpleProperty.String<BusPartPaymentItem>(BusPartPaymentItem.class, "DisplayCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AmountInDisplayCurrency</b>
     * </p>
     * 
     * @return The amountInDisplayCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "AmountInDisplayCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal amountInDisplayCurrency;
    public final static SimpleProperty.NumericDecimal<BusPartPaymentItem> AMOUNT_IN_DISPLAY_CURRENCY =
        new SimpleProperty.NumericDecimal<BusPartPaymentItem>(BusPartPaymentItem.class, "AmountInDisplayCurrency");
    /**
     * Navigation property <b>Parameters</b> for <b>BusPartPaymentItem</b> to single
     * <b>BusPartPaymentItemParameters</b>.
     * 
     */
    @ElementName( "Parameters" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusPartPaymentItemParameters toParameters;
    /**
     * Use with available request builders to apply the <b>Parameters</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusPartPaymentItem, BusPartPaymentItemParameters> TO_PARAMETERS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusPartPaymentItem, BusPartPaymentItemParameters>(
            BusPartPaymentItem.class,
            "Parameters",
            BusPartPaymentItemParameters.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BusPartPaymentItem> getType()
    {
        return BusPartPaymentItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerUUID</b>
     * </p>
     * 
     * @param cADocumentContainerUUID
     *            Document Container ID
     */
    public void setCADocumentContainerUUID( @Nullable final UUID cADocumentContainerUUID )
    {
        rememberChangedField("CADocumentContainerUUID", this.cADocumentContainerUUID);
        this.cADocumentContainerUUID = cADocumentContainerUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerSqncNumber</b>
     * </p>
     * 
     * @param cADocumentContainerSqncNumber
     *            Sequence Number
     */
    public void setCADocumentContainerSqncNumber( @Nullable final java.lang.String cADocumentContainerSqncNumber )
    {
        rememberChangedField("CADocumentContainerSqncNumber", this.cADocumentContainerSqncNumber);
        this.cADocumentContainerSqncNumber = cADocumentContainerSqncNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentDocument</b>
     * </p>
     * 
     * @param cAPaymentDocument
     *            Document
     */
    public void setCAPaymentDocument( @Nullable final java.lang.String cAPaymentDocument )
    {
        rememberChangedField("CAPaymentDocument", this.cAPaymentDocument);
        this.cAPaymentDocument = cAPaymentDocument;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Day On Which Accounting Document Was Entered
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @param creationTime
     *            Time of Entry
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerDocItemRefType</b>
     * </p>
     * 
     * @param cADocContainerDocItemRefType
     *            Document Item Reference Category
     */
    public void setCADocContainerDocItemRefType( @Nullable final java.lang.String cADocContainerDocItemRefType )
    {
        rememberChangedField("CADocContainerDocItemRefType", this.cADocContainerDocItemRefType);
        this.cADocContainerDocItemRefType = cADocContainerDocItemRefType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerDocItmRefTypeTxt</b>
     * </p>
     * 
     * @param cADocContainerDocItmRefTypeTxt
     *            Short Text for Fixed Values
     */
    public void setCADocContainerDocItmRefTypeTxt( @Nullable final java.lang.String cADocContainerDocItmRefTypeTxt )
    {
        rememberChangedField("CADocContainerDocItmRefTypeTxt", this.cADocContainerDocItmRefTypeTxt);
        this.cADocContainerDocItmRefTypeTxt = cADocContainerDocItmRefTypeTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final java.lang.String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFullName</b>
     * </p>
     * 
     * @param businessPartnerFullName
     *            The businessPartnerFullName to set.
     */
    public void setBusinessPartnerFullName( @Nullable final java.lang.String businessPartnerFullName )
    {
        rememberChangedField("BusinessPartnerFullName", this.businessPartnerFullName);
        this.businessPartnerFullName = businessPartnerFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @param contractAccount
     *            Contract Account
     */
    public void setContractAccount( @Nullable final java.lang.String contractAccount )
    {
        rememberChangedField("ContractAccount", this.contractAccount);
        this.contractAccount = contractAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccountName</b>
     * </p>
     * 
     * @param contractAccountName
     *            Description of Contract Account
     */
    public void setContractAccountName( @Nullable final java.lang.String contractAccountName )
    {
        rememberChangedField("ContractAccountName", this.contractAccountName);
        this.contractAccountName = contractAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAContract</b>
     * </p>
     * 
     * @param cAContract
     *            Reference Specifications from Contract
     */
    public void setCAContract( @Nullable final java.lang.String cAContract )
    {
        rememberChangedField("CAContract", this.cAContract);
        this.cAContract = cAContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplication</b>
     * </p>
     * 
     * @param cASubApplication
     *            Subapplication in Contract Accounts Receivable and Payable
     */
    public void setCASubApplication( @Nullable final java.lang.String cASubApplication )
    {
        rememberChangedField("CASubApplication", this.cASubApplication);
        this.cASubApplication = cASubApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 250
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplicationText</b>
     * </p>
     * 
     * @param cASubApplicationText
     *            Description (250 Characters)
     */
    public void setCASubApplicationText( @Nullable final java.lang.String cASubApplicationText )
    {
        rememberChangedField("CASubApplicationText", this.cASubApplicationText);
        this.cASubApplicationText = cASubApplicationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     * 
     * @param companyCodeName
     *            Name of Company Code or Company
     */
    public void setCompanyCodeName( @Nullable final java.lang.String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingForPayment</b>
     * </p>
     * 
     * @param cAGroupingForPayment
     *            Grouping field for automatic payments
     */
    public void setCAGroupingForPayment( @Nullable final java.lang.String cAGroupingForPayment )
    {
        rememberChangedField("CAGroupingForPayment", this.cAGroupingForPayment);
        this.cAGroupingForPayment = cAGroupingForPayment;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentContainerInvoiceUUID</b>
     * </p>
     * 
     * @param cADocumentContainerInvoiceUUID
     *            Document Container ID
     */
    public void setCADocumentContainerInvoiceUUID( @Nullable final UUID cADocumentContainerInvoiceUUID )
    {
        rememberChangedField("CADocumentContainerInvoiceUUID", this.cADocumentContainerInvoiceUUID);
        this.cADocumentContainerInvoiceUUID = cADocumentContainerInvoiceUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainerInvoiceSqncNmbr</b>
     * </p>
     * 
     * @param cADocContainerInvoiceSqncNmbr
     *            Sequence Number
     */
    public void setCADocContainerInvoiceSqncNmbr( @Nullable final java.lang.String cADocContainerInvoiceSqncNmbr )
    {
        rememberChangedField("CADocContainerInvoiceSqncNmbr", this.cADocContainerInvoiceSqncNmbr);
        this.cADocContainerInvoiceSqncNmbr = cADocContainerInvoiceSqncNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     * 
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final java.lang.String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BusinessAreaName</b>
     * </p>
     * 
     * @param businessAreaName
     *            Business Area Description
     */
    public void setBusinessAreaName( @Nullable final java.lang.String businessAreaName )
    {
        rememberChangedField("BusinessAreaName", this.businessAreaName);
        this.businessAreaName = businessAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     * 
     * @param segment
     *            Segment for Segmental Reporting
     */
    public void setSegment( @Nullable final java.lang.String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SegmentName</b>
     * </p>
     * 
     * @param segmentName
     *            Segment Name
     */
    public void setSegmentName( @Nullable final java.lang.String segmentName )
    {
        rememberChangedField("SegmentName", this.segmentName);
        this.segmentName = segmentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingReason</b>
     * </p>
     * 
     * @param cAClearingReason
     *            The cAClearingReason to set.
     */
    public void setCAClearingReason( @Nullable final java.lang.String cAClearingReason )
    {
        rememberChangedField("CAClearingReason", this.cAClearingReason);
        this.cAClearingReason = cAClearingReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingReasonName</b>
     * </p>
     * 
     * @param cAClearingReasonName
     *            Name
     */
    public void setCAClearingReasonName( @Nullable final java.lang.String cAClearingReasonName )
    {
        rememberChangedField("CAClearingReasonName", this.cAClearingReasonName);
        this.cAClearingReasonName = cAClearingReasonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisplayCurrency</b>
     * </p>
     * 
     * @param displayCurrency
     *            The displayCurrency to set.
     */
    public void setDisplayCurrency( @Nullable final java.lang.String displayCurrency )
    {
        rememberChangedField("DisplayCurrency", this.displayCurrency);
        this.displayCurrency = displayCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AmountInDisplayCurrency</b>
     * </p>
     * 
     * @param amountInDisplayCurrency
     *            The amountInDisplayCurrency to set.
     */
    public void setAmountInDisplayCurrency( @Nullable final BigDecimal amountInDisplayCurrency )
    {
        rememberChangedField("AmountInDisplayCurrency", this.amountInDisplayCurrency);
        this.amountInDisplayCurrency = amountInDisplayCurrency;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "Set";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentContainerUUID", getCADocumentContainerUUID());
        entityKey.addKeyProperty("CADocumentContainerSqncNumber", getCADocumentContainerSqncNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentContainerUUID", getCADocumentContainerUUID());
        values.put("CADocumentContainerSqncNumber", getCADocumentContainerSqncNumber());
        values.put("CAPaymentDocument", getCAPaymentDocument());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("CADocContainerDocItemRefType", getCADocContainerDocItemRefType());
        values.put("CADocContainerDocItmRefTypeTxt", getCADocContainerDocItmRefTypeTxt());
        values.put("BusinessPartner", getBusinessPartner());
        values.put("BusinessPartnerFullName", getBusinessPartnerFullName());
        values.put("ContractAccount", getContractAccount());
        values.put("ContractAccountName", getContractAccountName());
        values.put("CAContract", getCAContract());
        values.put("CASubApplication", getCASubApplication());
        values.put("CASubApplicationText", getCASubApplicationText());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("CAGroupingForPayment", getCAGroupingForPayment());
        values.put("CADocumentContainerInvoiceUUID", getCADocumentContainerInvoiceUUID());
        values.put("CADocContainerInvoiceSqncNmbr", getCADocContainerInvoiceSqncNmbr());
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessAreaName", getBusinessAreaName());
        values.put("Segment", getSegment());
        values.put("SegmentName", getSegmentName());
        values.put("CAClearingReason", getCAClearingReason());
        values.put("CAClearingReasonName", getCAClearingReasonName());
        values.put("DisplayCurrency", getDisplayCurrency());
        values.put("AmountInDisplayCurrency", getAmountInDisplayCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentContainerUUID") ) {
                final Object value = values.remove("CADocumentContainerUUID");
                if( (value == null) || (!value.equals(getCADocumentContainerUUID())) ) {
                    setCADocumentContainerUUID(((UUID) value));
                }
            }
            if( values.containsKey("CADocumentContainerSqncNumber") ) {
                final Object value = values.remove("CADocumentContainerSqncNumber");
                if( (value == null) || (!value.equals(getCADocumentContainerSqncNumber())) ) {
                    setCADocumentContainerSqncNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPaymentDocument") ) {
                final Object value = values.remove("CAPaymentDocument");
                if( (value == null) || (!value.equals(getCAPaymentDocument())) ) {
                    setCAPaymentDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CADocContainerDocItemRefType") ) {
                final Object value = values.remove("CADocContainerDocItemRefType");
                if( (value == null) || (!value.equals(getCADocContainerDocItemRefType())) ) {
                    setCADocContainerDocItemRefType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocContainerDocItmRefTypeTxt") ) {
                final Object value = values.remove("CADocContainerDocItmRefTypeTxt");
                if( (value == null) || (!value.equals(getCADocContainerDocItmRefTypeTxt())) ) {
                    setCADocContainerDocItmRefTypeTxt(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartnerFullName") ) {
                final Object value = values.remove("BusinessPartnerFullName");
                if( (value == null) || (!value.equals(getBusinessPartnerFullName())) ) {
                    setBusinessPartnerFullName(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractAccount") ) {
                final Object value = values.remove("ContractAccount");
                if( (value == null) || (!value.equals(getContractAccount())) ) {
                    setContractAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractAccountName") ) {
                final Object value = values.remove("ContractAccountName");
                if( (value == null) || (!value.equals(getContractAccountName())) ) {
                    setContractAccountName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAContract") ) {
                final Object value = values.remove("CAContract");
                if( (value == null) || (!value.equals(getCAContract())) ) {
                    setCAContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubApplication") ) {
                final Object value = values.remove("CASubApplication");
                if( (value == null) || (!value.equals(getCASubApplication())) ) {
                    setCASubApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubApplicationText") ) {
                final Object value = values.remove("CASubApplicationText");
                if( (value == null) || (!value.equals(getCASubApplicationText())) ) {
                    setCASubApplicationText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGroupingForPayment") ) {
                final Object value = values.remove("CAGroupingForPayment");
                if( (value == null) || (!value.equals(getCAGroupingForPayment())) ) {
                    setCAGroupingForPayment(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentContainerInvoiceUUID") ) {
                final Object value = values.remove("CADocumentContainerInvoiceUUID");
                if( (value == null) || (!value.equals(getCADocumentContainerInvoiceUUID())) ) {
                    setCADocumentContainerInvoiceUUID(((UUID) value));
                }
            }
            if( values.containsKey("CADocContainerInvoiceSqncNmbr") ) {
                final Object value = values.remove("CADocContainerInvoiceSqncNmbr");
                if( (value == null) || (!value.equals(getCADocContainerInvoiceSqncNmbr())) ) {
                    setCADocContainerInvoiceSqncNmbr(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessAreaName") ) {
                final Object value = values.remove("BusinessAreaName");
                if( (value == null) || (!value.equals(getBusinessAreaName())) ) {
                    setBusinessAreaName(((java.lang.String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((java.lang.String) value));
                }
            }
            if( values.containsKey("SegmentName") ) {
                final Object value = values.remove("SegmentName");
                if( (value == null) || (!value.equals(getSegmentName())) ) {
                    setSegmentName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAClearingReason") ) {
                final Object value = values.remove("CAClearingReason");
                if( (value == null) || (!value.equals(getCAClearingReason())) ) {
                    setCAClearingReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAClearingReasonName") ) {
                final Object value = values.remove("CAClearingReasonName");
                if( (value == null) || (!value.equals(getCAClearingReasonName())) ) {
                    setCAClearingReasonName(((java.lang.String) value));
                }
            }
            if( values.containsKey("DisplayCurrency") ) {
                final Object value = values.remove("DisplayCurrency");
                if( (value == null) || (!value.equals(getDisplayCurrency())) ) {
                    setDisplayCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("AmountInDisplayCurrency") ) {
                final Object value = values.remove("AmountInDisplayCurrency");
                if( (value == null) || (!value.equals(getAmountInDisplayCurrency())) ) {
                    setAmountInDisplayCurrency(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Parameters") ) {
                final Object value = (values).remove("Parameters");
                if( value instanceof Map ) {
                    if( toParameters == null ) {
                        toParameters = new BusPartPaymentItemParameters();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    toParameters.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( toParameters != null ) {
            (values).put("Parameters", toParameters);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>BusPartPaymentItemParameters</b> entity (one to one). This corresponds to the OData
     * navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property for an entity <b>BusPartPaymentItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>Parameters</b> is already loaded, the result will contain
     *         the <b>BusPartPaymentItemParameters</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusPartPaymentItemParameters> getParametersIfPresent()
    {
        return Option.of(toParameters);
    }

    /**
     * Overwrites the associated <b>BusPartPaymentItemParameters</b> entity for the loaded navigation property
     * <b>Parameters</b>.
     * 
     * @param value
     *            New <b>BusPartPaymentItemParameters</b> entity.
     */
    public void setParameters( final BusPartPaymentItemParameters value )
    {
        toParameters = value;
    }

    /**
     * Helper class to allow for fluent creation of BusPartPaymentItem instances.
     * 
     */
    public final static class BusPartPaymentItemBuilder
    {

        private BusPartPaymentItemParameters toParameters;

        private BusPartPaymentItem.BusPartPaymentItemBuilder toParameters( final BusPartPaymentItemParameters value )
        {
            toParameters = value;
            return this;
        }

        /**
         * Navigation property <b>Parameters</b> for <b>BusPartPaymentItem</b> to single
         * <b>BusPartPaymentItemParameters</b>.
         * 
         * @param value
         *            The BusPartPaymentItemParameters to build this BusPartPaymentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusPartPaymentItem.BusPartPaymentItemBuilder parameters( final BusPartPaymentItemParameters value )
        {
            return toParameters(value);
        }

    }

}
