/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingBusinessPartnerPaymentService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>BusPartPaymentParameters</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BusPartPaymentParameters extends VdmEntity<BusPartPaymentParameters> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_cabuspartpayment.v0001.BusPartPaymentParameters";
    /**
     * Selector for all available fields of BusPartPaymentParameters.
     * 
     */
    public final static SimpleProperty<BusPartPaymentParameters> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>P_DisplayCurrency</b>
     * </p>
     * 
     * @return Currency Key
     */
    @Nullable
    @ElementName( "P_DisplayCurrency" )
    private java.lang.String p_DisplayCurrency;
    public final static SimpleProperty.String<BusPartPaymentParameters> P_DISPLAY_CURRENCY =
        new SimpleProperty.String<BusPartPaymentParameters>(BusPartPaymentParameters.class, "P_DisplayCurrency");
    /**
     * Navigation property <b>Set</b> for <b>BusPartPaymentParameters</b> to multiple <b>BusPartPayment</b>.
     * 
     */
    @ElementName( "Set" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusPartPayment> toSet;
    /**
     * Use with available request builders to apply the <b>Set</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<BusPartPaymentParameters, BusPartPayment> TO_SET =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<BusPartPaymentParameters, BusPartPayment>(
            BusPartPaymentParameters.class,
            "Set",
            BusPartPayment.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BusPartPaymentParameters> getType()
    {
        return BusPartPaymentParameters.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>P_DisplayCurrency</b>
     * </p>
     * 
     * @param p_DisplayCurrency
     *            Currency Key
     */
    public void setP_DisplayCurrency( @Nullable final java.lang.String p_DisplayCurrency )
    {
        rememberChangedField("P_DisplayCurrency", this.p_DisplayCurrency);
        this.p_DisplayCurrency = p_DisplayCurrency;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "BusPartPayment";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("P_DisplayCurrency", getP_DisplayCurrency());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("P_DisplayCurrency", getP_DisplayCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("P_DisplayCurrency") ) {
                final Object value = values.remove("P_DisplayCurrency");
                if( (value == null) || (!value.equals(getP_DisplayCurrency())) ) {
                    setP_DisplayCurrency(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Set") ) {
                final Object value = (values).remove("Set");
                if( value instanceof Iterable ) {
                    if( toSet == null ) {
                        toSet = Lists.newArrayList();
                    } else {
                        toSet = Lists.newArrayList(toSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusPartPayment entity;
                        if( toSet.size() > i ) {
                            entity = toSet.get(i);
                        } else {
                            entity = new BusPartPayment();
                            toSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingBusinessPartnerPaymentService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( toSet != null ) {
            (values).put("Set", toSet);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>BusPartPayment</b> entities (one to many). This corresponds to the OData navigation
     * property <b>Set</b>.
     * <p>
     * If the navigation property for an entity <b>BusPartPaymentParameters</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>Set</b> is already loaded, the result will contain the
     *         <b>BusPartPayment</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<BusPartPayment>> getSetIfPresent()
    {
        return Option.of(toSet);
    }

    /**
     * Overwrites the list of associated <b>BusPartPayment</b> entities for the loaded navigation property <b>Set</b>.
     * <p>
     * If the navigation property <b>Set</b> of a queried <b>BusPartPaymentParameters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>BusPartPayment</b> entities.
     */
    public void setSet( @Nonnull final List<BusPartPayment> value )
    {
        if( toSet == null ) {
            toSet = Lists.newArrayList();
        }
        toSet.clear();
        toSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusPartPayment</b> entities. This corresponds to the OData navigation
     * property <b>Set</b>.
     * <p>
     * If the navigation property <b>Set</b> of a queried <b>BusPartPaymentParameters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>BusPartPayment</b> entities.
     */
    public void addSet( BusPartPayment... entity )
    {
        if( toSet == null ) {
            toSet = Lists.newArrayList();
        }
        toSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusPartPaymentParameters instances.
     * 
     */
    public final static class BusPartPaymentParametersBuilder
    {

        private List<BusPartPayment> toSet = Lists.newArrayList();

        private BusPartPaymentParameters.BusPartPaymentParametersBuilder toSet( final List<BusPartPayment> value )
        {
            toSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>Set</b> for <b>BusPartPaymentParameters</b> to multiple <b>BusPartPayment</b>.
         * 
         * @param value
         *            The BusPartPayments to build this BusPartPaymentParameters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusPartPaymentParameters.BusPartPaymentParametersBuilder set( BusPartPayment... value )
        {
            return toSet(Lists.newArrayList(value));
        }

    }

}
