/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingcreditworthiness;

import java.time.LocalDate;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingCreditworthinessService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Credit Worthiness
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CreditWorthinessType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class CreditWorthiness extends VdmEntity<CreditWorthiness> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_cacreditworthiness.v0001.CreditWorthinessType";
    /**
     * Selector for all available fields of CreditWorthiness.
     * 
     */
    public final static SimpleProperty<CreditWorthiness> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @return Business Partner Number
     */
    @Nullable
    @ElementName( "BusinessPartner" )
    private java.lang.String businessPartner;
    public final static SimpleProperty.String<CreditWorthiness> BUSINESS_PARTNER =
        new SimpleProperty.String<CreditWorthiness>(CreditWorthiness.class, "BusinessPartner");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CACreditWorthiness</b>
     * </p>
     * 
     * @return The cACreditWorthiness contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CACreditWorthiness" )
    private Short cACreditWorthiness;
    public final static SimpleProperty.NumericInteger<CreditWorthiness> CA_CREDIT_WORTHINESS =
        new SimpleProperty.NumericInteger<CreditWorthiness>(CreditWorthiness.class, "CACreditWorthiness");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAExternalCreditWorthinessVal</b>
     * </p>
     * 
     * @return Value of External Creditworthiness Valuation
     */
    @Nullable
    @ElementName( "CAExternalCreditWorthinessVal" )
    private java.lang.String cAExternalCreditWorthinessVal;
    public final static SimpleProperty.String<CreditWorthiness> CA_EXTERNAL_CREDIT_WORTHINESS_VAL =
        new SimpleProperty.String<CreditWorthiness>(CreditWorthiness.class, "CAExternalCreditWorthinessVal");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAExternalCreditWorthinessDate</b>
     * </p>
     * 
     * @return Date of Last Change to Rating
     */
    @Nullable
    @ElementName( "CAExternalCreditWorthinessDate" )
    private LocalDate cAExternalCreditWorthinessDate;
    public final static SimpleProperty.Date<CreditWorthiness> CA_EXTERNAL_CREDIT_WORTHINESS_DATE =
        new SimpleProperty.Date<CreditWorthiness>(CreditWorthiness.class, "CAExternalCreditWorthinessDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CACreditWorthinessFactorInPct</b>
     * </p>
     * 
     * @return Creditworthiness factor as a percentage
     */
    @Nullable
    @ElementName( "CACreditWorthinessFactorInPct" )
    private java.lang.String cACreditWorthinessFactorInPct;
    public final static SimpleProperty.String<CreditWorthiness> CA_CREDIT_WORTHINESS_FACTOR_IN_PCT =
        new SimpleProperty.String<CreditWorthiness>(CreditWorthiness.class, "CACreditWorthinessFactorInPct");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAManualCreditWorthinessValue</b>
     * </p>
     * 
     * @return Manual Creditworthiness
     */
    @Nullable
    @ElementName( "CAManualCreditWorthinessValue" )
    private java.lang.String cAManualCreditWorthinessValue;
    public final static SimpleProperty.String<CreditWorthiness> CA_MANUAL_CREDIT_WORTHINESS_VALUE =
        new SimpleProperty.String<CreditWorthiness>(CreditWorthiness.class, "CAManualCreditWorthinessValue");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAManualCreditWorthinessDate</b>
     * </p>
     * 
     * @return Date On Which Creditworthiness Was Manually Set
     */
    @Nullable
    @ElementName( "CAManualCreditWorthinessDate" )
    private LocalDate cAManualCreditWorthinessDate;
    public final static SimpleProperty.Date<CreditWorthiness> CA_MANUAL_CREDIT_WORTHINESS_DATE =
        new SimpleProperty.Date<CreditWorthiness>(CreditWorthiness.class, "CAManualCreditWorthinessDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAFrozenCreditWorthinessValue</b>
     * </p>
     * 
     * @return Fixed Creditworthiness
     */
    @Nullable
    @ElementName( "CAFrozenCreditWorthinessValue" )
    private java.lang.String cAFrozenCreditWorthinessValue;
    public final static SimpleProperty.String<CreditWorthiness> CA_FROZEN_CREDIT_WORTHINESS_VALUE =
        new SimpleProperty.String<CreditWorthiness>(CreditWorthiness.class, "CAFrozenCreditWorthinessValue");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAFrozenCreditWorthinessDate</b>
     * </p>
     * 
     * @return Date on Which Creditworthiness was Fixed
     */
    @Nullable
    @ElementName( "CAFrozenCreditWorthinessDate" )
    private LocalDate cAFrozenCreditWorthinessDate;
    public final static SimpleProperty.Date<CreditWorthiness> CA_FROZEN_CREDIT_WORTHINESS_DATE =
        new SimpleProperty.Date<CreditWorthiness>(CreditWorthiness.class, "CAFrozenCreditWorthinessDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAUnfrozenCreditWorthinessDate</b>
     * </p>
     * 
     * @return Release Date of Fixed Creditworthiness
     */
    @Nullable
    @ElementName( "CAUnfrozenCreditWorthinessDate" )
    private LocalDate cAUnfrozenCreditWorthinessDate;
    public final static SimpleProperty.Date<CreditWorthiness> CA_UNFROZEN_CREDIT_WORTHINESS_DATE =
        new SimpleProperty.Date<CreditWorthiness>(CreditWorthiness.class, "CAUnfrozenCreditWorthinessDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CACreditWorthinessIsFrozen</b>
     * </p>
     * 
     * @return The cACreditWorthinessIsFrozen contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CACreditWorthinessIsFrozen" )
    private java.lang.String cACreditWorthinessIsFrozen;
    public final static SimpleProperty.String<CreditWorthiness> CA_CREDIT_WORTHINESS_IS_FROZEN =
        new SimpleProperty.String<CreditWorthiness>(CreditWorthiness.class, "CACreditWorthinessIsFrozen");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<CreditWorthiness> getType()
    {
        return CreditWorthiness.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final java.lang.String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CACreditWorthiness</b>
     * </p>
     * 
     * @param cACreditWorthiness
     *            The cACreditWorthiness to set.
     */
    public void setCACreditWorthiness( @Nullable final Short cACreditWorthiness )
    {
        rememberChangedField("CACreditWorthiness", this.cACreditWorthiness);
        this.cACreditWorthiness = cACreditWorthiness;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAExternalCreditWorthinessVal</b>
     * </p>
     * 
     * @param cAExternalCreditWorthinessVal
     *            Value of External Creditworthiness Valuation
     */
    public void setCAExternalCreditWorthinessVal( @Nullable final java.lang.String cAExternalCreditWorthinessVal )
    {
        rememberChangedField("CAExternalCreditWorthinessVal", this.cAExternalCreditWorthinessVal);
        this.cAExternalCreditWorthinessVal = cAExternalCreditWorthinessVal;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAExternalCreditWorthinessDate</b>
     * </p>
     * 
     * @param cAExternalCreditWorthinessDate
     *            Date of Last Change to Rating
     */
    public void setCAExternalCreditWorthinessDate( @Nullable final LocalDate cAExternalCreditWorthinessDate )
    {
        rememberChangedField("CAExternalCreditWorthinessDate", this.cAExternalCreditWorthinessDate);
        this.cAExternalCreditWorthinessDate = cAExternalCreditWorthinessDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CACreditWorthinessFactorInPct</b>
     * </p>
     * 
     * @param cACreditWorthinessFactorInPct
     *            Creditworthiness factor as a percentage
     */
    public void setCACreditWorthinessFactorInPct( @Nullable final java.lang.String cACreditWorthinessFactorInPct )
    {
        rememberChangedField("CACreditWorthinessFactorInPct", this.cACreditWorthinessFactorInPct);
        this.cACreditWorthinessFactorInPct = cACreditWorthinessFactorInPct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAManualCreditWorthinessValue</b>
     * </p>
     * 
     * @param cAManualCreditWorthinessValue
     *            Manual Creditworthiness
     */
    public void setCAManualCreditWorthinessValue( @Nullable final java.lang.String cAManualCreditWorthinessValue )
    {
        rememberChangedField("CAManualCreditWorthinessValue", this.cAManualCreditWorthinessValue);
        this.cAManualCreditWorthinessValue = cAManualCreditWorthinessValue;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAManualCreditWorthinessDate</b>
     * </p>
     * 
     * @param cAManualCreditWorthinessDate
     *            Date On Which Creditworthiness Was Manually Set
     */
    public void setCAManualCreditWorthinessDate( @Nullable final LocalDate cAManualCreditWorthinessDate )
    {
        rememberChangedField("CAManualCreditWorthinessDate", this.cAManualCreditWorthinessDate);
        this.cAManualCreditWorthinessDate = cAManualCreditWorthinessDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAFrozenCreditWorthinessValue</b>
     * </p>
     * 
     * @param cAFrozenCreditWorthinessValue
     *            Fixed Creditworthiness
     */
    public void setCAFrozenCreditWorthinessValue( @Nullable final java.lang.String cAFrozenCreditWorthinessValue )
    {
        rememberChangedField("CAFrozenCreditWorthinessValue", this.cAFrozenCreditWorthinessValue);
        this.cAFrozenCreditWorthinessValue = cAFrozenCreditWorthinessValue;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAFrozenCreditWorthinessDate</b>
     * </p>
     * 
     * @param cAFrozenCreditWorthinessDate
     *            Date on Which Creditworthiness was Fixed
     */
    public void setCAFrozenCreditWorthinessDate( @Nullable final LocalDate cAFrozenCreditWorthinessDate )
    {
        rememberChangedField("CAFrozenCreditWorthinessDate", this.cAFrozenCreditWorthinessDate);
        this.cAFrozenCreditWorthinessDate = cAFrozenCreditWorthinessDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAUnfrozenCreditWorthinessDate</b>
     * </p>
     * 
     * @param cAUnfrozenCreditWorthinessDate
     *            Release Date of Fixed Creditworthiness
     */
    public void setCAUnfrozenCreditWorthinessDate( @Nullable final LocalDate cAUnfrozenCreditWorthinessDate )
    {
        rememberChangedField("CAUnfrozenCreditWorthinessDate", this.cAUnfrozenCreditWorthinessDate);
        this.cAUnfrozenCreditWorthinessDate = cAUnfrozenCreditWorthinessDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CACreditWorthinessIsFrozen</b>
     * </p>
     * 
     * @param cACreditWorthinessIsFrozen
     *            The cACreditWorthinessIsFrozen to set.
     */
    public void setCACreditWorthinessIsFrozen( @Nullable final java.lang.String cACreditWorthinessIsFrozen )
    {
        rememberChangedField("CACreditWorthinessIsFrozen", this.cACreditWorthinessIsFrozen);
        this.cACreditWorthinessIsFrozen = cACreditWorthinessIsFrozen;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "CreditWorthiness";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("BusinessPartner", getBusinessPartner());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("CACreditWorthiness", getCACreditWorthiness());
        values.put("CAExternalCreditWorthinessVal", getCAExternalCreditWorthinessVal());
        values.put("CAExternalCreditWorthinessDate", getCAExternalCreditWorthinessDate());
        values.put("CACreditWorthinessFactorInPct", getCACreditWorthinessFactorInPct());
        values.put("CAManualCreditWorthinessValue", getCAManualCreditWorthinessValue());
        values.put("CAManualCreditWorthinessDate", getCAManualCreditWorthinessDate());
        values.put("CAFrozenCreditWorthinessValue", getCAFrozenCreditWorthinessValue());
        values.put("CAFrozenCreditWorthinessDate", getCAFrozenCreditWorthinessDate());
        values.put("CAUnfrozenCreditWorthinessDate", getCAUnfrozenCreditWorthinessDate());
        values.put("CACreditWorthinessIsFrozen", getCACreditWorthinessIsFrozen());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACreditWorthiness") ) {
                final Object value = values.remove("CACreditWorthiness");
                if( (value == null) || (!value.equals(getCACreditWorthiness())) ) {
                    setCACreditWorthiness(((Short) value));
                }
            }
            if( values.containsKey("CAExternalCreditWorthinessVal") ) {
                final Object value = values.remove("CAExternalCreditWorthinessVal");
                if( (value == null) || (!value.equals(getCAExternalCreditWorthinessVal())) ) {
                    setCAExternalCreditWorthinessVal(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAExternalCreditWorthinessDate") ) {
                final Object value = values.remove("CAExternalCreditWorthinessDate");
                if( (value == null) || (!value.equals(getCAExternalCreditWorthinessDate())) ) {
                    setCAExternalCreditWorthinessDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CACreditWorthinessFactorInPct") ) {
                final Object value = values.remove("CACreditWorthinessFactorInPct");
                if( (value == null) || (!value.equals(getCACreditWorthinessFactorInPct())) ) {
                    setCACreditWorthinessFactorInPct(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAManualCreditWorthinessValue") ) {
                final Object value = values.remove("CAManualCreditWorthinessValue");
                if( (value == null) || (!value.equals(getCAManualCreditWorthinessValue())) ) {
                    setCAManualCreditWorthinessValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAManualCreditWorthinessDate") ) {
                final Object value = values.remove("CAManualCreditWorthinessDate");
                if( (value == null) || (!value.equals(getCAManualCreditWorthinessDate())) ) {
                    setCAManualCreditWorthinessDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAFrozenCreditWorthinessValue") ) {
                final Object value = values.remove("CAFrozenCreditWorthinessValue");
                if( (value == null) || (!value.equals(getCAFrozenCreditWorthinessValue())) ) {
                    setCAFrozenCreditWorthinessValue(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAFrozenCreditWorthinessDate") ) {
                final Object value = values.remove("CAFrozenCreditWorthinessDate");
                if( (value == null) || (!value.equals(getCAFrozenCreditWorthinessDate())) ) {
                    setCAFrozenCreditWorthinessDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAUnfrozenCreditWorthinessDate") ) {
                final Object value = values.remove("CAUnfrozenCreditWorthinessDate");
                if( (value == null) || (!value.equals(getCAUnfrozenCreditWorthinessDate())) ) {
                    setCAUnfrozenCreditWorthinessDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CACreditWorthinessIsFrozen") ) {
                final Object value = values.remove("CACreditWorthinessIsFrozen");
                if( (value == null) || (!value.equals(getCACreditWorthinessIsFrozen())) ) {
                    setCACreditWorthinessIsFrozen(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingCreditworthinessService.DEFAULT_SERVICE_PATH;
    }

}
