/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmComplex;
import com.sap.cloud.sdk.result.ElementName;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>D_CADisputeCaseCopyResult</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class D_CADisputeCaseCopyResult extends VdmComplex<D_CADisputeCaseCopyResult>
{

    @Getter
    private final String odataType = "com.sap.gateway.srvd_a2x.api_cadisputecase.v0001.D_CADisputeCaseCopyResult";
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseUUID</b>
     * </p>
     * 
     * @return The caseUUID contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseUUID" )
    private UUID caseUUID;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Guid<D_CADisputeCaseCopyResult> CASE_UUID =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Guid<D_CADisputeCaseCopyResult>(
            D_CADisputeCaseCopyResult.class,
            "CaseUUID");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<D_CADisputeCaseCopyResult> getType()
    {
        return D_CADisputeCaseCopyResult.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CaseUUID", getCaseUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CaseUUID") ) {
                final Object value = values.remove("CaseUUID");
                if( (value == null) || (!value.equals(getCaseUUID())) ) {
                    setCaseUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        return entityKey;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseUUID</b>
     * </p>
     * 
     * @param caseUUID
     *            The caseUUID to set.
     */
    public void setCaseUUID( @Nullable final UUID caseUUID )
    {
        rememberChangedField("CaseUUID", this.caseUUID);
        this.caseUUID = caseUUID;
    }

}
