/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmComplex;
import com.sap.cloud.sdk.result.ElementName;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>D_CADisputeCaseRetrieveAttchR</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class D_CADisputeCaseRetrieveAttchR extends VdmComplex<D_CADisputeCaseRetrieveAttchR>
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_cadisputecase.v0001.D_CADisputeCaseRetrieveAttchR";
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>CaseAttachmentContentBinary</b>
     * </p>
     * 
     * @return The caseAttachmentContentBinary contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseAttachmentContentBinary" )
    private byte[] caseAttachmentContentBinary;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Binary<D_CADisputeCaseRetrieveAttchR> CASE_ATTACHMENT_CONTENT_BINARY =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Binary<D_CADisputeCaseRetrieveAttchR>(
            D_CADisputeCaseRetrieveAttchR.class,
            "CaseAttachmentContentBinary");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseAttachmentCreatedByUser</b>
     * </p>
     * 
     * @return The caseAttachmentCreatedByUser contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseAttachmentCreatedByUser" )
    private java.lang.String caseAttachmentCreatedByUser;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveAttchR> CASE_ATTACHMENT_CREATED_BY_USER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveAttchR>(
            D_CADisputeCaseRetrieveAttchR.class,
            "CaseAttachmentCreatedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CaseAttachmentCreationDateTime</b>
     * </p>
     * 
     * @return The caseAttachmentCreationDateTime contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseAttachmentCreationDateTime" )
    private OffsetDateTime caseAttachmentCreationDateTime;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.DateTime<D_CADisputeCaseRetrieveAttchR> CASE_ATTACHMENT_CREATION_DATE_TIME =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.DateTime<D_CADisputeCaseRetrieveAttchR>(
            D_CADisputeCaseRetrieveAttchR.class,
            "CaseAttachmentCreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>CaseAttachmentName</b>
     * </p>
     * 
     * @return The caseAttachmentName contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseAttachmentName" )
    private java.lang.String caseAttachmentName;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveAttchR> CASE_ATTACHMENT_NAME =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveAttchR>(
            D_CADisputeCaseRetrieveAttchR.class,
            "CaseAttachmentName");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseUUID</b>
     * </p>
     * 
     * @return The caseUUID contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseUUID" )
    private UUID caseUUID;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Guid<D_CADisputeCaseRetrieveAttchR> CASE_UUID =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Guid<D_CADisputeCaseRetrieveAttchR>(
            D_CADisputeCaseRetrieveAttchR.class,
            "CaseUUID");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>MimeType</b>
     * </p>
     * 
     * @return The mimeType contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "MimeType" )
    private java.lang.String mimeType;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveAttchR> MIME_TYPE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveAttchR>(
            D_CADisputeCaseRetrieveAttchR.class,
            "MimeType");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<D_CADisputeCaseRetrieveAttchR> getType()
    {
        return D_CADisputeCaseRetrieveAttchR.class;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CaseAttachmentContentBinary", getCaseAttachmentContentBinary());
        values.put("CaseAttachmentCreatedByUser", getCaseAttachmentCreatedByUser());
        values.put("CaseAttachmentCreationDateTime", getCaseAttachmentCreationDateTime());
        values.put("CaseAttachmentName", getCaseAttachmentName());
        values.put("CaseUUID", getCaseUUID());
        values.put("MimeType", getMimeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CaseAttachmentContentBinary") ) {
                final Object value = values.remove("CaseAttachmentContentBinary");
                if( (value == null) || (!value.equals(getCaseAttachmentContentBinary())) ) {
                    setCaseAttachmentContentBinary(((byte[]) value));
                }
            }
            if( values.containsKey("CaseAttachmentCreatedByUser") ) {
                final Object value = values.remove("CaseAttachmentCreatedByUser");
                if( (value == null) || (!value.equals(getCaseAttachmentCreatedByUser())) ) {
                    setCaseAttachmentCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseAttachmentCreationDateTime") ) {
                final Object value = values.remove("CaseAttachmentCreationDateTime");
                if( (value == null) || (!value.equals(getCaseAttachmentCreationDateTime())) ) {
                    setCaseAttachmentCreationDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("CaseAttachmentName") ) {
                final Object value = values.remove("CaseAttachmentName");
                if( (value == null) || (!value.equals(getCaseAttachmentName())) ) {
                    setCaseAttachmentName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseUUID") ) {
                final Object value = values.remove("CaseUUID");
                if( (value == null) || (!value.equals(getCaseUUID())) ) {
                    setCaseUUID(((UUID) value));
                }
            }
            if( values.containsKey("MimeType") ) {
                final Object value = values.remove("MimeType");
                if( (value == null) || (!value.equals(getMimeType())) ) {
                    setMimeType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        return entityKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>CaseAttachmentContentBinary</b>
     * </p>
     * 
     * @param caseAttachmentContentBinary
     *            The caseAttachmentContentBinary to set.
     */
    public void setCaseAttachmentContentBinary( @Nullable final byte[] caseAttachmentContentBinary )
    {
        rememberChangedField("CaseAttachmentContentBinary", this.caseAttachmentContentBinary);
        this.caseAttachmentContentBinary = caseAttachmentContentBinary;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseAttachmentCreatedByUser</b>
     * </p>
     * 
     * @param caseAttachmentCreatedByUser
     *            The caseAttachmentCreatedByUser to set.
     */
    public void setCaseAttachmentCreatedByUser( @Nullable final java.lang.String caseAttachmentCreatedByUser )
    {
        rememberChangedField("CaseAttachmentCreatedByUser", this.caseAttachmentCreatedByUser);
        this.caseAttachmentCreatedByUser = caseAttachmentCreatedByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CaseAttachmentCreationDateTime</b>
     * </p>
     * 
     * @param caseAttachmentCreationDateTime
     *            The caseAttachmentCreationDateTime to set.
     */
    public void setCaseAttachmentCreationDateTime( @Nullable final OffsetDateTime caseAttachmentCreationDateTime )
    {
        rememberChangedField("CaseAttachmentCreationDateTime", this.caseAttachmentCreationDateTime);
        this.caseAttachmentCreationDateTime = caseAttachmentCreationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>CaseAttachmentName</b>
     * </p>
     * 
     * @param caseAttachmentName
     *            The caseAttachmentName to set.
     */
    public void setCaseAttachmentName( @Nullable final java.lang.String caseAttachmentName )
    {
        rememberChangedField("CaseAttachmentName", this.caseAttachmentName);
        this.caseAttachmentName = caseAttachmentName;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseUUID</b>
     * </p>
     * 
     * @param caseUUID
     *            The caseUUID to set.
     */
    public void setCaseUUID( @Nullable final UUID caseUUID )
    {
        rememberChangedField("CaseUUID", this.caseUUID);
        this.caseUUID = caseUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>MimeType</b>
     * </p>
     * 
     * @param mimeType
     *            The mimeType to set.
     */
    public void setMimeType( @Nullable final java.lang.String mimeType )
    {
        rememberChangedField("MimeType", this.mimeType);
        this.mimeType = mimeType;
    }

}
