/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmComplex;
import com.sap.cloud.sdk.result.ElementName;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>D_CADisputeCaseRetrieveNoteR</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class D_CADisputeCaseRetrieveNoteR extends VdmComplex<D_CADisputeCaseRetrieveNoteR>
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_cadisputecase.v0001.D_CADisputeCaseRetrieveNoteR";
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseNoteCreatedByUser</b>
     * </p>
     * 
     * @return The caseNoteCreatedByUser contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseNoteCreatedByUser" )
    private java.lang.String caseNoteCreatedByUser;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveNoteR> CASE_NOTE_CREATED_BY_USER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveNoteR>(
            D_CADisputeCaseRetrieveNoteR.class,
            "CaseNoteCreatedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CaseNoteLastChangeDateTime</b>
     * </p>
     * 
     * @return The caseNoteLastChangeDateTime contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseNoteLastChangeDateTime" )
    private OffsetDateTime caseNoteLastChangeDateTime;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.DateTime<D_CADisputeCaseRetrieveNoteR> CASE_NOTE_LAST_CHANGE_DATE_TIME =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.DateTime<D_CADisputeCaseRetrieveNoteR>(
            D_CADisputeCaseRetrieveNoteR.class,
            "CaseNoteLastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>CaseNoteText</b>
     * </p>
     * 
     * @return The caseNoteText contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseNoteText" )
    private java.lang.String caseNoteText;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveNoteR> CASE_NOTE_TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveNoteR>(
            D_CADisputeCaseRetrieveNoteR.class,
            "CaseNoteText");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CaseNoteTypeName</b>
     * </p>
     * 
     * @return The caseNoteTypeName contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseNoteTypeName" )
    private java.lang.String caseNoteTypeName;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveNoteR> CASE_NOTE_TYPE_NAME =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CADisputeCaseRetrieveNoteR>(
            D_CADisputeCaseRetrieveNoteR.class,
            "CaseNoteTypeName");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseUUID</b>
     * </p>
     * 
     * @return The caseUUID contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CaseUUID" )
    private UUID caseUUID;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Guid<D_CADisputeCaseRetrieveNoteR> CASE_UUID =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Guid<D_CADisputeCaseRetrieveNoteR>(
            D_CADisputeCaseRetrieveNoteR.class,
            "CaseUUID");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<D_CADisputeCaseRetrieveNoteR> getType()
    {
        return D_CADisputeCaseRetrieveNoteR.class;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CaseNoteCreatedByUser", getCaseNoteCreatedByUser());
        values.put("CaseNoteLastChangeDateTime", getCaseNoteLastChangeDateTime());
        values.put("CaseNoteText", getCaseNoteText());
        values.put("CaseNoteTypeName", getCaseNoteTypeName());
        values.put("CaseUUID", getCaseUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CaseNoteCreatedByUser") ) {
                final Object value = values.remove("CaseNoteCreatedByUser");
                if( (value == null) || (!value.equals(getCaseNoteCreatedByUser())) ) {
                    setCaseNoteCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseNoteLastChangeDateTime") ) {
                final Object value = values.remove("CaseNoteLastChangeDateTime");
                if( (value == null) || (!value.equals(getCaseNoteLastChangeDateTime())) ) {
                    setCaseNoteLastChangeDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("CaseNoteText") ) {
                final Object value = values.remove("CaseNoteText");
                if( (value == null) || (!value.equals(getCaseNoteText())) ) {
                    setCaseNoteText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseNoteTypeName") ) {
                final Object value = values.remove("CaseNoteTypeName");
                if( (value == null) || (!value.equals(getCaseNoteTypeName())) ) {
                    setCaseNoteTypeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseUUID") ) {
                final Object value = values.remove("CaseUUID");
                if( (value == null) || (!value.equals(getCaseUUID())) ) {
                    setCaseUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        return entityKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseNoteCreatedByUser</b>
     * </p>
     * 
     * @param caseNoteCreatedByUser
     *            The caseNoteCreatedByUser to set.
     */
    public void setCaseNoteCreatedByUser( @Nullable final java.lang.String caseNoteCreatedByUser )
    {
        rememberChangedField("CaseNoteCreatedByUser", this.caseNoteCreatedByUser);
        this.caseNoteCreatedByUser = caseNoteCreatedByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CaseNoteLastChangeDateTime</b>
     * </p>
     * 
     * @param caseNoteLastChangeDateTime
     *            The caseNoteLastChangeDateTime to set.
     */
    public void setCaseNoteLastChangeDateTime( @Nullable final OffsetDateTime caseNoteLastChangeDateTime )
    {
        rememberChangedField("CaseNoteLastChangeDateTime", this.caseNoteLastChangeDateTime);
        this.caseNoteLastChangeDateTime = caseNoteLastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>CaseNoteText</b>
     * </p>
     * 
     * @param caseNoteText
     *            The caseNoteText to set.
     */
    public void setCaseNoteText( @Nullable final java.lang.String caseNoteText )
    {
        rememberChangedField("CaseNoteText", this.caseNoteText);
        this.caseNoteText = caseNoteText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CaseNoteTypeName</b>
     * </p>
     * 
     * @param caseNoteTypeName
     *            The caseNoteTypeName to set.
     */
    public void setCaseNoteTypeName( @Nullable final java.lang.String caseNoteTypeName )
    {
        rememberChangedField("CaseNoteTypeName", this.caseNoteTypeName);
        this.caseNoteTypeName = caseNoteTypeName;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseUUID</b>
     * </p>
     * 
     * @param caseUUID
     *            The caseUUID to set.
     */
    public void setCaseUUID( @Nullable final UUID caseUUID )
    {
        rememberChangedField("CaseUUID", this.caseUUID);
        this.caseUUID = caseUUID;
    }

}
