/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingDisputeCaseService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Dispute Case
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>DisputeCaseType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class DisputeCase extends VdmEntity<DisputeCase> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_cadisputecase.v0001.DisputeCaseType";
    /**
     * Selector for all available fields of DisputeCase.
     * 
     */
    public final static SimpleProperty<DisputeCase> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseUUID</b>
     * </p>
     * 
     * @return UUID in Character Format
     */
    @Nullable
    @ElementName( "CaseUUID" )
    private UUID caseUUID;
    public final static SimpleProperty.Guid<DisputeCase> CASE_UUID =
        new SimpleProperty.Guid<DisputeCase>(DisputeCase.class, "CaseUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @return Business Partner
     */
    @Nullable
    @ElementName( "BusinessPartner" )
    private java.lang.String businessPartner;
    public final static SimpleProperty.String<DisputeCase> BUSINESS_PARTNER =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFullName</b>
     * </p>
     * 
     * @return The businessPartnerFullName contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "BusinessPartnerFullName" )
    private java.lang.String businessPartnerFullName;
    public final static SimpleProperty.String<DisputeCase> BUSINESS_PARTNER_FULL_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "BusinessPartnerFullName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @return Contract Account
     */
    @Nullable
    @ElementName( "ContractAccount" )
    private java.lang.String contractAccount;
    public final static SimpleProperty.String<DisputeCase> CONTRACT_ACCOUNT =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "ContractAccount");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccountName</b>
     * </p>
     * 
     * @return Description of Contract Account
     */
    @Nullable
    @ElementName( "ContractAccountName" )
    private java.lang.String contractAccountName;
    public final static SimpleProperty.String<DisputeCase> CONTRACT_ACCOUNT_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "ContractAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAContract</b>
     * </p>
     * 
     * @return Contract Reference
     */
    @Nullable
    @ElementName( "CAContract" )
    private java.lang.String cAContract;
    public final static SimpleProperty.String<DisputeCase> CA_CONTRACT =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CAContract");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAApplicationArea</b>
     * </p>
     * 
     * @return FI-CA Application Area
     */
    @Nullable
    @ElementName( "CAApplicationArea" )
    private java.lang.String cAApplicationArea;
    public final static SimpleProperty.String<DisputeCase> CA_APPLICATION_AREA =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CAApplicationArea");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplication</b>
     * </p>
     * 
     * @return Subapplication in Contract Accounts Receivable and Payable
     */
    @Nullable
    @ElementName( "CASubApplication" )
    private java.lang.String cASubApplication;
    public final static SimpleProperty.String<DisputeCase> CA_SUB_APPLICATION =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CASubApplication");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DisputedAmount</b>
     * </p>
     * 
     * @return The disputedAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "DisputedAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal disputedAmount;
    public final static SimpleProperty.NumericDecimal<DisputeCase> DISPUTED_AMOUNT =
        new SimpleProperty.NumericDecimal<DisputeCase>(DisputeCase.class, "DisputedAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalReceivablesAmount</b>
     * </p>
     * 
     * @return The totalReceivablesAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "TotalReceivablesAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal totalReceivablesAmount;
    public final static SimpleProperty.NumericDecimal<DisputeCase> TOTAL_RECEIVABLES_AMOUNT =
        new SimpleProperty.NumericDecimal<DisputeCase>(DisputeCase.class, "TotalReceivablesAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseCorrectionAmount</b>
     * </p>
     * 
     * @return The disputeCaseCorrectionAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "DisputeCaseCorrectionAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal disputeCaseCorrectionAmount;
    public final static SimpleProperty.NumericDecimal<DisputeCase> DISPUTE_CASE_CORRECTION_AMOUNT =
        new SimpleProperty.NumericDecimal<DisputeCase>(DisputeCase.class, "DisputeCaseCorrectionAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseReversedAmount</b>
     * </p>
     * 
     * @return The disputeCaseReversedAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "DisputeCaseReversedAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal disputeCaseReversedAmount;
    public final static SimpleProperty.NumericDecimal<DisputeCase> DISPUTE_CASE_REVERSED_AMOUNT =
        new SimpleProperty.NumericDecimal<DisputeCase>(DisputeCase.class, "DisputeCaseReversedAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditedAmount</b>
     * </p>
     * 
     * @return The creditedAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CreditedAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal creditedAmount;
    public final static SimpleProperty.NumericDecimal<DisputeCase> CREDITED_AMOUNT =
        new SimpleProperty.NumericDecimal<DisputeCase>(DisputeCase.class, "CreditedAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>WriteOffAmount</b>
     * </p>
     * 
     * @return The writeOffAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "WriteOffAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal writeOffAmount;
    public final static SimpleProperty.NumericDecimal<DisputeCase> WRITE_OFF_AMOUNT =
        new SimpleProperty.NumericDecimal<DisputeCase>(DisputeCase.class, "WriteOffAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseReplacedAmount</b>
     * </p>
     * 
     * @return The disputeCaseReplacedAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "DisputeCaseReplacedAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal disputeCaseReplacedAmount;
    public final static SimpleProperty.NumericDecimal<DisputeCase> DISPUTE_CASE_REPLACED_AMOUNT =
        new SimpleProperty.NumericDecimal<DisputeCase>(DisputeCase.class, "DisputeCaseReplacedAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PaidAmount</b>
     * </p>
     * 
     * @return The paidAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "PaidAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal paidAmount;
    public final static SimpleProperty.NumericDecimal<DisputeCase> PAID_AMOUNT =
        new SimpleProperty.NumericDecimal<DisputeCase>(DisputeCase.class, "PaidAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CARemainingDisputedAmount</b>
     * </p>
     * 
     * @return The cARemainingDisputedAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CARemainingDisputedAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal cARemainingDisputedAmount;
    public final static SimpleProperty.NumericDecimal<DisputeCase> CA_REMAINING_DISPUTED_AMOUNT =
        new SimpleProperty.NumericDecimal<DisputeCase>(DisputeCase.class, "CARemainingDisputedAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseCurrency</b>
     * </p>
     * 
     * @return Currency of Dispute Case
     */
    @Nullable
    @ElementName( "DisputeCaseCurrency" )
    private java.lang.String disputeCaseCurrency;
    public final static SimpleProperty.String<DisputeCase> DISPUTE_CASE_CURRENCY =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "DisputeCaseCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     * 
     * @return Logical System
     */
    @Nullable
    @ElementName( "LogicalSystem" )
    private java.lang.String logicalSystem;
    public final static SimpleProperty.String<DisputeCase> LOGICAL_SYSTEM =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CADisputeType</b>
     * </p>
     * 
     * @return FICA-DM: Internal Dispute Type
     */
    @Nullable
    @ElementName( "CADisputeType" )
    private java.lang.String cADisputeType;
    public final static SimpleProperty.String<DisputeCase> CA_DISPUTE_TYPE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CADisputeType");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADisputeTypeText</b>
     * </p>
     * 
     * @return FI-CA: Internal Dispute Type
     */
    @Nullable
    @ElementName( "CADisputeTypeText" )
    private java.lang.String cADisputeTypeText;
    public final static SimpleProperty.String<DisputeCase> CA_DISPUTE_TYPE_TEXT =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CADisputeTypeText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<DisputeCase> COMPANY_CODE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     * 
     * @return Name of Company Code or Company
     */
    @Nullable
    @ElementName( "CompanyCodeName" )
    private java.lang.String companyCodeName;
    public final static SimpleProperty.String<DisputeCase> COMPANY_CODE_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CompanyCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseCoordinator</b>
     * </p>
     * 
     * @return Coordinator of Dispute Case
     */
    @Nullable
    @ElementName( "DisputeCaseCoordinator" )
    private java.lang.String disputeCaseCoordinator;
    public final static SimpleProperty.String<DisputeCase> DISPUTE_CASE_COORDINATOR =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "DisputeCaseCoordinator");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseRootCause</b>
     * </p>
     * 
     * @return Root Cause Code
     */
    @Nullable
    @ElementName( "DisputeCaseRootCause" )
    private java.lang.String disputeCaseRootCause;
    public final static SimpleProperty.String<DisputeCase> DISPUTE_CASE_ROOT_CAUSE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "DisputeCaseRootCause");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CaseRootCauseDescription</b>
     * </p>
     * 
     * @return Root Cause Code
     */
    @Nullable
    @ElementName( "CaseRootCauseDescription" )
    private java.lang.String caseRootCauseDescription;
    public final static SimpleProperty.String<DisputeCase> CASE_ROOT_CAUSE_DESCRIPTION =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseRootCauseDescription");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseProcessingDeadlineDate</b>
     * </p>
     * 
     * @return Processing Deadline
     */
    @Nullable
    @ElementName( "CaseProcessingDeadlineDate" )
    private LocalDate caseProcessingDeadlineDate;
    public final static SimpleProperty.Date<DisputeCase> CASE_PROCESSING_DEADLINE_DATE =
        new SimpleProperty.Date<DisputeCase>(DisputeCase.class, "CaseProcessingDeadlineDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonFullName</b>
     * </p>
     * 
     * @return Name of Contact Person at Business Partner
     */
    @Nullable
    @ElementName( "ContactPersonFullName" )
    private java.lang.String contactPersonFullName;
    public final static SimpleProperty.String<DisputeCase> CONTACT_PERSON_FULL_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "ContactPersonFullName");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonEmailAddress</b>
     * </p>
     * 
     * @return Email Address of Contact Person at Business Partner
     */
    @Nullable
    @ElementName( "ContactPersonEmailAddress" )
    private java.lang.String contactPersonEmailAddress;
    public final static SimpleProperty.String<DisputeCase> CONTACT_PERSON_EMAIL_ADDRESS =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "ContactPersonEmailAddress");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonPhoneNumber</b>
     * </p>
     * 
     * @return Telephone Number of Contact Person at Business Partner
     */
    @Nullable
    @ElementName( "ContactPersonPhoneNumber" )
    private java.lang.String contactPersonPhoneNumber;
    public final static SimpleProperty.String<DisputeCase> CONTACT_PERSON_PHONE_NUMBER =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "ContactPersonPhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonFaxNumber</b>
     * </p>
     * 
     * @return Fax Number of Contact Person at Business Partner
     */
    @Nullable
    @ElementName( "ContactPersonFaxNumber" )
    private java.lang.String contactPersonFaxNumber;
    public final static SimpleProperty.String<DisputeCase> CONTACT_PERSON_FAX_NUMBER =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "ContactPersonFaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonFaxCountry</b>
     * </p>
     * 
     * @return Country/Region of Fax Number
     */
    @Nullable
    @ElementName( "ContactPersonFaxCountry" )
    private java.lang.String contactPersonFaxCountry;
    public final static SimpleProperty.String<DisputeCase> CONTACT_PERSON_FAX_COUNTRY =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "ContactPersonFaxCountry");
    /**
     * Constraints: Not nullable, Maximum length: 43
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseBPCorrespondenceKey</b>
     * </p>
     * 
     * @return Correspondence Key in Dispute Management
     */
    @Nullable
    @ElementName( "DisputeCaseBPCorrespondenceKey" )
    private java.lang.String disputeCaseBPCorrespondenceKey;
    public final static SimpleProperty.String<DisputeCase> DISPUTE_CASE_BP_CORRESPONDENCE_KEY =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "DisputeCaseBPCorrespondenceKey");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseInformationText</b>
     * </p>
     * 
     * @return Additional Information for Dispute Case
     */
    @Nullable
    @ElementName( "DisputeCaseInformationText" )
    private java.lang.String disputeCaseInformationText;
    public final static SimpleProperty.String<DisputeCase> DISPUTE_CASE_INFORMATION_TEXT =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "DisputeCaseInformationText");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseTransactionDate</b>
     * </p>
     * 
     * @return Transaction Date for Dispute Case
     */
    @Nullable
    @ElementName( "DisputeCaseTransactionDate" )
    private LocalDate disputeCaseTransactionDate;
    public final static SimpleProperty.Date<DisputeCase> DISPUTE_CASE_TRANSACTION_DATE =
        new SimpleProperty.Date<DisputeCase>(DisputeCase.class, "DisputeCaseTransactionDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADisputeCase</b>
     * </p>
     * 
     * @return FI-CA: Case Number of Dispute Case
     */
    @Nullable
    @ElementName( "CADisputeCase" )
    private java.lang.String cADisputeCase;
    public final static SimpleProperty.String<DisputeCase> CA_DISPUTE_CASE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CADisputeCase");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CaseType</b>
     * </p>
     * 
     * @return Case Type
     */
    @Nullable
    @ElementName( "CaseType" )
    private java.lang.String caseType;
    public final static SimpleProperty.String<DisputeCase> CASE_TYPE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseType");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseID</b>
     * </p>
     * 
     * @return Case ID
     */
    @Nullable
    @ElementName( "CaseID" )
    private java.lang.String caseID;
    public final static SimpleProperty.String<DisputeCase> CASE_ID =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseID");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CaseExternalReference</b>
     * </p>
     * 
     * @return External Reference
     */
    @Nullable
    @ElementName( "CaseExternalReference" )
    private java.lang.String caseExternalReference;
    public final static SimpleProperty.String<DisputeCase> CASE_EXTERNAL_REFERENCE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseCreatedBy</b>
     * </p>
     * 
     * @return Created By
     */
    @Nullable
    @ElementName( "CaseCreatedBy" )
    private java.lang.String caseCreatedBy;
    public final static SimpleProperty.String<DisputeCase> CASE_CREATED_BY =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseCreatedBy");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseCreationDate</b>
     * </p>
     * 
     * @return Date on Which Record Was Created
     */
    @Nullable
    @ElementName( "CaseCreationDate" )
    private LocalDate caseCreationDate;
    public final static SimpleProperty.Date<DisputeCase> CASE_CREATION_DATE =
        new SimpleProperty.Date<DisputeCase>(DisputeCase.class, "CaseCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseLastChangedBy</b>
     * </p>
     * 
     * @return Last Changed By
     */
    @Nullable
    @ElementName( "CaseLastChangedBy" )
    private java.lang.String caseLastChangedBy;
    public final static SimpleProperty.String<DisputeCase> CASE_LAST_CHANGED_BY =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseLastChangedBy");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseLastChangedOn</b>
     * </p>
     * 
     * @return Last Changed On
     */
    @Nullable
    @ElementName( "CaseLastChangedOn" )
    private OffsetDateTime caseLastChangedOn;
    public final static SimpleProperty.DateTime<DisputeCase> CASE_LAST_CHANGED_ON =
        new SimpleProperty.DateTime<DisputeCase>(DisputeCase.class, "CaseLastChangedOn");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CaseStatusProfile</b>
     * </p>
     * 
     * @return Case: Status Profile
     */
    @Nullable
    @ElementName( "CaseStatusProfile" )
    private java.lang.String caseStatusProfile;
    public final static SimpleProperty.String<DisputeCase> CASE_STATUS_PROFILE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseStatusProfile");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseClosedBy</b>
     * </p>
     * 
     * @return Closed by User
     */
    @Nullable
    @ElementName( "CaseClosedBy" )
    private java.lang.String caseClosedBy;
    public final static SimpleProperty.String<DisputeCase> CASE_CLOSED_BY =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseClosedBy");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseClosedTime</b>
     * </p>
     * 
     * @return Closed at Time
     */
    @Nullable
    @ElementName( "CaseClosedTime" )
    private OffsetDateTime caseClosedTime;
    public final static SimpleProperty.DateTime<DisputeCase> CASE_CLOSED_TIME =
        new SimpleProperty.DateTime<DisputeCase>(DisputeCase.class, "CaseClosedTime");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CasePlannedCloseDate</b>
     * </p>
     * 
     * @return Planned Close Date
     */
    @Nullable
    @ElementName( "CasePlannedCloseDate" )
    private LocalDate casePlannedCloseDate;
    public final static SimpleProperty.Date<DisputeCase> CASE_PLANNED_CLOSE_DATE =
        new SimpleProperty.Date<DisputeCase>(DisputeCase.class, "CasePlannedCloseDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseProcessor</b>
     * </p>
     * 
     * @return Processor
     */
    @Nullable
    @ElementName( "CaseProcessor" )
    private java.lang.String caseProcessor;
    public final static SimpleProperty.String<DisputeCase> CASE_PROCESSOR =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseProcessor");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseResponsible</b>
     * </p>
     * 
     * @return Person Responsible
     */
    @Nullable
    @ElementName( "CaseResponsible" )
    private java.lang.String caseResponsible;
    public final static SimpleProperty.String<DisputeCase> CASE_RESPONSIBLE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CaseTitle</b>
     * </p>
     * 
     * @return Case Title
     */
    @Nullable
    @ElementName( "CaseTitle" )
    private java.lang.String caseTitle;
    public final static SimpleProperty.String<DisputeCase> CASE_TITLE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseTitle");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CaseAuthorizationLevel</b>
     * </p>
     * 
     * @return Authorization level
     */
    @Nullable
    @ElementName( "CaseAuthorizationLevel" )
    private java.lang.String caseAuthorizationLevel;
    public final static SimpleProperty.String<DisputeCase> CASE_AUTHORIZATION_LEVEL =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseAuthorizationLevel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CaseStatus</b>
     * </p>
     * 
     * @return Case: Status
     */
    @Nullable
    @ElementName( "CaseStatus" )
    private java.lang.String caseStatus;
    public final static SimpleProperty.String<DisputeCase> CASE_STATUS =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseStatus");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CaseStatusName</b>
     * </p>
     * 
     * @return Case: Status Description
     */
    @Nullable
    @ElementName( "CaseStatusName" )
    private java.lang.String caseStatusName;
    public final static SimpleProperty.String<DisputeCase> CASE_STATUS_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CaseSystemStatus</b>
     * </p>
     * 
     * @return Case: System Status
     */
    @Nullable
    @ElementName( "CaseSystemStatus" )
    private java.lang.String caseSystemStatus;
    public final static SimpleProperty.String<DisputeCase> CASE_SYSTEM_STATUS =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseSystemStatus");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CaseUserStatusName</b>
     * </p>
     * 
     * @return Case: User Status Description (Central Status Management)
     */
    @Nullable
    @ElementName( "CaseUserStatusName" )
    private java.lang.String caseUserStatusName;
    public final static SimpleProperty.String<DisputeCase> CASE_USER_STATUS_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseUserStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CasePriority</b>
     * </p>
     * 
     * @return Priority
     */
    @Nullable
    @ElementName( "CasePriority" )
    private java.lang.String casePriority;
    public final static SimpleProperty.String<DisputeCase> CASE_PRIORITY =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CasePriority");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCasePriorityName</b>
     * </p>
     * 
     * @return Priority
     */
    @Nullable
    @ElementName( "DisputeCasePriorityName" )
    private java.lang.String disputeCasePriorityName;
    public final static SimpleProperty.String<DisputeCase> DISPUTE_CASE_PRIORITY_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "DisputeCasePriorityName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CaseCategory</b>
     * </p>
     * 
     * @return Category
     */
    @Nullable
    @ElementName( "CaseCategory" )
    private java.lang.String caseCategory;
    public final static SimpleProperty.String<DisputeCase> CASE_CATEGORY =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseCategoryName</b>
     * </p>
     * 
     * @return Category
     */
    @Nullable
    @ElementName( "DisputeCaseCategoryName" )
    private java.lang.String disputeCaseCategoryName;
    public final static SimpleProperty.String<DisputeCase> DISPUTE_CASE_CATEGORY_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "DisputeCaseCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CaseReason</b>
     * </p>
     * 
     * @return Reason for Case
     */
    @Nullable
    @ElementName( "CaseReason" )
    private java.lang.String caseReason;
    public final static SimpleProperty.String<DisputeCase> CASE_REASON =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseReason");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CaseReasonName</b>
     * </p>
     * 
     * @return Reason Description
     */
    @Nullable
    @ElementName( "CaseReasonName" )
    private java.lang.String caseReasonName;
    public final static SimpleProperty.String<DisputeCase> CASE_REASON_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseReasonName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CaseEscalationReason</b>
     * </p>
     * 
     * @return Reason for Escalation
     */
    @Nullable
    @ElementName( "CaseEscalationReason" )
    private java.lang.String caseEscalationReason;
    public final static SimpleProperty.String<DisputeCase> CASE_ESCALATION_REASON =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CaseEscalationReason");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DsputCaseEscalationRsnName</b>
     * </p>
     * 
     * @return Reason for Escalation
     */
    @Nullable
    @ElementName( "DsputCaseEscalationRsnName" )
    private java.lang.String dsputCaseEscalationRsnName;
    public final static SimpleProperty.String<DisputeCase> DSPUT_CASE_ESCALATION_RSN_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "DsputCaseEscalationRsnName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     * 
     * @return Street
     */
    @Nullable
    @ElementName( "StreetName" )
    private java.lang.String streetName;
    public final static SimpleProperty.String<DisputeCase> STREET_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     * 
     * @return House Number
     */
    @Nullable
    @ElementName( "HouseNumber" )
    private java.lang.String houseNumber;
    public final static SimpleProperty.String<DisputeCase> HOUSE_NUMBER =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "HouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CountryName</b>
     * </p>
     * 
     * @return Country/Region Name
     */
    @Nullable
    @ElementName( "CountryName" )
    private java.lang.String countryName;
    public final static SimpleProperty.String<DisputeCase> COUNTRY_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CountryName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     * 
     * @return City Postal Code
     */
    @Nullable
    @ElementName( "PostalCode" )
    private java.lang.String postalCode;
    public final static SimpleProperty.String<DisputeCase> POSTAL_CODE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     * 
     * @return City
     */
    @Nullable
    @ElementName( "CityName" )
    private java.lang.String cityName;
    public final static SimpleProperty.String<DisputeCase> CITY_NAME =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CityName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADisputeExternalCallerCode</b>
     * </p>
     * 
     * @return Identification of External Caller for Dispute Case
     */
    @Nullable
    @ElementName( "CADisputeExternalCallerCode" )
    private java.lang.String cADisputeExternalCallerCode;
    public final static SimpleProperty.String<DisputeCase> CA_DISPUTE_EXTERNAL_CALLER_CODE =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "CADisputeExternalCallerCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseOrigin</b>
     * </p>
     * 
     * @return Origin of Dispute Case
     */
    @Nullable
    @ElementName( "DisputeCaseOrigin" )
    private java.lang.String disputeCaseOrigin;
    public final static SimpleProperty.String<DisputeCase> DISPUTE_CASE_ORIGIN =
        new SimpleProperty.String<DisputeCase>(DisputeCase.class, "DisputeCaseOrigin");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<DisputeCase, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<DisputeCase, SAP__Message>(
            DisputeCase.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_CACaseObject</b> for <b>DisputeCase</b> to multiple <b>DisputeCaseObject</b>.
     * 
     */
    @ElementName( "_CACaseObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DisputeCaseObject> to_CACaseObject;
    /**
     * Use with available request builders to apply the <b>_CACaseObject</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<DisputeCase, DisputeCaseObject> TO__C_A_CASE_OBJECT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<DisputeCase, DisputeCaseObject>(
            DisputeCase.class,
            "_CACaseObject",
            DisputeCaseObject.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<DisputeCase> getType()
    {
        return DisputeCase.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseUUID</b>
     * </p>
     * 
     * @param caseUUID
     *            UUID in Character Format
     */
    public void setCaseUUID( @Nullable final UUID caseUUID )
    {
        rememberChangedField("CaseUUID", this.caseUUID);
        this.caseUUID = caseUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @param businessPartner
     *            Business Partner
     */
    public void setBusinessPartner( @Nullable final java.lang.String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFullName</b>
     * </p>
     * 
     * @param businessPartnerFullName
     *            The businessPartnerFullName to set.
     */
    public void setBusinessPartnerFullName( @Nullable final java.lang.String businessPartnerFullName )
    {
        rememberChangedField("BusinessPartnerFullName", this.businessPartnerFullName);
        this.businessPartnerFullName = businessPartnerFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @param contractAccount
     *            Contract Account
     */
    public void setContractAccount( @Nullable final java.lang.String contractAccount )
    {
        rememberChangedField("ContractAccount", this.contractAccount);
        this.contractAccount = contractAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccountName</b>
     * </p>
     * 
     * @param contractAccountName
     *            Description of Contract Account
     */
    public void setContractAccountName( @Nullable final java.lang.String contractAccountName )
    {
        rememberChangedField("ContractAccountName", this.contractAccountName);
        this.contractAccountName = contractAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAContract</b>
     * </p>
     * 
     * @param cAContract
     *            Contract Reference
     */
    public void setCAContract( @Nullable final java.lang.String cAContract )
    {
        rememberChangedField("CAContract", this.cAContract);
        this.cAContract = cAContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAApplicationArea</b>
     * </p>
     * 
     * @param cAApplicationArea
     *            FI-CA Application Area
     */
    public void setCAApplicationArea( @Nullable final java.lang.String cAApplicationArea )
    {
        rememberChangedField("CAApplicationArea", this.cAApplicationArea);
        this.cAApplicationArea = cAApplicationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplication</b>
     * </p>
     * 
     * @param cASubApplication
     *            Subapplication in Contract Accounts Receivable and Payable
     */
    public void setCASubApplication( @Nullable final java.lang.String cASubApplication )
    {
        rememberChangedField("CASubApplication", this.cASubApplication);
        this.cASubApplication = cASubApplication;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DisputedAmount</b>
     * </p>
     * 
     * @param disputedAmount
     *            The disputedAmount to set.
     */
    public void setDisputedAmount( @Nullable final BigDecimal disputedAmount )
    {
        rememberChangedField("DisputedAmount", this.disputedAmount);
        this.disputedAmount = disputedAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalReceivablesAmount</b>
     * </p>
     * 
     * @param totalReceivablesAmount
     *            The totalReceivablesAmount to set.
     */
    public void setTotalReceivablesAmount( @Nullable final BigDecimal totalReceivablesAmount )
    {
        rememberChangedField("TotalReceivablesAmount", this.totalReceivablesAmount);
        this.totalReceivablesAmount = totalReceivablesAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseCorrectionAmount</b>
     * </p>
     * 
     * @param disputeCaseCorrectionAmount
     *            The disputeCaseCorrectionAmount to set.
     */
    public void setDisputeCaseCorrectionAmount( @Nullable final BigDecimal disputeCaseCorrectionAmount )
    {
        rememberChangedField("DisputeCaseCorrectionAmount", this.disputeCaseCorrectionAmount);
        this.disputeCaseCorrectionAmount = disputeCaseCorrectionAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseReversedAmount</b>
     * </p>
     * 
     * @param disputeCaseReversedAmount
     *            The disputeCaseReversedAmount to set.
     */
    public void setDisputeCaseReversedAmount( @Nullable final BigDecimal disputeCaseReversedAmount )
    {
        rememberChangedField("DisputeCaseReversedAmount", this.disputeCaseReversedAmount);
        this.disputeCaseReversedAmount = disputeCaseReversedAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditedAmount</b>
     * </p>
     * 
     * @param creditedAmount
     *            The creditedAmount to set.
     */
    public void setCreditedAmount( @Nullable final BigDecimal creditedAmount )
    {
        rememberChangedField("CreditedAmount", this.creditedAmount);
        this.creditedAmount = creditedAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>WriteOffAmount</b>
     * </p>
     * 
     * @param writeOffAmount
     *            The writeOffAmount to set.
     */
    public void setWriteOffAmount( @Nullable final BigDecimal writeOffAmount )
    {
        rememberChangedField("WriteOffAmount", this.writeOffAmount);
        this.writeOffAmount = writeOffAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseReplacedAmount</b>
     * </p>
     * 
     * @param disputeCaseReplacedAmount
     *            The disputeCaseReplacedAmount to set.
     */
    public void setDisputeCaseReplacedAmount( @Nullable final BigDecimal disputeCaseReplacedAmount )
    {
        rememberChangedField("DisputeCaseReplacedAmount", this.disputeCaseReplacedAmount);
        this.disputeCaseReplacedAmount = disputeCaseReplacedAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PaidAmount</b>
     * </p>
     * 
     * @param paidAmount
     *            The paidAmount to set.
     */
    public void setPaidAmount( @Nullable final BigDecimal paidAmount )
    {
        rememberChangedField("PaidAmount", this.paidAmount);
        this.paidAmount = paidAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CARemainingDisputedAmount</b>
     * </p>
     * 
     * @param cARemainingDisputedAmount
     *            The cARemainingDisputedAmount to set.
     */
    public void setCARemainingDisputedAmount( @Nullable final BigDecimal cARemainingDisputedAmount )
    {
        rememberChangedField("CARemainingDisputedAmount", this.cARemainingDisputedAmount);
        this.cARemainingDisputedAmount = cARemainingDisputedAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseCurrency</b>
     * </p>
     * 
     * @param disputeCaseCurrency
     *            Currency of Dispute Case
     */
    public void setDisputeCaseCurrency( @Nullable final java.lang.String disputeCaseCurrency )
    {
        rememberChangedField("DisputeCaseCurrency", this.disputeCaseCurrency);
        this.disputeCaseCurrency = disputeCaseCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     * 
     * @param logicalSystem
     *            Logical System
     */
    public void setLogicalSystem( @Nullable final java.lang.String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CADisputeType</b>
     * </p>
     * 
     * @param cADisputeType
     *            FICA-DM: Internal Dispute Type
     */
    public void setCADisputeType( @Nullable final java.lang.String cADisputeType )
    {
        rememberChangedField("CADisputeType", this.cADisputeType);
        this.cADisputeType = cADisputeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CADisputeTypeText</b>
     * </p>
     * 
     * @param cADisputeTypeText
     *            FI-CA: Internal Dispute Type
     */
    public void setCADisputeTypeText( @Nullable final java.lang.String cADisputeTypeText )
    {
        rememberChangedField("CADisputeTypeText", this.cADisputeTypeText);
        this.cADisputeTypeText = cADisputeTypeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     * 
     * @param companyCodeName
     *            Name of Company Code or Company
     */
    public void setCompanyCodeName( @Nullable final java.lang.String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseCoordinator</b>
     * </p>
     * 
     * @param disputeCaseCoordinator
     *            Coordinator of Dispute Case
     */
    public void setDisputeCaseCoordinator( @Nullable final java.lang.String disputeCaseCoordinator )
    {
        rememberChangedField("DisputeCaseCoordinator", this.disputeCaseCoordinator);
        this.disputeCaseCoordinator = disputeCaseCoordinator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseRootCause</b>
     * </p>
     * 
     * @param disputeCaseRootCause
     *            Root Cause Code
     */
    public void setDisputeCaseRootCause( @Nullable final java.lang.String disputeCaseRootCause )
    {
        rememberChangedField("DisputeCaseRootCause", this.disputeCaseRootCause);
        this.disputeCaseRootCause = disputeCaseRootCause;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CaseRootCauseDescription</b>
     * </p>
     * 
     * @param caseRootCauseDescription
     *            Root Cause Code
     */
    public void setCaseRootCauseDescription( @Nullable final java.lang.String caseRootCauseDescription )
    {
        rememberChangedField("CaseRootCauseDescription", this.caseRootCauseDescription);
        this.caseRootCauseDescription = caseRootCauseDescription;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseProcessingDeadlineDate</b>
     * </p>
     * 
     * @param caseProcessingDeadlineDate
     *            Processing Deadline
     */
    public void setCaseProcessingDeadlineDate( @Nullable final LocalDate caseProcessingDeadlineDate )
    {
        rememberChangedField("CaseProcessingDeadlineDate", this.caseProcessingDeadlineDate);
        this.caseProcessingDeadlineDate = caseProcessingDeadlineDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonFullName</b>
     * </p>
     * 
     * @param contactPersonFullName
     *            Name of Contact Person at Business Partner
     */
    public void setContactPersonFullName( @Nullable final java.lang.String contactPersonFullName )
    {
        rememberChangedField("ContactPersonFullName", this.contactPersonFullName);
        this.contactPersonFullName = contactPersonFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonEmailAddress</b>
     * </p>
     * 
     * @param contactPersonEmailAddress
     *            Email Address of Contact Person at Business Partner
     */
    public void setContactPersonEmailAddress( @Nullable final java.lang.String contactPersonEmailAddress )
    {
        rememberChangedField("ContactPersonEmailAddress", this.contactPersonEmailAddress);
        this.contactPersonEmailAddress = contactPersonEmailAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonPhoneNumber</b>
     * </p>
     * 
     * @param contactPersonPhoneNumber
     *            Telephone Number of Contact Person at Business Partner
     */
    public void setContactPersonPhoneNumber( @Nullable final java.lang.String contactPersonPhoneNumber )
    {
        rememberChangedField("ContactPersonPhoneNumber", this.contactPersonPhoneNumber);
        this.contactPersonPhoneNumber = contactPersonPhoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonFaxNumber</b>
     * </p>
     * 
     * @param contactPersonFaxNumber
     *            Fax Number of Contact Person at Business Partner
     */
    public void setContactPersonFaxNumber( @Nullable final java.lang.String contactPersonFaxNumber )
    {
        rememberChangedField("ContactPersonFaxNumber", this.contactPersonFaxNumber);
        this.contactPersonFaxNumber = contactPersonFaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ContactPersonFaxCountry</b>
     * </p>
     * 
     * @param contactPersonFaxCountry
     *            Country/Region of Fax Number
     */
    public void setContactPersonFaxCountry( @Nullable final java.lang.String contactPersonFaxCountry )
    {
        rememberChangedField("ContactPersonFaxCountry", this.contactPersonFaxCountry);
        this.contactPersonFaxCountry = contactPersonFaxCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 43
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseBPCorrespondenceKey</b>
     * </p>
     * 
     * @param disputeCaseBPCorrespondenceKey
     *            Correspondence Key in Dispute Management
     */
    public void setDisputeCaseBPCorrespondenceKey( @Nullable final java.lang.String disputeCaseBPCorrespondenceKey )
    {
        rememberChangedField("DisputeCaseBPCorrespondenceKey", this.disputeCaseBPCorrespondenceKey);
        this.disputeCaseBPCorrespondenceKey = disputeCaseBPCorrespondenceKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseInformationText</b>
     * </p>
     * 
     * @param disputeCaseInformationText
     *            Additional Information for Dispute Case
     */
    public void setDisputeCaseInformationText( @Nullable final java.lang.String disputeCaseInformationText )
    {
        rememberChangedField("DisputeCaseInformationText", this.disputeCaseInformationText);
        this.disputeCaseInformationText = disputeCaseInformationText;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseTransactionDate</b>
     * </p>
     * 
     * @param disputeCaseTransactionDate
     *            Transaction Date for Dispute Case
     */
    public void setDisputeCaseTransactionDate( @Nullable final LocalDate disputeCaseTransactionDate )
    {
        rememberChangedField("DisputeCaseTransactionDate", this.disputeCaseTransactionDate);
        this.disputeCaseTransactionDate = disputeCaseTransactionDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADisputeCase</b>
     * </p>
     * 
     * @param cADisputeCase
     *            FI-CA: Case Number of Dispute Case
     */
    public void setCADisputeCase( @Nullable final java.lang.String cADisputeCase )
    {
        rememberChangedField("CADisputeCase", this.cADisputeCase);
        this.cADisputeCase = cADisputeCase;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CaseType</b>
     * </p>
     * 
     * @param caseType
     *            Case Type
     */
    public void setCaseType( @Nullable final java.lang.String caseType )
    {
        rememberChangedField("CaseType", this.caseType);
        this.caseType = caseType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseID</b>
     * </p>
     * 
     * @param caseID
     *            Case ID
     */
    public void setCaseID( @Nullable final java.lang.String caseID )
    {
        rememberChangedField("CaseID", this.caseID);
        this.caseID = caseID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CaseExternalReference</b>
     * </p>
     * 
     * @param caseExternalReference
     *            External Reference
     */
    public void setCaseExternalReference( @Nullable final java.lang.String caseExternalReference )
    {
        rememberChangedField("CaseExternalReference", this.caseExternalReference);
        this.caseExternalReference = caseExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseCreatedBy</b>
     * </p>
     * 
     * @param caseCreatedBy
     *            Created By
     */
    public void setCaseCreatedBy( @Nullable final java.lang.String caseCreatedBy )
    {
        rememberChangedField("CaseCreatedBy", this.caseCreatedBy);
        this.caseCreatedBy = caseCreatedBy;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseCreationDate</b>
     * </p>
     * 
     * @param caseCreationDate
     *            Date on Which Record Was Created
     */
    public void setCaseCreationDate( @Nullable final LocalDate caseCreationDate )
    {
        rememberChangedField("CaseCreationDate", this.caseCreationDate);
        this.caseCreationDate = caseCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseLastChangedBy</b>
     * </p>
     * 
     * @param caseLastChangedBy
     *            Last Changed By
     */
    public void setCaseLastChangedBy( @Nullable final java.lang.String caseLastChangedBy )
    {
        rememberChangedField("CaseLastChangedBy", this.caseLastChangedBy);
        this.caseLastChangedBy = caseLastChangedBy;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseLastChangedOn</b>
     * </p>
     * 
     * @param caseLastChangedOn
     *            Last Changed On
     */
    public void setCaseLastChangedOn( @Nullable final OffsetDateTime caseLastChangedOn )
    {
        rememberChangedField("CaseLastChangedOn", this.caseLastChangedOn);
        this.caseLastChangedOn = caseLastChangedOn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CaseStatusProfile</b>
     * </p>
     * 
     * @param caseStatusProfile
     *            Case: Status Profile
     */
    public void setCaseStatusProfile( @Nullable final java.lang.String caseStatusProfile )
    {
        rememberChangedField("CaseStatusProfile", this.caseStatusProfile);
        this.caseStatusProfile = caseStatusProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseClosedBy</b>
     * </p>
     * 
     * @param caseClosedBy
     *            Closed by User
     */
    public void setCaseClosedBy( @Nullable final java.lang.String caseClosedBy )
    {
        rememberChangedField("CaseClosedBy", this.caseClosedBy);
        this.caseClosedBy = caseClosedBy;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseClosedTime</b>
     * </p>
     * 
     * @param caseClosedTime
     *            Closed at Time
     */
    public void setCaseClosedTime( @Nullable final OffsetDateTime caseClosedTime )
    {
        rememberChangedField("CaseClosedTime", this.caseClosedTime);
        this.caseClosedTime = caseClosedTime;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CasePlannedCloseDate</b>
     * </p>
     * 
     * @param casePlannedCloseDate
     *            Planned Close Date
     */
    public void setCasePlannedCloseDate( @Nullable final LocalDate casePlannedCloseDate )
    {
        rememberChangedField("CasePlannedCloseDate", this.casePlannedCloseDate);
        this.casePlannedCloseDate = casePlannedCloseDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseProcessor</b>
     * </p>
     * 
     * @param caseProcessor
     *            Processor
     */
    public void setCaseProcessor( @Nullable final java.lang.String caseProcessor )
    {
        rememberChangedField("CaseProcessor", this.caseProcessor);
        this.caseProcessor = caseProcessor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CaseResponsible</b>
     * </p>
     * 
     * @param caseResponsible
     *            Person Responsible
     */
    public void setCaseResponsible( @Nullable final java.lang.String caseResponsible )
    {
        rememberChangedField("CaseResponsible", this.caseResponsible);
        this.caseResponsible = caseResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CaseTitle</b>
     * </p>
     * 
     * @param caseTitle
     *            Case Title
     */
    public void setCaseTitle( @Nullable final java.lang.String caseTitle )
    {
        rememberChangedField("CaseTitle", this.caseTitle);
        this.caseTitle = caseTitle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CaseAuthorizationLevel</b>
     * </p>
     * 
     * @param caseAuthorizationLevel
     *            Authorization level
     */
    public void setCaseAuthorizationLevel( @Nullable final java.lang.String caseAuthorizationLevel )
    {
        rememberChangedField("CaseAuthorizationLevel", this.caseAuthorizationLevel);
        this.caseAuthorizationLevel = caseAuthorizationLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CaseStatus</b>
     * </p>
     * 
     * @param caseStatus
     *            Case: Status
     */
    public void setCaseStatus( @Nullable final java.lang.String caseStatus )
    {
        rememberChangedField("CaseStatus", this.caseStatus);
        this.caseStatus = caseStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CaseStatusName</b>
     * </p>
     * 
     * @param caseStatusName
     *            Case: Status Description
     */
    public void setCaseStatusName( @Nullable final java.lang.String caseStatusName )
    {
        rememberChangedField("CaseStatusName", this.caseStatusName);
        this.caseStatusName = caseStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CaseSystemStatus</b>
     * </p>
     * 
     * @param caseSystemStatus
     *            Case: System Status
     */
    public void setCaseSystemStatus( @Nullable final java.lang.String caseSystemStatus )
    {
        rememberChangedField("CaseSystemStatus", this.caseSystemStatus);
        this.caseSystemStatus = caseSystemStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CaseUserStatusName</b>
     * </p>
     * 
     * @param caseUserStatusName
     *            Case: User Status Description (Central Status Management)
     */
    public void setCaseUserStatusName( @Nullable final java.lang.String caseUserStatusName )
    {
        rememberChangedField("CaseUserStatusName", this.caseUserStatusName);
        this.caseUserStatusName = caseUserStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CasePriority</b>
     * </p>
     * 
     * @param casePriority
     *            Priority
     */
    public void setCasePriority( @Nullable final java.lang.String casePriority )
    {
        rememberChangedField("CasePriority", this.casePriority);
        this.casePriority = casePriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCasePriorityName</b>
     * </p>
     * 
     * @param disputeCasePriorityName
     *            Priority
     */
    public void setDisputeCasePriorityName( @Nullable final java.lang.String disputeCasePriorityName )
    {
        rememberChangedField("DisputeCasePriorityName", this.disputeCasePriorityName);
        this.disputeCasePriorityName = disputeCasePriorityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CaseCategory</b>
     * </p>
     * 
     * @param caseCategory
     *            Category
     */
    public void setCaseCategory( @Nullable final java.lang.String caseCategory )
    {
        rememberChangedField("CaseCategory", this.caseCategory);
        this.caseCategory = caseCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseCategoryName</b>
     * </p>
     * 
     * @param disputeCaseCategoryName
     *            Category
     */
    public void setDisputeCaseCategoryName( @Nullable final java.lang.String disputeCaseCategoryName )
    {
        rememberChangedField("DisputeCaseCategoryName", this.disputeCaseCategoryName);
        this.disputeCaseCategoryName = disputeCaseCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CaseReason</b>
     * </p>
     * 
     * @param caseReason
     *            Reason for Case
     */
    public void setCaseReason( @Nullable final java.lang.String caseReason )
    {
        rememberChangedField("CaseReason", this.caseReason);
        this.caseReason = caseReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CaseReasonName</b>
     * </p>
     * 
     * @param caseReasonName
     *            Reason Description
     */
    public void setCaseReasonName( @Nullable final java.lang.String caseReasonName )
    {
        rememberChangedField("CaseReasonName", this.caseReasonName);
        this.caseReasonName = caseReasonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CaseEscalationReason</b>
     * </p>
     * 
     * @param caseEscalationReason
     *            Reason for Escalation
     */
    public void setCaseEscalationReason( @Nullable final java.lang.String caseEscalationReason )
    {
        rememberChangedField("CaseEscalationReason", this.caseEscalationReason);
        this.caseEscalationReason = caseEscalationReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>DsputCaseEscalationRsnName</b>
     * </p>
     * 
     * @param dsputCaseEscalationRsnName
     *            Reason for Escalation
     */
    public void setDsputCaseEscalationRsnName( @Nullable final java.lang.String dsputCaseEscalationRsnName )
    {
        rememberChangedField("DsputCaseEscalationRsnName", this.dsputCaseEscalationRsnName);
        this.dsputCaseEscalationRsnName = dsputCaseEscalationRsnName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     * 
     * @param streetName
     *            Street
     */
    public void setStreetName( @Nullable final java.lang.String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     * 
     * @param houseNumber
     *            House Number
     */
    public void setHouseNumber( @Nullable final java.lang.String houseNumber )
    {
        rememberChangedField("HouseNumber", this.houseNumber);
        this.houseNumber = houseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CountryName</b>
     * </p>
     * 
     * @param countryName
     *            Country/Region Name
     */
    public void setCountryName( @Nullable final java.lang.String countryName )
    {
        rememberChangedField("CountryName", this.countryName);
        this.countryName = countryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     * 
     * @param postalCode
     *            City Postal Code
     */
    public void setPostalCode( @Nullable final java.lang.String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     * 
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final java.lang.String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADisputeExternalCallerCode</b>
     * </p>
     * 
     * @param cADisputeExternalCallerCode
     *            Identification of External Caller for Dispute Case
     */
    public void setCADisputeExternalCallerCode( @Nullable final java.lang.String cADisputeExternalCallerCode )
    {
        rememberChangedField("CADisputeExternalCallerCode", this.cADisputeExternalCallerCode);
        this.cADisputeExternalCallerCode = cADisputeExternalCallerCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DisputeCaseOrigin</b>
     * </p>
     * 
     * @param disputeCaseOrigin
     *            Origin of Dispute Case
     */
    public void setDisputeCaseOrigin( @Nullable final java.lang.String disputeCaseOrigin )
    {
        rememberChangedField("DisputeCaseOrigin", this.disputeCaseOrigin);
        this.disputeCaseOrigin = disputeCaseOrigin;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "DisputeCase";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CaseUUID", getCaseUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CaseUUID", getCaseUUID());
        values.put("BusinessPartner", getBusinessPartner());
        values.put("BusinessPartnerFullName", getBusinessPartnerFullName());
        values.put("ContractAccount", getContractAccount());
        values.put("ContractAccountName", getContractAccountName());
        values.put("CAContract", getCAContract());
        values.put("CAApplicationArea", getCAApplicationArea());
        values.put("CASubApplication", getCASubApplication());
        values.put("DisputedAmount", getDisputedAmount());
        values.put("TotalReceivablesAmount", getTotalReceivablesAmount());
        values.put("DisputeCaseCorrectionAmount", getDisputeCaseCorrectionAmount());
        values.put("DisputeCaseReversedAmount", getDisputeCaseReversedAmount());
        values.put("CreditedAmount", getCreditedAmount());
        values.put("WriteOffAmount", getWriteOffAmount());
        values.put("DisputeCaseReplacedAmount", getDisputeCaseReplacedAmount());
        values.put("PaidAmount", getPaidAmount());
        values.put("CARemainingDisputedAmount", getCARemainingDisputedAmount());
        values.put("DisputeCaseCurrency", getDisputeCaseCurrency());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("CADisputeType", getCADisputeType());
        values.put("CADisputeTypeText", getCADisputeTypeText());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        values.put("DisputeCaseCoordinator", getDisputeCaseCoordinator());
        values.put("DisputeCaseRootCause", getDisputeCaseRootCause());
        values.put("CaseRootCauseDescription", getCaseRootCauseDescription());
        values.put("CaseProcessingDeadlineDate", getCaseProcessingDeadlineDate());
        values.put("ContactPersonFullName", getContactPersonFullName());
        values.put("ContactPersonEmailAddress", getContactPersonEmailAddress());
        values.put("ContactPersonPhoneNumber", getContactPersonPhoneNumber());
        values.put("ContactPersonFaxNumber", getContactPersonFaxNumber());
        values.put("ContactPersonFaxCountry", getContactPersonFaxCountry());
        values.put("DisputeCaseBPCorrespondenceKey", getDisputeCaseBPCorrespondenceKey());
        values.put("DisputeCaseInformationText", getDisputeCaseInformationText());
        values.put("DisputeCaseTransactionDate", getDisputeCaseTransactionDate());
        values.put("CADisputeCase", getCADisputeCase());
        values.put("CaseType", getCaseType());
        values.put("CaseID", getCaseID());
        values.put("CaseExternalReference", getCaseExternalReference());
        values.put("CaseCreatedBy", getCaseCreatedBy());
        values.put("CaseCreationDate", getCaseCreationDate());
        values.put("CaseLastChangedBy", getCaseLastChangedBy());
        values.put("CaseLastChangedOn", getCaseLastChangedOn());
        values.put("CaseStatusProfile", getCaseStatusProfile());
        values.put("CaseClosedBy", getCaseClosedBy());
        values.put("CaseClosedTime", getCaseClosedTime());
        values.put("CasePlannedCloseDate", getCasePlannedCloseDate());
        values.put("CaseProcessor", getCaseProcessor());
        values.put("CaseResponsible", getCaseResponsible());
        values.put("CaseTitle", getCaseTitle());
        values.put("CaseAuthorizationLevel", getCaseAuthorizationLevel());
        values.put("CaseStatus", getCaseStatus());
        values.put("CaseStatusName", getCaseStatusName());
        values.put("CaseSystemStatus", getCaseSystemStatus());
        values.put("CaseUserStatusName", getCaseUserStatusName());
        values.put("CasePriority", getCasePriority());
        values.put("DisputeCasePriorityName", getDisputeCasePriorityName());
        values.put("CaseCategory", getCaseCategory());
        values.put("DisputeCaseCategoryName", getDisputeCaseCategoryName());
        values.put("CaseReason", getCaseReason());
        values.put("CaseReasonName", getCaseReasonName());
        values.put("CaseEscalationReason", getCaseEscalationReason());
        values.put("DsputCaseEscalationRsnName", getDsputCaseEscalationRsnName());
        values.put("StreetName", getStreetName());
        values.put("HouseNumber", getHouseNumber());
        values.put("CountryName", getCountryName());
        values.put("PostalCode", getPostalCode());
        values.put("CityName", getCityName());
        values.put("CADisputeExternalCallerCode", getCADisputeExternalCallerCode());
        values.put("DisputeCaseOrigin", getDisputeCaseOrigin());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CaseUUID") ) {
                final Object value = values.remove("CaseUUID");
                if( (value == null) || (!value.equals(getCaseUUID())) ) {
                    setCaseUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartnerFullName") ) {
                final Object value = values.remove("BusinessPartnerFullName");
                if( (value == null) || (!value.equals(getBusinessPartnerFullName())) ) {
                    setBusinessPartnerFullName(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractAccount") ) {
                final Object value = values.remove("ContractAccount");
                if( (value == null) || (!value.equals(getContractAccount())) ) {
                    setContractAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractAccountName") ) {
                final Object value = values.remove("ContractAccountName");
                if( (value == null) || (!value.equals(getContractAccountName())) ) {
                    setContractAccountName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAContract") ) {
                final Object value = values.remove("CAContract");
                if( (value == null) || (!value.equals(getCAContract())) ) {
                    setCAContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAApplicationArea") ) {
                final Object value = values.remove("CAApplicationArea");
                if( (value == null) || (!value.equals(getCAApplicationArea())) ) {
                    setCAApplicationArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubApplication") ) {
                final Object value = values.remove("CASubApplication");
                if( (value == null) || (!value.equals(getCASubApplication())) ) {
                    setCASubApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("DisputedAmount") ) {
                final Object value = values.remove("DisputedAmount");
                if( (value == null) || (!value.equals(getDisputedAmount())) ) {
                    setDisputedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TotalReceivablesAmount") ) {
                final Object value = values.remove("TotalReceivablesAmount");
                if( (value == null) || (!value.equals(getTotalReceivablesAmount())) ) {
                    setTotalReceivablesAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("DisputeCaseCorrectionAmount") ) {
                final Object value = values.remove("DisputeCaseCorrectionAmount");
                if( (value == null) || (!value.equals(getDisputeCaseCorrectionAmount())) ) {
                    setDisputeCaseCorrectionAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("DisputeCaseReversedAmount") ) {
                final Object value = values.remove("DisputeCaseReversedAmount");
                if( (value == null) || (!value.equals(getDisputeCaseReversedAmount())) ) {
                    setDisputeCaseReversedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditedAmount") ) {
                final Object value = values.remove("CreditedAmount");
                if( (value == null) || (!value.equals(getCreditedAmount())) ) {
                    setCreditedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("WriteOffAmount") ) {
                final Object value = values.remove("WriteOffAmount");
                if( (value == null) || (!value.equals(getWriteOffAmount())) ) {
                    setWriteOffAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("DisputeCaseReplacedAmount") ) {
                final Object value = values.remove("DisputeCaseReplacedAmount");
                if( (value == null) || (!value.equals(getDisputeCaseReplacedAmount())) ) {
                    setDisputeCaseReplacedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaidAmount") ) {
                final Object value = values.remove("PaidAmount");
                if( (value == null) || (!value.equals(getPaidAmount())) ) {
                    setPaidAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CARemainingDisputedAmount") ) {
                final Object value = values.remove("CARemainingDisputedAmount");
                if( (value == null) || (!value.equals(getCARemainingDisputedAmount())) ) {
                    setCARemainingDisputedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("DisputeCaseCurrency") ) {
                final Object value = values.remove("DisputeCaseCurrency");
                if( (value == null) || (!value.equals(getDisputeCaseCurrency())) ) {
                    setDisputeCaseCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADisputeType") ) {
                final Object value = values.remove("CADisputeType");
                if( (value == null) || (!value.equals(getCADisputeType())) ) {
                    setCADisputeType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADisputeTypeText") ) {
                final Object value = values.remove("CADisputeTypeText");
                if( (value == null) || (!value.equals(getCADisputeTypeText())) ) {
                    setCADisputeTypeText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("DisputeCaseCoordinator") ) {
                final Object value = values.remove("DisputeCaseCoordinator");
                if( (value == null) || (!value.equals(getDisputeCaseCoordinator())) ) {
                    setDisputeCaseCoordinator(((java.lang.String) value));
                }
            }
            if( values.containsKey("DisputeCaseRootCause") ) {
                final Object value = values.remove("DisputeCaseRootCause");
                if( (value == null) || (!value.equals(getDisputeCaseRootCause())) ) {
                    setDisputeCaseRootCause(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseRootCauseDescription") ) {
                final Object value = values.remove("CaseRootCauseDescription");
                if( (value == null) || (!value.equals(getCaseRootCauseDescription())) ) {
                    setCaseRootCauseDescription(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseProcessingDeadlineDate") ) {
                final Object value = values.remove("CaseProcessingDeadlineDate");
                if( (value == null) || (!value.equals(getCaseProcessingDeadlineDate())) ) {
                    setCaseProcessingDeadlineDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ContactPersonFullName") ) {
                final Object value = values.remove("ContactPersonFullName");
                if( (value == null) || (!value.equals(getContactPersonFullName())) ) {
                    setContactPersonFullName(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContactPersonEmailAddress") ) {
                final Object value = values.remove("ContactPersonEmailAddress");
                if( (value == null) || (!value.equals(getContactPersonEmailAddress())) ) {
                    setContactPersonEmailAddress(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContactPersonPhoneNumber") ) {
                final Object value = values.remove("ContactPersonPhoneNumber");
                if( (value == null) || (!value.equals(getContactPersonPhoneNumber())) ) {
                    setContactPersonPhoneNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContactPersonFaxNumber") ) {
                final Object value = values.remove("ContactPersonFaxNumber");
                if( (value == null) || (!value.equals(getContactPersonFaxNumber())) ) {
                    setContactPersonFaxNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContactPersonFaxCountry") ) {
                final Object value = values.remove("ContactPersonFaxCountry");
                if( (value == null) || (!value.equals(getContactPersonFaxCountry())) ) {
                    setContactPersonFaxCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("DisputeCaseBPCorrespondenceKey") ) {
                final Object value = values.remove("DisputeCaseBPCorrespondenceKey");
                if( (value == null) || (!value.equals(getDisputeCaseBPCorrespondenceKey())) ) {
                    setDisputeCaseBPCorrespondenceKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("DisputeCaseInformationText") ) {
                final Object value = values.remove("DisputeCaseInformationText");
                if( (value == null) || (!value.equals(getDisputeCaseInformationText())) ) {
                    setDisputeCaseInformationText(((java.lang.String) value));
                }
            }
            if( values.containsKey("DisputeCaseTransactionDate") ) {
                final Object value = values.remove("DisputeCaseTransactionDate");
                if( (value == null) || (!value.equals(getDisputeCaseTransactionDate())) ) {
                    setDisputeCaseTransactionDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CADisputeCase") ) {
                final Object value = values.remove("CADisputeCase");
                if( (value == null) || (!value.equals(getCADisputeCase())) ) {
                    setCADisputeCase(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseType") ) {
                final Object value = values.remove("CaseType");
                if( (value == null) || (!value.equals(getCaseType())) ) {
                    setCaseType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseID") ) {
                final Object value = values.remove("CaseID");
                if( (value == null) || (!value.equals(getCaseID())) ) {
                    setCaseID(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseExternalReference") ) {
                final Object value = values.remove("CaseExternalReference");
                if( (value == null) || (!value.equals(getCaseExternalReference())) ) {
                    setCaseExternalReference(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseCreatedBy") ) {
                final Object value = values.remove("CaseCreatedBy");
                if( (value == null) || (!value.equals(getCaseCreatedBy())) ) {
                    setCaseCreatedBy(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseCreationDate") ) {
                final Object value = values.remove("CaseCreationDate");
                if( (value == null) || (!value.equals(getCaseCreationDate())) ) {
                    setCaseCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CaseLastChangedBy") ) {
                final Object value = values.remove("CaseLastChangedBy");
                if( (value == null) || (!value.equals(getCaseLastChangedBy())) ) {
                    setCaseLastChangedBy(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseLastChangedOn") ) {
                final Object value = values.remove("CaseLastChangedOn");
                if( (value == null) || (!value.equals(getCaseLastChangedOn())) ) {
                    setCaseLastChangedOn(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("CaseStatusProfile") ) {
                final Object value = values.remove("CaseStatusProfile");
                if( (value == null) || (!value.equals(getCaseStatusProfile())) ) {
                    setCaseStatusProfile(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseClosedBy") ) {
                final Object value = values.remove("CaseClosedBy");
                if( (value == null) || (!value.equals(getCaseClosedBy())) ) {
                    setCaseClosedBy(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseClosedTime") ) {
                final Object value = values.remove("CaseClosedTime");
                if( (value == null) || (!value.equals(getCaseClosedTime())) ) {
                    setCaseClosedTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("CasePlannedCloseDate") ) {
                final Object value = values.remove("CasePlannedCloseDate");
                if( (value == null) || (!value.equals(getCasePlannedCloseDate())) ) {
                    setCasePlannedCloseDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CaseProcessor") ) {
                final Object value = values.remove("CaseProcessor");
                if( (value == null) || (!value.equals(getCaseProcessor())) ) {
                    setCaseProcessor(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseResponsible") ) {
                final Object value = values.remove("CaseResponsible");
                if( (value == null) || (!value.equals(getCaseResponsible())) ) {
                    setCaseResponsible(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseTitle") ) {
                final Object value = values.remove("CaseTitle");
                if( (value == null) || (!value.equals(getCaseTitle())) ) {
                    setCaseTitle(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseAuthorizationLevel") ) {
                final Object value = values.remove("CaseAuthorizationLevel");
                if( (value == null) || (!value.equals(getCaseAuthorizationLevel())) ) {
                    setCaseAuthorizationLevel(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseStatus") ) {
                final Object value = values.remove("CaseStatus");
                if( (value == null) || (!value.equals(getCaseStatus())) ) {
                    setCaseStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseStatusName") ) {
                final Object value = values.remove("CaseStatusName");
                if( (value == null) || (!value.equals(getCaseStatusName())) ) {
                    setCaseStatusName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseSystemStatus") ) {
                final Object value = values.remove("CaseSystemStatus");
                if( (value == null) || (!value.equals(getCaseSystemStatus())) ) {
                    setCaseSystemStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseUserStatusName") ) {
                final Object value = values.remove("CaseUserStatusName");
                if( (value == null) || (!value.equals(getCaseUserStatusName())) ) {
                    setCaseUserStatusName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CasePriority") ) {
                final Object value = values.remove("CasePriority");
                if( (value == null) || (!value.equals(getCasePriority())) ) {
                    setCasePriority(((java.lang.String) value));
                }
            }
            if( values.containsKey("DisputeCasePriorityName") ) {
                final Object value = values.remove("DisputeCasePriorityName");
                if( (value == null) || (!value.equals(getDisputeCasePriorityName())) ) {
                    setDisputeCasePriorityName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseCategory") ) {
                final Object value = values.remove("CaseCategory");
                if( (value == null) || (!value.equals(getCaseCategory())) ) {
                    setCaseCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("DisputeCaseCategoryName") ) {
                final Object value = values.remove("DisputeCaseCategoryName");
                if( (value == null) || (!value.equals(getDisputeCaseCategoryName())) ) {
                    setDisputeCaseCategoryName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseReason") ) {
                final Object value = values.remove("CaseReason");
                if( (value == null) || (!value.equals(getCaseReason())) ) {
                    setCaseReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseReasonName") ) {
                final Object value = values.remove("CaseReasonName");
                if( (value == null) || (!value.equals(getCaseReasonName())) ) {
                    setCaseReasonName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CaseEscalationReason") ) {
                final Object value = values.remove("CaseEscalationReason");
                if( (value == null) || (!value.equals(getCaseEscalationReason())) ) {
                    setCaseEscalationReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("DsputCaseEscalationRsnName") ) {
                final Object value = values.remove("DsputCaseEscalationRsnName");
                if( (value == null) || (!value.equals(getDsputCaseEscalationRsnName())) ) {
                    setDsputCaseEscalationRsnName(((java.lang.String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((java.lang.String) value));
                }
            }
            if( values.containsKey("HouseNumber") ) {
                final Object value = values.remove("HouseNumber");
                if( (value == null) || (!value.equals(getHouseNumber())) ) {
                    setHouseNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CountryName") ) {
                final Object value = values.remove("CountryName");
                if( (value == null) || (!value.equals(getCountryName())) ) {
                    setCountryName(((java.lang.String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADisputeExternalCallerCode") ) {
                final Object value = values.remove("CADisputeExternalCallerCode");
                if( (value == null) || (!value.equals(getCADisputeExternalCallerCode())) ) {
                    setCADisputeExternalCallerCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("DisputeCaseOrigin") ) {
                final Object value = values.remove("DisputeCaseOrigin");
                if( (value == null) || (!value.equals(getDisputeCaseOrigin())) ) {
                    setDisputeCaseOrigin(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_CACaseObject") ) {
                final Object value = (values).remove("_CACaseObject");
                if( value instanceof Iterable ) {
                    if( to_CACaseObject == null ) {
                        to_CACaseObject = Lists.newArrayList();
                    } else {
                        to_CACaseObject = Lists.newArrayList(to_CACaseObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DisputeCaseObject entity;
                        if( to_CACaseObject.size() > i ) {
                            entity = to_CACaseObject.get(i);
                        } else {
                            entity = new DisputeCaseObject();
                            to_CACaseObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingDisputeCaseService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CACaseObject != null ) {
            (values).put("_CACaseObject", to_CACaseObject);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>DisputeCaseObject</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_CACaseObject</b>.
     * <p>
     * If the navigation property for an entity <b>DisputeCase</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CACaseObject</b> is already loaded, the result will
     *         contain the <b>DisputeCaseObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DisputeCaseObject>> getCACaseObjectIfPresent()
    {
        return Option.of(to_CACaseObject);
    }

    /**
     * Overwrites the list of associated <b>DisputeCaseObject</b> entities for the loaded navigation property
     * <b>_CACaseObject</b>.
     * <p>
     * If the navigation property <b>_CACaseObject</b> of a queried <b>DisputeCase</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>DisputeCaseObject</b> entities.
     */
    public void setCACaseObject( @Nonnull final List<DisputeCaseObject> value )
    {
        if( to_CACaseObject == null ) {
            to_CACaseObject = Lists.newArrayList();
        }
        to_CACaseObject.clear();
        to_CACaseObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DisputeCaseObject</b> entities. This corresponds to the OData
     * navigation property <b>_CACaseObject</b>.
     * <p>
     * If the navigation property <b>_CACaseObject</b> of a queried <b>DisputeCase</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>DisputeCaseObject</b> entities.
     */
    public void addCACaseObject( DisputeCaseObject... entity )
    {
        if( to_CACaseObject == null ) {
            to_CACaseObject = Lists.newArrayList();
        }
        to_CACaseObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Function that can be applied to any entity object of this class.
     * </p>
     * 
     * @param caseNoteCreatedByUser
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CaseNoteCreatedByUser</b>
     *            </p>
     * @return Function object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyFunction(thisFunction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundFunction.SingleToCollection<DisputeCase, D_CADisputeCaseRetrieveNoteR>
        retrieveNote( @Nonnull final java.lang.String caseNoteCreatedByUser )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("CaseNoteCreatedByUser", caseNoteCreatedByUser);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundFunction.SingleToCollection<DisputeCase, D_CADisputeCaseRetrieveNoteR>(
            DisputeCase.class,
            D_CADisputeCaseRetrieveNoteR.class,
            "com.sap.gateway.srvd_a2x.api_cadisputecase.v0001.RetrieveNote",
            parameters);
    }

    /**
     * Function that can be applied to any entity object of this class.
     * </p>
     * 
     * @param caseAttachmentCreatedByUser
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CaseAttachmentCreatedByUser</b>
     *            </p>
     * @return Function object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyFunction(thisFunction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundFunction.SingleToCollection<DisputeCase, D_CADisputeCaseRetrieveAttchR>
        retrieveAttachment( @Nonnull final java.lang.String caseAttachmentCreatedByUser )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("CaseAttachmentCreatedByUser", caseAttachmentCreatedByUser);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundFunction.SingleToCollection<DisputeCase, D_CADisputeCaseRetrieveAttchR>(
            DisputeCase.class,
            D_CADisputeCaseRetrieveAttchR.class,
            "com.sap.gateway.srvd_a2x.api_cadisputecase.v0001.RetrieveAttachment",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param caseAttachmentName
     *            Constraints: Not nullable, Maximum length: 255
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CaseAttachmentName</b>
     *            </p>
     * @param caseAttachmentContentBinary
     *            Constraints: Not nullable, Maximum length: 255
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CaseAttachmentContentBinary</b>
     *            </p>
     * @param mimeType
     *            Constraints: Not nullable, Maximum length: 128
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MimeType</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<DisputeCase, Void>
        assignAttachment(
            @Nonnull final byte[] caseAttachmentContentBinary,
            @Nonnull final java.lang.String caseAttachmentName,
            @Nonnull final java.lang.String mimeType )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("CaseAttachmentContentBinary", caseAttachmentContentBinary);
        parameters.put("CaseAttachmentName", caseAttachmentName);
        parameters.put("MimeType", mimeType);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<DisputeCase, Void>(
            DisputeCase.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_cadisputecase.v0001.AssignAttachment",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param caseNoteText
     *            Constraints: Not nullable, Maximum length: 132
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CaseNoteText</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<DisputeCase, Void> assignNote(
        @Nonnull final java.lang.String caseNoteText )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("CaseNoteText", caseNoteText);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<DisputeCase, Void>(
            DisputeCase.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_cadisputecase.v0001.AssignNote",
            parameters);
    }

    /**
     * Action that can be applied to a collection of entities of this class.
     * </p>
     * 
     * @param disputeCaseCurrency
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DisputeCaseCurrency</b>
     *            </p>
     * @param cADisputeExternalCallerCode
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADisputeExternalCallerCode</b>
     *            </p>
     * @param cADisputeType
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CADisputeType</b>
     *            </p>
     * @param disputedAmount
     *            Constraints: Not nullable, Precision: 15, Scale: 0
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DisputedAmount</b>
     *            </p>
     * @param caseUUID
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CaseUUID</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to a collection of entities of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<DisputeCase, D_CADisputeCaseCopyResult>
        copy(
            @Nonnull final UUID caseUUID,
            @Nonnull final java.lang.String cADisputeType,
            @Nonnull final BigDecimal disputedAmount,
            @Nonnull final java.lang.String disputeCaseCurrency,
            @Nonnull final java.lang.String cADisputeExternalCallerCode )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("CaseUUID", caseUUID);
        parameters.put("CADisputeType", cADisputeType);
        parameters.put("DisputedAmount", disputedAmount);
        parameters.put("DisputeCaseCurrency", disputeCaseCurrency);
        parameters.put("CADisputeExternalCallerCode", cADisputeExternalCallerCode);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<DisputeCase, D_CADisputeCaseCopyResult>(
            DisputeCase.class,
            D_CADisputeCaseCopyResult.class,
            "com.sap.gateway.srvd_a2x.api_cadisputecase.v0001.Copy",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of DisputeCase instances.
     * 
     */
    public final static class DisputeCaseBuilder
    {

        private List<DisputeCaseObject> to_CACaseObject = Lists.newArrayList();

        private DisputeCase.DisputeCaseBuilder to_CACaseObject( final List<DisputeCaseObject> value )
        {
            to_CACaseObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CACaseObject</b> for <b>DisputeCase</b> to multiple <b>DisputeCaseObject</b>.
         * 
         * @param value
         *            The DisputeCaseObjects to build this DisputeCase with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DisputeCase.DisputeCaseBuilder caCaseObject( DisputeCaseObject... value )
        {
            return to_CACaseObject(Lists.newArrayList(value));
        }

    }

}
