/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingDisputeCaseService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Dispute Case Object
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>DisputeCaseObjectType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class DisputeCaseObject extends VdmEntity<DisputeCaseObject> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_cadisputecase.v0001.DisputeCaseObjectType";
    /**
     * Selector for all available fields of DisputeCaseObject.
     * 
     */
    public final static SimpleProperty<DisputeCaseObject> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseUUID</b>
     * </p>
     * 
     * @return UUID in Character Format
     */
    @Nullable
    @ElementName( "CaseUUID" )
    private UUID caseUUID;
    public final static SimpleProperty.Guid<DisputeCaseObject> CASE_UUID =
        new SimpleProperty.Guid<DisputeCaseObject>(DisputeCaseObject.class, "CaseUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ObjectType</b>
     * </p>
     * 
     * @return Object Type
     */
    @Nullable
    @ElementName( "ObjectType" )
    private java.lang.String objectType;
    public final static SimpleProperty.String<DisputeCaseObject> OBJECT_TYPE =
        new SimpleProperty.String<DisputeCaseObject>(DisputeCaseObject.class, "ObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>ObjectKey</b>
     * </p>
     * 
     * @return Object key
     */
    @Nullable
    @ElementName( "ObjectKey" )
    private java.lang.String objectKey;
    public final static SimpleProperty.String<DisputeCaseObject> OBJECT_KEY =
        new SimpleProperty.String<DisputeCaseObject>(DisputeCaseObject.class, "ObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ObjectClassification</b>
     * </p>
     * 
     * @return Object Classification
     */
    @Nullable
    @ElementName( "ObjectClassification" )
    private java.lang.String objectClassification;
    public final static SimpleProperty.String<DisputeCaseObject> OBJECT_CLASSIFICATION =
        new SimpleProperty.String<DisputeCaseObject>(DisputeCaseObject.class, "ObjectClassification");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentLot</b>
     * </p>
     * 
     * @return Payment Lot
     */
    @Nullable
    @ElementName( "CAPaymentLot" )
    private java.lang.String cAPaymentLot;
    public final static SimpleProperty.String<DisputeCaseObject> CA_PAYMENT_LOT =
        new SimpleProperty.String<DisputeCaseObject>(DisputeCaseObject.class, "CAPaymentLot");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentLotItem</b>
     * </p>
     * 
     * @return Item number in a payment lot
     */
    @Nullable
    @ElementName( "CAPaymentLotItem" )
    private java.lang.String cAPaymentLotItem;
    public final static SimpleProperty.String<DisputeCaseObject> CA_PAYMENT_LOT_ITEM =
        new SimpleProperty.String<DisputeCaseObject>(DisputeCaseObject.class, "CAPaymentLotItem");
    /**
     * Navigation property <b>_CADisputeCase</b> for <b>DisputeCaseObject</b> to single <b>DisputeCase</b>.
     * 
     */
    @ElementName( "_CADisputeCase" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DisputeCase to_CADisputeCase;
    /**
     * Use with available request builders to apply the <b>_CADisputeCase</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<DisputeCaseObject, DisputeCase> TO__C_A_DISPUTE_CASE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<DisputeCaseObject, DisputeCase>(
            DisputeCaseObject.class,
            "_CADisputeCase",
            DisputeCase.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<DisputeCaseObject> getType()
    {
        return DisputeCaseObject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CaseUUID</b>
     * </p>
     * 
     * @param caseUUID
     *            UUID in Character Format
     */
    public void setCaseUUID( @Nullable final UUID caseUUID )
    {
        rememberChangedField("CaseUUID", this.caseUUID);
        this.caseUUID = caseUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ObjectType</b>
     * </p>
     * 
     * @param objectType
     *            Object Type
     */
    public void setObjectType( @Nullable final java.lang.String objectType )
    {
        rememberChangedField("ObjectType", this.objectType);
        this.objectType = objectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>ObjectKey</b>
     * </p>
     * 
     * @param objectKey
     *            Object key
     */
    public void setObjectKey( @Nullable final java.lang.String objectKey )
    {
        rememberChangedField("ObjectKey", this.objectKey);
        this.objectKey = objectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ObjectClassification</b>
     * </p>
     * 
     * @param objectClassification
     *            Object Classification
     */
    public void setObjectClassification( @Nullable final java.lang.String objectClassification )
    {
        rememberChangedField("ObjectClassification", this.objectClassification);
        this.objectClassification = objectClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentLot</b>
     * </p>
     * 
     * @param cAPaymentLot
     *            Payment Lot
     */
    public void setCAPaymentLot( @Nullable final java.lang.String cAPaymentLot )
    {
        rememberChangedField("CAPaymentLot", this.cAPaymentLot);
        this.cAPaymentLot = cAPaymentLot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentLotItem</b>
     * </p>
     * 
     * @param cAPaymentLotItem
     *            Item number in a payment lot
     */
    public void setCAPaymentLotItem( @Nullable final java.lang.String cAPaymentLotItem )
    {
        rememberChangedField("CAPaymentLotItem", this.cAPaymentLotItem);
        this.cAPaymentLotItem = cAPaymentLotItem;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "DisputeCaseObject";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CaseUUID", getCaseUUID());
        entityKey.addKeyProperty("ObjectType", getObjectType());
        entityKey.addKeyProperty("ObjectKey", getObjectKey());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CaseUUID", getCaseUUID());
        values.put("ObjectType", getObjectType());
        values.put("ObjectKey", getObjectKey());
        values.put("ObjectClassification", getObjectClassification());
        values.put("CAPaymentLot", getCAPaymentLot());
        values.put("CAPaymentLotItem", getCAPaymentLotItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CaseUUID") ) {
                final Object value = values.remove("CaseUUID");
                if( (value == null) || (!value.equals(getCaseUUID())) ) {
                    setCaseUUID(((UUID) value));
                }
            }
            if( values.containsKey("ObjectType") ) {
                final Object value = values.remove("ObjectType");
                if( (value == null) || (!value.equals(getObjectType())) ) {
                    setObjectType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ObjectKey") ) {
                final Object value = values.remove("ObjectKey");
                if( (value == null) || (!value.equals(getObjectKey())) ) {
                    setObjectKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("ObjectClassification") ) {
                final Object value = values.remove("ObjectClassification");
                if( (value == null) || (!value.equals(getObjectClassification())) ) {
                    setObjectClassification(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPaymentLot") ) {
                final Object value = values.remove("CAPaymentLot");
                if( (value == null) || (!value.equals(getCAPaymentLot())) ) {
                    setCAPaymentLot(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPaymentLotItem") ) {
                final Object value = values.remove("CAPaymentLotItem");
                if( (value == null) || (!value.equals(getCAPaymentLotItem())) ) {
                    setCAPaymentLotItem(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_CADisputeCase") ) {
                final Object value = (values).remove("_CADisputeCase");
                if( value instanceof Map ) {
                    if( to_CADisputeCase == null ) {
                        to_CADisputeCase = new DisputeCase();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_CADisputeCase.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingDisputeCaseService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CADisputeCase != null ) {
            (values).put("_CADisputeCase", to_CADisputeCase);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>DisputeCase</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_CADisputeCase</b>.
     * <p>
     * If the navigation property for an entity <b>DisputeCaseObject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CADisputeCase</b> is already loaded, the result will
     *         contain the <b>DisputeCase</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DisputeCase> getCADisputeCaseIfPresent()
    {
        return Option.of(to_CADisputeCase);
    }

    /**
     * Overwrites the associated <b>DisputeCase</b> entity for the loaded navigation property <b>_CADisputeCase</b>.
     * 
     * @param value
     *            New <b>DisputeCase</b> entity.
     */
    public void setCADisputeCase( final DisputeCase value )
    {
        to_CADisputeCase = value;
    }

    /**
     * Helper class to allow for fluent creation of DisputeCaseObject instances.
     * 
     */
    public final static class DisputeCaseObjectBuilder
    {

        private DisputeCase to_CADisputeCase;

        private DisputeCaseObject.DisputeCaseObjectBuilder to_CADisputeCase( final DisputeCase value )
        {
            to_CADisputeCase = value;
            return this;
        }

        /**
         * Navigation property <b>_CADisputeCase</b> for <b>DisputeCaseObject</b> to single <b>DisputeCase</b>.
         * 
         * @param value
         *            The DisputeCase to build this DisputeCaseObject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DisputeCaseObject.DisputeCaseObjectBuilder caDisputeCase( final DisputeCase value )
        {
            return to_CADisputeCase(value);
        }

    }

}
