/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage;

import java.time.LocalDate;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingDocumentManageService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Bus.Part. Item Business Lock
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BPItemBusLockType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BPItemBusLock extends VdmEntity<BPItemBusLock> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_cadocumentmanage.v0001.BPItemBusLockType";
    /**
     * Selector for all available fields of BPItemBusLock.
     * 
     */
    public final static SimpleProperty<BPItemBusLock> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @return The cADocumentNumber contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CADocumentNumber" )
    private java.lang.String cADocumentNumber;
    public final static SimpleProperty.String<BPItemBusLock> CA_DOCUMENT_NUMBER =
        new SimpleProperty.String<BPItemBusLock>(BPItemBusLock.class, "CADocumentNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CARepetitionItemNumber</b>
     * </p>
     * 
     * @return Repetition Item in FI-CA Document
     */
    @Nullable
    @ElementName( "CARepetitionItemNumber" )
    private java.lang.String cARepetitionItemNumber;
    public final static SimpleProperty.String<BPItemBusLock> CA_REPETITION_ITEM_NUMBER =
        new SimpleProperty.String<BPItemBusLock>(BPItemBusLock.class, "CARepetitionItemNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CABPItemNumber</b>
     * </p>
     * 
     * @return Item Number in FI-CA Document
     */
    @Nullable
    @ElementName( "CABPItemNumber" )
    private java.lang.String cABPItemNumber;
    public final static SimpleProperty.String<BPItemBusLock> CABP_ITEM_NUMBER =
        new SimpleProperty.String<BPItemBusLock>(BPItemBusLock.class, "CABPItemNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CASubItemNumber</b>
     * </p>
     * 
     * @return Subitem for a Partial Clearing in Document
     */
    @Nullable
    @ElementName( "CASubItemNumber" )
    private java.lang.String cASubItemNumber;
    public final static SimpleProperty.String<BPItemBusLock> CA_SUB_ITEM_NUMBER =
        new SimpleProperty.String<BPItemBusLock>(BPItemBusLock.class, "CASubItemNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CABusinessProcess</b>
     * </p>
     * 
     * @return Process Code (Example: Dunning, Payment)
     */
    @Nullable
    @ElementName( "CABusinessProcess" )
    private java.lang.String cABusinessProcess;
    public final static SimpleProperty.String<BPItemBusLock> CA_BUSINESS_PROCESS =
        new SimpleProperty.String<BPItemBusLock>(BPItemBusLock.class, "CABusinessProcess");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CABusinessLockReason</b>
     * </p>
     * 
     * @return Lock Reason
     */
    @Nullable
    @ElementName( "CABusinessLockReason" )
    private java.lang.String cABusinessLockReason;
    public final static SimpleProperty.String<BPItemBusLock> CA_BUSINESS_LOCK_REASON =
        new SimpleProperty.String<BPItemBusLock>(BPItemBusLock.class, "CABusinessLockReason");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CABusinessLockValidFrom</b>
     * </p>
     * 
     * @return Lock valid from
     */
    @Nullable
    @ElementName( "CABusinessLockValidFrom" )
    private LocalDate cABusinessLockValidFrom;
    public final static SimpleProperty.Date<BPItemBusLock> CA_BUSINESS_LOCK_VALID_FROM =
        new SimpleProperty.Date<BPItemBusLock>(BPItemBusLock.class, "CABusinessLockValidFrom");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CABusinessLockValidTo</b>
     * </p>
     * 
     * @return Lock valid to
     */
    @Nullable
    @ElementName( "CABusinessLockValidTo" )
    private LocalDate cABusinessLockValidTo;
    public final static SimpleProperty.Date<BPItemBusLock> CA_BUSINESS_LOCK_VALID_TO =
        new SimpleProperty.Date<BPItemBusLock>(BPItemBusLock.class, "CABusinessLockValidTo");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<BPItemBusLock, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<BPItemBusLock, SAP__Message>(
            BPItemBusLock.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_BPItem</b> for <b>BPItemBusLock</b> to single <b>BPItemLogical</b>.
     * 
     */
    @ElementName( "_BPItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BPItemLogical to_BPItem;
    /**
     * Navigation property <b>_DocHeader</b> for <b>BPItemBusLock</b> to single <b>DocumentHeader</b>.
     * 
     */
    @ElementName( "_DocHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DocumentHeader to_DocHeader;
    /**
     * Use with available request builders to apply the <b>_BPItem</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BPItemBusLock, BPItemLogical> TO__B_P_ITEM =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BPItemBusLock, BPItemLogical>(
            BPItemBusLock.class,
            "_BPItem",
            BPItemLogical.class);
    /**
     * Use with available request builders to apply the <b>_DocHeader</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BPItemBusLock, DocumentHeader> TO__DOC_HEADER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BPItemBusLock, DocumentHeader>(
            BPItemBusLock.class,
            "_DocHeader",
            DocumentHeader.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BPItemBusLock> getType()
    {
        return BPItemBusLock.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @param cADocumentNumber
     *            The cADocumentNumber to set.
     */
    public void setCADocumentNumber( @Nullable final java.lang.String cADocumentNumber )
    {
        rememberChangedField("CADocumentNumber", this.cADocumentNumber);
        this.cADocumentNumber = cADocumentNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CARepetitionItemNumber</b>
     * </p>
     * 
     * @param cARepetitionItemNumber
     *            Repetition Item in FI-CA Document
     */
    public void setCARepetitionItemNumber( @Nullable final java.lang.String cARepetitionItemNumber )
    {
        rememberChangedField("CARepetitionItemNumber", this.cARepetitionItemNumber);
        this.cARepetitionItemNumber = cARepetitionItemNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CABPItemNumber</b>
     * </p>
     * 
     * @param cABPItemNumber
     *            Item Number in FI-CA Document
     */
    public void setCABPItemNumber( @Nullable final java.lang.String cABPItemNumber )
    {
        rememberChangedField("CABPItemNumber", this.cABPItemNumber);
        this.cABPItemNumber = cABPItemNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CASubItemNumber</b>
     * </p>
     * 
     * @param cASubItemNumber
     *            Subitem for a Partial Clearing in Document
     */
    public void setCASubItemNumber( @Nullable final java.lang.String cASubItemNumber )
    {
        rememberChangedField("CASubItemNumber", this.cASubItemNumber);
        this.cASubItemNumber = cASubItemNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CABusinessProcess</b>
     * </p>
     * 
     * @param cABusinessProcess
     *            Process Code (Example: Dunning, Payment)
     */
    public void setCABusinessProcess( @Nullable final java.lang.String cABusinessProcess )
    {
        rememberChangedField("CABusinessProcess", this.cABusinessProcess);
        this.cABusinessProcess = cABusinessProcess;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CABusinessLockReason</b>
     * </p>
     * 
     * @param cABusinessLockReason
     *            Lock Reason
     */
    public void setCABusinessLockReason( @Nullable final java.lang.String cABusinessLockReason )
    {
        rememberChangedField("CABusinessLockReason", this.cABusinessLockReason);
        this.cABusinessLockReason = cABusinessLockReason;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CABusinessLockValidFrom</b>
     * </p>
     * 
     * @param cABusinessLockValidFrom
     *            Lock valid from
     */
    public void setCABusinessLockValidFrom( @Nullable final LocalDate cABusinessLockValidFrom )
    {
        rememberChangedField("CABusinessLockValidFrom", this.cABusinessLockValidFrom);
        this.cABusinessLockValidFrom = cABusinessLockValidFrom;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CABusinessLockValidTo</b>
     * </p>
     * 
     * @param cABusinessLockValidTo
     *            Lock valid to
     */
    public void setCABusinessLockValidTo( @Nullable final LocalDate cABusinessLockValidTo )
    {
        rememberChangedField("CABusinessLockValidTo", this.cABusinessLockValidTo);
        this.cABusinessLockValidTo = cABusinessLockValidTo;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "BPItemBusLock";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentNumber", getCADocumentNumber());
        entityKey.addKeyProperty("CARepetitionItemNumber", getCARepetitionItemNumber());
        entityKey.addKeyProperty("CABPItemNumber", getCABPItemNumber());
        entityKey.addKeyProperty("CASubItemNumber", getCASubItemNumber());
        entityKey.addKeyProperty("CABusinessProcess", getCABusinessProcess());
        entityKey.addKeyProperty("CABusinessLockReason", getCABusinessLockReason());
        entityKey.addKeyProperty("CABusinessLockValidFrom", getCABusinessLockValidFrom());
        entityKey.addKeyProperty("CABusinessLockValidTo", getCABusinessLockValidTo());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentNumber", getCADocumentNumber());
        values.put("CARepetitionItemNumber", getCARepetitionItemNumber());
        values.put("CABPItemNumber", getCABPItemNumber());
        values.put("CASubItemNumber", getCASubItemNumber());
        values.put("CABusinessProcess", getCABusinessProcess());
        values.put("CABusinessLockReason", getCABusinessLockReason());
        values.put("CABusinessLockValidFrom", getCABusinessLockValidFrom());
        values.put("CABusinessLockValidTo", getCABusinessLockValidTo());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentNumber") ) {
                final Object value = values.remove("CADocumentNumber");
                if( (value == null) || (!value.equals(getCADocumentNumber())) ) {
                    setCADocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CARepetitionItemNumber") ) {
                final Object value = values.remove("CARepetitionItemNumber");
                if( (value == null) || (!value.equals(getCARepetitionItemNumber())) ) {
                    setCARepetitionItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CABPItemNumber") ) {
                final Object value = values.remove("CABPItemNumber");
                if( (value == null) || (!value.equals(getCABPItemNumber())) ) {
                    setCABPItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubItemNumber") ) {
                final Object value = values.remove("CASubItemNumber");
                if( (value == null) || (!value.equals(getCASubItemNumber())) ) {
                    setCASubItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CABusinessProcess") ) {
                final Object value = values.remove("CABusinessProcess");
                if( (value == null) || (!value.equals(getCABusinessProcess())) ) {
                    setCABusinessProcess(((java.lang.String) value));
                }
            }
            if( values.containsKey("CABusinessLockReason") ) {
                final Object value = values.remove("CABusinessLockReason");
                if( (value == null) || (!value.equals(getCABusinessLockReason())) ) {
                    setCABusinessLockReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CABusinessLockValidFrom") ) {
                final Object value = values.remove("CABusinessLockValidFrom");
                if( (value == null) || (!value.equals(getCABusinessLockValidFrom())) ) {
                    setCABusinessLockValidFrom(((LocalDate) value));
                }
            }
            if( values.containsKey("CABusinessLockValidTo") ) {
                final Object value = values.remove("CABusinessLockValidTo");
                if( (value == null) || (!value.equals(getCABusinessLockValidTo())) ) {
                    setCABusinessLockValidTo(((LocalDate) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_BPItem") ) {
                final Object value = (values).remove("_BPItem");
                if( value instanceof Map ) {
                    if( to_BPItem == null ) {
                        to_BPItem = new BPItemLogical();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_BPItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_DocHeader") ) {
                final Object value = (values).remove("_DocHeader");
                if( value instanceof Map ) {
                    if( to_DocHeader == null ) {
                        to_DocHeader = new DocumentHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_DocHeader.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingDocumentManageService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_BPItem != null ) {
            (values).put("_BPItem", to_BPItem);
        }
        if( to_DocHeader != null ) {
            (values).put("_DocHeader", to_DocHeader);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>BPItemLogical</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_BPItem</b>.
     * <p>
     * If the navigation property for an entity <b>BPItemBusLock</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_BPItem</b> is already loaded, the result will contain the
     *         <b>BPItemLogical</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<BPItemLogical> getBPItemIfPresent()
    {
        return Option.of(to_BPItem);
    }

    /**
     * Overwrites the associated <b>BPItemLogical</b> entity for the loaded navigation property <b>_BPItem</b>.
     * 
     * @param value
     *            New <b>BPItemLogical</b> entity.
     */
    public void setBPItem( final BPItemLogical value )
    {
        to_BPItem = value;
    }

    /**
     * Retrieval of associated <b>DocumentHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_DocHeader</b>.
     * <p>
     * If the navigation property for an entity <b>BPItemBusLock</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_DocHeader</b> is already loaded, the result will contain
     *         the <b>DocumentHeader</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<DocumentHeader> getDocHeaderIfPresent()
    {
        return Option.of(to_DocHeader);
    }

    /**
     * Overwrites the associated <b>DocumentHeader</b> entity for the loaded navigation property <b>_DocHeader</b>.
     * 
     * @param value
     *            New <b>DocumentHeader</b> entity.
     */
    public void setDocHeader( final DocumentHeader value )
    {
        to_DocHeader = value;
    }

    /**
     * Helper class to allow for fluent creation of BPItemBusLock instances.
     * 
     */
    public final static class BPItemBusLockBuilder
    {

        private BPItemLogical to_BPItem;
        private DocumentHeader to_DocHeader;

        private BPItemBusLock.BPItemBusLockBuilder to_BPItem( final BPItemLogical value )
        {
            to_BPItem = value;
            return this;
        }

        /**
         * Navigation property <b>_BPItem</b> for <b>BPItemBusLock</b> to single <b>BPItemLogical</b>.
         * 
         * @param value
         *            The BPItemLogical to build this BPItemBusLock with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BPItemBusLock.BPItemBusLockBuilder bpItem( final BPItemLogical value )
        {
            return to_BPItem(value);
        }

        private BPItemBusLock.BPItemBusLockBuilder to_DocHeader( final DocumentHeader value )
        {
            to_DocHeader = value;
            return this;
        }

        /**
         * Navigation property <b>_DocHeader</b> for <b>BPItemBusLock</b> to single <b>DocumentHeader</b>.
         * 
         * @param value
         *            The DocumentHeader to build this BPItemBusLock with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BPItemBusLock.BPItemBusLockBuilder docHeader( final DocumentHeader value )
        {
            return to_DocHeader(value);
        }

    }

}
