/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingDocumentManageService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Business Partner Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BPItemLogicalType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BPItemLogical extends VdmEntity<BPItemLogical> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_cadocumentmanage.v0001.BPItemLogicalType";
    /**
     * Selector for all available fields of BPItemLogical.
     * 
     */
    public final static SimpleProperty<BPItemLogical> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @return Number of a FI-CA Document
     */
    @Nullable
    @ElementName( "CADocumentNumber" )
    private java.lang.String cADocumentNumber;
    public final static SimpleProperty.String<BPItemLogical> CA_DOCUMENT_NUMBER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CADocumentNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CARepetitionItemNumber</b>
     * </p>
     * 
     * @return Repetition Item in FI-CA Document
     */
    @Nullable
    @ElementName( "CARepetitionItemNumber" )
    private java.lang.String cARepetitionItemNumber;
    public final static SimpleProperty.String<BPItemLogical> CA_REPETITION_ITEM_NUMBER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CARepetitionItemNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CABPItemNumber</b>
     * </p>
     * 
     * @return Item Number in FI-CA Document
     */
    @Nullable
    @ElementName( "CABPItemNumber" )
    private java.lang.String cABPItemNumber;
    public final static SimpleProperty.String<BPItemLogical> CABP_ITEM_NUMBER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CABPItemNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CASubItemNumber</b>
     * </p>
     * 
     * @return Subitem for a Partial Clearing in Document
     */
    @Nullable
    @ElementName( "CASubItemNumber" )
    private java.lang.String cASubItemNumber;
    public final static SimpleProperty.String<BPItemLogical> CA_SUB_ITEM_NUMBER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CASubItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>CAConcatenatedDocumentNumber</b>
     * </p>
     * 
     * @return The cAConcatenatedDocumentNumber contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAConcatenatedDocumentNumber" )
    private java.lang.String cAConcatenatedDocumentNumber;
    public final static SimpleProperty.String<BPItemLogical> CA_CONCATENATED_DOCUMENT_NUMBER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAConcatenatedDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<BPItemLogical> COMPANY_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     * 
     * @return Business Area
     */
    @Nullable
    @ElementName( "BusinessArea" )
    private java.lang.String businessArea;
    public final static SimpleProperty.String<BPItemLogical> BUSINESS_AREA =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     * 
     * @return Business Place
     */
    @Nullable
    @ElementName( "BusinessPlace" )
    private java.lang.String businessPlace;
    public final static SimpleProperty.String<BPItemLogical> BUSINESS_PLACE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "BusinessPlace");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     * 
     * @return Segment for Segmental Reporting
     */
    @Nullable
    @ElementName( "Segment" )
    private java.lang.String segment;
    public final static SimpleProperty.String<BPItemLogical> SEGMENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "Segment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     * 
     * @return Profit Center
     */
    @Nullable
    @ElementName( "ProfitCenter" )
    private java.lang.String profitCenter;
    public final static SimpleProperty.String<BPItemLogical> PROFIT_CENTER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @return Division
     */
    @Nullable
    @ElementName( "Division" )
    private java.lang.String division;
    public final static SimpleProperty.String<BPItemLogical> DIVISION =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "Division");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     * 
     * @return Personnel Number
     */
    @Nullable
    @ElementName( "PersonnelNumber" )
    private java.lang.String personnelNumber;
    public final static SimpleProperty.String<BPItemLogical> PERSONNEL_NUMBER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "PersonnelNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     * 
     * @return Company ID of Trading Partner
     */
    @Nullable
    @ElementName( "PartnerCompany" )
    private java.lang.String partnerCompany;
    public final static SimpleProperty.String<BPItemLogical> PARTNER_COMPANY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @return Business Partner Number
     */
    @Nullable
    @ElementName( "BusinessPartner" )
    private java.lang.String businessPartner;
    public final static SimpleProperty.String<BPItemLogical> BUSINESS_PARTNER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAContract</b>
     * </p>
     * 
     * @return Reference Specifications from Contract
     */
    @Nullable
    @ElementName( "CAContract" )
    private java.lang.String cAContract;
    public final static SimpleProperty.String<BPItemLogical> CA_CONTRACT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAContract");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CAProviderContractItemNumber</b>
     * </p>
     * 
     * @return Contract: Item Number
     */
    @Nullable
    @ElementName( "CAProviderContractItemNumber" )
    private java.lang.String cAProviderContractItemNumber;
    public final static SimpleProperty.String<BPItemLogical> CA_PROVIDER_CONTRACT_ITEM_NUMBER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAProviderContractItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAAdditionalContract</b>
     * </p>
     * 
     * @return Additional Reference Information
     */
    @Nullable
    @ElementName( "CAAdditionalContract" )
    private java.lang.String cAAdditionalContract;
    public final static SimpleProperty.String<BPItemLogical> CA_ADDITIONAL_CONTRACT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAAdditionalContract");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @return Contract Account
     */
    @Nullable
    @ElementName( "ContractAccount" )
    private java.lang.String contractAccount;
    public final static SimpleProperty.String<BPItemLogical> CONTRACT_ACCOUNT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "ContractAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplication</b>
     * </p>
     * 
     * @return Subapplication in Contract Accounts Receivable and Payable
     */
    @Nullable
    @ElementName( "CASubApplication" )
    private java.lang.String cASubApplication;
    public final static SimpleProperty.String<BPItemLogical> CA_SUB_APPLICATION =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CASubApplication");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AltvContractAcctForCollvBills</b>
     * </p>
     * 
     * @return Alternative Contract Account for Collective Bills
     */
    @Nullable
    @ElementName( "AltvContractAcctForCollvBills" )
    private java.lang.String altvContractAcctForCollvBills;
    public final static SimpleProperty.String<BPItemLogical> ALTV_CONTRACT_ACCT_FOR_COLLV_BILLS =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "AltvContractAcctForCollvBills");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAReconciliationAccount</b>
     * </p>
     * 
     * @return General ledger account
     */
    @Nullable
    @ElementName( "CAReconciliationAccount" )
    private java.lang.String cAReconciliationAccount;
    public final static SimpleProperty.String<BPItemLogical> CA_RECONCILIATION_ACCOUNT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAReconciliationAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAApplicationArea</b>
     * </p>
     * 
     * @return Application area
     */
    @Nullable
    @ElementName( "CAApplicationArea" )
    private java.lang.String cAApplicationArea;
    public final static SimpleProperty.String<BPItemLogical> CA_APPLICATION_AREA =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAApplicationArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAMainTransaction</b>
     * </p>
     * 
     * @return Main Transaction for Line Item
     */
    @Nullable
    @ElementName( "CAMainTransaction" )
    private java.lang.String cAMainTransaction;
    public final static SimpleProperty.String<BPItemLogical> CA_MAIN_TRANSACTION =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAMainTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CASubTransaction</b>
     * </p>
     * 
     * @return Subtransaction for Document Item
     */
    @Nullable
    @ElementName( "CASubTransaction" )
    private java.lang.String cASubTransaction;
    public final static SimpleProperty.String<BPItemLogical> CA_SUB_TRANSACTION =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CASubTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAAccountDeterminationCode</b>
     * </p>
     * 
     * @return Account Determination ID
     */
    @Nullable
    @ElementName( "CAAccountDeterminationCode" )
    private java.lang.String cAAccountDeterminationCode;
    public final static SimpleProperty.String<BPItemLogical> CA_ACCOUNT_DETERMINATION_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAAccountDeterminationCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADoubtfulOrValueAdjmtCode</b>
     * </p>
     * 
     * @return Doubtful Item Entry / Individual Value Adjustment
     */
    @Nullable
    @ElementName( "CADoubtfulOrValueAdjmtCode" )
    private java.lang.String cADoubtfulOrValueAdjmtCode;
    public final static SimpleProperty.String<BPItemLogical> CA_DOUBTFUL_OR_VALUE_ADJMT_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CADoubtfulOrValueAdjmtCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAAccountAssignmentCategory</b>
     * </p>
     * 
     * @return Account Assignment Category
     */
    @Nullable
    @ElementName( "CAAccountAssignmentCategory" )
    private java.lang.String cAAccountAssignmentCategory;
    public final static SimpleProperty.String<BPItemLogical> CA_ACCOUNT_ASSIGNMENT_CATEGORY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAAccountAssignmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CAAccountAssignment</b>
     * </p>
     * 
     * @return Acct assnmnt string for industry-specific account assngments
     */
    @Nullable
    @ElementName( "CAAccountAssignment" )
    private java.lang.String cAAccountAssignment;
    public final static SimpleProperty.String<BPItemLogical> CA_ACCOUNT_ASSIGNMENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAAccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentType</b>
     * </p>
     * 
     * @return Document Type
     */
    @Nullable
    @ElementName( "CADocumentType" )
    private java.lang.String cADocumentType;
    public final static SimpleProperty.String<BPItemLogical> CA_DOCUMENT_TYPE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CADocumentType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsDownPaymentRequest</b>
     * </p>
     * 
     * @return Item is a Down Payment/Down Payment Request
     */
    @Nullable
    @ElementName( "CAIsDownPaymentRequest" )
    private java.lang.Boolean cAIsDownPaymentRequest;
    public final static SimpleProperty.Boolean<BPItemLogical> CA_IS_DOWN_PAYMENT_REQUEST =
        new SimpleProperty.Boolean<BPItemLogical>(BPItemLogical.class, "CAIsDownPaymentRequest");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAItemIsOnlyForSettlement</b>
     * </p>
     * 
     * @return Item Can Only Be Cleared
     */
    @Nullable
    @ElementName( "CAItemIsOnlyForSettlement" )
    private java.lang.String cAItemIsOnlyForSettlement;
    public final static SimpleProperty.String<BPItemLogical> CA_ITEM_IS_ONLY_FOR_SETTLEMENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAItemIsOnlyForSettlement");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAStatisticalItemCode</b>
     * </p>
     * 
     * @return Type of Statistical Line Item
     */
    @Nullable
    @ElementName( "CAStatisticalItemCode" )
    private java.lang.String cAStatisticalItemCode;
    public final static SimpleProperty.String<BPItemLogical> CA_STATISTICAL_ITEM_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAStatisticalItemCode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CABPItemText</b>
     * </p>
     * 
     * @return Item text
     */
    @Nullable
    @ElementName( "CABPItemText" )
    private java.lang.String cABPItemText;
    public final static SimpleProperty.String<BPItemLogical> CABP_ITEM_TEXT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CABPItemText");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CANumberOfRepetitionItems</b>
     * </p>
     * 
     * @return Number of repetition items
     */
    @Nullable
    @ElementName( "CANumberOfRepetitionItems" )
    private java.lang.String cANumberOfRepetitionItems;
    public final static SimpleProperty.String<BPItemLogical> CA_NUMBER_OF_REPETITION_ITEMS =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CANumberOfRepetitionItems");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CARepetitionGroup</b>
     * </p>
     * 
     * @return Repetition group
     */
    @Nullable
    @ElementName( "CARepetitionGroup" )
    private java.lang.String cARepetitionGroup;
    public final static SimpleProperty.String<BPItemLogical> CA_REPETITION_GROUP =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CARepetitionGroup");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAStartDateOfBillingPeriod</b>
     * </p>
     * 
     * @return Lower Limit of Billing Period
     */
    @Nullable
    @ElementName( "CAStartDateOfBillingPeriod" )
    private LocalDate cAStartDateOfBillingPeriod;
    public final static SimpleProperty.Date<BPItemLogical> CA_START_DATE_OF_BILLING_PERIOD =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CAStartDateOfBillingPeriod");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAEndDateOfBillingPeriod</b>
     * </p>
     * 
     * @return Upper Limit of the Billing Period
     */
    @Nullable
    @ElementName( "CAEndDateOfBillingPeriod" )
    private LocalDate cAEndDateOfBillingPeriod;
    public final static SimpleProperty.Date<BPItemLogical> CA_END_DATE_OF_BILLING_PERIOD =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CAEndDateOfBillingPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingCodeForBPItems</b>
     * </p>
     * 
     * @return Grouping Key for Displaying Open Items
     */
    @Nullable
    @ElementName( "CAGroupingCodeForBPItems" )
    private java.lang.String cAGroupingCodeForBPItems;
    public final static SimpleProperty.String<BPItemLogical> CA_GROUPING_CODE_FOR_BP_ITEMS =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAGroupingCodeForBPItems");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAPeriodCode</b>
     * </p>
     * 
     * @return Key for Period Assignment
     */
    @Nullable
    @ElementName( "CAPeriodCode" )
    private java.lang.String cAPeriodCode;
    public final static SimpleProperty.String<BPItemLogical> CA_PERIOD_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAPeriodCode");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAChangeIsForbidden</b>
     * </p>
     * 
     * @return Printing - No Changes Possible
     */
    @Nullable
    @ElementName( "CAChangeIsForbidden" )
    private java.lang.Boolean cAChangeIsForbidden;
    public final static SimpleProperty.Boolean<BPItemLogical> CA_CHANGE_IS_FORBIDDEN =
        new SimpleProperty.Boolean<BPItemLogical>(BPItemLogical.class, "CAChangeIsForbidden");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAInterestCode</b>
     * </p>
     * 
     * @return Interest Key
     */
    @Nullable
    @ElementName( "CAInterestCode" )
    private java.lang.String cAInterestCode;
    public final static SimpleProperty.String<BPItemLogical> CA_INTEREST_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAInterestCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CARoundingItemCode</b>
     * </p>
     * 
     * @return Type of Rounding Item
     */
    @Nullable
    @ElementName( "CARoundingItemCode" )
    private java.lang.String cARoundingItemCode;
    public final static SimpleProperty.String<BPItemLogical> CA_ROUNDING_ITEM_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CARoundingItemCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CAReceivingCountry</b>
     * </p>
     * 
     * @return Destination Country/Region (for Tax Reports)
     */
    @Nullable
    @ElementName( "CAReceivingCountry" )
    private java.lang.String cAReceivingCountry;
    public final static SimpleProperty.String<BPItemLogical> CA_RECEIVING_COUNTRY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAReceivingCountry");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAInternalPostingReasonCode</b>
     * </p>
     * 
     * @return Reason for Automatic Creation of Posting
     */
    @Nullable
    @ElementName( "CAInternalPostingReasonCode" )
    private java.lang.String cAInternalPostingReasonCode;
    public final static SimpleProperty.String<BPItemLogical> CA_INTERNAL_POSTING_REASON_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAInternalPostingReasonCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAWorkflowCheckReason</b>
     * </p>
     * 
     * @return Check Reason for Workflows Acc. to Dual Control Principle
     */
    @Nullable
    @ElementName( "CAWorkflowCheckReason" )
    private java.lang.String cAWorkflowCheckReason;
    public final static SimpleProperty.String<BPItemLogical> CA_WORKFLOW_CHECK_REASON =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAWorkflowCheckReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAWorkflowCheckProcess</b>
     * </p>
     * 
     * @return Editing Process To Be Confirmed
     */
    @Nullable
    @ElementName( "CAWorkflowCheckProcess" )
    private java.lang.String cAWorkflowCheckProcess;
    public final static SimpleProperty.String<BPItemLogical> CA_WORKFLOW_CHECK_PROCESS =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAWorkflowCheckProcess");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CANegativePostingControlCode</b>
     * </p>
     * 
     * @return Control Field for Negative Posting
     */
    @Nullable
    @ElementName( "CANegativePostingControlCode" )
    private java.lang.String cANegativePostingControlCode;
    public final static SimpleProperty.String<BPItemLogical> CA_NEGATIVE_POSTING_CONTROL_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CANegativePostingControlCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAPartnerSettlementStatus</b>
     * </p>
     * 
     * @return Status of Partner Settlement Using Billable Items
     */
    @Nullable
    @ElementName( "CAPartnerSettlementStatus" )
    private java.lang.String cAPartnerSettlementStatus;
    public final static SimpleProperty.String<BPItemLogical> CA_PARTNER_SETTLEMENT_STATUS =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAPartnerSettlementStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAIsPartOfJointLiability</b>
     * </p>
     * 
     * @return Item Is Part of a Collaborative Liability
     */
    @Nullable
    @ElementName( "CAIsPartOfJointLiability" )
    private java.lang.String cAIsPartOfJointLiability;
    public final static SimpleProperty.String<BPItemLogical> CA_IS_PART_OF_JOINT_LIABILITY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAIsPartOfJointLiability");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASubstituteDocumentNumber</b>
     * </p>
     * 
     * @return Number of the Substitute FI-CA Document
     */
    @Nullable
    @ElementName( "CASubstituteDocumentNumber" )
    private java.lang.String cASubstituteDocumentNumber;
    public final static SimpleProperty.String<BPItemLogical> CA_SUBSTITUTE_DOCUMENT_NUMBER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CASubstituteDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASubstituteDocumentCategory</b>
     * </p>
     * 
     * @return Category of substitute document in FI-CA
     */
    @Nullable
    @ElementName( "CASubstituteDocumentCategory" )
    private java.lang.String cASubstituteDocumentCategory;
    public final static SimpleProperty.String<BPItemLogical> CA_SUBSTITUTE_DOCUMENT_CATEGORY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CASubstituteDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAStatisticalCodeOfOriginItem</b>
     * </p>
     * 
     * @return Statistical Key of the Initiating Item
     */
    @Nullable
    @ElementName( "CAStatisticalCodeOfOriginItem" )
    private java.lang.String cAStatisticalCodeOfOriginItem;
    public final static SimpleProperty.String<BPItemLogical> CA_STATISTICAL_CODE_OF_ORIGIN_ITEM =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAStatisticalCodeOfOriginItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumberOfOriginItem</b>
     * </p>
     * 
     * @return Number of Triggering Document
     */
    @Nullable
    @ElementName( "CADocumentNumberOfOriginItem" )
    private java.lang.String cADocumentNumberOfOriginItem;
    public final static SimpleProperty.String<BPItemLogical> CA_DOCUMENT_NUMBER_OF_ORIGIN_ITEM =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CADocumentNumberOfOriginItem");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CAReferenceDocument</b>
     * </p>
     * 
     * @return Reference Document Number
     */
    @Nullable
    @ElementName( "CAReferenceDocument" )
    private java.lang.String cAReferenceDocument;
    public final static SimpleProperty.String<BPItemLogical> CA_REFERENCE_DOCUMENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAReferenceDocument");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     * 
     * @return Journal Entry Date
     */
    @Nullable
    @ElementName( "DocumentDate" )
    private LocalDate documentDate;
    public final static SimpleProperty.Date<BPItemLogical> DOCUMENT_DATE =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "DocumentDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDate</b>
     * </p>
     * 
     * @return Posting Date in the Document
     */
    @Nullable
    @ElementName( "CAPostingDate" )
    private LocalDate cAPostingDate;
    public final static SimpleProperty.Date<BPItemLogical> CA_POSTING_DATE =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CAPostingDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CANetDueDate</b>
     * </p>
     * 
     * @return Due date for net payment
     */
    @Nullable
    @ElementName( "CANetDueDate" )
    private LocalDate cANetDueDate;
    public final static SimpleProperty.Date<BPItemLogical> CA_NET_DUE_DATE =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CANetDueDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADeferralDate</b>
     * </p>
     * 
     * @return Deferral to
     */
    @Nullable
    @ElementName( "CADeferralDate" )
    private LocalDate cADeferralDate;
    public final static SimpleProperty.Date<BPItemLogical> CA_DEFERRAL_DATE =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CADeferralDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @return Transaction Currency
     */
    @Nullable
    @ElementName( "TransactionCurrency" )
    private java.lang.String transactionCurrency;
    public final static SimpleProperty.String<BPItemLogical> TRANSACTION_CURRENCY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     * 
     * @return Company Code Currency
     */
    @Nullable
    @ElementName( "CompanyCodeCurrency" )
    private java.lang.String companyCodeCurrency;
    public final static SimpleProperty.String<BPItemLogical> COMPANY_CODE_CURRENCY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency1</b>
     * </p>
     * 
     * @return Additional Currency 1
     */
    @Nullable
    @ElementName( "AdditionalCurrency1" )
    private java.lang.String additionalCurrency1;
    public final static SimpleProperty.String<BPItemLogical> ADDITIONAL_CURRENCY1 =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "AdditionalCurrency1");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency2</b>
     * </p>
     * 
     * @return Additional Currency 2
     */
    @Nullable
    @ElementName( "AdditionalCurrency2" )
    private java.lang.String additionalCurrency2;
    public final static SimpleProperty.String<BPItemLogical> ADDITIONAL_CURRENCY2 =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "AdditionalCurrency2");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>CAExchangeRate</b>
     * </p>
     * 
     * @return Absolute Exchange Rate
     */
    @Nullable
    @ElementName( "CAExchangeRate" )
    @DecimalDescriptor( precision = 9, scale = 5 )
    private BigDecimal cAExchangeRate;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_EXCHANGE_RATE =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CAExchangeRate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchRateIsIndirectQuotation</b>
     * </p>
     * 
     * @return Exchange Rate Is Indirect Quotation
     */
    @Nullable
    @ElementName( "ExchRateIsIndirectQuotation" )
    private java.lang.Boolean exchRateIsIndirectQuotation;
    public final static SimpleProperty.Boolean<BPItemLogical> EXCH_RATE_IS_INDIRECT_QUOTATION =
        new SimpleProperty.Boolean<BPItemLogical>(BPItemLogical.class, "ExchRateIsIndirectQuotation");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInLocalCurrency</b>
     * </p>
     * 
     * @return The cAAmountInLocalCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInLocalCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInLocalCurrency;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_AMOUNT_IN_LOCAL_CURRENCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CAAmountInLocalCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @return The cAAmountInTransactionCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInTransactionCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInTransactionCurrency;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_AMOUNT_IN_TRANSACTION_CURRENCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CAAmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInSecondCurrency</b>
     * </p>
     * 
     * @return The cAAmountInSecondCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInSecondCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInSecondCurrency;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_AMOUNT_IN_SECOND_CURRENCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CAAmountInSecondCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInThirdCurrency</b>
     * </p>
     * 
     * @return The cAAmountInThirdCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInThirdCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInThirdCurrency;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_AMOUNT_IN_THIRD_CURRENCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CAAmountInThirdCurrency");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscountDueDate</b>
     * </p>
     * 
     * @return Due Date for Cash Discount
     */
    @Nullable
    @ElementName( "CACashDiscountDueDate" )
    private LocalDate cACashDiscountDueDate;
    public final static SimpleProperty.Date<BPItemLogical> CA_CASH_DISCOUNT_DUE_DATE =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CACashDiscountDueDate");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscountRate</b>
     * </p>
     * 
     * @return Cash Discount Percentage Rate
     */
    @Nullable
    @ElementName( "CACashDiscountRate" )
    @DecimalDescriptor( precision = 5, scale = 3 )
    private BigDecimal cACashDiscountRate;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_CASH_DISCOUNT_RATE =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CACashDiscountRate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAEligibleAmountForCshDiscount</b>
     * </p>
     * 
     * @return The cAEligibleAmountForCshDiscount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAEligibleAmountForCshDiscount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAEligibleAmountForCshDiscount;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_ELIGIBLE_AMOUNT_FOR_CSH_DISCOUNT =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CAEligibleAmountForCshDiscount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscAmountInClearingCrcy</b>
     * </p>
     * 
     * @return The cACashDiscAmountInClearingCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CACashDiscAmountInClearingCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cACashDiscAmountInClearingCrcy;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_CASH_DISC_AMOUNT_IN_CLEARING_CRCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CACashDiscAmountInClearingCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     * 
     * @return Tax on Sales/Purchases Code
     */
    @Nullable
    @ElementName( "TaxCode" )
    private java.lang.String taxCode;
    public final static SimpleProperty.String<BPItemLogical> TAX_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CASupplementaryTaxCode</b>
     * </p>
     * 
     * @return Supplementary Tax
     */
    @Nullable
    @ElementName( "CASupplementaryTaxCode" )
    private java.lang.String cASupplementaryTaxCode;
    public final static SimpleProperty.String<BPItemLogical> CA_SUPPLEMENTARY_TAX_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CASupplementaryTaxCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxAmountInLocalCurrency</b>
     * </p>
     * 
     * @return The cATaxAmountInLocalCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxAmountInLocalCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxAmountInLocalCurrency;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_TAX_AMOUNT_IN_LOCAL_CURRENCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CATaxAmountInLocalCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxAmountInTransCurrency</b>
     * </p>
     * 
     * @return The cATaxAmountInTransCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxAmountInTransCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxAmountInTransCurrency;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_TAX_AMOUNT_IN_TRANS_CURRENCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CATaxAmountInTransCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxAmountInSecondCurrency</b>
     * </p>
     * 
     * @return The cATaxAmountInSecondCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxAmountInSecondCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxAmountInSecondCurrency;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_TAX_AMOUNT_IN_SECOND_CURRENCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CATaxAmountInSecondCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxAmountInThirdCurrency</b>
     * </p>
     * 
     * @return The cATaxAmountInThirdCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxAmountInThirdCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxAmountInThirdCurrency;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_TAX_AMOUNT_IN_THIRD_CURRENCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CATaxAmountInThirdCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CADownPaymentTaxAccount</b>
     * </p>
     * 
     * @return Account for Posting Sales / Purchase Tax for Down Payments
     */
    @Nullable
    @ElementName( "CADownPaymentTaxAccount" )
    private java.lang.String cADownPaymentTaxAccount;
    public final static SimpleProperty.String<BPItemLogical> CA_DOWN_PAYMENT_TAX_ACCOUNT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CADownPaymentTaxAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CADownPaymentOffsetTaxAccount</b>
     * </p>
     * 
     * @return Account for Offsetting Tax Posting in Down Payments
     */
    @Nullable
    @ElementName( "CADownPaymentOffsetTaxAccount" )
    private java.lang.String cADownPaymentOffsetTaxAccount;
    public final static SimpleProperty.String<BPItemLogical> CA_DOWN_PAYMENT_OFFSET_TAX_ACCOUNT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CADownPaymentOffsetTaxAccount");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     * 
     * @return Tax Jurisdiction
     */
    @Nullable
    @ElementName( "TaxJurisdiction" )
    private java.lang.String taxJurisdiction;
    public final static SimpleProperty.String<BPItemLogical> TAX_JURISDICTION =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "TaxJurisdiction");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CATaxDate</b>
     * </p>
     * 
     * @return Decisive Date for Calculating Taxes
     */
    @Nullable
    @ElementName( "CATaxDate" )
    private LocalDate cATaxDate;
    public final static SimpleProperty.Date<BPItemLogical> CA_TAX_DATE =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CATaxDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     * 
     * @return Withholding Tax Code
     */
    @Nullable
    @ElementName( "WithholdingTaxCode" )
    private java.lang.String withholdingTaxCode;
    public final static SimpleProperty.String<BPItemLogical> WITHHOLDING_TAX_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "WithholdingTaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAWithholdingTaxSupplement</b>
     * </p>
     * 
     * @return Withholding Tax Supplement
     */
    @Nullable
    @ElementName( "CAWithholdingTaxSupplement" )
    private java.lang.String cAWithholdingTaxSupplement;
    public final static SimpleProperty.String<BPItemLogical> CA_WITHHOLDING_TAX_SUPPLEMENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAWithholdingTaxSupplement");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAWithholdingTaxCategory</b>
     * </p>
     * 
     * @return Line Item Category From Withholding Tax View
     */
    @Nullable
    @ElementName( "CAWithholdingTaxCategory" )
    private java.lang.String cAWithholdingTaxCategory;
    public final static SimpleProperty.String<BPItemLogical> CA_WITHHOLDING_TAX_CATEGORY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAWithholdingTaxCategory");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CABaseAmountForWithholdingTax</b>
     * </p>
     * 
     * @return The cABaseAmountForWithholdingTax contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CABaseAmountForWithholdingTax" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cABaseAmountForWithholdingTax;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_BASE_AMOUNT_FOR_WITHHOLDING_TAX =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CABaseAmountForWithholdingTax");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAWithholdingTaxAmount</b>
     * </p>
     * 
     * @return The cAWithholdingTaxAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAWithholdingTaxAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAWithholdingTaxAmount;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_WITHHOLDING_TAX_AMOUNT =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CAWithholdingTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>CAWithholdingTaxPercentage</b>
     * </p>
     * 
     * @return Withholding Tax Percentage
     */
    @Nullable
    @ElementName( "CAWithholdingTaxPercentage" )
    private java.lang.String cAWithholdingTaxPercentage;
    public final static SimpleProperty.String<BPItemLogical> CA_WITHHOLDING_TAX_PERCENTAGE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAWithholdingTaxPercentage");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCertificate</b>
     * </p>
     * 
     * @return Withholding Tax Certificate
     */
    @Nullable
    @ElementName( "WithholdingTaxCertificate" )
    private java.lang.String withholdingTaxCertificate;
    public final static SimpleProperty.String<BPItemLogical> WITHHOLDING_TAX_CERTIFICATE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "WithholdingTaxCertificate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAOtherTaxCode</b>
     * </p>
     * 
     * @return Tax Code for Other Taxes
     */
    @Nullable
    @ElementName( "CAOtherTaxCode" )
    private java.lang.String cAOtherTaxCode;
    public final static SimpleProperty.String<BPItemLogical> CA_OTHER_TAX_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAOtherTaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingCodeForTaxItems</b>
     * </p>
     * 
     * @return Grouping Key for Tax Items
     */
    @Nullable
    @ElementName( "CAGroupingCodeForTaxItems" )
    private java.lang.String cAGroupingCodeForTaxItems;
    public final static SimpleProperty.String<BPItemLogical> CA_GROUPING_CODE_FOR_TAX_ITEMS =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAGroupingCodeForTaxItems");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxPortionInLocalCurrency</b>
     * </p>
     * 
     * @return The cATaxPortionInLocalCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxPortionInLocalCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxPortionInLocalCurrency;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_TAX_PORTION_IN_LOCAL_CURRENCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CATaxPortionInLocalCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxPortionInTransCurrency</b>
     * </p>
     * 
     * @return The cATaxPortionInTransCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxPortionInTransCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxPortionInTransCurrency;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_TAX_PORTION_IN_TRANS_CURRENCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CATaxPortionInTransCurrency");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CATaxIsCalculatedExternally</b>
     * </p>
     * 
     * @return Tax on Sales/Purchases Was Calculated by Document
     */
    @Nullable
    @ElementName( "CATaxIsCalculatedExternally" )
    private java.lang.Boolean cATaxIsCalculatedExternally;
    public final static SimpleProperty.Boolean<BPItemLogical> CA_TAX_IS_CALCULATED_EXTERNALLY =
        new SimpleProperty.Boolean<BPItemLogical>(BPItemLogical.class, "CATaxIsCalculatedExternally");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentMethod</b>
     * </p>
     * 
     * @return Payment Method
     */
    @Nullable
    @ElementName( "CAPaymentMethod" )
    private java.lang.String cAPaymentMethod;
    public final static SimpleProperty.String<BPItemLogical> CA_PAYMENT_METHOD =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAPaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentCompanyCode</b>
     * </p>
     * 
     * @return Company Code for Automatic Payment Transactions
     */
    @Nullable
    @ElementName( "CAPaymentCompanyCode" )
    private java.lang.String cAPaymentCompanyCode;
    public final static SimpleProperty.String<BPItemLogical> CA_PAYMENT_COMPANY_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAPaymentCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingForPayment</b>
     * </p>
     * 
     * @return Grouping field for automatic payments
     */
    @Nullable
    @ElementName( "CAGroupingForPayment" )
    private java.lang.String cAGroupingForPayment;
    public final static SimpleProperty.String<BPItemLogical> CA_GROUPING_FOR_PAYMENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAGroupingForPayment");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentSpecificationCategory</b>
     * </p>
     * 
     * @return Category of Payment Specification
     */
    @Nullable
    @ElementName( "CAPaymentSpecificationCategory" )
    private java.lang.String cAPaymentSpecificationCategory;
    public final static SimpleProperty.String<BPItemLogical> CA_PAYMENT_SPECIFICATION_CATEGORY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAPaymentSpecificationCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingStatus</b>
     * </p>
     * 
     * @return Clearing status
     */
    @Nullable
    @ElementName( "CAClearingStatus" )
    private java.lang.String cAClearingStatus;
    public final static SimpleProperty.String<BPItemLogical> CA_CLEARING_STATUS =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAClearingStatus");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingDate</b>
     * </p>
     * 
     * @return Clearing Date
     */
    @Nullable
    @ElementName( "CAClearingDate" )
    private LocalDate cAClearingDate;
    public final static SimpleProperty.Date<BPItemLogical> CA_CLEARING_DATE =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CAClearingDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingDocumentNumber</b>
     * </p>
     * 
     * @return Clearing Document or Printed Document
     */
    @Nullable
    @ElementName( "CAClearingDocumentNumber" )
    private java.lang.String cAClearingDocumentNumber;
    public final static SimpleProperty.String<BPItemLogical> CA_CLEARING_DOCUMENT_NUMBER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAClearingDocumentNumber");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDateOfClearingDoc</b>
     * </p>
     * 
     * @return Clearing Document Posting Date
     */
    @Nullable
    @ElementName( "CAPostingDateOfClearingDoc" )
    private LocalDate cAPostingDateOfClearingDoc;
    public final static SimpleProperty.Date<BPItemLogical> CA_POSTING_DATE_OF_CLEARING_DOC =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CAPostingDateOfClearingDoc");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingReason</b>
     * </p>
     * 
     * @return Clearing Reason
     */
    @Nullable
    @ElementName( "CAClearingReason" )
    private java.lang.String cAClearingReason;
    public final static SimpleProperty.String<BPItemLogical> CA_CLEARING_REASON =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAClearingReason");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingCurrency</b>
     * </p>
     * 
     * @return Clearing Currency
     */
    @Nullable
    @ElementName( "CAClearingCurrency" )
    private java.lang.String cAClearingCurrency;
    public final static SimpleProperty.String<BPItemLogical> CA_CLEARING_CURRENCY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAClearingCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingAmountInClearingCrcy</b>
     * </p>
     * 
     * @return The cAClearingAmountInClearingCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAClearingAmountInClearingCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAClearingAmountInClearingCrcy;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_CLEARING_AMOUNT_IN_CLEARING_CRCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CAClearingAmountInClearingCrcy");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxAmountInClearingCrcy</b>
     * </p>
     * 
     * @return The cATaxAmountInClearingCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxAmountInClearingCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxAmountInClearingCrcy;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CA_TAX_AMOUNT_IN_CLEARING_CRCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CATaxAmountInClearingCrcy");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAValueDateForClearing</b>
     * </p>
     * 
     * @return Clearing Value Date
     */
    @Nullable
    @ElementName( "CAValueDateForClearing" )
    private LocalDate cAValueDateForClearing;
    public final static SimpleProperty.Date<BPItemLogical> CA_VALUE_DATE_FOR_CLEARING =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CAValueDateForClearing");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingRestrictionCode</b>
     * </p>
     * 
     * @return Clearing restriction
     */
    @Nullable
    @ElementName( "CAClearingRestrictionCode" )
    private java.lang.String cAClearingRestrictionCode;
    public final static SimpleProperty.String<BPItemLogical> CA_CLEARING_RESTRICTION_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAClearingRestrictionCode");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingPostingIsReset</b>
     * </p>
     * 
     * @return Clearing posting reversed
     */
    @Nullable
    @ElementName( "CAClearingPostingIsReset" )
    private java.lang.Boolean cAClearingPostingIsReset;
    public final static SimpleProperty.Boolean<BPItemLogical> CA_CLEARING_POSTING_IS_RESET =
        new SimpleProperty.Boolean<BPItemLogical>(BPItemLogical.class, "CAClearingPostingIsReset");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAItemIsWithdrawn</b>
     * </p>
     * 
     * @return Item Canceled
     */
    @Nullable
    @ElementName( "CAItemIsWithdrawn" )
    private java.lang.Boolean cAItemIsWithdrawn;
    public final static SimpleProperty.Boolean<BPItemLogical> CA_ITEM_IS_WITHDRAWN =
        new SimpleProperty.Boolean<BPItemLogical>(BPItemLogical.class, "CAItemIsWithdrawn");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAItemIsExcludedFromDunning</b>
     * </p>
     * 
     * @return Exclude Item from Dunning Run
     */
    @Nullable
    @ElementName( "CAItemIsExcludedFromDunning" )
    private java.lang.Boolean cAItemIsExcludedFromDunning;
    public final static SimpleProperty.Boolean<BPItemLogical> CA_ITEM_IS_EXCLUDED_FROM_DUNNING =
        new SimpleProperty.Boolean<BPItemLogical>(BPItemLogical.class, "CAItemIsExcludedFromDunning");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADunningProcedure</b>
     * </p>
     * 
     * @return Dunning Procedure
     */
    @Nullable
    @ElementName( "CADunningProcedure" )
    private java.lang.String cADunningProcedure;
    public final static SimpleProperty.String<BPItemLogical> CA_DUNNING_PROCEDURE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CADunningProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CAGrpgCodeForTransfToCollAgcy</b>
     * </p>
     * 
     * @return Collection Item
     */
    @Nullable
    @ElementName( "CAGrpgCodeForTransfToCollAgcy" )
    private java.lang.String cAGrpgCodeForTransfToCollAgcy;
    public final static SimpleProperty.String<BPItemLogical> CA_GRPG_CODE_FOR_TRANSF_TO_COLL_AGCY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAGrpgCodeForTransfToCollAgcy");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsIncludedInCollectionCase</b>
     * </p>
     * 
     * @return Item Is Included in Collection Case
     */
    @Nullable
    @ElementName( "CAIsIncludedInCollectionCase" )
    private java.lang.Boolean cAIsIncludedInCollectionCase;
    public final static SimpleProperty.Boolean<BPItemLogical> CA_IS_INCLUDED_IN_COLLECTION_CASE =
        new SimpleProperty.Boolean<BPItemLogical>(BPItemLogical.class, "CAIsIncludedInCollectionCase");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CashPlanningGroup</b>
     * </p>
     * 
     * @return Planning Group
     */
    @Nullable
    @ElementName( "CashPlanningGroup" )
    private java.lang.String cashPlanningGroup;
    public final static SimpleProperty.String<BPItemLogical> CASH_PLANNING_GROUP =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CashPlanningGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningLevel</b>
     * </p>
     * 
     * @return Planning Level
     */
    @Nullable
    @ElementName( "PlanningLevel" )
    private java.lang.String planningLevel;
    public final static SimpleProperty.String<BPItemLogical> PLANNING_LEVEL =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "PlanningLevel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAAdditionalDaysForCashMgmt</b>
     * </p>
     * 
     * @return Additional Days for Cash Management
     */
    @Nullable
    @ElementName( "CAAdditionalDaysForCashMgmt" )
    private java.lang.String cAAdditionalDaysForCashMgmt;
    public final static SimpleProperty.String<BPItemLogical> CA_ADDITIONAL_DAYS_FOR_CASH_MGMT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAAdditionalDaysForCashMgmt");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedAmtInTransactionCrcy</b>
     * </p>
     * 
     * @return The plannedAmtInTransactionCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "PlannedAmtInTransactionCrcy" )
    @DecimalDescriptor( precision = 23, scale = 0 )
    private BigDecimal plannedAmtInTransactionCrcy;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> PLANNED_AMT_IN_TRANSACTION_CRCY =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "PlannedAmtInTransactionCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAAltvBPForPayment</b>
     * </p>
     * 
     * @return Alternative Business Partner for Payments
     */
    @Nullable
    @ElementName( "CAAltvBPForPayment" )
    private java.lang.String cAAltvBPForPayment;
    public final static SimpleProperty.String<BPItemLogical> CA_ALTV_BP_FOR_PAYMENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAAltvBPForPayment");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CABankOfAltvBPForPayment</b>
     * </p>
     * 
     * @return Bank Details ID of Payee
     */
    @Nullable
    @ElementName( "CABankOfAltvBPForPayment" )
    private java.lang.String cABankOfAltvBPForPayment;
    public final static SimpleProperty.String<BPItemLogical> CA_BANK_OF_ALTV_BP_FOR_PAYMENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CABankOfAltvBPForPayment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAAddressOfAltvBPForPayment</b>
     * </p>
     * 
     * @return Address Number
     */
    @Nullable
    @ElementName( "CAAddressOfAltvBPForPayment" )
    private java.lang.String cAAddressOfAltvBPForPayment;
    public final static SimpleProperty.String<BPItemLogical> CA_ADDRESS_OF_ALTV_BP_FOR_PAYMENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAAddressOfAltvBPForPayment");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CACardOfAltvBPForPayment</b>
     * </p>
     * 
     * @return Alternative Payment Card ID in Document
     */
    @Nullable
    @ElementName( "CACardOfAltvBPForPayment" )
    private java.lang.String cACardOfAltvBPForPayment;
    public final static SimpleProperty.String<BPItemLogical> CA_CARD_OF_ALTV_BP_FOR_PAYMENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CACardOfAltvBPForPayment");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CAGLPostingCurrency</b>
     * </p>
     * 
     * @return Update Currency for General Ledger Transaction Figures
     */
    @Nullable
    @ElementName( "CAGLPostingCurrency" )
    private java.lang.String cAGLPostingCurrency;
    public final static SimpleProperty.String<BPItemLogical> CAGL_POSTING_CURRENCY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAGLPostingCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAGLPostingAmount</b>
     * </p>
     * 
     * @return The cAGLPostingAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAGLPostingAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAGLPostingAmount;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CAGL_POSTING_AMOUNT =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CAGLPostingAmount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAGLPostingTaxAmount</b>
     * </p>
     * 
     * @return The cAGLPostingTaxAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAGLPostingTaxAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAGLPostingTaxAmount;
    public final static SimpleProperty.NumericDecimal<BPItemLogical> CAGL_POSTING_TAX_AMOUNT =
        new SimpleProperty.NumericDecimal<BPItemLogical>(BPItemLogical.class, "CAGLPostingTaxAmount");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsSeparateLineItemInGL</b>
     * </p>
     * 
     * @return Create Line Item in General Ledger
     */
    @Nullable
    @ElementName( "CAIsSeparateLineItemInGL" )
    private java.lang.Boolean cAIsSeparateLineItemInGL;
    public final static SimpleProperty.Boolean<BPItemLogical> CA_IS_SEPARATE_LINE_ITEM_IN_GL =
        new SimpleProperty.Boolean<BPItemLogical>(BPItemLogical.class, "CAIsSeparateLineItemInGL");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsCashFlowItem</b>
     * </p>
     * 
     * @return Document Contains Assignments from Cash Flows
     */
    @Nullable
    @ElementName( "CAIsCashFlowItem" )
    private java.lang.Boolean cAIsCashFlowItem;
    public final static SimpleProperty.Boolean<BPItemLogical> CA_IS_CASH_FLOW_ITEM =
        new SimpleProperty.Boolean<BPItemLogical>(BPItemLogical.class, "CAIsCashFlowItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CACashFlowAccount</b>
     * </p>
     * 
     * @return Originating Account in Cash Flow Anlaysis
     */
    @Nullable
    @ElementName( "CACashFlowAccount" )
    private java.lang.String cACashFlowAccount;
    public final static SimpleProperty.String<BPItemLogical> CA_CASH_FLOW_ACCOUNT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CACashFlowAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CACashFlowCompanyCode</b>
     * </p>
     * 
     * @return Partner Company Code for Cash Flow Analysis
     */
    @Nullable
    @ElementName( "CACashFlowCompanyCode" )
    private java.lang.String cACashFlowCompanyCode;
    public final static SimpleProperty.String<BPItemLogical> CA_CASH_FLOW_COMPANY_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CACashFlowCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentPreNotificationCode</b>
     * </p>
     * 
     * @return Item Included in a Payment Order
     */
    @Nullable
    @ElementName( "CAPaymentPreNotificationCode" )
    private java.lang.String cAPaymentPreNotificationCode;
    public final static SimpleProperty.String<BPItemLogical> CA_PAYMENT_PRE_NOTIFICATION_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAPaymentPreNotificationCode");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CASEPAPreNotificationNumber</b>
     * </p>
     * 
     * @return SEPA: Number of Direct Debit Pre-Notification
     */
    @Nullable
    @ElementName( "CASEPAPreNotificationNumber" )
    private java.lang.String cASEPAPreNotificationNumber;
    public final static SimpleProperty.String<BPItemLogical> CASEPA_PRE_NOTIFICATION_NUMBER =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CASEPAPreNotificationNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CASEPAPreNotifOriginCode</b>
     * </p>
     * 
     * @return SEPA: Origin of Direct Debit Pre-Notification
     */
    @Nullable
    @ElementName( "CASEPAPreNotifOriginCode" )
    private java.lang.String cASEPAPreNotifOriginCode;
    public final static SimpleProperty.String<BPItemLogical> CASEPA_PRE_NOTIF_ORIGIN_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CASEPAPreNotifOriginCode");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASEPAPreNotifExecutionDate</b>
     * </p>
     * 
     * @return SEPA: Date of Execution of Direct Debit Pre-Notifcation
     */
    @Nullable
    @ElementName( "CASEPAPreNotifExecutionDate" )
    private LocalDate cASEPAPreNotifExecutionDate;
    public final static SimpleProperty.Date<BPItemLogical> CASEPA_PRE_NOTIF_EXECUTION_DATE =
        new SimpleProperty.Date<BPItemLogical>(BPItemLogical.class, "CASEPAPreNotifExecutionDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASEPAPreNotificationRqmtCode</b>
     * </p>
     * 
     * @return SEPA: Requirement for a Pre-Notification
     */
    @Nullable
    @ElementName( "CASEPAPreNotificationRqmtCode" )
    private java.lang.String cASEPAPreNotificationRqmtCode;
    public final static SimpleProperty.String<BPItemLogical> CASEPA_PRE_NOTIFICATION_RQMT_CODE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CASEPAPreNotificationRqmtCode");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CARevenueDistrFinalRecipient</b>
     * </p>
     * 
     * @return Contract Account of Final Recipient
     */
    @Nullable
    @ElementName( "CARevenueDistrFinalRecipient" )
    private java.lang.String cARevenueDistrFinalRecipient;
    public final static SimpleProperty.String<BPItemLogical> CA_REVENUE_DISTR_FINAL_RECIPIENT =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CARevenueDistrFinalRecipient");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CARevenueDistrCurrentStatus</b>
     * </p>
     * 
     * @return Current Distribution Status
     */
    @Nullable
    @ElementName( "CARevenueDistrCurrentStatus" )
    private java.lang.String cARevenueDistrCurrentStatus;
    public final static SimpleProperty.String<BPItemLogical> CA_REVENUE_DISTR_CURRENT_STATUS =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CARevenueDistrCurrentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CARevenueDistrLastStatus</b>
     * </p>
     * 
     * @return Last Distribution Status Reported
     */
    @Nullable
    @ElementName( "CARevenueDistrLastStatus" )
    private java.lang.String cARevenueDistrLastStatus;
    public final static SimpleProperty.String<BPItemLogical> CA_REVENUE_DISTR_LAST_STATUS =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CARevenueDistrLastStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CACurrentFactoringStatusOfRbl</b>
     * </p>
     * 
     * @return Factoring: Current Status of Receivable
     */
    @Nullable
    @ElementName( "CACurrentFactoringStatusOfRbl" )
    private java.lang.String cACurrentFactoringStatusOfRbl;
    public final static SimpleProperty.String<BPItemLogical> CA_CURRENT_FACTORING_STATUS_OF_RBL =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CACurrentFactoringStatusOfRbl");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAFactoringCheckStsForClrgInfo</b>
     * </p>
     * 
     * @return Factoring: Check Status for Clearing Information
     */
    @Nullable
    @ElementName( "CAFactoringCheckStsForClrgInfo" )
    private java.lang.String cAFactoringCheckStsForClrgInfo;
    public final static SimpleProperty.String<BPItemLogical> CA_FACTORING_CHECK_STS_FOR_CLRG_INFO =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "CAFactoringCheckStsForClrgInfo");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     * 
     * @return Controlling Area
     */
    @Nullable
    @ElementName( "ControllingArea" )
    private java.lang.String controllingArea;
    public final static SimpleProperty.String<BPItemLogical> CONTROLLING_AREA =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     * 
     * @return Chart of Accounts
     */
    @Nullable
    @ElementName( "ChartOfAccounts" )
    private java.lang.String chartOfAccounts;
    public final static SimpleProperty.String<BPItemLogical> CHART_OF_ACCOUNTS =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     * 
     * @return Country/Region Key
     */
    @Nullable
    @ElementName( "Country" )
    private java.lang.String country;
    public final static SimpleProperty.String<BPItemLogical> COUNTRY =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "Country");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxCalculationProcedure</b>
     * </p>
     * 
     * @return Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    @Nullable
    @ElementName( "TaxCalculationProcedure" )
    private java.lang.String taxCalculationProcedure;
    public final static SimpleProperty.String<BPItemLogical> TAX_CALCULATION_PROCEDURE =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "TaxCalculationProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateCAInternalID</b>
     * </p>
     * 
     * @return SEPA Mandate Identifier
     */
    @Nullable
    @ElementName( "SEPAMandateCAInternalID" )
    private java.lang.String sEPAMandateCAInternalID;
    public final static SimpleProperty.String<BPItemLogical> SEPA_MANDATE_CA_INTERNAL_ID =
        new SimpleProperty.String<BPItemLogical>(BPItemLogical.class, "SEPAMandateCAInternalID");
    /**
     * Navigation property <b>_BPItemBusLock</b> for <b>BPItemLogical</b> to multiple <b>BPItemBusLock</b>.
     * 
     */
    @ElementName( "_BPItemBusLock" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BPItemBusLock> to_BPItemBusLock;
    /**
     * Navigation property <b>_DocHeader</b> for <b>BPItemLogical</b> to single <b>DocumentHeader</b>.
     * 
     */
    @ElementName( "_DocHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DocumentHeader to_DocHeader;
    /**
     * Use with available request builders to apply the <b>_BPItemBusLock</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<BPItemLogical, BPItemBusLock> TO__B_P_ITEM_BUS_LOCK =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<BPItemLogical, BPItemBusLock>(
            BPItemLogical.class,
            "_BPItemBusLock",
            BPItemBusLock.class);
    /**
     * Use with available request builders to apply the <b>_DocHeader</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BPItemLogical, DocumentHeader> TO__DOC_HEADER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BPItemLogical, DocumentHeader>(
            BPItemLogical.class,
            "_DocHeader",
            DocumentHeader.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BPItemLogical> getType()
    {
        return BPItemLogical.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @param cADocumentNumber
     *            Number of a FI-CA Document
     */
    public void setCADocumentNumber( @Nullable final java.lang.String cADocumentNumber )
    {
        rememberChangedField("CADocumentNumber", this.cADocumentNumber);
        this.cADocumentNumber = cADocumentNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CARepetitionItemNumber</b>
     * </p>
     * 
     * @param cARepetitionItemNumber
     *            Repetition Item in FI-CA Document
     */
    public void setCARepetitionItemNumber( @Nullable final java.lang.String cARepetitionItemNumber )
    {
        rememberChangedField("CARepetitionItemNumber", this.cARepetitionItemNumber);
        this.cARepetitionItemNumber = cARepetitionItemNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CABPItemNumber</b>
     * </p>
     * 
     * @param cABPItemNumber
     *            Item Number in FI-CA Document
     */
    public void setCABPItemNumber( @Nullable final java.lang.String cABPItemNumber )
    {
        rememberChangedField("CABPItemNumber", this.cABPItemNumber);
        this.cABPItemNumber = cABPItemNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CASubItemNumber</b>
     * </p>
     * 
     * @param cASubItemNumber
     *            Subitem for a Partial Clearing in Document
     */
    public void setCASubItemNumber( @Nullable final java.lang.String cASubItemNumber )
    {
        rememberChangedField("CASubItemNumber", this.cASubItemNumber);
        this.cASubItemNumber = cASubItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>CAConcatenatedDocumentNumber</b>
     * </p>
     * 
     * @param cAConcatenatedDocumentNumber
     *            The cAConcatenatedDocumentNumber to set.
     */
    public void setCAConcatenatedDocumentNumber( @Nullable final java.lang.String cAConcatenatedDocumentNumber )
    {
        rememberChangedField("CAConcatenatedDocumentNumber", this.cAConcatenatedDocumentNumber);
        this.cAConcatenatedDocumentNumber = cAConcatenatedDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     * 
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final java.lang.String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     * 
     * @param businessPlace
     *            Business Place
     */
    public void setBusinessPlace( @Nullable final java.lang.String businessPlace )
    {
        rememberChangedField("BusinessPlace", this.businessPlace);
        this.businessPlace = businessPlace;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     * 
     * @param segment
     *            Segment for Segmental Reporting
     */
    public void setSegment( @Nullable final java.lang.String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     * 
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final java.lang.String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final java.lang.String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     * 
     * @param personnelNumber
     *            Personnel Number
     */
    public void setPersonnelNumber( @Nullable final java.lang.String personnelNumber )
    {
        rememberChangedField("PersonnelNumber", this.personnelNumber);
        this.personnelNumber = personnelNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     * 
     * @param partnerCompany
     *            Company ID of Trading Partner
     */
    public void setPartnerCompany( @Nullable final java.lang.String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final java.lang.String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAContract</b>
     * </p>
     * 
     * @param cAContract
     *            Reference Specifications from Contract
     */
    public void setCAContract( @Nullable final java.lang.String cAContract )
    {
        rememberChangedField("CAContract", this.cAContract);
        this.cAContract = cAContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CAProviderContractItemNumber</b>
     * </p>
     * 
     * @param cAProviderContractItemNumber
     *            Contract: Item Number
     */
    public void setCAProviderContractItemNumber( @Nullable final java.lang.String cAProviderContractItemNumber )
    {
        rememberChangedField("CAProviderContractItemNumber", this.cAProviderContractItemNumber);
        this.cAProviderContractItemNumber = cAProviderContractItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAAdditionalContract</b>
     * </p>
     * 
     * @param cAAdditionalContract
     *            Additional Reference Information
     */
    public void setCAAdditionalContract( @Nullable final java.lang.String cAAdditionalContract )
    {
        rememberChangedField("CAAdditionalContract", this.cAAdditionalContract);
        this.cAAdditionalContract = cAAdditionalContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @param contractAccount
     *            Contract Account
     */
    public void setContractAccount( @Nullable final java.lang.String contractAccount )
    {
        rememberChangedField("ContractAccount", this.contractAccount);
        this.contractAccount = contractAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASubApplication</b>
     * </p>
     * 
     * @param cASubApplication
     *            Subapplication in Contract Accounts Receivable and Payable
     */
    public void setCASubApplication( @Nullable final java.lang.String cASubApplication )
    {
        rememberChangedField("CASubApplication", this.cASubApplication);
        this.cASubApplication = cASubApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AltvContractAcctForCollvBills</b>
     * </p>
     * 
     * @param altvContractAcctForCollvBills
     *            Alternative Contract Account for Collective Bills
     */
    public void setAltvContractAcctForCollvBills( @Nullable final java.lang.String altvContractAcctForCollvBills )
    {
        rememberChangedField("AltvContractAcctForCollvBills", this.altvContractAcctForCollvBills);
        this.altvContractAcctForCollvBills = altvContractAcctForCollvBills;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAReconciliationAccount</b>
     * </p>
     * 
     * @param cAReconciliationAccount
     *            General ledger account
     */
    public void setCAReconciliationAccount( @Nullable final java.lang.String cAReconciliationAccount )
    {
        rememberChangedField("CAReconciliationAccount", this.cAReconciliationAccount);
        this.cAReconciliationAccount = cAReconciliationAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAApplicationArea</b>
     * </p>
     * 
     * @param cAApplicationArea
     *            Application area
     */
    public void setCAApplicationArea( @Nullable final java.lang.String cAApplicationArea )
    {
        rememberChangedField("CAApplicationArea", this.cAApplicationArea);
        this.cAApplicationArea = cAApplicationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAMainTransaction</b>
     * </p>
     * 
     * @param cAMainTransaction
     *            Main Transaction for Line Item
     */
    public void setCAMainTransaction( @Nullable final java.lang.String cAMainTransaction )
    {
        rememberChangedField("CAMainTransaction", this.cAMainTransaction);
        this.cAMainTransaction = cAMainTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CASubTransaction</b>
     * </p>
     * 
     * @param cASubTransaction
     *            Subtransaction for Document Item
     */
    public void setCASubTransaction( @Nullable final java.lang.String cASubTransaction )
    {
        rememberChangedField("CASubTransaction", this.cASubTransaction);
        this.cASubTransaction = cASubTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAAccountDeterminationCode</b>
     * </p>
     * 
     * @param cAAccountDeterminationCode
     *            Account Determination ID
     */
    public void setCAAccountDeterminationCode( @Nullable final java.lang.String cAAccountDeterminationCode )
    {
        rememberChangedField("CAAccountDeterminationCode", this.cAAccountDeterminationCode);
        this.cAAccountDeterminationCode = cAAccountDeterminationCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADoubtfulOrValueAdjmtCode</b>
     * </p>
     * 
     * @param cADoubtfulOrValueAdjmtCode
     *            Doubtful Item Entry / Individual Value Adjustment
     */
    public void setCADoubtfulOrValueAdjmtCode( @Nullable final java.lang.String cADoubtfulOrValueAdjmtCode )
    {
        rememberChangedField("CADoubtfulOrValueAdjmtCode", this.cADoubtfulOrValueAdjmtCode);
        this.cADoubtfulOrValueAdjmtCode = cADoubtfulOrValueAdjmtCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAAccountAssignmentCategory</b>
     * </p>
     * 
     * @param cAAccountAssignmentCategory
     *            Account Assignment Category
     */
    public void setCAAccountAssignmentCategory( @Nullable final java.lang.String cAAccountAssignmentCategory )
    {
        rememberChangedField("CAAccountAssignmentCategory", this.cAAccountAssignmentCategory);
        this.cAAccountAssignmentCategory = cAAccountAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CAAccountAssignment</b>
     * </p>
     * 
     * @param cAAccountAssignment
     *            Acct assnmnt string for industry-specific account assngments
     */
    public void setCAAccountAssignment( @Nullable final java.lang.String cAAccountAssignment )
    {
        rememberChangedField("CAAccountAssignment", this.cAAccountAssignment);
        this.cAAccountAssignment = cAAccountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentType</b>
     * </p>
     * 
     * @param cADocumentType
     *            Document Type
     */
    public void setCADocumentType( @Nullable final java.lang.String cADocumentType )
    {
        rememberChangedField("CADocumentType", this.cADocumentType);
        this.cADocumentType = cADocumentType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsDownPaymentRequest</b>
     * </p>
     * 
     * @param cAIsDownPaymentRequest
     *            Item is a Down Payment/Down Payment Request
     */
    public void setCAIsDownPaymentRequest( @Nullable final java.lang.Boolean cAIsDownPaymentRequest )
    {
        rememberChangedField("CAIsDownPaymentRequest", this.cAIsDownPaymentRequest);
        this.cAIsDownPaymentRequest = cAIsDownPaymentRequest;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAItemIsOnlyForSettlement</b>
     * </p>
     * 
     * @param cAItemIsOnlyForSettlement
     *            Item Can Only Be Cleared
     */
    public void setCAItemIsOnlyForSettlement( @Nullable final java.lang.String cAItemIsOnlyForSettlement )
    {
        rememberChangedField("CAItemIsOnlyForSettlement", this.cAItemIsOnlyForSettlement);
        this.cAItemIsOnlyForSettlement = cAItemIsOnlyForSettlement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAStatisticalItemCode</b>
     * </p>
     * 
     * @param cAStatisticalItemCode
     *            Type of Statistical Line Item
     */
    public void setCAStatisticalItemCode( @Nullable final java.lang.String cAStatisticalItemCode )
    {
        rememberChangedField("CAStatisticalItemCode", this.cAStatisticalItemCode);
        this.cAStatisticalItemCode = cAStatisticalItemCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CABPItemText</b>
     * </p>
     * 
     * @param cABPItemText
     *            Item text
     */
    public void setCABPItemText( @Nullable final java.lang.String cABPItemText )
    {
        rememberChangedField("CABPItemText", this.cABPItemText);
        this.cABPItemText = cABPItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CANumberOfRepetitionItems</b>
     * </p>
     * 
     * @param cANumberOfRepetitionItems
     *            Number of repetition items
     */
    public void setCANumberOfRepetitionItems( @Nullable final java.lang.String cANumberOfRepetitionItems )
    {
        rememberChangedField("CANumberOfRepetitionItems", this.cANumberOfRepetitionItems);
        this.cANumberOfRepetitionItems = cANumberOfRepetitionItems;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CARepetitionGroup</b>
     * </p>
     * 
     * @param cARepetitionGroup
     *            Repetition group
     */
    public void setCARepetitionGroup( @Nullable final java.lang.String cARepetitionGroup )
    {
        rememberChangedField("CARepetitionGroup", this.cARepetitionGroup);
        this.cARepetitionGroup = cARepetitionGroup;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAStartDateOfBillingPeriod</b>
     * </p>
     * 
     * @param cAStartDateOfBillingPeriod
     *            Lower Limit of Billing Period
     */
    public void setCAStartDateOfBillingPeriod( @Nullable final LocalDate cAStartDateOfBillingPeriod )
    {
        rememberChangedField("CAStartDateOfBillingPeriod", this.cAStartDateOfBillingPeriod);
        this.cAStartDateOfBillingPeriod = cAStartDateOfBillingPeriod;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAEndDateOfBillingPeriod</b>
     * </p>
     * 
     * @param cAEndDateOfBillingPeriod
     *            Upper Limit of the Billing Period
     */
    public void setCAEndDateOfBillingPeriod( @Nullable final LocalDate cAEndDateOfBillingPeriod )
    {
        rememberChangedField("CAEndDateOfBillingPeriod", this.cAEndDateOfBillingPeriod);
        this.cAEndDateOfBillingPeriod = cAEndDateOfBillingPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingCodeForBPItems</b>
     * </p>
     * 
     * @param cAGroupingCodeForBPItems
     *            Grouping Key for Displaying Open Items
     */
    public void setCAGroupingCodeForBPItems( @Nullable final java.lang.String cAGroupingCodeForBPItems )
    {
        rememberChangedField("CAGroupingCodeForBPItems", this.cAGroupingCodeForBPItems);
        this.cAGroupingCodeForBPItems = cAGroupingCodeForBPItems;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAPeriodCode</b>
     * </p>
     * 
     * @param cAPeriodCode
     *            Key for Period Assignment
     */
    public void setCAPeriodCode( @Nullable final java.lang.String cAPeriodCode )
    {
        rememberChangedField("CAPeriodCode", this.cAPeriodCode);
        this.cAPeriodCode = cAPeriodCode;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAChangeIsForbidden</b>
     * </p>
     * 
     * @param cAChangeIsForbidden
     *            Printing - No Changes Possible
     */
    public void setCAChangeIsForbidden( @Nullable final java.lang.Boolean cAChangeIsForbidden )
    {
        rememberChangedField("CAChangeIsForbidden", this.cAChangeIsForbidden);
        this.cAChangeIsForbidden = cAChangeIsForbidden;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAInterestCode</b>
     * </p>
     * 
     * @param cAInterestCode
     *            Interest Key
     */
    public void setCAInterestCode( @Nullable final java.lang.String cAInterestCode )
    {
        rememberChangedField("CAInterestCode", this.cAInterestCode);
        this.cAInterestCode = cAInterestCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CARoundingItemCode</b>
     * </p>
     * 
     * @param cARoundingItemCode
     *            Type of Rounding Item
     */
    public void setCARoundingItemCode( @Nullable final java.lang.String cARoundingItemCode )
    {
        rememberChangedField("CARoundingItemCode", this.cARoundingItemCode);
        this.cARoundingItemCode = cARoundingItemCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CAReceivingCountry</b>
     * </p>
     * 
     * @param cAReceivingCountry
     *            Destination Country/Region (for Tax Reports)
     */
    public void setCAReceivingCountry( @Nullable final java.lang.String cAReceivingCountry )
    {
        rememberChangedField("CAReceivingCountry", this.cAReceivingCountry);
        this.cAReceivingCountry = cAReceivingCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAInternalPostingReasonCode</b>
     * </p>
     * 
     * @param cAInternalPostingReasonCode
     *            Reason for Automatic Creation of Posting
     */
    public void setCAInternalPostingReasonCode( @Nullable final java.lang.String cAInternalPostingReasonCode )
    {
        rememberChangedField("CAInternalPostingReasonCode", this.cAInternalPostingReasonCode);
        this.cAInternalPostingReasonCode = cAInternalPostingReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAWorkflowCheckReason</b>
     * </p>
     * 
     * @param cAWorkflowCheckReason
     *            Check Reason for Workflows Acc. to Dual Control Principle
     */
    public void setCAWorkflowCheckReason( @Nullable final java.lang.String cAWorkflowCheckReason )
    {
        rememberChangedField("CAWorkflowCheckReason", this.cAWorkflowCheckReason);
        this.cAWorkflowCheckReason = cAWorkflowCheckReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAWorkflowCheckProcess</b>
     * </p>
     * 
     * @param cAWorkflowCheckProcess
     *            Editing Process To Be Confirmed
     */
    public void setCAWorkflowCheckProcess( @Nullable final java.lang.String cAWorkflowCheckProcess )
    {
        rememberChangedField("CAWorkflowCheckProcess", this.cAWorkflowCheckProcess);
        this.cAWorkflowCheckProcess = cAWorkflowCheckProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CANegativePostingControlCode</b>
     * </p>
     * 
     * @param cANegativePostingControlCode
     *            Control Field for Negative Posting
     */
    public void setCANegativePostingControlCode( @Nullable final java.lang.String cANegativePostingControlCode )
    {
        rememberChangedField("CANegativePostingControlCode", this.cANegativePostingControlCode);
        this.cANegativePostingControlCode = cANegativePostingControlCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAPartnerSettlementStatus</b>
     * </p>
     * 
     * @param cAPartnerSettlementStatus
     *            Status of Partner Settlement Using Billable Items
     */
    public void setCAPartnerSettlementStatus( @Nullable final java.lang.String cAPartnerSettlementStatus )
    {
        rememberChangedField("CAPartnerSettlementStatus", this.cAPartnerSettlementStatus);
        this.cAPartnerSettlementStatus = cAPartnerSettlementStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAIsPartOfJointLiability</b>
     * </p>
     * 
     * @param cAIsPartOfJointLiability
     *            Item Is Part of a Collaborative Liability
     */
    public void setCAIsPartOfJointLiability( @Nullable final java.lang.String cAIsPartOfJointLiability )
    {
        rememberChangedField("CAIsPartOfJointLiability", this.cAIsPartOfJointLiability);
        this.cAIsPartOfJointLiability = cAIsPartOfJointLiability;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASubstituteDocumentNumber</b>
     * </p>
     * 
     * @param cASubstituteDocumentNumber
     *            Number of the Substitute FI-CA Document
     */
    public void setCASubstituteDocumentNumber( @Nullable final java.lang.String cASubstituteDocumentNumber )
    {
        rememberChangedField("CASubstituteDocumentNumber", this.cASubstituteDocumentNumber);
        this.cASubstituteDocumentNumber = cASubstituteDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASubstituteDocumentCategory</b>
     * </p>
     * 
     * @param cASubstituteDocumentCategory
     *            Category of substitute document in FI-CA
     */
    public void setCASubstituteDocumentCategory( @Nullable final java.lang.String cASubstituteDocumentCategory )
    {
        rememberChangedField("CASubstituteDocumentCategory", this.cASubstituteDocumentCategory);
        this.cASubstituteDocumentCategory = cASubstituteDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAStatisticalCodeOfOriginItem</b>
     * </p>
     * 
     * @param cAStatisticalCodeOfOriginItem
     *            Statistical Key of the Initiating Item
     */
    public void setCAStatisticalCodeOfOriginItem( @Nullable final java.lang.String cAStatisticalCodeOfOriginItem )
    {
        rememberChangedField("CAStatisticalCodeOfOriginItem", this.cAStatisticalCodeOfOriginItem);
        this.cAStatisticalCodeOfOriginItem = cAStatisticalCodeOfOriginItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumberOfOriginItem</b>
     * </p>
     * 
     * @param cADocumentNumberOfOriginItem
     *            Number of Triggering Document
     */
    public void setCADocumentNumberOfOriginItem( @Nullable final java.lang.String cADocumentNumberOfOriginItem )
    {
        rememberChangedField("CADocumentNumberOfOriginItem", this.cADocumentNumberOfOriginItem);
        this.cADocumentNumberOfOriginItem = cADocumentNumberOfOriginItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CAReferenceDocument</b>
     * </p>
     * 
     * @param cAReferenceDocument
     *            Reference Document Number
     */
    public void setCAReferenceDocument( @Nullable final java.lang.String cAReferenceDocument )
    {
        rememberChangedField("CAReferenceDocument", this.cAReferenceDocument);
        this.cAReferenceDocument = cAReferenceDocument;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     * 
     * @param documentDate
     *            Journal Entry Date
     */
    public void setDocumentDate( @Nullable final LocalDate documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDate</b>
     * </p>
     * 
     * @param cAPostingDate
     *            Posting Date in the Document
     */
    public void setCAPostingDate( @Nullable final LocalDate cAPostingDate )
    {
        rememberChangedField("CAPostingDate", this.cAPostingDate);
        this.cAPostingDate = cAPostingDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CANetDueDate</b>
     * </p>
     * 
     * @param cANetDueDate
     *            Due date for net payment
     */
    public void setCANetDueDate( @Nullable final LocalDate cANetDueDate )
    {
        rememberChangedField("CANetDueDate", this.cANetDueDate);
        this.cANetDueDate = cANetDueDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADeferralDate</b>
     * </p>
     * 
     * @param cADeferralDate
     *            Deferral to
     */
    public void setCADeferralDate( @Nullable final LocalDate cADeferralDate )
    {
        rememberChangedField("CADeferralDate", this.cADeferralDate);
        this.cADeferralDate = cADeferralDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final java.lang.String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     * 
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final java.lang.String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency1</b>
     * </p>
     * 
     * @param additionalCurrency1
     *            Additional Currency 1
     */
    public void setAdditionalCurrency1( @Nullable final java.lang.String additionalCurrency1 )
    {
        rememberChangedField("AdditionalCurrency1", this.additionalCurrency1);
        this.additionalCurrency1 = additionalCurrency1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCurrency2</b>
     * </p>
     * 
     * @param additionalCurrency2
     *            Additional Currency 2
     */
    public void setAdditionalCurrency2( @Nullable final java.lang.String additionalCurrency2 )
    {
        rememberChangedField("AdditionalCurrency2", this.additionalCurrency2);
        this.additionalCurrency2 = additionalCurrency2;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>CAExchangeRate</b>
     * </p>
     * 
     * @param cAExchangeRate
     *            Absolute Exchange Rate
     */
    public void setCAExchangeRate( @Nullable final BigDecimal cAExchangeRate )
    {
        rememberChangedField("CAExchangeRate", this.cAExchangeRate);
        this.cAExchangeRate = cAExchangeRate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchRateIsIndirectQuotation</b>
     * </p>
     * 
     * @param exchRateIsIndirectQuotation
     *            Exchange Rate Is Indirect Quotation
     */
    public void setExchRateIsIndirectQuotation( @Nullable final java.lang.Boolean exchRateIsIndirectQuotation )
    {
        rememberChangedField("ExchRateIsIndirectQuotation", this.exchRateIsIndirectQuotation);
        this.exchRateIsIndirectQuotation = exchRateIsIndirectQuotation;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInLocalCurrency</b>
     * </p>
     * 
     * @param cAAmountInLocalCurrency
     *            The cAAmountInLocalCurrency to set.
     */
    public void setCAAmountInLocalCurrency( @Nullable final BigDecimal cAAmountInLocalCurrency )
    {
        rememberChangedField("CAAmountInLocalCurrency", this.cAAmountInLocalCurrency);
        this.cAAmountInLocalCurrency = cAAmountInLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @param cAAmountInTransactionCurrency
     *            The cAAmountInTransactionCurrency to set.
     */
    public void setCAAmountInTransactionCurrency( @Nullable final BigDecimal cAAmountInTransactionCurrency )
    {
        rememberChangedField("CAAmountInTransactionCurrency", this.cAAmountInTransactionCurrency);
        this.cAAmountInTransactionCurrency = cAAmountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInSecondCurrency</b>
     * </p>
     * 
     * @param cAAmountInSecondCurrency
     *            The cAAmountInSecondCurrency to set.
     */
    public void setCAAmountInSecondCurrency( @Nullable final BigDecimal cAAmountInSecondCurrency )
    {
        rememberChangedField("CAAmountInSecondCurrency", this.cAAmountInSecondCurrency);
        this.cAAmountInSecondCurrency = cAAmountInSecondCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInThirdCurrency</b>
     * </p>
     * 
     * @param cAAmountInThirdCurrency
     *            The cAAmountInThirdCurrency to set.
     */
    public void setCAAmountInThirdCurrency( @Nullable final BigDecimal cAAmountInThirdCurrency )
    {
        rememberChangedField("CAAmountInThirdCurrency", this.cAAmountInThirdCurrency);
        this.cAAmountInThirdCurrency = cAAmountInThirdCurrency;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscountDueDate</b>
     * </p>
     * 
     * @param cACashDiscountDueDate
     *            Due Date for Cash Discount
     */
    public void setCACashDiscountDueDate( @Nullable final LocalDate cACashDiscountDueDate )
    {
        rememberChangedField("CACashDiscountDueDate", this.cACashDiscountDueDate);
        this.cACashDiscountDueDate = cACashDiscountDueDate;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscountRate</b>
     * </p>
     * 
     * @param cACashDiscountRate
     *            Cash Discount Percentage Rate
     */
    public void setCACashDiscountRate( @Nullable final BigDecimal cACashDiscountRate )
    {
        rememberChangedField("CACashDiscountRate", this.cACashDiscountRate);
        this.cACashDiscountRate = cACashDiscountRate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAEligibleAmountForCshDiscount</b>
     * </p>
     * 
     * @param cAEligibleAmountForCshDiscount
     *            The cAEligibleAmountForCshDiscount to set.
     */
    public void setCAEligibleAmountForCshDiscount( @Nullable final BigDecimal cAEligibleAmountForCshDiscount )
    {
        rememberChangedField("CAEligibleAmountForCshDiscount", this.cAEligibleAmountForCshDiscount);
        this.cAEligibleAmountForCshDiscount = cAEligibleAmountForCshDiscount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CACashDiscAmountInClearingCrcy</b>
     * </p>
     * 
     * @param cACashDiscAmountInClearingCrcy
     *            The cACashDiscAmountInClearingCrcy to set.
     */
    public void setCACashDiscAmountInClearingCrcy( @Nullable final BigDecimal cACashDiscAmountInClearingCrcy )
    {
        rememberChangedField("CACashDiscAmountInClearingCrcy", this.cACashDiscAmountInClearingCrcy);
        this.cACashDiscAmountInClearingCrcy = cACashDiscAmountInClearingCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     * 
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final java.lang.String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CASupplementaryTaxCode</b>
     * </p>
     * 
     * @param cASupplementaryTaxCode
     *            Supplementary Tax
     */
    public void setCASupplementaryTaxCode( @Nullable final java.lang.String cASupplementaryTaxCode )
    {
        rememberChangedField("CASupplementaryTaxCode", this.cASupplementaryTaxCode);
        this.cASupplementaryTaxCode = cASupplementaryTaxCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxAmountInLocalCurrency</b>
     * </p>
     * 
     * @param cATaxAmountInLocalCurrency
     *            The cATaxAmountInLocalCurrency to set.
     */
    public void setCATaxAmountInLocalCurrency( @Nullable final BigDecimal cATaxAmountInLocalCurrency )
    {
        rememberChangedField("CATaxAmountInLocalCurrency", this.cATaxAmountInLocalCurrency);
        this.cATaxAmountInLocalCurrency = cATaxAmountInLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxAmountInTransCurrency</b>
     * </p>
     * 
     * @param cATaxAmountInTransCurrency
     *            The cATaxAmountInTransCurrency to set.
     */
    public void setCATaxAmountInTransCurrency( @Nullable final BigDecimal cATaxAmountInTransCurrency )
    {
        rememberChangedField("CATaxAmountInTransCurrency", this.cATaxAmountInTransCurrency);
        this.cATaxAmountInTransCurrency = cATaxAmountInTransCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxAmountInSecondCurrency</b>
     * </p>
     * 
     * @param cATaxAmountInSecondCurrency
     *            The cATaxAmountInSecondCurrency to set.
     */
    public void setCATaxAmountInSecondCurrency( @Nullable final BigDecimal cATaxAmountInSecondCurrency )
    {
        rememberChangedField("CATaxAmountInSecondCurrency", this.cATaxAmountInSecondCurrency);
        this.cATaxAmountInSecondCurrency = cATaxAmountInSecondCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxAmountInThirdCurrency</b>
     * </p>
     * 
     * @param cATaxAmountInThirdCurrency
     *            The cATaxAmountInThirdCurrency to set.
     */
    public void setCATaxAmountInThirdCurrency( @Nullable final BigDecimal cATaxAmountInThirdCurrency )
    {
        rememberChangedField("CATaxAmountInThirdCurrency", this.cATaxAmountInThirdCurrency);
        this.cATaxAmountInThirdCurrency = cATaxAmountInThirdCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CADownPaymentTaxAccount</b>
     * </p>
     * 
     * @param cADownPaymentTaxAccount
     *            Account for Posting Sales / Purchase Tax for Down Payments
     */
    public void setCADownPaymentTaxAccount( @Nullable final java.lang.String cADownPaymentTaxAccount )
    {
        rememberChangedField("CADownPaymentTaxAccount", this.cADownPaymentTaxAccount);
        this.cADownPaymentTaxAccount = cADownPaymentTaxAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CADownPaymentOffsetTaxAccount</b>
     * </p>
     * 
     * @param cADownPaymentOffsetTaxAccount
     *            Account for Offsetting Tax Posting in Down Payments
     */
    public void setCADownPaymentOffsetTaxAccount( @Nullable final java.lang.String cADownPaymentOffsetTaxAccount )
    {
        rememberChangedField("CADownPaymentOffsetTaxAccount", this.cADownPaymentOffsetTaxAccount);
        this.cADownPaymentOffsetTaxAccount = cADownPaymentOffsetTaxAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     * 
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final java.lang.String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CATaxDate</b>
     * </p>
     * 
     * @param cATaxDate
     *            Decisive Date for Calculating Taxes
     */
    public void setCATaxDate( @Nullable final LocalDate cATaxDate )
    {
        rememberChangedField("CATaxDate", this.cATaxDate);
        this.cATaxDate = cATaxDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     * 
     * @param withholdingTaxCode
     *            Withholding Tax Code
     */
    public void setWithholdingTaxCode( @Nullable final java.lang.String withholdingTaxCode )
    {
        rememberChangedField("WithholdingTaxCode", this.withholdingTaxCode);
        this.withholdingTaxCode = withholdingTaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAWithholdingTaxSupplement</b>
     * </p>
     * 
     * @param cAWithholdingTaxSupplement
     *            Withholding Tax Supplement
     */
    public void setCAWithholdingTaxSupplement( @Nullable final java.lang.String cAWithholdingTaxSupplement )
    {
        rememberChangedField("CAWithholdingTaxSupplement", this.cAWithholdingTaxSupplement);
        this.cAWithholdingTaxSupplement = cAWithholdingTaxSupplement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAWithholdingTaxCategory</b>
     * </p>
     * 
     * @param cAWithholdingTaxCategory
     *            Line Item Category From Withholding Tax View
     */
    public void setCAWithholdingTaxCategory( @Nullable final java.lang.String cAWithholdingTaxCategory )
    {
        rememberChangedField("CAWithholdingTaxCategory", this.cAWithholdingTaxCategory);
        this.cAWithholdingTaxCategory = cAWithholdingTaxCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CABaseAmountForWithholdingTax</b>
     * </p>
     * 
     * @param cABaseAmountForWithholdingTax
     *            The cABaseAmountForWithholdingTax to set.
     */
    public void setCABaseAmountForWithholdingTax( @Nullable final BigDecimal cABaseAmountForWithholdingTax )
    {
        rememberChangedField("CABaseAmountForWithholdingTax", this.cABaseAmountForWithholdingTax);
        this.cABaseAmountForWithholdingTax = cABaseAmountForWithholdingTax;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAWithholdingTaxAmount</b>
     * </p>
     * 
     * @param cAWithholdingTaxAmount
     *            The cAWithholdingTaxAmount to set.
     */
    public void setCAWithholdingTaxAmount( @Nullable final BigDecimal cAWithholdingTaxAmount )
    {
        rememberChangedField("CAWithholdingTaxAmount", this.cAWithholdingTaxAmount);
        this.cAWithholdingTaxAmount = cAWithholdingTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>CAWithholdingTaxPercentage</b>
     * </p>
     * 
     * @param cAWithholdingTaxPercentage
     *            Withholding Tax Percentage
     */
    public void setCAWithholdingTaxPercentage( @Nullable final java.lang.String cAWithholdingTaxPercentage )
    {
        rememberChangedField("CAWithholdingTaxPercentage", this.cAWithholdingTaxPercentage);
        this.cAWithholdingTaxPercentage = cAWithholdingTaxPercentage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCertificate</b>
     * </p>
     * 
     * @param withholdingTaxCertificate
     *            Withholding Tax Certificate
     */
    public void setWithholdingTaxCertificate( @Nullable final java.lang.String withholdingTaxCertificate )
    {
        rememberChangedField("WithholdingTaxCertificate", this.withholdingTaxCertificate);
        this.withholdingTaxCertificate = withholdingTaxCertificate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAOtherTaxCode</b>
     * </p>
     * 
     * @param cAOtherTaxCode
     *            Tax Code for Other Taxes
     */
    public void setCAOtherTaxCode( @Nullable final java.lang.String cAOtherTaxCode )
    {
        rememberChangedField("CAOtherTaxCode", this.cAOtherTaxCode);
        this.cAOtherTaxCode = cAOtherTaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingCodeForTaxItems</b>
     * </p>
     * 
     * @param cAGroupingCodeForTaxItems
     *            Grouping Key for Tax Items
     */
    public void setCAGroupingCodeForTaxItems( @Nullable final java.lang.String cAGroupingCodeForTaxItems )
    {
        rememberChangedField("CAGroupingCodeForTaxItems", this.cAGroupingCodeForTaxItems);
        this.cAGroupingCodeForTaxItems = cAGroupingCodeForTaxItems;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxPortionInLocalCurrency</b>
     * </p>
     * 
     * @param cATaxPortionInLocalCurrency
     *            The cATaxPortionInLocalCurrency to set.
     */
    public void setCATaxPortionInLocalCurrency( @Nullable final BigDecimal cATaxPortionInLocalCurrency )
    {
        rememberChangedField("CATaxPortionInLocalCurrency", this.cATaxPortionInLocalCurrency);
        this.cATaxPortionInLocalCurrency = cATaxPortionInLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxPortionInTransCurrency</b>
     * </p>
     * 
     * @param cATaxPortionInTransCurrency
     *            The cATaxPortionInTransCurrency to set.
     */
    public void setCATaxPortionInTransCurrency( @Nullable final BigDecimal cATaxPortionInTransCurrency )
    {
        rememberChangedField("CATaxPortionInTransCurrency", this.cATaxPortionInTransCurrency);
        this.cATaxPortionInTransCurrency = cATaxPortionInTransCurrency;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CATaxIsCalculatedExternally</b>
     * </p>
     * 
     * @param cATaxIsCalculatedExternally
     *            Tax on Sales/Purchases Was Calculated by Document
     */
    public void setCATaxIsCalculatedExternally( @Nullable final java.lang.Boolean cATaxIsCalculatedExternally )
    {
        rememberChangedField("CATaxIsCalculatedExternally", this.cATaxIsCalculatedExternally);
        this.cATaxIsCalculatedExternally = cATaxIsCalculatedExternally;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentMethod</b>
     * </p>
     * 
     * @param cAPaymentMethod
     *            Payment Method
     */
    public void setCAPaymentMethod( @Nullable final java.lang.String cAPaymentMethod )
    {
        rememberChangedField("CAPaymentMethod", this.cAPaymentMethod);
        this.cAPaymentMethod = cAPaymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentCompanyCode</b>
     * </p>
     * 
     * @param cAPaymentCompanyCode
     *            Company Code for Automatic Payment Transactions
     */
    public void setCAPaymentCompanyCode( @Nullable final java.lang.String cAPaymentCompanyCode )
    {
        rememberChangedField("CAPaymentCompanyCode", this.cAPaymentCompanyCode);
        this.cAPaymentCompanyCode = cAPaymentCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingForPayment</b>
     * </p>
     * 
     * @param cAGroupingForPayment
     *            Grouping field for automatic payments
     */
    public void setCAGroupingForPayment( @Nullable final java.lang.String cAGroupingForPayment )
    {
        rememberChangedField("CAGroupingForPayment", this.cAGroupingForPayment);
        this.cAGroupingForPayment = cAGroupingForPayment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentSpecificationCategory</b>
     * </p>
     * 
     * @param cAPaymentSpecificationCategory
     *            Category of Payment Specification
     */
    public void setCAPaymentSpecificationCategory( @Nullable final java.lang.String cAPaymentSpecificationCategory )
    {
        rememberChangedField("CAPaymentSpecificationCategory", this.cAPaymentSpecificationCategory);
        this.cAPaymentSpecificationCategory = cAPaymentSpecificationCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingStatus</b>
     * </p>
     * 
     * @param cAClearingStatus
     *            Clearing status
     */
    public void setCAClearingStatus( @Nullable final java.lang.String cAClearingStatus )
    {
        rememberChangedField("CAClearingStatus", this.cAClearingStatus);
        this.cAClearingStatus = cAClearingStatus;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingDate</b>
     * </p>
     * 
     * @param cAClearingDate
     *            Clearing Date
     */
    public void setCAClearingDate( @Nullable final LocalDate cAClearingDate )
    {
        rememberChangedField("CAClearingDate", this.cAClearingDate);
        this.cAClearingDate = cAClearingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingDocumentNumber</b>
     * </p>
     * 
     * @param cAClearingDocumentNumber
     *            Clearing Document or Printed Document
     */
    public void setCAClearingDocumentNumber( @Nullable final java.lang.String cAClearingDocumentNumber )
    {
        rememberChangedField("CAClearingDocumentNumber", this.cAClearingDocumentNumber);
        this.cAClearingDocumentNumber = cAClearingDocumentNumber;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDateOfClearingDoc</b>
     * </p>
     * 
     * @param cAPostingDateOfClearingDoc
     *            Clearing Document Posting Date
     */
    public void setCAPostingDateOfClearingDoc( @Nullable final LocalDate cAPostingDateOfClearingDoc )
    {
        rememberChangedField("CAPostingDateOfClearingDoc", this.cAPostingDateOfClearingDoc);
        this.cAPostingDateOfClearingDoc = cAPostingDateOfClearingDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingReason</b>
     * </p>
     * 
     * @param cAClearingReason
     *            Clearing Reason
     */
    public void setCAClearingReason( @Nullable final java.lang.String cAClearingReason )
    {
        rememberChangedField("CAClearingReason", this.cAClearingReason);
        this.cAClearingReason = cAClearingReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingCurrency</b>
     * </p>
     * 
     * @param cAClearingCurrency
     *            Clearing Currency
     */
    public void setCAClearingCurrency( @Nullable final java.lang.String cAClearingCurrency )
    {
        rememberChangedField("CAClearingCurrency", this.cAClearingCurrency);
        this.cAClearingCurrency = cAClearingCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingAmountInClearingCrcy</b>
     * </p>
     * 
     * @param cAClearingAmountInClearingCrcy
     *            The cAClearingAmountInClearingCrcy to set.
     */
    public void setCAClearingAmountInClearingCrcy( @Nullable final BigDecimal cAClearingAmountInClearingCrcy )
    {
        rememberChangedField("CAClearingAmountInClearingCrcy", this.cAClearingAmountInClearingCrcy);
        this.cAClearingAmountInClearingCrcy = cAClearingAmountInClearingCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxAmountInClearingCrcy</b>
     * </p>
     * 
     * @param cATaxAmountInClearingCrcy
     *            The cATaxAmountInClearingCrcy to set.
     */
    public void setCATaxAmountInClearingCrcy( @Nullable final BigDecimal cATaxAmountInClearingCrcy )
    {
        rememberChangedField("CATaxAmountInClearingCrcy", this.cATaxAmountInClearingCrcy);
        this.cATaxAmountInClearingCrcy = cATaxAmountInClearingCrcy;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAValueDateForClearing</b>
     * </p>
     * 
     * @param cAValueDateForClearing
     *            Clearing Value Date
     */
    public void setCAValueDateForClearing( @Nullable final LocalDate cAValueDateForClearing )
    {
        rememberChangedField("CAValueDateForClearing", this.cAValueDateForClearing);
        this.cAValueDateForClearing = cAValueDateForClearing;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingRestrictionCode</b>
     * </p>
     * 
     * @param cAClearingRestrictionCode
     *            Clearing restriction
     */
    public void setCAClearingRestrictionCode( @Nullable final java.lang.String cAClearingRestrictionCode )
    {
        rememberChangedField("CAClearingRestrictionCode", this.cAClearingRestrictionCode);
        this.cAClearingRestrictionCode = cAClearingRestrictionCode;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingPostingIsReset</b>
     * </p>
     * 
     * @param cAClearingPostingIsReset
     *            Clearing posting reversed
     */
    public void setCAClearingPostingIsReset( @Nullable final java.lang.Boolean cAClearingPostingIsReset )
    {
        rememberChangedField("CAClearingPostingIsReset", this.cAClearingPostingIsReset);
        this.cAClearingPostingIsReset = cAClearingPostingIsReset;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAItemIsWithdrawn</b>
     * </p>
     * 
     * @param cAItemIsWithdrawn
     *            Item Canceled
     */
    public void setCAItemIsWithdrawn( @Nullable final java.lang.Boolean cAItemIsWithdrawn )
    {
        rememberChangedField("CAItemIsWithdrawn", this.cAItemIsWithdrawn);
        this.cAItemIsWithdrawn = cAItemIsWithdrawn;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAItemIsExcludedFromDunning</b>
     * </p>
     * 
     * @param cAItemIsExcludedFromDunning
     *            Exclude Item from Dunning Run
     */
    public void setCAItemIsExcludedFromDunning( @Nullable final java.lang.Boolean cAItemIsExcludedFromDunning )
    {
        rememberChangedField("CAItemIsExcludedFromDunning", this.cAItemIsExcludedFromDunning);
        this.cAItemIsExcludedFromDunning = cAItemIsExcludedFromDunning;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADunningProcedure</b>
     * </p>
     * 
     * @param cADunningProcedure
     *            Dunning Procedure
     */
    public void setCADunningProcedure( @Nullable final java.lang.String cADunningProcedure )
    {
        rememberChangedField("CADunningProcedure", this.cADunningProcedure);
        this.cADunningProcedure = cADunningProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CAGrpgCodeForTransfToCollAgcy</b>
     * </p>
     * 
     * @param cAGrpgCodeForTransfToCollAgcy
     *            Collection Item
     */
    public void setCAGrpgCodeForTransfToCollAgcy( @Nullable final java.lang.String cAGrpgCodeForTransfToCollAgcy )
    {
        rememberChangedField("CAGrpgCodeForTransfToCollAgcy", this.cAGrpgCodeForTransfToCollAgcy);
        this.cAGrpgCodeForTransfToCollAgcy = cAGrpgCodeForTransfToCollAgcy;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsIncludedInCollectionCase</b>
     * </p>
     * 
     * @param cAIsIncludedInCollectionCase
     *            Item Is Included in Collection Case
     */
    public void setCAIsIncludedInCollectionCase( @Nullable final java.lang.Boolean cAIsIncludedInCollectionCase )
    {
        rememberChangedField("CAIsIncludedInCollectionCase", this.cAIsIncludedInCollectionCase);
        this.cAIsIncludedInCollectionCase = cAIsIncludedInCollectionCase;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CashPlanningGroup</b>
     * </p>
     * 
     * @param cashPlanningGroup
     *            Planning Group
     */
    public void setCashPlanningGroup( @Nullable final java.lang.String cashPlanningGroup )
    {
        rememberChangedField("CashPlanningGroup", this.cashPlanningGroup);
        this.cashPlanningGroup = cashPlanningGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningLevel</b>
     * </p>
     * 
     * @param planningLevel
     *            Planning Level
     */
    public void setPlanningLevel( @Nullable final java.lang.String planningLevel )
    {
        rememberChangedField("PlanningLevel", this.planningLevel);
        this.planningLevel = planningLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAAdditionalDaysForCashMgmt</b>
     * </p>
     * 
     * @param cAAdditionalDaysForCashMgmt
     *            Additional Days for Cash Management
     */
    public void setCAAdditionalDaysForCashMgmt( @Nullable final java.lang.String cAAdditionalDaysForCashMgmt )
    {
        rememberChangedField("CAAdditionalDaysForCashMgmt", this.cAAdditionalDaysForCashMgmt);
        this.cAAdditionalDaysForCashMgmt = cAAdditionalDaysForCashMgmt;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedAmtInTransactionCrcy</b>
     * </p>
     * 
     * @param plannedAmtInTransactionCrcy
     *            The plannedAmtInTransactionCrcy to set.
     */
    public void setPlannedAmtInTransactionCrcy( @Nullable final BigDecimal plannedAmtInTransactionCrcy )
    {
        rememberChangedField("PlannedAmtInTransactionCrcy", this.plannedAmtInTransactionCrcy);
        this.plannedAmtInTransactionCrcy = plannedAmtInTransactionCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAAltvBPForPayment</b>
     * </p>
     * 
     * @param cAAltvBPForPayment
     *            Alternative Business Partner for Payments
     */
    public void setCAAltvBPForPayment( @Nullable final java.lang.String cAAltvBPForPayment )
    {
        rememberChangedField("CAAltvBPForPayment", this.cAAltvBPForPayment);
        this.cAAltvBPForPayment = cAAltvBPForPayment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CABankOfAltvBPForPayment</b>
     * </p>
     * 
     * @param cABankOfAltvBPForPayment
     *            Bank Details ID of Payee
     */
    public void setCABankOfAltvBPForPayment( @Nullable final java.lang.String cABankOfAltvBPForPayment )
    {
        rememberChangedField("CABankOfAltvBPForPayment", this.cABankOfAltvBPForPayment);
        this.cABankOfAltvBPForPayment = cABankOfAltvBPForPayment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAAddressOfAltvBPForPayment</b>
     * </p>
     * 
     * @param cAAddressOfAltvBPForPayment
     *            Address Number
     */
    public void setCAAddressOfAltvBPForPayment( @Nullable final java.lang.String cAAddressOfAltvBPForPayment )
    {
        rememberChangedField("CAAddressOfAltvBPForPayment", this.cAAddressOfAltvBPForPayment);
        this.cAAddressOfAltvBPForPayment = cAAddressOfAltvBPForPayment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CACardOfAltvBPForPayment</b>
     * </p>
     * 
     * @param cACardOfAltvBPForPayment
     *            Alternative Payment Card ID in Document
     */
    public void setCACardOfAltvBPForPayment( @Nullable final java.lang.String cACardOfAltvBPForPayment )
    {
        rememberChangedField("CACardOfAltvBPForPayment", this.cACardOfAltvBPForPayment);
        this.cACardOfAltvBPForPayment = cACardOfAltvBPForPayment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CAGLPostingCurrency</b>
     * </p>
     * 
     * @param cAGLPostingCurrency
     *            Update Currency for General Ledger Transaction Figures
     */
    public void setCAGLPostingCurrency( @Nullable final java.lang.String cAGLPostingCurrency )
    {
        rememberChangedField("CAGLPostingCurrency", this.cAGLPostingCurrency);
        this.cAGLPostingCurrency = cAGLPostingCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAGLPostingAmount</b>
     * </p>
     * 
     * @param cAGLPostingAmount
     *            The cAGLPostingAmount to set.
     */
    public void setCAGLPostingAmount( @Nullable final BigDecimal cAGLPostingAmount )
    {
        rememberChangedField("CAGLPostingAmount", this.cAGLPostingAmount);
        this.cAGLPostingAmount = cAGLPostingAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAGLPostingTaxAmount</b>
     * </p>
     * 
     * @param cAGLPostingTaxAmount
     *            The cAGLPostingTaxAmount to set.
     */
    public void setCAGLPostingTaxAmount( @Nullable final BigDecimal cAGLPostingTaxAmount )
    {
        rememberChangedField("CAGLPostingTaxAmount", this.cAGLPostingTaxAmount);
        this.cAGLPostingTaxAmount = cAGLPostingTaxAmount;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsSeparateLineItemInGL</b>
     * </p>
     * 
     * @param cAIsSeparateLineItemInGL
     *            Create Line Item in General Ledger
     */
    public void setCAIsSeparateLineItemInGL( @Nullable final java.lang.Boolean cAIsSeparateLineItemInGL )
    {
        rememberChangedField("CAIsSeparateLineItemInGL", this.cAIsSeparateLineItemInGL);
        this.cAIsSeparateLineItemInGL = cAIsSeparateLineItemInGL;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsCashFlowItem</b>
     * </p>
     * 
     * @param cAIsCashFlowItem
     *            Document Contains Assignments from Cash Flows
     */
    public void setCAIsCashFlowItem( @Nullable final java.lang.Boolean cAIsCashFlowItem )
    {
        rememberChangedField("CAIsCashFlowItem", this.cAIsCashFlowItem);
        this.cAIsCashFlowItem = cAIsCashFlowItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CACashFlowAccount</b>
     * </p>
     * 
     * @param cACashFlowAccount
     *            Originating Account in Cash Flow Anlaysis
     */
    public void setCACashFlowAccount( @Nullable final java.lang.String cACashFlowAccount )
    {
        rememberChangedField("CACashFlowAccount", this.cACashFlowAccount);
        this.cACashFlowAccount = cACashFlowAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CACashFlowCompanyCode</b>
     * </p>
     * 
     * @param cACashFlowCompanyCode
     *            Partner Company Code for Cash Flow Analysis
     */
    public void setCACashFlowCompanyCode( @Nullable final java.lang.String cACashFlowCompanyCode )
    {
        rememberChangedField("CACashFlowCompanyCode", this.cACashFlowCompanyCode);
        this.cACashFlowCompanyCode = cACashFlowCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentPreNotificationCode</b>
     * </p>
     * 
     * @param cAPaymentPreNotificationCode
     *            Item Included in a Payment Order
     */
    public void setCAPaymentPreNotificationCode( @Nullable final java.lang.String cAPaymentPreNotificationCode )
    {
        rememberChangedField("CAPaymentPreNotificationCode", this.cAPaymentPreNotificationCode);
        this.cAPaymentPreNotificationCode = cAPaymentPreNotificationCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CASEPAPreNotificationNumber</b>
     * </p>
     * 
     * @param cASEPAPreNotificationNumber
     *            SEPA: Number of Direct Debit Pre-Notification
     */
    public void setCASEPAPreNotificationNumber( @Nullable final java.lang.String cASEPAPreNotificationNumber )
    {
        rememberChangedField("CASEPAPreNotificationNumber", this.cASEPAPreNotificationNumber);
        this.cASEPAPreNotificationNumber = cASEPAPreNotificationNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CASEPAPreNotifOriginCode</b>
     * </p>
     * 
     * @param cASEPAPreNotifOriginCode
     *            SEPA: Origin of Direct Debit Pre-Notification
     */
    public void setCASEPAPreNotifOriginCode( @Nullable final java.lang.String cASEPAPreNotifOriginCode )
    {
        rememberChangedField("CASEPAPreNotifOriginCode", this.cASEPAPreNotifOriginCode);
        this.cASEPAPreNotifOriginCode = cASEPAPreNotifOriginCode;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASEPAPreNotifExecutionDate</b>
     * </p>
     * 
     * @param cASEPAPreNotifExecutionDate
     *            SEPA: Date of Execution of Direct Debit Pre-Notifcation
     */
    public void setCASEPAPreNotifExecutionDate( @Nullable final LocalDate cASEPAPreNotifExecutionDate )
    {
        rememberChangedField("CASEPAPreNotifExecutionDate", this.cASEPAPreNotifExecutionDate);
        this.cASEPAPreNotifExecutionDate = cASEPAPreNotifExecutionDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASEPAPreNotificationRqmtCode</b>
     * </p>
     * 
     * @param cASEPAPreNotificationRqmtCode
     *            SEPA: Requirement for a Pre-Notification
     */
    public void setCASEPAPreNotificationRqmtCode( @Nullable final java.lang.String cASEPAPreNotificationRqmtCode )
    {
        rememberChangedField("CASEPAPreNotificationRqmtCode", this.cASEPAPreNotificationRqmtCode);
        this.cASEPAPreNotificationRqmtCode = cASEPAPreNotificationRqmtCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CARevenueDistrFinalRecipient</b>
     * </p>
     * 
     * @param cARevenueDistrFinalRecipient
     *            Contract Account of Final Recipient
     */
    public void setCARevenueDistrFinalRecipient( @Nullable final java.lang.String cARevenueDistrFinalRecipient )
    {
        rememberChangedField("CARevenueDistrFinalRecipient", this.cARevenueDistrFinalRecipient);
        this.cARevenueDistrFinalRecipient = cARevenueDistrFinalRecipient;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CARevenueDistrCurrentStatus</b>
     * </p>
     * 
     * @param cARevenueDistrCurrentStatus
     *            Current Distribution Status
     */
    public void setCARevenueDistrCurrentStatus( @Nullable final java.lang.String cARevenueDistrCurrentStatus )
    {
        rememberChangedField("CARevenueDistrCurrentStatus", this.cARevenueDistrCurrentStatus);
        this.cARevenueDistrCurrentStatus = cARevenueDistrCurrentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CARevenueDistrLastStatus</b>
     * </p>
     * 
     * @param cARevenueDistrLastStatus
     *            Last Distribution Status Reported
     */
    public void setCARevenueDistrLastStatus( @Nullable final java.lang.String cARevenueDistrLastStatus )
    {
        rememberChangedField("CARevenueDistrLastStatus", this.cARevenueDistrLastStatus);
        this.cARevenueDistrLastStatus = cARevenueDistrLastStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CACurrentFactoringStatusOfRbl</b>
     * </p>
     * 
     * @param cACurrentFactoringStatusOfRbl
     *            Factoring: Current Status of Receivable
     */
    public void setCACurrentFactoringStatusOfRbl( @Nullable final java.lang.String cACurrentFactoringStatusOfRbl )
    {
        rememberChangedField("CACurrentFactoringStatusOfRbl", this.cACurrentFactoringStatusOfRbl);
        this.cACurrentFactoringStatusOfRbl = cACurrentFactoringStatusOfRbl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAFactoringCheckStsForClrgInfo</b>
     * </p>
     * 
     * @param cAFactoringCheckStsForClrgInfo
     *            Factoring: Check Status for Clearing Information
     */
    public void setCAFactoringCheckStsForClrgInfo( @Nullable final java.lang.String cAFactoringCheckStsForClrgInfo )
    {
        rememberChangedField("CAFactoringCheckStsForClrgInfo", this.cAFactoringCheckStsForClrgInfo);
        this.cAFactoringCheckStsForClrgInfo = cAFactoringCheckStsForClrgInfo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     * 
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final java.lang.String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     * 
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final java.lang.String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     * 
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final java.lang.String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxCalculationProcedure</b>
     * </p>
     * 
     * @param taxCalculationProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    public void setTaxCalculationProcedure( @Nullable final java.lang.String taxCalculationProcedure )
    {
        rememberChangedField("TaxCalculationProcedure", this.taxCalculationProcedure);
        this.taxCalculationProcedure = taxCalculationProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateCAInternalID</b>
     * </p>
     * 
     * @param sEPAMandateCAInternalID
     *            SEPA Mandate Identifier
     */
    public void setSEPAMandateCAInternalID( @Nullable final java.lang.String sEPAMandateCAInternalID )
    {
        rememberChangedField("SEPAMandateCAInternalID", this.sEPAMandateCAInternalID);
        this.sEPAMandateCAInternalID = sEPAMandateCAInternalID;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "BPItemLogical";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentNumber", getCADocumentNumber());
        entityKey.addKeyProperty("CARepetitionItemNumber", getCARepetitionItemNumber());
        entityKey.addKeyProperty("CABPItemNumber", getCABPItemNumber());
        entityKey.addKeyProperty("CASubItemNumber", getCASubItemNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentNumber", getCADocumentNumber());
        values.put("CARepetitionItemNumber", getCARepetitionItemNumber());
        values.put("CABPItemNumber", getCABPItemNumber());
        values.put("CASubItemNumber", getCASubItemNumber());
        values.put("CAConcatenatedDocumentNumber", getCAConcatenatedDocumentNumber());
        values.put("CompanyCode", getCompanyCode());
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessPlace", getBusinessPlace());
        values.put("Segment", getSegment());
        values.put("ProfitCenter", getProfitCenter());
        values.put("Division", getDivision());
        values.put("PersonnelNumber", getPersonnelNumber());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("BusinessPartner", getBusinessPartner());
        values.put("CAContract", getCAContract());
        values.put("CAProviderContractItemNumber", getCAProviderContractItemNumber());
        values.put("CAAdditionalContract", getCAAdditionalContract());
        values.put("ContractAccount", getContractAccount());
        values.put("CASubApplication", getCASubApplication());
        values.put("AltvContractAcctForCollvBills", getAltvContractAcctForCollvBills());
        values.put("CAReconciliationAccount", getCAReconciliationAccount());
        values.put("CAApplicationArea", getCAApplicationArea());
        values.put("CAMainTransaction", getCAMainTransaction());
        values.put("CASubTransaction", getCASubTransaction());
        values.put("CAAccountDeterminationCode", getCAAccountDeterminationCode());
        values.put("CADoubtfulOrValueAdjmtCode", getCADoubtfulOrValueAdjmtCode());
        values.put("CAAccountAssignmentCategory", getCAAccountAssignmentCategory());
        values.put("CAAccountAssignment", getCAAccountAssignment());
        values.put("CADocumentType", getCADocumentType());
        values.put("CAIsDownPaymentRequest", getCAIsDownPaymentRequest());
        values.put("CAItemIsOnlyForSettlement", getCAItemIsOnlyForSettlement());
        values.put("CAStatisticalItemCode", getCAStatisticalItemCode());
        values.put("CABPItemText", getCABPItemText());
        values.put("CANumberOfRepetitionItems", getCANumberOfRepetitionItems());
        values.put("CARepetitionGroup", getCARepetitionGroup());
        values.put("CAStartDateOfBillingPeriod", getCAStartDateOfBillingPeriod());
        values.put("CAEndDateOfBillingPeriod", getCAEndDateOfBillingPeriod());
        values.put("CAGroupingCodeForBPItems", getCAGroupingCodeForBPItems());
        values.put("CAPeriodCode", getCAPeriodCode());
        values.put("CAChangeIsForbidden", getCAChangeIsForbidden());
        values.put("CAInterestCode", getCAInterestCode());
        values.put("CARoundingItemCode", getCARoundingItemCode());
        values.put("CAReceivingCountry", getCAReceivingCountry());
        values.put("CAInternalPostingReasonCode", getCAInternalPostingReasonCode());
        values.put("CAWorkflowCheckReason", getCAWorkflowCheckReason());
        values.put("CAWorkflowCheckProcess", getCAWorkflowCheckProcess());
        values.put("CANegativePostingControlCode", getCANegativePostingControlCode());
        values.put("CAPartnerSettlementStatus", getCAPartnerSettlementStatus());
        values.put("CAIsPartOfJointLiability", getCAIsPartOfJointLiability());
        values.put("CASubstituteDocumentNumber", getCASubstituteDocumentNumber());
        values.put("CASubstituteDocumentCategory", getCASubstituteDocumentCategory());
        values.put("CAStatisticalCodeOfOriginItem", getCAStatisticalCodeOfOriginItem());
        values.put("CADocumentNumberOfOriginItem", getCADocumentNumberOfOriginItem());
        values.put("CAReferenceDocument", getCAReferenceDocument());
        values.put("DocumentDate", getDocumentDate());
        values.put("CAPostingDate", getCAPostingDate());
        values.put("CANetDueDate", getCANetDueDate());
        values.put("CADeferralDate", getCADeferralDate());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("AdditionalCurrency1", getAdditionalCurrency1());
        values.put("AdditionalCurrency2", getAdditionalCurrency2());
        values.put("CAExchangeRate", getCAExchangeRate());
        values.put("ExchRateIsIndirectQuotation", getExchRateIsIndirectQuotation());
        values.put("CAAmountInLocalCurrency", getCAAmountInLocalCurrency());
        values.put("CAAmountInTransactionCurrency", getCAAmountInTransactionCurrency());
        values.put("CAAmountInSecondCurrency", getCAAmountInSecondCurrency());
        values.put("CAAmountInThirdCurrency", getCAAmountInThirdCurrency());
        values.put("CACashDiscountDueDate", getCACashDiscountDueDate());
        values.put("CACashDiscountRate", getCACashDiscountRate());
        values.put("CAEligibleAmountForCshDiscount", getCAEligibleAmountForCshDiscount());
        values.put("CACashDiscAmountInClearingCrcy", getCACashDiscAmountInClearingCrcy());
        values.put("TaxCode", getTaxCode());
        values.put("CASupplementaryTaxCode", getCASupplementaryTaxCode());
        values.put("CATaxAmountInLocalCurrency", getCATaxAmountInLocalCurrency());
        values.put("CATaxAmountInTransCurrency", getCATaxAmountInTransCurrency());
        values.put("CATaxAmountInSecondCurrency", getCATaxAmountInSecondCurrency());
        values.put("CATaxAmountInThirdCurrency", getCATaxAmountInThirdCurrency());
        values.put("CADownPaymentTaxAccount", getCADownPaymentTaxAccount());
        values.put("CADownPaymentOffsetTaxAccount", getCADownPaymentOffsetTaxAccount());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("CATaxDate", getCATaxDate());
        values.put("WithholdingTaxCode", getWithholdingTaxCode());
        values.put("CAWithholdingTaxSupplement", getCAWithholdingTaxSupplement());
        values.put("CAWithholdingTaxCategory", getCAWithholdingTaxCategory());
        values.put("CABaseAmountForWithholdingTax", getCABaseAmountForWithholdingTax());
        values.put("CAWithholdingTaxAmount", getCAWithholdingTaxAmount());
        values.put("CAWithholdingTaxPercentage", getCAWithholdingTaxPercentage());
        values.put("WithholdingTaxCertificate", getWithholdingTaxCertificate());
        values.put("CAOtherTaxCode", getCAOtherTaxCode());
        values.put("CAGroupingCodeForTaxItems", getCAGroupingCodeForTaxItems());
        values.put("CATaxPortionInLocalCurrency", getCATaxPortionInLocalCurrency());
        values.put("CATaxPortionInTransCurrency", getCATaxPortionInTransCurrency());
        values.put("CATaxIsCalculatedExternally", getCATaxIsCalculatedExternally());
        values.put("CAPaymentMethod", getCAPaymentMethod());
        values.put("CAPaymentCompanyCode", getCAPaymentCompanyCode());
        values.put("CAGroupingForPayment", getCAGroupingForPayment());
        values.put("CAPaymentSpecificationCategory", getCAPaymentSpecificationCategory());
        values.put("CAClearingStatus", getCAClearingStatus());
        values.put("CAClearingDate", getCAClearingDate());
        values.put("CAClearingDocumentNumber", getCAClearingDocumentNumber());
        values.put("CAPostingDateOfClearingDoc", getCAPostingDateOfClearingDoc());
        values.put("CAClearingReason", getCAClearingReason());
        values.put("CAClearingCurrency", getCAClearingCurrency());
        values.put("CAClearingAmountInClearingCrcy", getCAClearingAmountInClearingCrcy());
        values.put("CATaxAmountInClearingCrcy", getCATaxAmountInClearingCrcy());
        values.put("CAValueDateForClearing", getCAValueDateForClearing());
        values.put("CAClearingRestrictionCode", getCAClearingRestrictionCode());
        values.put("CAClearingPostingIsReset", getCAClearingPostingIsReset());
        values.put("CAItemIsWithdrawn", getCAItemIsWithdrawn());
        values.put("CAItemIsExcludedFromDunning", getCAItemIsExcludedFromDunning());
        values.put("CADunningProcedure", getCADunningProcedure());
        values.put("CAGrpgCodeForTransfToCollAgcy", getCAGrpgCodeForTransfToCollAgcy());
        values.put("CAIsIncludedInCollectionCase", getCAIsIncludedInCollectionCase());
        values.put("CashPlanningGroup", getCashPlanningGroup());
        values.put("PlanningLevel", getPlanningLevel());
        values.put("CAAdditionalDaysForCashMgmt", getCAAdditionalDaysForCashMgmt());
        values.put("PlannedAmtInTransactionCrcy", getPlannedAmtInTransactionCrcy());
        values.put("CAAltvBPForPayment", getCAAltvBPForPayment());
        values.put("CABankOfAltvBPForPayment", getCABankOfAltvBPForPayment());
        values.put("CAAddressOfAltvBPForPayment", getCAAddressOfAltvBPForPayment());
        values.put("CACardOfAltvBPForPayment", getCACardOfAltvBPForPayment());
        values.put("CAGLPostingCurrency", getCAGLPostingCurrency());
        values.put("CAGLPostingAmount", getCAGLPostingAmount());
        values.put("CAGLPostingTaxAmount", getCAGLPostingTaxAmount());
        values.put("CAIsSeparateLineItemInGL", getCAIsSeparateLineItemInGL());
        values.put("CAIsCashFlowItem", getCAIsCashFlowItem());
        values.put("CACashFlowAccount", getCACashFlowAccount());
        values.put("CACashFlowCompanyCode", getCACashFlowCompanyCode());
        values.put("CAPaymentPreNotificationCode", getCAPaymentPreNotificationCode());
        values.put("CASEPAPreNotificationNumber", getCASEPAPreNotificationNumber());
        values.put("CASEPAPreNotifOriginCode", getCASEPAPreNotifOriginCode());
        values.put("CASEPAPreNotifExecutionDate", getCASEPAPreNotifExecutionDate());
        values.put("CASEPAPreNotificationRqmtCode", getCASEPAPreNotificationRqmtCode());
        values.put("CARevenueDistrFinalRecipient", getCARevenueDistrFinalRecipient());
        values.put("CARevenueDistrCurrentStatus", getCARevenueDistrCurrentStatus());
        values.put("CARevenueDistrLastStatus", getCARevenueDistrLastStatus());
        values.put("CACurrentFactoringStatusOfRbl", getCACurrentFactoringStatusOfRbl());
        values.put("CAFactoringCheckStsForClrgInfo", getCAFactoringCheckStsForClrgInfo());
        values.put("ControllingArea", getControllingArea());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("Country", getCountry());
        values.put("TaxCalculationProcedure", getTaxCalculationProcedure());
        values.put("SEPAMandateCAInternalID", getSEPAMandateCAInternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentNumber") ) {
                final Object value = values.remove("CADocumentNumber");
                if( (value == null) || (!value.equals(getCADocumentNumber())) ) {
                    setCADocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CARepetitionItemNumber") ) {
                final Object value = values.remove("CARepetitionItemNumber");
                if( (value == null) || (!value.equals(getCARepetitionItemNumber())) ) {
                    setCARepetitionItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CABPItemNumber") ) {
                final Object value = values.remove("CABPItemNumber");
                if( (value == null) || (!value.equals(getCABPItemNumber())) ) {
                    setCABPItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubItemNumber") ) {
                final Object value = values.remove("CASubItemNumber");
                if( (value == null) || (!value.equals(getCASubItemNumber())) ) {
                    setCASubItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAConcatenatedDocumentNumber") ) {
                final Object value = values.remove("CAConcatenatedDocumentNumber");
                if( (value == null) || (!value.equals(getCAConcatenatedDocumentNumber())) ) {
                    setCAConcatenatedDocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPlace") ) {
                final Object value = values.remove("BusinessPlace");
                if( (value == null) || (!value.equals(getBusinessPlace())) ) {
                    setBusinessPlace(((java.lang.String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((java.lang.String) value));
                }
            }
            if( values.containsKey("PersonnelNumber") ) {
                final Object value = values.remove("PersonnelNumber");
                if( (value == null) || (!value.equals(getPersonnelNumber())) ) {
                    setPersonnelNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAContract") ) {
                final Object value = values.remove("CAContract");
                if( (value == null) || (!value.equals(getCAContract())) ) {
                    setCAContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAProviderContractItemNumber") ) {
                final Object value = values.remove("CAProviderContractItemNumber");
                if( (value == null) || (!value.equals(getCAProviderContractItemNumber())) ) {
                    setCAProviderContractItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAdditionalContract") ) {
                final Object value = values.remove("CAAdditionalContract");
                if( (value == null) || (!value.equals(getCAAdditionalContract())) ) {
                    setCAAdditionalContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractAccount") ) {
                final Object value = values.remove("ContractAccount");
                if( (value == null) || (!value.equals(getContractAccount())) ) {
                    setContractAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubApplication") ) {
                final Object value = values.remove("CASubApplication");
                if( (value == null) || (!value.equals(getCASubApplication())) ) {
                    setCASubApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("AltvContractAcctForCollvBills") ) {
                final Object value = values.remove("AltvContractAcctForCollvBills");
                if( (value == null) || (!value.equals(getAltvContractAcctForCollvBills())) ) {
                    setAltvContractAcctForCollvBills(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAReconciliationAccount") ) {
                final Object value = values.remove("CAReconciliationAccount");
                if( (value == null) || (!value.equals(getCAReconciliationAccount())) ) {
                    setCAReconciliationAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAApplicationArea") ) {
                final Object value = values.remove("CAApplicationArea");
                if( (value == null) || (!value.equals(getCAApplicationArea())) ) {
                    setCAApplicationArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAMainTransaction") ) {
                final Object value = values.remove("CAMainTransaction");
                if( (value == null) || (!value.equals(getCAMainTransaction())) ) {
                    setCAMainTransaction(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubTransaction") ) {
                final Object value = values.remove("CASubTransaction");
                if( (value == null) || (!value.equals(getCASubTransaction())) ) {
                    setCASubTransaction(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAccountDeterminationCode") ) {
                final Object value = values.remove("CAAccountDeterminationCode");
                if( (value == null) || (!value.equals(getCAAccountDeterminationCode())) ) {
                    setCAAccountDeterminationCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADoubtfulOrValueAdjmtCode") ) {
                final Object value = values.remove("CADoubtfulOrValueAdjmtCode");
                if( (value == null) || (!value.equals(getCADoubtfulOrValueAdjmtCode())) ) {
                    setCADoubtfulOrValueAdjmtCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAccountAssignmentCategory") ) {
                final Object value = values.remove("CAAccountAssignmentCategory");
                if( (value == null) || (!value.equals(getCAAccountAssignmentCategory())) ) {
                    setCAAccountAssignmentCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAccountAssignment") ) {
                final Object value = values.remove("CAAccountAssignment");
                if( (value == null) || (!value.equals(getCAAccountAssignment())) ) {
                    setCAAccountAssignment(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentType") ) {
                final Object value = values.remove("CADocumentType");
                if( (value == null) || (!value.equals(getCADocumentType())) ) {
                    setCADocumentType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAIsDownPaymentRequest") ) {
                final Object value = values.remove("CAIsDownPaymentRequest");
                if( (value == null) || (!value.equals(getCAIsDownPaymentRequest())) ) {
                    setCAIsDownPaymentRequest(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAItemIsOnlyForSettlement") ) {
                final Object value = values.remove("CAItemIsOnlyForSettlement");
                if( (value == null) || (!value.equals(getCAItemIsOnlyForSettlement())) ) {
                    setCAItemIsOnlyForSettlement(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAStatisticalItemCode") ) {
                final Object value = values.remove("CAStatisticalItemCode");
                if( (value == null) || (!value.equals(getCAStatisticalItemCode())) ) {
                    setCAStatisticalItemCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CABPItemText") ) {
                final Object value = values.remove("CABPItemText");
                if( (value == null) || (!value.equals(getCABPItemText())) ) {
                    setCABPItemText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CANumberOfRepetitionItems") ) {
                final Object value = values.remove("CANumberOfRepetitionItems");
                if( (value == null) || (!value.equals(getCANumberOfRepetitionItems())) ) {
                    setCANumberOfRepetitionItems(((java.lang.String) value));
                }
            }
            if( values.containsKey("CARepetitionGroup") ) {
                final Object value = values.remove("CARepetitionGroup");
                if( (value == null) || (!value.equals(getCARepetitionGroup())) ) {
                    setCARepetitionGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAStartDateOfBillingPeriod") ) {
                final Object value = values.remove("CAStartDateOfBillingPeriod");
                if( (value == null) || (!value.equals(getCAStartDateOfBillingPeriod())) ) {
                    setCAStartDateOfBillingPeriod(((LocalDate) value));
                }
            }
            if( values.containsKey("CAEndDateOfBillingPeriod") ) {
                final Object value = values.remove("CAEndDateOfBillingPeriod");
                if( (value == null) || (!value.equals(getCAEndDateOfBillingPeriod())) ) {
                    setCAEndDateOfBillingPeriod(((LocalDate) value));
                }
            }
            if( values.containsKey("CAGroupingCodeForBPItems") ) {
                final Object value = values.remove("CAGroupingCodeForBPItems");
                if( (value == null) || (!value.equals(getCAGroupingCodeForBPItems())) ) {
                    setCAGroupingCodeForBPItems(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPeriodCode") ) {
                final Object value = values.remove("CAPeriodCode");
                if( (value == null) || (!value.equals(getCAPeriodCode())) ) {
                    setCAPeriodCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAChangeIsForbidden") ) {
                final Object value = values.remove("CAChangeIsForbidden");
                if( (value == null) || (!value.equals(getCAChangeIsForbidden())) ) {
                    setCAChangeIsForbidden(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAInterestCode") ) {
                final Object value = values.remove("CAInterestCode");
                if( (value == null) || (!value.equals(getCAInterestCode())) ) {
                    setCAInterestCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CARoundingItemCode") ) {
                final Object value = values.remove("CARoundingItemCode");
                if( (value == null) || (!value.equals(getCARoundingItemCode())) ) {
                    setCARoundingItemCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAReceivingCountry") ) {
                final Object value = values.remove("CAReceivingCountry");
                if( (value == null) || (!value.equals(getCAReceivingCountry())) ) {
                    setCAReceivingCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAInternalPostingReasonCode") ) {
                final Object value = values.remove("CAInternalPostingReasonCode");
                if( (value == null) || (!value.equals(getCAInternalPostingReasonCode())) ) {
                    setCAInternalPostingReasonCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAWorkflowCheckReason") ) {
                final Object value = values.remove("CAWorkflowCheckReason");
                if( (value == null) || (!value.equals(getCAWorkflowCheckReason())) ) {
                    setCAWorkflowCheckReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAWorkflowCheckProcess") ) {
                final Object value = values.remove("CAWorkflowCheckProcess");
                if( (value == null) || (!value.equals(getCAWorkflowCheckProcess())) ) {
                    setCAWorkflowCheckProcess(((java.lang.String) value));
                }
            }
            if( values.containsKey("CANegativePostingControlCode") ) {
                final Object value = values.remove("CANegativePostingControlCode");
                if( (value == null) || (!value.equals(getCANegativePostingControlCode())) ) {
                    setCANegativePostingControlCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPartnerSettlementStatus") ) {
                final Object value = values.remove("CAPartnerSettlementStatus");
                if( (value == null) || (!value.equals(getCAPartnerSettlementStatus())) ) {
                    setCAPartnerSettlementStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAIsPartOfJointLiability") ) {
                final Object value = values.remove("CAIsPartOfJointLiability");
                if( (value == null) || (!value.equals(getCAIsPartOfJointLiability())) ) {
                    setCAIsPartOfJointLiability(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubstituteDocumentNumber") ) {
                final Object value = values.remove("CASubstituteDocumentNumber");
                if( (value == null) || (!value.equals(getCASubstituteDocumentNumber())) ) {
                    setCASubstituteDocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASubstituteDocumentCategory") ) {
                final Object value = values.remove("CASubstituteDocumentCategory");
                if( (value == null) || (!value.equals(getCASubstituteDocumentCategory())) ) {
                    setCASubstituteDocumentCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAStatisticalCodeOfOriginItem") ) {
                final Object value = values.remove("CAStatisticalCodeOfOriginItem");
                if( (value == null) || (!value.equals(getCAStatisticalCodeOfOriginItem())) ) {
                    setCAStatisticalCodeOfOriginItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentNumberOfOriginItem") ) {
                final Object value = values.remove("CADocumentNumberOfOriginItem");
                if( (value == null) || (!value.equals(getCADocumentNumberOfOriginItem())) ) {
                    setCADocumentNumberOfOriginItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAReferenceDocument") ) {
                final Object value = values.remove("CAReferenceDocument");
                if( (value == null) || (!value.equals(getCAReferenceDocument())) ) {
                    setCAReferenceDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAPostingDate") ) {
                final Object value = values.remove("CAPostingDate");
                if( (value == null) || (!value.equals(getCAPostingDate())) ) {
                    setCAPostingDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CANetDueDate") ) {
                final Object value = values.remove("CANetDueDate");
                if( (value == null) || (!value.equals(getCANetDueDate())) ) {
                    setCANetDueDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CADeferralDate") ) {
                final Object value = values.remove("CADeferralDate");
                if( (value == null) || (!value.equals(getCADeferralDate())) ) {
                    setCADeferralDate(((LocalDate) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("AdditionalCurrency1") ) {
                final Object value = values.remove("AdditionalCurrency1");
                if( (value == null) || (!value.equals(getAdditionalCurrency1())) ) {
                    setAdditionalCurrency1(((java.lang.String) value));
                }
            }
            if( values.containsKey("AdditionalCurrency2") ) {
                final Object value = values.remove("AdditionalCurrency2");
                if( (value == null) || (!value.equals(getAdditionalCurrency2())) ) {
                    setAdditionalCurrency2(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAExchangeRate") ) {
                final Object value = values.remove("CAExchangeRate");
                if( (value == null) || (!value.equals(getCAExchangeRate())) ) {
                    setCAExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExchRateIsIndirectQuotation") ) {
                final Object value = values.remove("ExchRateIsIndirectQuotation");
                if( (value == null) || (!value.equals(getExchRateIsIndirectQuotation())) ) {
                    setExchRateIsIndirectQuotation(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAAmountInLocalCurrency") ) {
                final Object value = values.remove("CAAmountInLocalCurrency");
                if( (value == null) || (!value.equals(getCAAmountInLocalCurrency())) ) {
                    setCAAmountInLocalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAAmountInTransactionCurrency") ) {
                final Object value = values.remove("CAAmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getCAAmountInTransactionCurrency())) ) {
                    setCAAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAAmountInSecondCurrency") ) {
                final Object value = values.remove("CAAmountInSecondCurrency");
                if( (value == null) || (!value.equals(getCAAmountInSecondCurrency())) ) {
                    setCAAmountInSecondCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAAmountInThirdCurrency") ) {
                final Object value = values.remove("CAAmountInThirdCurrency");
                if( (value == null) || (!value.equals(getCAAmountInThirdCurrency())) ) {
                    setCAAmountInThirdCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CACashDiscountDueDate") ) {
                final Object value = values.remove("CACashDiscountDueDate");
                if( (value == null) || (!value.equals(getCACashDiscountDueDate())) ) {
                    setCACashDiscountDueDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CACashDiscountRate") ) {
                final Object value = values.remove("CACashDiscountRate");
                if( (value == null) || (!value.equals(getCACashDiscountRate())) ) {
                    setCACashDiscountRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAEligibleAmountForCshDiscount") ) {
                final Object value = values.remove("CAEligibleAmountForCshDiscount");
                if( (value == null) || (!value.equals(getCAEligibleAmountForCshDiscount())) ) {
                    setCAEligibleAmountForCshDiscount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CACashDiscAmountInClearingCrcy") ) {
                final Object value = values.remove("CACashDiscAmountInClearingCrcy");
                if( (value == null) || (!value.equals(getCACashDiscAmountInClearingCrcy())) ) {
                    setCACashDiscAmountInClearingCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASupplementaryTaxCode") ) {
                final Object value = values.remove("CASupplementaryTaxCode");
                if( (value == null) || (!value.equals(getCASupplementaryTaxCode())) ) {
                    setCASupplementaryTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CATaxAmountInLocalCurrency") ) {
                final Object value = values.remove("CATaxAmountInLocalCurrency");
                if( (value == null) || (!value.equals(getCATaxAmountInLocalCurrency())) ) {
                    setCATaxAmountInLocalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CATaxAmountInTransCurrency") ) {
                final Object value = values.remove("CATaxAmountInTransCurrency");
                if( (value == null) || (!value.equals(getCATaxAmountInTransCurrency())) ) {
                    setCATaxAmountInTransCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CATaxAmountInSecondCurrency") ) {
                final Object value = values.remove("CATaxAmountInSecondCurrency");
                if( (value == null) || (!value.equals(getCATaxAmountInSecondCurrency())) ) {
                    setCATaxAmountInSecondCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CATaxAmountInThirdCurrency") ) {
                final Object value = values.remove("CATaxAmountInThirdCurrency");
                if( (value == null) || (!value.equals(getCATaxAmountInThirdCurrency())) ) {
                    setCATaxAmountInThirdCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CADownPaymentTaxAccount") ) {
                final Object value = values.remove("CADownPaymentTaxAccount");
                if( (value == null) || (!value.equals(getCADownPaymentTaxAccount())) ) {
                    setCADownPaymentTaxAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADownPaymentOffsetTaxAccount") ) {
                final Object value = values.remove("CADownPaymentOffsetTaxAccount");
                if( (value == null) || (!value.equals(getCADownPaymentOffsetTaxAccount())) ) {
                    setCADownPaymentOffsetTaxAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((java.lang.String) value));
                }
            }
            if( values.containsKey("CATaxDate") ) {
                final Object value = values.remove("CATaxDate");
                if( (value == null) || (!value.equals(getCATaxDate())) ) {
                    setCATaxDate(((LocalDate) value));
                }
            }
            if( values.containsKey("WithholdingTaxCode") ) {
                final Object value = values.remove("WithholdingTaxCode");
                if( (value == null) || (!value.equals(getWithholdingTaxCode())) ) {
                    setWithholdingTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAWithholdingTaxSupplement") ) {
                final Object value = values.remove("CAWithholdingTaxSupplement");
                if( (value == null) || (!value.equals(getCAWithholdingTaxSupplement())) ) {
                    setCAWithholdingTaxSupplement(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAWithholdingTaxCategory") ) {
                final Object value = values.remove("CAWithholdingTaxCategory");
                if( (value == null) || (!value.equals(getCAWithholdingTaxCategory())) ) {
                    setCAWithholdingTaxCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("CABaseAmountForWithholdingTax") ) {
                final Object value = values.remove("CABaseAmountForWithholdingTax");
                if( (value == null) || (!value.equals(getCABaseAmountForWithholdingTax())) ) {
                    setCABaseAmountForWithholdingTax(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAWithholdingTaxAmount") ) {
                final Object value = values.remove("CAWithholdingTaxAmount");
                if( (value == null) || (!value.equals(getCAWithholdingTaxAmount())) ) {
                    setCAWithholdingTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAWithholdingTaxPercentage") ) {
                final Object value = values.remove("CAWithholdingTaxPercentage");
                if( (value == null) || (!value.equals(getCAWithholdingTaxPercentage())) ) {
                    setCAWithholdingTaxPercentage(((java.lang.String) value));
                }
            }
            if( values.containsKey("WithholdingTaxCertificate") ) {
                final Object value = values.remove("WithholdingTaxCertificate");
                if( (value == null) || (!value.equals(getWithholdingTaxCertificate())) ) {
                    setWithholdingTaxCertificate(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAOtherTaxCode") ) {
                final Object value = values.remove("CAOtherTaxCode");
                if( (value == null) || (!value.equals(getCAOtherTaxCode())) ) {
                    setCAOtherTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGroupingCodeForTaxItems") ) {
                final Object value = values.remove("CAGroupingCodeForTaxItems");
                if( (value == null) || (!value.equals(getCAGroupingCodeForTaxItems())) ) {
                    setCAGroupingCodeForTaxItems(((java.lang.String) value));
                }
            }
            if( values.containsKey("CATaxPortionInLocalCurrency") ) {
                final Object value = values.remove("CATaxPortionInLocalCurrency");
                if( (value == null) || (!value.equals(getCATaxPortionInLocalCurrency())) ) {
                    setCATaxPortionInLocalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CATaxPortionInTransCurrency") ) {
                final Object value = values.remove("CATaxPortionInTransCurrency");
                if( (value == null) || (!value.equals(getCATaxPortionInTransCurrency())) ) {
                    setCATaxPortionInTransCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CATaxIsCalculatedExternally") ) {
                final Object value = values.remove("CATaxIsCalculatedExternally");
                if( (value == null) || (!value.equals(getCATaxIsCalculatedExternally())) ) {
                    setCATaxIsCalculatedExternally(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAPaymentMethod") ) {
                final Object value = values.remove("CAPaymentMethod");
                if( (value == null) || (!value.equals(getCAPaymentMethod())) ) {
                    setCAPaymentMethod(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPaymentCompanyCode") ) {
                final Object value = values.remove("CAPaymentCompanyCode");
                if( (value == null) || (!value.equals(getCAPaymentCompanyCode())) ) {
                    setCAPaymentCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGroupingForPayment") ) {
                final Object value = values.remove("CAGroupingForPayment");
                if( (value == null) || (!value.equals(getCAGroupingForPayment())) ) {
                    setCAGroupingForPayment(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPaymentSpecificationCategory") ) {
                final Object value = values.remove("CAPaymentSpecificationCategory");
                if( (value == null) || (!value.equals(getCAPaymentSpecificationCategory())) ) {
                    setCAPaymentSpecificationCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAClearingStatus") ) {
                final Object value = values.remove("CAClearingStatus");
                if( (value == null) || (!value.equals(getCAClearingStatus())) ) {
                    setCAClearingStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAClearingDate") ) {
                final Object value = values.remove("CAClearingDate");
                if( (value == null) || (!value.equals(getCAClearingDate())) ) {
                    setCAClearingDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAClearingDocumentNumber") ) {
                final Object value = values.remove("CAClearingDocumentNumber");
                if( (value == null) || (!value.equals(getCAClearingDocumentNumber())) ) {
                    setCAClearingDocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPostingDateOfClearingDoc") ) {
                final Object value = values.remove("CAPostingDateOfClearingDoc");
                if( (value == null) || (!value.equals(getCAPostingDateOfClearingDoc())) ) {
                    setCAPostingDateOfClearingDoc(((LocalDate) value));
                }
            }
            if( values.containsKey("CAClearingReason") ) {
                final Object value = values.remove("CAClearingReason");
                if( (value == null) || (!value.equals(getCAClearingReason())) ) {
                    setCAClearingReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAClearingCurrency") ) {
                final Object value = values.remove("CAClearingCurrency");
                if( (value == null) || (!value.equals(getCAClearingCurrency())) ) {
                    setCAClearingCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAClearingAmountInClearingCrcy") ) {
                final Object value = values.remove("CAClearingAmountInClearingCrcy");
                if( (value == null) || (!value.equals(getCAClearingAmountInClearingCrcy())) ) {
                    setCAClearingAmountInClearingCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CATaxAmountInClearingCrcy") ) {
                final Object value = values.remove("CATaxAmountInClearingCrcy");
                if( (value == null) || (!value.equals(getCATaxAmountInClearingCrcy())) ) {
                    setCATaxAmountInClearingCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAValueDateForClearing") ) {
                final Object value = values.remove("CAValueDateForClearing");
                if( (value == null) || (!value.equals(getCAValueDateForClearing())) ) {
                    setCAValueDateForClearing(((LocalDate) value));
                }
            }
            if( values.containsKey("CAClearingRestrictionCode") ) {
                final Object value = values.remove("CAClearingRestrictionCode");
                if( (value == null) || (!value.equals(getCAClearingRestrictionCode())) ) {
                    setCAClearingRestrictionCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAClearingPostingIsReset") ) {
                final Object value = values.remove("CAClearingPostingIsReset");
                if( (value == null) || (!value.equals(getCAClearingPostingIsReset())) ) {
                    setCAClearingPostingIsReset(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAItemIsWithdrawn") ) {
                final Object value = values.remove("CAItemIsWithdrawn");
                if( (value == null) || (!value.equals(getCAItemIsWithdrawn())) ) {
                    setCAItemIsWithdrawn(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAItemIsExcludedFromDunning") ) {
                final Object value = values.remove("CAItemIsExcludedFromDunning");
                if( (value == null) || (!value.equals(getCAItemIsExcludedFromDunning())) ) {
                    setCAItemIsExcludedFromDunning(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CADunningProcedure") ) {
                final Object value = values.remove("CADunningProcedure");
                if( (value == null) || (!value.equals(getCADunningProcedure())) ) {
                    setCADunningProcedure(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGrpgCodeForTransfToCollAgcy") ) {
                final Object value = values.remove("CAGrpgCodeForTransfToCollAgcy");
                if( (value == null) || (!value.equals(getCAGrpgCodeForTransfToCollAgcy())) ) {
                    setCAGrpgCodeForTransfToCollAgcy(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAIsIncludedInCollectionCase") ) {
                final Object value = values.remove("CAIsIncludedInCollectionCase");
                if( (value == null) || (!value.equals(getCAIsIncludedInCollectionCase())) ) {
                    setCAIsIncludedInCollectionCase(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CashPlanningGroup") ) {
                final Object value = values.remove("CashPlanningGroup");
                if( (value == null) || (!value.equals(getCashPlanningGroup())) ) {
                    setCashPlanningGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("PlanningLevel") ) {
                final Object value = values.remove("PlanningLevel");
                if( (value == null) || (!value.equals(getPlanningLevel())) ) {
                    setPlanningLevel(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAdditionalDaysForCashMgmt") ) {
                final Object value = values.remove("CAAdditionalDaysForCashMgmt");
                if( (value == null) || (!value.equals(getCAAdditionalDaysForCashMgmt())) ) {
                    setCAAdditionalDaysForCashMgmt(((java.lang.String) value));
                }
            }
            if( values.containsKey("PlannedAmtInTransactionCrcy") ) {
                final Object value = values.remove("PlannedAmtInTransactionCrcy");
                if( (value == null) || (!value.equals(getPlannedAmtInTransactionCrcy())) ) {
                    setPlannedAmtInTransactionCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAAltvBPForPayment") ) {
                final Object value = values.remove("CAAltvBPForPayment");
                if( (value == null) || (!value.equals(getCAAltvBPForPayment())) ) {
                    setCAAltvBPForPayment(((java.lang.String) value));
                }
            }
            if( values.containsKey("CABankOfAltvBPForPayment") ) {
                final Object value = values.remove("CABankOfAltvBPForPayment");
                if( (value == null) || (!value.equals(getCABankOfAltvBPForPayment())) ) {
                    setCABankOfAltvBPForPayment(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAddressOfAltvBPForPayment") ) {
                final Object value = values.remove("CAAddressOfAltvBPForPayment");
                if( (value == null) || (!value.equals(getCAAddressOfAltvBPForPayment())) ) {
                    setCAAddressOfAltvBPForPayment(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACardOfAltvBPForPayment") ) {
                final Object value = values.remove("CACardOfAltvBPForPayment");
                if( (value == null) || (!value.equals(getCACardOfAltvBPForPayment())) ) {
                    setCACardOfAltvBPForPayment(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGLPostingCurrency") ) {
                final Object value = values.remove("CAGLPostingCurrency");
                if( (value == null) || (!value.equals(getCAGLPostingCurrency())) ) {
                    setCAGLPostingCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGLPostingAmount") ) {
                final Object value = values.remove("CAGLPostingAmount");
                if( (value == null) || (!value.equals(getCAGLPostingAmount())) ) {
                    setCAGLPostingAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAGLPostingTaxAmount") ) {
                final Object value = values.remove("CAGLPostingTaxAmount");
                if( (value == null) || (!value.equals(getCAGLPostingTaxAmount())) ) {
                    setCAGLPostingTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAIsSeparateLineItemInGL") ) {
                final Object value = values.remove("CAIsSeparateLineItemInGL");
                if( (value == null) || (!value.equals(getCAIsSeparateLineItemInGL())) ) {
                    setCAIsSeparateLineItemInGL(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAIsCashFlowItem") ) {
                final Object value = values.remove("CAIsCashFlowItem");
                if( (value == null) || (!value.equals(getCAIsCashFlowItem())) ) {
                    setCAIsCashFlowItem(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CACashFlowAccount") ) {
                final Object value = values.remove("CACashFlowAccount");
                if( (value == null) || (!value.equals(getCACashFlowAccount())) ) {
                    setCACashFlowAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACashFlowCompanyCode") ) {
                final Object value = values.remove("CACashFlowCompanyCode");
                if( (value == null) || (!value.equals(getCACashFlowCompanyCode())) ) {
                    setCACashFlowCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPaymentPreNotificationCode") ) {
                final Object value = values.remove("CAPaymentPreNotificationCode");
                if( (value == null) || (!value.equals(getCAPaymentPreNotificationCode())) ) {
                    setCAPaymentPreNotificationCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASEPAPreNotificationNumber") ) {
                final Object value = values.remove("CASEPAPreNotificationNumber");
                if( (value == null) || (!value.equals(getCASEPAPreNotificationNumber())) ) {
                    setCASEPAPreNotificationNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASEPAPreNotifOriginCode") ) {
                final Object value = values.remove("CASEPAPreNotifOriginCode");
                if( (value == null) || (!value.equals(getCASEPAPreNotifOriginCode())) ) {
                    setCASEPAPreNotifOriginCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASEPAPreNotifExecutionDate") ) {
                final Object value = values.remove("CASEPAPreNotifExecutionDate");
                if( (value == null) || (!value.equals(getCASEPAPreNotifExecutionDate())) ) {
                    setCASEPAPreNotifExecutionDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CASEPAPreNotificationRqmtCode") ) {
                final Object value = values.remove("CASEPAPreNotificationRqmtCode");
                if( (value == null) || (!value.equals(getCASEPAPreNotificationRqmtCode())) ) {
                    setCASEPAPreNotificationRqmtCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CARevenueDistrFinalRecipient") ) {
                final Object value = values.remove("CARevenueDistrFinalRecipient");
                if( (value == null) || (!value.equals(getCARevenueDistrFinalRecipient())) ) {
                    setCARevenueDistrFinalRecipient(((java.lang.String) value));
                }
            }
            if( values.containsKey("CARevenueDistrCurrentStatus") ) {
                final Object value = values.remove("CARevenueDistrCurrentStatus");
                if( (value == null) || (!value.equals(getCARevenueDistrCurrentStatus())) ) {
                    setCARevenueDistrCurrentStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CARevenueDistrLastStatus") ) {
                final Object value = values.remove("CARevenueDistrLastStatus");
                if( (value == null) || (!value.equals(getCARevenueDistrLastStatus())) ) {
                    setCARevenueDistrLastStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACurrentFactoringStatusOfRbl") ) {
                final Object value = values.remove("CACurrentFactoringStatusOfRbl");
                if( (value == null) || (!value.equals(getCACurrentFactoringStatusOfRbl())) ) {
                    setCACurrentFactoringStatusOfRbl(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAFactoringCheckStsForClrgInfo") ) {
                final Object value = values.remove("CAFactoringCheckStsForClrgInfo");
                if( (value == null) || (!value.equals(getCAFactoringCheckStsForClrgInfo())) ) {
                    setCAFactoringCheckStsForClrgInfo(((java.lang.String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((java.lang.String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxCalculationProcedure") ) {
                final Object value = values.remove("TaxCalculationProcedure");
                if( (value == null) || (!value.equals(getTaxCalculationProcedure())) ) {
                    setTaxCalculationProcedure(((java.lang.String) value));
                }
            }
            if( values.containsKey("SEPAMandateCAInternalID") ) {
                final Object value = values.remove("SEPAMandateCAInternalID");
                if( (value == null) || (!value.equals(getSEPAMandateCAInternalID())) ) {
                    setSEPAMandateCAInternalID(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_BPItemBusLock") ) {
                final Object value = (values).remove("_BPItemBusLock");
                if( value instanceof Iterable ) {
                    if( to_BPItemBusLock == null ) {
                        to_BPItemBusLock = Lists.newArrayList();
                    } else {
                        to_BPItemBusLock = Lists.newArrayList(to_BPItemBusLock);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BPItemBusLock entity;
                        if( to_BPItemBusLock.size() > i ) {
                            entity = to_BPItemBusLock.get(i);
                        } else {
                            entity = new BPItemBusLock();
                            to_BPItemBusLock.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_DocHeader") ) {
                final Object value = (values).remove("_DocHeader");
                if( value instanceof Map ) {
                    if( to_DocHeader == null ) {
                        to_DocHeader = new DocumentHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_DocHeader.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingDocumentManageService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_BPItemBusLock != null ) {
            (values).put("_BPItemBusLock", to_BPItemBusLock);
        }
        if( to_DocHeader != null ) {
            (values).put("_DocHeader", to_DocHeader);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>BPItemBusLock</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_BPItemBusLock</b>.
     * <p>
     * If the navigation property for an entity <b>BPItemLogical</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_BPItemBusLock</b> is already loaded, the result will
     *         contain the <b>BPItemBusLock</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BPItemBusLock>> getBPItemBusLockIfPresent()
    {
        return Option.of(to_BPItemBusLock);
    }

    /**
     * Overwrites the list of associated <b>BPItemBusLock</b> entities for the loaded navigation property
     * <b>_BPItemBusLock</b>.
     * <p>
     * If the navigation property <b>_BPItemBusLock</b> of a queried <b>BPItemLogical</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>BPItemBusLock</b> entities.
     */
    public void setBPItemBusLock( @Nonnull final List<BPItemBusLock> value )
    {
        if( to_BPItemBusLock == null ) {
            to_BPItemBusLock = Lists.newArrayList();
        }
        to_BPItemBusLock.clear();
        to_BPItemBusLock.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BPItemBusLock</b> entities. This corresponds to the OData navigation
     * property <b>_BPItemBusLock</b>.
     * <p>
     * If the navigation property <b>_BPItemBusLock</b> of a queried <b>BPItemLogical</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>BPItemBusLock</b> entities.
     */
    public void addBPItemBusLock( BPItemBusLock... entity )
    {
        if( to_BPItemBusLock == null ) {
            to_BPItemBusLock = Lists.newArrayList();
        }
        to_BPItemBusLock.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>DocumentHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_DocHeader</b>.
     * <p>
     * If the navigation property for an entity <b>BPItemLogical</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_DocHeader</b> is already loaded, the result will contain
     *         the <b>DocumentHeader</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<DocumentHeader> getDocHeaderIfPresent()
    {
        return Option.of(to_DocHeader);
    }

    /**
     * Overwrites the associated <b>DocumentHeader</b> entity for the loaded navigation property <b>_DocHeader</b>.
     * 
     * @param value
     *            New <b>DocumentHeader</b> entity.
     */
    public void setDocHeader( final DocumentHeader value )
    {
        to_DocHeader = value;
    }

    /**
     * Helper class to allow for fluent creation of BPItemLogical instances.
     * 
     */
    public final static class BPItemLogicalBuilder
    {

        private List<BPItemBusLock> to_BPItemBusLock = Lists.newArrayList();
        private DocumentHeader to_DocHeader;

        private BPItemLogical.BPItemLogicalBuilder to_BPItemBusLock( final List<BPItemBusLock> value )
        {
            to_BPItemBusLock.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_BPItemBusLock</b> for <b>BPItemLogical</b> to multiple <b>BPItemBusLock</b>.
         * 
         * @param value
         *            The BPItemBusLocks to build this BPItemLogical with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BPItemLogical.BPItemLogicalBuilder bpItemBusLock( BPItemBusLock... value )
        {
            return to_BPItemBusLock(Lists.newArrayList(value));
        }

        private BPItemLogical.BPItemLogicalBuilder to_DocHeader( final DocumentHeader value )
        {
            to_DocHeader = value;
            return this;
        }

        /**
         * Navigation property <b>_DocHeader</b> for <b>BPItemLogical</b> to single <b>DocumentHeader</b>.
         * 
         * @param value
         *            The DocumentHeader to build this BPItemLogical with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BPItemLogical.BPItemLogicalBuilder docHeader( final DocumentHeader value )
        {
            return to_DocHeader(value);
        }

    }

}
