/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingDocumentManageService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Bus.Part. Item Payment Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BPItemPaytDataType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BPItemPaytData extends VdmEntity<BPItemPaytData> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_cadocumentmanage.v0001.BPItemPaytDataType";
    /**
     * Selector for all available fields of BPItemPaytData.
     * 
     */
    public final static SimpleProperty<BPItemPaytData> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @return Number of a FI-CA Document
     */
    @Nullable
    @ElementName( "CADocumentNumber" )
    private java.lang.String cADocumentNumber;
    public final static SimpleProperty.String<BPItemPaytData> CA_DOCUMENT_NUMBER =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "CADocumentNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingForPayment</b>
     * </p>
     * 
     * @return Grouping field for automatic payments
     */
    @Nullable
    @ElementName( "CAGroupingForPayment" )
    private java.lang.String cAGroupingForPayment;
    public final static SimpleProperty.String<BPItemPaytData> CA_GROUPING_FOR_PAYMENT =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "CAGroupingForPayment");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardType</b>
     * </p>
     * 
     * @return Payment Card Type
     */
    @Nullable
    @ElementName( "PaymentCardType" )
    private java.lang.String paymentCardType;
    public final static SimpleProperty.String<BPItemPaytData> PAYMENT_CARD_TYPE =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "PaymentCardType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PaytCardByDigitalPaymentSrvc</b>
     * </p>
     * 
     * @return Payment cards: Card number
     */
    @Nullable
    @ElementName( "PaytCardByDigitalPaymentSrvc" )
    private java.lang.String paytCardByDigitalPaymentSrvc;
    public final static SimpleProperty.String<BPItemPaytData> PAYT_CARD_BY_DIGITAL_PAYMENT_SRVC =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "PaytCardByDigitalPaymentSrvc");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardSequenceNumber</b>
     * </p>
     * 
     * @return Payment cards: Payment card suffix
     */
    @Nullable
    @ElementName( "PaymentCardSequenceNumber" )
    private java.lang.String paymentCardSequenceNumber;
    public final static SimpleProperty.String<BPItemPaytData> PAYMENT_CARD_SEQUENCE_NUMBER =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "PaymentCardSequenceNumber");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardValidityStartDate</b>
     * </p>
     * 
     * @return Payment cards: Valid from
     */
    @Nullable
    @ElementName( "PaymentCardValidityStartDate" )
    private LocalDate paymentCardValidityStartDate;
    public final static SimpleProperty.Date<BPItemPaytData> PAYMENT_CARD_VALIDITY_START_DATE =
        new SimpleProperty.Date<BPItemPaytData>(BPItemPaytData.class, "PaymentCardValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardValidityEndDate</b>
     * </p>
     * 
     * @return Payment Cards: Valid To
     */
    @Nullable
    @ElementName( "PaymentCardValidityEndDate" )
    private LocalDate paymentCardValidityEndDate;
    public final static SimpleProperty.Date<BPItemPaytData> PAYMENT_CARD_VALIDITY_END_DATE =
        new SimpleProperty.Date<BPItemPaytData>(BPItemPaytData.class, "PaymentCardValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardHolderName</b>
     * </p>
     * 
     * @return Payment Cards: Name of Cardholder
     */
    @Nullable
    @ElementName( "PaymentCardHolderName" )
    private java.lang.String paymentCardHolderName;
    public final static SimpleProperty.String<BPItemPaytData> PAYMENT_CARD_HOLDER_NAME =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "PaymentCardHolderName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardMaskedNumber</b>
     * </p>
     * 
     * @return Masked Payment Card Number ( Digital Payment )
     */
    @Nullable
    @ElementName( "PaymentCardMaskedNumber" )
    private java.lang.String paymentCardMaskedNumber;
    public final static SimpleProperty.String<BPItemPaytData> PAYMENT_CARD_MASKED_NUMBER =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "PaymentCardMaskedNumber");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthznByDigitalPaytSrvc</b>
     * </p>
     * 
     * @return Payment cards: Authorization number
     */
    @Nullable
    @ElementName( "CAAuthznByDigitalPaytSrvc" )
    private java.lang.String cAAuthznByDigitalPaytSrvc;
    public final static SimpleProperty.String<BPItemPaytData> CA_AUTHZN_BY_DIGITAL_PAYT_SRVC =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "CAAuthznByDigitalPaytSrvc");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationByAcquirer</b>
     * </p>
     * 
     * @return Payment Cards: Authorization Reference Number
     */
    @Nullable
    @ElementName( "CAAuthorizationByAcquirer" )
    private java.lang.String cAAuthorizationByAcquirer;
    public final static SimpleProperty.String<BPItemPaytData> CA_AUTHORIZATION_BY_ACQUIRER =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "CAAuthorizationByAcquirer");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationDate</b>
     * </p>
     * 
     * @return Payment cards: Authorization date
     */
    @Nullable
    @ElementName( "AuthorizationDate" )
    private LocalDate authorizationDate;
    public final static SimpleProperty.Date<BPItemPaytData> AUTHORIZATION_DATE =
        new SimpleProperty.Date<BPItemPaytData>(BPItemPaytData.class, "AuthorizationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationTime</b>
     * </p>
     * 
     * @return Payment cards: Authorization time
     */
    @Nullable
    @ElementName( "AuthorizationTime" )
    private LocalTime authorizationTime;
    public final static SimpleProperty.Time<BPItemPaytData> AUTHORIZATION_TIME =
        new SimpleProperty.Time<BPItemPaytData>(BPItemPaytData.class, "AuthorizationTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationType</b>
     * </p>
     * 
     * @return Payment cards: Authorization type
     */
    @Nullable
    @ElementName( "CAAuthorizationType" )
    private java.lang.String cAAuthorizationType;
    public final static SimpleProperty.String<BPItemPaytData> CA_AUTHORIZATION_TYPE =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "CAAuthorizationType");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizedAmountInAuthznCrcy</b>
     * </p>
     * 
     * @return The authorizedAmountInAuthznCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "AuthorizedAmountInAuthznCrcy" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal authorizedAmountInAuthznCrcy;
    public final static SimpleProperty.NumericDecimal<BPItemPaytData> AUTHORIZED_AMOUNT_IN_AUTHZN_CRCY =
        new SimpleProperty.NumericDecimal<BPItemPaytData>(BPItemPaytData.class, "AuthorizedAmountInAuthznCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationCurrency</b>
     * </p>
     * 
     * @return Currency Key
     */
    @Nullable
    @ElementName( "AuthorizationCurrency" )
    private java.lang.String authorizationCurrency;
    public final static SimpleProperty.String<BPItemPaytData> AUTHORIZATION_CURRENCY =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "AuthorizationCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>MerchantByClearingHouse</b>
     * </p>
     * 
     * @return Payment cards: Merchant ID at the clearing house
     */
    @Nullable
    @ElementName( "MerchantByClearingHouse" )
    private java.lang.String merchantByClearingHouse;
    public final static SimpleProperty.String<BPItemPaytData> MERCHANT_BY_CLEARING_HOUSE =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "MerchantByClearingHouse");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationExpirationDate</b>
     * </p>
     * 
     * @return Payment Cards: Authorization Expiry Date
     */
    @Nullable
    @ElementName( "AuthorizationExpirationDate" )
    private LocalDate authorizationExpirationDate;
    public final static SimpleProperty.Date<BPItemPaytData> AUTHORIZATION_EXPIRATION_DATE =
        new SimpleProperty.Date<BPItemPaytData>(BPItemPaytData.class, "AuthorizationExpirationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationExpirationTime</b>
     * </p>
     * 
     * @return Payment Cards: Authorization Expiration Time
     */
    @Nullable
    @ElementName( "AuthorizationExpirationTime" )
    private LocalTime authorizationExpirationTime;
    public final static SimpleProperty.Time<BPItemPaytData> AUTHORIZATION_EXPIRATION_TIME =
        new SimpleProperty.Time<BPItemPaytData>(BPItemPaytData.class, "AuthorizationExpirationTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentIDAuthznWithBilling</b>
     * </p>
     * 
     * @return Payment Cards: Payment ID (Authorization with Billing)
     */
    @Nullable
    @ElementName( "CAPaymentIDAuthznWithBilling" )
    private java.lang.String cAPaymentIDAuthznWithBilling;
    public final static SimpleProperty.String<BPItemPaytData> CA_PAYMENT_ID_AUTHZN_WITH_BILLING =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "CAPaymentIDAuthznWithBilling");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardUUID</b>
     * </p>
     * 
     * @return GUID of a Payment Card
     */
    @Nullable
    @ElementName( "PaymentCardUUID" )
    private UUID paymentCardUUID;
    public final static SimpleProperty.Guid<BPItemPaytData> PAYMENT_CARD_UUID =
        new SimpleProperty.Guid<BPItemPaytData>(BPItemPaytData.class, "PaymentCardUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EncryptionType</b>
     * </p>
     * 
     * @return Type of Encryption
     */
    @Nullable
    @ElementName( "EncryptionType" )
    private java.lang.String encryptionType;
    public final static SimpleProperty.String<BPItemPaytData> ENCRYPTION_TYPE =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "EncryptionType");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAKeyForPaymentCardSupplement</b>
     * </p>
     * 
     * @return Key for Payment Card Supplement
     */
    @Nullable
    @ElementName( "CAKeyForPaymentCardSupplement" )
    private UUID cAKeyForPaymentCardSupplement;
    public final static SimpleProperty.Guid<BPItemPaytData> CA_KEY_FOR_PAYMENT_CARD_SUPPLEMENT =
        new SimpleProperty.Guid<BPItemPaytData>(BPItemPaytData.class, "CAKeyForPaymentCardSupplement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentServiceProvider</b>
     * </p>
     * 
     * @return Payment Service Providers
     */
    @Nullable
    @ElementName( "PaymentServiceProvider" )
    private java.lang.String paymentServiceProvider;
    public final static SimpleProperty.String<BPItemPaytData> PAYMENT_SERVICE_PROVIDER =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "PaymentServiceProvider");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PaymentRefByPaytSrvcProvider</b>
     * </p>
     * 
     * @return Payment Reference of Payment Service Provider
     */
    @Nullable
    @ElementName( "PaymentRefByPaytSrvcProvider" )
    private java.lang.String paymentRefByPaytSrvcProvider;
    public final static SimpleProperty.String<BPItemPaytData> PAYMENT_REF_BY_PAYT_SRVC_PROVIDER =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "PaymentRefByPaytSrvcProvider");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OriglPaytRefByPaytSrvcProvider</b>
     * </p>
     * 
     * @return Payment Reference of Payment Service Provider
     */
    @Nullable
    @ElementName( "OriglPaytRefByPaytSrvcProvider" )
    private java.lang.String origlPaytRefByPaytSrvcProvider;
    public final static SimpleProperty.String<BPItemPaytData> ORIGL_PAYT_REF_BY_PAYT_SRVC_PROVIDER =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "OriglPaytRefByPaytSrvcProvider");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OriginalSourceOfCredit</b>
     * </p>
     * 
     * @return Origin of Credit Memo Posting
     */
    @Nullable
    @ElementName( "OriginalSourceOfCredit" )
    private java.lang.String originalSourceOfCredit;
    public final static SimpleProperty.String<BPItemPaytData> ORIGINAL_SOURCE_OF_CREDIT =
        new SimpleProperty.String<BPItemPaytData>(BPItemPaytData.class, "OriginalSourceOfCredit");
    /**
     * Navigation property <b>_DocHeader</b> for <b>BPItemPaytData</b> to single <b>DocumentHeader</b>.
     * 
     */
    @ElementName( "_DocHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DocumentHeader to_DocHeader;
    /**
     * Use with available request builders to apply the <b>_DocHeader</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BPItemPaytData, DocumentHeader> TO__DOC_HEADER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BPItemPaytData, DocumentHeader>(
            BPItemPaytData.class,
            "_DocHeader",
            DocumentHeader.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BPItemPaytData> getType()
    {
        return BPItemPaytData.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @param cADocumentNumber
     *            Number of a FI-CA Document
     */
    public void setCADocumentNumber( @Nullable final java.lang.String cADocumentNumber )
    {
        rememberChangedField("CADocumentNumber", this.cADocumentNumber);
        this.cADocumentNumber = cADocumentNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingForPayment</b>
     * </p>
     * 
     * @param cAGroupingForPayment
     *            Grouping field for automatic payments
     */
    public void setCAGroupingForPayment( @Nullable final java.lang.String cAGroupingForPayment )
    {
        rememberChangedField("CAGroupingForPayment", this.cAGroupingForPayment);
        this.cAGroupingForPayment = cAGroupingForPayment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardType</b>
     * </p>
     * 
     * @param paymentCardType
     *            Payment Card Type
     */
    public void setPaymentCardType( @Nullable final java.lang.String paymentCardType )
    {
        rememberChangedField("PaymentCardType", this.paymentCardType);
        this.paymentCardType = paymentCardType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PaytCardByDigitalPaymentSrvc</b>
     * </p>
     * 
     * @param paytCardByDigitalPaymentSrvc
     *            Payment cards: Card number
     */
    public void setPaytCardByDigitalPaymentSrvc( @Nullable final java.lang.String paytCardByDigitalPaymentSrvc )
    {
        rememberChangedField("PaytCardByDigitalPaymentSrvc", this.paytCardByDigitalPaymentSrvc);
        this.paytCardByDigitalPaymentSrvc = paytCardByDigitalPaymentSrvc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardSequenceNumber</b>
     * </p>
     * 
     * @param paymentCardSequenceNumber
     *            Payment cards: Payment card suffix
     */
    public void setPaymentCardSequenceNumber( @Nullable final java.lang.String paymentCardSequenceNumber )
    {
        rememberChangedField("PaymentCardSequenceNumber", this.paymentCardSequenceNumber);
        this.paymentCardSequenceNumber = paymentCardSequenceNumber;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardValidityStartDate</b>
     * </p>
     * 
     * @param paymentCardValidityStartDate
     *            Payment cards: Valid from
     */
    public void setPaymentCardValidityStartDate( @Nullable final LocalDate paymentCardValidityStartDate )
    {
        rememberChangedField("PaymentCardValidityStartDate", this.paymentCardValidityStartDate);
        this.paymentCardValidityStartDate = paymentCardValidityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardValidityEndDate</b>
     * </p>
     * 
     * @param paymentCardValidityEndDate
     *            Payment Cards: Valid To
     */
    public void setPaymentCardValidityEndDate( @Nullable final LocalDate paymentCardValidityEndDate )
    {
        rememberChangedField("PaymentCardValidityEndDate", this.paymentCardValidityEndDate);
        this.paymentCardValidityEndDate = paymentCardValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardHolderName</b>
     * </p>
     * 
     * @param paymentCardHolderName
     *            Payment Cards: Name of Cardholder
     */
    public void setPaymentCardHolderName( @Nullable final java.lang.String paymentCardHolderName )
    {
        rememberChangedField("PaymentCardHolderName", this.paymentCardHolderName);
        this.paymentCardHolderName = paymentCardHolderName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardMaskedNumber</b>
     * </p>
     * 
     * @param paymentCardMaskedNumber
     *            Masked Payment Card Number ( Digital Payment )
     */
    public void setPaymentCardMaskedNumber( @Nullable final java.lang.String paymentCardMaskedNumber )
    {
        rememberChangedField("PaymentCardMaskedNumber", this.paymentCardMaskedNumber);
        this.paymentCardMaskedNumber = paymentCardMaskedNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthznByDigitalPaytSrvc</b>
     * </p>
     * 
     * @param cAAuthznByDigitalPaytSrvc
     *            Payment cards: Authorization number
     */
    public void setCAAuthznByDigitalPaytSrvc( @Nullable final java.lang.String cAAuthznByDigitalPaytSrvc )
    {
        rememberChangedField("CAAuthznByDigitalPaytSrvc", this.cAAuthznByDigitalPaytSrvc);
        this.cAAuthznByDigitalPaytSrvc = cAAuthznByDigitalPaytSrvc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationByAcquirer</b>
     * </p>
     * 
     * @param cAAuthorizationByAcquirer
     *            Payment Cards: Authorization Reference Number
     */
    public void setCAAuthorizationByAcquirer( @Nullable final java.lang.String cAAuthorizationByAcquirer )
    {
        rememberChangedField("CAAuthorizationByAcquirer", this.cAAuthorizationByAcquirer);
        this.cAAuthorizationByAcquirer = cAAuthorizationByAcquirer;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationDate</b>
     * </p>
     * 
     * @param authorizationDate
     *            Payment cards: Authorization date
     */
    public void setAuthorizationDate( @Nullable final LocalDate authorizationDate )
    {
        rememberChangedField("AuthorizationDate", this.authorizationDate);
        this.authorizationDate = authorizationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationTime</b>
     * </p>
     * 
     * @param authorizationTime
     *            Payment cards: Authorization time
     */
    public void setAuthorizationTime( @Nullable final LocalTime authorizationTime )
    {
        rememberChangedField("AuthorizationTime", this.authorizationTime);
        this.authorizationTime = authorizationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationType</b>
     * </p>
     * 
     * @param cAAuthorizationType
     *            Payment cards: Authorization type
     */
    public void setCAAuthorizationType( @Nullable final java.lang.String cAAuthorizationType )
    {
        rememberChangedField("CAAuthorizationType", this.cAAuthorizationType);
        this.cAAuthorizationType = cAAuthorizationType;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizedAmountInAuthznCrcy</b>
     * </p>
     * 
     * @param authorizedAmountInAuthznCrcy
     *            The authorizedAmountInAuthznCrcy to set.
     */
    public void setAuthorizedAmountInAuthznCrcy( @Nullable final BigDecimal authorizedAmountInAuthznCrcy )
    {
        rememberChangedField("AuthorizedAmountInAuthznCrcy", this.authorizedAmountInAuthznCrcy);
        this.authorizedAmountInAuthznCrcy = authorizedAmountInAuthznCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationCurrency</b>
     * </p>
     * 
     * @param authorizationCurrency
     *            Currency Key
     */
    public void setAuthorizationCurrency( @Nullable final java.lang.String authorizationCurrency )
    {
        rememberChangedField("AuthorizationCurrency", this.authorizationCurrency);
        this.authorizationCurrency = authorizationCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>MerchantByClearingHouse</b>
     * </p>
     * 
     * @param merchantByClearingHouse
     *            Payment cards: Merchant ID at the clearing house
     */
    public void setMerchantByClearingHouse( @Nullable final java.lang.String merchantByClearingHouse )
    {
        rememberChangedField("MerchantByClearingHouse", this.merchantByClearingHouse);
        this.merchantByClearingHouse = merchantByClearingHouse;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationExpirationDate</b>
     * </p>
     * 
     * @param authorizationExpirationDate
     *            Payment Cards: Authorization Expiry Date
     */
    public void setAuthorizationExpirationDate( @Nullable final LocalDate authorizationExpirationDate )
    {
        rememberChangedField("AuthorizationExpirationDate", this.authorizationExpirationDate);
        this.authorizationExpirationDate = authorizationExpirationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationExpirationTime</b>
     * </p>
     * 
     * @param authorizationExpirationTime
     *            Payment Cards: Authorization Expiration Time
     */
    public void setAuthorizationExpirationTime( @Nullable final LocalTime authorizationExpirationTime )
    {
        rememberChangedField("AuthorizationExpirationTime", this.authorizationExpirationTime);
        this.authorizationExpirationTime = authorizationExpirationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentIDAuthznWithBilling</b>
     * </p>
     * 
     * @param cAPaymentIDAuthznWithBilling
     *            Payment Cards: Payment ID (Authorization with Billing)
     */
    public void setCAPaymentIDAuthznWithBilling( @Nullable final java.lang.String cAPaymentIDAuthznWithBilling )
    {
        rememberChangedField("CAPaymentIDAuthznWithBilling", this.cAPaymentIDAuthznWithBilling);
        this.cAPaymentIDAuthznWithBilling = cAPaymentIDAuthznWithBilling;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardUUID</b>
     * </p>
     * 
     * @param paymentCardUUID
     *            GUID of a Payment Card
     */
    public void setPaymentCardUUID( @Nullable final UUID paymentCardUUID )
    {
        rememberChangedField("PaymentCardUUID", this.paymentCardUUID);
        this.paymentCardUUID = paymentCardUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EncryptionType</b>
     * </p>
     * 
     * @param encryptionType
     *            Type of Encryption
     */
    public void setEncryptionType( @Nullable final java.lang.String encryptionType )
    {
        rememberChangedField("EncryptionType", this.encryptionType);
        this.encryptionType = encryptionType;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAKeyForPaymentCardSupplement</b>
     * </p>
     * 
     * @param cAKeyForPaymentCardSupplement
     *            Key for Payment Card Supplement
     */
    public void setCAKeyForPaymentCardSupplement( @Nullable final UUID cAKeyForPaymentCardSupplement )
    {
        rememberChangedField("CAKeyForPaymentCardSupplement", this.cAKeyForPaymentCardSupplement);
        this.cAKeyForPaymentCardSupplement = cAKeyForPaymentCardSupplement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentServiceProvider</b>
     * </p>
     * 
     * @param paymentServiceProvider
     *            Payment Service Providers
     */
    public void setPaymentServiceProvider( @Nullable final java.lang.String paymentServiceProvider )
    {
        rememberChangedField("PaymentServiceProvider", this.paymentServiceProvider);
        this.paymentServiceProvider = paymentServiceProvider;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PaymentRefByPaytSrvcProvider</b>
     * </p>
     * 
     * @param paymentRefByPaytSrvcProvider
     *            Payment Reference of Payment Service Provider
     */
    public void setPaymentRefByPaytSrvcProvider( @Nullable final java.lang.String paymentRefByPaytSrvcProvider )
    {
        rememberChangedField("PaymentRefByPaytSrvcProvider", this.paymentRefByPaytSrvcProvider);
        this.paymentRefByPaytSrvcProvider = paymentRefByPaytSrvcProvider;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OriglPaytRefByPaytSrvcProvider</b>
     * </p>
     * 
     * @param origlPaytRefByPaytSrvcProvider
     *            Payment Reference of Payment Service Provider
     */
    public void setOriglPaytRefByPaytSrvcProvider( @Nullable final java.lang.String origlPaytRefByPaytSrvcProvider )
    {
        rememberChangedField("OriglPaytRefByPaytSrvcProvider", this.origlPaytRefByPaytSrvcProvider);
        this.origlPaytRefByPaytSrvcProvider = origlPaytRefByPaytSrvcProvider;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OriginalSourceOfCredit</b>
     * </p>
     * 
     * @param originalSourceOfCredit
     *            Origin of Credit Memo Posting
     */
    public void setOriginalSourceOfCredit( @Nullable final java.lang.String originalSourceOfCredit )
    {
        rememberChangedField("OriginalSourceOfCredit", this.originalSourceOfCredit);
        this.originalSourceOfCredit = originalSourceOfCredit;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "BPItemPaytData";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentNumber", getCADocumentNumber());
        entityKey.addKeyProperty("CAGroupingForPayment", getCAGroupingForPayment());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentNumber", getCADocumentNumber());
        values.put("CAGroupingForPayment", getCAGroupingForPayment());
        values.put("PaymentCardType", getPaymentCardType());
        values.put("PaytCardByDigitalPaymentSrvc", getPaytCardByDigitalPaymentSrvc());
        values.put("PaymentCardSequenceNumber", getPaymentCardSequenceNumber());
        values.put("PaymentCardValidityStartDate", getPaymentCardValidityStartDate());
        values.put("PaymentCardValidityEndDate", getPaymentCardValidityEndDate());
        values.put("PaymentCardHolderName", getPaymentCardHolderName());
        values.put("PaymentCardMaskedNumber", getPaymentCardMaskedNumber());
        values.put("CAAuthznByDigitalPaytSrvc", getCAAuthznByDigitalPaytSrvc());
        values.put("CAAuthorizationByAcquirer", getCAAuthorizationByAcquirer());
        values.put("AuthorizationDate", getAuthorizationDate());
        values.put("AuthorizationTime", getAuthorizationTime());
        values.put("CAAuthorizationType", getCAAuthorizationType());
        values.put("AuthorizedAmountInAuthznCrcy", getAuthorizedAmountInAuthznCrcy());
        values.put("AuthorizationCurrency", getAuthorizationCurrency());
        values.put("MerchantByClearingHouse", getMerchantByClearingHouse());
        values.put("AuthorizationExpirationDate", getAuthorizationExpirationDate());
        values.put("AuthorizationExpirationTime", getAuthorizationExpirationTime());
        values.put("CAPaymentIDAuthznWithBilling", getCAPaymentIDAuthznWithBilling());
        values.put("PaymentCardUUID", getPaymentCardUUID());
        values.put("EncryptionType", getEncryptionType());
        values.put("CAKeyForPaymentCardSupplement", getCAKeyForPaymentCardSupplement());
        values.put("PaymentServiceProvider", getPaymentServiceProvider());
        values.put("PaymentRefByPaytSrvcProvider", getPaymentRefByPaytSrvcProvider());
        values.put("OriglPaytRefByPaytSrvcProvider", getOriglPaytRefByPaytSrvcProvider());
        values.put("OriginalSourceOfCredit", getOriginalSourceOfCredit());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentNumber") ) {
                final Object value = values.remove("CADocumentNumber");
                if( (value == null) || (!value.equals(getCADocumentNumber())) ) {
                    setCADocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGroupingForPayment") ) {
                final Object value = values.remove("CAGroupingForPayment");
                if( (value == null) || (!value.equals(getCAGroupingForPayment())) ) {
                    setCAGroupingForPayment(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCardType") ) {
                final Object value = values.remove("PaymentCardType");
                if( (value == null) || (!value.equals(getPaymentCardType())) ) {
                    setPaymentCardType(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaytCardByDigitalPaymentSrvc") ) {
                final Object value = values.remove("PaytCardByDigitalPaymentSrvc");
                if( (value == null) || (!value.equals(getPaytCardByDigitalPaymentSrvc())) ) {
                    setPaytCardByDigitalPaymentSrvc(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCardSequenceNumber") ) {
                final Object value = values.remove("PaymentCardSequenceNumber");
                if( (value == null) || (!value.equals(getPaymentCardSequenceNumber())) ) {
                    setPaymentCardSequenceNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCardValidityStartDate") ) {
                final Object value = values.remove("PaymentCardValidityStartDate");
                if( (value == null) || (!value.equals(getPaymentCardValidityStartDate())) ) {
                    setPaymentCardValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("PaymentCardValidityEndDate") ) {
                final Object value = values.remove("PaymentCardValidityEndDate");
                if( (value == null) || (!value.equals(getPaymentCardValidityEndDate())) ) {
                    setPaymentCardValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("PaymentCardHolderName") ) {
                final Object value = values.remove("PaymentCardHolderName");
                if( (value == null) || (!value.equals(getPaymentCardHolderName())) ) {
                    setPaymentCardHolderName(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCardMaskedNumber") ) {
                final Object value = values.remove("PaymentCardMaskedNumber");
                if( (value == null) || (!value.equals(getPaymentCardMaskedNumber())) ) {
                    setPaymentCardMaskedNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAuthznByDigitalPaytSrvc") ) {
                final Object value = values.remove("CAAuthznByDigitalPaytSrvc");
                if( (value == null) || (!value.equals(getCAAuthznByDigitalPaytSrvc())) ) {
                    setCAAuthznByDigitalPaytSrvc(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAuthorizationByAcquirer") ) {
                final Object value = values.remove("CAAuthorizationByAcquirer");
                if( (value == null) || (!value.equals(getCAAuthorizationByAcquirer())) ) {
                    setCAAuthorizationByAcquirer(((java.lang.String) value));
                }
            }
            if( values.containsKey("AuthorizationDate") ) {
                final Object value = values.remove("AuthorizationDate");
                if( (value == null) || (!value.equals(getAuthorizationDate())) ) {
                    setAuthorizationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("AuthorizationTime") ) {
                final Object value = values.remove("AuthorizationTime");
                if( (value == null) || (!value.equals(getAuthorizationTime())) ) {
                    setAuthorizationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CAAuthorizationType") ) {
                final Object value = values.remove("CAAuthorizationType");
                if( (value == null) || (!value.equals(getCAAuthorizationType())) ) {
                    setCAAuthorizationType(((java.lang.String) value));
                }
            }
            if( values.containsKey("AuthorizedAmountInAuthznCrcy") ) {
                final Object value = values.remove("AuthorizedAmountInAuthznCrcy");
                if( (value == null) || (!value.equals(getAuthorizedAmountInAuthznCrcy())) ) {
                    setAuthorizedAmountInAuthznCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("AuthorizationCurrency") ) {
                final Object value = values.remove("AuthorizationCurrency");
                if( (value == null) || (!value.equals(getAuthorizationCurrency())) ) {
                    setAuthorizationCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("MerchantByClearingHouse") ) {
                final Object value = values.remove("MerchantByClearingHouse");
                if( (value == null) || (!value.equals(getMerchantByClearingHouse())) ) {
                    setMerchantByClearingHouse(((java.lang.String) value));
                }
            }
            if( values.containsKey("AuthorizationExpirationDate") ) {
                final Object value = values.remove("AuthorizationExpirationDate");
                if( (value == null) || (!value.equals(getAuthorizationExpirationDate())) ) {
                    setAuthorizationExpirationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("AuthorizationExpirationTime") ) {
                final Object value = values.remove("AuthorizationExpirationTime");
                if( (value == null) || (!value.equals(getAuthorizationExpirationTime())) ) {
                    setAuthorizationExpirationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CAPaymentIDAuthznWithBilling") ) {
                final Object value = values.remove("CAPaymentIDAuthznWithBilling");
                if( (value == null) || (!value.equals(getCAPaymentIDAuthznWithBilling())) ) {
                    setCAPaymentIDAuthznWithBilling(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCardUUID") ) {
                final Object value = values.remove("PaymentCardUUID");
                if( (value == null) || (!value.equals(getPaymentCardUUID())) ) {
                    setPaymentCardUUID(((UUID) value));
                }
            }
            if( values.containsKey("EncryptionType") ) {
                final Object value = values.remove("EncryptionType");
                if( (value == null) || (!value.equals(getEncryptionType())) ) {
                    setEncryptionType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAKeyForPaymentCardSupplement") ) {
                final Object value = values.remove("CAKeyForPaymentCardSupplement");
                if( (value == null) || (!value.equals(getCAKeyForPaymentCardSupplement())) ) {
                    setCAKeyForPaymentCardSupplement(((UUID) value));
                }
            }
            if( values.containsKey("PaymentServiceProvider") ) {
                final Object value = values.remove("PaymentServiceProvider");
                if( (value == null) || (!value.equals(getPaymentServiceProvider())) ) {
                    setPaymentServiceProvider(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentRefByPaytSrvcProvider") ) {
                final Object value = values.remove("PaymentRefByPaytSrvcProvider");
                if( (value == null) || (!value.equals(getPaymentRefByPaytSrvcProvider())) ) {
                    setPaymentRefByPaytSrvcProvider(((java.lang.String) value));
                }
            }
            if( values.containsKey("OriglPaytRefByPaytSrvcProvider") ) {
                final Object value = values.remove("OriglPaytRefByPaytSrvcProvider");
                if( (value == null) || (!value.equals(getOriglPaytRefByPaytSrvcProvider())) ) {
                    setOriglPaytRefByPaytSrvcProvider(((java.lang.String) value));
                }
            }
            if( values.containsKey("OriginalSourceOfCredit") ) {
                final Object value = values.remove("OriginalSourceOfCredit");
                if( (value == null) || (!value.equals(getOriginalSourceOfCredit())) ) {
                    setOriginalSourceOfCredit(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_DocHeader") ) {
                final Object value = (values).remove("_DocHeader");
                if( value instanceof Map ) {
                    if( to_DocHeader == null ) {
                        to_DocHeader = new DocumentHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_DocHeader.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingDocumentManageService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_DocHeader != null ) {
            (values).put("_DocHeader", to_DocHeader);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>DocumentHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_DocHeader</b>.
     * <p>
     * If the navigation property for an entity <b>BPItemPaytData</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_DocHeader</b> is already loaded, the result will contain
     *         the <b>DocumentHeader</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<DocumentHeader> getDocHeaderIfPresent()
    {
        return Option.of(to_DocHeader);
    }

    /**
     * Overwrites the associated <b>DocumentHeader</b> entity for the loaded navigation property <b>_DocHeader</b>.
     * 
     * @param value
     *            New <b>DocumentHeader</b> entity.
     */
    public void setDocHeader( final DocumentHeader value )
    {
        to_DocHeader = value;
    }

    /**
     * Helper class to allow for fluent creation of BPItemPaytData instances.
     * 
     */
    public final static class BPItemPaytDataBuilder
    {

        private DocumentHeader to_DocHeader;

        private BPItemPaytData.BPItemPaytDataBuilder to_DocHeader( final DocumentHeader value )
        {
            to_DocHeader = value;
            return this;
        }

        /**
         * Navigation property <b>_DocHeader</b> for <b>BPItemPaytData</b> to single <b>DocumentHeader</b>.
         * 
         * @param value
         *            The DocumentHeader to build this BPItemPaytData with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BPItemPaytData.BPItemPaytDataBuilder docHeader( final DocumentHeader value )
        {
            return to_DocHeader(value);
        }

    }

}
