/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingDocumentManageService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>DocumentHeaderType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class DocumentHeader extends VdmEntity<DocumentHeader> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_cadocumentmanage.v0001.DocumentHeaderType";
    /**
     * Selector for all available fields of DocumentHeader.
     * 
     */
    public final static SimpleProperty<DocumentHeader> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @return Document
     */
    @Nullable
    @ElementName( "CADocumentNumber" )
    private java.lang.String cADocumentNumber;
    public final static SimpleProperty.String<DocumentHeader> CA_DOCUMENT_NUMBER =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CADocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Created By
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<DocumentHeader> CREATED_BY_USER =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CreatedByUser");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Creation Date
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<DocumentHeader> CREATION_DATE =
        new SimpleProperty.Date<DocumentHeader>(DocumentHeader.class, "CreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @return Creation Time
     */
    @Nullable
    @ElementName( "CreationTime" )
    private LocalTime creationTime;
    public final static SimpleProperty.Time<DocumentHeader> CREATION_TIME =
        new SimpleProperty.Time<DocumentHeader>(DocumentHeader.class, "CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CATaxCompanyCode</b>
     * </p>
     * 
     * @return Tax Company Code
     */
    @Nullable
    @ElementName( "CATaxCompanyCode" )
    private java.lang.String cATaxCompanyCode;
    public final static SimpleProperty.String<DocumentHeader> CA_TAX_COMPANY_CODE =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CATaxCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAStorageLocationOfTaxSuplmnt</b>
     * </p>
     * 
     * @return Storage Location of Tax Supplement for Telco Tax (U.S.A)
     */
    @Nullable
    @ElementName( "CAStorageLocationOfTaxSuplmnt" )
    private java.lang.String cAStorageLocationOfTaxSuplmnt;
    public final static SimpleProperty.String<DocumentHeader> CA_STORAGE_LOCATION_OF_TAX_SUPLMNT =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAStorageLocationOfTaxSuplmnt");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CATaxCodeWasExchanged</b>
     * </p>
     * 
     * @return Tax Codes Were Exchanged
     */
    @Nullable
    @ElementName( "CATaxCodeWasExchanged" )
    private java.lang.Boolean cATaxCodeWasExchanged;
    public final static SimpleProperty.Boolean<DocumentHeader> CA_TAX_CODE_WAS_EXCHANGED =
        new SimpleProperty.Boolean<DocumentHeader>(DocumentHeader.class, "CATaxCodeWasExchanged");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>TaxReportingDate</b>
     * </p>
     * 
     * @return Tax Reporting Date
     */
    @Nullable
    @ElementName( "TaxReportingDate" )
    private LocalDate taxReportingDate;
    public final static SimpleProperty.Date<DocumentHeader> TAX_REPORTING_DATE =
        new SimpleProperty.Date<DocumentHeader>(DocumentHeader.class, "TaxReportingDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAReconciliationKey</b>
     * </p>
     * 
     * @return Reconciliation Key for General Ledger
     */
    @Nullable
    @ElementName( "CAReconciliationKey" )
    private java.lang.String cAReconciliationKey;
    public final static SimpleProperty.String<DocumentHeader> CA_RECONCILIATION_KEY =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAReconciliationKey");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASeparateDocIsCreatedInGL</b>
     * </p>
     * 
     * @return Create Separate Document in General Ledger
     */
    @Nullable
    @ElementName( "CASeparateDocIsCreatedInGL" )
    private java.lang.Boolean cASeparateDocIsCreatedInGL;
    public final static SimpleProperty.Boolean<DocumentHeader> CA_SEPARATE_DOC_IS_CREATED_IN_GL =
        new SimpleProperty.Boolean<DocumentHeader>(DocumentHeader.class, "CASeparateDocIsCreatedInGL");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CARequestedPeriodForGLTransfer</b>
     * </p>
     * 
     * @return Requested Special Period for Transfer to General Ledger
     */
    @Nullable
    @ElementName( "CARequestedPeriodForGLTransfer" )
    private java.lang.String cARequestedPeriodForGLTransfer;
    public final static SimpleProperty.String<DocumentHeader> CA_REQUESTED_PERIOD_FOR_GL_TRANSFER =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CARequestedPeriodForGLTransfer");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAApplicationArea</b>
     * </p>
     * 
     * @return Application area
     */
    @Nullable
    @ElementName( "CAApplicationArea" )
    private java.lang.String cAApplicationArea;
    public final static SimpleProperty.String<DocumentHeader> CA_APPLICATION_AREA =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAApplicationArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentType</b>
     * </p>
     * 
     * @return Document Type
     */
    @Nullable
    @ElementName( "CADocumentType" )
    private java.lang.String cADocumentType;
    public final static SimpleProperty.String<DocumentHeader> CA_DOCUMENT_TYPE =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CADocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCode</b>
     * </p>
     * 
     * @return Document Origin Key
     */
    @Nullable
    @ElementName( "CADocumentOriginCode" )
    private java.lang.String cADocumentOriginCode;
    public final static SimpleProperty.String<DocumentHeader> CA_DOCUMENT_ORIGIN_CODE =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CADocumentOriginCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCodeName</b>
     * </p>
     * 
     * @return Description of Document Origin
     */
    @Nullable
    @ElementName( "CADocumentOriginCodeName" )
    private java.lang.String cADocumentOriginCodeName;
    public final static SimpleProperty.String<DocumentHeader> CA_DOCUMENT_ORIGIN_CODE_NAME =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CADocumentOriginCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @return Transaction Currency
     */
    @Nullable
    @ElementName( "TransactionCurrency" )
    private java.lang.String transactionCurrency;
    public final static SimpleProperty.String<DocumentHeader> TRANSACTION_CURRENCY =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "TransactionCurrency");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     * 
     * @return Journal Entry Date
     */
    @Nullable
    @ElementName( "DocumentDate" )
    private LocalDate documentDate;
    public final static SimpleProperty.Date<DocumentHeader> DOCUMENT_DATE =
        new SimpleProperty.Date<DocumentHeader>(DocumentHeader.class, "DocumentDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDate</b>
     * </p>
     * 
     * @return Posting Date in the Document
     */
    @Nullable
    @ElementName( "CAPostingDate" )
    private LocalDate cAPostingDate;
    public final static SimpleProperty.Date<DocumentHeader> CA_POSTING_DATE =
        new SimpleProperty.Date<DocumentHeader>(DocumentHeader.class, "CAPostingDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     * 
     * @return Exchange Rate Date
     */
    @Nullable
    @ElementName( "ExchangeRateDate" )
    private LocalDate exchangeRateDate;
    public final static SimpleProperty.Date<DocumentHeader> EXCHANGE_RATE_DATE =
        new SimpleProperty.Date<DocumentHeader>(DocumentHeader.class, "ExchangeRateDate");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CAReferenceDocument</b>
     * </p>
     * 
     * @return Reference Document Number
     */
    @Nullable
    @ElementName( "CAReferenceDocument" )
    private java.lang.String cAReferenceDocument;
    public final static SimpleProperty.String<DocumentHeader> CA_REFERENCE_DOCUMENT =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CAReturnReason</b>
     * </p>
     * 
     * @return Return Reason
     */
    @Nullable
    @ElementName( "CAReturnReason" )
    private java.lang.String cAReturnReason;
    public final static SimpleProperty.String<DocumentHeader> CA_RETURN_REASON =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAReturnReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingReason</b>
     * </p>
     * 
     * @return Posting Reason (For Write-Offs And Transfer Postings)
     */
    @Nullable
    @ElementName( "CAPostingReason" )
    private java.lang.String cAPostingReason;
    public final static SimpleProperty.String<DocumentHeader> CA_POSTING_REASON =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAPostingReason");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     * 
     * @return Reference Document Type
     */
    @Nullable
    @ElementName( "ReferenceDocumentType" )
    private java.lang.String referenceDocumentType;
    public final static SimpleProperty.String<DocumentHeader> REFERENCE_DOCUMENT_TYPE =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OriginalReferenceDocument</b>
     * </p>
     * 
     * @return Object key
     */
    @Nullable
    @ElementName( "OriginalReferenceDocument" )
    private java.lang.String originalReferenceDocument;
    public final static SimpleProperty.String<DocumentHeader> ORIGINAL_REFERENCE_DOCUMENT =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "OriginalReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAReversedDocumentNumber</b>
     * </p>
     * 
     * @return Number of Reversed Document
     */
    @Nullable
    @ElementName( "CAReversedDocumentNumber" )
    private java.lang.String cAReversedDocumentNumber;
    public final static SimpleProperty.String<DocumentHeader> CA_REVERSED_DOCUMENT_NUMBER =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAReversedDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingInformation</b>
     * </p>
     * 
     * @return Clearing Information
     */
    @Nullable
    @ElementName( "CAClearingInformation" )
    private java.lang.String cAClearingInformation;
    public final static SimpleProperty.String<DocumentHeader> CA_CLEARING_INFORMATION =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAClearingInformation");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAReversalDocumentNumber</b>
     * </p>
     * 
     * @return Reversal Document
     */
    @Nullable
    @ElementName( "CAReversalDocumentNumber" )
    private java.lang.String cAReversalDocumentNumber;
    public final static SimpleProperty.String<DocumentHeader> CA_REVERSAL_DOCUMENT_NUMBER =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAReversalDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentSupplements</b>
     * </p>
     * 
     * @return Existing document supplements
     */
    @Nullable
    @ElementName( "CADocumentSupplements" )
    private java.lang.String cADocumentSupplements;
    public final static SimpleProperty.String<DocumentHeader> CA_DOCUMENT_SUPPLEMENTS =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CADocumentSupplements");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     * 
     * @return Logical system of source document
     */
    @Nullable
    @ElementName( "LogicalSystem" )
    private java.lang.String logicalSystem;
    public final static SimpleProperty.String<DocumentHeader> LOGICAL_SYSTEM =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAWorkflowCheckReason</b>
     * </p>
     * 
     * @return Check Reason for Workflows Acc. to Dual Control Principle
     */
    @Nullable
    @ElementName( "CAWorkflowCheckReason" )
    private java.lang.String cAWorkflowCheckReason;
    public final static SimpleProperty.String<DocumentHeader> CA_WORKFLOW_CHECK_REASON =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAWorkflowCheckReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAWorkflowCheckProcess</b>
     * </p>
     * 
     * @return Editing Process To Be Confirmed
     */
    @Nullable
    @ElementName( "CAWorkflowCheckProcess" )
    private java.lang.String cAWorkflowCheckProcess;
    public final static SimpleProperty.String<DocumentHeader> CA_WORKFLOW_CHECK_PROCESS =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CAWorkflowCheckProcess");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentTransactionClass</b>
     * </p>
     * 
     * @return Transaction Class of Document
     */
    @Nullable
    @ElementName( "CADocumentTransactionClass" )
    private java.lang.String cADocumentTransactionClass;
    public final static SimpleProperty.String<DocumentHeader> CA_DOCUMENT_TRANSACTION_CLASS =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CADocumentTransactionClass");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainsCashFlowItems</b>
     * </p>
     * 
     * @return Document Contains Assignments from Cash Flows
     */
    @Nullable
    @ElementName( "CADocContainsCashFlowItems" )
    private java.lang.Boolean cADocContainsCashFlowItems;
    public final static SimpleProperty.Boolean<DocumentHeader> CA_DOC_CONTAINS_CASH_FLOW_ITEMS =
        new SimpleProperty.Boolean<DocumentHeader>(DocumentHeader.class, "CADocContainsCashFlowItems");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentClass</b>
     * </p>
     * 
     * @return Document Class
     */
    @Nullable
    @ElementName( "CADocumentClass" )
    private java.lang.String cADocumentClass;
    public final static SimpleProperty.String<DocumentHeader> CA_DOCUMENT_CLASS =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CADocumentClass");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentVersion</b>
     * </p>
     * 
     * @return Version Number
     */
    @Nullable
    @ElementName( "CADocumentVersion" )
    private java.lang.String cADocumentVersion;
    public final static SimpleProperty.String<DocumentHeader> CA_DOCUMENT_VERSION =
        new SimpleProperty.String<DocumentHeader>(DocumentHeader.class, "CADocumentVersion");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsIndividualPosting</b>
     * </p>
     * 
     * @return Individual Posting
     */
    @Nullable
    @ElementName( "IsIndividualPosting" )
    private java.lang.Boolean isIndividualPosting;
    public final static SimpleProperty.Boolean<DocumentHeader> IS_INDIVIDUAL_POSTING =
        new SimpleProperty.Boolean<DocumentHeader>(DocumentHeader.class, "IsIndividualPosting");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentIsAged</b>
     * </p>
     * 
     * @return Data Aging: Document was already in historical area
     */
    @Nullable
    @ElementName( "CADocumentIsAged" )
    private java.lang.Boolean cADocumentIsAged;
    public final static SimpleProperty.Boolean<DocumentHeader> CA_DOCUMENT_IS_AGED =
        new SimpleProperty.Boolean<DocumentHeader>(DocumentHeader.class, "CADocumentIsAged");
    /**
     * Navigation property <b>_BPItem</b> for <b>DocumentHeader</b> to multiple <b>BPItemLogical</b>.
     * 
     */
    @ElementName( "_BPItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BPItemLogical> to_BPItem;
    /**
     * Navigation property <b>_BPItemPaytData</b> for <b>DocumentHeader</b> to multiple <b>BPItemPaytData</b>.
     * 
     */
    @ElementName( "_BPItemPaytData" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BPItemPaytData> to_BPItemPaytData;
    /**
     * Navigation property <b>_GLItem</b> for <b>DocumentHeader</b> to multiple <b>GLItem</b>.
     * 
     */
    @ElementName( "_GLItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GLItem> to_GLItem;
    /**
     * Navigation property <b>_GLItemPaytData</b> for <b>DocumentHeader</b> to multiple <b>GLItemPaytData</b>.
     * 
     */
    @ElementName( "_GLItemPaytData" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<GLItemPaytData> to_GLItemPaytData;
    /**
     * Use with available request builders to apply the <b>_BPItem</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<DocumentHeader, BPItemLogical> TO__B_P_ITEM =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<DocumentHeader, BPItemLogical>(
            DocumentHeader.class,
            "_BPItem",
            BPItemLogical.class);
    /**
     * Use with available request builders to apply the <b>_BPItemPaytData</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<DocumentHeader, BPItemPaytData> TO__B_P_ITEM_PAYT_DATA =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<DocumentHeader, BPItemPaytData>(
            DocumentHeader.class,
            "_BPItemPaytData",
            BPItemPaytData.class);
    /**
     * Use with available request builders to apply the <b>_GLItem</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<DocumentHeader, GLItem> TO__G_L_ITEM =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<DocumentHeader, GLItem>(
            DocumentHeader.class,
            "_GLItem",
            GLItem.class);
    /**
     * Use with available request builders to apply the <b>_GLItemPaytData</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<DocumentHeader, GLItemPaytData> TO__G_L_ITEM_PAYT_DATA =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<DocumentHeader, GLItemPaytData>(
            DocumentHeader.class,
            "_GLItemPaytData",
            GLItemPaytData.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<DocumentHeader> getType()
    {
        return DocumentHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @param cADocumentNumber
     *            Document
     */
    public void setCADocumentNumber( @Nullable final java.lang.String cADocumentNumber )
    {
        rememberChangedField("CADocumentNumber", this.cADocumentNumber);
        this.cADocumentNumber = cADocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Creation Date
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @param creationTime
     *            Creation Time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CATaxCompanyCode</b>
     * </p>
     * 
     * @param cATaxCompanyCode
     *            Tax Company Code
     */
    public void setCATaxCompanyCode( @Nullable final java.lang.String cATaxCompanyCode )
    {
        rememberChangedField("CATaxCompanyCode", this.cATaxCompanyCode);
        this.cATaxCompanyCode = cATaxCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAStorageLocationOfTaxSuplmnt</b>
     * </p>
     * 
     * @param cAStorageLocationOfTaxSuplmnt
     *            Storage Location of Tax Supplement for Telco Tax (U.S.A)
     */
    public void setCAStorageLocationOfTaxSuplmnt( @Nullable final java.lang.String cAStorageLocationOfTaxSuplmnt )
    {
        rememberChangedField("CAStorageLocationOfTaxSuplmnt", this.cAStorageLocationOfTaxSuplmnt);
        this.cAStorageLocationOfTaxSuplmnt = cAStorageLocationOfTaxSuplmnt;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CATaxCodeWasExchanged</b>
     * </p>
     * 
     * @param cATaxCodeWasExchanged
     *            Tax Codes Were Exchanged
     */
    public void setCATaxCodeWasExchanged( @Nullable final java.lang.Boolean cATaxCodeWasExchanged )
    {
        rememberChangedField("CATaxCodeWasExchanged", this.cATaxCodeWasExchanged);
        this.cATaxCodeWasExchanged = cATaxCodeWasExchanged;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>TaxReportingDate</b>
     * </p>
     * 
     * @param taxReportingDate
     *            Tax Reporting Date
     */
    public void setTaxReportingDate( @Nullable final LocalDate taxReportingDate )
    {
        rememberChangedField("TaxReportingDate", this.taxReportingDate);
        this.taxReportingDate = taxReportingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAReconciliationKey</b>
     * </p>
     * 
     * @param cAReconciliationKey
     *            Reconciliation Key for General Ledger
     */
    public void setCAReconciliationKey( @Nullable final java.lang.String cAReconciliationKey )
    {
        rememberChangedField("CAReconciliationKey", this.cAReconciliationKey);
        this.cAReconciliationKey = cAReconciliationKey;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASeparateDocIsCreatedInGL</b>
     * </p>
     * 
     * @param cASeparateDocIsCreatedInGL
     *            Create Separate Document in General Ledger
     */
    public void setCASeparateDocIsCreatedInGL( @Nullable final java.lang.Boolean cASeparateDocIsCreatedInGL )
    {
        rememberChangedField("CASeparateDocIsCreatedInGL", this.cASeparateDocIsCreatedInGL);
        this.cASeparateDocIsCreatedInGL = cASeparateDocIsCreatedInGL;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CARequestedPeriodForGLTransfer</b>
     * </p>
     * 
     * @param cARequestedPeriodForGLTransfer
     *            Requested Special Period for Transfer to General Ledger
     */
    public void setCARequestedPeriodForGLTransfer( @Nullable final java.lang.String cARequestedPeriodForGLTransfer )
    {
        rememberChangedField("CARequestedPeriodForGLTransfer", this.cARequestedPeriodForGLTransfer);
        this.cARequestedPeriodForGLTransfer = cARequestedPeriodForGLTransfer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAApplicationArea</b>
     * </p>
     * 
     * @param cAApplicationArea
     *            Application area
     */
    public void setCAApplicationArea( @Nullable final java.lang.String cAApplicationArea )
    {
        rememberChangedField("CAApplicationArea", this.cAApplicationArea);
        this.cAApplicationArea = cAApplicationArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentType</b>
     * </p>
     * 
     * @param cADocumentType
     *            Document Type
     */
    public void setCADocumentType( @Nullable final java.lang.String cADocumentType )
    {
        rememberChangedField("CADocumentType", this.cADocumentType);
        this.cADocumentType = cADocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCode</b>
     * </p>
     * 
     * @param cADocumentOriginCode
     *            Document Origin Key
     */
    public void setCADocumentOriginCode( @Nullable final java.lang.String cADocumentOriginCode )
    {
        rememberChangedField("CADocumentOriginCode", this.cADocumentOriginCode);
        this.cADocumentOriginCode = cADocumentOriginCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentOriginCodeName</b>
     * </p>
     * 
     * @param cADocumentOriginCodeName
     *            Description of Document Origin
     */
    public void setCADocumentOriginCodeName( @Nullable final java.lang.String cADocumentOriginCodeName )
    {
        rememberChangedField("CADocumentOriginCodeName", this.cADocumentOriginCodeName);
        this.cADocumentOriginCodeName = cADocumentOriginCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final java.lang.String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     * 
     * @param documentDate
     *            Journal Entry Date
     */
    public void setDocumentDate( @Nullable final LocalDate documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDate</b>
     * </p>
     * 
     * @param cAPostingDate
     *            Posting Date in the Document
     */
    public void setCAPostingDate( @Nullable final LocalDate cAPostingDate )
    {
        rememberChangedField("CAPostingDate", this.cAPostingDate);
        this.cAPostingDate = cAPostingDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     * 
     * @param exchangeRateDate
     *            Exchange Rate Date
     */
    public void setExchangeRateDate( @Nullable final LocalDate exchangeRateDate )
    {
        rememberChangedField("ExchangeRateDate", this.exchangeRateDate);
        this.exchangeRateDate = exchangeRateDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CAReferenceDocument</b>
     * </p>
     * 
     * @param cAReferenceDocument
     *            Reference Document Number
     */
    public void setCAReferenceDocument( @Nullable final java.lang.String cAReferenceDocument )
    {
        rememberChangedField("CAReferenceDocument", this.cAReferenceDocument);
        this.cAReferenceDocument = cAReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CAReturnReason</b>
     * </p>
     * 
     * @param cAReturnReason
     *            Return Reason
     */
    public void setCAReturnReason( @Nullable final java.lang.String cAReturnReason )
    {
        rememberChangedField("CAReturnReason", this.cAReturnReason);
        this.cAReturnReason = cAReturnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingReason</b>
     * </p>
     * 
     * @param cAPostingReason
     *            Posting Reason (For Write-Offs And Transfer Postings)
     */
    public void setCAPostingReason( @Nullable final java.lang.String cAPostingReason )
    {
        rememberChangedField("CAPostingReason", this.cAPostingReason);
        this.cAPostingReason = cAPostingReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     * 
     * @param referenceDocumentType
     *            Reference Document Type
     */
    public void setReferenceDocumentType( @Nullable final java.lang.String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>OriginalReferenceDocument</b>
     * </p>
     * 
     * @param originalReferenceDocument
     *            Object key
     */
    public void setOriginalReferenceDocument( @Nullable final java.lang.String originalReferenceDocument )
    {
        rememberChangedField("OriginalReferenceDocument", this.originalReferenceDocument);
        this.originalReferenceDocument = originalReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAReversedDocumentNumber</b>
     * </p>
     * 
     * @param cAReversedDocumentNumber
     *            Number of Reversed Document
     */
    public void setCAReversedDocumentNumber( @Nullable final java.lang.String cAReversedDocumentNumber )
    {
        rememberChangedField("CAReversedDocumentNumber", this.cAReversedDocumentNumber);
        this.cAReversedDocumentNumber = cAReversedDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAClearingInformation</b>
     * </p>
     * 
     * @param cAClearingInformation
     *            Clearing Information
     */
    public void setCAClearingInformation( @Nullable final java.lang.String cAClearingInformation )
    {
        rememberChangedField("CAClearingInformation", this.cAClearingInformation);
        this.cAClearingInformation = cAClearingInformation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAReversalDocumentNumber</b>
     * </p>
     * 
     * @param cAReversalDocumentNumber
     *            Reversal Document
     */
    public void setCAReversalDocumentNumber( @Nullable final java.lang.String cAReversalDocumentNumber )
    {
        rememberChangedField("CAReversalDocumentNumber", this.cAReversalDocumentNumber);
        this.cAReversalDocumentNumber = cAReversalDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentSupplements</b>
     * </p>
     * 
     * @param cADocumentSupplements
     *            Existing document supplements
     */
    public void setCADocumentSupplements( @Nullable final java.lang.String cADocumentSupplements )
    {
        rememberChangedField("CADocumentSupplements", this.cADocumentSupplements);
        this.cADocumentSupplements = cADocumentSupplements;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     * 
     * @param logicalSystem
     *            Logical system of source document
     */
    public void setLogicalSystem( @Nullable final java.lang.String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAWorkflowCheckReason</b>
     * </p>
     * 
     * @param cAWorkflowCheckReason
     *            Check Reason for Workflows Acc. to Dual Control Principle
     */
    public void setCAWorkflowCheckReason( @Nullable final java.lang.String cAWorkflowCheckReason )
    {
        rememberChangedField("CAWorkflowCheckReason", this.cAWorkflowCheckReason);
        this.cAWorkflowCheckReason = cAWorkflowCheckReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAWorkflowCheckProcess</b>
     * </p>
     * 
     * @param cAWorkflowCheckProcess
     *            Editing Process To Be Confirmed
     */
    public void setCAWorkflowCheckProcess( @Nullable final java.lang.String cAWorkflowCheckProcess )
    {
        rememberChangedField("CAWorkflowCheckProcess", this.cAWorkflowCheckProcess);
        this.cAWorkflowCheckProcess = cAWorkflowCheckProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentTransactionClass</b>
     * </p>
     * 
     * @param cADocumentTransactionClass
     *            Transaction Class of Document
     */
    public void setCADocumentTransactionClass( @Nullable final java.lang.String cADocumentTransactionClass )
    {
        rememberChangedField("CADocumentTransactionClass", this.cADocumentTransactionClass);
        this.cADocumentTransactionClass = cADocumentTransactionClass;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocContainsCashFlowItems</b>
     * </p>
     * 
     * @param cADocContainsCashFlowItems
     *            Document Contains Assignments from Cash Flows
     */
    public void setCADocContainsCashFlowItems( @Nullable final java.lang.Boolean cADocContainsCashFlowItems )
    {
        rememberChangedField("CADocContainsCashFlowItems", this.cADocContainsCashFlowItems);
        this.cADocContainsCashFlowItems = cADocContainsCashFlowItems;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentClass</b>
     * </p>
     * 
     * @param cADocumentClass
     *            Document Class
     */
    public void setCADocumentClass( @Nullable final java.lang.String cADocumentClass )
    {
        rememberChangedField("CADocumentClass", this.cADocumentClass);
        this.cADocumentClass = cADocumentClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentVersion</b>
     * </p>
     * 
     * @param cADocumentVersion
     *            Version Number
     */
    public void setCADocumentVersion( @Nullable final java.lang.String cADocumentVersion )
    {
        rememberChangedField("CADocumentVersion", this.cADocumentVersion);
        this.cADocumentVersion = cADocumentVersion;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsIndividualPosting</b>
     * </p>
     * 
     * @param isIndividualPosting
     *            Individual Posting
     */
    public void setIsIndividualPosting( @Nullable final java.lang.Boolean isIndividualPosting )
    {
        rememberChangedField("IsIndividualPosting", this.isIndividualPosting);
        this.isIndividualPosting = isIndividualPosting;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentIsAged</b>
     * </p>
     * 
     * @param cADocumentIsAged
     *            Data Aging: Document was already in historical area
     */
    public void setCADocumentIsAged( @Nullable final java.lang.Boolean cADocumentIsAged )
    {
        rememberChangedField("CADocumentIsAged", this.cADocumentIsAged);
        this.cADocumentIsAged = cADocumentIsAged;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "DocumentHeader";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentNumber", getCADocumentNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentNumber", getCADocumentNumber());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("CATaxCompanyCode", getCATaxCompanyCode());
        values.put("CAStorageLocationOfTaxSuplmnt", getCAStorageLocationOfTaxSuplmnt());
        values.put("CATaxCodeWasExchanged", getCATaxCodeWasExchanged());
        values.put("TaxReportingDate", getTaxReportingDate());
        values.put("CAReconciliationKey", getCAReconciliationKey());
        values.put("CASeparateDocIsCreatedInGL", getCASeparateDocIsCreatedInGL());
        values.put("CARequestedPeriodForGLTransfer", getCARequestedPeriodForGLTransfer());
        values.put("CAApplicationArea", getCAApplicationArea());
        values.put("CADocumentType", getCADocumentType());
        values.put("CADocumentOriginCode", getCADocumentOriginCode());
        values.put("CADocumentOriginCodeName", getCADocumentOriginCodeName());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("DocumentDate", getDocumentDate());
        values.put("CAPostingDate", getCAPostingDate());
        values.put("ExchangeRateDate", getExchangeRateDate());
        values.put("CAReferenceDocument", getCAReferenceDocument());
        values.put("CAReturnReason", getCAReturnReason());
        values.put("CAPostingReason", getCAPostingReason());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("OriginalReferenceDocument", getOriginalReferenceDocument());
        values.put("CAReversedDocumentNumber", getCAReversedDocumentNumber());
        values.put("CAClearingInformation", getCAClearingInformation());
        values.put("CAReversalDocumentNumber", getCAReversalDocumentNumber());
        values.put("CADocumentSupplements", getCADocumentSupplements());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("CAWorkflowCheckReason", getCAWorkflowCheckReason());
        values.put("CAWorkflowCheckProcess", getCAWorkflowCheckProcess());
        values.put("CADocumentTransactionClass", getCADocumentTransactionClass());
        values.put("CADocContainsCashFlowItems", getCADocContainsCashFlowItems());
        values.put("CADocumentClass", getCADocumentClass());
        values.put("CADocumentVersion", getCADocumentVersion());
        values.put("IsIndividualPosting", getIsIndividualPosting());
        values.put("CADocumentIsAged", getCADocumentIsAged());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentNumber") ) {
                final Object value = values.remove("CADocumentNumber");
                if( (value == null) || (!value.equals(getCADocumentNumber())) ) {
                    setCADocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CATaxCompanyCode") ) {
                final Object value = values.remove("CATaxCompanyCode");
                if( (value == null) || (!value.equals(getCATaxCompanyCode())) ) {
                    setCATaxCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAStorageLocationOfTaxSuplmnt") ) {
                final Object value = values.remove("CAStorageLocationOfTaxSuplmnt");
                if( (value == null) || (!value.equals(getCAStorageLocationOfTaxSuplmnt())) ) {
                    setCAStorageLocationOfTaxSuplmnt(((java.lang.String) value));
                }
            }
            if( values.containsKey("CATaxCodeWasExchanged") ) {
                final Object value = values.remove("CATaxCodeWasExchanged");
                if( (value == null) || (!value.equals(getCATaxCodeWasExchanged())) ) {
                    setCATaxCodeWasExchanged(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("TaxReportingDate") ) {
                final Object value = values.remove("TaxReportingDate");
                if( (value == null) || (!value.equals(getTaxReportingDate())) ) {
                    setTaxReportingDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAReconciliationKey") ) {
                final Object value = values.remove("CAReconciliationKey");
                if( (value == null) || (!value.equals(getCAReconciliationKey())) ) {
                    setCAReconciliationKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASeparateDocIsCreatedInGL") ) {
                final Object value = values.remove("CASeparateDocIsCreatedInGL");
                if( (value == null) || (!value.equals(getCASeparateDocIsCreatedInGL())) ) {
                    setCASeparateDocIsCreatedInGL(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CARequestedPeriodForGLTransfer") ) {
                final Object value = values.remove("CARequestedPeriodForGLTransfer");
                if( (value == null) || (!value.equals(getCARequestedPeriodForGLTransfer())) ) {
                    setCARequestedPeriodForGLTransfer(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAApplicationArea") ) {
                final Object value = values.remove("CAApplicationArea");
                if( (value == null) || (!value.equals(getCAApplicationArea())) ) {
                    setCAApplicationArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentType") ) {
                final Object value = values.remove("CADocumentType");
                if( (value == null) || (!value.equals(getCADocumentType())) ) {
                    setCADocumentType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentOriginCode") ) {
                final Object value = values.remove("CADocumentOriginCode");
                if( (value == null) || (!value.equals(getCADocumentOriginCode())) ) {
                    setCADocumentOriginCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentOriginCodeName") ) {
                final Object value = values.remove("CADocumentOriginCodeName");
                if( (value == null) || (!value.equals(getCADocumentOriginCodeName())) ) {
                    setCADocumentOriginCodeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAPostingDate") ) {
                final Object value = values.remove("CAPostingDate");
                if( (value == null) || (!value.equals(getCAPostingDate())) ) {
                    setCAPostingDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ExchangeRateDate") ) {
                final Object value = values.remove("ExchangeRateDate");
                if( (value == null) || (!value.equals(getExchangeRateDate())) ) {
                    setExchangeRateDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAReferenceDocument") ) {
                final Object value = values.remove("CAReferenceDocument");
                if( (value == null) || (!value.equals(getCAReferenceDocument())) ) {
                    setCAReferenceDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAReturnReason") ) {
                final Object value = values.remove("CAReturnReason");
                if( (value == null) || (!value.equals(getCAReturnReason())) ) {
                    setCAReturnReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPostingReason") ) {
                final Object value = values.remove("CAPostingReason");
                if( (value == null) || (!value.equals(getCAPostingReason())) ) {
                    setCAPostingReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((java.lang.String) value));
                }
            }
            if( values.containsKey("OriginalReferenceDocument") ) {
                final Object value = values.remove("OriginalReferenceDocument");
                if( (value == null) || (!value.equals(getOriginalReferenceDocument())) ) {
                    setOriginalReferenceDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAReversedDocumentNumber") ) {
                final Object value = values.remove("CAReversedDocumentNumber");
                if( (value == null) || (!value.equals(getCAReversedDocumentNumber())) ) {
                    setCAReversedDocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAClearingInformation") ) {
                final Object value = values.remove("CAClearingInformation");
                if( (value == null) || (!value.equals(getCAClearingInformation())) ) {
                    setCAClearingInformation(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAReversalDocumentNumber") ) {
                final Object value = values.remove("CAReversalDocumentNumber");
                if( (value == null) || (!value.equals(getCAReversalDocumentNumber())) ) {
                    setCAReversalDocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentSupplements") ) {
                final Object value = values.remove("CADocumentSupplements");
                if( (value == null) || (!value.equals(getCADocumentSupplements())) ) {
                    setCADocumentSupplements(((java.lang.String) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAWorkflowCheckReason") ) {
                final Object value = values.remove("CAWorkflowCheckReason");
                if( (value == null) || (!value.equals(getCAWorkflowCheckReason())) ) {
                    setCAWorkflowCheckReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAWorkflowCheckProcess") ) {
                final Object value = values.remove("CAWorkflowCheckProcess");
                if( (value == null) || (!value.equals(getCAWorkflowCheckProcess())) ) {
                    setCAWorkflowCheckProcess(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentTransactionClass") ) {
                final Object value = values.remove("CADocumentTransactionClass");
                if( (value == null) || (!value.equals(getCADocumentTransactionClass())) ) {
                    setCADocumentTransactionClass(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocContainsCashFlowItems") ) {
                final Object value = values.remove("CADocContainsCashFlowItems");
                if( (value == null) || (!value.equals(getCADocContainsCashFlowItems())) ) {
                    setCADocContainsCashFlowItems(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CADocumentClass") ) {
                final Object value = values.remove("CADocumentClass");
                if( (value == null) || (!value.equals(getCADocumentClass())) ) {
                    setCADocumentClass(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentVersion") ) {
                final Object value = values.remove("CADocumentVersion");
                if( (value == null) || (!value.equals(getCADocumentVersion())) ) {
                    setCADocumentVersion(((java.lang.String) value));
                }
            }
            if( values.containsKey("IsIndividualPosting") ) {
                final Object value = values.remove("IsIndividualPosting");
                if( (value == null) || (!value.equals(getIsIndividualPosting())) ) {
                    setIsIndividualPosting(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CADocumentIsAged") ) {
                final Object value = values.remove("CADocumentIsAged");
                if( (value == null) || (!value.equals(getCADocumentIsAged())) ) {
                    setCADocumentIsAged(((java.lang.Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_BPItem") ) {
                final Object value = (values).remove("_BPItem");
                if( value instanceof Iterable ) {
                    if( to_BPItem == null ) {
                        to_BPItem = Lists.newArrayList();
                    } else {
                        to_BPItem = Lists.newArrayList(to_BPItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BPItemLogical entity;
                        if( to_BPItem.size() > i ) {
                            entity = to_BPItem.get(i);
                        } else {
                            entity = new BPItemLogical();
                            to_BPItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_BPItemPaytData") ) {
                final Object value = (values).remove("_BPItemPaytData");
                if( value instanceof Iterable ) {
                    if( to_BPItemPaytData == null ) {
                        to_BPItemPaytData = Lists.newArrayList();
                    } else {
                        to_BPItemPaytData = Lists.newArrayList(to_BPItemPaytData);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BPItemPaytData entity;
                        if( to_BPItemPaytData.size() > i ) {
                            entity = to_BPItemPaytData.get(i);
                        } else {
                            entity = new BPItemPaytData();
                            to_BPItemPaytData.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_GLItem") ) {
                final Object value = (values).remove("_GLItem");
                if( value instanceof Iterable ) {
                    if( to_GLItem == null ) {
                        to_GLItem = Lists.newArrayList();
                    } else {
                        to_GLItem = Lists.newArrayList(to_GLItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GLItem entity;
                        if( to_GLItem.size() > i ) {
                            entity = to_GLItem.get(i);
                        } else {
                            entity = new GLItem();
                            to_GLItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_GLItemPaytData") ) {
                final Object value = (values).remove("_GLItemPaytData");
                if( value instanceof Iterable ) {
                    if( to_GLItemPaytData == null ) {
                        to_GLItemPaytData = Lists.newArrayList();
                    } else {
                        to_GLItemPaytData = Lists.newArrayList(to_GLItemPaytData);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        GLItemPaytData entity;
                        if( to_GLItemPaytData.size() > i ) {
                            entity = to_GLItemPaytData.get(i);
                        } else {
                            entity = new GLItemPaytData();
                            to_GLItemPaytData.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingDocumentManageService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_BPItem != null ) {
            (values).put("_BPItem", to_BPItem);
        }
        if( to_BPItemPaytData != null ) {
            (values).put("_BPItemPaytData", to_BPItemPaytData);
        }
        if( to_GLItem != null ) {
            (values).put("_GLItem", to_GLItem);
        }
        if( to_GLItemPaytData != null ) {
            (values).put("_GLItemPaytData", to_GLItemPaytData);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>BPItemLogical</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_BPItem</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_BPItem</b> is already loaded, the result will contain the
     *         <b>BPItemLogical</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<BPItemLogical>> getBPItemIfPresent()
    {
        return Option.of(to_BPItem);
    }

    /**
     * Overwrites the list of associated <b>BPItemLogical</b> entities for the loaded navigation property
     * <b>_BPItem</b>.
     * <p>
     * If the navigation property <b>_BPItem</b> of a queried <b>DocumentHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>BPItemLogical</b> entities.
     */
    public void setBPItem( @Nonnull final List<BPItemLogical> value )
    {
        if( to_BPItem == null ) {
            to_BPItem = Lists.newArrayList();
        }
        to_BPItem.clear();
        to_BPItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BPItemLogical</b> entities. This corresponds to the OData navigation
     * property <b>_BPItem</b>.
     * <p>
     * If the navigation property <b>_BPItem</b> of a queried <b>DocumentHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>BPItemLogical</b> entities.
     */
    public void addBPItem( BPItemLogical... entity )
    {
        if( to_BPItem == null ) {
            to_BPItem = Lists.newArrayList();
        }
        to_BPItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>BPItemPaytData</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_BPItemPaytData</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_BPItemPaytData</b> is already loaded, the result will
     *         contain the <b>BPItemPaytData</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BPItemPaytData>> getBPItemPaytDataIfPresent()
    {
        return Option.of(to_BPItemPaytData);
    }

    /**
     * Overwrites the list of associated <b>BPItemPaytData</b> entities for the loaded navigation property
     * <b>_BPItemPaytData</b>.
     * <p>
     * If the navigation property <b>_BPItemPaytData</b> of a queried <b>DocumentHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>BPItemPaytData</b> entities.
     */
    public void setBPItemPaytData( @Nonnull final List<BPItemPaytData> value )
    {
        if( to_BPItemPaytData == null ) {
            to_BPItemPaytData = Lists.newArrayList();
        }
        to_BPItemPaytData.clear();
        to_BPItemPaytData.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BPItemPaytData</b> entities. This corresponds to the OData navigation
     * property <b>_BPItemPaytData</b>.
     * <p>
     * If the navigation property <b>_BPItemPaytData</b> of a queried <b>DocumentHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>BPItemPaytData</b> entities.
     */
    public void addBPItemPaytData( BPItemPaytData... entity )
    {
        if( to_BPItemPaytData == null ) {
            to_BPItemPaytData = Lists.newArrayList();
        }
        to_BPItemPaytData.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>GLItem</b> entities (one to many). This corresponds to the OData navigation property
     * <b>_GLItem</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_GLItem</b> is already loaded, the result will contain the
     *         <b>GLItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GLItem>> getGLItemIfPresent()
    {
        return Option.of(to_GLItem);
    }

    /**
     * Overwrites the list of associated <b>GLItem</b> entities for the loaded navigation property <b>_GLItem</b>.
     * <p>
     * If the navigation property <b>_GLItem</b> of a queried <b>DocumentHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>GLItem</b> entities.
     */
    public void setGLItem( @Nonnull final List<GLItem> value )
    {
        if( to_GLItem == null ) {
            to_GLItem = Lists.newArrayList();
        }
        to_GLItem.clear();
        to_GLItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GLItem</b> entities. This corresponds to the OData navigation property
     * <b>_GLItem</b>.
     * <p>
     * If the navigation property <b>_GLItem</b> of a queried <b>DocumentHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>GLItem</b> entities.
     */
    public void addGLItem( GLItem... entity )
    {
        if( to_GLItem == null ) {
            to_GLItem = Lists.newArrayList();
        }
        to_GLItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>GLItemPaytData</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_GLItemPaytData</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentHeader</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_GLItemPaytData</b> is already loaded, the result will
     *         contain the <b>GLItemPaytData</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<GLItemPaytData>> getGLItemPaytDataIfPresent()
    {
        return Option.of(to_GLItemPaytData);
    }

    /**
     * Overwrites the list of associated <b>GLItemPaytData</b> entities for the loaded navigation property
     * <b>_GLItemPaytData</b>.
     * <p>
     * If the navigation property <b>_GLItemPaytData</b> of a queried <b>DocumentHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>GLItemPaytData</b> entities.
     */
    public void setGLItemPaytData( @Nonnull final List<GLItemPaytData> value )
    {
        if( to_GLItemPaytData == null ) {
            to_GLItemPaytData = Lists.newArrayList();
        }
        to_GLItemPaytData.clear();
        to_GLItemPaytData.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>GLItemPaytData</b> entities. This corresponds to the OData navigation
     * property <b>_GLItemPaytData</b>.
     * <p>
     * If the navigation property <b>_GLItemPaytData</b> of a queried <b>DocumentHeader</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>GLItemPaytData</b> entities.
     */
    public void addGLItemPaytData( GLItemPaytData... entity )
    {
        if( to_GLItemPaytData == null ) {
            to_GLItemPaytData = Lists.newArrayList();
        }
        to_GLItemPaytData.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of DocumentHeader instances.
     * 
     */
    public final static class DocumentHeaderBuilder
    {

        private List<BPItemLogical> to_BPItem = Lists.newArrayList();
        private List<BPItemPaytData> to_BPItemPaytData = Lists.newArrayList();
        private List<GLItem> to_GLItem = Lists.newArrayList();
        private List<GLItemPaytData> to_GLItemPaytData = Lists.newArrayList();

        private DocumentHeader.DocumentHeaderBuilder to_BPItem( final List<BPItemLogical> value )
        {
            to_BPItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_BPItem</b> for <b>DocumentHeader</b> to multiple <b>BPItemLogical</b>.
         * 
         * @param value
         *            The BPItemLogicals to build this DocumentHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentHeader.DocumentHeaderBuilder bpItem( BPItemLogical... value )
        {
            return to_BPItem(Lists.newArrayList(value));
        }

        private DocumentHeader.DocumentHeaderBuilder to_BPItemPaytData( final List<BPItemPaytData> value )
        {
            to_BPItemPaytData.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_BPItemPaytData</b> for <b>DocumentHeader</b> to multiple <b>BPItemPaytData</b>.
         * 
         * @param value
         *            The BPItemPaytDatas to build this DocumentHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentHeader.DocumentHeaderBuilder bpItemPaytData( BPItemPaytData... value )
        {
            return to_BPItemPaytData(Lists.newArrayList(value));
        }

        private DocumentHeader.DocumentHeaderBuilder to_GLItem( final List<GLItem> value )
        {
            to_GLItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_GLItem</b> for <b>DocumentHeader</b> to multiple <b>GLItem</b>.
         * 
         * @param value
         *            The GLItems to build this DocumentHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentHeader.DocumentHeaderBuilder glItem( GLItem... value )
        {
            return to_GLItem(Lists.newArrayList(value));
        }

        private DocumentHeader.DocumentHeaderBuilder to_GLItemPaytData( final List<GLItemPaytData> value )
        {
            to_GLItemPaytData.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_GLItemPaytData</b> for <b>DocumentHeader</b> to multiple <b>GLItemPaytData</b>.
         * 
         * @param value
         *            The GLItemPaytDatas to build this DocumentHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentHeader.DocumentHeaderBuilder glItemPaytData( GLItemPaytData... value )
        {
            return to_GLItemPaytData(Lists.newArrayList(value));
        }

    }

}
