/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingDocumentManageService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document General Ledger Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GLItemType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class GLItem extends VdmEntity<GLItem> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_cadocumentmanage.v0001.GLItemType";
    /**
     * Selector for all available fields of GLItem.
     * 
     */
    public final static SimpleProperty<GLItem> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @return Number of a FI-CA Document
     */
    @Nullable
    @ElementName( "CADocumentNumber" )
    private java.lang.String cADocumentNumber;
    public final static SimpleProperty.String<GLItem> CA_DOCUMENT_NUMBER =
        new SimpleProperty.String<GLItem>(GLItem.class, "CADocumentNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAGLItemNumber</b>
     * </p>
     * 
     * @return Item Number in FI-CA Document
     */
    @Nullable
    @ElementName( "CAGLItemNumber" )
    private java.lang.String cAGLItemNumber;
    public final static SimpleProperty.String<GLItem> CAGL_ITEM_NUMBER =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAGLItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<GLItem> COMPANY_CODE =
        new SimpleProperty.String<GLItem>(GLItem.class, "CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     * 
     * @return Business Area
     */
    @Nullable
    @ElementName( "BusinessArea" )
    private java.lang.String businessArea;
    public final static SimpleProperty.String<GLItem> BUSINESS_AREA =
        new SimpleProperty.String<GLItem>(GLItem.class, "BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     * 
     * @return Business Place
     */
    @Nullable
    @ElementName( "BusinessPlace" )
    private java.lang.String businessPlace;
    public final static SimpleProperty.String<GLItem> BUSINESS_PLACE =
        new SimpleProperty.String<GLItem>(GLItem.class, "BusinessPlace");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     * 
     * @return Segment for Segmental Reporting
     */
    @Nullable
    @ElementName( "Segment" )
    private java.lang.String segment;
    public final static SimpleProperty.String<GLItem> SEGMENT =
        new SimpleProperty.String<GLItem>(GLItem.class, "Segment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     * 
     * @return Profit Center
     */
    @Nullable
    @ElementName( "ProfitCenter" )
    private java.lang.String profitCenter;
    public final static SimpleProperty.String<GLItem> PROFIT_CENTER =
        new SimpleProperty.String<GLItem>(GLItem.class, "ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     * 
     * @return Company ID of Trading Partner
     */
    @Nullable
    @ElementName( "PartnerCompany" )
    private java.lang.String partnerCompany;
    public final static SimpleProperty.String<GLItem> PARTNER_COMPANY =
        new SimpleProperty.String<GLItem>(GLItem.class, "PartnerCompany");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     * 
     * @return G/L Account
     */
    @Nullable
    @ElementName( "GLAccount" )
    private java.lang.String gLAccount;
    public final static SimpleProperty.String<GLItem> GL_ACCOUNT =
        new SimpleProperty.String<GLItem>(GLItem.class, "GLAccount");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     * 
     * @return Value Date
     */
    @Nullable
    @ElementName( "ValueDate" )
    private LocalDate valueDate;
    public final static SimpleProperty.Date<GLItem> VALUE_DATE =
        new SimpleProperty.Date<GLItem>(GLItem.class, "ValueDate");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>CAExchangeRate</b>
     * </p>
     * 
     * @return Absolute Exchange Rate
     */
    @Nullable
    @ElementName( "CAExchangeRate" )
    @DecimalDescriptor( precision = 9, scale = 5 )
    private BigDecimal cAExchangeRate;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_EXCHANGE_RATE =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CAExchangeRate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchRateIsIndirectQuotation</b>
     * </p>
     * 
     * @return Exchange Rate Is Indirect Quotation
     */
    @Nullable
    @ElementName( "ExchRateIsIndirectQuotation" )
    private java.lang.Boolean exchRateIsIndirectQuotation;
    public final static SimpleProperty.Boolean<GLItem> EXCH_RATE_IS_INDIRECT_QUOTATION =
        new SimpleProperty.Boolean<GLItem>(GLItem.class, "ExchRateIsIndirectQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @return Transaction Currency
     */
    @Nullable
    @ElementName( "TransactionCurrency" )
    private java.lang.String transactionCurrency;
    public final static SimpleProperty.String<GLItem> TRANSACTION_CURRENCY =
        new SimpleProperty.String<GLItem>(GLItem.class, "TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     * 
     * @return Currency Key
     */
    @Nullable
    @ElementName( "Currency" )
    private java.lang.String currency;
    public final static SimpleProperty.String<GLItem> CURRENCY =
        new SimpleProperty.String<GLItem>(GLItem.class, "Currency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInLocalCurrency</b>
     * </p>
     * 
     * @return The cAAmountInLocalCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInLocalCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInLocalCurrency;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_AMOUNT_IN_LOCAL_CURRENCY =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CAAmountInLocalCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @return The cAAmountInTransactionCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInTransactionCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInTransactionCurrency;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_AMOUNT_IN_TRANSACTION_CURRENCY =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CAAmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInSecondCurrency</b>
     * </p>
     * 
     * @return The cAAmountInSecondCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInSecondCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInSecondCurrency;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_AMOUNT_IN_SECOND_CURRENCY =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CAAmountInSecondCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInThirdCurrency</b>
     * </p>
     * 
     * @return The cAAmountInThirdCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInThirdCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInThirdCurrency;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_AMOUNT_IN_THIRD_CURRENCY =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CAAmountInThirdCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAAccountAssignmentCategory</b>
     * </p>
     * 
     * @return Account Assignment Category
     */
    @Nullable
    @ElementName( "CAAccountAssignmentCategory" )
    private java.lang.String cAAccountAssignmentCategory;
    public final static SimpleProperty.String<GLItem> CA_ACCOUNT_ASSIGNMENT_CATEGORY =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAAccountAssignmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CAAccountAssignment</b>
     * </p>
     * 
     * @return Acct assnmnt string for industry-specific account assngments
     */
    @Nullable
    @ElementName( "CAAccountAssignment" )
    private java.lang.String cAAccountAssignment;
    public final static SimpleProperty.String<GLItem> CA_ACCOUNT_ASSIGNMENT =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAAccountAssignment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     * 
     * @return Cost Center
     */
    @Nullable
    @ElementName( "CostCenter" )
    private java.lang.String costCenter;
    public final static SimpleProperty.String<GLItem> COST_CENTER =
        new SimpleProperty.String<GLItem>(GLItem.class, "CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     * 
     * @return Sales Order Number
     */
    @Nullable
    @ElementName( "SalesOrder" )
    private java.lang.String salesOrder;
    public final static SimpleProperty.String<GLItem> SALES_ORDER =
        new SimpleProperty.String<GLItem>(GLItem.class, "SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     * 
     * @return Item number in Sales Order
     */
    @Nullable
    @ElementName( "SalesOrderItem" )
    private java.lang.String salesOrderItem;
    public final static SimpleProperty.String<GLItem> SALES_ORDER_ITEM =
        new SimpleProperty.String<GLItem>(GLItem.class, "SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAReconciliationKey</b>
     * </p>
     * 
     * @return Reconciliation Key for General Ledger
     */
    @Nullable
    @ElementName( "CAReconciliationKey" )
    private java.lang.String cAReconciliationKey;
    public final static SimpleProperty.String<GLItem> CA_RECONCILIATION_KEY =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAReconciliationKey");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAInternalPostingReasonCode</b>
     * </p>
     * 
     * @return Reason for Automatic Creation of Posting
     */
    @Nullable
    @ElementName( "CAInternalPostingReasonCode" )
    private java.lang.String cAInternalPostingReasonCode;
    public final static SimpleProperty.String<GLItem> CA_INTERNAL_POSTING_REASON_CODE =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAInternalPostingReasonCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CANegativePostingControlCode</b>
     * </p>
     * 
     * @return Control Field for Negative Posting
     */
    @Nullable
    @ElementName( "CANegativePostingControlCode" )
    private java.lang.String cANegativePostingControlCode;
    public final static SimpleProperty.String<GLItem> CA_NEGATIVE_POSTING_CONTROL_CODE =
        new SimpleProperty.String<GLItem>(GLItem.class, "CANegativePostingControlCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CAGLPostingCurrency</b>
     * </p>
     * 
     * @return Update Currency for General Ledger Transaction Figures
     */
    @Nullable
    @ElementName( "CAGLPostingCurrency" )
    private java.lang.String cAGLPostingCurrency;
    public final static SimpleProperty.String<GLItem> CAGL_POSTING_CURRENCY =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAGLPostingCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGroup</b>
     * </p>
     * 
     * @return Ledger Group
     */
    @Nullable
    @ElementName( "LedgerGroup" )
    private java.lang.String ledgerGroup;
    public final static SimpleProperty.String<GLItem> LEDGER_GROUP =
        new SimpleProperty.String<GLItem>(GLItem.class, "LedgerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     * 
     * @return Profitability Segment Number (CO-PA)
     */
    @Nullable
    @ElementName( "ProfitabilitySegment" )
    private java.lang.String profitabilitySegment;
    public final static SimpleProperty.String<GLItem> PROFITABILITY_SEGMENT =
        new SimpleProperty.String<GLItem>(GLItem.class, "ProfitabilitySegment");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegmentChanges</b>
     * </p>
     * 
     * @return Profitability Segment Changes (CO-PA)
     */
    @Nullable
    @ElementName( "ProfitabilitySegmentChanges" )
    private java.lang.String profitabilitySegmentChanges;
    public final static SimpleProperty.String<GLItem> PROFITABILITY_SEGMENT_CHANGES =
        new SimpleProperty.String<GLItem>(GLItem.class, "ProfitabilitySegmentChanges");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningLevel</b>
     * </p>
     * 
     * @return Planning Level
     */
    @Nullable
    @ElementName( "PlanningLevel" )
    private java.lang.String planningLevel;
    public final static SimpleProperty.String<GLItem> PLANNING_LEVEL =
        new SimpleProperty.String<GLItem>(GLItem.class, "PlanningLevel");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CARepetitionGroup</b>
     * </p>
     * 
     * @return Repetition group
     */
    @Nullable
    @ElementName( "CARepetitionGroup" )
    private java.lang.String cARepetitionGroup;
    public final static SimpleProperty.String<GLItem> CA_REPETITION_GROUP =
        new SimpleProperty.String<GLItem>(GLItem.class, "CARepetitionGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CATransactionKeyAccountDetn</b>
     * </p>
     * 
     * @return Transaction key for account determination
     */
    @Nullable
    @ElementName( "CATransactionKeyAccountDetn" )
    private java.lang.String cATransactionKeyAccountDetn;
    public final static SimpleProperty.String<GLItem> CA_TRANSACTION_KEY_ACCOUNT_DETN =
        new SimpleProperty.String<GLItem>(GLItem.class, "CATransactionKeyAccountDetn");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @return Condition Type
     */
    @Nullable
    @ElementName( "ConditionType" )
    private java.lang.String conditionType;
    public final static SimpleProperty.String<GLItem> CONDITION_TYPE =
        new SimpleProperty.String<GLItem>(GLItem.class, "ConditionType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsSeparateLineItemInGL</b>
     * </p>
     * 
     * @return Create Line Item in General Ledger
     */
    @Nullable
    @ElementName( "CAIsSeparateLineItemInGL" )
    private java.lang.Boolean cAIsSeparateLineItemInGL;
    public final static SimpleProperty.Boolean<GLItem> CA_IS_SEPARATE_LINE_ITEM_IN_GL =
        new SimpleProperty.Boolean<GLItem>(GLItem.class, "CAIsSeparateLineItemInGL");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     * 
     * @return Base Unit of Measure
     */
    @Nullable
    @ElementName( "BaseUnit" )
    private java.lang.String baseUnit;
    public final static SimpleProperty.String<GLItem> BASE_UNIT =
        new SimpleProperty.String<GLItem>(GLItem.class, "BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     * 
     * @return Tax on Sales/Purchases Code
     */
    @Nullable
    @ElementName( "TaxCode" )
    private java.lang.String taxCode;
    public final static SimpleProperty.String<GLItem> TAX_CODE =
        new SimpleProperty.String<GLItem>(GLItem.class, "TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CASupplementaryTaxCode</b>
     * </p>
     * 
     * @return Supplementary Tax
     */
    @Nullable
    @ElementName( "CASupplementaryTaxCode" )
    private java.lang.String cASupplementaryTaxCode;
    public final static SimpleProperty.String<GLItem> CA_SUPPLEMENTARY_TAX_CODE =
        new SimpleProperty.String<GLItem>(GLItem.class, "CASupplementaryTaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAWithholdingTaxSupplement</b>
     * </p>
     * 
     * @return Withholding Tax Supplement
     */
    @Nullable
    @ElementName( "CAWithholdingTaxSupplement" )
    private java.lang.String cAWithholdingTaxSupplement;
    public final static SimpleProperty.String<GLItem> CA_WITHHOLDING_TAX_SUPPLEMENT =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAWithholdingTaxSupplement");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAOtherTaxCode</b>
     * </p>
     * 
     * @return Tax Code for Other Taxes
     */
    @Nullable
    @ElementName( "CAOtherTaxCode" )
    private java.lang.String cAOtherTaxCode;
    public final static SimpleProperty.String<GLItem> CA_OTHER_TAX_CODE =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAOtherTaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingCodeForTaxItems</b>
     * </p>
     * 
     * @return Grouping Key for Tax Items
     */
    @Nullable
    @ElementName( "CAGroupingCodeForTaxItems" )
    private java.lang.String cAGroupingCodeForTaxItems;
    public final static SimpleProperty.String<GLItem> CA_GROUPING_CODE_FOR_TAX_ITEMS =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAGroupingCodeForTaxItems");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     * 
     * @return Tax Jurisdiction
     */
    @Nullable
    @ElementName( "TaxJurisdiction" )
    private java.lang.String taxJurisdiction;
    public final static SimpleProperty.String<GLItem> TAX_JURISDICTION =
        new SimpleProperty.String<GLItem>(GLItem.class, "TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>CAEnteredTaxJurisdictionCode</b>
     * </p>
     * 
     * @return Tax Jurisdiction Code (Entered value)
     */
    @Nullable
    @ElementName( "CAEnteredTaxJurisdictionCode" )
    private java.lang.String cAEnteredTaxJurisdictionCode;
    public final static SimpleProperty.String<GLItem> CA_ENTERED_TAX_JURISDICTION_CODE =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAEnteredTaxJurisdictionCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CATaxJurisdictionLevelCounter</b>
     * </p>
     * 
     * @return Level Counter for Multi-Level Taxes in Tax Jurisdiction
     */
    @Nullable
    @ElementName( "CATaxJurisdictionLevelCounter" )
    private java.lang.String cATaxJurisdictionLevelCounter;
    public final static SimpleProperty.String<GLItem> CA_TAX_JURISDICTION_LEVEL_COUNTER =
        new SimpleProperty.String<GLItem>(GLItem.class, "CATaxJurisdictionLevelCounter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CATaxExceptionID</b>
     * </p>
     * 
     * @return Key for tax exception
     */
    @Nullable
    @ElementName( "CATaxExceptionID" )
    private java.lang.String cATaxExceptionID;
    public final static SimpleProperty.String<GLItem> CA_TAX_EXCEPTION_ID =
        new SimpleProperty.String<GLItem>(GLItem.class, "CATaxExceptionID");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CATaxDate</b>
     * </p>
     * 
     * @return Decisive Date for Calculating Taxes
     */
    @Nullable
    @ElementName( "CATaxDate" )
    private LocalDate cATaxDate;
    public final static SimpleProperty.Date<GLItem> CA_TAX_DATE =
        new SimpleProperty.Date<GLItem>(GLItem.class, "CATaxDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxBaseAmountInLocalCurrency</b>
     * </p>
     * 
     * @return The cATaxBaseAmountInLocalCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxBaseAmountInLocalCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxBaseAmountInLocalCurrency;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_TAX_BASE_AMOUNT_IN_LOCAL_CURRENCY =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CATaxBaseAmountInLocalCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxBaseAmount</b>
     * </p>
     * 
     * @return The cATaxBaseAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxBaseAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxBaseAmount;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_TAX_BASE_AMOUNT =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CATaxBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CANonDeductibleTxAmtInDocCrcy</b>
     * </p>
     * 
     * @return The cANonDeductibleTxAmtInDocCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CANonDeductibleTxAmtInDocCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cANonDeductibleTxAmtInDocCrcy;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_NON_DEDUCTIBLE_TX_AMT_IN_DOC_CRCY =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CANonDeductibleTxAmtInDocCrcy");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CANonDeductibleTxAmtInLoclCrcy</b>
     * </p>
     * 
     * @return The cANonDeductibleTxAmtInLoclCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CANonDeductibleTxAmtInLoclCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cANonDeductibleTxAmtInLoclCrcy;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_NON_DEDUCTIBLE_TX_AMT_IN_LOCL_CRCY =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CANonDeductibleTxAmtInLoclCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAContainsNonDeductibleInptTax</b>
     * </p>
     * 
     * @return Contains Non-Deductible Input Tax
     */
    @Nullable
    @ElementName( "CAContainsNonDeductibleInptTax" )
    private java.lang.String cAContainsNonDeductibleInptTax;
    public final static SimpleProperty.String<GLItem> CA_CONTAINS_NON_DEDUCTIBLE_INPT_TAX =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAContainsNonDeductibleInptTax");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>CATaxRate</b>
     * </p>
     * 
     * @return Tax rate
     */
    @Nullable
    @ElementName( "CATaxRate" )
    private java.lang.String cATaxRate;
    public final static SimpleProperty.String<GLItem> CA_TAX_RATE =
        new SimpleProperty.String<GLItem>(GLItem.class, "CATaxRate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>GrossIncomeTaxActivityCode</b>
     * </p>
     * 
     * @return Activity Code for Gross Income Tax
     */
    @Nullable
    @ElementName( "GrossIncomeTaxActivityCode" )
    private java.lang.String grossIncomeTaxActivityCode;
    public final static SimpleProperty.String<GLItem> GROSS_INCOME_TAX_ACTIVITY_CODE =
        new SimpleProperty.String<GLItem>(GLItem.class, "GrossIncomeTaxActivityCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EmploymentTaxDistributionType</b>
     * </p>
     * 
     * @return Distribution Type for Employment Tax
     */
    @Nullable
    @ElementName( "EmploymentTaxDistributionType" )
    private java.lang.String employmentTaxDistributionType;
    public final static SimpleProperty.String<GLItem> EMPLOYMENT_TAX_DISTRIBUTION_TYPE =
        new SimpleProperty.String<GLItem>(GLItem.class, "EmploymentTaxDistributionType");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxPortionInLocalCurrency</b>
     * </p>
     * 
     * @return The cATaxPortionInLocalCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxPortionInLocalCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxPortionInLocalCurrency;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_TAX_PORTION_IN_LOCAL_CURRENCY =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CATaxPortionInLocalCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxPortionInTransCurrency</b>
     * </p>
     * 
     * @return The cATaxPortionInTransCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CATaxPortionInTransCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cATaxPortionInTransCurrency;
    public final static SimpleProperty.NumericDecimal<GLItem> CA_TAX_PORTION_IN_TRANS_CURRENCY =
        new SimpleProperty.NumericDecimal<GLItem>(GLItem.class, "CATaxPortionInTransCurrency");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CATaxIsCalculatedExternally</b>
     * </p>
     * 
     * @return Tax on Sales/Purchases Was Calculated by Document
     */
    @Nullable
    @ElementName( "CATaxIsCalculatedExternally" )
    private java.lang.Boolean cATaxIsCalculatedExternally;
    public final static SimpleProperty.Boolean<GLItem> CA_TAX_IS_CALCULATED_EXTERNALLY =
        new SimpleProperty.Boolean<GLItem>(GLItem.class, "CATaxIsCalculatedExternally");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CATaxItemHasAltvExchangeRate</b>
     * </p>
     * 
     * @return Alternative Exchange Rate for Tax Items
     */
    @Nullable
    @ElementName( "CATaxItemHasAltvExchangeRate" )
    private java.lang.String cATaxItemHasAltvExchangeRate;
    public final static SimpleProperty.String<GLItem> CA_TAX_ITEM_HAS_ALTV_EXCHANGE_RATE =
        new SimpleProperty.String<GLItem>(GLItem.class, "CATaxItemHasAltvExchangeRate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsCashFlowItem</b>
     * </p>
     * 
     * @return Document Contains Assignments from Cash Flows
     */
    @Nullable
    @ElementName( "CAIsCashFlowItem" )
    private java.lang.Boolean cAIsCashFlowItem;
    public final static SimpleProperty.Boolean<GLItem> CA_IS_CASH_FLOW_ITEM =
        new SimpleProperty.Boolean<GLItem>(GLItem.class, "CAIsCashFlowItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CACashFlowAccount</b>
     * </p>
     * 
     * @return Originating Account in Cash Flow Anlaysis
     */
    @Nullable
    @ElementName( "CACashFlowAccount" )
    private java.lang.String cACashFlowAccount;
    public final static SimpleProperty.String<GLItem> CA_CASH_FLOW_ACCOUNT =
        new SimpleProperty.String<GLItem>(GLItem.class, "CACashFlowAccount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CACashFlowCompanyCode</b>
     * </p>
     * 
     * @return Partner Company Code for Cash Flow Analysis
     */
    @Nullable
    @ElementName( "CACashFlowCompanyCode" )
    private java.lang.String cACashFlowCompanyCode;
    public final static SimpleProperty.String<GLItem> CA_CASH_FLOW_COMPANY_CODE =
        new SimpleProperty.String<GLItem>(GLItem.class, "CACashFlowCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     * 
     * @return House Bank Key
     */
    @Nullable
    @ElementName( "HouseBank" )
    private java.lang.String houseBank;
    public final static SimpleProperty.String<GLItem> HOUSE_BANK =
        new SimpleProperty.String<GLItem>(GLItem.class, "HouseBank");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     * 
     * @return House Bank Account
     */
    @Nullable
    @ElementName( "HouseBankAccount" )
    private java.lang.String houseBankAccount;
    public final static SimpleProperty.String<GLItem> HOUSE_BANK_ACCOUNT =
        new SimpleProperty.String<GLItem>(GLItem.class, "HouseBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuantitySignCode</b>
     * </p>
     * 
     * @return Quantity +/- Sign
     */
    @Nullable
    @ElementName( "QuantitySignCode" )
    private java.lang.String quantitySignCode;
    public final static SimpleProperty.String<GLItem> QUANTITY_SIGN_CODE =
        new SimpleProperty.String<GLItem>(GLItem.class, "QuantitySignCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BankStatementShortID</b>
     * </p>
     * 
     * @return Short Key of Account Statement
     */
    @Nullable
    @ElementName( "BankStatementShortID" )
    private java.lang.String bankStatementShortID;
    public final static SimpleProperty.String<GLItem> BANK_STATEMENT_SHORT_ID =
        new SimpleProperty.String<GLItem>(GLItem.class, "BankStatementShortID");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BankStatementItem</b>
     * </p>
     * 
     * @return Memo record number (line item number in bank statement)
     */
    @Nullable
    @ElementName( "BankStatementItem" )
    private java.lang.String bankStatementItem;
    public final static SimpleProperty.String<GLItem> BANK_STATEMENT_ITEM =
        new SimpleProperty.String<GLItem>(GLItem.class, "BankStatementItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CashManagementLinkType</b>
     * </p>
     * 
     * @return Link Type
     */
    @Nullable
    @ElementName( "CashManagementLinkType" )
    private java.lang.String cashManagementLinkType;
    public final static SimpleProperty.String<GLItem> CASH_MANAGEMENT_LINK_TYPE =
        new SimpleProperty.String<GLItem>(GLItem.class, "CashManagementLinkType");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CashManagementLink</b>
     * </p>
     * 
     * @return Link ID
     */
    @Nullable
    @ElementName( "CashManagementLink" )
    private java.lang.String cashManagementLink;
    public final static SimpleProperty.String<GLItem> CASH_MANAGEMENT_LINK =
        new SimpleProperty.String<GLItem>(GLItem.class, "CashManagementLink");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAItmIsCreatedByPostgInterface</b>
     * </p>
     * 
     * @return Item Created by Posting Interface
     */
    @Nullable
    @ElementName( "CAItmIsCreatedByPostgInterface" )
    private java.lang.Boolean cAItmIsCreatedByPostgInterface;
    public final static SimpleProperty.Boolean<GLItem> CA_ITM_IS_CREATED_BY_POSTG_INTERFACE =
        new SimpleProperty.Boolean<GLItem>(GLItem.class, "CAItmIsCreatedByPostgInterface");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAStatusOfEuroConversion</b>
     * </p>
     * 
     * @return Status of Euro Conversion
     */
    @Nullable
    @ElementName( "CAStatusOfEuroConversion" )
    private java.lang.String cAStatusOfEuroConversion;
    public final static SimpleProperty.String<GLItem> CA_STATUS_OF_EURO_CONVERSION =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAStatusOfEuroConversion");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAProfitAnalysisUpdtIsDirect</b>
     * </p>
     * 
     * @return CO-PA update done directly
     */
    @Nullable
    @ElementName( "CAProfitAnalysisUpdtIsDirect" )
    private java.lang.Boolean cAProfitAnalysisUpdtIsDirect;
    public final static SimpleProperty.Boolean<GLItem> CA_PROFIT_ANALYSIS_UPDT_IS_DIRECT =
        new SimpleProperty.Boolean<GLItem>(GLItem.class, "CAProfitAnalysisUpdtIsDirect");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAInvcgGroupingKey</b>
     * </p>
     * 
     * @return Grouping Key for Invoicing
     */
    @Nullable
    @ElementName( "CAInvcgGroupingKey" )
    private java.lang.String cAInvcgGroupingKey;
    public final static SimpleProperty.String<GLItem> CA_INVCG_GROUPING_KEY =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAInvcgGroupingKey");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CACtrlFieldForAcctAssgmtDistr</b>
     * </p>
     * 
     * @return Control Field for Account Assignment Distributions
     */
    @Nullable
    @ElementName( "CACtrlFieldForAcctAssgmtDistr" )
    private java.lang.String cACtrlFieldForAcctAssgmtDistr;
    public final static SimpleProperty.String<GLItem> CA_CTRL_FIELD_FOR_ACCT_ASSGMT_DISTR =
        new SimpleProperty.String<GLItem>(GLItem.class, "CACtrlFieldForAcctAssgmtDistr");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAUpdateMethodForFundsMgmt</b>
     * </p>
     * 
     * @return Update Method for FM - FI-CA Integration
     */
    @Nullable
    @ElementName( "CAUpdateMethodForFundsMgmt" )
    private java.lang.String cAUpdateMethodForFundsMgmt;
    public final static SimpleProperty.String<GLItem> CA_UPDATE_METHOD_FOR_FUNDS_MGMT =
        new SimpleProperty.String<GLItem>(GLItem.class, "CAUpdateMethodForFundsMgmt");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OriginalFinancialMgmtArea</b>
     * </p>
     * 
     * @return Original FM Area for FM Account Assignment
     */
    @Nullable
    @ElementName( "OriginalFinancialMgmtArea" )
    private java.lang.String originalFinancialMgmtArea;
    public final static SimpleProperty.String<GLItem> ORIGINAL_FINANCIAL_MGMT_AREA =
        new SimpleProperty.String<GLItem>(GLItem.class, "OriginalFinancialMgmtArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OriglYearForFinMgmtAcctAssgmt</b>
     * </p>
     * 
     * @return Original Year for FM Account Assignment
     */
    @Nullable
    @ElementName( "OriglYearForFinMgmtAcctAssgmt" )
    private java.lang.String origlYearForFinMgmtAcctAssgmt;
    public final static SimpleProperty.String<GLItem> ORIGL_YEAR_FOR_FIN_MGMT_ACCT_ASSGMT =
        new SimpleProperty.String<GLItem>(GLItem.class, "OriglYearForFinMgmtAcctAssgmt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     * 
     * @return Document Number for Earmarked Funds
     */
    @Nullable
    @ElementName( "EarmarkedFundsDocument" )
    private java.lang.String earmarkedFundsDocument;
    public final static SimpleProperty.String<GLItem> EARMARKED_FUNDS_DOCUMENT =
        new SimpleProperty.String<GLItem>(GLItem.class, "EarmarkedFundsDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     * 
     * @return Chart of Accounts
     */
    @Nullable
    @ElementName( "ChartOfAccounts" )
    private java.lang.String chartOfAccounts;
    public final static SimpleProperty.String<GLItem> CHART_OF_ACCOUNTS =
        new SimpleProperty.String<GLItem>(GLItem.class, "ChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     * 
     * @return Country/Region Key
     */
    @Nullable
    @ElementName( "Country" )
    private java.lang.String country;
    public final static SimpleProperty.String<GLItem> COUNTRY =
        new SimpleProperty.String<GLItem>(GLItem.class, "Country");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxCalculationProcedure</b>
     * </p>
     * 
     * @return Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    @Nullable
    @ElementName( "TaxCalculationProcedure" )
    private java.lang.String taxCalculationProcedure;
    public final static SimpleProperty.String<GLItem> TAX_CALCULATION_PROCEDURE =
        new SimpleProperty.String<GLItem>(GLItem.class, "TaxCalculationProcedure");
    /**
     * Navigation property <b>_DocHeader</b> for <b>GLItem</b> to single <b>DocumentHeader</b>.
     * 
     */
    @ElementName( "_DocHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DocumentHeader to_DocHeader;
    /**
     * Use with available request builders to apply the <b>_DocHeader</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<GLItem, DocumentHeader> TO__DOC_HEADER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<GLItem, DocumentHeader>(
            GLItem.class,
            "_DocHeader",
            DocumentHeader.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<GLItem> getType()
    {
        return GLItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @param cADocumentNumber
     *            Number of a FI-CA Document
     */
    public void setCADocumentNumber( @Nullable final java.lang.String cADocumentNumber )
    {
        rememberChangedField("CADocumentNumber", this.cADocumentNumber);
        this.cADocumentNumber = cADocumentNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAGLItemNumber</b>
     * </p>
     * 
     * @param cAGLItemNumber
     *            Item Number in FI-CA Document
     */
    public void setCAGLItemNumber( @Nullable final java.lang.String cAGLItemNumber )
    {
        rememberChangedField("CAGLItemNumber", this.cAGLItemNumber);
        this.cAGLItemNumber = cAGLItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     * 
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final java.lang.String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPlace</b>
     * </p>
     * 
     * @param businessPlace
     *            Business Place
     */
    public void setBusinessPlace( @Nullable final java.lang.String businessPlace )
    {
        rememberChangedField("BusinessPlace", this.businessPlace);
        this.businessPlace = businessPlace;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     * 
     * @param segment
     *            Segment for Segmental Reporting
     */
    public void setSegment( @Nullable final java.lang.String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     * 
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final java.lang.String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCompany</b>
     * </p>
     * 
     * @param partnerCompany
     *            Company ID of Trading Partner
     */
    public void setPartnerCompany( @Nullable final java.lang.String partnerCompany )
    {
        rememberChangedField("PartnerCompany", this.partnerCompany);
        this.partnerCompany = partnerCompany;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     * 
     * @param gLAccount
     *            G/L Account
     */
    public void setGLAccount( @Nullable final java.lang.String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     * 
     * @param valueDate
     *            Value Date
     */
    public void setValueDate( @Nullable final LocalDate valueDate )
    {
        rememberChangedField("ValueDate", this.valueDate);
        this.valueDate = valueDate;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>CAExchangeRate</b>
     * </p>
     * 
     * @param cAExchangeRate
     *            Absolute Exchange Rate
     */
    public void setCAExchangeRate( @Nullable final BigDecimal cAExchangeRate )
    {
        rememberChangedField("CAExchangeRate", this.cAExchangeRate);
        this.cAExchangeRate = cAExchangeRate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchRateIsIndirectQuotation</b>
     * </p>
     * 
     * @param exchRateIsIndirectQuotation
     *            Exchange Rate Is Indirect Quotation
     */
    public void setExchRateIsIndirectQuotation( @Nullable final java.lang.Boolean exchRateIsIndirectQuotation )
    {
        rememberChangedField("ExchRateIsIndirectQuotation", this.exchRateIsIndirectQuotation);
        this.exchRateIsIndirectQuotation = exchRateIsIndirectQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final java.lang.String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     * 
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final java.lang.String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInLocalCurrency</b>
     * </p>
     * 
     * @param cAAmountInLocalCurrency
     *            The cAAmountInLocalCurrency to set.
     */
    public void setCAAmountInLocalCurrency( @Nullable final BigDecimal cAAmountInLocalCurrency )
    {
        rememberChangedField("CAAmountInLocalCurrency", this.cAAmountInLocalCurrency);
        this.cAAmountInLocalCurrency = cAAmountInLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @param cAAmountInTransactionCurrency
     *            The cAAmountInTransactionCurrency to set.
     */
    public void setCAAmountInTransactionCurrency( @Nullable final BigDecimal cAAmountInTransactionCurrency )
    {
        rememberChangedField("CAAmountInTransactionCurrency", this.cAAmountInTransactionCurrency);
        this.cAAmountInTransactionCurrency = cAAmountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInSecondCurrency</b>
     * </p>
     * 
     * @param cAAmountInSecondCurrency
     *            The cAAmountInSecondCurrency to set.
     */
    public void setCAAmountInSecondCurrency( @Nullable final BigDecimal cAAmountInSecondCurrency )
    {
        rememberChangedField("CAAmountInSecondCurrency", this.cAAmountInSecondCurrency);
        this.cAAmountInSecondCurrency = cAAmountInSecondCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInThirdCurrency</b>
     * </p>
     * 
     * @param cAAmountInThirdCurrency
     *            The cAAmountInThirdCurrency to set.
     */
    public void setCAAmountInThirdCurrency( @Nullable final BigDecimal cAAmountInThirdCurrency )
    {
        rememberChangedField("CAAmountInThirdCurrency", this.cAAmountInThirdCurrency);
        this.cAAmountInThirdCurrency = cAAmountInThirdCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAAccountAssignmentCategory</b>
     * </p>
     * 
     * @param cAAccountAssignmentCategory
     *            Account Assignment Category
     */
    public void setCAAccountAssignmentCategory( @Nullable final java.lang.String cAAccountAssignmentCategory )
    {
        rememberChangedField("CAAccountAssignmentCategory", this.cAAccountAssignmentCategory);
        this.cAAccountAssignmentCategory = cAAccountAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CAAccountAssignment</b>
     * </p>
     * 
     * @param cAAccountAssignment
     *            Acct assnmnt string for industry-specific account assngments
     */
    public void setCAAccountAssignment( @Nullable final java.lang.String cAAccountAssignment )
    {
        rememberChangedField("CAAccountAssignment", this.cAAccountAssignment);
        this.cAAccountAssignment = cAAccountAssignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     * 
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final java.lang.String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     * 
     * @param salesOrder
     *            Sales Order Number
     */
    public void setSalesOrder( @Nullable final java.lang.String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     * 
     * @param salesOrderItem
     *            Item number in Sales Order
     */
    public void setSalesOrderItem( @Nullable final java.lang.String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAReconciliationKey</b>
     * </p>
     * 
     * @param cAReconciliationKey
     *            Reconciliation Key for General Ledger
     */
    public void setCAReconciliationKey( @Nullable final java.lang.String cAReconciliationKey )
    {
        rememberChangedField("CAReconciliationKey", this.cAReconciliationKey);
        this.cAReconciliationKey = cAReconciliationKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAInternalPostingReasonCode</b>
     * </p>
     * 
     * @param cAInternalPostingReasonCode
     *            Reason for Automatic Creation of Posting
     */
    public void setCAInternalPostingReasonCode( @Nullable final java.lang.String cAInternalPostingReasonCode )
    {
        rememberChangedField("CAInternalPostingReasonCode", this.cAInternalPostingReasonCode);
        this.cAInternalPostingReasonCode = cAInternalPostingReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CANegativePostingControlCode</b>
     * </p>
     * 
     * @param cANegativePostingControlCode
     *            Control Field for Negative Posting
     */
    public void setCANegativePostingControlCode( @Nullable final java.lang.String cANegativePostingControlCode )
    {
        rememberChangedField("CANegativePostingControlCode", this.cANegativePostingControlCode);
        this.cANegativePostingControlCode = cANegativePostingControlCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CAGLPostingCurrency</b>
     * </p>
     * 
     * @param cAGLPostingCurrency
     *            Update Currency for General Ledger Transaction Figures
     */
    public void setCAGLPostingCurrency( @Nullable final java.lang.String cAGLPostingCurrency )
    {
        rememberChangedField("CAGLPostingCurrency", this.cAGLPostingCurrency);
        this.cAGLPostingCurrency = cAGLPostingCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGroup</b>
     * </p>
     * 
     * @param ledgerGroup
     *            Ledger Group
     */
    public void setLedgerGroup( @Nullable final java.lang.String ledgerGroup )
    {
        rememberChangedField("LedgerGroup", this.ledgerGroup);
        this.ledgerGroup = ledgerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegment</b>
     * </p>
     * 
     * @param profitabilitySegment
     *            Profitability Segment Number (CO-PA)
     */
    public void setProfitabilitySegment( @Nullable final java.lang.String profitabilitySegment )
    {
        rememberChangedField("ProfitabilitySegment", this.profitabilitySegment);
        this.profitabilitySegment = profitabilitySegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProfitabilitySegmentChanges</b>
     * </p>
     * 
     * @param profitabilitySegmentChanges
     *            Profitability Segment Changes (CO-PA)
     */
    public void setProfitabilitySegmentChanges( @Nullable final java.lang.String profitabilitySegmentChanges )
    {
        rememberChangedField("ProfitabilitySegmentChanges", this.profitabilitySegmentChanges);
        this.profitabilitySegmentChanges = profitabilitySegmentChanges;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PlanningLevel</b>
     * </p>
     * 
     * @param planningLevel
     *            Planning Level
     */
    public void setPlanningLevel( @Nullable final java.lang.String planningLevel )
    {
        rememberChangedField("PlanningLevel", this.planningLevel);
        this.planningLevel = planningLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CARepetitionGroup</b>
     * </p>
     * 
     * @param cARepetitionGroup
     *            Repetition group
     */
    public void setCARepetitionGroup( @Nullable final java.lang.String cARepetitionGroup )
    {
        rememberChangedField("CARepetitionGroup", this.cARepetitionGroup);
        this.cARepetitionGroup = cARepetitionGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CATransactionKeyAccountDetn</b>
     * </p>
     * 
     * @param cATransactionKeyAccountDetn
     *            Transaction key for account determination
     */
    public void setCATransactionKeyAccountDetn( @Nullable final java.lang.String cATransactionKeyAccountDetn )
    {
        rememberChangedField("CATransactionKeyAccountDetn", this.cATransactionKeyAccountDetn);
        this.cATransactionKeyAccountDetn = cATransactionKeyAccountDetn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final java.lang.String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsSeparateLineItemInGL</b>
     * </p>
     * 
     * @param cAIsSeparateLineItemInGL
     *            Create Line Item in General Ledger
     */
    public void setCAIsSeparateLineItemInGL( @Nullable final java.lang.Boolean cAIsSeparateLineItemInGL )
    {
        rememberChangedField("CAIsSeparateLineItemInGL", this.cAIsSeparateLineItemInGL);
        this.cAIsSeparateLineItemInGL = cAIsSeparateLineItemInGL;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     * 
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final java.lang.String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     * 
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final java.lang.String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CASupplementaryTaxCode</b>
     * </p>
     * 
     * @param cASupplementaryTaxCode
     *            Supplementary Tax
     */
    public void setCASupplementaryTaxCode( @Nullable final java.lang.String cASupplementaryTaxCode )
    {
        rememberChangedField("CASupplementaryTaxCode", this.cASupplementaryTaxCode);
        this.cASupplementaryTaxCode = cASupplementaryTaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAWithholdingTaxSupplement</b>
     * </p>
     * 
     * @param cAWithholdingTaxSupplement
     *            Withholding Tax Supplement
     */
    public void setCAWithholdingTaxSupplement( @Nullable final java.lang.String cAWithholdingTaxSupplement )
    {
        rememberChangedField("CAWithholdingTaxSupplement", this.cAWithholdingTaxSupplement);
        this.cAWithholdingTaxSupplement = cAWithholdingTaxSupplement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAOtherTaxCode</b>
     * </p>
     * 
     * @param cAOtherTaxCode
     *            Tax Code for Other Taxes
     */
    public void setCAOtherTaxCode( @Nullable final java.lang.String cAOtherTaxCode )
    {
        rememberChangedField("CAOtherTaxCode", this.cAOtherTaxCode);
        this.cAOtherTaxCode = cAOtherTaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CAGroupingCodeForTaxItems</b>
     * </p>
     * 
     * @param cAGroupingCodeForTaxItems
     *            Grouping Key for Tax Items
     */
    public void setCAGroupingCodeForTaxItems( @Nullable final java.lang.String cAGroupingCodeForTaxItems )
    {
        rememberChangedField("CAGroupingCodeForTaxItems", this.cAGroupingCodeForTaxItems);
        this.cAGroupingCodeForTaxItems = cAGroupingCodeForTaxItems;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     * 
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final java.lang.String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>CAEnteredTaxJurisdictionCode</b>
     * </p>
     * 
     * @param cAEnteredTaxJurisdictionCode
     *            Tax Jurisdiction Code (Entered value)
     */
    public void setCAEnteredTaxJurisdictionCode( @Nullable final java.lang.String cAEnteredTaxJurisdictionCode )
    {
        rememberChangedField("CAEnteredTaxJurisdictionCode", this.cAEnteredTaxJurisdictionCode);
        this.cAEnteredTaxJurisdictionCode = cAEnteredTaxJurisdictionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CATaxJurisdictionLevelCounter</b>
     * </p>
     * 
     * @param cATaxJurisdictionLevelCounter
     *            Level Counter for Multi-Level Taxes in Tax Jurisdiction
     */
    public void setCATaxJurisdictionLevelCounter( @Nullable final java.lang.String cATaxJurisdictionLevelCounter )
    {
        rememberChangedField("CATaxJurisdictionLevelCounter", this.cATaxJurisdictionLevelCounter);
        this.cATaxJurisdictionLevelCounter = cATaxJurisdictionLevelCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CATaxExceptionID</b>
     * </p>
     * 
     * @param cATaxExceptionID
     *            Key for tax exception
     */
    public void setCATaxExceptionID( @Nullable final java.lang.String cATaxExceptionID )
    {
        rememberChangedField("CATaxExceptionID", this.cATaxExceptionID);
        this.cATaxExceptionID = cATaxExceptionID;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CATaxDate</b>
     * </p>
     * 
     * @param cATaxDate
     *            Decisive Date for Calculating Taxes
     */
    public void setCATaxDate( @Nullable final LocalDate cATaxDate )
    {
        rememberChangedField("CATaxDate", this.cATaxDate);
        this.cATaxDate = cATaxDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxBaseAmountInLocalCurrency</b>
     * </p>
     * 
     * @param cATaxBaseAmountInLocalCurrency
     *            The cATaxBaseAmountInLocalCurrency to set.
     */
    public void setCATaxBaseAmountInLocalCurrency( @Nullable final BigDecimal cATaxBaseAmountInLocalCurrency )
    {
        rememberChangedField("CATaxBaseAmountInLocalCurrency", this.cATaxBaseAmountInLocalCurrency);
        this.cATaxBaseAmountInLocalCurrency = cATaxBaseAmountInLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxBaseAmount</b>
     * </p>
     * 
     * @param cATaxBaseAmount
     *            The cATaxBaseAmount to set.
     */
    public void setCATaxBaseAmount( @Nullable final BigDecimal cATaxBaseAmount )
    {
        rememberChangedField("CATaxBaseAmount", this.cATaxBaseAmount);
        this.cATaxBaseAmount = cATaxBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CANonDeductibleTxAmtInDocCrcy</b>
     * </p>
     * 
     * @param cANonDeductibleTxAmtInDocCrcy
     *            The cANonDeductibleTxAmtInDocCrcy to set.
     */
    public void setCANonDeductibleTxAmtInDocCrcy( @Nullable final BigDecimal cANonDeductibleTxAmtInDocCrcy )
    {
        rememberChangedField("CANonDeductibleTxAmtInDocCrcy", this.cANonDeductibleTxAmtInDocCrcy);
        this.cANonDeductibleTxAmtInDocCrcy = cANonDeductibleTxAmtInDocCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CANonDeductibleTxAmtInLoclCrcy</b>
     * </p>
     * 
     * @param cANonDeductibleTxAmtInLoclCrcy
     *            The cANonDeductibleTxAmtInLoclCrcy to set.
     */
    public void setCANonDeductibleTxAmtInLoclCrcy( @Nullable final BigDecimal cANonDeductibleTxAmtInLoclCrcy )
    {
        rememberChangedField("CANonDeductibleTxAmtInLoclCrcy", this.cANonDeductibleTxAmtInLoclCrcy);
        this.cANonDeductibleTxAmtInLoclCrcy = cANonDeductibleTxAmtInLoclCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAContainsNonDeductibleInptTax</b>
     * </p>
     * 
     * @param cAContainsNonDeductibleInptTax
     *            Contains Non-Deductible Input Tax
     */
    public void setCAContainsNonDeductibleInptTax( @Nullable final java.lang.String cAContainsNonDeductibleInptTax )
    {
        rememberChangedField("CAContainsNonDeductibleInptTax", this.cAContainsNonDeductibleInptTax);
        this.cAContainsNonDeductibleInptTax = cAContainsNonDeductibleInptTax;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>CATaxRate</b>
     * </p>
     * 
     * @param cATaxRate
     *            Tax rate
     */
    public void setCATaxRate( @Nullable final java.lang.String cATaxRate )
    {
        rememberChangedField("CATaxRate", this.cATaxRate);
        this.cATaxRate = cATaxRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>GrossIncomeTaxActivityCode</b>
     * </p>
     * 
     * @param grossIncomeTaxActivityCode
     *            Activity Code for Gross Income Tax
     */
    public void setGrossIncomeTaxActivityCode( @Nullable final java.lang.String grossIncomeTaxActivityCode )
    {
        rememberChangedField("GrossIncomeTaxActivityCode", this.grossIncomeTaxActivityCode);
        this.grossIncomeTaxActivityCode = grossIncomeTaxActivityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EmploymentTaxDistributionType</b>
     * </p>
     * 
     * @param employmentTaxDistributionType
     *            Distribution Type for Employment Tax
     */
    public void setEmploymentTaxDistributionType( @Nullable final java.lang.String employmentTaxDistributionType )
    {
        rememberChangedField("EmploymentTaxDistributionType", this.employmentTaxDistributionType);
        this.employmentTaxDistributionType = employmentTaxDistributionType;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxPortionInLocalCurrency</b>
     * </p>
     * 
     * @param cATaxPortionInLocalCurrency
     *            The cATaxPortionInLocalCurrency to set.
     */
    public void setCATaxPortionInLocalCurrency( @Nullable final BigDecimal cATaxPortionInLocalCurrency )
    {
        rememberChangedField("CATaxPortionInLocalCurrency", this.cATaxPortionInLocalCurrency);
        this.cATaxPortionInLocalCurrency = cATaxPortionInLocalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CATaxPortionInTransCurrency</b>
     * </p>
     * 
     * @param cATaxPortionInTransCurrency
     *            The cATaxPortionInTransCurrency to set.
     */
    public void setCATaxPortionInTransCurrency( @Nullable final BigDecimal cATaxPortionInTransCurrency )
    {
        rememberChangedField("CATaxPortionInTransCurrency", this.cATaxPortionInTransCurrency);
        this.cATaxPortionInTransCurrency = cATaxPortionInTransCurrency;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CATaxIsCalculatedExternally</b>
     * </p>
     * 
     * @param cATaxIsCalculatedExternally
     *            Tax on Sales/Purchases Was Calculated by Document
     */
    public void setCATaxIsCalculatedExternally( @Nullable final java.lang.Boolean cATaxIsCalculatedExternally )
    {
        rememberChangedField("CATaxIsCalculatedExternally", this.cATaxIsCalculatedExternally);
        this.cATaxIsCalculatedExternally = cATaxIsCalculatedExternally;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CATaxItemHasAltvExchangeRate</b>
     * </p>
     * 
     * @param cATaxItemHasAltvExchangeRate
     *            Alternative Exchange Rate for Tax Items
     */
    public void setCATaxItemHasAltvExchangeRate( @Nullable final java.lang.String cATaxItemHasAltvExchangeRate )
    {
        rememberChangedField("CATaxItemHasAltvExchangeRate", this.cATaxItemHasAltvExchangeRate);
        this.cATaxItemHasAltvExchangeRate = cATaxItemHasAltvExchangeRate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAIsCashFlowItem</b>
     * </p>
     * 
     * @param cAIsCashFlowItem
     *            Document Contains Assignments from Cash Flows
     */
    public void setCAIsCashFlowItem( @Nullable final java.lang.Boolean cAIsCashFlowItem )
    {
        rememberChangedField("CAIsCashFlowItem", this.cAIsCashFlowItem);
        this.cAIsCashFlowItem = cAIsCashFlowItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CACashFlowAccount</b>
     * </p>
     * 
     * @param cACashFlowAccount
     *            Originating Account in Cash Flow Anlaysis
     */
    public void setCACashFlowAccount( @Nullable final java.lang.String cACashFlowAccount )
    {
        rememberChangedField("CACashFlowAccount", this.cACashFlowAccount);
        this.cACashFlowAccount = cACashFlowAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CACashFlowCompanyCode</b>
     * </p>
     * 
     * @param cACashFlowCompanyCode
     *            Partner Company Code for Cash Flow Analysis
     */
    public void setCACashFlowCompanyCode( @Nullable final java.lang.String cACashFlowCompanyCode )
    {
        rememberChangedField("CACashFlowCompanyCode", this.cACashFlowCompanyCode);
        this.cACashFlowCompanyCode = cACashFlowCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBank</b>
     * </p>
     * 
     * @param houseBank
     *            House Bank Key
     */
    public void setHouseBank( @Nullable final java.lang.String houseBank )
    {
        rememberChangedField("HouseBank", this.houseBank);
        this.houseBank = houseBank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HouseBankAccount</b>
     * </p>
     * 
     * @param houseBankAccount
     *            House Bank Account
     */
    public void setHouseBankAccount( @Nullable final java.lang.String houseBankAccount )
    {
        rememberChangedField("HouseBankAccount", this.houseBankAccount);
        this.houseBankAccount = houseBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuantitySignCode</b>
     * </p>
     * 
     * @param quantitySignCode
     *            Quantity +/- Sign
     */
    public void setQuantitySignCode( @Nullable final java.lang.String quantitySignCode )
    {
        rememberChangedField("QuantitySignCode", this.quantitySignCode);
        this.quantitySignCode = quantitySignCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BankStatementShortID</b>
     * </p>
     * 
     * @param bankStatementShortID
     *            Short Key of Account Statement
     */
    public void setBankStatementShortID( @Nullable final java.lang.String bankStatementShortID )
    {
        rememberChangedField("BankStatementShortID", this.bankStatementShortID);
        this.bankStatementShortID = bankStatementShortID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BankStatementItem</b>
     * </p>
     * 
     * @param bankStatementItem
     *            Memo record number (line item number in bank statement)
     */
    public void setBankStatementItem( @Nullable final java.lang.String bankStatementItem )
    {
        rememberChangedField("BankStatementItem", this.bankStatementItem);
        this.bankStatementItem = bankStatementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CashManagementLinkType</b>
     * </p>
     * 
     * @param cashManagementLinkType
     *            Link Type
     */
    public void setCashManagementLinkType( @Nullable final java.lang.String cashManagementLinkType )
    {
        rememberChangedField("CashManagementLinkType", this.cashManagementLinkType);
        this.cashManagementLinkType = cashManagementLinkType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CashManagementLink</b>
     * </p>
     * 
     * @param cashManagementLink
     *            Link ID
     */
    public void setCashManagementLink( @Nullable final java.lang.String cashManagementLink )
    {
        rememberChangedField("CashManagementLink", this.cashManagementLink);
        this.cashManagementLink = cashManagementLink;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAItmIsCreatedByPostgInterface</b>
     * </p>
     * 
     * @param cAItmIsCreatedByPostgInterface
     *            Item Created by Posting Interface
     */
    public void setCAItmIsCreatedByPostgInterface( @Nullable final java.lang.Boolean cAItmIsCreatedByPostgInterface )
    {
        rememberChangedField("CAItmIsCreatedByPostgInterface", this.cAItmIsCreatedByPostgInterface);
        this.cAItmIsCreatedByPostgInterface = cAItmIsCreatedByPostgInterface;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAStatusOfEuroConversion</b>
     * </p>
     * 
     * @param cAStatusOfEuroConversion
     *            Status of Euro Conversion
     */
    public void setCAStatusOfEuroConversion( @Nullable final java.lang.String cAStatusOfEuroConversion )
    {
        rememberChangedField("CAStatusOfEuroConversion", this.cAStatusOfEuroConversion);
        this.cAStatusOfEuroConversion = cAStatusOfEuroConversion;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAProfitAnalysisUpdtIsDirect</b>
     * </p>
     * 
     * @param cAProfitAnalysisUpdtIsDirect
     *            CO-PA update done directly
     */
    public void setCAProfitAnalysisUpdtIsDirect( @Nullable final java.lang.Boolean cAProfitAnalysisUpdtIsDirect )
    {
        rememberChangedField("CAProfitAnalysisUpdtIsDirect", this.cAProfitAnalysisUpdtIsDirect);
        this.cAProfitAnalysisUpdtIsDirect = cAProfitAnalysisUpdtIsDirect;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAInvcgGroupingKey</b>
     * </p>
     * 
     * @param cAInvcgGroupingKey
     *            Grouping Key for Invoicing
     */
    public void setCAInvcgGroupingKey( @Nullable final java.lang.String cAInvcgGroupingKey )
    {
        rememberChangedField("CAInvcgGroupingKey", this.cAInvcgGroupingKey);
        this.cAInvcgGroupingKey = cAInvcgGroupingKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CACtrlFieldForAcctAssgmtDistr</b>
     * </p>
     * 
     * @param cACtrlFieldForAcctAssgmtDistr
     *            Control Field for Account Assignment Distributions
     */
    public void setCACtrlFieldForAcctAssgmtDistr( @Nullable final java.lang.String cACtrlFieldForAcctAssgmtDistr )
    {
        rememberChangedField("CACtrlFieldForAcctAssgmtDistr", this.cACtrlFieldForAcctAssgmtDistr);
        this.cACtrlFieldForAcctAssgmtDistr = cACtrlFieldForAcctAssgmtDistr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAUpdateMethodForFundsMgmt</b>
     * </p>
     * 
     * @param cAUpdateMethodForFundsMgmt
     *            Update Method for FM - FI-CA Integration
     */
    public void setCAUpdateMethodForFundsMgmt( @Nullable final java.lang.String cAUpdateMethodForFundsMgmt )
    {
        rememberChangedField("CAUpdateMethodForFundsMgmt", this.cAUpdateMethodForFundsMgmt);
        this.cAUpdateMethodForFundsMgmt = cAUpdateMethodForFundsMgmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OriginalFinancialMgmtArea</b>
     * </p>
     * 
     * @param originalFinancialMgmtArea
     *            Original FM Area for FM Account Assignment
     */
    public void setOriginalFinancialMgmtArea( @Nullable final java.lang.String originalFinancialMgmtArea )
    {
        rememberChangedField("OriginalFinancialMgmtArea", this.originalFinancialMgmtArea);
        this.originalFinancialMgmtArea = originalFinancialMgmtArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OriglYearForFinMgmtAcctAssgmt</b>
     * </p>
     * 
     * @param origlYearForFinMgmtAcctAssgmt
     *            Original Year for FM Account Assignment
     */
    public void setOriglYearForFinMgmtAcctAssgmt( @Nullable final java.lang.String origlYearForFinMgmtAcctAssgmt )
    {
        rememberChangedField("OriglYearForFinMgmtAcctAssgmt", this.origlYearForFinMgmtAcctAssgmt);
        this.origlYearForFinMgmtAcctAssgmt = origlYearForFinMgmtAcctAssgmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     * 
     * @param earmarkedFundsDocument
     *            Document Number for Earmarked Funds
     */
    public void setEarmarkedFundsDocument( @Nullable final java.lang.String earmarkedFundsDocument )
    {
        rememberChangedField("EarmarkedFundsDocument", this.earmarkedFundsDocument);
        this.earmarkedFundsDocument = earmarkedFundsDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ChartOfAccounts</b>
     * </p>
     * 
     * @param chartOfAccounts
     *            Chart of Accounts
     */
    public void setChartOfAccounts( @Nullable final java.lang.String chartOfAccounts )
    {
        rememberChangedField("ChartOfAccounts", this.chartOfAccounts);
        this.chartOfAccounts = chartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     * 
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final java.lang.String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxCalculationProcedure</b>
     * </p>
     * 
     * @param taxCalculationProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    public void setTaxCalculationProcedure( @Nullable final java.lang.String taxCalculationProcedure )
    {
        rememberChangedField("TaxCalculationProcedure", this.taxCalculationProcedure);
        this.taxCalculationProcedure = taxCalculationProcedure;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "GLItem";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentNumber", getCADocumentNumber());
        entityKey.addKeyProperty("CAGLItemNumber", getCAGLItemNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentNumber", getCADocumentNumber());
        values.put("CAGLItemNumber", getCAGLItemNumber());
        values.put("CompanyCode", getCompanyCode());
        values.put("BusinessArea", getBusinessArea());
        values.put("BusinessPlace", getBusinessPlace());
        values.put("Segment", getSegment());
        values.put("ProfitCenter", getProfitCenter());
        values.put("PartnerCompany", getPartnerCompany());
        values.put("GLAccount", getGLAccount());
        values.put("ValueDate", getValueDate());
        values.put("CAExchangeRate", getCAExchangeRate());
        values.put("ExchRateIsIndirectQuotation", getExchRateIsIndirectQuotation());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("Currency", getCurrency());
        values.put("CAAmountInLocalCurrency", getCAAmountInLocalCurrency());
        values.put("CAAmountInTransactionCurrency", getCAAmountInTransactionCurrency());
        values.put("CAAmountInSecondCurrency", getCAAmountInSecondCurrency());
        values.put("CAAmountInThirdCurrency", getCAAmountInThirdCurrency());
        values.put("CAAccountAssignmentCategory", getCAAccountAssignmentCategory());
        values.put("CAAccountAssignment", getCAAccountAssignment());
        values.put("CostCenter", getCostCenter());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("CAReconciliationKey", getCAReconciliationKey());
        values.put("CAInternalPostingReasonCode", getCAInternalPostingReasonCode());
        values.put("CANegativePostingControlCode", getCANegativePostingControlCode());
        values.put("CAGLPostingCurrency", getCAGLPostingCurrency());
        values.put("LedgerGroup", getLedgerGroup());
        values.put("ProfitabilitySegment", getProfitabilitySegment());
        values.put("ProfitabilitySegmentChanges", getProfitabilitySegmentChanges());
        values.put("PlanningLevel", getPlanningLevel());
        values.put("CARepetitionGroup", getCARepetitionGroup());
        values.put("CATransactionKeyAccountDetn", getCATransactionKeyAccountDetn());
        values.put("ConditionType", getConditionType());
        values.put("CAIsSeparateLineItemInGL", getCAIsSeparateLineItemInGL());
        values.put("BaseUnit", getBaseUnit());
        values.put("TaxCode", getTaxCode());
        values.put("CASupplementaryTaxCode", getCASupplementaryTaxCode());
        values.put("CAWithholdingTaxSupplement", getCAWithholdingTaxSupplement());
        values.put("CAOtherTaxCode", getCAOtherTaxCode());
        values.put("CAGroupingCodeForTaxItems", getCAGroupingCodeForTaxItems());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("CAEnteredTaxJurisdictionCode", getCAEnteredTaxJurisdictionCode());
        values.put("CATaxJurisdictionLevelCounter", getCATaxJurisdictionLevelCounter());
        values.put("CATaxExceptionID", getCATaxExceptionID());
        values.put("CATaxDate", getCATaxDate());
        values.put("CATaxBaseAmountInLocalCurrency", getCATaxBaseAmountInLocalCurrency());
        values.put("CATaxBaseAmount", getCATaxBaseAmount());
        values.put("CANonDeductibleTxAmtInDocCrcy", getCANonDeductibleTxAmtInDocCrcy());
        values.put("CANonDeductibleTxAmtInLoclCrcy", getCANonDeductibleTxAmtInLoclCrcy());
        values.put("CAContainsNonDeductibleInptTax", getCAContainsNonDeductibleInptTax());
        values.put("CATaxRate", getCATaxRate());
        values.put("GrossIncomeTaxActivityCode", getGrossIncomeTaxActivityCode());
        values.put("EmploymentTaxDistributionType", getEmploymentTaxDistributionType());
        values.put("CATaxPortionInLocalCurrency", getCATaxPortionInLocalCurrency());
        values.put("CATaxPortionInTransCurrency", getCATaxPortionInTransCurrency());
        values.put("CATaxIsCalculatedExternally", getCATaxIsCalculatedExternally());
        values.put("CATaxItemHasAltvExchangeRate", getCATaxItemHasAltvExchangeRate());
        values.put("CAIsCashFlowItem", getCAIsCashFlowItem());
        values.put("CACashFlowAccount", getCACashFlowAccount());
        values.put("CACashFlowCompanyCode", getCACashFlowCompanyCode());
        values.put("HouseBank", getHouseBank());
        values.put("HouseBankAccount", getHouseBankAccount());
        values.put("QuantitySignCode", getQuantitySignCode());
        values.put("BankStatementShortID", getBankStatementShortID());
        values.put("BankStatementItem", getBankStatementItem());
        values.put("CashManagementLinkType", getCashManagementLinkType());
        values.put("CashManagementLink", getCashManagementLink());
        values.put("CAItmIsCreatedByPostgInterface", getCAItmIsCreatedByPostgInterface());
        values.put("CAStatusOfEuroConversion", getCAStatusOfEuroConversion());
        values.put("CAProfitAnalysisUpdtIsDirect", getCAProfitAnalysisUpdtIsDirect());
        values.put("CAInvcgGroupingKey", getCAInvcgGroupingKey());
        values.put("CACtrlFieldForAcctAssgmtDistr", getCACtrlFieldForAcctAssgmtDistr());
        values.put("CAUpdateMethodForFundsMgmt", getCAUpdateMethodForFundsMgmt());
        values.put("OriginalFinancialMgmtArea", getOriginalFinancialMgmtArea());
        values.put("OriglYearForFinMgmtAcctAssgmt", getOriglYearForFinMgmtAcctAssgmt());
        values.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        values.put("ChartOfAccounts", getChartOfAccounts());
        values.put("Country", getCountry());
        values.put("TaxCalculationProcedure", getTaxCalculationProcedure());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentNumber") ) {
                final Object value = values.remove("CADocumentNumber");
                if( (value == null) || (!value.equals(getCADocumentNumber())) ) {
                    setCADocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGLItemNumber") ) {
                final Object value = values.remove("CAGLItemNumber");
                if( (value == null) || (!value.equals(getCAGLItemNumber())) ) {
                    setCAGLItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPlace") ) {
                final Object value = values.remove("BusinessPlace");
                if( (value == null) || (!value.equals(getBusinessPlace())) ) {
                    setBusinessPlace(((java.lang.String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("PartnerCompany") ) {
                final Object value = values.remove("PartnerCompany");
                if( (value == null) || (!value.equals(getPartnerCompany())) ) {
                    setPartnerCompany(((java.lang.String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValueDate") ) {
                final Object value = values.remove("ValueDate");
                if( (value == null) || (!value.equals(getValueDate())) ) {
                    setValueDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAExchangeRate") ) {
                final Object value = values.remove("CAExchangeRate");
                if( (value == null) || (!value.equals(getCAExchangeRate())) ) {
                    setCAExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExchRateIsIndirectQuotation") ) {
                final Object value = values.remove("ExchRateIsIndirectQuotation");
                if( (value == null) || (!value.equals(getExchRateIsIndirectQuotation())) ) {
                    setExchRateIsIndirectQuotation(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAmountInLocalCurrency") ) {
                final Object value = values.remove("CAAmountInLocalCurrency");
                if( (value == null) || (!value.equals(getCAAmountInLocalCurrency())) ) {
                    setCAAmountInLocalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAAmountInTransactionCurrency") ) {
                final Object value = values.remove("CAAmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getCAAmountInTransactionCurrency())) ) {
                    setCAAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAAmountInSecondCurrency") ) {
                final Object value = values.remove("CAAmountInSecondCurrency");
                if( (value == null) || (!value.equals(getCAAmountInSecondCurrency())) ) {
                    setCAAmountInSecondCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAAmountInThirdCurrency") ) {
                final Object value = values.remove("CAAmountInThirdCurrency");
                if( (value == null) || (!value.equals(getCAAmountInThirdCurrency())) ) {
                    setCAAmountInThirdCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAAccountAssignmentCategory") ) {
                final Object value = values.remove("CAAccountAssignmentCategory");
                if( (value == null) || (!value.equals(getCAAccountAssignmentCategory())) ) {
                    setCAAccountAssignmentCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAccountAssignment") ) {
                final Object value = values.remove("CAAccountAssignment");
                if( (value == null) || (!value.equals(getCAAccountAssignment())) ) {
                    setCAAccountAssignment(((java.lang.String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAReconciliationKey") ) {
                final Object value = values.remove("CAReconciliationKey");
                if( (value == null) || (!value.equals(getCAReconciliationKey())) ) {
                    setCAReconciliationKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAInternalPostingReasonCode") ) {
                final Object value = values.remove("CAInternalPostingReasonCode");
                if( (value == null) || (!value.equals(getCAInternalPostingReasonCode())) ) {
                    setCAInternalPostingReasonCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CANegativePostingControlCode") ) {
                final Object value = values.remove("CANegativePostingControlCode");
                if( (value == null) || (!value.equals(getCANegativePostingControlCode())) ) {
                    setCANegativePostingControlCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGLPostingCurrency") ) {
                final Object value = values.remove("CAGLPostingCurrency");
                if( (value == null) || (!value.equals(getCAGLPostingCurrency())) ) {
                    setCAGLPostingCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("LedgerGroup") ) {
                final Object value = values.remove("LedgerGroup");
                if( (value == null) || (!value.equals(getLedgerGroup())) ) {
                    setLedgerGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProfitabilitySegment") ) {
                final Object value = values.remove("ProfitabilitySegment");
                if( (value == null) || (!value.equals(getProfitabilitySegment())) ) {
                    setProfitabilitySegment(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProfitabilitySegmentChanges") ) {
                final Object value = values.remove("ProfitabilitySegmentChanges");
                if( (value == null) || (!value.equals(getProfitabilitySegmentChanges())) ) {
                    setProfitabilitySegmentChanges(((java.lang.String) value));
                }
            }
            if( values.containsKey("PlanningLevel") ) {
                final Object value = values.remove("PlanningLevel");
                if( (value == null) || (!value.equals(getPlanningLevel())) ) {
                    setPlanningLevel(((java.lang.String) value));
                }
            }
            if( values.containsKey("CARepetitionGroup") ) {
                final Object value = values.remove("CARepetitionGroup");
                if( (value == null) || (!value.equals(getCARepetitionGroup())) ) {
                    setCARepetitionGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("CATransactionKeyAccountDetn") ) {
                final Object value = values.remove("CATransactionKeyAccountDetn");
                if( (value == null) || (!value.equals(getCATransactionKeyAccountDetn())) ) {
                    setCATransactionKeyAccountDetn(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAIsSeparateLineItemInGL") ) {
                final Object value = values.remove("CAIsSeparateLineItemInGL");
                if( (value == null) || (!value.equals(getCAIsSeparateLineItemInGL())) ) {
                    setCAIsSeparateLineItemInGL(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASupplementaryTaxCode") ) {
                final Object value = values.remove("CASupplementaryTaxCode");
                if( (value == null) || (!value.equals(getCASupplementaryTaxCode())) ) {
                    setCASupplementaryTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAWithholdingTaxSupplement") ) {
                final Object value = values.remove("CAWithholdingTaxSupplement");
                if( (value == null) || (!value.equals(getCAWithholdingTaxSupplement())) ) {
                    setCAWithholdingTaxSupplement(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAOtherTaxCode") ) {
                final Object value = values.remove("CAOtherTaxCode");
                if( (value == null) || (!value.equals(getCAOtherTaxCode())) ) {
                    setCAOtherTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGroupingCodeForTaxItems") ) {
                final Object value = values.remove("CAGroupingCodeForTaxItems");
                if( (value == null) || (!value.equals(getCAGroupingCodeForTaxItems())) ) {
                    setCAGroupingCodeForTaxItems(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAEnteredTaxJurisdictionCode") ) {
                final Object value = values.remove("CAEnteredTaxJurisdictionCode");
                if( (value == null) || (!value.equals(getCAEnteredTaxJurisdictionCode())) ) {
                    setCAEnteredTaxJurisdictionCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CATaxJurisdictionLevelCounter") ) {
                final Object value = values.remove("CATaxJurisdictionLevelCounter");
                if( (value == null) || (!value.equals(getCATaxJurisdictionLevelCounter())) ) {
                    setCATaxJurisdictionLevelCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("CATaxExceptionID") ) {
                final Object value = values.remove("CATaxExceptionID");
                if( (value == null) || (!value.equals(getCATaxExceptionID())) ) {
                    setCATaxExceptionID(((java.lang.String) value));
                }
            }
            if( values.containsKey("CATaxDate") ) {
                final Object value = values.remove("CATaxDate");
                if( (value == null) || (!value.equals(getCATaxDate())) ) {
                    setCATaxDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CATaxBaseAmountInLocalCurrency") ) {
                final Object value = values.remove("CATaxBaseAmountInLocalCurrency");
                if( (value == null) || (!value.equals(getCATaxBaseAmountInLocalCurrency())) ) {
                    setCATaxBaseAmountInLocalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CATaxBaseAmount") ) {
                final Object value = values.remove("CATaxBaseAmount");
                if( (value == null) || (!value.equals(getCATaxBaseAmount())) ) {
                    setCATaxBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CANonDeductibleTxAmtInDocCrcy") ) {
                final Object value = values.remove("CANonDeductibleTxAmtInDocCrcy");
                if( (value == null) || (!value.equals(getCANonDeductibleTxAmtInDocCrcy())) ) {
                    setCANonDeductibleTxAmtInDocCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CANonDeductibleTxAmtInLoclCrcy") ) {
                final Object value = values.remove("CANonDeductibleTxAmtInLoclCrcy");
                if( (value == null) || (!value.equals(getCANonDeductibleTxAmtInLoclCrcy())) ) {
                    setCANonDeductibleTxAmtInLoclCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAContainsNonDeductibleInptTax") ) {
                final Object value = values.remove("CAContainsNonDeductibleInptTax");
                if( (value == null) || (!value.equals(getCAContainsNonDeductibleInptTax())) ) {
                    setCAContainsNonDeductibleInptTax(((java.lang.String) value));
                }
            }
            if( values.containsKey("CATaxRate") ) {
                final Object value = values.remove("CATaxRate");
                if( (value == null) || (!value.equals(getCATaxRate())) ) {
                    setCATaxRate(((java.lang.String) value));
                }
            }
            if( values.containsKey("GrossIncomeTaxActivityCode") ) {
                final Object value = values.remove("GrossIncomeTaxActivityCode");
                if( (value == null) || (!value.equals(getGrossIncomeTaxActivityCode())) ) {
                    setGrossIncomeTaxActivityCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("EmploymentTaxDistributionType") ) {
                final Object value = values.remove("EmploymentTaxDistributionType");
                if( (value == null) || (!value.equals(getEmploymentTaxDistributionType())) ) {
                    setEmploymentTaxDistributionType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CATaxPortionInLocalCurrency") ) {
                final Object value = values.remove("CATaxPortionInLocalCurrency");
                if( (value == null) || (!value.equals(getCATaxPortionInLocalCurrency())) ) {
                    setCATaxPortionInLocalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CATaxPortionInTransCurrency") ) {
                final Object value = values.remove("CATaxPortionInTransCurrency");
                if( (value == null) || (!value.equals(getCATaxPortionInTransCurrency())) ) {
                    setCATaxPortionInTransCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CATaxIsCalculatedExternally") ) {
                final Object value = values.remove("CATaxIsCalculatedExternally");
                if( (value == null) || (!value.equals(getCATaxIsCalculatedExternally())) ) {
                    setCATaxIsCalculatedExternally(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CATaxItemHasAltvExchangeRate") ) {
                final Object value = values.remove("CATaxItemHasAltvExchangeRate");
                if( (value == null) || (!value.equals(getCATaxItemHasAltvExchangeRate())) ) {
                    setCATaxItemHasAltvExchangeRate(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAIsCashFlowItem") ) {
                final Object value = values.remove("CAIsCashFlowItem");
                if( (value == null) || (!value.equals(getCAIsCashFlowItem())) ) {
                    setCAIsCashFlowItem(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CACashFlowAccount") ) {
                final Object value = values.remove("CACashFlowAccount");
                if( (value == null) || (!value.equals(getCACashFlowAccount())) ) {
                    setCACashFlowAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACashFlowCompanyCode") ) {
                final Object value = values.remove("CACashFlowCompanyCode");
                if( (value == null) || (!value.equals(getCACashFlowCompanyCode())) ) {
                    setCACashFlowCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("HouseBank") ) {
                final Object value = values.remove("HouseBank");
                if( (value == null) || (!value.equals(getHouseBank())) ) {
                    setHouseBank(((java.lang.String) value));
                }
            }
            if( values.containsKey("HouseBankAccount") ) {
                final Object value = values.remove("HouseBankAccount");
                if( (value == null) || (!value.equals(getHouseBankAccount())) ) {
                    setHouseBankAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("QuantitySignCode") ) {
                final Object value = values.remove("QuantitySignCode");
                if( (value == null) || (!value.equals(getQuantitySignCode())) ) {
                    setQuantitySignCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("BankStatementShortID") ) {
                final Object value = values.remove("BankStatementShortID");
                if( (value == null) || (!value.equals(getBankStatementShortID())) ) {
                    setBankStatementShortID(((java.lang.String) value));
                }
            }
            if( values.containsKey("BankStatementItem") ) {
                final Object value = values.remove("BankStatementItem");
                if( (value == null) || (!value.equals(getBankStatementItem())) ) {
                    setBankStatementItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("CashManagementLinkType") ) {
                final Object value = values.remove("CashManagementLinkType");
                if( (value == null) || (!value.equals(getCashManagementLinkType())) ) {
                    setCashManagementLinkType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CashManagementLink") ) {
                final Object value = values.remove("CashManagementLink");
                if( (value == null) || (!value.equals(getCashManagementLink())) ) {
                    setCashManagementLink(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAItmIsCreatedByPostgInterface") ) {
                final Object value = values.remove("CAItmIsCreatedByPostgInterface");
                if( (value == null) || (!value.equals(getCAItmIsCreatedByPostgInterface())) ) {
                    setCAItmIsCreatedByPostgInterface(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAStatusOfEuroConversion") ) {
                final Object value = values.remove("CAStatusOfEuroConversion");
                if( (value == null) || (!value.equals(getCAStatusOfEuroConversion())) ) {
                    setCAStatusOfEuroConversion(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAProfitAnalysisUpdtIsDirect") ) {
                final Object value = values.remove("CAProfitAnalysisUpdtIsDirect");
                if( (value == null) || (!value.equals(getCAProfitAnalysisUpdtIsDirect())) ) {
                    setCAProfitAnalysisUpdtIsDirect(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAInvcgGroupingKey") ) {
                final Object value = values.remove("CAInvcgGroupingKey");
                if( (value == null) || (!value.equals(getCAInvcgGroupingKey())) ) {
                    setCAInvcgGroupingKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACtrlFieldForAcctAssgmtDistr") ) {
                final Object value = values.remove("CACtrlFieldForAcctAssgmtDistr");
                if( (value == null) || (!value.equals(getCACtrlFieldForAcctAssgmtDistr())) ) {
                    setCACtrlFieldForAcctAssgmtDistr(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAUpdateMethodForFundsMgmt") ) {
                final Object value = values.remove("CAUpdateMethodForFundsMgmt");
                if( (value == null) || (!value.equals(getCAUpdateMethodForFundsMgmt())) ) {
                    setCAUpdateMethodForFundsMgmt(((java.lang.String) value));
                }
            }
            if( values.containsKey("OriginalFinancialMgmtArea") ) {
                final Object value = values.remove("OriginalFinancialMgmtArea");
                if( (value == null) || (!value.equals(getOriginalFinancialMgmtArea())) ) {
                    setOriginalFinancialMgmtArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("OriglYearForFinMgmtAcctAssgmt") ) {
                final Object value = values.remove("OriglYearForFinMgmtAcctAssgmt");
                if( (value == null) || (!value.equals(getOriglYearForFinMgmtAcctAssgmt())) ) {
                    setOriglYearForFinMgmtAcctAssgmt(((java.lang.String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocument") ) {
                final Object value = values.remove("EarmarkedFundsDocument");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocument())) ) {
                    setEarmarkedFundsDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("ChartOfAccounts") ) {
                final Object value = values.remove("ChartOfAccounts");
                if( (value == null) || (!value.equals(getChartOfAccounts())) ) {
                    setChartOfAccounts(((java.lang.String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxCalculationProcedure") ) {
                final Object value = values.remove("TaxCalculationProcedure");
                if( (value == null) || (!value.equals(getTaxCalculationProcedure())) ) {
                    setTaxCalculationProcedure(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_DocHeader") ) {
                final Object value = (values).remove("_DocHeader");
                if( value instanceof Map ) {
                    if( to_DocHeader == null ) {
                        to_DocHeader = new DocumentHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_DocHeader.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingDocumentManageService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_DocHeader != null ) {
            (values).put("_DocHeader", to_DocHeader);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>DocumentHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_DocHeader</b>.
     * <p>
     * If the navigation property for an entity <b>GLItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_DocHeader</b> is already loaded, the result will contain
     *         the <b>DocumentHeader</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<DocumentHeader> getDocHeaderIfPresent()
    {
        return Option.of(to_DocHeader);
    }

    /**
     * Overwrites the associated <b>DocumentHeader</b> entity for the loaded navigation property <b>_DocHeader</b>.
     * 
     * @param value
     *            New <b>DocumentHeader</b> entity.
     */
    public void setDocHeader( final DocumentHeader value )
    {
        to_DocHeader = value;
    }

    /**
     * Helper class to allow for fluent creation of GLItem instances.
     * 
     */
    public final static class GLItemBuilder
    {

        private DocumentHeader to_DocHeader;

        private GLItem.GLItemBuilder to_DocHeader( final DocumentHeader value )
        {
            to_DocHeader = value;
            return this;
        }

        /**
         * Navigation property <b>_DocHeader</b> for <b>GLItem</b> to single <b>DocumentHeader</b>.
         * 
         * @param value
         *            The DocumentHeader to build this GLItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GLItem.GLItemBuilder docHeader( final DocumentHeader value )
        {
            return to_DocHeader(value);
        }

    }

}
