/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdocumentmanage;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ContractAccountingDocumentManageService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document GL Item Payment Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>GLItemPaytDataType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class GLItemPaytData extends VdmEntity<GLItemPaytData> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_cadocumentmanage.v0001.GLItemPaytDataType";
    /**
     * Selector for all available fields of GLItemPaytData.
     * 
     */
    public final static SimpleProperty<GLItemPaytData> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @return Number of a FI-CA Document
     */
    @Nullable
    @ElementName( "CADocumentNumber" )
    private java.lang.String cADocumentNumber;
    public final static SimpleProperty.String<GLItemPaytData> CA_DOCUMENT_NUMBER =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CADocumentNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAGLItemNumber</b>
     * </p>
     * 
     * @return Item Number in FI-CA Document
     */
    @Nullable
    @ElementName( "CAGLItemNumber" )
    private java.lang.String cAGLItemNumber;
    public final static SimpleProperty.String<GLItemPaytData> CAGL_ITEM_NUMBER =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CAGLItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardType</b>
     * </p>
     * 
     * @return Payment Card Type
     */
    @Nullable
    @ElementName( "PaymentCardType" )
    private java.lang.String paymentCardType;
    public final static SimpleProperty.String<GLItemPaytData> PAYMENT_CARD_TYPE =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "PaymentCardType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PaytCardByDigitalPaymentSrvc</b>
     * </p>
     * 
     * @return Payment cards: Card number
     */
    @Nullable
    @ElementName( "PaytCardByDigitalPaymentSrvc" )
    private java.lang.String paytCardByDigitalPaymentSrvc;
    public final static SimpleProperty.String<GLItemPaytData> PAYT_CARD_BY_DIGITAL_PAYMENT_SRVC =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "PaytCardByDigitalPaymentSrvc");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardSequenceNumber</b>
     * </p>
     * 
     * @return Payment cards: Payment card suffix
     */
    @Nullable
    @ElementName( "PaymentCardSequenceNumber" )
    private java.lang.String paymentCardSequenceNumber;
    public final static SimpleProperty.String<GLItemPaytData> PAYMENT_CARD_SEQUENCE_NUMBER =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "PaymentCardSequenceNumber");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardValidityStartDate</b>
     * </p>
     * 
     * @return Payment cards: Valid from
     */
    @Nullable
    @ElementName( "PaymentCardValidityStartDate" )
    private LocalDate paymentCardValidityStartDate;
    public final static SimpleProperty.Date<GLItemPaytData> PAYMENT_CARD_VALIDITY_START_DATE =
        new SimpleProperty.Date<GLItemPaytData>(GLItemPaytData.class, "PaymentCardValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardValidityEndDate</b>
     * </p>
     * 
     * @return Payment Cards: Valid To
     */
    @Nullable
    @ElementName( "PaymentCardValidityEndDate" )
    private LocalDate paymentCardValidityEndDate;
    public final static SimpleProperty.Date<GLItemPaytData> PAYMENT_CARD_VALIDITY_END_DATE =
        new SimpleProperty.Date<GLItemPaytData>(GLItemPaytData.class, "PaymentCardValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardHolderName</b>
     * </p>
     * 
     * @return Payment Cards: Name of Cardholder
     */
    @Nullable
    @ElementName( "PaymentCardHolderName" )
    private java.lang.String paymentCardHolderName;
    public final static SimpleProperty.String<GLItemPaytData> PAYMENT_CARD_HOLDER_NAME =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "PaymentCardHolderName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardMaskedNumber</b>
     * </p>
     * 
     * @return Masked Payment Card Number ( Digital Payment )
     */
    @Nullable
    @ElementName( "PaymentCardMaskedNumber" )
    private java.lang.String paymentCardMaskedNumber;
    public final static SimpleProperty.String<GLItemPaytData> PAYMENT_CARD_MASKED_NUMBER =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "PaymentCardMaskedNumber");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthznByDigitalPaytSrvc</b>
     * </p>
     * 
     * @return Payment cards: Authorization number
     */
    @Nullable
    @ElementName( "CAAuthznByDigitalPaytSrvc" )
    private java.lang.String cAAuthznByDigitalPaytSrvc;
    public final static SimpleProperty.String<GLItemPaytData> CA_AUTHZN_BY_DIGITAL_PAYT_SRVC =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CAAuthznByDigitalPaytSrvc");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationByAcquirer</b>
     * </p>
     * 
     * @return Payment Cards: Authorization Reference Number
     */
    @Nullable
    @ElementName( "CAAuthorizationByAcquirer" )
    private java.lang.String cAAuthorizationByAcquirer;
    public final static SimpleProperty.String<GLItemPaytData> CA_AUTHORIZATION_BY_ACQUIRER =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CAAuthorizationByAcquirer");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationDate</b>
     * </p>
     * 
     * @return Payment cards: Authorization date
     */
    @Nullable
    @ElementName( "AuthorizationDate" )
    private LocalDate authorizationDate;
    public final static SimpleProperty.Date<GLItemPaytData> AUTHORIZATION_DATE =
        new SimpleProperty.Date<GLItemPaytData>(GLItemPaytData.class, "AuthorizationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationTime</b>
     * </p>
     * 
     * @return Payment cards: Authorization time
     */
    @Nullable
    @ElementName( "AuthorizationTime" )
    private LocalTime authorizationTime;
    public final static SimpleProperty.Time<GLItemPaytData> AUTHORIZATION_TIME =
        new SimpleProperty.Time<GLItemPaytData>(GLItemPaytData.class, "AuthorizationTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationType</b>
     * </p>
     * 
     * @return Payment cards: Authorization type
     */
    @Nullable
    @ElementName( "CAAuthorizationType" )
    private java.lang.String cAAuthorizationType;
    public final static SimpleProperty.String<GLItemPaytData> CA_AUTHORIZATION_TYPE =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CAAuthorizationType");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizedAmountInAuthznCrcy</b>
     * </p>
     * 
     * @return The authorizedAmountInAuthznCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "AuthorizedAmountInAuthznCrcy" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal authorizedAmountInAuthznCrcy;
    public final static SimpleProperty.NumericDecimal<GLItemPaytData> AUTHORIZED_AMOUNT_IN_AUTHZN_CRCY =
        new SimpleProperty.NumericDecimal<GLItemPaytData>(GLItemPaytData.class, "AuthorizedAmountInAuthznCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationCurrency</b>
     * </p>
     * 
     * @return Currency Key
     */
    @Nullable
    @ElementName( "AuthorizationCurrency" )
    private java.lang.String authorizationCurrency;
    public final static SimpleProperty.String<GLItemPaytData> AUTHORIZATION_CURRENCY =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "AuthorizationCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>MerchantByClearingHouse</b>
     * </p>
     * 
     * @return Payment cards: Merchant ID at the clearing house
     */
    @Nullable
    @ElementName( "MerchantByClearingHouse" )
    private java.lang.String merchantByClearingHouse;
    public final static SimpleProperty.String<GLItemPaytData> MERCHANT_BY_CLEARING_HOUSE =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "MerchantByClearingHouse");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationExpirationDate</b>
     * </p>
     * 
     * @return Payment Cards: Authorization Expiry Date
     */
    @Nullable
    @ElementName( "AuthorizationExpirationDate" )
    private LocalDate authorizationExpirationDate;
    public final static SimpleProperty.Date<GLItemPaytData> AUTHORIZATION_EXPIRATION_DATE =
        new SimpleProperty.Date<GLItemPaytData>(GLItemPaytData.class, "AuthorizationExpirationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationExpirationTime</b>
     * </p>
     * 
     * @return Payment Cards: Authorization Expiration Time
     */
    @Nullable
    @ElementName( "AuthorizationExpirationTime" )
    private LocalTime authorizationExpirationTime;
    public final static SimpleProperty.Time<GLItemPaytData> AUTHORIZATION_EXPIRATION_TIME =
        new SimpleProperty.Time<GLItemPaytData>(GLItemPaytData.class, "AuthorizationExpirationTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentIDAuthznWithBilling</b>
     * </p>
     * 
     * @return Payment Cards: Payment ID (Authorization with Billing)
     */
    @Nullable
    @ElementName( "CAPaymentIDAuthznWithBilling" )
    private java.lang.String cAPaymentIDAuthznWithBilling;
    public final static SimpleProperty.String<GLItemPaytData> CA_PAYMENT_ID_AUTHZN_WITH_BILLING =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CAPaymentIDAuthznWithBilling");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDate</b>
     * </p>
     * 
     * @return Posting Date in the Document
     */
    @Nullable
    @ElementName( "CAPostingDate" )
    private LocalDate cAPostingDate;
    public final static SimpleProperty.Date<GLItemPaytData> CA_POSTING_DATE =
        new SimpleProperty.Date<GLItemPaytData>(GLItemPaytData.class, "CAPostingDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @return The cAAmountInTransactionCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInTransactionCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInTransactionCurrency;
    public final static SimpleProperty.NumericDecimal<GLItemPaytData> CA_AMOUNT_IN_TRANSACTION_CURRENCY =
        new SimpleProperty.NumericDecimal<GLItemPaytData>(GLItemPaytData.class, "CAAmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @return Currency Key
     */
    @Nullable
    @ElementName( "TransactionCurrency" )
    private java.lang.String transactionCurrency;
    public final static SimpleProperty.String<GLItemPaytData> TRANSACTION_CURRENCY =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<GLItemPaytData> COMPANY_CODE =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CompanyCode");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     * 
     * @return Value Date
     */
    @Nullable
    @ElementName( "ValueDate" )
    private LocalDate valueDate;
    public final static SimpleProperty.Date<GLItemPaytData> VALUE_DATE =
        new SimpleProperty.Date<GLItemPaytData>(GLItemPaytData.class, "ValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentBillingStatus</b>
     * </p>
     * 
     * @return Billing Status
     */
    @Nullable
    @ElementName( "CAPaymentBillingStatus" )
    private java.lang.String cAPaymentBillingStatus;
    public final static SimpleProperty.String<GLItemPaytData> CA_PAYMENT_BILLING_STATUS =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CAPaymentBillingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CASettlementMassRunID</b>
     * </p>
     * 
     * @return Payment Cards/PSP: Run ID of Settlement Run
     */
    @Nullable
    @ElementName( "CASettlementMassRunID" )
    private java.lang.String cASettlementMassRunID;
    public final static SimpleProperty.String<GLItemPaytData> CA_SETTLEMENT_MASS_RUN_ID =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CASettlementMassRunID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASettlementDocument</b>
     * </p>
     * 
     * @return Document Number of Billing Document
     */
    @Nullable
    @ElementName( "CASettlementDocument" )
    private java.lang.String cASettlementDocument;
    public final static SimpleProperty.String<GLItemPaytData> CA_SETTLEMENT_DOCUMENT =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CASettlementDocument");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPaytCardSupplementIsResent</b>
     * </p>
     * 
     * @return Payment Card Supplement Was Resent
     */
    @Nullable
    @ElementName( "CAPaytCardSupplementIsResent" )
    private java.lang.Boolean cAPaytCardSupplementIsResent;
    public final static SimpleProperty.Boolean<GLItemPaytData> CA_PAYT_CARD_SUPPLEMENT_IS_RESENT =
        new SimpleProperty.Boolean<GLItemPaytData>(GLItemPaytData.class, "CAPaytCardSupplementIsResent");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAReturnLot</b>
     * </p>
     * 
     * @return Returns Lot for a Non-Billable Payment
     */
    @Nullable
    @ElementName( "CAReturnLot" )
    private java.lang.String cAReturnLot;
    public final static SimpleProperty.String<GLItemPaytData> CA_RETURN_LOT =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CAReturnLot");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CAReturnReason</b>
     * </p>
     * 
     * @return Returns Reason for Non-Billable Payments
     */
    @Nullable
    @ElementName( "CAReturnReason" )
    private java.lang.String cAReturnReason;
    public final static SimpleProperty.String<GLItemPaytData> CA_RETURN_REASON =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CAReturnReason");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CASettlementChargeAmountInTC</b>
     * </p>
     * 
     * @return The cASettlementChargeAmountInTC contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CASettlementChargeAmountInTC" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cASettlementChargeAmountInTC;
    public final static SimpleProperty.NumericDecimal<GLItemPaytData> CA_SETTLEMENTCHARGE_AMOUNT_IN_T_C =
        new SimpleProperty.NumericDecimal<GLItemPaytData>(GLItemPaytData.class, "CASettlementChargeAmountInTC");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentCardSettlementID</b>
     * </p>
     * 
     * @return Payment Card Billing ID
     */
    @Nullable
    @ElementName( "CAPaymentCardSettlementID" )
    private java.lang.String cAPaymentCardSettlementID;
    public final static SimpleProperty.String<GLItemPaytData> CA_PAYMENT_CARD_SETTLEMENT_ID =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CAPaymentCardSettlementID");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CASettlmtAmountInSettlmtCrcy</b>
     * </p>
     * 
     * @return The cASettlmtAmountInSettlmtCrcy contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CASettlmtAmountInSettlmtCrcy" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cASettlmtAmountInSettlmtCrcy;
    public final static SimpleProperty.NumericDecimal<GLItemPaytData> CA_SETTLMT_AMOUNT_IN_SETTLMT_CRCY =
        new SimpleProperty.NumericDecimal<GLItemPaytData>(GLItemPaytData.class, "CASettlmtAmountInSettlmtCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlementCurrency</b>
     * </p>
     * 
     * @return Payment Cards: Settlement Currency
     */
    @Nullable
    @ElementName( "SettlementCurrency" )
    private java.lang.String settlementCurrency;
    public final static SimpleProperty.String<GLItemPaytData> SETTLEMENT_CURRENCY =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "SettlementCurrency");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Created On
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<GLItemPaytData> CREATION_DATE =
        new SimpleProperty.Date<GLItemPaytData>(GLItemPaytData.class, "CreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @return Time of Data Entry
     */
    @Nullable
    @ElementName( "CreationTime" )
    private LocalTime creationTime;
    public final static SimpleProperty.Time<GLItemPaytData> CREATION_TIME =
        new SimpleProperty.Time<GLItemPaytData>(GLItemPaytData.class, "CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Name of Person Who Created Object
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<GLItemPaytData> CREATED_BY_USER =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "CreatedByUser");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardUUID</b>
     * </p>
     * 
     * @return GUID of a Payment Card
     */
    @Nullable
    @ElementName( "PaymentCardUUID" )
    private UUID paymentCardUUID;
    public final static SimpleProperty.Guid<GLItemPaytData> PAYMENT_CARD_UUID =
        new SimpleProperty.Guid<GLItemPaytData>(GLItemPaytData.class, "PaymentCardUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EncryptionType</b>
     * </p>
     * 
     * @return Type of Encryption
     */
    @Nullable
    @ElementName( "EncryptionType" )
    private java.lang.String encryptionType;
    public final static SimpleProperty.String<GLItemPaytData> ENCRYPTION_TYPE =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "EncryptionType");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAKeyForPaymentCardSupplement</b>
     * </p>
     * 
     * @return Key for Payment Card Supplement
     */
    @Nullable
    @ElementName( "CAKeyForPaymentCardSupplement" )
    private UUID cAKeyForPaymentCardSupplement;
    public final static SimpleProperty.Guid<GLItemPaytData> CA_KEY_FOR_PAYMENT_CARD_SUPPLEMENT =
        new SimpleProperty.Guid<GLItemPaytData>(GLItemPaytData.class, "CAKeyForPaymentCardSupplement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentServiceProvider</b>
     * </p>
     * 
     * @return Payment Service Providers
     */
    @Nullable
    @ElementName( "PaymentServiceProvider" )
    private java.lang.String paymentServiceProvider;
    public final static SimpleProperty.String<GLItemPaytData> PAYMENT_SERVICE_PROVIDER =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "PaymentServiceProvider");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PaymentRefByPaytSrvcProvider</b>
     * </p>
     * 
     * @return Payment Reference of Payment Service Provider
     */
    @Nullable
    @ElementName( "PaymentRefByPaytSrvcProvider" )
    private java.lang.String paymentRefByPaytSrvcProvider;
    public final static SimpleProperty.String<GLItemPaytData> PAYMENT_REF_BY_PAYT_SRVC_PROVIDER =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "PaymentRefByPaytSrvcProvider");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OriglPaytRefByPaytSrvcProvider</b>
     * </p>
     * 
     * @return Payment Reference of Payment Service Provider
     */
    @Nullable
    @ElementName( "OriglPaytRefByPaytSrvcProvider" )
    private java.lang.String origlPaytRefByPaytSrvcProvider;
    public final static SimpleProperty.String<GLItemPaytData> ORIGL_PAYT_REF_BY_PAYT_SRVC_PROVIDER =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "OriglPaytRefByPaytSrvcProvider");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OriginalSourceOfCredit</b>
     * </p>
     * 
     * @return Origin of Credit Memo Posting
     */
    @Nullable
    @ElementName( "OriginalSourceOfCredit" )
    private java.lang.String originalSourceOfCredit;
    public final static SimpleProperty.String<GLItemPaytData> ORIGINAL_SOURCE_OF_CREDIT =
        new SimpleProperty.String<GLItemPaytData>(GLItemPaytData.class, "OriginalSourceOfCredit");
    /**
     * Navigation property <b>_DocHeader</b> for <b>GLItemPaytData</b> to single <b>DocumentHeader</b>.
     * 
     */
    @ElementName( "_DocHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DocumentHeader to_DocHeader;
    /**
     * Use with available request builders to apply the <b>_DocHeader</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<GLItemPaytData, DocumentHeader> TO__DOC_HEADER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<GLItemPaytData, DocumentHeader>(
            GLItemPaytData.class,
            "_DocHeader",
            DocumentHeader.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<GLItemPaytData> getType()
    {
        return GLItemPaytData.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @param cADocumentNumber
     *            Number of a FI-CA Document
     */
    public void setCADocumentNumber( @Nullable final java.lang.String cADocumentNumber )
    {
        rememberChangedField("CADocumentNumber", this.cADocumentNumber);
        this.cADocumentNumber = cADocumentNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAGLItemNumber</b>
     * </p>
     * 
     * @param cAGLItemNumber
     *            Item Number in FI-CA Document
     */
    public void setCAGLItemNumber( @Nullable final java.lang.String cAGLItemNumber )
    {
        rememberChangedField("CAGLItemNumber", this.cAGLItemNumber);
        this.cAGLItemNumber = cAGLItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardType</b>
     * </p>
     * 
     * @param paymentCardType
     *            Payment Card Type
     */
    public void setPaymentCardType( @Nullable final java.lang.String paymentCardType )
    {
        rememberChangedField("PaymentCardType", this.paymentCardType);
        this.paymentCardType = paymentCardType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PaytCardByDigitalPaymentSrvc</b>
     * </p>
     * 
     * @param paytCardByDigitalPaymentSrvc
     *            Payment cards: Card number
     */
    public void setPaytCardByDigitalPaymentSrvc( @Nullable final java.lang.String paytCardByDigitalPaymentSrvc )
    {
        rememberChangedField("PaytCardByDigitalPaymentSrvc", this.paytCardByDigitalPaymentSrvc);
        this.paytCardByDigitalPaymentSrvc = paytCardByDigitalPaymentSrvc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardSequenceNumber</b>
     * </p>
     * 
     * @param paymentCardSequenceNumber
     *            Payment cards: Payment card suffix
     */
    public void setPaymentCardSequenceNumber( @Nullable final java.lang.String paymentCardSequenceNumber )
    {
        rememberChangedField("PaymentCardSequenceNumber", this.paymentCardSequenceNumber);
        this.paymentCardSequenceNumber = paymentCardSequenceNumber;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardValidityStartDate</b>
     * </p>
     * 
     * @param paymentCardValidityStartDate
     *            Payment cards: Valid from
     */
    public void setPaymentCardValidityStartDate( @Nullable final LocalDate paymentCardValidityStartDate )
    {
        rememberChangedField("PaymentCardValidityStartDate", this.paymentCardValidityStartDate);
        this.paymentCardValidityStartDate = paymentCardValidityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardValidityEndDate</b>
     * </p>
     * 
     * @param paymentCardValidityEndDate
     *            Payment Cards: Valid To
     */
    public void setPaymentCardValidityEndDate( @Nullable final LocalDate paymentCardValidityEndDate )
    {
        rememberChangedField("PaymentCardValidityEndDate", this.paymentCardValidityEndDate);
        this.paymentCardValidityEndDate = paymentCardValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardHolderName</b>
     * </p>
     * 
     * @param paymentCardHolderName
     *            Payment Cards: Name of Cardholder
     */
    public void setPaymentCardHolderName( @Nullable final java.lang.String paymentCardHolderName )
    {
        rememberChangedField("PaymentCardHolderName", this.paymentCardHolderName);
        this.paymentCardHolderName = paymentCardHolderName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardMaskedNumber</b>
     * </p>
     * 
     * @param paymentCardMaskedNumber
     *            Masked Payment Card Number ( Digital Payment )
     */
    public void setPaymentCardMaskedNumber( @Nullable final java.lang.String paymentCardMaskedNumber )
    {
        rememberChangedField("PaymentCardMaskedNumber", this.paymentCardMaskedNumber);
        this.paymentCardMaskedNumber = paymentCardMaskedNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthznByDigitalPaytSrvc</b>
     * </p>
     * 
     * @param cAAuthznByDigitalPaytSrvc
     *            Payment cards: Authorization number
     */
    public void setCAAuthznByDigitalPaytSrvc( @Nullable final java.lang.String cAAuthznByDigitalPaytSrvc )
    {
        rememberChangedField("CAAuthznByDigitalPaytSrvc", this.cAAuthznByDigitalPaytSrvc);
        this.cAAuthznByDigitalPaytSrvc = cAAuthznByDigitalPaytSrvc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationByAcquirer</b>
     * </p>
     * 
     * @param cAAuthorizationByAcquirer
     *            Payment Cards: Authorization Reference Number
     */
    public void setCAAuthorizationByAcquirer( @Nullable final java.lang.String cAAuthorizationByAcquirer )
    {
        rememberChangedField("CAAuthorizationByAcquirer", this.cAAuthorizationByAcquirer);
        this.cAAuthorizationByAcquirer = cAAuthorizationByAcquirer;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationDate</b>
     * </p>
     * 
     * @param authorizationDate
     *            Payment cards: Authorization date
     */
    public void setAuthorizationDate( @Nullable final LocalDate authorizationDate )
    {
        rememberChangedField("AuthorizationDate", this.authorizationDate);
        this.authorizationDate = authorizationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationTime</b>
     * </p>
     * 
     * @param authorizationTime
     *            Payment cards: Authorization time
     */
    public void setAuthorizationTime( @Nullable final LocalTime authorizationTime )
    {
        rememberChangedField("AuthorizationTime", this.authorizationTime);
        this.authorizationTime = authorizationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationType</b>
     * </p>
     * 
     * @param cAAuthorizationType
     *            Payment cards: Authorization type
     */
    public void setCAAuthorizationType( @Nullable final java.lang.String cAAuthorizationType )
    {
        rememberChangedField("CAAuthorizationType", this.cAAuthorizationType);
        this.cAAuthorizationType = cAAuthorizationType;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizedAmountInAuthznCrcy</b>
     * </p>
     * 
     * @param authorizedAmountInAuthznCrcy
     *            The authorizedAmountInAuthznCrcy to set.
     */
    public void setAuthorizedAmountInAuthznCrcy( @Nullable final BigDecimal authorizedAmountInAuthznCrcy )
    {
        rememberChangedField("AuthorizedAmountInAuthznCrcy", this.authorizedAmountInAuthznCrcy);
        this.authorizedAmountInAuthznCrcy = authorizedAmountInAuthznCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationCurrency</b>
     * </p>
     * 
     * @param authorizationCurrency
     *            Currency Key
     */
    public void setAuthorizationCurrency( @Nullable final java.lang.String authorizationCurrency )
    {
        rememberChangedField("AuthorizationCurrency", this.authorizationCurrency);
        this.authorizationCurrency = authorizationCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>MerchantByClearingHouse</b>
     * </p>
     * 
     * @param merchantByClearingHouse
     *            Payment cards: Merchant ID at the clearing house
     */
    public void setMerchantByClearingHouse( @Nullable final java.lang.String merchantByClearingHouse )
    {
        rememberChangedField("MerchantByClearingHouse", this.merchantByClearingHouse);
        this.merchantByClearingHouse = merchantByClearingHouse;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationExpirationDate</b>
     * </p>
     * 
     * @param authorizationExpirationDate
     *            Payment Cards: Authorization Expiry Date
     */
    public void setAuthorizationExpirationDate( @Nullable final LocalDate authorizationExpirationDate )
    {
        rememberChangedField("AuthorizationExpirationDate", this.authorizationExpirationDate);
        this.authorizationExpirationDate = authorizationExpirationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationExpirationTime</b>
     * </p>
     * 
     * @param authorizationExpirationTime
     *            Payment Cards: Authorization Expiration Time
     */
    public void setAuthorizationExpirationTime( @Nullable final LocalTime authorizationExpirationTime )
    {
        rememberChangedField("AuthorizationExpirationTime", this.authorizationExpirationTime);
        this.authorizationExpirationTime = authorizationExpirationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentIDAuthznWithBilling</b>
     * </p>
     * 
     * @param cAPaymentIDAuthznWithBilling
     *            Payment Cards: Payment ID (Authorization with Billing)
     */
    public void setCAPaymentIDAuthznWithBilling( @Nullable final java.lang.String cAPaymentIDAuthznWithBilling )
    {
        rememberChangedField("CAPaymentIDAuthznWithBilling", this.cAPaymentIDAuthznWithBilling);
        this.cAPaymentIDAuthznWithBilling = cAPaymentIDAuthznWithBilling;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDate</b>
     * </p>
     * 
     * @param cAPostingDate
     *            Posting Date in the Document
     */
    public void setCAPostingDate( @Nullable final LocalDate cAPostingDate )
    {
        rememberChangedField("CAPostingDate", this.cAPostingDate);
        this.cAPostingDate = cAPostingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @param cAAmountInTransactionCurrency
     *            The cAAmountInTransactionCurrency to set.
     */
    public void setCAAmountInTransactionCurrency( @Nullable final BigDecimal cAAmountInTransactionCurrency )
    {
        rememberChangedField("CAAmountInTransactionCurrency", this.cAAmountInTransactionCurrency);
        this.cAAmountInTransactionCurrency = cAAmountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @param transactionCurrency
     *            Currency Key
     */
    public void setTransactionCurrency( @Nullable final java.lang.String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     * 
     * @param valueDate
     *            Value Date
     */
    public void setValueDate( @Nullable final LocalDate valueDate )
    {
        rememberChangedField("ValueDate", this.valueDate);
        this.valueDate = valueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentBillingStatus</b>
     * </p>
     * 
     * @param cAPaymentBillingStatus
     *            Billing Status
     */
    public void setCAPaymentBillingStatus( @Nullable final java.lang.String cAPaymentBillingStatus )
    {
        rememberChangedField("CAPaymentBillingStatus", this.cAPaymentBillingStatus);
        this.cAPaymentBillingStatus = cAPaymentBillingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>CASettlementMassRunID</b>
     * </p>
     * 
     * @param cASettlementMassRunID
     *            Payment Cards/PSP: Run ID of Settlement Run
     */
    public void setCASettlementMassRunID( @Nullable final java.lang.String cASettlementMassRunID )
    {
        rememberChangedField("CASettlementMassRunID", this.cASettlementMassRunID);
        this.cASettlementMassRunID = cASettlementMassRunID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASettlementDocument</b>
     * </p>
     * 
     * @param cASettlementDocument
     *            Document Number of Billing Document
     */
    public void setCASettlementDocument( @Nullable final java.lang.String cASettlementDocument )
    {
        rememberChangedField("CASettlementDocument", this.cASettlementDocument);
        this.cASettlementDocument = cASettlementDocument;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPaytCardSupplementIsResent</b>
     * </p>
     * 
     * @param cAPaytCardSupplementIsResent
     *            Payment Card Supplement Was Resent
     */
    public void setCAPaytCardSupplementIsResent( @Nullable final java.lang.Boolean cAPaytCardSupplementIsResent )
    {
        rememberChangedField("CAPaytCardSupplementIsResent", this.cAPaytCardSupplementIsResent);
        this.cAPaytCardSupplementIsResent = cAPaytCardSupplementIsResent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAReturnLot</b>
     * </p>
     * 
     * @param cAReturnLot
     *            Returns Lot for a Non-Billable Payment
     */
    public void setCAReturnLot( @Nullable final java.lang.String cAReturnLot )
    {
        rememberChangedField("CAReturnLot", this.cAReturnLot);
        this.cAReturnLot = cAReturnLot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CAReturnReason</b>
     * </p>
     * 
     * @param cAReturnReason
     *            Returns Reason for Non-Billable Payments
     */
    public void setCAReturnReason( @Nullable final java.lang.String cAReturnReason )
    {
        rememberChangedField("CAReturnReason", this.cAReturnReason);
        this.cAReturnReason = cAReturnReason;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CASettlementChargeAmountInTC</b>
     * </p>
     * 
     * @param cASettlementChargeAmountInTC
     *            The cASettlementChargeAmountInTC to set.
     */
    public void setCASettlementChargeAmountInTC( @Nullable final BigDecimal cASettlementChargeAmountInTC )
    {
        rememberChangedField("CASettlementChargeAmountInTC", this.cASettlementChargeAmountInTC);
        this.cASettlementChargeAmountInTC = cASettlementChargeAmountInTC;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentCardSettlementID</b>
     * </p>
     * 
     * @param cAPaymentCardSettlementID
     *            Payment Card Billing ID
     */
    public void setCAPaymentCardSettlementID( @Nullable final java.lang.String cAPaymentCardSettlementID )
    {
        rememberChangedField("CAPaymentCardSettlementID", this.cAPaymentCardSettlementID);
        this.cAPaymentCardSettlementID = cAPaymentCardSettlementID;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CASettlmtAmountInSettlmtCrcy</b>
     * </p>
     * 
     * @param cASettlmtAmountInSettlmtCrcy
     *            The cASettlmtAmountInSettlmtCrcy to set.
     */
    public void setCASettlmtAmountInSettlmtCrcy( @Nullable final BigDecimal cASettlmtAmountInSettlmtCrcy )
    {
        rememberChangedField("CASettlmtAmountInSettlmtCrcy", this.cASettlmtAmountInSettlmtCrcy);
        this.cASettlmtAmountInSettlmtCrcy = cASettlmtAmountInSettlmtCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlementCurrency</b>
     * </p>
     * 
     * @param settlementCurrency
     *            Payment Cards: Settlement Currency
     */
    public void setSettlementCurrency( @Nullable final java.lang.String settlementCurrency )
    {
        rememberChangedField("SettlementCurrency", this.settlementCurrency);
        this.settlementCurrency = settlementCurrency;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @param creationTime
     *            Time of Data Entry
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Name of Person Who Created Object
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardUUID</b>
     * </p>
     * 
     * @param paymentCardUUID
     *            GUID of a Payment Card
     */
    public void setPaymentCardUUID( @Nullable final UUID paymentCardUUID )
    {
        rememberChangedField("PaymentCardUUID", this.paymentCardUUID);
        this.paymentCardUUID = paymentCardUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EncryptionType</b>
     * </p>
     * 
     * @param encryptionType
     *            Type of Encryption
     */
    public void setEncryptionType( @Nullable final java.lang.String encryptionType )
    {
        rememberChangedField("EncryptionType", this.encryptionType);
        this.encryptionType = encryptionType;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAKeyForPaymentCardSupplement</b>
     * </p>
     * 
     * @param cAKeyForPaymentCardSupplement
     *            Key for Payment Card Supplement
     */
    public void setCAKeyForPaymentCardSupplement( @Nullable final UUID cAKeyForPaymentCardSupplement )
    {
        rememberChangedField("CAKeyForPaymentCardSupplement", this.cAKeyForPaymentCardSupplement);
        this.cAKeyForPaymentCardSupplement = cAKeyForPaymentCardSupplement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentServiceProvider</b>
     * </p>
     * 
     * @param paymentServiceProvider
     *            Payment Service Providers
     */
    public void setPaymentServiceProvider( @Nullable final java.lang.String paymentServiceProvider )
    {
        rememberChangedField("PaymentServiceProvider", this.paymentServiceProvider);
        this.paymentServiceProvider = paymentServiceProvider;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PaymentRefByPaytSrvcProvider</b>
     * </p>
     * 
     * @param paymentRefByPaytSrvcProvider
     *            Payment Reference of Payment Service Provider
     */
    public void setPaymentRefByPaytSrvcProvider( @Nullable final java.lang.String paymentRefByPaytSrvcProvider )
    {
        rememberChangedField("PaymentRefByPaytSrvcProvider", this.paymentRefByPaytSrvcProvider);
        this.paymentRefByPaytSrvcProvider = paymentRefByPaytSrvcProvider;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>OriglPaytRefByPaytSrvcProvider</b>
     * </p>
     * 
     * @param origlPaytRefByPaytSrvcProvider
     *            Payment Reference of Payment Service Provider
     */
    public void setOriglPaytRefByPaytSrvcProvider( @Nullable final java.lang.String origlPaytRefByPaytSrvcProvider )
    {
        rememberChangedField("OriglPaytRefByPaytSrvcProvider", this.origlPaytRefByPaytSrvcProvider);
        this.origlPaytRefByPaytSrvcProvider = origlPaytRefByPaytSrvcProvider;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OriginalSourceOfCredit</b>
     * </p>
     * 
     * @param originalSourceOfCredit
     *            Origin of Credit Memo Posting
     */
    public void setOriginalSourceOfCredit( @Nullable final java.lang.String originalSourceOfCredit )
    {
        rememberChangedField("OriginalSourceOfCredit", this.originalSourceOfCredit);
        this.originalSourceOfCredit = originalSourceOfCredit;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "GLItemPaytData";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CADocumentNumber", getCADocumentNumber());
        entityKey.addKeyProperty("CAGLItemNumber", getCAGLItemNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentNumber", getCADocumentNumber());
        values.put("CAGLItemNumber", getCAGLItemNumber());
        values.put("PaymentCardType", getPaymentCardType());
        values.put("PaytCardByDigitalPaymentSrvc", getPaytCardByDigitalPaymentSrvc());
        values.put("PaymentCardSequenceNumber", getPaymentCardSequenceNumber());
        values.put("PaymentCardValidityStartDate", getPaymentCardValidityStartDate());
        values.put("PaymentCardValidityEndDate", getPaymentCardValidityEndDate());
        values.put("PaymentCardHolderName", getPaymentCardHolderName());
        values.put("PaymentCardMaskedNumber", getPaymentCardMaskedNumber());
        values.put("CAAuthznByDigitalPaytSrvc", getCAAuthznByDigitalPaytSrvc());
        values.put("CAAuthorizationByAcquirer", getCAAuthorizationByAcquirer());
        values.put("AuthorizationDate", getAuthorizationDate());
        values.put("AuthorizationTime", getAuthorizationTime());
        values.put("CAAuthorizationType", getCAAuthorizationType());
        values.put("AuthorizedAmountInAuthznCrcy", getAuthorizedAmountInAuthznCrcy());
        values.put("AuthorizationCurrency", getAuthorizationCurrency());
        values.put("MerchantByClearingHouse", getMerchantByClearingHouse());
        values.put("AuthorizationExpirationDate", getAuthorizationExpirationDate());
        values.put("AuthorizationExpirationTime", getAuthorizationExpirationTime());
        values.put("CAPaymentIDAuthznWithBilling", getCAPaymentIDAuthznWithBilling());
        values.put("CAPostingDate", getCAPostingDate());
        values.put("CAAmountInTransactionCurrency", getCAAmountInTransactionCurrency());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("CompanyCode", getCompanyCode());
        values.put("ValueDate", getValueDate());
        values.put("CAPaymentBillingStatus", getCAPaymentBillingStatus());
        values.put("CASettlementMassRunID", getCASettlementMassRunID());
        values.put("CASettlementDocument", getCASettlementDocument());
        values.put("CAPaytCardSupplementIsResent", getCAPaytCardSupplementIsResent());
        values.put("CAReturnLot", getCAReturnLot());
        values.put("CAReturnReason", getCAReturnReason());
        values.put("CASettlementChargeAmountInTC", getCASettlementChargeAmountInTC());
        values.put("CAPaymentCardSettlementID", getCAPaymentCardSettlementID());
        values.put("CASettlmtAmountInSettlmtCrcy", getCASettlmtAmountInSettlmtCrcy());
        values.put("SettlementCurrency", getSettlementCurrency());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("PaymentCardUUID", getPaymentCardUUID());
        values.put("EncryptionType", getEncryptionType());
        values.put("CAKeyForPaymentCardSupplement", getCAKeyForPaymentCardSupplement());
        values.put("PaymentServiceProvider", getPaymentServiceProvider());
        values.put("PaymentRefByPaytSrvcProvider", getPaymentRefByPaytSrvcProvider());
        values.put("OriglPaytRefByPaytSrvcProvider", getOriglPaytRefByPaytSrvcProvider());
        values.put("OriginalSourceOfCredit", getOriginalSourceOfCredit());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentNumber") ) {
                final Object value = values.remove("CADocumentNumber");
                if( (value == null) || (!value.equals(getCADocumentNumber())) ) {
                    setCADocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAGLItemNumber") ) {
                final Object value = values.remove("CAGLItemNumber");
                if( (value == null) || (!value.equals(getCAGLItemNumber())) ) {
                    setCAGLItemNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCardType") ) {
                final Object value = values.remove("PaymentCardType");
                if( (value == null) || (!value.equals(getPaymentCardType())) ) {
                    setPaymentCardType(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaytCardByDigitalPaymentSrvc") ) {
                final Object value = values.remove("PaytCardByDigitalPaymentSrvc");
                if( (value == null) || (!value.equals(getPaytCardByDigitalPaymentSrvc())) ) {
                    setPaytCardByDigitalPaymentSrvc(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCardSequenceNumber") ) {
                final Object value = values.remove("PaymentCardSequenceNumber");
                if( (value == null) || (!value.equals(getPaymentCardSequenceNumber())) ) {
                    setPaymentCardSequenceNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCardValidityStartDate") ) {
                final Object value = values.remove("PaymentCardValidityStartDate");
                if( (value == null) || (!value.equals(getPaymentCardValidityStartDate())) ) {
                    setPaymentCardValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("PaymentCardValidityEndDate") ) {
                final Object value = values.remove("PaymentCardValidityEndDate");
                if( (value == null) || (!value.equals(getPaymentCardValidityEndDate())) ) {
                    setPaymentCardValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("PaymentCardHolderName") ) {
                final Object value = values.remove("PaymentCardHolderName");
                if( (value == null) || (!value.equals(getPaymentCardHolderName())) ) {
                    setPaymentCardHolderName(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCardMaskedNumber") ) {
                final Object value = values.remove("PaymentCardMaskedNumber");
                if( (value == null) || (!value.equals(getPaymentCardMaskedNumber())) ) {
                    setPaymentCardMaskedNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAuthznByDigitalPaytSrvc") ) {
                final Object value = values.remove("CAAuthznByDigitalPaytSrvc");
                if( (value == null) || (!value.equals(getCAAuthznByDigitalPaytSrvc())) ) {
                    setCAAuthznByDigitalPaytSrvc(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAuthorizationByAcquirer") ) {
                final Object value = values.remove("CAAuthorizationByAcquirer");
                if( (value == null) || (!value.equals(getCAAuthorizationByAcquirer())) ) {
                    setCAAuthorizationByAcquirer(((java.lang.String) value));
                }
            }
            if( values.containsKey("AuthorizationDate") ) {
                final Object value = values.remove("AuthorizationDate");
                if( (value == null) || (!value.equals(getAuthorizationDate())) ) {
                    setAuthorizationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("AuthorizationTime") ) {
                final Object value = values.remove("AuthorizationTime");
                if( (value == null) || (!value.equals(getAuthorizationTime())) ) {
                    setAuthorizationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CAAuthorizationType") ) {
                final Object value = values.remove("CAAuthorizationType");
                if( (value == null) || (!value.equals(getCAAuthorizationType())) ) {
                    setCAAuthorizationType(((java.lang.String) value));
                }
            }
            if( values.containsKey("AuthorizedAmountInAuthznCrcy") ) {
                final Object value = values.remove("AuthorizedAmountInAuthznCrcy");
                if( (value == null) || (!value.equals(getAuthorizedAmountInAuthznCrcy())) ) {
                    setAuthorizedAmountInAuthznCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("AuthorizationCurrency") ) {
                final Object value = values.remove("AuthorizationCurrency");
                if( (value == null) || (!value.equals(getAuthorizationCurrency())) ) {
                    setAuthorizationCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("MerchantByClearingHouse") ) {
                final Object value = values.remove("MerchantByClearingHouse");
                if( (value == null) || (!value.equals(getMerchantByClearingHouse())) ) {
                    setMerchantByClearingHouse(((java.lang.String) value));
                }
            }
            if( values.containsKey("AuthorizationExpirationDate") ) {
                final Object value = values.remove("AuthorizationExpirationDate");
                if( (value == null) || (!value.equals(getAuthorizationExpirationDate())) ) {
                    setAuthorizationExpirationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("AuthorizationExpirationTime") ) {
                final Object value = values.remove("AuthorizationExpirationTime");
                if( (value == null) || (!value.equals(getAuthorizationExpirationTime())) ) {
                    setAuthorizationExpirationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CAPaymentIDAuthznWithBilling") ) {
                final Object value = values.remove("CAPaymentIDAuthznWithBilling");
                if( (value == null) || (!value.equals(getCAPaymentIDAuthznWithBilling())) ) {
                    setCAPaymentIDAuthznWithBilling(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPostingDate") ) {
                final Object value = values.remove("CAPostingDate");
                if( (value == null) || (!value.equals(getCAPostingDate())) ) {
                    setCAPostingDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAAmountInTransactionCurrency") ) {
                final Object value = values.remove("CAAmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getCAAmountInTransactionCurrency())) ) {
                    setCAAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValueDate") ) {
                final Object value = values.remove("ValueDate");
                if( (value == null) || (!value.equals(getValueDate())) ) {
                    setValueDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CAPaymentBillingStatus") ) {
                final Object value = values.remove("CAPaymentBillingStatus");
                if( (value == null) || (!value.equals(getCAPaymentBillingStatus())) ) {
                    setCAPaymentBillingStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASettlementMassRunID") ) {
                final Object value = values.remove("CASettlementMassRunID");
                if( (value == null) || (!value.equals(getCASettlementMassRunID())) ) {
                    setCASettlementMassRunID(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASettlementDocument") ) {
                final Object value = values.remove("CASettlementDocument");
                if( (value == null) || (!value.equals(getCASettlementDocument())) ) {
                    setCASettlementDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAPaytCardSupplementIsResent") ) {
                final Object value = values.remove("CAPaytCardSupplementIsResent");
                if( (value == null) || (!value.equals(getCAPaytCardSupplementIsResent())) ) {
                    setCAPaytCardSupplementIsResent(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CAReturnLot") ) {
                final Object value = values.remove("CAReturnLot");
                if( (value == null) || (!value.equals(getCAReturnLot())) ) {
                    setCAReturnLot(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAReturnReason") ) {
                final Object value = values.remove("CAReturnReason");
                if( (value == null) || (!value.equals(getCAReturnReason())) ) {
                    setCAReturnReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASettlementChargeAmountInTC") ) {
                final Object value = values.remove("CASettlementChargeAmountInTC");
                if( (value == null) || (!value.equals(getCASettlementChargeAmountInTC())) ) {
                    setCASettlementChargeAmountInTC(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAPaymentCardSettlementID") ) {
                final Object value = values.remove("CAPaymentCardSettlementID");
                if( (value == null) || (!value.equals(getCAPaymentCardSettlementID())) ) {
                    setCAPaymentCardSettlementID(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASettlmtAmountInSettlmtCrcy") ) {
                final Object value = values.remove("CASettlmtAmountInSettlmtCrcy");
                if( (value == null) || (!value.equals(getCASettlmtAmountInSettlmtCrcy())) ) {
                    setCASettlmtAmountInSettlmtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("SettlementCurrency") ) {
                final Object value = values.remove("SettlementCurrency");
                if( (value == null) || (!value.equals(getSettlementCurrency())) ) {
                    setSettlementCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCardUUID") ) {
                final Object value = values.remove("PaymentCardUUID");
                if( (value == null) || (!value.equals(getPaymentCardUUID())) ) {
                    setPaymentCardUUID(((UUID) value));
                }
            }
            if( values.containsKey("EncryptionType") ) {
                final Object value = values.remove("EncryptionType");
                if( (value == null) || (!value.equals(getEncryptionType())) ) {
                    setEncryptionType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAKeyForPaymentCardSupplement") ) {
                final Object value = values.remove("CAKeyForPaymentCardSupplement");
                if( (value == null) || (!value.equals(getCAKeyForPaymentCardSupplement())) ) {
                    setCAKeyForPaymentCardSupplement(((UUID) value));
                }
            }
            if( values.containsKey("PaymentServiceProvider") ) {
                final Object value = values.remove("PaymentServiceProvider");
                if( (value == null) || (!value.equals(getPaymentServiceProvider())) ) {
                    setPaymentServiceProvider(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentRefByPaytSrvcProvider") ) {
                final Object value = values.remove("PaymentRefByPaytSrvcProvider");
                if( (value == null) || (!value.equals(getPaymentRefByPaytSrvcProvider())) ) {
                    setPaymentRefByPaytSrvcProvider(((java.lang.String) value));
                }
            }
            if( values.containsKey("OriglPaytRefByPaytSrvcProvider") ) {
                final Object value = values.remove("OriglPaytRefByPaytSrvcProvider");
                if( (value == null) || (!value.equals(getOriglPaytRefByPaytSrvcProvider())) ) {
                    setOriglPaytRefByPaytSrvcProvider(((java.lang.String) value));
                }
            }
            if( values.containsKey("OriginalSourceOfCredit") ) {
                final Object value = values.remove("OriginalSourceOfCredit");
                if( (value == null) || (!value.equals(getOriginalSourceOfCredit())) ) {
                    setOriginalSourceOfCredit(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_DocHeader") ) {
                final Object value = (values).remove("_DocHeader");
                if( value instanceof Map ) {
                    if( to_DocHeader == null ) {
                        to_DocHeader = new DocumentHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_DocHeader.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ContractAccountingDocumentManageService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_DocHeader != null ) {
            (values).put("_DocHeader", to_DocHeader);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>DocumentHeader</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_DocHeader</b>.
     * <p>
     * If the navigation property for an entity <b>GLItemPaytData</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_DocHeader</b> is already loaded, the result will contain
     *         the <b>DocumentHeader</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<DocumentHeader> getDocHeaderIfPresent()
    {
        return Option.of(to_DocHeader);
    }

    /**
     * Overwrites the associated <b>DocumentHeader</b> entity for the loaded navigation property <b>_DocHeader</b>.
     * 
     * @param value
     *            New <b>DocumentHeader</b> entity.
     */
    public void setDocHeader( final DocumentHeader value )
    {
        to_DocHeader = value;
    }

    /**
     * Helper class to allow for fluent creation of GLItemPaytData instances.
     * 
     */
    public final static class GLItemPaytDataBuilder
    {

        private DocumentHeader to_DocHeader;

        private GLItemPaytData.GLItemPaytDataBuilder to_DocHeader( final DocumentHeader value )
        {
            to_DocHeader = value;
            return this;
        }

        /**
         * Navigation property <b>_DocHeader</b> for <b>GLItemPaytData</b> to single <b>DocumentHeader</b>.
         * 
         * @param value
         *            The DocumentHeader to build this GLItemPaytData with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public GLItemPaytData.GLItemPaytDataBuilder docHeader( final DocumentHeader value )
        {
            return to_DocHeader(value);
        }

    }

}
