/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.documentcomplianceelectronicdocumentfile;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DocumentComplianceElectronicDocumentFileService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * eDocument File
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ElectronicDocFile_Type</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ElectronicDocFile extends VdmEntity<ElectronicDocFile> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_electronicdocfile.v0001.ElectronicDocFile_Type";
    /**
     * Selector for all available fields of ElectronicDocFile.
     * 
     */
    public final static SimpleProperty<ElectronicDocFile> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileUUID</b>
     * </p>
     * 
     * @return File GUID
     */
    @Nullable
    @ElementName( "ElectronicDocFileUUID" )
    private UUID electronicDocFileUUID;
    public final static SimpleProperty.Guid<ElectronicDocFile> ELECTRONIC_DOC_FILE_UUID =
        new SimpleProperty.Guid<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocFileUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileType</b>
     * </p>
     * 
     * @return eDocument: File Type
     */
    @Nullable
    @ElementName( "ElectronicDocFileType" )
    private java.lang.String electronicDocFileType;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_FILE_TYPE =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocFileType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileName</b>
     * </p>
     * 
     * @return File Name
     */
    @Nullable
    @ElementName( "ElectronicDocFileName" )
    private java.lang.String electronicDocFileName;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_FILE_NAME =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocFileName");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileCreationTime</b>
     * </p>
     * 
     * @return File Creation Time
     */
    @Nullable
    @ElementName( "ElectronicDocFileCreationTime" )
    private LocalTime electronicDocFileCreationTime;
    public final static SimpleProperty.Time<ElectronicDocFile> ELECTRONIC_DOC_FILE_CREATION_TIME =
        new SimpleProperty.Time<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocFileCreationTime");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileCreationDate</b>
     * </p>
     * 
     * @return File Creation Date
     */
    @Nullable
    @ElementName( "ElectronicDocFileCreationDate" )
    private LocalDate electronicDocFileCreationDate;
    public final static SimpleProperty.Date<ElectronicDocFile> ELECTRONIC_DOC_FILE_CREATION_DATE =
        new SimpleProperty.Date<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocFileCreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileContent</b>
     * </p>
     * 
     * @return File
     */
    @Nullable
    @ElementName( "ElectronicDocFileContent" )
    private byte[] electronicDocFileContent;
    public final static SimpleProperty.Binary<ElectronicDocFile> ELECTRONIC_DOC_FILE_CONTENT =
        new SimpleProperty.Binary<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocFileContent");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocUUID</b>
     * </p>
     * 
     * @return eDocument: GUID
     */
    @Nullable
    @ElementName( "ElectronicDocUUID" )
    private UUID electronicDocUUID;
    public final static SimpleProperty.Guid<ElectronicDocFile> ELECTRONIC_DOC_UUID =
        new SimpleProperty.Guid<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocCompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "ElectronicDocCompanyCode" )
    private java.lang.String electronicDocCompanyCode;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_COMPANY_CODE =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocCountry</b>
     * </p>
     * 
     * @return Country of Company
     */
    @Nullable
    @ElementName( "ElectronicDocCountry" )
    private java.lang.String electronicDocCountry;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_COUNTRY =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocCountry");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocCountry_Text</b>
     * </p>
     * 
     * @return Country Name (Max. 50 Characters)
     */
    @Nullable
    @ElementName( "ElectronicDocCountry_Text" )
    private java.lang.String electronicDocCountry_Text;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_COUNTRY_TEXT =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocCountry_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocSourceType</b>
     * </p>
     * 
     * @return eDocument Source Type
     */
    @Nullable
    @ElementName( "ElectronicDocSourceType" )
    private java.lang.String electronicDocSourceType;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_SOURCE_TYPE =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocSourceType");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocSourceType_Text</b>
     * </p>
     * 
     * @return eDocument Source Description
     */
    @Nullable
    @ElementName( "ElectronicDocSourceType_Text" )
    private java.lang.String electronicDocSourceType_Text;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_SOURCE_TYPE_TEXT =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocSourceType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocSourceKey</b>
     * </p>
     * 
     * @return eDocument Source Key
     */
    @Nullable
    @ElementName( "ElectronicDocSourceKey" )
    private java.lang.String electronicDocSourceKey;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_SOURCE_KEY =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocSourceKey");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocType</b>
     * </p>
     * 
     * @return eDocument Type
     */
    @Nullable
    @ElementName( "ElectronicDocType" )
    private java.lang.String electronicDocType;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_TYPE =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocType_Text</b>
     * </p>
     * 
     * @return eDocument Type Description
     */
    @Nullable
    @ElementName( "ElectronicDocType_Text" )
    private java.lang.String electronicDocType_Text;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_TYPE_TEXT =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocProcess</b>
     * </p>
     * 
     * @return eDocument Process
     */
    @Nullable
    @ElementName( "ElectronicDocProcess" )
    private java.lang.String electronicDocProcess;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_PROCESS =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocProcess");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocProcess_Text</b>
     * </p>
     * 
     * @return eDocument Process Description
     */
    @Nullable
    @ElementName( "ElectronicDocProcess_Text" )
    private java.lang.String electronicDocProcess_Text;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_PROCESS_TEXT =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocProcess_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocProcessStatus</b>
     * </p>
     * 
     * @return eDocument Process Status
     */
    @Nullable
    @ElementName( "ElectronicDocProcessStatus" )
    private java.lang.String electronicDocProcessStatus;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_PROCESS_STATUS =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocProcessStatus_Text</b>
     * </p>
     * 
     * @return eDocument Status Description
     */
    @Nullable
    @ElementName( "ElectronicDocProcessStatus_Text" )
    private java.lang.String electronicDocProcessStatus_Text;
    public final static SimpleProperty.String<ElectronicDocFile> ELECTRONIC_DOC_PROCESS_STATUS_TEXT =
        new SimpleProperty.String<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocProcessStatus_Text");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocLastChangeDate</b>
     * </p>
     * 
     * @return Changed on (Date)
     */
    @Nullable
    @ElementName( "ElectronicDocLastChangeDate" )
    private LocalDate electronicDocLastChangeDate;
    public final static SimpleProperty.Date<ElectronicDocFile> ELECTRONIC_DOC_LAST_CHANGE_DATE =
        new SimpleProperty.Date<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocLastChangeDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocLastChangeTime</b>
     * </p>
     * 
     * @return Changed On (Time)
     */
    @Nullable
    @ElementName( "ElectronicDocLastChangeTime" )
    private LocalTime electronicDocLastChangeTime;
    public final static SimpleProperty.Time<ElectronicDocFile> ELECTRONIC_DOC_LAST_CHANGE_TIME =
        new SimpleProperty.Time<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocLastChangeTime");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocCreationDate</b>
     * </p>
     * 
     * @return Creation Date
     */
    @Nullable
    @ElementName( "ElectronicDocCreationDate" )
    private LocalDate electronicDocCreationDate;
    public final static SimpleProperty.Date<ElectronicDocFile> ELECTRONIC_DOC_CREATION_DATE =
        new SimpleProperty.Date<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocCreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocCreationTime</b>
     * </p>
     * 
     * @return Created on (Time)
     */
    @Nullable
    @ElementName( "ElectronicDocCreationTime" )
    private LocalTime electronicDocCreationTime;
    public final static SimpleProperty.Time<ElectronicDocFile> ELECTRONIC_DOC_CREATION_TIME =
        new SimpleProperty.Time<ElectronicDocFile>(ElectronicDocFile.class, "ElectronicDocCreationTime");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ElectronicDocFile> getType()
    {
        return ElectronicDocFile.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileUUID</b>
     * </p>
     * 
     * @param electronicDocFileUUID
     *            File GUID
     */
    public void setElectronicDocFileUUID( @Nullable final UUID electronicDocFileUUID )
    {
        rememberChangedField("ElectronicDocFileUUID", this.electronicDocFileUUID);
        this.electronicDocFileUUID = electronicDocFileUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileType</b>
     * </p>
     * 
     * @param electronicDocFileType
     *            eDocument: File Type
     */
    public void setElectronicDocFileType( @Nullable final java.lang.String electronicDocFileType )
    {
        rememberChangedField("ElectronicDocFileType", this.electronicDocFileType);
        this.electronicDocFileType = electronicDocFileType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileName</b>
     * </p>
     * 
     * @param electronicDocFileName
     *            File Name
     */
    public void setElectronicDocFileName( @Nullable final java.lang.String electronicDocFileName )
    {
        rememberChangedField("ElectronicDocFileName", this.electronicDocFileName);
        this.electronicDocFileName = electronicDocFileName;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileCreationTime</b>
     * </p>
     * 
     * @param electronicDocFileCreationTime
     *            File Creation Time
     */
    public void setElectronicDocFileCreationTime( @Nullable final LocalTime electronicDocFileCreationTime )
    {
        rememberChangedField("ElectronicDocFileCreationTime", this.electronicDocFileCreationTime);
        this.electronicDocFileCreationTime = electronicDocFileCreationTime;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileCreationDate</b>
     * </p>
     * 
     * @param electronicDocFileCreationDate
     *            File Creation Date
     */
    public void setElectronicDocFileCreationDate( @Nullable final LocalDate electronicDocFileCreationDate )
    {
        rememberChangedField("ElectronicDocFileCreationDate", this.electronicDocFileCreationDate);
        this.electronicDocFileCreationDate = electronicDocFileCreationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocFileContent</b>
     * </p>
     * 
     * @param electronicDocFileContent
     *            File
     */
    public void setElectronicDocFileContent( @Nullable final byte[] electronicDocFileContent )
    {
        rememberChangedField("ElectronicDocFileContent", this.electronicDocFileContent);
        this.electronicDocFileContent = electronicDocFileContent;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocUUID</b>
     * </p>
     * 
     * @param electronicDocUUID
     *            eDocument: GUID
     */
    public void setElectronicDocUUID( @Nullable final UUID electronicDocUUID )
    {
        rememberChangedField("ElectronicDocUUID", this.electronicDocUUID);
        this.electronicDocUUID = electronicDocUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocCompanyCode</b>
     * </p>
     * 
     * @param electronicDocCompanyCode
     *            Company Code
     */
    public void setElectronicDocCompanyCode( @Nullable final java.lang.String electronicDocCompanyCode )
    {
        rememberChangedField("ElectronicDocCompanyCode", this.electronicDocCompanyCode);
        this.electronicDocCompanyCode = electronicDocCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocCountry</b>
     * </p>
     * 
     * @param electronicDocCountry
     *            Country of Company
     */
    public void setElectronicDocCountry( @Nullable final java.lang.String electronicDocCountry )
    {
        rememberChangedField("ElectronicDocCountry", this.electronicDocCountry);
        this.electronicDocCountry = electronicDocCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocCountry_Text</b>
     * </p>
     * 
     * @param electronicDocCountry_Text
     *            Country Name (Max. 50 Characters)
     */
    public void setElectronicDocCountry_Text( @Nullable final java.lang.String electronicDocCountry_Text )
    {
        rememberChangedField("ElectronicDocCountry_Text", this.electronicDocCountry_Text);
        this.electronicDocCountry_Text = electronicDocCountry_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocSourceType</b>
     * </p>
     * 
     * @param electronicDocSourceType
     *            eDocument Source Type
     */
    public void setElectronicDocSourceType( @Nullable final java.lang.String electronicDocSourceType )
    {
        rememberChangedField("ElectronicDocSourceType", this.electronicDocSourceType);
        this.electronicDocSourceType = electronicDocSourceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocSourceType_Text</b>
     * </p>
     * 
     * @param electronicDocSourceType_Text
     *            eDocument Source Description
     */
    public void setElectronicDocSourceType_Text( @Nullable final java.lang.String electronicDocSourceType_Text )
    {
        rememberChangedField("ElectronicDocSourceType_Text", this.electronicDocSourceType_Text);
        this.electronicDocSourceType_Text = electronicDocSourceType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocSourceKey</b>
     * </p>
     * 
     * @param electronicDocSourceKey
     *            eDocument Source Key
     */
    public void setElectronicDocSourceKey( @Nullable final java.lang.String electronicDocSourceKey )
    {
        rememberChangedField("ElectronicDocSourceKey", this.electronicDocSourceKey);
        this.electronicDocSourceKey = electronicDocSourceKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocType</b>
     * </p>
     * 
     * @param electronicDocType
     *            eDocument Type
     */
    public void setElectronicDocType( @Nullable final java.lang.String electronicDocType )
    {
        rememberChangedField("ElectronicDocType", this.electronicDocType);
        this.electronicDocType = electronicDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocType_Text</b>
     * </p>
     * 
     * @param electronicDocType_Text
     *            eDocument Type Description
     */
    public void setElectronicDocType_Text( @Nullable final java.lang.String electronicDocType_Text )
    {
        rememberChangedField("ElectronicDocType_Text", this.electronicDocType_Text);
        this.electronicDocType_Text = electronicDocType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocProcess</b>
     * </p>
     * 
     * @param electronicDocProcess
     *            eDocument Process
     */
    public void setElectronicDocProcess( @Nullable final java.lang.String electronicDocProcess )
    {
        rememberChangedField("ElectronicDocProcess", this.electronicDocProcess);
        this.electronicDocProcess = electronicDocProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocProcess_Text</b>
     * </p>
     * 
     * @param electronicDocProcess_Text
     *            eDocument Process Description
     */
    public void setElectronicDocProcess_Text( @Nullable final java.lang.String electronicDocProcess_Text )
    {
        rememberChangedField("ElectronicDocProcess_Text", this.electronicDocProcess_Text);
        this.electronicDocProcess_Text = electronicDocProcess_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocProcessStatus</b>
     * </p>
     * 
     * @param electronicDocProcessStatus
     *            eDocument Process Status
     */
    public void setElectronicDocProcessStatus( @Nullable final java.lang.String electronicDocProcessStatus )
    {
        rememberChangedField("ElectronicDocProcessStatus", this.electronicDocProcessStatus);
        this.electronicDocProcessStatus = electronicDocProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocProcessStatus_Text</b>
     * </p>
     * 
     * @param electronicDocProcessStatus_Text
     *            eDocument Status Description
     */
    public void setElectronicDocProcessStatus_Text( @Nullable final java.lang.String electronicDocProcessStatus_Text )
    {
        rememberChangedField("ElectronicDocProcessStatus_Text", this.electronicDocProcessStatus_Text);
        this.electronicDocProcessStatus_Text = electronicDocProcessStatus_Text;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocLastChangeDate</b>
     * </p>
     * 
     * @param electronicDocLastChangeDate
     *            Changed on (Date)
     */
    public void setElectronicDocLastChangeDate( @Nullable final LocalDate electronicDocLastChangeDate )
    {
        rememberChangedField("ElectronicDocLastChangeDate", this.electronicDocLastChangeDate);
        this.electronicDocLastChangeDate = electronicDocLastChangeDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocLastChangeTime</b>
     * </p>
     * 
     * @param electronicDocLastChangeTime
     *            Changed On (Time)
     */
    public void setElectronicDocLastChangeTime( @Nullable final LocalTime electronicDocLastChangeTime )
    {
        rememberChangedField("ElectronicDocLastChangeTime", this.electronicDocLastChangeTime);
        this.electronicDocLastChangeTime = electronicDocLastChangeTime;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocCreationDate</b>
     * </p>
     * 
     * @param electronicDocCreationDate
     *            Creation Date
     */
    public void setElectronicDocCreationDate( @Nullable final LocalDate electronicDocCreationDate )
    {
        rememberChangedField("ElectronicDocCreationDate", this.electronicDocCreationDate);
        this.electronicDocCreationDate = electronicDocCreationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicDocCreationTime</b>
     * </p>
     * 
     * @param electronicDocCreationTime
     *            Created on (Time)
     */
    public void setElectronicDocCreationTime( @Nullable final LocalTime electronicDocCreationTime )
    {
        rememberChangedField("ElectronicDocCreationTime", this.electronicDocCreationTime);
        this.electronicDocCreationTime = electronicDocCreationTime;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ElectronicDocFile";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ElectronicDocFileUUID", getElectronicDocFileUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ElectronicDocFileUUID", getElectronicDocFileUUID());
        values.put("ElectronicDocFileType", getElectronicDocFileType());
        values.put("ElectronicDocFileName", getElectronicDocFileName());
        values.put("ElectronicDocFileCreationTime", getElectronicDocFileCreationTime());
        values.put("ElectronicDocFileCreationDate", getElectronicDocFileCreationDate());
        values.put("ElectronicDocFileContent", getElectronicDocFileContent());
        values.put("ElectronicDocUUID", getElectronicDocUUID());
        values.put("ElectronicDocCompanyCode", getElectronicDocCompanyCode());
        values.put("ElectronicDocCountry", getElectronicDocCountry());
        values.put("ElectronicDocCountry_Text", getElectronicDocCountry_Text());
        values.put("ElectronicDocSourceType", getElectronicDocSourceType());
        values.put("ElectronicDocSourceType_Text", getElectronicDocSourceType_Text());
        values.put("ElectronicDocSourceKey", getElectronicDocSourceKey());
        values.put("ElectronicDocType", getElectronicDocType());
        values.put("ElectronicDocType_Text", getElectronicDocType_Text());
        values.put("ElectronicDocProcess", getElectronicDocProcess());
        values.put("ElectronicDocProcess_Text", getElectronicDocProcess_Text());
        values.put("ElectronicDocProcessStatus", getElectronicDocProcessStatus());
        values.put("ElectronicDocProcessStatus_Text", getElectronicDocProcessStatus_Text());
        values.put("ElectronicDocLastChangeDate", getElectronicDocLastChangeDate());
        values.put("ElectronicDocLastChangeTime", getElectronicDocLastChangeTime());
        values.put("ElectronicDocCreationDate", getElectronicDocCreationDate());
        values.put("ElectronicDocCreationTime", getElectronicDocCreationTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ElectronicDocFileUUID") ) {
                final Object value = values.remove("ElectronicDocFileUUID");
                if( (value == null) || (!value.equals(getElectronicDocFileUUID())) ) {
                    setElectronicDocFileUUID(((UUID) value));
                }
            }
            if( values.containsKey("ElectronicDocFileType") ) {
                final Object value = values.remove("ElectronicDocFileType");
                if( (value == null) || (!value.equals(getElectronicDocFileType())) ) {
                    setElectronicDocFileType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocFileName") ) {
                final Object value = values.remove("ElectronicDocFileName");
                if( (value == null) || (!value.equals(getElectronicDocFileName())) ) {
                    setElectronicDocFileName(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocFileCreationTime") ) {
                final Object value = values.remove("ElectronicDocFileCreationTime");
                if( (value == null) || (!value.equals(getElectronicDocFileCreationTime())) ) {
                    setElectronicDocFileCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ElectronicDocFileCreationDate") ) {
                final Object value = values.remove("ElectronicDocFileCreationDate");
                if( (value == null) || (!value.equals(getElectronicDocFileCreationDate())) ) {
                    setElectronicDocFileCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ElectronicDocFileContent") ) {
                final Object value = values.remove("ElectronicDocFileContent");
                if( (value == null) || (!value.equals(getElectronicDocFileContent())) ) {
                    setElectronicDocFileContent(((byte[]) value));
                }
            }
            if( values.containsKey("ElectronicDocUUID") ) {
                final Object value = values.remove("ElectronicDocUUID");
                if( (value == null) || (!value.equals(getElectronicDocUUID())) ) {
                    setElectronicDocUUID(((UUID) value));
                }
            }
            if( values.containsKey("ElectronicDocCompanyCode") ) {
                final Object value = values.remove("ElectronicDocCompanyCode");
                if( (value == null) || (!value.equals(getElectronicDocCompanyCode())) ) {
                    setElectronicDocCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocCountry") ) {
                final Object value = values.remove("ElectronicDocCountry");
                if( (value == null) || (!value.equals(getElectronicDocCountry())) ) {
                    setElectronicDocCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocCountry_Text") ) {
                final Object value = values.remove("ElectronicDocCountry_Text");
                if( (value == null) || (!value.equals(getElectronicDocCountry_Text())) ) {
                    setElectronicDocCountry_Text(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocSourceType") ) {
                final Object value = values.remove("ElectronicDocSourceType");
                if( (value == null) || (!value.equals(getElectronicDocSourceType())) ) {
                    setElectronicDocSourceType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocSourceType_Text") ) {
                final Object value = values.remove("ElectronicDocSourceType_Text");
                if( (value == null) || (!value.equals(getElectronicDocSourceType_Text())) ) {
                    setElectronicDocSourceType_Text(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocSourceKey") ) {
                final Object value = values.remove("ElectronicDocSourceKey");
                if( (value == null) || (!value.equals(getElectronicDocSourceKey())) ) {
                    setElectronicDocSourceKey(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocType") ) {
                final Object value = values.remove("ElectronicDocType");
                if( (value == null) || (!value.equals(getElectronicDocType())) ) {
                    setElectronicDocType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocType_Text") ) {
                final Object value = values.remove("ElectronicDocType_Text");
                if( (value == null) || (!value.equals(getElectronicDocType_Text())) ) {
                    setElectronicDocType_Text(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocProcess") ) {
                final Object value = values.remove("ElectronicDocProcess");
                if( (value == null) || (!value.equals(getElectronicDocProcess())) ) {
                    setElectronicDocProcess(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocProcess_Text") ) {
                final Object value = values.remove("ElectronicDocProcess_Text");
                if( (value == null) || (!value.equals(getElectronicDocProcess_Text())) ) {
                    setElectronicDocProcess_Text(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocProcessStatus") ) {
                final Object value = values.remove("ElectronicDocProcessStatus");
                if( (value == null) || (!value.equals(getElectronicDocProcessStatus())) ) {
                    setElectronicDocProcessStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocProcessStatus_Text") ) {
                final Object value = values.remove("ElectronicDocProcessStatus_Text");
                if( (value == null) || (!value.equals(getElectronicDocProcessStatus_Text())) ) {
                    setElectronicDocProcessStatus_Text(((java.lang.String) value));
                }
            }
            if( values.containsKey("ElectronicDocLastChangeDate") ) {
                final Object value = values.remove("ElectronicDocLastChangeDate");
                if( (value == null) || (!value.equals(getElectronicDocLastChangeDate())) ) {
                    setElectronicDocLastChangeDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ElectronicDocLastChangeTime") ) {
                final Object value = values.remove("ElectronicDocLastChangeTime");
                if( (value == null) || (!value.equals(getElectronicDocLastChangeTime())) ) {
                    setElectronicDocLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ElectronicDocCreationDate") ) {
                final Object value = values.remove("ElectronicDocCreationDate");
                if( (value == null) || (!value.equals(getElectronicDocCreationDate())) ) {
                    setElectronicDocCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ElectronicDocCreationTime") ) {
                final Object value = values.remove("ElectronicDocCreationTime");
                if( (value == null) || (!value.equals(getElectronicDocCreationTime())) ) {
                    setElectronicDocCreationTime(((LocalTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return DocumentComplianceElectronicDocumentFileService.DEFAULT_SERVICE_PATH;
    }

}
