/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.enterpriseprojectinternaltype;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.EnterpriseProjectInternalTypeService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Internal Project Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EntProjectTypeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class EntProjectType extends VdmEntity<EntProjectType> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_entprojtype.v0001.EntProjectTypeType";
    /**
     * Selector for all available fields of EntProjectType.
     * 
     */
    public final static SimpleProperty<EntProjectType> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>EntProjectTypeInternal</b>
     * </p>
     * 
     * @return Project Type
     */
    @Nullable
    @ElementName( "EntProjectTypeInternal" )
    private java.lang.String entProjectTypeInternal;
    public final static SimpleProperty.String<EntProjectType> ENT_PROJECT_TYPE_INTERNAL =
        new SimpleProperty.String<EntProjectType>(EntProjectType.class, "EntProjectTypeInternal");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCategory</b>
     * </p>
     * 
     * @return Project Category
     */
    @Nullable
    @ElementName( "ProjectCategory" )
    private java.lang.String projectCategory;
    public final static SimpleProperty.String<EntProjectType> PROJECT_CATEGORY =
        new SimpleProperty.String<EntProjectType>(EntProjectType.class, "ProjectCategory");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
     * </p>
     * 
     * @return Project Profile
     */
    @Nullable
    @ElementName( "ProjectProfileCode" )
    private java.lang.String projectProfileCode;
    public final static SimpleProperty.String<EntProjectType> PROJECT_PROFILE_CODE =
        new SimpleProperty.String<EntProjectType>(EntProjectType.class, "ProjectProfileCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectTypeName</b>
     * </p>
     * 
     * @return Short Text for Type
     */
    @Nullable
    @ElementName( "ProjectTypeName" )
    private java.lang.String projectTypeName;
    public final static SimpleProperty.String<EntProjectType> PROJECT_TYPE_NAME =
        new SimpleProperty.String<EntProjectType>(EntProjectType.class, "ProjectTypeName");
    /**
     * Navigation property <b>_EntProjectTypeText</b> for <b>EntProjectType</b> to multiple <b>EntProjectTypeText</b>.
     * 
     */
    @ElementName( "_EntProjectTypeText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EntProjectTypeText> to_EntProjectTypeText;
    /**
     * Use with available request builders to apply the <b>_EntProjectTypeText</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<EntProjectType, EntProjectTypeText> TO__ENT_PROJECT_TYPE_TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<EntProjectType, EntProjectTypeText>(
            EntProjectType.class,
            "_EntProjectTypeText",
            EntProjectTypeText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<EntProjectType> getType()
    {
        return EntProjectType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>EntProjectTypeInternal</b>
     * </p>
     * 
     * @param entProjectTypeInternal
     *            Project Type
     */
    public void setEntProjectTypeInternal( @Nullable final java.lang.String entProjectTypeInternal )
    {
        rememberChangedField("EntProjectTypeInternal", this.entProjectTypeInternal);
        this.entProjectTypeInternal = entProjectTypeInternal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCategory</b>
     * </p>
     * 
     * @param projectCategory
     *            Project Category
     */
    public void setProjectCategory( @Nullable final java.lang.String projectCategory )
    {
        rememberChangedField("ProjectCategory", this.projectCategory);
        this.projectCategory = projectCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
     * </p>
     * 
     * @param projectProfileCode
     *            Project Profile
     */
    public void setProjectProfileCode( @Nullable final java.lang.String projectProfileCode )
    {
        rememberChangedField("ProjectProfileCode", this.projectProfileCode);
        this.projectProfileCode = projectProfileCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectTypeName</b>
     * </p>
     * 
     * @param projectTypeName
     *            Short Text for Type
     */
    public void setProjectTypeName( @Nullable final java.lang.String projectTypeName )
    {
        rememberChangedField("ProjectTypeName", this.projectTypeName);
        this.projectTypeName = projectTypeName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "EntProjectType";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("EntProjectTypeInternal", getEntProjectTypeInternal());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("EntProjectTypeInternal", getEntProjectTypeInternal());
        values.put("ProjectCategory", getProjectCategory());
        values.put("ProjectProfileCode", getProjectProfileCode());
        values.put("ProjectTypeName", getProjectTypeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EntProjectTypeInternal") ) {
                final Object value = values.remove("EntProjectTypeInternal");
                if( (value == null) || (!value.equals(getEntProjectTypeInternal())) ) {
                    setEntProjectTypeInternal(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProjectCategory") ) {
                final Object value = values.remove("ProjectCategory");
                if( (value == null) || (!value.equals(getProjectCategory())) ) {
                    setProjectCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProjectProfileCode") ) {
                final Object value = values.remove("ProjectProfileCode");
                if( (value == null) || (!value.equals(getProjectProfileCode())) ) {
                    setProjectProfileCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProjectTypeName") ) {
                final Object value = values.remove("ProjectTypeName");
                if( (value == null) || (!value.equals(getProjectTypeName())) ) {
                    setProjectTypeName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_EntProjectTypeText") ) {
                final Object value = (values).remove("_EntProjectTypeText");
                if( value instanceof Iterable ) {
                    if( to_EntProjectTypeText == null ) {
                        to_EntProjectTypeText = Lists.newArrayList();
                    } else {
                        to_EntProjectTypeText = Lists.newArrayList(to_EntProjectTypeText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EntProjectTypeText entity;
                        if( to_EntProjectTypeText.size() > i ) {
                            entity = to_EntProjectTypeText.get(i);
                        } else {
                            entity = new EntProjectTypeText();
                            to_EntProjectTypeText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return EnterpriseProjectInternalTypeService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_EntProjectTypeText != null ) {
            (values).put("_EntProjectTypeText", to_EntProjectTypeText);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>EntProjectTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_EntProjectTypeText</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjectType</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_EntProjectTypeText</b> is already loaded, the result will
     *         contain the <b>EntProjectTypeText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EntProjectTypeText>> getEntProjectTypeTextIfPresent()
    {
        return Option.of(to_EntProjectTypeText);
    }

    /**
     * Overwrites the list of associated <b>EntProjectTypeText</b> entities for the loaded navigation property
     * <b>_EntProjectTypeText</b>.
     * <p>
     * If the navigation property <b>_EntProjectTypeText</b> of a queried <b>EntProjectType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>EntProjectTypeText</b> entities.
     */
    public void setEntProjectTypeText( @Nonnull final List<EntProjectTypeText> value )
    {
        if( to_EntProjectTypeText == null ) {
            to_EntProjectTypeText = Lists.newArrayList();
        }
        to_EntProjectTypeText.clear();
        to_EntProjectTypeText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EntProjectTypeText</b> entities. This corresponds to the OData
     * navigation property <b>_EntProjectTypeText</b>.
     * <p>
     * If the navigation property <b>_EntProjectTypeText</b> of a queried <b>EntProjectType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>EntProjectTypeText</b> entities.
     */
    public void addEntProjectTypeText( EntProjectTypeText... entity )
    {
        if( to_EntProjectTypeText == null ) {
            to_EntProjectTypeText = Lists.newArrayList();
        }
        to_EntProjectTypeText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of EntProjectType instances.
     * 
     */
    public final static class EntProjectTypeBuilder
    {

        private List<EntProjectTypeText> to_EntProjectTypeText = Lists.newArrayList();

        private EntProjectType.EntProjectTypeBuilder to_EntProjectTypeText( final List<EntProjectTypeText> value )
        {
            to_EntProjectTypeText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_EntProjectTypeText</b> for <b>EntProjectType</b> to multiple
         * <b>EntProjectTypeText</b>.
         * 
         * @param value
         *            The EntProjectTypeTexts to build this EntProjectType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjectType.EntProjectTypeBuilder entProjectTypeText( EntProjectTypeText... value )
        {
            return to_EntProjectTypeText(Lists.newArrayList(value));
        }

    }

}
