/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.enterpriseprojectinternaltype;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.EnterpriseProjectInternalTypeService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>EntProjectTypeTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class EntProjectTypeText extends VdmEntity<EntProjectTypeText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_entprojtype.v0001.EntProjectTypeTextType";
    /**
     * Selector for all available fields of EntProjectTypeText.
     * 
     */
    public final static SimpleProperty<EntProjectTypeText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<EntProjectTypeText> LANGUAGE =
        new SimpleProperty.String<EntProjectTypeText>(EntProjectTypeText.class, "Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>EntProjectTypeInternal</b>
     * </p>
     * 
     * @return Project Type
     */
    @Nullable
    @ElementName( "EntProjectTypeInternal" )
    private java.lang.String entProjectTypeInternal;
    public final static SimpleProperty.String<EntProjectTypeText> ENT_PROJECT_TYPE_INTERNAL =
        new SimpleProperty.String<EntProjectTypeText>(EntProjectTypeText.class, "EntProjectTypeInternal");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectTypeName</b>
     * </p>
     * 
     * @return Short Text for Type
     */
    @Nullable
    @ElementName( "ProjectTypeName" )
    private java.lang.String projectTypeName;
    public final static SimpleProperty.String<EntProjectTypeText> PROJECT_TYPE_NAME =
        new SimpleProperty.String<EntProjectTypeText>(EntProjectTypeText.class, "ProjectTypeName");
    /**
     * Navigation property <b>_ProjectType</b> for <b>EntProjectTypeText</b> to single <b>EntProjectType</b>.
     * 
     */
    @ElementName( "_ProjectType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EntProjectType to_ProjectType;
    /**
     * Use with available request builders to apply the <b>_ProjectType</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<EntProjectTypeText, EntProjectType> TO__PROJECT_TYPE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<EntProjectTypeText, EntProjectType>(
            EntProjectTypeText.class,
            "_ProjectType",
            EntProjectType.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<EntProjectTypeText> getType()
    {
        return EntProjectTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>EntProjectTypeInternal</b>
     * </p>
     * 
     * @param entProjectTypeInternal
     *            Project Type
     */
    public void setEntProjectTypeInternal( @Nullable final java.lang.String entProjectTypeInternal )
    {
        rememberChangedField("EntProjectTypeInternal", this.entProjectTypeInternal);
        this.entProjectTypeInternal = entProjectTypeInternal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectTypeName</b>
     * </p>
     * 
     * @param projectTypeName
     *            Short Text for Type
     */
    public void setProjectTypeName( @Nullable final java.lang.String projectTypeName )
    {
        rememberChangedField("ProjectTypeName", this.projectTypeName);
        this.projectTypeName = projectTypeName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "EntProjectTypeText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Language", getLanguage());
        entityKey.addKeyProperty("EntProjectTypeInternal", getEntProjectTypeInternal());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("EntProjectTypeInternal", getEntProjectTypeInternal());
        values.put("ProjectTypeName", getProjectTypeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("EntProjectTypeInternal") ) {
                final Object value = values.remove("EntProjectTypeInternal");
                if( (value == null) || (!value.equals(getEntProjectTypeInternal())) ) {
                    setEntProjectTypeInternal(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProjectTypeName") ) {
                final Object value = values.remove("ProjectTypeName");
                if( (value == null) || (!value.equals(getProjectTypeName())) ) {
                    setProjectTypeName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProjectType") ) {
                final Object value = (values).remove("_ProjectType");
                if( value instanceof Map ) {
                    if( to_ProjectType == null ) {
                        to_ProjectType = new EntProjectType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ProjectType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return EnterpriseProjectInternalTypeService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProjectType != null ) {
            (values).put("_ProjectType", to_ProjectType);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>EntProjectType</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_ProjectType</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjectTypeText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProjectType</b> is already loaded, the result will contain
     *         the <b>EntProjectType</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<EntProjectType> getProjectTypeIfPresent()
    {
        return Option.of(to_ProjectType);
    }

    /**
     * Overwrites the associated <b>EntProjectType</b> entity for the loaded navigation property <b>_ProjectType</b>.
     * 
     * @param value
     *            New <b>EntProjectType</b> entity.
     */
    public void setProjectType( final EntProjectType value )
    {
        to_ProjectType = value;
    }

    /**
     * Helper class to allow for fluent creation of EntProjectTypeText instances.
     * 
     */
    public final static class EntProjectTypeTextBuilder
    {

        private EntProjectType to_ProjectType;

        private EntProjectTypeText.EntProjectTypeTextBuilder to_ProjectType( final EntProjectType value )
        {
            to_ProjectType = value;
            return this;
        }

        /**
         * Navigation property <b>_ProjectType</b> for <b>EntProjectTypeText</b> to single <b>EntProjectType</b>.
         * 
         * @param value
         *            The EntProjectType to build this EntProjectTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjectTypeText.EntProjectTypeTextBuilder projectType( final EntProjectType value )
        {
            return to_ProjectType(value);
        }

    }

}
