/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.enterpriseprojectpriority;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.EnterpriseProjectPriorityService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Priority
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EntProjPriorityCodeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class EntProjPriorityCode extends VdmEntity<EntProjPriorityCode> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_entprojectprioritycode.v0001.EntProjPriorityCodeType";
    /**
     * Selector for all available fields of EntProjPriorityCode.
     * 
     */
    public final static SimpleProperty<EntProjPriorityCode> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     * 
     * @return The priorityCode contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "PriorityCode" )
    private java.lang.String priorityCode;
    public final static SimpleProperty.String<EntProjPriorityCode> PRIORITY_CODE =
        new SimpleProperty.String<EntProjPriorityCode>(EntProjPriorityCode.class, "PriorityCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCodeName</b>
     * </p>
     * 
     * @return Object Name
     */
    @Nullable
    @ElementName( "PriorityCodeName" )
    private java.lang.String priorityCodeName;
    public final static SimpleProperty.String<EntProjPriorityCode> PRIORITY_CODE_NAME =
        new SimpleProperty.String<EntProjPriorityCode>(EntProjPriorityCode.class, "PriorityCodeName");
    /**
     * Navigation property <b>_PriorityCodeText</b> for <b>EntProjPriorityCode</b> to multiple
     * <b>EntProjPriorityCodeText</b>.
     * 
     */
    @ElementName( "_PriorityCodeText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EntProjPriorityCodeText> to_PriorityCodeText;
    /**
     * Use with available request builders to apply the <b>_PriorityCodeText</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<EntProjPriorityCode, EntProjPriorityCodeText> TO__PRIORITY_CODE_TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<EntProjPriorityCode, EntProjPriorityCodeText>(
            EntProjPriorityCode.class,
            "_PriorityCodeText",
            EntProjPriorityCodeText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<EntProjPriorityCode> getType()
    {
        return EntProjPriorityCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     * 
     * @param priorityCode
     *            The priorityCode to set.
     */
    public void setPriorityCode( @Nullable final java.lang.String priorityCode )
    {
        rememberChangedField("PriorityCode", this.priorityCode);
        this.priorityCode = priorityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCodeName</b>
     * </p>
     * 
     * @param priorityCodeName
     *            Object Name
     */
    public void setPriorityCodeName( @Nullable final java.lang.String priorityCodeName )
    {
        rememberChangedField("PriorityCodeName", this.priorityCodeName);
        this.priorityCodeName = priorityCodeName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "EntProjPriorityCode";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("PriorityCode", getPriorityCode());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("PriorityCode", getPriorityCode());
        values.put("PriorityCodeName", getPriorityCodeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PriorityCode") ) {
                final Object value = values.remove("PriorityCode");
                if( (value == null) || (!value.equals(getPriorityCode())) ) {
                    setPriorityCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("PriorityCodeName") ) {
                final Object value = values.remove("PriorityCodeName");
                if( (value == null) || (!value.equals(getPriorityCodeName())) ) {
                    setPriorityCodeName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_PriorityCodeText") ) {
                final Object value = (values).remove("_PriorityCodeText");
                if( value instanceof Iterable ) {
                    if( to_PriorityCodeText == null ) {
                        to_PriorityCodeText = Lists.newArrayList();
                    } else {
                        to_PriorityCodeText = Lists.newArrayList(to_PriorityCodeText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EntProjPriorityCodeText entity;
                        if( to_PriorityCodeText.size() > i ) {
                            entity = to_PriorityCodeText.get(i);
                        } else {
                            entity = new EntProjPriorityCodeText();
                            to_PriorityCodeText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return EnterpriseProjectPriorityService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_PriorityCodeText != null ) {
            (values).put("_PriorityCodeText", to_PriorityCodeText);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>EntProjPriorityCodeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_PriorityCodeText</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjPriorityCode</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_PriorityCodeText</b> is already loaded, the result will
     *         contain the <b>EntProjPriorityCodeText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EntProjPriorityCodeText>> getPriorityCodeTextIfPresent()
    {
        return Option.of(to_PriorityCodeText);
    }

    /**
     * Overwrites the list of associated <b>EntProjPriorityCodeText</b> entities for the loaded navigation property
     * <b>_PriorityCodeText</b>.
     * <p>
     * If the navigation property <b>_PriorityCodeText</b> of a queried <b>EntProjPriorityCode</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>EntProjPriorityCodeText</b> entities.
     */
    public void setPriorityCodeText( @Nonnull final List<EntProjPriorityCodeText> value )
    {
        if( to_PriorityCodeText == null ) {
            to_PriorityCodeText = Lists.newArrayList();
        }
        to_PriorityCodeText.clear();
        to_PriorityCodeText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EntProjPriorityCodeText</b> entities. This corresponds to the OData
     * navigation property <b>_PriorityCodeText</b>.
     * <p>
     * If the navigation property <b>_PriorityCodeText</b> of a queried <b>EntProjPriorityCode</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>EntProjPriorityCodeText</b> entities.
     */
    public void addPriorityCodeText( EntProjPriorityCodeText... entity )
    {
        if( to_PriorityCodeText == null ) {
            to_PriorityCodeText = Lists.newArrayList();
        }
        to_PriorityCodeText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of EntProjPriorityCode instances.
     * 
     */
    public final static class EntProjPriorityCodeBuilder
    {

        private List<EntProjPriorityCodeText> to_PriorityCodeText = Lists.newArrayList();

        private EntProjPriorityCode.EntProjPriorityCodeBuilder to_PriorityCodeText(
            final List<EntProjPriorityCodeText> value )
        {
            to_PriorityCodeText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_PriorityCodeText</b> for <b>EntProjPriorityCode</b> to multiple
         * <b>EntProjPriorityCodeText</b>.
         * 
         * @param value
         *            The EntProjPriorityCodeTexts to build this EntProjPriorityCode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjPriorityCode.EntProjPriorityCodeBuilder priorityCodeText( EntProjPriorityCodeText... value )
        {
            return to_PriorityCodeText(Lists.newArrayList(value));
        }

    }

}
