/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.enterpriseprojectpriority;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.EnterpriseProjectPriorityService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>EntProjPriorityCodeTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class EntProjPriorityCodeText extends VdmEntity<EntProjPriorityCodeText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_entprojectprioritycode.v0001.EntProjPriorityCodeTextType";
    /**
     * Selector for all available fields of EntProjPriorityCodeText.
     * 
     */
    public final static SimpleProperty<EntProjPriorityCodeText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<EntProjPriorityCodeText> LANGUAGE =
        new SimpleProperty.String<EntProjPriorityCodeText>(EntProjPriorityCodeText.class, "Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     * 
     * @return The priorityCode contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "PriorityCode" )
    private java.lang.String priorityCode;
    public final static SimpleProperty.String<EntProjPriorityCodeText> PRIORITY_CODE =
        new SimpleProperty.String<EntProjPriorityCodeText>(EntProjPriorityCodeText.class, "PriorityCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCodeName</b>
     * </p>
     * 
     * @return Object Name
     */
    @Nullable
    @ElementName( "PriorityCodeName" )
    private java.lang.String priorityCodeName;
    public final static SimpleProperty.String<EntProjPriorityCodeText> PRIORITY_CODE_NAME =
        new SimpleProperty.String<EntProjPriorityCodeText>(EntProjPriorityCodeText.class, "PriorityCodeName");
    /**
     * Navigation property <b>_PriorityCode</b> for <b>EntProjPriorityCodeText</b> to single <b>EntProjPriorityCode</b>.
     * 
     */
    @ElementName( "_PriorityCode" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EntProjPriorityCode to_PriorityCode;
    /**
     * Use with available request builders to apply the <b>_PriorityCode</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<EntProjPriorityCodeText, EntProjPriorityCode> TO__PRIORITY_CODE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<EntProjPriorityCodeText, EntProjPriorityCode>(
            EntProjPriorityCodeText.class,
            "_PriorityCode",
            EntProjPriorityCode.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<EntProjPriorityCodeText> getType()
    {
        return EntProjPriorityCodeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     * 
     * @param priorityCode
     *            The priorityCode to set.
     */
    public void setPriorityCode( @Nullable final java.lang.String priorityCode )
    {
        rememberChangedField("PriorityCode", this.priorityCode);
        this.priorityCode = priorityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCodeName</b>
     * </p>
     * 
     * @param priorityCodeName
     *            Object Name
     */
    public void setPriorityCodeName( @Nullable final java.lang.String priorityCodeName )
    {
        rememberChangedField("PriorityCodeName", this.priorityCodeName);
        this.priorityCodeName = priorityCodeName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "EntProjPriorityCodeText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Language", getLanguage());
        entityKey.addKeyProperty("PriorityCode", getPriorityCode());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("PriorityCode", getPriorityCode());
        values.put("PriorityCodeName", getPriorityCodeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("PriorityCode") ) {
                final Object value = values.remove("PriorityCode");
                if( (value == null) || (!value.equals(getPriorityCode())) ) {
                    setPriorityCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("PriorityCodeName") ) {
                final Object value = values.remove("PriorityCodeName");
                if( (value == null) || (!value.equals(getPriorityCodeName())) ) {
                    setPriorityCodeName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_PriorityCode") ) {
                final Object value = (values).remove("_PriorityCode");
                if( value instanceof Map ) {
                    if( to_PriorityCode == null ) {
                        to_PriorityCode = new EntProjPriorityCode();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_PriorityCode.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return EnterpriseProjectPriorityService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_PriorityCode != null ) {
            (values).put("_PriorityCode", to_PriorityCode);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>EntProjPriorityCode</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_PriorityCode</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjPriorityCodeText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_PriorityCode</b> is already loaded, the result will
     *         contain the <b>EntProjPriorityCode</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EntProjPriorityCode> getPriorityCodeIfPresent()
    {
        return Option.of(to_PriorityCode);
    }

    /**
     * Overwrites the associated <b>EntProjPriorityCode</b> entity for the loaded navigation property
     * <b>_PriorityCode</b>.
     * 
     * @param value
     *            New <b>EntProjPriorityCode</b> entity.
     */
    public void setPriorityCode( final EntProjPriorityCode value )
    {
        to_PriorityCode = value;
    }

    /**
     * Helper class to allow for fluent creation of EntProjPriorityCodeText instances.
     * 
     */
    public final static class EntProjPriorityCodeTextBuilder
    {

        private EntProjPriorityCode to_PriorityCode;
        private java.lang.String priorityCode = null;

        private EntProjPriorityCodeText.EntProjPriorityCodeTextBuilder to_PriorityCode(
            final EntProjPriorityCode value )
        {
            to_PriorityCode = value;
            return this;
        }

        /**
         * Navigation property <b>_PriorityCode</b> for <b>EntProjPriorityCodeText</b> to single
         * <b>EntProjPriorityCode</b>.
         * 
         * @param value
         *            The EntProjPriorityCode to build this EntProjPriorityCodeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjPriorityCodeText.EntProjPriorityCodeTextBuilder priorityCode( final EntProjPriorityCode value )
        {
            return to_PriorityCode(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 3
         * <p>
         * Original property name from the Odata EDM: <b>PriorityCode</b>
         * </p>
         * 
         * @param value
         *            The priorityCode to build this EntProjPriorityCodeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjPriorityCodeText.EntProjPriorityCodeTextBuilder priorityCode( final java.lang.String value )
        {
            priorityCode = value;
            return this;
        }

    }

}
