/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.enterpriseprojectprocessingstatus;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.EnterpriseProjectProcessingStatusService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Processing Status
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProcessingStatusType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProcessingStatus extends VdmEntity<ProcessingStatus> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_entprojprocessingstatus.v0001.ProcessingStatusType";
    /**
     * Selector for all available fields of ProcessingStatus.
     * 
     */
    public final static SimpleProperty<ProcessingStatus> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     * 
     * @return Processing Status
     */
    @Nullable
    @ElementName( "ProcessingStatus" )
    private java.lang.String processingStatus;
    public final static SimpleProperty.String<ProcessingStatus> PROCESSING_STATUS =
        new SimpleProperty.String<ProcessingStatus>(ProcessingStatus.class, "ProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatusText</b>
     * </p>
     * 
     * @return Processing Status Text
     */
    @Nullable
    @ElementName( "ProcessingStatusText" )
    private java.lang.String processingStatusText;
    public final static SimpleProperty.String<ProcessingStatus> PROCESSING_STATUS_TEXT =
        new SimpleProperty.String<ProcessingStatus>(ProcessingStatus.class, "ProcessingStatusText");
    /**
     * Navigation property <b>_ProcessingStatusText</b> for <b>ProcessingStatus</b> to multiple
     * <b>ProcessingStatusText</b>.
     * 
     */
    @ElementName( "_ProcessingStatusText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProcessingStatusText> to_ProcessingStatusText;
    /**
     * Use with available request builders to apply the <b>_ProcessingStatusText</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProcessingStatus, ProcessingStatusText> TO__PROCESSING_STATUS_TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProcessingStatus, ProcessingStatusText>(
            ProcessingStatus.class,
            "_ProcessingStatusText",
            ProcessingStatusText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProcessingStatus> getType()
    {
        return ProcessingStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     * 
     * @param processingStatus
     *            Processing Status
     */
    public void setProcessingStatus( @Nullable final java.lang.String processingStatus )
    {
        rememberChangedField("ProcessingStatus", this.processingStatus);
        this.processingStatus = processingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatusText</b>
     * </p>
     * 
     * @param processingStatusText
     *            Processing Status Text
     */
    public void setProcessingStatusText( @Nullable final java.lang.String processingStatusText )
    {
        rememberChangedField("ProcessingStatusText", this.processingStatusText);
        this.processingStatusText = processingStatusText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProcessingStatus";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ProcessingStatus", getProcessingStatus());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ProcessingStatus", getProcessingStatus());
        values.put("ProcessingStatusText", getProcessingStatusText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProcessingStatus") ) {
                final Object value = values.remove("ProcessingStatus");
                if( (value == null) || (!value.equals(getProcessingStatus())) ) {
                    setProcessingStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProcessingStatusText") ) {
                final Object value = values.remove("ProcessingStatusText");
                if( (value == null) || (!value.equals(getProcessingStatusText())) ) {
                    setProcessingStatusText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProcessingStatusText") ) {
                final Object value = (values).remove("_ProcessingStatusText");
                if( value instanceof Iterable ) {
                    if( to_ProcessingStatusText == null ) {
                        to_ProcessingStatusText = Lists.newArrayList();
                    } else {
                        to_ProcessingStatusText = Lists.newArrayList(to_ProcessingStatusText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProcessingStatusText entity;
                        if( to_ProcessingStatusText.size() > i ) {
                            entity = to_ProcessingStatusText.get(i);
                        } else {
                            entity = new ProcessingStatusText();
                            to_ProcessingStatusText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return EnterpriseProjectProcessingStatusService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProcessingStatusText != null ) {
            (values).put("_ProcessingStatusText", to_ProcessingStatusText);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProcessingStatusText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_ProcessingStatusText</b>.
     * <p>
     * If the navigation property for an entity <b>ProcessingStatus</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProcessingStatusText</b> is already loaded, the result
     *         will contain the <b>ProcessingStatusText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProcessingStatusText>> getProcessingStatusTextIfPresent()
    {
        return Option.of(to_ProcessingStatusText);
    }

    /**
     * Overwrites the list of associated <b>ProcessingStatusText</b> entities for the loaded navigation property
     * <b>_ProcessingStatusText</b>.
     * <p>
     * If the navigation property <b>_ProcessingStatusText</b> of a queried <b>ProcessingStatus</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>ProcessingStatusText</b> entities.
     */
    public void setProcessingStatusText( @Nonnull final List<ProcessingStatusText> value )
    {
        if( to_ProcessingStatusText == null ) {
            to_ProcessingStatusText = Lists.newArrayList();
        }
        to_ProcessingStatusText.clear();
        to_ProcessingStatusText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProcessingStatusText</b> entities. This corresponds to the OData
     * navigation property <b>_ProcessingStatusText</b>.
     * <p>
     * If the navigation property <b>_ProcessingStatusText</b> of a queried <b>ProcessingStatus</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>ProcessingStatusText</b> entities.
     */
    public void addProcessingStatusText( ProcessingStatusText... entity )
    {
        if( to_ProcessingStatusText == null ) {
            to_ProcessingStatusText = Lists.newArrayList();
        }
        to_ProcessingStatusText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProcessingStatus instances.
     * 
     */
    public final static class ProcessingStatusBuilder
    {

        private List<ProcessingStatusText> to_ProcessingStatusText = Lists.newArrayList();
        private java.lang.String processingStatusText = null;

        private ProcessingStatus.ProcessingStatusBuilder to_ProcessingStatusText(
            final List<ProcessingStatusText> value )
        {
            to_ProcessingStatusText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_ProcessingStatusText</b> for <b>ProcessingStatus</b> to multiple
         * <b>ProcessingStatusText</b>.
         * 
         * @param value
         *            The ProcessingStatusTexts to build this ProcessingStatus with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProcessingStatus.ProcessingStatusBuilder processingStatusText( ProcessingStatusText... value )
        {
            return to_ProcessingStatusText(Lists.newArrayList(value));
        }

        /**
         * Constraints: Not nullable, Maximum length: 60
         * <p>
         * Original property name from the Odata EDM: <b>ProcessingStatusText</b>
         * </p>
         * 
         * @param value
         *            The processingStatusText to build this ProcessingStatus with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProcessingStatus.ProcessingStatusBuilder processingStatusText( final java.lang.String value )
        {
            processingStatusText = value;
            return this;
        }

    }

}
