/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.enterpriseprojectprocessingstatus;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.EnterpriseProjectProcessingStatusService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>ProcessingStatusTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProcessingStatusText extends VdmEntity<ProcessingStatusText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_entprojprocessingstatus.v0001.ProcessingStatusTextType";
    /**
     * Selector for all available fields of ProcessingStatusText.
     * 
     */
    public final static SimpleProperty<ProcessingStatusText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<ProcessingStatusText> LANGUAGE =
        new SimpleProperty.String<ProcessingStatusText>(ProcessingStatusText.class, "Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     * 
     * @return Processing Status
     */
    @Nullable
    @ElementName( "ProcessingStatus" )
    private java.lang.String processingStatus;
    public final static SimpleProperty.String<ProcessingStatusText> PROCESSING_STATUS =
        new SimpleProperty.String<ProcessingStatusText>(ProcessingStatusText.class, "ProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatusText</b>
     * </p>
     * 
     * @return Processing Status Text
     */
    @Nullable
    @ElementName( "ProcessingStatusText" )
    private java.lang.String processingStatusText;
    public final static SimpleProperty.String<ProcessingStatusText> PROCESSING_STATUS_TEXT =
        new SimpleProperty.String<ProcessingStatusText>(ProcessingStatusText.class, "ProcessingStatusText");
    /**
     * Navigation property <b>_ProcessingStatus</b> for <b>ProcessingStatusText</b> to single <b>ProcessingStatus</b>.
     * 
     */
    @ElementName( "_ProcessingStatus" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProcessingStatus to_ProcessingStatus;
    /**
     * Use with available request builders to apply the <b>_ProcessingStatus</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProcessingStatusText, ProcessingStatus> TO__PROCESSING_STATUS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProcessingStatusText, ProcessingStatus>(
            ProcessingStatusText.class,
            "_ProcessingStatus",
            ProcessingStatus.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProcessingStatusText> getType()
    {
        return ProcessingStatusText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     * 
     * @param processingStatus
     *            Processing Status
     */
    public void setProcessingStatus( @Nullable final java.lang.String processingStatus )
    {
        rememberChangedField("ProcessingStatus", this.processingStatus);
        this.processingStatus = processingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatusText</b>
     * </p>
     * 
     * @param processingStatusText
     *            Processing Status Text
     */
    public void setProcessingStatusText( @Nullable final java.lang.String processingStatusText )
    {
        rememberChangedField("ProcessingStatusText", this.processingStatusText);
        this.processingStatusText = processingStatusText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProcessingStatusText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Language", getLanguage());
        entityKey.addKeyProperty("ProcessingStatus", getProcessingStatus());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ProcessingStatus", getProcessingStatus());
        values.put("ProcessingStatusText", getProcessingStatusText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProcessingStatus") ) {
                final Object value = values.remove("ProcessingStatus");
                if( (value == null) || (!value.equals(getProcessingStatus())) ) {
                    setProcessingStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProcessingStatusText") ) {
                final Object value = values.remove("ProcessingStatusText");
                if( (value == null) || (!value.equals(getProcessingStatusText())) ) {
                    setProcessingStatusText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProcessingStatus") ) {
                final Object value = (values).remove("_ProcessingStatus");
                if( value instanceof Map ) {
                    if( to_ProcessingStatus == null ) {
                        to_ProcessingStatus = new ProcessingStatus();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ProcessingStatus.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return EnterpriseProjectProcessingStatusService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProcessingStatus != null ) {
            (values).put("_ProcessingStatus", to_ProcessingStatus);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProcessingStatus</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_ProcessingStatus</b>.
     * <p>
     * If the navigation property for an entity <b>ProcessingStatusText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProcessingStatus</b> is already loaded, the result will
     *         contain the <b>ProcessingStatus</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProcessingStatus> getProcessingStatusIfPresent()
    {
        return Option.of(to_ProcessingStatus);
    }

    /**
     * Overwrites the associated <b>ProcessingStatus</b> entity for the loaded navigation property
     * <b>_ProcessingStatus</b>.
     * 
     * @param value
     *            New <b>ProcessingStatus</b> entity.
     */
    public void setProcessingStatus( final ProcessingStatus value )
    {
        to_ProcessingStatus = value;
    }

    /**
     * Helper class to allow for fluent creation of ProcessingStatusText instances.
     * 
     */
    public final static class ProcessingStatusTextBuilder
    {

        private ProcessingStatus to_ProcessingStatus;
        private java.lang.String processingStatus = null;

        private ProcessingStatusText.ProcessingStatusTextBuilder to_ProcessingStatus( final ProcessingStatus value )
        {
            to_ProcessingStatus = value;
            return this;
        }

        /**
         * Navigation property <b>_ProcessingStatus</b> for <b>ProcessingStatusText</b> to single
         * <b>ProcessingStatus</b>.
         * 
         * @param value
         *            The ProcessingStatus to build this ProcessingStatusText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProcessingStatusText.ProcessingStatusTextBuilder processingStatus( final ProcessingStatus value )
        {
            return to_ProcessingStatus(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 2
         * <p>
         * Original property name from the Odata EDM: <b>ProcessingStatus</b>
         * </p>
         * 
         * @param value
         *            The processingStatus to build this ProcessingStatusText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProcessingStatusText.ProcessingStatusTextBuilder processingStatus( final java.lang.String value )
        {
            processingStatus = value;
            return this;
        }

    }

}
