/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.enterpriseprojectprofile;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.EnterpriseProjectProfileService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Profile
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProjectProfileCodeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProjectProfileCode extends VdmEntity<ProjectProfileCode> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_entprojectprofilecode.v0001.ProjectProfileCodeType";
    /**
     * Selector for all available fields of ProjectProfileCode.
     * 
     */
    public final static SimpleProperty<ProjectProfileCode> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
     * </p>
     * 
     * @return Project Profile
     */
    @Nullable
    @ElementName( "ProjectProfileCode" )
    private java.lang.String projectProfileCode;
    public final static SimpleProperty.String<ProjectProfileCode> PROJECT_PROFILE_CODE =
        new SimpleProperty.String<ProjectProfileCode>(ProjectProfileCode.class, "ProjectProfileCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCodeText</b>
     * </p>
     * 
     * @return Text for Profile
     */
    @Nullable
    @ElementName( "ProjectProfileCodeText" )
    private java.lang.String projectProfileCodeText;
    public final static SimpleProperty.String<ProjectProfileCode> PROJECT_PROFILE_CODE_TEXT =
        new SimpleProperty.String<ProjectProfileCode>(ProjectProfileCode.class, "ProjectProfileCodeText");
    /**
     * Navigation property <b>_ProjectProfileCodeText</b> for <b>ProjectProfileCode</b> to multiple
     * <b>ProjectProfileCodeText</b>.
     * 
     */
    @ElementName( "_ProjectProfileCodeText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProjectProfileCodeText> to_ProjectProfileCodeText;
    /**
     * Use with available request builders to apply the <b>_ProjectProfileCodeText</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProjectProfileCode, ProjectProfileCodeText> TO__PROJECT_PROFILE_CODE_TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<ProjectProfileCode, ProjectProfileCodeText>(
            ProjectProfileCode.class,
            "_ProjectProfileCodeText",
            ProjectProfileCodeText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProjectProfileCode> getType()
    {
        return ProjectProfileCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
     * </p>
     * 
     * @param projectProfileCode
     *            Project Profile
     */
    public void setProjectProfileCode( @Nullable final java.lang.String projectProfileCode )
    {
        rememberChangedField("ProjectProfileCode", this.projectProfileCode);
        this.projectProfileCode = projectProfileCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCodeText</b>
     * </p>
     * 
     * @param projectProfileCodeText
     *            Text for Profile
     */
    public void setProjectProfileCodeText( @Nullable final java.lang.String projectProfileCodeText )
    {
        rememberChangedField("ProjectProfileCodeText", this.projectProfileCodeText);
        this.projectProfileCodeText = projectProfileCodeText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProjectProfileCode";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ProjectProfileCode", getProjectProfileCode());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ProjectProfileCode", getProjectProfileCode());
        values.put("ProjectProfileCodeText", getProjectProfileCodeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectProfileCode") ) {
                final Object value = values.remove("ProjectProfileCode");
                if( (value == null) || (!value.equals(getProjectProfileCode())) ) {
                    setProjectProfileCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProjectProfileCodeText") ) {
                final Object value = values.remove("ProjectProfileCodeText");
                if( (value == null) || (!value.equals(getProjectProfileCodeText())) ) {
                    setProjectProfileCodeText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProjectProfileCodeText") ) {
                final Object value = (values).remove("_ProjectProfileCodeText");
                if( value instanceof Iterable ) {
                    if( to_ProjectProfileCodeText == null ) {
                        to_ProjectProfileCodeText = Lists.newArrayList();
                    } else {
                        to_ProjectProfileCodeText = Lists.newArrayList(to_ProjectProfileCodeText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProjectProfileCodeText entity;
                        if( to_ProjectProfileCodeText.size() > i ) {
                            entity = to_ProjectProfileCodeText.get(i);
                        } else {
                            entity = new ProjectProfileCodeText();
                            to_ProjectProfileCodeText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return EnterpriseProjectProfileService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProjectProfileCodeText != null ) {
            (values).put("_ProjectProfileCodeText", to_ProjectProfileCodeText);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProjectProfileCodeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_ProjectProfileCodeText</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectProfileCode</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProjectProfileCodeText</b> is already loaded, the result
     *         will contain the <b>ProjectProfileCodeText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProjectProfileCodeText>> getProjectProfileCodeTextIfPresent()
    {
        return Option.of(to_ProjectProfileCodeText);
    }

    /**
     * Overwrites the list of associated <b>ProjectProfileCodeText</b> entities for the loaded navigation property
     * <b>_ProjectProfileCodeText</b>.
     * <p>
     * If the navigation property <b>_ProjectProfileCodeText</b> of a queried <b>ProjectProfileCode</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>ProjectProfileCodeText</b> entities.
     */
    public void setProjectProfileCodeText( @Nonnull final List<ProjectProfileCodeText> value )
    {
        if( to_ProjectProfileCodeText == null ) {
            to_ProjectProfileCodeText = Lists.newArrayList();
        }
        to_ProjectProfileCodeText.clear();
        to_ProjectProfileCodeText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProjectProfileCodeText</b> entities. This corresponds to the OData
     * navigation property <b>_ProjectProfileCodeText</b>.
     * <p>
     * If the navigation property <b>_ProjectProfileCodeText</b> of a queried <b>ProjectProfileCode</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>ProjectProfileCodeText</b> entities.
     */
    public void addProjectProfileCodeText( ProjectProfileCodeText... entity )
    {
        if( to_ProjectProfileCodeText == null ) {
            to_ProjectProfileCodeText = Lists.newArrayList();
        }
        to_ProjectProfileCodeText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProjectProfileCode instances.
     * 
     */
    public final static class ProjectProfileCodeBuilder
    {

        private List<ProjectProfileCodeText> to_ProjectProfileCodeText = Lists.newArrayList();
        private java.lang.String projectProfileCodeText = null;

        private ProjectProfileCode.ProjectProfileCodeBuilder to_ProjectProfileCodeText(
            final List<ProjectProfileCodeText> value )
        {
            to_ProjectProfileCodeText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_ProjectProfileCodeText</b> for <b>ProjectProfileCode</b> to multiple
         * <b>ProjectProfileCodeText</b>.
         * 
         * @param value
         *            The ProjectProfileCodeTexts to build this ProjectProfileCode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectProfileCode.ProjectProfileCodeBuilder projectProfileCodeText( ProjectProfileCodeText... value )
        {
            return to_ProjectProfileCodeText(Lists.newArrayList(value));
        }

        /**
         * Constraints: Not nullable, Maximum length: 40
         * <p>
         * Original property name from the Odata EDM: <b>ProjectProfileCodeText</b>
         * </p>
         * 
         * @param value
         *            The projectProfileCodeText to build this ProjectProfileCode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectProfileCode.ProjectProfileCodeBuilder projectProfileCodeText( final java.lang.String value )
        {
            projectProfileCodeText = value;
            return this;
        }

    }

}
