/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.enterpriseprojectprofile;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.EnterpriseProjectProfileService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>ProjectProfileCodeTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProjectProfileCodeText extends VdmEntity<ProjectProfileCodeText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_entprojectprofilecode.v0001.ProjectProfileCodeTextType";
    /**
     * Selector for all available fields of ProjectProfileCodeText.
     * 
     */
    public final static SimpleProperty<ProjectProfileCodeText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<ProjectProfileCodeText> LANGUAGE =
        new SimpleProperty.String<ProjectProfileCodeText>(ProjectProfileCodeText.class, "Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
     * </p>
     * 
     * @return Project Profile
     */
    @Nullable
    @ElementName( "ProjectProfileCode" )
    private java.lang.String projectProfileCode;
    public final static SimpleProperty.String<ProjectProfileCodeText> PROJECT_PROFILE_CODE =
        new SimpleProperty.String<ProjectProfileCodeText>(ProjectProfileCodeText.class, "ProjectProfileCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCodeText</b>
     * </p>
     * 
     * @return Text for Profile
     */
    @Nullable
    @ElementName( "ProjectProfileCodeText" )
    private java.lang.String projectProfileCodeText;
    public final static SimpleProperty.String<ProjectProfileCodeText> PROJECT_PROFILE_CODE_TEXT =
        new SimpleProperty.String<ProjectProfileCodeText>(ProjectProfileCodeText.class, "ProjectProfileCodeText");
    /**
     * Navigation property <b>_ProjectProfileCode</b> for <b>ProjectProfileCodeText</b> to single
     * <b>ProjectProfileCode</b>.
     * 
     */
    @ElementName( "_ProjectProfileCode" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProjectProfileCode to_ProjectProfileCode;
    /**
     * Use with available request builders to apply the <b>_ProjectProfileCode</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProjectProfileCodeText, ProjectProfileCode> TO__PROJECT_PROFILE_CODE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<ProjectProfileCodeText, ProjectProfileCode>(
            ProjectProfileCodeText.class,
            "_ProjectProfileCode",
            ProjectProfileCode.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProjectProfileCodeText> getType()
    {
        return ProjectProfileCodeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
     * </p>
     * 
     * @param projectProfileCode
     *            Project Profile
     */
    public void setProjectProfileCode( @Nullable final java.lang.String projectProfileCode )
    {
        rememberChangedField("ProjectProfileCode", this.projectProfileCode);
        this.projectProfileCode = projectProfileCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCodeText</b>
     * </p>
     * 
     * @param projectProfileCodeText
     *            Text for Profile
     */
    public void setProjectProfileCodeText( @Nullable final java.lang.String projectProfileCodeText )
    {
        rememberChangedField("ProjectProfileCodeText", this.projectProfileCodeText);
        this.projectProfileCodeText = projectProfileCodeText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "ProjectProfileCodeText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Language", getLanguage());
        entityKey.addKeyProperty("ProjectProfileCode", getProjectProfileCode());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ProjectProfileCode", getProjectProfileCode());
        values.put("ProjectProfileCodeText", getProjectProfileCodeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProjectProfileCode") ) {
                final Object value = values.remove("ProjectProfileCode");
                if( (value == null) || (!value.equals(getProjectProfileCode())) ) {
                    setProjectProfileCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProjectProfileCodeText") ) {
                final Object value = values.remove("ProjectProfileCodeText");
                if( (value == null) || (!value.equals(getProjectProfileCodeText())) ) {
                    setProjectProfileCodeText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ProjectProfileCode") ) {
                final Object value = (values).remove("_ProjectProfileCode");
                if( value instanceof Map ) {
                    if( to_ProjectProfileCode == null ) {
                        to_ProjectProfileCode = new ProjectProfileCode();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ProjectProfileCode.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return EnterpriseProjectProfileService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ProjectProfileCode != null ) {
            (values).put("_ProjectProfileCode", to_ProjectProfileCode);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ProjectProfileCode</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_ProjectProfileCode</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectProfileCodeText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ProjectProfileCode</b> is already loaded, the result will
     *         contain the <b>ProjectProfileCode</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProjectProfileCode> getProjectProfileCodeIfPresent()
    {
        return Option.of(to_ProjectProfileCode);
    }

    /**
     * Overwrites the associated <b>ProjectProfileCode</b> entity for the loaded navigation property
     * <b>_ProjectProfileCode</b>.
     * 
     * @param value
     *            New <b>ProjectProfileCode</b> entity.
     */
    public void setProjectProfileCode( final ProjectProfileCode value )
    {
        to_ProjectProfileCode = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjectProfileCodeText instances.
     * 
     */
    public final static class ProjectProfileCodeTextBuilder
    {

        private ProjectProfileCode to_ProjectProfileCode;
        private java.lang.String projectProfileCode = null;

        private ProjectProfileCodeText.ProjectProfileCodeTextBuilder to_ProjectProfileCode(
            final ProjectProfileCode value )
        {
            to_ProjectProfileCode = value;
            return this;
        }

        /**
         * Navigation property <b>_ProjectProfileCode</b> for <b>ProjectProfileCodeText</b> to single
         * <b>ProjectProfileCode</b>.
         * 
         * @param value
         *            The ProjectProfileCode to build this ProjectProfileCodeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectProfileCodeText.ProjectProfileCodeTextBuilder projectProfileCode( final ProjectProfileCode value )
        {
            return to_ProjectProfileCode(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 7
         * <p>
         * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
         * </p>
         * 
         * @param value
         *            The projectProfileCode to build this ProjectProfileCodeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectProfileCodeText.ProjectProfileCodeTextBuilder projectProfileCode( final java.lang.String value )
        {
            projectProfileCode = value;
            return this;
        }

    }

}
