/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource;

import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.EnvironmentHealthAndSafetyExternalSourceService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * External Source
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EHSAmountExternalSourceType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class EHSAmountExternalSource extends VdmEntity<EHSAmountExternalSource> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_ehsamountexternalsrce.v0001.EHSAmountExternalSourceType";
    /**
     * Selector for all available fields of EHSAmountExternalSource.
     * 
     */
    public final static SimpleProperty<EHSAmountExternalSource> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>EHSAmountExternalSource</b>
     * </p>
     * 
     * @return External Source
     */
    @Nullable
    @ElementName( "EHSAmountExternalSource" )
    private java.lang.String eHSAmountExternalSource;
    public final static SimpleProperty.String<EHSAmountExternalSource> EHS_AMOUNT_EXTERNAL_SOURCE =
        new SimpleProperty.String<EHSAmountExternalSource>(EHSAmountExternalSource.class, "EHSAmountExternalSource");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<EHSAmountExternalSource, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<EHSAmountExternalSource, SAP__Message>(
            EHSAmountExternalSource.class,
            "SAP__Messages",
            SAP__Message.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<EHSAmountExternalSource> getType()
    {
        return EHSAmountExternalSource.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>EHSAmountExternalSource</b>
     * </p>
     * 
     * @param eHSAmountExternalSource
     *            External Source
     */
    public void setEHSAmountExternalSource( @Nullable final java.lang.String eHSAmountExternalSource )
    {
        rememberChangedField("EHSAmountExternalSource", this.eHSAmountExternalSource);
        this.eHSAmountExternalSource = eHSAmountExternalSource;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "EHSAmountExternalSource";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("EHSAmountExternalSource", getEHSAmountExternalSource());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("EHSAmountExternalSource", getEHSAmountExternalSource());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EHSAmountExternalSource") ) {
                final Object value = values.remove("EHSAmountExternalSource");
                if( (value == null) || (!value.equals(getEHSAmountExternalSource())) ) {
                    setEHSAmountExternalSource(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return EnvironmentHealthAndSafetyExternalSourceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Action that can be applied to a collection of entities of this class.
     * </p>
     * 
     * @param eHSAmountIsFaulty
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EHSAmountIsFaulty</b>
     *            </p>
     * @param eHSAmountValue
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EHSAmountValue</b>
     *            </p>
     * @param note
     *            Constraints: Not nullable, Maximum length: 255
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Note</b>
     *            </p>
     * @param eHSAmountIsOutOfCalibration
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EHSAmountIsOutOfCalibration</b>
     *            </p>
     * @param unitOfMeasure
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UnitOfMeasure</b>
     *            </p>
     * @param eHSAmountUTCDateTime
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EHSAmountUTCDateTime</b>
     *            </p>
     * @param eHSAmtOutOfPrecisenessOptr
     *            Constraints: Not nullable, Maximum length: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EHSAmtOutOfPrecisenessOptr</b>
     *            </p>
     * @param eHSAmountExternalSource
     *            Constraints: Not nullable, Maximum length: 80
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EHSAmountExternalSource</b>
     *            </p>
     * @param eHSAmountIsNotAvailable
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EHSAmountIsNotAvailable</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to a collection of entities of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<EHSAmountExternalSource, EHSCollectAmountResult_Type>
        collectAmount(
            @Nonnull final java.lang.String eHSAmountExternalSource,
            @Nonnull final OffsetDateTime eHSAmountUTCDateTime,
            @Nonnull final Double eHSAmountValue,
            @Nonnull final java.lang.String unitOfMeasure,
            @Nonnull final Boolean eHSAmountIsFaulty,
            @Nonnull final Boolean eHSAmountIsOutOfCalibration,
            @Nonnull final java.lang.String eHSAmtOutOfPrecisenessOptr,
            @Nonnull final Boolean eHSAmountIsNotAvailable,
            @Nonnull final java.lang.String note )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("EHSAmountExternalSource", eHSAmountExternalSource);
        parameters.put("EHSAmountUTCDateTime", eHSAmountUTCDateTime);
        parameters.put("EHSAmountValue", eHSAmountValue);
        parameters.put("UnitOfMeasure", unitOfMeasure);
        parameters.put("EHSAmountIsFaulty", eHSAmountIsFaulty);
        parameters.put("EHSAmountIsOutOfCalibration", eHSAmountIsOutOfCalibration);
        parameters.put("EHSAmtOutOfPrecisenessOptr", eHSAmtOutOfPrecisenessOptr);
        parameters.put("EHSAmountIsNotAvailable", eHSAmountIsNotAvailable);
        parameters.put("Note", note);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<EHSAmountExternalSource, EHSCollectAmountResult_Type>(
            EHSAmountExternalSource.class,
            EHSCollectAmountResult_Type.class,
            "com.sap.gateway.srvd_a2x.api_ehsamountexternalsrce.v0001.CollectAmount",
            parameters);
    }

}
