/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmComplex;
import com.sap.cloud.sdk.result.ElementName;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>EHSCollectAmountResult_Type</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class EHSCollectAmountResult_Type extends VdmComplex<EHSCollectAmountResult_Type>
{

    @Getter
    private final String odataType =
        "com.sap.gateway.srvd_a2x.api_ehsamountexternalsrce.v0001.EHSCollectAmountResult_Type";
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSAmountImportIsSuccessful</b>
     * </p>
     * 
     * @return The eHSAmountImportIsSuccessful contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "EHSAmountImportIsSuccessful" )
    private java.lang.Boolean eHSAmountImportIsSuccessful;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Boolean<EHSCollectAmountResult_Type> EHS_AMOUNT_IMPORT_IS_SUCCESSFUL =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Boolean<EHSCollectAmountResult_Type>(
            EHSCollectAmountResult_Type.class,
            "EHSAmountImportIsSuccessful");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<EHSCollectAmountResult_Type> getType()
    {
        return EHSCollectAmountResult_Type.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("EHSAmountImportIsSuccessful", getEHSAmountImportIsSuccessful());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EHSAmountImportIsSuccessful") ) {
                final Object value = values.remove("EHSAmountImportIsSuccessful");
                if( (value == null) || (!value.equals(getEHSAmountImportIsSuccessful())) ) {
                    setEHSAmountImportIsSuccessful(((java.lang.Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        return entityKey;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSAmountImportIsSuccessful</b>
     * </p>
     * 
     * @param eHSAmountImportIsSuccessful
     *            The eHSAmountImportIsSuccessful to set.
     */
    public void setEHSAmountImportIsSuccessful( @Nullable final java.lang.Boolean eHSAmountImportIsSuccessful )
    {
        rememberChangedField("EHSAmountImportIsSuccessful", this.eHSAmountImportIsSuccessful);
        this.eHSAmountImportIsSuccessful = eHSAmountImportIsSuccessful;
    }

}
