/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fieldcatalogforpricinginsales;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.FieldCatalogForPricingInSalesService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Fields
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesPricingConditionFieldType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SalesPricingConditionField extends VdmEntity<SalesPricingConditionField> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_slsprcgconditionfield.v0001.SalesPricingConditionFieldType";
    /**
     * Selector for all available fields of SalesPricingConditionField.
     * 
     */
    public final static SimpleProperty<SalesPricingConditionField> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @return Usage of the condition table
     */
    @Nullable
    @ElementName( "ConditionUsage" )
    private java.lang.String conditionUsage;
    public final static SimpleProperty.String<SalesPricingConditionField> CONDITION_USAGE =
        new SimpleProperty.String<SalesPricingConditionField>(SalesPricingConditionField.class, "ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<SalesPricingConditionField> CONDITION_APPLICATION =
        new SimpleProperty.String<SalesPricingConditionField>(SalesPricingConditionField.class, "ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionField</b>
     * </p>
     * 
     * @return Name of the condition field
     */
    @Nullable
    @ElementName( "PricingConditionField" )
    private java.lang.String pricingConditionField;
    public final static SimpleProperty.String<SalesPricingConditionField> PRICING_CONDITION_FIELD =
        new SimpleProperty.String<SalesPricingConditionField>(
            SalesPricingConditionField.class,
            "PricingConditionField");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionGlobalFieldName</b>
     * </p>
     * 
     * @return DD: Field Name Original Spelling
     */
    @Nullable
    @ElementName( "PrcgConditionGlobalFieldName" )
    private java.lang.String prcgConditionGlobalFieldName;
    public final static SimpleProperty.String<SalesPricingConditionField> PRCG_CONDITION_GLOBAL_FIELD_NAME =
        new SimpleProperty.String<SalesPricingConditionField>(
            SalesPricingConditionField.class,
            "PrcgConditionGlobalFieldName");
    /**
     * Navigation property <b>_Text</b> for <b>SalesPricingConditionField</b> to multiple
     * <b>SlsPricingConditionFieldText</b>.
     * 
     */
    @ElementName( "_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPricingConditionFieldText> to_Text;
    /**
     * Use with available request builders to apply the <b>_Text</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingConditionField, SlsPricingConditionFieldText> TO__TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingConditionField, SlsPricingConditionFieldText>(
            SalesPricingConditionField.class,
            "_Text",
            SlsPricingConditionFieldText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SalesPricingConditionField> getType()
    {
        return SalesPricingConditionField.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final java.lang.String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionField</b>
     * </p>
     * 
     * @param pricingConditionField
     *            Name of the condition field
     */
    public void setPricingConditionField( @Nullable final java.lang.String pricingConditionField )
    {
        rememberChangedField("PricingConditionField", this.pricingConditionField);
        this.pricingConditionField = pricingConditionField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionGlobalFieldName</b>
     * </p>
     * 
     * @param prcgConditionGlobalFieldName
     *            DD: Field Name Original Spelling
     */
    public void setPrcgConditionGlobalFieldName( @Nullable final java.lang.String prcgConditionGlobalFieldName )
    {
        rememberChangedField("PrcgConditionGlobalFieldName", this.prcgConditionGlobalFieldName);
        this.prcgConditionGlobalFieldName = prcgConditionGlobalFieldName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SalesPricingConditionField";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionUsage", getConditionUsage());
        entityKey.addKeyProperty("ConditionApplication", getConditionApplication());
        entityKey.addKeyProperty("PricingConditionField", getPricingConditionField());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("PricingConditionField", getPricingConditionField());
        values.put("PrcgConditionGlobalFieldName", getPrcgConditionGlobalFieldName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingConditionField") ) {
                final Object value = values.remove("PricingConditionField");
                if( (value == null) || (!value.equals(getPricingConditionField())) ) {
                    setPricingConditionField(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgConditionGlobalFieldName") ) {
                final Object value = values.remove("PrcgConditionGlobalFieldName");
                if( (value == null) || (!value.equals(getPrcgConditionGlobalFieldName())) ) {
                    setPrcgConditionGlobalFieldName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_Text") ) {
                final Object value = (values).remove("_Text");
                if( value instanceof Iterable ) {
                    if( to_Text == null ) {
                        to_Text = Lists.newArrayList();
                    } else {
                        to_Text = Lists.newArrayList(to_Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPricingConditionFieldText entity;
                        if( to_Text.size() > i ) {
                            entity = to_Text.get(i);
                        } else {
                            entity = new SlsPricingConditionFieldText();
                            to_Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return FieldCatalogForPricingInSalesService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_Text != null ) {
            (values).put("_Text", to_Text);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SlsPricingConditionFieldText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_Text</b>.
     * <p>
     * If the navigation property for an entity <b>SalesPricingConditionField</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Text</b> is already loaded, the result will contain the
     *         <b>SlsPricingConditionFieldText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPricingConditionFieldText>> getTextIfPresent()
    {
        return Option.of(to_Text);
    }

    /**
     * Overwrites the list of associated <b>SlsPricingConditionFieldText</b> entities for the loaded navigation property
     * <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>SalesPricingConditionField</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SlsPricingConditionFieldText</b> entities.
     */
    public void setText( @Nonnull final List<SlsPricingConditionFieldText> value )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.clear();
        to_Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPricingConditionFieldText</b> entities. This corresponds to the
     * OData navigation property <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>SalesPricingConditionField</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SlsPricingConditionFieldText</b> entities.
     */
    public void addText( SlsPricingConditionFieldText... entity )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesPricingConditionField instances.
     * 
     */
    public final static class SalesPricingConditionFieldBuilder
    {

        private List<SlsPricingConditionFieldText> to_Text = Lists.newArrayList();

        private SalesPricingConditionField.SalesPricingConditionFieldBuilder to_Text(
            final List<SlsPricingConditionFieldText> value )
        {
            to_Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_Text</b> for <b>SalesPricingConditionField</b> to multiple
         * <b>SlsPricingConditionFieldText</b>.
         * 
         * @param value
         *            The SlsPricingConditionFieldTexts to build this SalesPricingConditionField with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesPricingConditionField.SalesPricingConditionFieldBuilder text(
            SlsPricingConditionFieldText... value )
        {
            return to_Text(Lists.newArrayList(value));
        }

    }

}
