/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fieldcatalogforpricinginsales;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.FieldCatalogForPricingInSalesService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SlsPricingConditionFieldTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SlsPricingConditionFieldText extends VdmEntity<SlsPricingConditionFieldText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_slsprcgconditionfield.v0001.SlsPricingConditionFieldTextType";
    /**
     * Selector for all available fields of SlsPricingConditionFieldText.
     * 
     */
    public final static SimpleProperty<SlsPricingConditionFieldText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<SlsPricingConditionFieldText> LANGUAGE =
        new SimpleProperty.String<SlsPricingConditionFieldText>(SlsPricingConditionFieldText.class, "Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @return Usage of the condition table
     */
    @Nullable
    @ElementName( "ConditionUsage" )
    private java.lang.String conditionUsage;
    public final static SimpleProperty.String<SlsPricingConditionFieldText> CONDITION_USAGE =
        new SimpleProperty.String<SlsPricingConditionFieldText>(SlsPricingConditionFieldText.class, "ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<SlsPricingConditionFieldText> CONDITION_APPLICATION =
        new SimpleProperty.String<SlsPricingConditionFieldText>(
            SlsPricingConditionFieldText.class,
            "ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionField</b>
     * </p>
     * 
     * @return Field Name
     */
    @Nullable
    @ElementName( "PricingConditionField" )
    private java.lang.String pricingConditionField;
    public final static SimpleProperty.String<SlsPricingConditionFieldText> PRICING_CONDITION_FIELD =
        new SimpleProperty.String<SlsPricingConditionFieldText>(
            SlsPricingConditionFieldText.class,
            "PricingConditionField");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionFieldText</b>
     * </p>
     * 
     * @return Long Field Label
     */
    @Nullable
    @ElementName( "PricingConditionFieldText" )
    private java.lang.String pricingConditionFieldText;
    public final static SimpleProperty.String<SlsPricingConditionFieldText> PRICING_CONDITION_FIELD_TEXT =
        new SimpleProperty.String<SlsPricingConditionFieldText>(
            SlsPricingConditionFieldText.class,
            "PricingConditionFieldText");
    /**
     * Navigation property <b>_SalesPricingConditionField</b> for <b>SlsPricingConditionFieldText</b> to single
     * <b>SalesPricingConditionField</b>.
     * 
     */
    @ElementName( "_SalesPricingConditionField" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesPricingConditionField to_SalesPricingConditionField;
    /**
     * Use with available request builders to apply the <b>_SalesPricingConditionField</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SlsPricingConditionFieldText, SalesPricingConditionField> TO__SALES_PRICING_CONDITION_FIELD =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SlsPricingConditionFieldText, SalesPricingConditionField>(
            SlsPricingConditionFieldText.class,
            "_SalesPricingConditionField",
            SalesPricingConditionField.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SlsPricingConditionFieldText> getType()
    {
        return SlsPricingConditionFieldText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final java.lang.String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionField</b>
     * </p>
     * 
     * @param pricingConditionField
     *            Field Name
     */
    public void setPricingConditionField( @Nullable final java.lang.String pricingConditionField )
    {
        rememberChangedField("PricingConditionField", this.pricingConditionField);
        this.pricingConditionField = pricingConditionField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionFieldText</b>
     * </p>
     * 
     * @param pricingConditionFieldText
     *            Long Field Label
     */
    public void setPricingConditionFieldText( @Nullable final java.lang.String pricingConditionFieldText )
    {
        rememberChangedField("PricingConditionFieldText", this.pricingConditionFieldText);
        this.pricingConditionFieldText = pricingConditionFieldText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SlsPricingConditionFieldText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Language", getLanguage());
        entityKey.addKeyProperty("ConditionUsage", getConditionUsage());
        entityKey.addKeyProperty("ConditionApplication", getConditionApplication());
        entityKey.addKeyProperty("PricingConditionField", getPricingConditionField());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("PricingConditionField", getPricingConditionField());
        values.put("PricingConditionFieldText", getPricingConditionFieldText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingConditionField") ) {
                final Object value = values.remove("PricingConditionField");
                if( (value == null) || (!value.equals(getPricingConditionField())) ) {
                    setPricingConditionField(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingConditionFieldText") ) {
                final Object value = values.remove("PricingConditionFieldText");
                if( (value == null) || (!value.equals(getPricingConditionFieldText())) ) {
                    setPricingConditionFieldText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SalesPricingConditionField") ) {
                final Object value = (values).remove("_SalesPricingConditionField");
                if( value instanceof Map ) {
                    if( to_SalesPricingConditionField == null ) {
                        to_SalesPricingConditionField = new SalesPricingConditionField();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SalesPricingConditionField.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return FieldCatalogForPricingInSalesService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SalesPricingConditionField != null ) {
            (values).put("_SalesPricingConditionField", to_SalesPricingConditionField);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SalesPricingConditionField</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_SalesPricingConditionField</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPricingConditionFieldText</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SalesPricingConditionField</b> is already loaded, the
     *         result will contain the <b>SalesPricingConditionField</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesPricingConditionField> getSalesPricingConditionFieldIfPresent()
    {
        return Option.of(to_SalesPricingConditionField);
    }

    /**
     * Overwrites the associated <b>SalesPricingConditionField</b> entity for the loaded navigation property
     * <b>_SalesPricingConditionField</b>.
     * 
     * @param value
     *            New <b>SalesPricingConditionField</b> entity.
     */
    public void setSalesPricingConditionField( final SalesPricingConditionField value )
    {
        to_SalesPricingConditionField = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsPricingConditionFieldText instances.
     * 
     */
    public final static class SlsPricingConditionFieldTextBuilder
    {

        private SalesPricingConditionField to_SalesPricingConditionField;

        private SlsPricingConditionFieldText.SlsPricingConditionFieldTextBuilder to_SalesPricingConditionField(
            final SalesPricingConditionField value )
        {
            to_SalesPricingConditionField = value;
            return this;
        }

        /**
         * Navigation property <b>_SalesPricingConditionField</b> for <b>SlsPricingConditionFieldText</b> to single
         * <b>SalesPricingConditionField</b>.
         * 
         * @param value
         *            The SalesPricingConditionField to build this SlsPricingConditionFieldText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPricingConditionFieldText.SlsPricingConditionFieldTextBuilder salesPricingConditionField(
            final SalesPricingConditionField value )
        {
            return to_SalesPricingConditionField(value);
        }

    }

}
