/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.FixedAssetUsageObjectForUoPDepreciationService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>FixedAssetUsageObjectType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class FixedAssetUsageObject extends VdmEntity<FixedAssetUsageObject> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_fixedassetusageobject.v0001.FixedAssetUsageObjectType";
    /**
     * Selector for all available fields of FixedAssetUsageObject.
     * 
     */
    public final static SimpleProperty<FixedAssetUsageObject> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<FixedAssetUsageObject> COMPANY_CODE =
        new SimpleProperty.String<FixedAssetUsageObject>(FixedAssetUsageObject.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>FixedAssetUsageObject</b>
     * </p>
     * 
     * @return Usage Object
     */
    @Nullable
    @ElementName( "FixedAssetUsageObject" )
    private java.lang.String fixedAssetUsageObject;
    public final static SimpleProperty.String<FixedAssetUsageObject> FIXED_ASSET_USAGE_OBJECT =
        new SimpleProperty.String<FixedAssetUsageObject>(FixedAssetUsageObject.class, "FixedAssetUsageObject");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FixedAssetUsageObjectDesc</b>
     * </p>
     * 
     * @return Usage Object Description
     */
    @Nullable
    @ElementName( "FixedAssetUsageObjectDesc" )
    private java.lang.String fixedAssetUsageObjectDesc;
    public final static SimpleProperty.String<FixedAssetUsageObject> FIXED_ASSET_USAGE_OBJECT_DESC =
        new SimpleProperty.String<FixedAssetUsageObject>(FixedAssetUsageObject.class, "FixedAssetUsageObjectDesc");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     * 
     * @return Base Unit of Measure
     */
    @Nullable
    @ElementName( "BaseUnit" )
    private java.lang.String baseUnit;
    public final static SimpleProperty.String<FixedAssetUsageObject> BASE_UNIT =
        new SimpleProperty.String<FixedAssetUsageObject>(FixedAssetUsageObject.class, "BaseUnit");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsActive</b>
     * </p>
     * 
     * @return Is Active?
     */
    @Nullable
    @ElementName( "IsActive" )
    private java.lang.Boolean isActive;
    public final static SimpleProperty.Boolean<FixedAssetUsageObject> IS_ACTIVE =
        new SimpleProperty.Boolean<FixedAssetUsageObject>(FixedAssetUsageObject.class, "IsActive");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedAssetUsageObjLfcycSts</b>
     * </p>
     * 
     * @return Usage Object Lifecycle Status
     */
    @Nullable
    @ElementName( "FixedAssetUsageObjLfcycSts" )
    private java.lang.String fixedAssetUsageObjLfcycSts;
    public final static SimpleProperty.String<FixedAssetUsageObject> FIXED_ASSET_USAGE_OBJ_LFCYC_STS =
        new SimpleProperty.String<FixedAssetUsageObject>(FixedAssetUsageObject.class, "FixedAssetUsageObjLfcycSts");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FixedAssetUsageObjLfcycName</b>
     * </p>
     * 
     * @return Usage Object Lifecycle Status Text
     */
    @Nullable
    @ElementName( "FixedAssetUsageObjLfcycName" )
    private java.lang.String fixedAssetUsageObjLfcycName;
    public final static SimpleProperty.String<FixedAssetUsageObject> FIXED_ASSET_USAGE_OBJ_LFCYC_NAME =
        new SimpleProperty.String<FixedAssetUsageObject>(FixedAssetUsageObject.class, "FixedAssetUsageObjLfcycName");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @Nullable
    @ElementName( "LastChangeDateTime" )
    private OffsetDateTime lastChangeDateTime;
    public final static SimpleProperty.DateTime<FixedAssetUsageObject> LAST_CHANGE_DATE_TIME =
        new SimpleProperty.DateTime<FixedAssetUsageObject>(FixedAssetUsageObject.class, "LastChangeDateTime");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<FixedAssetUsageObject, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<FixedAssetUsageObject, SAP__Message>(
            FixedAssetUsageObject.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_UsageObjectPeriod</b> for <b>FixedAssetUsageObject</b> to multiple
     * <b>FixedAssetUsageObjectPeriod</b>.
     * 
     */
    @ElementName( "_UsageObjectPeriod" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FixedAssetUsageObjectPeriod> to_UsageObjectPeriod;
    /**
     * Navigation property <b>_UsageObjectTotal</b> for <b>FixedAssetUsageObject</b> to multiple
     * <b>FixedAssetUsageObjectTotal</b>.
     * 
     */
    @ElementName( "_UsageObjectTotal" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<FixedAssetUsageObjectTotal> to_UsageObjectTotal;
    /**
     * Use with available request builders to apply the <b>_UsageObjectPeriod</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<FixedAssetUsageObject, FixedAssetUsageObjectPeriod> TO__USAGE_OBJECT_PERIOD =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<FixedAssetUsageObject, FixedAssetUsageObjectPeriod>(
            FixedAssetUsageObject.class,
            "_UsageObjectPeriod",
            FixedAssetUsageObjectPeriod.class);
    /**
     * Use with available request builders to apply the <b>_UsageObjectTotal</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<FixedAssetUsageObject, FixedAssetUsageObjectTotal> TO__USAGE_OBJECT_TOTAL =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<FixedAssetUsageObject, FixedAssetUsageObjectTotal>(
            FixedAssetUsageObject.class,
            "_UsageObjectTotal",
            FixedAssetUsageObjectTotal.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<FixedAssetUsageObject> getType()
    {
        return FixedAssetUsageObject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>FixedAssetUsageObject</b>
     * </p>
     * 
     * @param fixedAssetUsageObject
     *            Usage Object
     */
    public void setFixedAssetUsageObject( @Nullable final java.lang.String fixedAssetUsageObject )
    {
        rememberChangedField("FixedAssetUsageObject", this.fixedAssetUsageObject);
        this.fixedAssetUsageObject = fixedAssetUsageObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>FixedAssetUsageObjectDesc</b>
     * </p>
     * 
     * @param fixedAssetUsageObjectDesc
     *            Usage Object Description
     */
    public void setFixedAssetUsageObjectDesc( @Nullable final java.lang.String fixedAssetUsageObjectDesc )
    {
        rememberChangedField("FixedAssetUsageObjectDesc", this.fixedAssetUsageObjectDesc);
        this.fixedAssetUsageObjectDesc = fixedAssetUsageObjectDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     * 
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final java.lang.String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsActive</b>
     * </p>
     * 
     * @param isActive
     *            Is Active?
     */
    public void setIsActive( @Nullable final java.lang.Boolean isActive )
    {
        rememberChangedField("IsActive", this.isActive);
        this.isActive = isActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedAssetUsageObjLfcycSts</b>
     * </p>
     * 
     * @param fixedAssetUsageObjLfcycSts
     *            Usage Object Lifecycle Status
     */
    public void setFixedAssetUsageObjLfcycSts( @Nullable final java.lang.String fixedAssetUsageObjLfcycSts )
    {
        rememberChangedField("FixedAssetUsageObjLfcycSts", this.fixedAssetUsageObjLfcycSts);
        this.fixedAssetUsageObjLfcycSts = fixedAssetUsageObjLfcycSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>FixedAssetUsageObjLfcycName</b>
     * </p>
     * 
     * @param fixedAssetUsageObjLfcycName
     *            Usage Object Lifecycle Status Text
     */
    public void setFixedAssetUsageObjLfcycName( @Nullable final java.lang.String fixedAssetUsageObjLfcycName )
    {
        rememberChangedField("FixedAssetUsageObjLfcycName", this.fixedAssetUsageObjLfcycName);
        this.fixedAssetUsageObjLfcycName = fixedAssetUsageObjLfcycName;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final OffsetDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "FixedAssetUsageObject";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("FixedAssetUsageObject", getFixedAssetUsageObject());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("FixedAssetUsageObject", getFixedAssetUsageObject());
        values.put("FixedAssetUsageObjectDesc", getFixedAssetUsageObjectDesc());
        values.put("BaseUnit", getBaseUnit());
        values.put("IsActive", getIsActive());
        values.put("FixedAssetUsageObjLfcycSts", getFixedAssetUsageObjLfcycSts());
        values.put("FixedAssetUsageObjLfcycName", getFixedAssetUsageObjLfcycName());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("FixedAssetUsageObject") ) {
                final Object value = values.remove("FixedAssetUsageObject");
                if( (value == null) || (!value.equals(getFixedAssetUsageObject())) ) {
                    setFixedAssetUsageObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("FixedAssetUsageObjectDesc") ) {
                final Object value = values.remove("FixedAssetUsageObjectDesc");
                if( (value == null) || (!value.equals(getFixedAssetUsageObjectDesc())) ) {
                    setFixedAssetUsageObjectDesc(((java.lang.String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("IsActive") ) {
                final Object value = values.remove("IsActive");
                if( (value == null) || (!value.equals(getIsActive())) ) {
                    setIsActive(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("FixedAssetUsageObjLfcycSts") ) {
                final Object value = values.remove("FixedAssetUsageObjLfcycSts");
                if( (value == null) || (!value.equals(getFixedAssetUsageObjLfcycSts())) ) {
                    setFixedAssetUsageObjLfcycSts(((java.lang.String) value));
                }
            }
            if( values.containsKey("FixedAssetUsageObjLfcycName") ) {
                final Object value = values.remove("FixedAssetUsageObjLfcycName");
                if( (value == null) || (!value.equals(getFixedAssetUsageObjLfcycName())) ) {
                    setFixedAssetUsageObjLfcycName(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((OffsetDateTime) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_UsageObjectPeriod") ) {
                final Object value = (values).remove("_UsageObjectPeriod");
                if( value instanceof Iterable ) {
                    if( to_UsageObjectPeriod == null ) {
                        to_UsageObjectPeriod = Lists.newArrayList();
                    } else {
                        to_UsageObjectPeriod = Lists.newArrayList(to_UsageObjectPeriod);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FixedAssetUsageObjectPeriod entity;
                        if( to_UsageObjectPeriod.size() > i ) {
                            entity = to_UsageObjectPeriod.get(i);
                        } else {
                            entity = new FixedAssetUsageObjectPeriod();
                            to_UsageObjectPeriod.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_UsageObjectTotal") ) {
                final Object value = (values).remove("_UsageObjectTotal");
                if( value instanceof Iterable ) {
                    if( to_UsageObjectTotal == null ) {
                        to_UsageObjectTotal = Lists.newArrayList();
                    } else {
                        to_UsageObjectTotal = Lists.newArrayList(to_UsageObjectTotal);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        FixedAssetUsageObjectTotal entity;
                        if( to_UsageObjectTotal.size() > i ) {
                            entity = to_UsageObjectTotal.get(i);
                        } else {
                            entity = new FixedAssetUsageObjectTotal();
                            to_UsageObjectTotal.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return FixedAssetUsageObjectForUoPDepreciationService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_UsageObjectPeriod != null ) {
            (values).put("_UsageObjectPeriod", to_UsageObjectPeriod);
        }
        if( to_UsageObjectTotal != null ) {
            (values).put("_UsageObjectTotal", to_UsageObjectTotal);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>FixedAssetUsageObjectPeriod</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_UsageObjectPeriod</b>.
     * <p>
     * If the navigation property for an entity <b>FixedAssetUsageObject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_UsageObjectPeriod</b> is already loaded, the result will
     *         contain the <b>FixedAssetUsageObjectPeriod</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FixedAssetUsageObjectPeriod>> getUsageObjectPeriodIfPresent()
    {
        return Option.of(to_UsageObjectPeriod);
    }

    /**
     * Overwrites the list of associated <b>FixedAssetUsageObjectPeriod</b> entities for the loaded navigation property
     * <b>_UsageObjectPeriod</b>.
     * <p>
     * If the navigation property <b>_UsageObjectPeriod</b> of a queried <b>FixedAssetUsageObject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>FixedAssetUsageObjectPeriod</b> entities.
     */
    public void setUsageObjectPeriod( @Nonnull final List<FixedAssetUsageObjectPeriod> value )
    {
        if( to_UsageObjectPeriod == null ) {
            to_UsageObjectPeriod = Lists.newArrayList();
        }
        to_UsageObjectPeriod.clear();
        to_UsageObjectPeriod.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FixedAssetUsageObjectPeriod</b> entities. This corresponds to the
     * OData navigation property <b>_UsageObjectPeriod</b>.
     * <p>
     * If the navigation property <b>_UsageObjectPeriod</b> of a queried <b>FixedAssetUsageObject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>FixedAssetUsageObjectPeriod</b> entities.
     */
    public void addUsageObjectPeriod( FixedAssetUsageObjectPeriod... entity )
    {
        if( to_UsageObjectPeriod == null ) {
            to_UsageObjectPeriod = Lists.newArrayList();
        }
        to_UsageObjectPeriod.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>FixedAssetUsageObjectTotal</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_UsageObjectTotal</b>.
     * <p>
     * If the navigation property for an entity <b>FixedAssetUsageObject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_UsageObjectTotal</b> is already loaded, the result will
     *         contain the <b>FixedAssetUsageObjectTotal</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<FixedAssetUsageObjectTotal>> getUsageObjectTotalIfPresent()
    {
        return Option.of(to_UsageObjectTotal);
    }

    /**
     * Overwrites the list of associated <b>FixedAssetUsageObjectTotal</b> entities for the loaded navigation property
     * <b>_UsageObjectTotal</b>.
     * <p>
     * If the navigation property <b>_UsageObjectTotal</b> of a queried <b>FixedAssetUsageObject</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>FixedAssetUsageObjectTotal</b> entities.
     */
    public void setUsageObjectTotal( @Nonnull final List<FixedAssetUsageObjectTotal> value )
    {
        if( to_UsageObjectTotal == null ) {
            to_UsageObjectTotal = Lists.newArrayList();
        }
        to_UsageObjectTotal.clear();
        to_UsageObjectTotal.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>FixedAssetUsageObjectTotal</b> entities. This corresponds to the OData
     * navigation property <b>_UsageObjectTotal</b>.
     * <p>
     * If the navigation property <b>_UsageObjectTotal</b> of a queried <b>FixedAssetUsageObject</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>FixedAssetUsageObjectTotal</b> entities.
     */
    public void addUsageObjectTotal( FixedAssetUsageObjectTotal... entity )
    {
        if( to_UsageObjectTotal == null ) {
            to_UsageObjectTotal = Lists.newArrayList();
        }
        to_UsageObjectTotal.addAll(Lists.newArrayList(entity));
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<FixedAssetUsageObject, FixedAssetUsageObject>
        executeDeactivation()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<FixedAssetUsageObject, FixedAssetUsageObject>(
            FixedAssetUsageObject.class,
            FixedAssetUsageObject.class,
            "com.sap.gateway.srvd_a2x.api_fixedassetusageobject.v0001.ExecuteDeactivation",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<FixedAssetUsageObject, FixedAssetUsageObject>
        executeActivation()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<FixedAssetUsageObject, FixedAssetUsageObject>(
            FixedAssetUsageObject.class,
            FixedAssetUsageObject.class,
            "com.sap.gateway.srvd_a2x.api_fixedassetusageobject.v0001.ExecuteActivation",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of FixedAssetUsageObject instances.
     * 
     */
    public final static class FixedAssetUsageObjectBuilder
    {

        private List<FixedAssetUsageObjectPeriod> to_UsageObjectPeriod = Lists.newArrayList();
        private List<FixedAssetUsageObjectTotal> to_UsageObjectTotal = Lists.newArrayList();

        private FixedAssetUsageObject.FixedAssetUsageObjectBuilder to_UsageObjectPeriod(
            final List<FixedAssetUsageObjectPeriod> value )
        {
            to_UsageObjectPeriod.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_UsageObjectPeriod</b> for <b>FixedAssetUsageObject</b> to multiple
         * <b>FixedAssetUsageObjectPeriod</b>.
         * 
         * @param value
         *            The FixedAssetUsageObjectPeriods to build this FixedAssetUsageObject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FixedAssetUsageObject.FixedAssetUsageObjectBuilder usageObjectPeriod(
            FixedAssetUsageObjectPeriod... value )
        {
            return to_UsageObjectPeriod(Lists.newArrayList(value));
        }

        private FixedAssetUsageObject.FixedAssetUsageObjectBuilder to_UsageObjectTotal(
            final List<FixedAssetUsageObjectTotal> value )
        {
            to_UsageObjectTotal.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_UsageObjectTotal</b> for <b>FixedAssetUsageObject</b> to multiple
         * <b>FixedAssetUsageObjectTotal</b>.
         * 
         * @param value
         *            The FixedAssetUsageObjectTotals to build this FixedAssetUsageObject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FixedAssetUsageObject.FixedAssetUsageObjectBuilder usageObjectTotal(
            FixedAssetUsageObjectTotal... value )
        {
            return to_UsageObjectTotal(Lists.newArrayList(value));
        }

    }

}
