/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.FixedAssetUsageObjectForUoPDepreciationService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>FixedAssetUsageObjectPeriodType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class FixedAssetUsageObjectPeriod extends VdmEntity<FixedAssetUsageObjectPeriod> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_fixedassetusageobject.v0001.FixedAssetUsageObjectPeriodType";
    /**
     * Selector for all available fields of FixedAssetUsageObjectPeriod.
     * 
     */
    public final static SimpleProperty<FixedAssetUsageObjectPeriod> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<FixedAssetUsageObjectPeriod> COMPANY_CODE =
        new SimpleProperty.String<FixedAssetUsageObjectPeriod>(FixedAssetUsageObjectPeriod.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>FixedAssetUsageObject</b>
     * </p>
     * 
     * @return Usage Object
     */
    @Nullable
    @ElementName( "FixedAssetUsageObject" )
    private java.lang.String fixedAssetUsageObject;
    public final static SimpleProperty.String<FixedAssetUsageObjectPeriod> FIXED_ASSET_USAGE_OBJECT =
        new SimpleProperty.String<FixedAssetUsageObjectPeriod>(
            FixedAssetUsageObjectPeriod.class,
            "FixedAssetUsageObject");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @return Date Validity Ends
     */
    @Nullable
    @ElementName( "ValidityEndDate" )
    private LocalDate validityEndDate;
    public final static SimpleProperty.Date<FixedAssetUsageObjectPeriod> VALIDITY_END_DATE =
        new SimpleProperty.Date<FixedAssetUsageObjectPeriod>(FixedAssetUsageObjectPeriod.class, "ValidityEndDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @return Date for Beginning of Validity
     */
    @Nullable
    @ElementName( "ValidityStartDate" )
    private LocalDate validityStartDate;
    public final static SimpleProperty.Date<FixedAssetUsageObjectPeriod> VALIDITY_START_DATE =
        new SimpleProperty.Date<FixedAssetUsageObjectPeriod>(FixedAssetUsageObjectPeriod.class, "ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PeriodPlannedQtyInProdnUnit</b>
     * </p>
     * 
     * @return Planned Number of Units in the Period
     */
    @Nullable
    @ElementName( "PeriodPlannedQtyInProdnUnit" )
    @DecimalDescriptor( precision = 18, scale = 3 )
    private BigDecimal periodPlannedQtyInProdnUnit;
    public final static SimpleProperty.NumericDecimal<FixedAssetUsageObjectPeriod> PERIOD_PLANNED_QTY_IN_PRODN_UNIT =
        new SimpleProperty.NumericDecimal<FixedAssetUsageObjectPeriod>(
            FixedAssetUsageObjectPeriod.class,
            "PeriodPlannedQtyInProdnUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     * 
     * @return Base Unit of Measure
     */
    @Nullable
    @ElementName( "BaseUnit" )
    private java.lang.String baseUnit;
    public final static SimpleProperty.String<FixedAssetUsageObjectPeriod> BASE_UNIT =
        new SimpleProperty.String<FixedAssetUsageObjectPeriod>(FixedAssetUsageObjectPeriod.class, "BaseUnit");
    /**
     * Navigation property <b>_UsageObject</b> for <b>FixedAssetUsageObjectPeriod</b> to single
     * <b>FixedAssetUsageObject</b>.
     * 
     */
    @ElementName( "_UsageObject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private FixedAssetUsageObject to_UsageObject;
    /**
     * Use with available request builders to apply the <b>_UsageObject</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<FixedAssetUsageObjectPeriod, FixedAssetUsageObject> TO__USAGE_OBJECT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<FixedAssetUsageObjectPeriod, FixedAssetUsageObject>(
            FixedAssetUsageObjectPeriod.class,
            "_UsageObject",
            FixedAssetUsageObject.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<FixedAssetUsageObjectPeriod> getType()
    {
        return FixedAssetUsageObjectPeriod.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>FixedAssetUsageObject</b>
     * </p>
     * 
     * @param fixedAssetUsageObject
     *            Usage Object
     */
    public void setFixedAssetUsageObject( @Nullable final java.lang.String fixedAssetUsageObject )
    {
        rememberChangedField("FixedAssetUsageObject", this.fixedAssetUsageObject);
        this.fixedAssetUsageObject = fixedAssetUsageObject;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     * 
     * @param validityEndDate
     *            Date Validity Ends
     */
    public void setValidityEndDate( @Nullable final LocalDate validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     * 
     * @param validityStartDate
     *            Date for Beginning of Validity
     */
    public void setValidityStartDate( @Nullable final LocalDate validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 18, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PeriodPlannedQtyInProdnUnit</b>
     * </p>
     * 
     * @param periodPlannedQtyInProdnUnit
     *            Planned Number of Units in the Period
     */
    public void setPeriodPlannedQtyInProdnUnit( @Nullable final BigDecimal periodPlannedQtyInProdnUnit )
    {
        rememberChangedField("PeriodPlannedQtyInProdnUnit", this.periodPlannedQtyInProdnUnit);
        this.periodPlannedQtyInProdnUnit = periodPlannedQtyInProdnUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     * 
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final java.lang.String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "FixedAssetUsageObjectPeriod";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("FixedAssetUsageObject", getFixedAssetUsageObject());
        entityKey.addKeyProperty("ValidityEndDate", getValidityEndDate());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("FixedAssetUsageObject", getFixedAssetUsageObject());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("PeriodPlannedQtyInProdnUnit", getPeriodPlannedQtyInProdnUnit());
        values.put("BaseUnit", getBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("FixedAssetUsageObject") ) {
                final Object value = values.remove("FixedAssetUsageObject");
                if( (value == null) || (!value.equals(getFixedAssetUsageObject())) ) {
                    setFixedAssetUsageObject(((java.lang.String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("PeriodPlannedQtyInProdnUnit") ) {
                final Object value = values.remove("PeriodPlannedQtyInProdnUnit");
                if( (value == null) || (!value.equals(getPeriodPlannedQtyInProdnUnit())) ) {
                    setPeriodPlannedQtyInProdnUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_UsageObject") ) {
                final Object value = (values).remove("_UsageObject");
                if( value instanceof Map ) {
                    if( to_UsageObject == null ) {
                        to_UsageObject = new FixedAssetUsageObject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_UsageObject.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return FixedAssetUsageObjectForUoPDepreciationService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_UsageObject != null ) {
            (values).put("_UsageObject", to_UsageObject);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>FixedAssetUsageObject</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_UsageObject</b>.
     * <p>
     * If the navigation property for an entity <b>FixedAssetUsageObjectPeriod</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_UsageObject</b> is already loaded, the result will contain
     *         the <b>FixedAssetUsageObject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<FixedAssetUsageObject> getUsageObjectIfPresent()
    {
        return Option.of(to_UsageObject);
    }

    /**
     * Overwrites the associated <b>FixedAssetUsageObject</b> entity for the loaded navigation property
     * <b>_UsageObject</b>.
     * 
     * @param value
     *            New <b>FixedAssetUsageObject</b> entity.
     */
    public void setUsageObject( final FixedAssetUsageObject value )
    {
        to_UsageObject = value;
    }

    /**
     * Helper class to allow for fluent creation of FixedAssetUsageObjectPeriod instances.
     * 
     */
    public final static class FixedAssetUsageObjectPeriodBuilder
    {

        private FixedAssetUsageObject to_UsageObject;

        private FixedAssetUsageObjectPeriod.FixedAssetUsageObjectPeriodBuilder to_UsageObject(
            final FixedAssetUsageObject value )
        {
            to_UsageObject = value;
            return this;
        }

        /**
         * Navigation property <b>_UsageObject</b> for <b>FixedAssetUsageObjectPeriod</b> to single
         * <b>FixedAssetUsageObject</b>.
         * 
         * @param value
         *            The FixedAssetUsageObject to build this FixedAssetUsageObjectPeriod with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public FixedAssetUsageObjectPeriod.FixedAssetUsageObjectPeriodBuilder usageObject(
            final FixedAssetUsageObject value )
        {
            return to_UsageObject(value);
        }

    }

}
