/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.handlingunit;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmComplex;
import com.sap.cloud.sdk.result.ElementName;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>D_HandlingUnitMoveResult</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class D_HandlingUnitMoveResult extends VdmComplex<D_HandlingUnitMoveResult>
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_handlingunit.v0001.D_HandlingUnitMoveResult";
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return The createdByUser contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> CREATED_BY_USER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "CreatedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @return The creationDateTime contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CreationDateTime" )
    private OffsetDateTime creationDateTime;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.DateTime<D_HandlingUnitMoveResult> CREATION_DATE_TIME =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.DateTime<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     * 
     * @return The grossWeight contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "GrossWeight" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal grossWeight;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.NumericDecimal<D_HandlingUnitMoveResult> GROSS_WEIGHT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.NumericDecimal<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "GrossWeight");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitCharUUID</b>
     * </p>
     * 
     * @return The handlingUnitCharUUID contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "HandlingUnitCharUUID" )
    private UUID handlingUnitCharUUID;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Guid<D_HandlingUnitMoveResult> HANDLING_UNIT_CHAR_UUID =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Guid<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "HandlingUnitCharUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalID</b>
     * </p>
     * 
     * @return The handlingUnitExternalID contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "HandlingUnitExternalID" )
    private java.lang.String handlingUnitExternalID;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> HANDLING_UNIT_EXTERNAL_ID =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "HandlingUnitExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInternalStatus</b>
     * </p>
     * 
     * @return The handlingUnitInternalStatus contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "HandlingUnitInternalStatus" )
    private java.lang.String handlingUnitInternalStatus;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> HANDLING_UNIT_INTERNAL_STATUS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "HandlingUnitInternalStatus");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitReferenceDocument</b>
     * </p>
     * 
     * @return The handlingUnitReferenceDocument contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "HandlingUnitReferenceDocument" )
    private java.lang.String handlingUnitReferenceDocument;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> HANDLING_UNIT_REFERENCE_DOCUMENT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "HandlingUnitReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterial</b>
     * </p>
     * 
     * @return The packagingMaterial contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "PackagingMaterial" )
    private java.lang.String packagingMaterial;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> PACKAGING_MATERIAL =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "PackagingMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialType</b>
     * </p>
     * 
     * @return The packagingMaterialType contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "PackagingMaterialType" )
    private java.lang.String packagingMaterialType;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> PACKAGING_MATERIAL_TYPE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "PackagingMaterialType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ParentHandlingUnitNumber</b>
     * </p>
     * 
     * @return The parentHandlingUnitNumber contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "ParentHandlingUnitNumber" )
    private java.lang.String parentHandlingUnitNumber;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> PARENT_HANDLING_UNIT_NUMBER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "ParentHandlingUnitNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return The plant contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> PLANT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ReceivingStorageBin</b>
     * </p>
     * 
     * @return The receivingStorageBin contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "ReceivingStorageBin" )
    private java.lang.String receivingStorageBin;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> RECEIVING_STORAGE_BIN =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "ReceivingStorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReceivingStorageLocation</b>
     * </p>
     * 
     * @return The receivingStorageLocation contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "ReceivingStorageLocation" )
    private java.lang.String receivingStorageLocation;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> RECEIVING_STORAGE_LOCATION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "ReceivingStorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     * 
     * @return The warehouse contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "Warehouse" )
    private java.lang.String warehouse;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> WAREHOUSE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     * 
     * @return The weightUnit contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "WeightUnit" )
    private java.lang.String weightUnit;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult> WEIGHT_UNIT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_HandlingUnitMoveResult>(
            D_HandlingUnitMoveResult.class,
            "WeightUnit");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<D_HandlingUnitMoveResult> getType()
    {
        return D_HandlingUnitMoveResult.class;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("GrossWeight", getGrossWeight());
        values.put("HandlingUnitCharUUID", getHandlingUnitCharUUID());
        values.put("HandlingUnitExternalID", getHandlingUnitExternalID());
        values.put("HandlingUnitInternalStatus", getHandlingUnitInternalStatus());
        values.put("HandlingUnitReferenceDocument", getHandlingUnitReferenceDocument());
        values.put("PackagingMaterial", getPackagingMaterial());
        values.put("PackagingMaterialType", getPackagingMaterialType());
        values.put("ParentHandlingUnitNumber", getParentHandlingUnitNumber());
        values.put("Plant", getPlant());
        values.put("ReceivingStorageBin", getReceivingStorageBin());
        values.put("ReceivingStorageLocation", getReceivingStorageLocation());
        values.put("Warehouse", getWarehouse());
        values.put("WeightUnit", getWeightUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("GrossWeight") ) {
                final Object value = values.remove("GrossWeight");
                if( (value == null) || (!value.equals(getGrossWeight())) ) {
                    setGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitCharUUID") ) {
                final Object value = values.remove("HandlingUnitCharUUID");
                if( (value == null) || (!value.equals(getHandlingUnitCharUUID())) ) {
                    setHandlingUnitCharUUID(((UUID) value));
                }
            }
            if( values.containsKey("HandlingUnitExternalID") ) {
                final Object value = values.remove("HandlingUnitExternalID");
                if( (value == null) || (!value.equals(getHandlingUnitExternalID())) ) {
                    setHandlingUnitExternalID(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitInternalStatus") ) {
                final Object value = values.remove("HandlingUnitInternalStatus");
                if( (value == null) || (!value.equals(getHandlingUnitInternalStatus())) ) {
                    setHandlingUnitInternalStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitReferenceDocument") ) {
                final Object value = values.remove("HandlingUnitReferenceDocument");
                if( (value == null) || (!value.equals(getHandlingUnitReferenceDocument())) ) {
                    setHandlingUnitReferenceDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("PackagingMaterial") ) {
                final Object value = values.remove("PackagingMaterial");
                if( (value == null) || (!value.equals(getPackagingMaterial())) ) {
                    setPackagingMaterial(((java.lang.String) value));
                }
            }
            if( values.containsKey("PackagingMaterialType") ) {
                final Object value = values.remove("PackagingMaterialType");
                if( (value == null) || (!value.equals(getPackagingMaterialType())) ) {
                    setPackagingMaterialType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ParentHandlingUnitNumber") ) {
                final Object value = values.remove("ParentHandlingUnitNumber");
                if( (value == null) || (!value.equals(getParentHandlingUnitNumber())) ) {
                    setParentHandlingUnitNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("ReceivingStorageBin") ) {
                final Object value = values.remove("ReceivingStorageBin");
                if( (value == null) || (!value.equals(getReceivingStorageBin())) ) {
                    setReceivingStorageBin(((java.lang.String) value));
                }
            }
            if( values.containsKey("ReceivingStorageLocation") ) {
                final Object value = values.remove("ReceivingStorageLocation");
                if( (value == null) || (!value.equals(getReceivingStorageLocation())) ) {
                    setReceivingStorageLocation(((java.lang.String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((java.lang.String) value));
                }
            }
            if( values.containsKey("WeightUnit") ) {
                final Object value = values.remove("WeightUnit");
                if( (value == null) || (!value.equals(getWeightUnit())) ) {
                    setWeightUnit(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        return entityKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            The createdByUser to set.
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @param creationDateTime
     *            The creationDateTime to set.
     */
    public void setCreationDateTime( @Nullable final OffsetDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     * 
     * @param grossWeight
     *            The grossWeight to set.
     */
    public void setGrossWeight( @Nullable final BigDecimal grossWeight )
    {
        rememberChangedField("GrossWeight", this.grossWeight);
        this.grossWeight = grossWeight;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitCharUUID</b>
     * </p>
     * 
     * @param handlingUnitCharUUID
     *            The handlingUnitCharUUID to set.
     */
    public void setHandlingUnitCharUUID( @Nullable final UUID handlingUnitCharUUID )
    {
        rememberChangedField("HandlingUnitCharUUID", this.handlingUnitCharUUID);
        this.handlingUnitCharUUID = handlingUnitCharUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalID</b>
     * </p>
     * 
     * @param handlingUnitExternalID
     *            The handlingUnitExternalID to set.
     */
    public void setHandlingUnitExternalID( @Nullable final java.lang.String handlingUnitExternalID )
    {
        rememberChangedField("HandlingUnitExternalID", this.handlingUnitExternalID);
        this.handlingUnitExternalID = handlingUnitExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitInternalStatus</b>
     * </p>
     * 
     * @param handlingUnitInternalStatus
     *            The handlingUnitInternalStatus to set.
     */
    public void setHandlingUnitInternalStatus( @Nullable final java.lang.String handlingUnitInternalStatus )
    {
        rememberChangedField("HandlingUnitInternalStatus", this.handlingUnitInternalStatus);
        this.handlingUnitInternalStatus = handlingUnitInternalStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitReferenceDocument</b>
     * </p>
     * 
     * @param handlingUnitReferenceDocument
     *            The handlingUnitReferenceDocument to set.
     */
    public void setHandlingUnitReferenceDocument( @Nullable final java.lang.String handlingUnitReferenceDocument )
    {
        rememberChangedField("HandlingUnitReferenceDocument", this.handlingUnitReferenceDocument);
        this.handlingUnitReferenceDocument = handlingUnitReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterial</b>
     * </p>
     * 
     * @param packagingMaterial
     *            The packagingMaterial to set.
     */
    public void setPackagingMaterial( @Nullable final java.lang.String packagingMaterial )
    {
        rememberChangedField("PackagingMaterial", this.packagingMaterial);
        this.packagingMaterial = packagingMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialType</b>
     * </p>
     * 
     * @param packagingMaterialType
     *            The packagingMaterialType to set.
     */
    public void setPackagingMaterialType( @Nullable final java.lang.String packagingMaterialType )
    {
        rememberChangedField("PackagingMaterialType", this.packagingMaterialType);
        this.packagingMaterialType = packagingMaterialType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ParentHandlingUnitNumber</b>
     * </p>
     * 
     * @param parentHandlingUnitNumber
     *            The parentHandlingUnitNumber to set.
     */
    public void setParentHandlingUnitNumber( @Nullable final java.lang.String parentHandlingUnitNumber )
    {
        rememberChangedField("ParentHandlingUnitNumber", this.parentHandlingUnitNumber);
        this.parentHandlingUnitNumber = parentHandlingUnitNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            The plant to set.
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ReceivingStorageBin</b>
     * </p>
     * 
     * @param receivingStorageBin
     *            The receivingStorageBin to set.
     */
    public void setReceivingStorageBin( @Nullable final java.lang.String receivingStorageBin )
    {
        rememberChangedField("ReceivingStorageBin", this.receivingStorageBin);
        this.receivingStorageBin = receivingStorageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReceivingStorageLocation</b>
     * </p>
     * 
     * @param receivingStorageLocation
     *            The receivingStorageLocation to set.
     */
    public void setReceivingStorageLocation( @Nullable final java.lang.String receivingStorageLocation )
    {
        rememberChangedField("ReceivingStorageLocation", this.receivingStorageLocation);
        this.receivingStorageLocation = receivingStorageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     * 
     * @param warehouse
     *            The warehouse to set.
     */
    public void setWarehouse( @Nullable final java.lang.String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     * 
     * @param weightUnit
     *            The weightUnit to set.
     */
    public void setWeightUnit( @Nullable final java.lang.String weightUnit )
    {
        rememberChangedField("WeightUnit", this.weightUnit);
        this.weightUnit = weightUnit;
    }

}
