/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.handlingunit;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.HandlingUnitService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Handling Unit
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>HandlingUnitType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class HandlingUnit extends VdmEntity<HandlingUnit> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_handlingunit.v0001.HandlingUnitType";
    /**
     * Selector for all available fields of HandlingUnit.
     * 
     */
    public final static SimpleProperty<HandlingUnit> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalID</b>
     * </p>
     * 
     * @return External Handling Unit Identification
     */
    @Nullable
    @ElementName( "HandlingUnitExternalID" )
    private java.lang.String handlingUnitExternalID;
    public final static SimpleProperty.String<HandlingUnit> HANDLING_UNIT_EXTERNAL_ID =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "HandlingUnitExternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     * 
     * @return Warehouse Number/Warehouse Complex
     */
    @Nullable
    @ElementName( "Warehouse" )
    private java.lang.String warehouse;
    public final static SimpleProperty.String<HandlingUnit> WAREHOUSE =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "Warehouse");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterial</b>
     * </p>
     * 
     * @return Packaging Materials
     */
    @Nullable
    @ElementName( "PackagingMaterial" )
    private java.lang.String packagingMaterial;
    public final static SimpleProperty.String<HandlingUnit> PACKAGING_MATERIAL =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "PackagingMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialType</b>
     * </p>
     * 
     * @return Packaging Material Type
     */
    @Nullable
    @ElementName( "PackagingMaterialType" )
    private java.lang.String packagingMaterialType;
    public final static SimpleProperty.String<HandlingUnit> PACKAGING_MATERIAL_TYPE =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "PackagingMaterialType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<HandlingUnit> PLANT =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     * 
     * @return Storage Location
     */
    @Nullable
    @ElementName( "StorageLocation" )
    private java.lang.String storageLocation;
    public final static SimpleProperty.String<HandlingUnit> STORAGE_LOCATION =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     * 
     * @return Shipping Point / Receiving Point
     */
    @Nullable
    @ElementName( "ShippingPoint" )
    private java.lang.String shippingPoint;
    public final static SimpleProperty.String<HandlingUnit> SHIPPING_POINT =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ParentHandlingUnitNumber</b>
     * </p>
     * 
     * @return External Handling Unit Identification
     */
    @Nullable
    @ElementName( "ParentHandlingUnitNumber" )
    private java.lang.String parentHandlingUnitNumber;
    public final static SimpleProperty.String<HandlingUnit> PARENT_HANDLING_UNIT_NUMBER =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "ParentHandlingUnitNumber");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     * 
     * @return The grossWeight contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "GrossWeight" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal grossWeight;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> GROSS_WEIGHT =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "GrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetWeight</b>
     * </p>
     * 
     * @return The netWeight contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "NetWeight" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal netWeight;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> NET_WEIGHT =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "NetWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitMaxWeight</b>
     * </p>
     * 
     * @return The handlingUnitMaxWeight contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "HandlingUnitMaxWeight" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal handlingUnitMaxWeight;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> HANDLING_UNIT_MAX_WEIGHT =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "HandlingUnitMaxWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     * 
     * @return Unit of Weight
     */
    @Nullable
    @ElementName( "WeightUnit" )
    private java.lang.String weightUnit;
    public final static SimpleProperty.String<HandlingUnit> WEIGHT_UNIT =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "WeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeight</b>
     * </p>
     * 
     * @return The handlingUnitTareWeight contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "HandlingUnitTareWeight" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal handlingUnitTareWeight;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> HANDLING_UNIT_TARE_WEIGHT =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "HandlingUnitTareWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeightUnit</b>
     * </p>
     * 
     * @return Unit of Weight
     */
    @Nullable
    @ElementName( "HandlingUnitTareWeightUnit" )
    private java.lang.String handlingUnitTareWeightUnit;
    public final static SimpleProperty.String<HandlingUnit> HANDLING_UNIT_TARE_WEIGHT_UNIT =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "HandlingUnitTareWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossVolume</b>
     * </p>
     * 
     * @return The grossVolume contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "GrossVolume" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal grossVolume;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> GROSS_VOLUME =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "GrossVolume");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNetVolume</b>
     * </p>
     * 
     * @return The handlingUnitNetVolume contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "HandlingUnitNetVolume" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal handlingUnitNetVolume;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> HANDLING_UNIT_NET_VOLUME =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "HandlingUnitNetVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     * 
     * @return Volume Unit
     */
    @Nullable
    @ElementName( "VolumeUnit" )
    private java.lang.String volumeUnit;
    public final static SimpleProperty.String<HandlingUnit> VOLUME_UNIT =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "VolumeUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolume</b>
     * </p>
     * 
     * @return The handlingUnitTareVolume contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "HandlingUnitTareVolume" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal handlingUnitTareVolume;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> HANDLING_UNIT_TARE_VOLUME =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "HandlingUnitTareVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolumeUnit</b>
     * </p>
     * 
     * @return Volume Unit
     */
    @Nullable
    @ElementName( "HandlingUnitTareVolumeUnit" )
    private java.lang.String handlingUnitTareVolumeUnit;
    public final static SimpleProperty.String<HandlingUnit> HANDLING_UNIT_TARE_VOLUME_UNIT =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "HandlingUnitTareVolumeUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLength</b>
     * </p>
     * 
     * @return The handlingUnitLength contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "HandlingUnitLength" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal handlingUnitLength;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> HANDLING_UNIT_LENGTH =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "HandlingUnitLength");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWidth</b>
     * </p>
     * 
     * @return The handlingUnitWidth contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "HandlingUnitWidth" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal handlingUnitWidth;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> HANDLING_UNIT_WIDTH =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "HandlingUnitWidth");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitHeight</b>
     * </p>
     * 
     * @return The handlingUnitHeight contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "HandlingUnitHeight" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal handlingUnitHeight;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> HANDLING_UNIT_HEIGHT =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "HandlingUnitHeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureDimension</b>
     * </p>
     * 
     * @return Unit of Dimension for Length/Width/Height
     */
    @Nullable
    @ElementName( "UnitOfMeasureDimension" )
    private java.lang.String unitOfMeasureDimension;
    public final static SimpleProperty.String<HandlingUnit> UNIT_OF_MEASURE_DIMENSION =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "UnitOfMeasureDimension");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitReferenceDocument</b>
     * </p>
     * 
     * @return Key for Object to Which the Handling Unit is Assigned
     */
    @Nullable
    @ElementName( "HandlingUnitReferenceDocument" )
    private java.lang.String handlingUnitReferenceDocument;
    public final static SimpleProperty.String<HandlingUnit> HANDLING_UNIT_REFERENCE_DOCUMENT =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "HandlingUnitReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitRefDocType</b>
     * </p>
     * 
     * @return Packing Object
     */
    @Nullable
    @ElementName( "HandlingUnitRefDocType" )
    private java.lang.String handlingUnitRefDocType;
    public final static SimpleProperty.String<HandlingUnit> HANDLING_UNIT_REF_DOC_TYPE =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "HandlingUnitRefDocType");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstruction</b>
     * </p>
     * 
     * @return Text string 22 characters
     */
    @Nullable
    @ElementName( "PackingInstruction" )
    private java.lang.String packingInstruction;
    public final static SimpleProperty.String<HandlingUnit> PACKING_INSTRUCTION =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "PackingInstruction");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitSecondExternalId</b>
     * </p>
     * 
     * @return Handling Unit&apos;s 2nd External Identification
     */
    @Nullable
    @ElementName( "HandlingUnitSecondExternalId" )
    private java.lang.String handlingUnitSecondExternalId;
    public final static SimpleProperty.String<HandlingUnit> HANDLING_UNIT_SECOND_EXTERNAL_ID =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "HandlingUnitSecondExternalId");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Name of Person Who Created Object
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<HandlingUnit> CREATED_BY_USER =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 15
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @return The creationDateTime contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CreationDateTime" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal creationDateTime;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> CREATION_DATE_TIME =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Name of Person who Changed Object
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<HandlingUnit> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 15
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @return The lastChangeDateTime contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "LastChangeDateTime" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal lastChangeDateTime;
    public final static SimpleProperty.NumericDecimal<HandlingUnit> LAST_CHANGE_DATE_TIME =
        new SimpleProperty.NumericDecimal<HandlingUnit>(HandlingUnit.class, "LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     * 
     * @return Storage Type
     */
    @Nullable
    @ElementName( "StorageType" )
    private java.lang.String storageType;
    public final static SimpleProperty.String<HandlingUnit> STORAGE_TYPE =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "StorageType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageSection</b>
     * </p>
     * 
     * @return Storage Section
     */
    @Nullable
    @ElementName( "StorageSection" )
    private java.lang.String storageSection;
    public final static SimpleProperty.String<HandlingUnit> STORAGE_SECTION =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "StorageSection");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     * 
     * @return Storage Bin
     */
    @Nullable
    @ElementName( "StorageBin" )
    private java.lang.String storageBin;
    public final static SimpleProperty.String<HandlingUnit> STORAGE_BIN =
        new SimpleProperty.String<HandlingUnit>(HandlingUnit.class, "StorageBin");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<HandlingUnit, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<HandlingUnit, SAP__Message>(
            HandlingUnit.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_HandlingUnitItem</b> for <b>HandlingUnit</b> to multiple <b>HandlingUnitItem</b>.
     * 
     */
    @ElementName( "_HandlingUnitItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<HandlingUnitItem> to_HandlingUnitItem;
    /**
     * Use with available request builders to apply the <b>_HandlingUnitItem</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<HandlingUnit, HandlingUnitItem> TO__HANDLING_UNIT_ITEM =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<HandlingUnit, HandlingUnitItem>(
            HandlingUnit.class,
            "_HandlingUnitItem",
            HandlingUnitItem.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<HandlingUnit> getType()
    {
        return HandlingUnit.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalID</b>
     * </p>
     * 
     * @param handlingUnitExternalID
     *            External Handling Unit Identification
     */
    public void setHandlingUnitExternalID( @Nullable final java.lang.String handlingUnitExternalID )
    {
        rememberChangedField("HandlingUnitExternalID", this.handlingUnitExternalID);
        this.handlingUnitExternalID = handlingUnitExternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     * 
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final java.lang.String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterial</b>
     * </p>
     * 
     * @param packagingMaterial
     *            Packaging Materials
     */
    public void setPackagingMaterial( @Nullable final java.lang.String packagingMaterial )
    {
        rememberChangedField("PackagingMaterial", this.packagingMaterial);
        this.packagingMaterial = packagingMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PackagingMaterialType</b>
     * </p>
     * 
     * @param packagingMaterialType
     *            Packaging Material Type
     */
    public void setPackagingMaterialType( @Nullable final java.lang.String packagingMaterialType )
    {
        rememberChangedField("PackagingMaterialType", this.packagingMaterialType);
        this.packagingMaterialType = packagingMaterialType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     * 
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final java.lang.String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     * 
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final java.lang.String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ParentHandlingUnitNumber</b>
     * </p>
     * 
     * @param parentHandlingUnitNumber
     *            External Handling Unit Identification
     */
    public void setParentHandlingUnitNumber( @Nullable final java.lang.String parentHandlingUnitNumber )
    {
        rememberChangedField("ParentHandlingUnitNumber", this.parentHandlingUnitNumber);
        this.parentHandlingUnitNumber = parentHandlingUnitNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     * 
     * @param grossWeight
     *            The grossWeight to set.
     */
    public void setGrossWeight( @Nullable final BigDecimal grossWeight )
    {
        rememberChangedField("GrossWeight", this.grossWeight);
        this.grossWeight = grossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetWeight</b>
     * </p>
     * 
     * @param netWeight
     *            The netWeight to set.
     */
    public void setNetWeight( @Nullable final BigDecimal netWeight )
    {
        rememberChangedField("NetWeight", this.netWeight);
        this.netWeight = netWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitMaxWeight</b>
     * </p>
     * 
     * @param handlingUnitMaxWeight
     *            The handlingUnitMaxWeight to set.
     */
    public void setHandlingUnitMaxWeight( @Nullable final BigDecimal handlingUnitMaxWeight )
    {
        rememberChangedField("HandlingUnitMaxWeight", this.handlingUnitMaxWeight);
        this.handlingUnitMaxWeight = handlingUnitMaxWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     * 
     * @param weightUnit
     *            Unit of Weight
     */
    public void setWeightUnit( @Nullable final java.lang.String weightUnit )
    {
        rememberChangedField("WeightUnit", this.weightUnit);
        this.weightUnit = weightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeight</b>
     * </p>
     * 
     * @param handlingUnitTareWeight
     *            The handlingUnitTareWeight to set.
     */
    public void setHandlingUnitTareWeight( @Nullable final BigDecimal handlingUnitTareWeight )
    {
        rememberChangedField("HandlingUnitTareWeight", this.handlingUnitTareWeight);
        this.handlingUnitTareWeight = handlingUnitTareWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareWeightUnit</b>
     * </p>
     * 
     * @param handlingUnitTareWeightUnit
     *            Unit of Weight
     */
    public void setHandlingUnitTareWeightUnit( @Nullable final java.lang.String handlingUnitTareWeightUnit )
    {
        rememberChangedField("HandlingUnitTareWeightUnit", this.handlingUnitTareWeightUnit);
        this.handlingUnitTareWeightUnit = handlingUnitTareWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossVolume</b>
     * </p>
     * 
     * @param grossVolume
     *            The grossVolume to set.
     */
    public void setGrossVolume( @Nullable final BigDecimal grossVolume )
    {
        rememberChangedField("GrossVolume", this.grossVolume);
        this.grossVolume = grossVolume;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNetVolume</b>
     * </p>
     * 
     * @param handlingUnitNetVolume
     *            The handlingUnitNetVolume to set.
     */
    public void setHandlingUnitNetVolume( @Nullable final BigDecimal handlingUnitNetVolume )
    {
        rememberChangedField("HandlingUnitNetVolume", this.handlingUnitNetVolume);
        this.handlingUnitNetVolume = handlingUnitNetVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     * 
     * @param volumeUnit
     *            Volume Unit
     */
    public void setVolumeUnit( @Nullable final java.lang.String volumeUnit )
    {
        rememberChangedField("VolumeUnit", this.volumeUnit);
        this.volumeUnit = volumeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolume</b>
     * </p>
     * 
     * @param handlingUnitTareVolume
     *            The handlingUnitTareVolume to set.
     */
    public void setHandlingUnitTareVolume( @Nullable final BigDecimal handlingUnitTareVolume )
    {
        rememberChangedField("HandlingUnitTareVolume", this.handlingUnitTareVolume);
        this.handlingUnitTareVolume = handlingUnitTareVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTareVolumeUnit</b>
     * </p>
     * 
     * @param handlingUnitTareVolumeUnit
     *            Volume Unit
     */
    public void setHandlingUnitTareVolumeUnit( @Nullable final java.lang.String handlingUnitTareVolumeUnit )
    {
        rememberChangedField("HandlingUnitTareVolumeUnit", this.handlingUnitTareVolumeUnit);
        this.handlingUnitTareVolumeUnit = handlingUnitTareVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitLength</b>
     * </p>
     * 
     * @param handlingUnitLength
     *            The handlingUnitLength to set.
     */
    public void setHandlingUnitLength( @Nullable final BigDecimal handlingUnitLength )
    {
        rememberChangedField("HandlingUnitLength", this.handlingUnitLength);
        this.handlingUnitLength = handlingUnitLength;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitWidth</b>
     * </p>
     * 
     * @param handlingUnitWidth
     *            The handlingUnitWidth to set.
     */
    public void setHandlingUnitWidth( @Nullable final BigDecimal handlingUnitWidth )
    {
        rememberChangedField("HandlingUnitWidth", this.handlingUnitWidth);
        this.handlingUnitWidth = handlingUnitWidth;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitHeight</b>
     * </p>
     * 
     * @param handlingUnitHeight
     *            The handlingUnitHeight to set.
     */
    public void setHandlingUnitHeight( @Nullable final BigDecimal handlingUnitHeight )
    {
        rememberChangedField("HandlingUnitHeight", this.handlingUnitHeight);
        this.handlingUnitHeight = handlingUnitHeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureDimension</b>
     * </p>
     * 
     * @param unitOfMeasureDimension
     *            Unit of Dimension for Length/Width/Height
     */
    public void setUnitOfMeasureDimension( @Nullable final java.lang.String unitOfMeasureDimension )
    {
        rememberChangedField("UnitOfMeasureDimension", this.unitOfMeasureDimension);
        this.unitOfMeasureDimension = unitOfMeasureDimension;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitReferenceDocument</b>
     * </p>
     * 
     * @param handlingUnitReferenceDocument
     *            Key for Object to Which the Handling Unit is Assigned
     */
    public void setHandlingUnitReferenceDocument( @Nullable final java.lang.String handlingUnitReferenceDocument )
    {
        rememberChangedField("HandlingUnitReferenceDocument", this.handlingUnitReferenceDocument);
        this.handlingUnitReferenceDocument = handlingUnitReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitRefDocType</b>
     * </p>
     * 
     * @param handlingUnitRefDocType
     *            Packing Object
     */
    public void setHandlingUnitRefDocType( @Nullable final java.lang.String handlingUnitRefDocType )
    {
        rememberChangedField("HandlingUnitRefDocType", this.handlingUnitRefDocType);
        this.handlingUnitRefDocType = handlingUnitRefDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>PackingInstruction</b>
     * </p>
     * 
     * @param packingInstruction
     *            Text string 22 characters
     */
    public void setPackingInstruction( @Nullable final java.lang.String packingInstruction )
    {
        rememberChangedField("PackingInstruction", this.packingInstruction);
        this.packingInstruction = packingInstruction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitSecondExternalId</b>
     * </p>
     * 
     * @param handlingUnitSecondExternalId
     *            Handling Unit&apos;s 2nd External Identification
     */
    public void setHandlingUnitSecondExternalId( @Nullable final java.lang.String handlingUnitSecondExternalId )
    {
        rememberChangedField("HandlingUnitSecondExternalId", this.handlingUnitSecondExternalId);
        this.handlingUnitSecondExternalId = handlingUnitSecondExternalId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Name of Person Who Created Object
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 15
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @param creationDateTime
     *            The creationDateTime to set.
     */
    public void setCreationDateTime( @Nullable final BigDecimal creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Name of Person who Changed Object
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 15
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @param lastChangeDateTime
     *            The lastChangeDateTime to set.
     */
    public void setLastChangeDateTime( @Nullable final BigDecimal lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     * 
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final java.lang.String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageSection</b>
     * </p>
     * 
     * @param storageSection
     *            Storage Section
     */
    public void setStorageSection( @Nullable final java.lang.String storageSection )
    {
        rememberChangedField("StorageSection", this.storageSection);
        this.storageSection = storageSection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     * 
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final java.lang.String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "HandlingUnit";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("HandlingUnitExternalID", getHandlingUnitExternalID());
        entityKey.addKeyProperty("Warehouse", getWarehouse());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("HandlingUnitExternalID", getHandlingUnitExternalID());
        values.put("Warehouse", getWarehouse());
        values.put("PackagingMaterial", getPackagingMaterial());
        values.put("PackagingMaterialType", getPackagingMaterialType());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("ShippingPoint", getShippingPoint());
        values.put("ParentHandlingUnitNumber", getParentHandlingUnitNumber());
        values.put("GrossWeight", getGrossWeight());
        values.put("NetWeight", getNetWeight());
        values.put("HandlingUnitMaxWeight", getHandlingUnitMaxWeight());
        values.put("WeightUnit", getWeightUnit());
        values.put("HandlingUnitTareWeight", getHandlingUnitTareWeight());
        values.put("HandlingUnitTareWeightUnit", getHandlingUnitTareWeightUnit());
        values.put("GrossVolume", getGrossVolume());
        values.put("HandlingUnitNetVolume", getHandlingUnitNetVolume());
        values.put("VolumeUnit", getVolumeUnit());
        values.put("HandlingUnitTareVolume", getHandlingUnitTareVolume());
        values.put("HandlingUnitTareVolumeUnit", getHandlingUnitTareVolumeUnit());
        values.put("HandlingUnitLength", getHandlingUnitLength());
        values.put("HandlingUnitWidth", getHandlingUnitWidth());
        values.put("HandlingUnitHeight", getHandlingUnitHeight());
        values.put("UnitOfMeasureDimension", getUnitOfMeasureDimension());
        values.put("HandlingUnitReferenceDocument", getHandlingUnitReferenceDocument());
        values.put("HandlingUnitRefDocType", getHandlingUnitRefDocType());
        values.put("PackingInstruction", getPackingInstruction());
        values.put("HandlingUnitSecondExternalId", getHandlingUnitSecondExternalId());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("StorageType", getStorageType());
        values.put("StorageSection", getStorageSection());
        values.put("StorageBin", getStorageBin());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("HandlingUnitExternalID") ) {
                final Object value = values.remove("HandlingUnitExternalID");
                if( (value == null) || (!value.equals(getHandlingUnitExternalID())) ) {
                    setHandlingUnitExternalID(((java.lang.String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((java.lang.String) value));
                }
            }
            if( values.containsKey("PackagingMaterial") ) {
                final Object value = values.remove("PackagingMaterial");
                if( (value == null) || (!value.equals(getPackagingMaterial())) ) {
                    setPackagingMaterial(((java.lang.String) value));
                }
            }
            if( values.containsKey("PackagingMaterialType") ) {
                final Object value = values.remove("PackagingMaterialType");
                if( (value == null) || (!value.equals(getPackagingMaterialType())) ) {
                    setPackagingMaterialType(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((java.lang.String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((java.lang.String) value));
                }
            }
            if( values.containsKey("ParentHandlingUnitNumber") ) {
                final Object value = values.remove("ParentHandlingUnitNumber");
                if( (value == null) || (!value.equals(getParentHandlingUnitNumber())) ) {
                    setParentHandlingUnitNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("GrossWeight") ) {
                final Object value = values.remove("GrossWeight");
                if( (value == null) || (!value.equals(getGrossWeight())) ) {
                    setGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetWeight") ) {
                final Object value = values.remove("NetWeight");
                if( (value == null) || (!value.equals(getNetWeight())) ) {
                    setNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitMaxWeight") ) {
                final Object value = values.remove("HandlingUnitMaxWeight");
                if( (value == null) || (!value.equals(getHandlingUnitMaxWeight())) ) {
                    setHandlingUnitMaxWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("WeightUnit") ) {
                final Object value = values.remove("WeightUnit");
                if( (value == null) || (!value.equals(getWeightUnit())) ) {
                    setWeightUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitTareWeight") ) {
                final Object value = values.remove("HandlingUnitTareWeight");
                if( (value == null) || (!value.equals(getHandlingUnitTareWeight())) ) {
                    setHandlingUnitTareWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitTareWeightUnit") ) {
                final Object value = values.remove("HandlingUnitTareWeightUnit");
                if( (value == null) || (!value.equals(getHandlingUnitTareWeightUnit())) ) {
                    setHandlingUnitTareWeightUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("GrossVolume") ) {
                final Object value = values.remove("GrossVolume");
                if( (value == null) || (!value.equals(getGrossVolume())) ) {
                    setGrossVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitNetVolume") ) {
                final Object value = values.remove("HandlingUnitNetVolume");
                if( (value == null) || (!value.equals(getHandlingUnitNetVolume())) ) {
                    setHandlingUnitNetVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("VolumeUnit") ) {
                final Object value = values.remove("VolumeUnit");
                if( (value == null) || (!value.equals(getVolumeUnit())) ) {
                    setVolumeUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitTareVolume") ) {
                final Object value = values.remove("HandlingUnitTareVolume");
                if( (value == null) || (!value.equals(getHandlingUnitTareVolume())) ) {
                    setHandlingUnitTareVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitTareVolumeUnit") ) {
                final Object value = values.remove("HandlingUnitTareVolumeUnit");
                if( (value == null) || (!value.equals(getHandlingUnitTareVolumeUnit())) ) {
                    setHandlingUnitTareVolumeUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitLength") ) {
                final Object value = values.remove("HandlingUnitLength");
                if( (value == null) || (!value.equals(getHandlingUnitLength())) ) {
                    setHandlingUnitLength(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitWidth") ) {
                final Object value = values.remove("HandlingUnitWidth");
                if( (value == null) || (!value.equals(getHandlingUnitWidth())) ) {
                    setHandlingUnitWidth(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitHeight") ) {
                final Object value = values.remove("HandlingUnitHeight");
                if( (value == null) || (!value.equals(getHandlingUnitHeight())) ) {
                    setHandlingUnitHeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitOfMeasureDimension") ) {
                final Object value = values.remove("UnitOfMeasureDimension");
                if( (value == null) || (!value.equals(getUnitOfMeasureDimension())) ) {
                    setUnitOfMeasureDimension(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitReferenceDocument") ) {
                final Object value = values.remove("HandlingUnitReferenceDocument");
                if( (value == null) || (!value.equals(getHandlingUnitReferenceDocument())) ) {
                    setHandlingUnitReferenceDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitRefDocType") ) {
                final Object value = values.remove("HandlingUnitRefDocType");
                if( (value == null) || (!value.equals(getHandlingUnitRefDocType())) ) {
                    setHandlingUnitRefDocType(((java.lang.String) value));
                }
            }
            if( values.containsKey("PackingInstruction") ) {
                final Object value = values.remove("PackingInstruction");
                if( (value == null) || (!value.equals(getPackingInstruction())) ) {
                    setPackingInstruction(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitSecondExternalId") ) {
                final Object value = values.remove("HandlingUnitSecondExternalId");
                if( (value == null) || (!value.equals(getHandlingUnitSecondExternalId())) ) {
                    setHandlingUnitSecondExternalId(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((java.lang.String) value));
                }
            }
            if( values.containsKey("StorageSection") ) {
                final Object value = values.remove("StorageSection");
                if( (value == null) || (!value.equals(getStorageSection())) ) {
                    setStorageSection(((java.lang.String) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_HandlingUnitItem") ) {
                final Object value = (values).remove("_HandlingUnitItem");
                if( value instanceof Iterable ) {
                    if( to_HandlingUnitItem == null ) {
                        to_HandlingUnitItem = Lists.newArrayList();
                    } else {
                        to_HandlingUnitItem = Lists.newArrayList(to_HandlingUnitItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        HandlingUnitItem entity;
                        if( to_HandlingUnitItem.size() > i ) {
                            entity = to_HandlingUnitItem.get(i);
                        } else {
                            entity = new HandlingUnitItem();
                            to_HandlingUnitItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return HandlingUnitService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_HandlingUnitItem != null ) {
            (values).put("_HandlingUnitItem", to_HandlingUnitItem);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>HandlingUnitItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_HandlingUnitItem</b>.
     * <p>
     * If the navigation property for an entity <b>HandlingUnit</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_HandlingUnitItem</b> is already loaded, the result will
     *         contain the <b>HandlingUnitItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<HandlingUnitItem>> getHandlingUnitItemIfPresent()
    {
        return Option.of(to_HandlingUnitItem);
    }

    /**
     * Overwrites the list of associated <b>HandlingUnitItem</b> entities for the loaded navigation property
     * <b>_HandlingUnitItem</b>.
     * <p>
     * If the navigation property <b>_HandlingUnitItem</b> of a queried <b>HandlingUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>HandlingUnitItem</b> entities.
     */
    public void setHandlingUnitItem( @Nonnull final List<HandlingUnitItem> value )
    {
        if( to_HandlingUnitItem == null ) {
            to_HandlingUnitItem = Lists.newArrayList();
        }
        to_HandlingUnitItem.clear();
        to_HandlingUnitItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>HandlingUnitItem</b> entities. This corresponds to the OData
     * navigation property <b>_HandlingUnitItem</b>.
     * <p>
     * If the navigation property <b>_HandlingUnitItem</b> of a queried <b>HandlingUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>HandlingUnitItem</b> entities.
     */
    public void addHandlingUnitItem( HandlingUnitItem... entity )
    {
        if( to_HandlingUnitItem == null ) {
            to_HandlingUnitItem = Lists.newArrayList();
        }
        to_HandlingUnitItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param handlingUnitGoodsMovementEvent
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HandlingUnitGoodsMovementEvent</b>
     *            </p>
     * @param handlingUnitExternalID
     *            Constraints: Not nullable, Maximum length: 20
     *            <p>
     *            Original parameter name from the Odata EDM: <b>HandlingUnitExternalID</b>
     *            </p>
     * @param receivingPlant
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReceivingPlant</b>
     *            </p>
     * @param receivingStorageBin
     *            Constraints: Not nullable, Maximum length: 18
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReceivingStorageBin</b>
     *            </p>
     * @param receivingStorageLocation
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReceivingStorageLocation</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<HandlingUnit, D_HandlingUnitMoveResult>
        moveHandlingUnits(
            @Nonnull final java.lang.String handlingUnitExternalID,
            @Nonnull final java.lang.String handlingUnitGoodsMovementEvent,
            @Nonnull final java.lang.String receivingPlant,
            @Nonnull final java.lang.String receivingStorageLocation,
            @Nonnull final java.lang.String receivingStorageBin )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("HandlingUnitExternalID", handlingUnitExternalID);
        parameters.put("HandlingUnitGoodsMovementEvent", handlingUnitGoodsMovementEvent);
        parameters.put("ReceivingPlant", receivingPlant);
        parameters.put("ReceivingStorageLocation", receivingStorageLocation);
        parameters.put("ReceivingStorageBin", receivingStorageBin);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<HandlingUnit, D_HandlingUnitMoveResult>(
            HandlingUnit.class,
            D_HandlingUnitMoveResult.class,
            "com.sap.gateway.srvd_a2x.api_handlingunit.v0001.MoveHandlingUnits",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of HandlingUnit instances.
     * 
     */
    public final static class HandlingUnitBuilder
    {

        private List<HandlingUnitItem> to_HandlingUnitItem = Lists.newArrayList();

        private HandlingUnit.HandlingUnitBuilder to_HandlingUnitItem( final List<HandlingUnitItem> value )
        {
            to_HandlingUnitItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_HandlingUnitItem</b> for <b>HandlingUnit</b> to multiple <b>HandlingUnitItem</b>.
         * 
         * @param value
         *            The HandlingUnitItems to build this HandlingUnit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public HandlingUnit.HandlingUnitBuilder handlingUnitItem( HandlingUnitItem... value )
        {
            return to_HandlingUnitItem(Lists.newArrayList(value));
        }

    }

}
