/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.handlingunit;

import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.HandlingUnitService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Handling Unit Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>HandlingUnitItemType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class HandlingUnitItem extends VdmEntity<HandlingUnitItem> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_handlingunit.v0001.HandlingUnitItemType";
    /**
     * Selector for all available fields of HandlingUnitItem.
     * 
     */
    public final static SimpleProperty<HandlingUnitItem> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalID</b>
     * </p>
     * 
     * @return External Handling Unit Identification
     */
    @Nullable
    @ElementName( "HandlingUnitExternalID" )
    private java.lang.String handlingUnitExternalID;
    public final static SimpleProperty.String<HandlingUnitItem> HANDLING_UNIT_EXTERNAL_ID =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "HandlingUnitExternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     * 
     * @return Warehouse Number/Warehouse Complex
     */
    @Nullable
    @ElementName( "Warehouse" )
    private java.lang.String warehouse;
    public final static SimpleProperty.String<HandlingUnitItem> WAREHOUSE =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "Warehouse");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>StockItemUUID</b>
     * </p>
     * 
     * @return GUID Stock Item
     */
    @Nullable
    @ElementName( "StockItemUUID" )
    private UUID stockItemUUID;
    public final static SimpleProperty.Guid<HandlingUnitItem> STOCK_ITEM_UUID =
        new SimpleProperty.Guid<HandlingUnitItem>(HandlingUnitItem.class, "StockItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitItem</b>
     * </p>
     * 
     * @return Handling Unit Item
     */
    @Nullable
    @ElementName( "HandlingUnitItem" )
    private java.lang.String handlingUnitItem;
    public final static SimpleProperty.String<HandlingUnitItem> HANDLING_UNIT_ITEM =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "HandlingUnitItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTypeOfContent</b>
     * </p>
     * 
     * @return Type of Handling-unit Item Content
     */
    @Nullable
    @ElementName( "HandlingUnitTypeOfContent" )
    private java.lang.String handlingUnitTypeOfContent;
    public final static SimpleProperty.String<HandlingUnitItem> HANDLING_UNIT_TYPE_OF_CONTENT =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "HandlingUnitTypeOfContent");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNestedExternalID</b>
     * </p>
     * 
     * @return Char 20
     */
    @Nullable
    @ElementName( "HandlingUnitNestedExternalID" )
    private java.lang.String handlingUnitNestedExternalID;
    public final static SimpleProperty.String<HandlingUnitItem> HANDLING_UNIT_NESTED_EXTERNAL_ID =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "HandlingUnitNestedExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitReferenceDocument</b>
     * </p>
     * 
     * @return Delivery
     */
    @Nullable
    @ElementName( "HandlingUnitReferenceDocument" )
    private java.lang.String handlingUnitReferenceDocument;
    public final static SimpleProperty.String<HandlingUnitItem> HANDLING_UNIT_REFERENCE_DOCUMENT =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "HandlingUnitReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitRefDocumentItem</b>
     * </p>
     * 
     * @return Character Field Length = 10
     */
    @Nullable
    @ElementName( "HandlingUnitRefDocumentItem" )
    private java.lang.String handlingUnitRefDocumentItem;
    public final static SimpleProperty.String<HandlingUnitItem> HANDLING_UNIT_REF_DOCUMENT_ITEM =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "HandlingUnitRefDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     * 
     * @return Material Number
     */
    @Nullable
    @ElementName( "Material" )
    private java.lang.String material;
    public final static SimpleProperty.String<HandlingUnitItem> MATERIAL =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "Material");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     * 
     * @return Batch Number
     */
    @Nullable
    @ElementName( "Batch" )
    private java.lang.String batch;
    public final static SimpleProperty.String<HandlingUnitItem> BATCH =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "Batch");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<HandlingUnitItem> PLANT =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     * 
     * @return Storage Location
     */
    @Nullable
    @ElementName( "StorageLocation" )
    private java.lang.String storageLocation;
    public final static SimpleProperty.String<HandlingUnitItem> STORAGE_LOCATION =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "StorageLocation");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantity</b>
     * </p>
     * 
     * @return The handlingUnitQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "HandlingUnitQuantity" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal handlingUnitQuantity;
    public final static SimpleProperty.NumericDecimal<HandlingUnitItem> HANDLING_UNIT_QUANTITY =
        new SimpleProperty.NumericDecimal<HandlingUnitItem>(HandlingUnitItem.class, "HandlingUnitQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantityUnit</b>
     * </p>
     * 
     * @return Base Unit of Measure of the Quantity to be Packed (VEMNG)
     */
    @Nullable
    @ElementName( "HandlingUnitQuantityUnit" )
    private java.lang.String handlingUnitQuantityUnit;
    public final static SimpleProperty.String<HandlingUnitItem> HANDLING_UNIT_QUANTITY_UNIT =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "HandlingUnitQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitAltUnitOfMeasure</b>
     * </p>
     * 
     * @return Alternative unit of measure for stock unit of measure
     */
    @Nullable
    @ElementName( "HandlingUnitAltUnitOfMeasure" )
    private java.lang.String handlingUnitAltUnitOfMeasure;
    public final static SimpleProperty.String<HandlingUnitItem> HANDLING_UNIT_ALT_UNIT_OF_MEASURE =
        new SimpleProperty.String<HandlingUnitItem>(HandlingUnitItem.class, "HandlingUnitAltUnitOfMeasure");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNrOfAuxPackgMat</b>
     * </p>
     * 
     * @return Number of Auxiliary Packaging Materials in the HU Item
     */
    @Nullable
    @ElementName( "HandlingUnitNrOfAuxPackgMat" )
    private Integer handlingUnitNrOfAuxPackgMat;
    public final static SimpleProperty.NumericInteger<HandlingUnitItem> HANDLING_UNIT_NR_OF_AUX_PACKG_MAT =
        new SimpleProperty.NumericInteger<HandlingUnitItem>(HandlingUnitItem.class, "HandlingUnitNrOfAuxPackgMat");
    /**
     * Navigation property <b>_HandlingUnit</b> for <b>HandlingUnitItem</b> to single <b>HandlingUnit</b>.
     * 
     */
    @ElementName( "_HandlingUnit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private HandlingUnit to_HandlingUnit;
    /**
     * Use with available request builders to apply the <b>_HandlingUnit</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<HandlingUnitItem, HandlingUnit> TO__HANDLING_UNIT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<HandlingUnitItem, HandlingUnit>(
            HandlingUnitItem.class,
            "_HandlingUnit",
            HandlingUnit.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<HandlingUnitItem> getType()
    {
        return HandlingUnitItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitExternalID</b>
     * </p>
     * 
     * @param handlingUnitExternalID
     *            External Handling Unit Identification
     */
    public void setHandlingUnitExternalID( @Nullable final java.lang.String handlingUnitExternalID )
    {
        rememberChangedField("HandlingUnitExternalID", this.handlingUnitExternalID);
        this.handlingUnitExternalID = handlingUnitExternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     * 
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final java.lang.String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>StockItemUUID</b>
     * </p>
     * 
     * @param stockItemUUID
     *            GUID Stock Item
     */
    public void setStockItemUUID( @Nullable final UUID stockItemUUID )
    {
        rememberChangedField("StockItemUUID", this.stockItemUUID);
        this.stockItemUUID = stockItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitItem</b>
     * </p>
     * 
     * @param handlingUnitItem
     *            Handling Unit Item
     */
    public void setHandlingUnitItem( @Nullable final java.lang.String handlingUnitItem )
    {
        rememberChangedField("HandlingUnitItem", this.handlingUnitItem);
        this.handlingUnitItem = handlingUnitItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitTypeOfContent</b>
     * </p>
     * 
     * @param handlingUnitTypeOfContent
     *            Type of Handling-unit Item Content
     */
    public void setHandlingUnitTypeOfContent( @Nullable final java.lang.String handlingUnitTypeOfContent )
    {
        rememberChangedField("HandlingUnitTypeOfContent", this.handlingUnitTypeOfContent);
        this.handlingUnitTypeOfContent = handlingUnitTypeOfContent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNestedExternalID</b>
     * </p>
     * 
     * @param handlingUnitNestedExternalID
     *            Char 20
     */
    public void setHandlingUnitNestedExternalID( @Nullable final java.lang.String handlingUnitNestedExternalID )
    {
        rememberChangedField("HandlingUnitNestedExternalID", this.handlingUnitNestedExternalID);
        this.handlingUnitNestedExternalID = handlingUnitNestedExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitReferenceDocument</b>
     * </p>
     * 
     * @param handlingUnitReferenceDocument
     *            Delivery
     */
    public void setHandlingUnitReferenceDocument( @Nullable final java.lang.String handlingUnitReferenceDocument )
    {
        rememberChangedField("HandlingUnitReferenceDocument", this.handlingUnitReferenceDocument);
        this.handlingUnitReferenceDocument = handlingUnitReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitRefDocumentItem</b>
     * </p>
     * 
     * @param handlingUnitRefDocumentItem
     *            Character Field Length = 10
     */
    public void setHandlingUnitRefDocumentItem( @Nullable final java.lang.String handlingUnitRefDocumentItem )
    {
        rememberChangedField("HandlingUnitRefDocumentItem", this.handlingUnitRefDocumentItem);
        this.handlingUnitRefDocumentItem = handlingUnitRefDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     * 
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final java.lang.String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     * 
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final java.lang.String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     * 
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final java.lang.String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantity</b>
     * </p>
     * 
     * @param handlingUnitQuantity
     *            The handlingUnitQuantity to set.
     */
    public void setHandlingUnitQuantity( @Nullable final BigDecimal handlingUnitQuantity )
    {
        rememberChangedField("HandlingUnitQuantity", this.handlingUnitQuantity);
        this.handlingUnitQuantity = handlingUnitQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitQuantityUnit</b>
     * </p>
     * 
     * @param handlingUnitQuantityUnit
     *            Base Unit of Measure of the Quantity to be Packed (VEMNG)
     */
    public void setHandlingUnitQuantityUnit( @Nullable final java.lang.String handlingUnitQuantityUnit )
    {
        rememberChangedField("HandlingUnitQuantityUnit", this.handlingUnitQuantityUnit);
        this.handlingUnitQuantityUnit = handlingUnitQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitAltUnitOfMeasure</b>
     * </p>
     * 
     * @param handlingUnitAltUnitOfMeasure
     *            Alternative unit of measure for stock unit of measure
     */
    public void setHandlingUnitAltUnitOfMeasure( @Nullable final java.lang.String handlingUnitAltUnitOfMeasure )
    {
        rememberChangedField("HandlingUnitAltUnitOfMeasure", this.handlingUnitAltUnitOfMeasure);
        this.handlingUnitAltUnitOfMeasure = handlingUnitAltUnitOfMeasure;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>HandlingUnitNrOfAuxPackgMat</b>
     * </p>
     * 
     * @param handlingUnitNrOfAuxPackgMat
     *            Number of Auxiliary Packaging Materials in the HU Item
     */
    public void setHandlingUnitNrOfAuxPackgMat( @Nullable final Integer handlingUnitNrOfAuxPackgMat )
    {
        rememberChangedField("HandlingUnitNrOfAuxPackgMat", this.handlingUnitNrOfAuxPackgMat);
        this.handlingUnitNrOfAuxPackgMat = handlingUnitNrOfAuxPackgMat;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "HandlingUnitItem";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("HandlingUnitExternalID", getHandlingUnitExternalID());
        entityKey.addKeyProperty("Warehouse", getWarehouse());
        entityKey.addKeyProperty("StockItemUUID", getStockItemUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("HandlingUnitExternalID", getHandlingUnitExternalID());
        values.put("Warehouse", getWarehouse());
        values.put("StockItemUUID", getStockItemUUID());
        values.put("HandlingUnitItem", getHandlingUnitItem());
        values.put("HandlingUnitTypeOfContent", getHandlingUnitTypeOfContent());
        values.put("HandlingUnitNestedExternalID", getHandlingUnitNestedExternalID());
        values.put("HandlingUnitReferenceDocument", getHandlingUnitReferenceDocument());
        values.put("HandlingUnitRefDocumentItem", getHandlingUnitRefDocumentItem());
        values.put("Material", getMaterial());
        values.put("Batch", getBatch());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("HandlingUnitQuantity", getHandlingUnitQuantity());
        values.put("HandlingUnitQuantityUnit", getHandlingUnitQuantityUnit());
        values.put("HandlingUnitAltUnitOfMeasure", getHandlingUnitAltUnitOfMeasure());
        values.put("HandlingUnitNrOfAuxPackgMat", getHandlingUnitNrOfAuxPackgMat());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("HandlingUnitExternalID") ) {
                final Object value = values.remove("HandlingUnitExternalID");
                if( (value == null) || (!value.equals(getHandlingUnitExternalID())) ) {
                    setHandlingUnitExternalID(((java.lang.String) value));
                }
            }
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((java.lang.String) value));
                }
            }
            if( values.containsKey("StockItemUUID") ) {
                final Object value = values.remove("StockItemUUID");
                if( (value == null) || (!value.equals(getStockItemUUID())) ) {
                    setStockItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("HandlingUnitItem") ) {
                final Object value = values.remove("HandlingUnitItem");
                if( (value == null) || (!value.equals(getHandlingUnitItem())) ) {
                    setHandlingUnitItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitTypeOfContent") ) {
                final Object value = values.remove("HandlingUnitTypeOfContent");
                if( (value == null) || (!value.equals(getHandlingUnitTypeOfContent())) ) {
                    setHandlingUnitTypeOfContent(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitNestedExternalID") ) {
                final Object value = values.remove("HandlingUnitNestedExternalID");
                if( (value == null) || (!value.equals(getHandlingUnitNestedExternalID())) ) {
                    setHandlingUnitNestedExternalID(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitReferenceDocument") ) {
                final Object value = values.remove("HandlingUnitReferenceDocument");
                if( (value == null) || (!value.equals(getHandlingUnitReferenceDocument())) ) {
                    setHandlingUnitReferenceDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitRefDocumentItem") ) {
                final Object value = values.remove("HandlingUnitRefDocumentItem");
                if( (value == null) || (!value.equals(getHandlingUnitRefDocumentItem())) ) {
                    setHandlingUnitRefDocumentItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((java.lang.String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitQuantity") ) {
                final Object value = values.remove("HandlingUnitQuantity");
                if( (value == null) || (!value.equals(getHandlingUnitQuantity())) ) {
                    setHandlingUnitQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("HandlingUnitQuantityUnit") ) {
                final Object value = values.remove("HandlingUnitQuantityUnit");
                if( (value == null) || (!value.equals(getHandlingUnitQuantityUnit())) ) {
                    setHandlingUnitQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitAltUnitOfMeasure") ) {
                final Object value = values.remove("HandlingUnitAltUnitOfMeasure");
                if( (value == null) || (!value.equals(getHandlingUnitAltUnitOfMeasure())) ) {
                    setHandlingUnitAltUnitOfMeasure(((java.lang.String) value));
                }
            }
            if( values.containsKey("HandlingUnitNrOfAuxPackgMat") ) {
                final Object value = values.remove("HandlingUnitNrOfAuxPackgMat");
                if( (value == null) || (!value.equals(getHandlingUnitNrOfAuxPackgMat())) ) {
                    setHandlingUnitNrOfAuxPackgMat(((Integer) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_HandlingUnit") ) {
                final Object value = (values).remove("_HandlingUnit");
                if( value instanceof Map ) {
                    if( to_HandlingUnit == null ) {
                        to_HandlingUnit = new HandlingUnit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_HandlingUnit.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return HandlingUnitService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_HandlingUnit != null ) {
            (values).put("_HandlingUnit", to_HandlingUnit);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>HandlingUnit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_HandlingUnit</b>.
     * <p>
     * If the navigation property for an entity <b>HandlingUnitItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_HandlingUnit</b> is already loaded, the result will
     *         contain the <b>HandlingUnit</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<HandlingUnit> getHandlingUnitIfPresent()
    {
        return Option.of(to_HandlingUnit);
    }

    /**
     * Overwrites the associated <b>HandlingUnit</b> entity for the loaded navigation property <b>_HandlingUnit</b>.
     * 
     * @param value
     *            New <b>HandlingUnit</b> entity.
     */
    public void setHandlingUnit( final HandlingUnit value )
    {
        to_HandlingUnit = value;
    }

    /**
     * Helper class to allow for fluent creation of HandlingUnitItem instances.
     * 
     */
    public final static class HandlingUnitItemBuilder
    {

        private HandlingUnit to_HandlingUnit;

        private HandlingUnitItem.HandlingUnitItemBuilder to_HandlingUnit( final HandlingUnit value )
        {
            to_HandlingUnit = value;
            return this;
        }

        /**
         * Navigation property <b>_HandlingUnit</b> for <b>HandlingUnitItem</b> to single <b>HandlingUnit</b>.
         * 
         * @param value
         *            The HandlingUnit to build this HandlingUnitItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public HandlingUnitItem.HandlingUnitItemBuilder handlingUnit( final HandlingUnit value )
        {
            return to_HandlingUnit(value);
        }

    }

}
