/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.InHouseRepairService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * In-House Repair
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>InHouseRepair_Type</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class InHouseRepair extends VdmEntity<InHouseRepair> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_inhouserepair.v0001.InHouseRepair_Type";
    /**
     * Selector for all available fields of InHouseRepair.
     * 
     */
    public final static SimpleProperty<InHouseRepair> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InHouseRepair</b>
     * </p>
     * 
     * @return In-House Repair ID
     */
    @Nullable
    @ElementName( "InHouseRepair" )
    private java.lang.String inHouseRepair;
    public final static SimpleProperty.String<InHouseRepair> IN_HOUSE_REPAIR =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "InHouseRepair");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairType</b>
     * </p>
     * 
     * @return Business Transaction Type
     */
    @Nullable
    @ElementName( "InhRepairType" )
    private java.lang.String inhRepairType;
    public final static SimpleProperty.String<InHouseRepair> INH_REPAIR_TYPE =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "InhRepairType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     * 
     * @return Sold-To Party
     */
    @Nullable
    @ElementName( "SoldToParty" )
    private java.lang.String soldToParty;
    public final static SimpleProperty.String<InHouseRepair> SOLD_TO_PARTY =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     * 
     * @return Contact Person
     */
    @Nullable
    @ElementName( "ContactPerson" )
    private java.lang.String contactPerson;
    public final static SimpleProperty.String<InHouseRepair> CONTACT_PERSON =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "ContactPerson");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     * 
     * @return Ship-To Party
     */
    @Nullable
    @ElementName( "ShipToParty" )
    private java.lang.String shipToParty;
    public final static SimpleProperty.String<InHouseRepair> SHIP_TO_PARTY =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     * 
     * @return Sales Organization
     */
    @Nullable
    @ElementName( "SalesOrganization" )
    private java.lang.String salesOrganization;
    public final static SimpleProperty.String<InHouseRepair> SALES_ORGANIZATION =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     * 
     * @return Distribution Channel
     */
    @Nullable
    @ElementName( "DistributionChannel" )
    private java.lang.String distributionChannel;
    public final static SimpleProperty.String<InHouseRepair> DISTRIBUTION_CHANNEL =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @return Division
     */
    @Nullable
    @ElementName( "Division" )
    private java.lang.String division;
    public final static SimpleProperty.String<InHouseRepair> DIVISION =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     * 
     * @return Sales Office
     */
    @Nullable
    @ElementName( "SalesOffice" )
    private java.lang.String salesOffice;
    public final static SimpleProperty.String<InHouseRepair> SALES_OFFICE =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     * 
     * @return Sales Group
     */
    @Nullable
    @ElementName( "SalesGroup" )
    private java.lang.String salesGroup;
    public final static SimpleProperty.String<InHouseRepair> SALES_GROUP =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationOrgUnitID</b>
     * </p>
     * 
     * @return Sales Organization ID
     */
    @Nullable
    @ElementName( "SalesOrganizationOrgUnitID" )
    private java.lang.String salesOrganizationOrgUnitID;
    public final static SimpleProperty.String<InHouseRepair> SALES_ORGANIZATION_ORG_UNIT_ID =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "SalesOrganizationOrgUnitID");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOfficeOrgUnitID</b>
     * </p>
     * 
     * @return Sales Office
     */
    @Nullable
    @ElementName( "SalesOfficeOrgUnitID" )
    private java.lang.String salesOfficeOrgUnitID;
    public final static SimpleProperty.String<InHouseRepair> SALES_OFFICE_ORG_UNIT_ID =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "SalesOfficeOrgUnitID");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroupOrgUnitID</b>
     * </p>
     * 
     * @return Sales Group
     */
    @Nullable
    @ElementName( "SalesGroupOrgUnitID" )
    private java.lang.String salesGroupOrgUnitID;
    public final static SimpleProperty.String<InHouseRepair> SALES_GROUP_ORG_UNIT_ID =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "SalesGroupOrgUnitID");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleSalesOrganization</b>
     * </p>
     * 
     * @return Organizational Unit (Sales)
     */
    @Nullable
    @ElementName( "ResponsibleSalesOrganization" )
    private java.lang.String responsibleSalesOrganization;
    public final static SimpleProperty.String<InHouseRepair> RESPONSIBLE_SALES_ORGANIZATION =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "ResponsibleSalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleEmployee</b>
     * </p>
     * 
     * @return Employee Responsible
     */
    @Nullable
    @ElementName( "ResponsibleEmployee" )
    private java.lang.String responsibleEmployee;
    public final static SimpleProperty.String<InHouseRepair> RESPONSIBLE_EMPLOYEE =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "ResponsibleEmployee");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairStatus</b>
     * </p>
     * 
     * @return In-House Repair Status
     */
    @Nullable
    @ElementName( "InhRepairStatus" )
    private java.lang.String inhRepairStatus;
    public final static SimpleProperty.String<InHouseRepair> INH_REPAIR_STATUS =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "InhRepairStatus");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairExtReference</b>
     * </p>
     * 
     * @return External Transaction Number
     */
    @Nullable
    @ElementName( "InhRepairExtReference" )
    private java.lang.String inhRepairExtReference;
    public final static SimpleProperty.String<InHouseRepair> INH_REPAIR_EXT_REFERENCE =
        new SimpleProperty.String<InHouseRepair>(InHouseRepair.class, "InhRepairExtReference");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<InHouseRepair, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<InHouseRepair, SAP__Message>(
            InHouseRepair.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_InHouseRepairItem</b> for <b>InHouseRepair</b> to multiple <b>InHouseRepairItem</b>.
     * 
     */
    @ElementName( "_InHouseRepairItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<InHouseRepairItem> to_InHouseRepairItem;
    /**
     * Use with available request builders to apply the <b>_InHouseRepairItem</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<InHouseRepair, InHouseRepairItem> TO__IN_HOUSE_REPAIR_ITEM =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<InHouseRepair, InHouseRepairItem>(
            InHouseRepair.class,
            "_InHouseRepairItem",
            InHouseRepairItem.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<InHouseRepair> getType()
    {
        return InHouseRepair.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InHouseRepair</b>
     * </p>
     * 
     * @param inHouseRepair
     *            In-House Repair ID
     */
    public void setInHouseRepair( @Nullable final java.lang.String inHouseRepair )
    {
        rememberChangedField("InHouseRepair", this.inHouseRepair);
        this.inHouseRepair = inHouseRepair;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairType</b>
     * </p>
     * 
     * @param inhRepairType
     *            Business Transaction Type
     */
    public void setInhRepairType( @Nullable final java.lang.String inhRepairType )
    {
        rememberChangedField("InhRepairType", this.inhRepairType);
        this.inhRepairType = inhRepairType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     * 
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final java.lang.String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     * 
     * @param contactPerson
     *            Contact Person
     */
    public void setContactPerson( @Nullable final java.lang.String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     * 
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final java.lang.String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     * 
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final java.lang.String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     * 
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final java.lang.String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final java.lang.String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     * 
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final java.lang.String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     * 
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final java.lang.String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationOrgUnitID</b>
     * </p>
     * 
     * @param salesOrganizationOrgUnitID
     *            Sales Organization ID
     */
    public void setSalesOrganizationOrgUnitID( @Nullable final java.lang.String salesOrganizationOrgUnitID )
    {
        rememberChangedField("SalesOrganizationOrgUnitID", this.salesOrganizationOrgUnitID);
        this.salesOrganizationOrgUnitID = salesOrganizationOrgUnitID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOfficeOrgUnitID</b>
     * </p>
     * 
     * @param salesOfficeOrgUnitID
     *            Sales Office
     */
    public void setSalesOfficeOrgUnitID( @Nullable final java.lang.String salesOfficeOrgUnitID )
    {
        rememberChangedField("SalesOfficeOrgUnitID", this.salesOfficeOrgUnitID);
        this.salesOfficeOrgUnitID = salesOfficeOrgUnitID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroupOrgUnitID</b>
     * </p>
     * 
     * @param salesGroupOrgUnitID
     *            Sales Group
     */
    public void setSalesGroupOrgUnitID( @Nullable final java.lang.String salesGroupOrgUnitID )
    {
        rememberChangedField("SalesGroupOrgUnitID", this.salesGroupOrgUnitID);
        this.salesGroupOrgUnitID = salesGroupOrgUnitID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleSalesOrganization</b>
     * </p>
     * 
     * @param responsibleSalesOrganization
     *            Organizational Unit (Sales)
     */
    public void setResponsibleSalesOrganization( @Nullable final java.lang.String responsibleSalesOrganization )
    {
        rememberChangedField("ResponsibleSalesOrganization", this.responsibleSalesOrganization);
        this.responsibleSalesOrganization = responsibleSalesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleEmployee</b>
     * </p>
     * 
     * @param responsibleEmployee
     *            Employee Responsible
     */
    public void setResponsibleEmployee( @Nullable final java.lang.String responsibleEmployee )
    {
        rememberChangedField("ResponsibleEmployee", this.responsibleEmployee);
        this.responsibleEmployee = responsibleEmployee;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairStatus</b>
     * </p>
     * 
     * @param inhRepairStatus
     *            In-House Repair Status
     */
    public void setInhRepairStatus( @Nullable final java.lang.String inhRepairStatus )
    {
        rememberChangedField("InhRepairStatus", this.inhRepairStatus);
        this.inhRepairStatus = inhRepairStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairExtReference</b>
     * </p>
     * 
     * @param inhRepairExtReference
     *            External Transaction Number
     */
    public void setInhRepairExtReference( @Nullable final java.lang.String inhRepairExtReference )
    {
        rememberChangedField("InhRepairExtReference", this.inhRepairExtReference);
        this.inhRepairExtReference = inhRepairExtReference;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "InHouseRepair";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InHouseRepair", getInHouseRepair());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InHouseRepair", getInHouseRepair());
        values.put("InhRepairType", getInhRepairType());
        values.put("SoldToParty", getSoldToParty());
        values.put("ContactPerson", getContactPerson());
        values.put("ShipToParty", getShipToParty());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("SalesOrganizationOrgUnitID", getSalesOrganizationOrgUnitID());
        values.put("SalesOfficeOrgUnitID", getSalesOfficeOrgUnitID());
        values.put("SalesGroupOrgUnitID", getSalesGroupOrgUnitID());
        values.put("ResponsibleSalesOrganization", getResponsibleSalesOrganization());
        values.put("ResponsibleEmployee", getResponsibleEmployee());
        values.put("InhRepairStatus", getInhRepairStatus());
        values.put("InhRepairExtReference", getInhRepairExtReference());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InHouseRepair") ) {
                final Object value = values.remove("InHouseRepair");
                if( (value == null) || (!value.equals(getInHouseRepair())) ) {
                    setInHouseRepair(((java.lang.String) value));
                }
            }
            if( values.containsKey("InhRepairType") ) {
                final Object value = values.remove("InhRepairType");
                if( (value == null) || (!value.equals(getInhRepairType())) ) {
                    setInhRepairType(((java.lang.String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((java.lang.String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((java.lang.String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOrganizationOrgUnitID") ) {
                final Object value = values.remove("SalesOrganizationOrgUnitID");
                if( (value == null) || (!value.equals(getSalesOrganizationOrgUnitID())) ) {
                    setSalesOrganizationOrgUnitID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOfficeOrgUnitID") ) {
                final Object value = values.remove("SalesOfficeOrgUnitID");
                if( (value == null) || (!value.equals(getSalesOfficeOrgUnitID())) ) {
                    setSalesOfficeOrgUnitID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesGroupOrgUnitID") ) {
                final Object value = values.remove("SalesGroupOrgUnitID");
                if( (value == null) || (!value.equals(getSalesGroupOrgUnitID())) ) {
                    setSalesGroupOrgUnitID(((java.lang.String) value));
                }
            }
            if( values.containsKey("ResponsibleSalesOrganization") ) {
                final Object value = values.remove("ResponsibleSalesOrganization");
                if( (value == null) || (!value.equals(getResponsibleSalesOrganization())) ) {
                    setResponsibleSalesOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("ResponsibleEmployee") ) {
                final Object value = values.remove("ResponsibleEmployee");
                if( (value == null) || (!value.equals(getResponsibleEmployee())) ) {
                    setResponsibleEmployee(((java.lang.String) value));
                }
            }
            if( values.containsKey("InhRepairStatus") ) {
                final Object value = values.remove("InhRepairStatus");
                if( (value == null) || (!value.equals(getInhRepairStatus())) ) {
                    setInhRepairStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("InhRepairExtReference") ) {
                final Object value = values.remove("InhRepairExtReference");
                if( (value == null) || (!value.equals(getInhRepairExtReference())) ) {
                    setInhRepairExtReference(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_InHouseRepairItem") ) {
                final Object value = (values).remove("_InHouseRepairItem");
                if( value instanceof Iterable ) {
                    if( to_InHouseRepairItem == null ) {
                        to_InHouseRepairItem = Lists.newArrayList();
                    } else {
                        to_InHouseRepairItem = Lists.newArrayList(to_InHouseRepairItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        InHouseRepairItem entity;
                        if( to_InHouseRepairItem.size() > i ) {
                            entity = to_InHouseRepairItem.get(i);
                        } else {
                            entity = new InHouseRepairItem();
                            to_InHouseRepairItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return InHouseRepairService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_InHouseRepairItem != null ) {
            (values).put("_InHouseRepairItem", to_InHouseRepairItem);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>InHouseRepairItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_InHouseRepairItem</b>.
     * <p>
     * If the navigation property for an entity <b>InHouseRepair</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_InHouseRepairItem</b> is already loaded, the result will
     *         contain the <b>InHouseRepairItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<InHouseRepairItem>> getInHouseRepairItemIfPresent()
    {
        return Option.of(to_InHouseRepairItem);
    }

    /**
     * Overwrites the list of associated <b>InHouseRepairItem</b> entities for the loaded navigation property
     * <b>_InHouseRepairItem</b>.
     * <p>
     * If the navigation property <b>_InHouseRepairItem</b> of a queried <b>InHouseRepair</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>InHouseRepairItem</b> entities.
     */
    public void setInHouseRepairItem( @Nonnull final List<InHouseRepairItem> value )
    {
        if( to_InHouseRepairItem == null ) {
            to_InHouseRepairItem = Lists.newArrayList();
        }
        to_InHouseRepairItem.clear();
        to_InHouseRepairItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>InHouseRepairItem</b> entities. This corresponds to the OData
     * navigation property <b>_InHouseRepairItem</b>.
     * <p>
     * If the navigation property <b>_InHouseRepairItem</b> of a queried <b>InHouseRepair</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>InHouseRepairItem</b> entities.
     */
    public void addInHouseRepairItem( InHouseRepairItem... entity )
    {
        if( to_InHouseRepairItem == null ) {
            to_InHouseRepairItem = Lists.newArrayList();
        }
        to_InHouseRepairItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<InHouseRepair, InHouseRepair>
        confirmRepairObjects()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<InHouseRepair, InHouseRepair>(
            InHouseRepair.class,
            InHouseRepair.class,
            "com.sap.gateway.srvd_a2x.api_inhouserepair.v0001.ConfirmRepairObjects",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of InHouseRepair instances.
     * 
     */
    public final static class InHouseRepairBuilder
    {

        private List<InHouseRepairItem> to_InHouseRepairItem = Lists.newArrayList();

        private InHouseRepair.InHouseRepairBuilder to_InHouseRepairItem( final List<InHouseRepairItem> value )
        {
            to_InHouseRepairItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_InHouseRepairItem</b> for <b>InHouseRepair</b> to multiple <b>InHouseRepairItem</b>.
         * 
         * @param value
         *            The InHouseRepairItems to build this InHouseRepair with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InHouseRepair.InHouseRepairBuilder inHouseRepairItem( InHouseRepairItem... value )
        {
            return to_InHouseRepairItem(Lists.newArrayList(value));
        }

    }

}
