/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.InHouseRepairService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * In-House Repair Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>InHouseRepairItem_Type</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class InHouseRepairItem extends VdmEntity<InHouseRepairItem> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_inhouserepair.v0001.InHouseRepairItem_Type";
    /**
     * Selector for all available fields of InHouseRepairItem.
     * 
     */
    public final static SimpleProperty<InHouseRepairItem> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InHouseRepair</b>
     * </p>
     * 
     * @return In-House Repair ID
     */
    @Nullable
    @ElementName( "InHouseRepair" )
    private java.lang.String inHouseRepair;
    public final static SimpleProperty.String<InHouseRepairItem> IN_HOUSE_REPAIR =
        new SimpleProperty.String<InHouseRepairItem>(InHouseRepairItem.class, "InHouseRepair");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InHouseRepairItem</b>
     * </p>
     * 
     * @return Repair Object
     */
    @Nullable
    @ElementName( "InHouseRepairItem" )
    private java.lang.String inHouseRepairItem;
    public final static SimpleProperty.String<InHouseRepairItem> IN_HOUSE_REPAIR_ITEM =
        new SimpleProperty.String<InHouseRepairItem>(InHouseRepairItem.class, "InHouseRepairItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairType</b>
     * </p>
     * 
     * @return Business Transaction Type
     */
    @Nullable
    @ElementName( "InhRepairType" )
    private java.lang.String inhRepairType;
    public final static SimpleProperty.String<InHouseRepairItem> INH_REPAIR_TYPE =
        new SimpleProperty.String<InHouseRepairItem>(InHouseRepairItem.class, "InhRepairType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairReferenceEquipment</b>
     * </p>
     * 
     * @return Equipment Number
     */
    @Nullable
    @ElementName( "InhRepairReferenceEquipment" )
    private java.lang.String inhRepairReferenceEquipment;
    public final static SimpleProperty.String<InHouseRepairItem> INH_REPAIR_REFERENCE_EQUIPMENT =
        new SimpleProperty.String<InHouseRepairItem>(InHouseRepairItem.class, "InhRepairReferenceEquipment");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @return Product Number
     */
    @Nullable
    @ElementName( "Product" )
    private java.lang.String product;
    public final static SimpleProperty.String<InHouseRepairItem> PRODUCT =
        new SimpleProperty.String<InHouseRepairItem>(InHouseRepairItem.class, "Product");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     * 
     * @return Serial Number of Equipment
     */
    @Nullable
    @ElementName( "SerialNumber" )
    private java.lang.String serialNumber;
    public final static SimpleProperty.String<InHouseRepairItem> SERIAL_NUMBER =
        new SimpleProperty.String<InHouseRepairItem>(InHouseRepairItem.class, "SerialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairItemStatus</b>
     * </p>
     * 
     * @return Repair Object Status
     */
    @Nullable
    @ElementName( "InhRepairItemStatus" )
    private java.lang.String inhRepairItemStatus;
    public final static SimpleProperty.String<InHouseRepairItem> INH_REPAIR_ITEM_STATUS =
        new SimpleProperty.String<InHouseRepairItem>(InHouseRepairItem.class, "InhRepairItemStatus");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<InHouseRepairItem, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<InHouseRepairItem, SAP__Message>(
            InHouseRepairItem.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_InHouseRepair</b> for <b>InHouseRepairItem</b> to single <b>InHouseRepair</b>.
     * 
     */
    @ElementName( "_InHouseRepair" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private InHouseRepair to_InHouseRepair;
    /**
     * Use with available request builders to apply the <b>_InHouseRepair</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<InHouseRepairItem, InHouseRepair> TO__IN_HOUSE_REPAIR =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<InHouseRepairItem, InHouseRepair>(
            InHouseRepairItem.class,
            "_InHouseRepair",
            InHouseRepair.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<InHouseRepairItem> getType()
    {
        return InHouseRepairItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InHouseRepair</b>
     * </p>
     * 
     * @param inHouseRepair
     *            In-House Repair ID
     */
    public void setInHouseRepair( @Nullable final java.lang.String inHouseRepair )
    {
        rememberChangedField("InHouseRepair", this.inHouseRepair);
        this.inHouseRepair = inHouseRepair;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InHouseRepairItem</b>
     * </p>
     * 
     * @param inHouseRepairItem
     *            Repair Object
     */
    public void setInHouseRepairItem( @Nullable final java.lang.String inHouseRepairItem )
    {
        rememberChangedField("InHouseRepairItem", this.inHouseRepairItem);
        this.inHouseRepairItem = inHouseRepairItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairType</b>
     * </p>
     * 
     * @param inhRepairType
     *            Business Transaction Type
     */
    public void setInhRepairType( @Nullable final java.lang.String inhRepairType )
    {
        rememberChangedField("InhRepairType", this.inhRepairType);
        this.inhRepairType = inhRepairType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairReferenceEquipment</b>
     * </p>
     * 
     * @param inhRepairReferenceEquipment
     *            Equipment Number
     */
    public void setInhRepairReferenceEquipment( @Nullable final java.lang.String inhRepairReferenceEquipment )
    {
        rememberChangedField("InhRepairReferenceEquipment", this.inhRepairReferenceEquipment);
        this.inhRepairReferenceEquipment = inhRepairReferenceEquipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final java.lang.String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     * 
     * @param serialNumber
     *            Serial Number of Equipment
     */
    public void setSerialNumber( @Nullable final java.lang.String serialNumber )
    {
        rememberChangedField("SerialNumber", this.serialNumber);
        this.serialNumber = serialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>InhRepairItemStatus</b>
     * </p>
     * 
     * @param inhRepairItemStatus
     *            Repair Object Status
     */
    public void setInhRepairItemStatus( @Nullable final java.lang.String inhRepairItemStatus )
    {
        rememberChangedField("InhRepairItemStatus", this.inhRepairItemStatus);
        this.inhRepairItemStatus = inhRepairItemStatus;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "InHouseRepairItem";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("InHouseRepair", getInHouseRepair());
        entityKey.addKeyProperty("InHouseRepairItem", getInHouseRepairItem());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("InHouseRepair", getInHouseRepair());
        values.put("InHouseRepairItem", getInHouseRepairItem());
        values.put("InhRepairType", getInhRepairType());
        values.put("InhRepairReferenceEquipment", getInhRepairReferenceEquipment());
        values.put("Product", getProduct());
        values.put("SerialNumber", getSerialNumber());
        values.put("InhRepairItemStatus", getInhRepairItemStatus());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InHouseRepair") ) {
                final Object value = values.remove("InHouseRepair");
                if( (value == null) || (!value.equals(getInHouseRepair())) ) {
                    setInHouseRepair(((java.lang.String) value));
                }
            }
            if( values.containsKey("InHouseRepairItem") ) {
                final Object value = values.remove("InHouseRepairItem");
                if( (value == null) || (!value.equals(getInHouseRepairItem())) ) {
                    setInHouseRepairItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("InhRepairType") ) {
                final Object value = values.remove("InhRepairType");
                if( (value == null) || (!value.equals(getInhRepairType())) ) {
                    setInhRepairType(((java.lang.String) value));
                }
            }
            if( values.containsKey("InhRepairReferenceEquipment") ) {
                final Object value = values.remove("InhRepairReferenceEquipment");
                if( (value == null) || (!value.equals(getInhRepairReferenceEquipment())) ) {
                    setInhRepairReferenceEquipment(((java.lang.String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("SerialNumber") ) {
                final Object value = values.remove("SerialNumber");
                if( (value == null) || (!value.equals(getSerialNumber())) ) {
                    setSerialNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("InhRepairItemStatus") ) {
                final Object value = values.remove("InhRepairItemStatus");
                if( (value == null) || (!value.equals(getInhRepairItemStatus())) ) {
                    setInhRepairItemStatus(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_InHouseRepair") ) {
                final Object value = (values).remove("_InHouseRepair");
                if( value instanceof Map ) {
                    if( to_InHouseRepair == null ) {
                        to_InHouseRepair = new InHouseRepair();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_InHouseRepair.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return InHouseRepairService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_InHouseRepair != null ) {
            (values).put("_InHouseRepair", to_InHouseRepair);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>InHouseRepair</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_InHouseRepair</b>.
     * <p>
     * If the navigation property for an entity <b>InHouseRepairItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_InHouseRepair</b> is already loaded, the result will
     *         contain the <b>InHouseRepair</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<InHouseRepair> getInHouseRepairIfPresent()
    {
        return Option.of(to_InHouseRepair);
    }

    /**
     * Overwrites the associated <b>InHouseRepair</b> entity for the loaded navigation property <b>_InHouseRepair</b>.
     * 
     * @param value
     *            New <b>InHouseRepair</b> entity.
     */
    public void setInHouseRepair( final InHouseRepair value )
    {
        to_InHouseRepair = value;
    }

    /**
     * Helper class to allow for fluent creation of InHouseRepairItem instances.
     * 
     */
    public final static class InHouseRepairItemBuilder
    {

        private InHouseRepair to_InHouseRepair;
        private java.lang.String inHouseRepair = null;

        private InHouseRepairItem.InHouseRepairItemBuilder to_InHouseRepair( final InHouseRepair value )
        {
            to_InHouseRepair = value;
            return this;
        }

        /**
         * Navigation property <b>_InHouseRepair</b> for <b>InHouseRepairItem</b> to single <b>InHouseRepair</b>.
         * 
         * @param value
         *            The InHouseRepair to build this InHouseRepairItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InHouseRepairItem.InHouseRepairItemBuilder inHouseRepair( final InHouseRepair value )
        {
            return to_InHouseRepair(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>InHouseRepair</b>
         * </p>
         * 
         * @param value
         *            The inHouseRepair to build this InHouseRepairItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public InHouseRepairItem.InHouseRepairItemBuilder inHouseRepair( final java.lang.String value )
        {
            inHouseRepair = value;
            return this;
        }

    }

}
