/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.JointOperatingAgreementService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Joint Operating Agreement
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JntOpgAgrmtType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class JntOpgAgrmt extends VdmEntity<JntOpgAgrmt> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_jntopgagrmt.v0001.A_JntOpgAgrmtType";
    /**
     * Selector for all available fields of JntOpgAgrmt.
     * 
     */
    public final static SimpleProperty<JntOpgAgrmt> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<JntOpgAgrmt> COMPANY_CODE =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @return Joint Operating Agreement
     */
    @Nullable
    @ElementName( "JntOpgAgrmt" )
    private java.lang.String jntOpgAgrmt;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_OPG_AGRMT =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntOpgAgrmt");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrContractNmbr</b>
     * </p>
     * 
     * @return JV Contract Number
     */
    @Nullable
    @ElementName( "JntVntrContractNmbr" )
    private java.lang.String jntVntrContractNmbr;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_CONTRACT_NMBR =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrContractNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPayrollClearingSet</b>
     * </p>
     * 
     * @return Set of Accounts to Which Payroll Burden Clearing Applies
     */
    @Nullable
    @ElementName( "JntVntrPayrollClearingSet" )
    private java.lang.String jntVntrPayrollClearingSet;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_PAYROLL_CLEARING_SET =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrPayrollClearingSet");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrConstructionExclsnSet</b>
     * </p>
     * 
     * @return Set of Accounts to Exclude from Construction Overhead Calc.
     */
    @Nullable
    @ElementName( "JntVntrConstructionExclsnSet" )
    private java.lang.String jntVntrConstructionExclsnSet;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_CONSTRUCTION_EXCLSN_SET =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrConstructionExclsnSet");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCatastropheExclsnSet</b>
     * </p>
     * 
     * @return Set of Accounts to Exclude from Catastrophe Overhead Calc.
     */
    @Nullable
    @ElementName( "JntVntrCatastropheExclsnSet" )
    private java.lang.String jntVntrCatastropheExclsnSet;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_CATASTROPHE_EXCLSN_SET =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrCatastropheExclsnSet");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrConstructionOvhdRule</b>
     * </p>
     * 
     * @return Construction Overhead Rule
     */
    @Nullable
    @ElementName( "JntVntrConstructionOvhdRule" )
    private java.lang.String jntVntrConstructionOvhdRule;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_CONSTRUCTION_OVHD_RULE =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrConstructionOvhdRule");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCatastropheOvhdRule</b>
     * </p>
     * 
     * @return Catastrophe Overhead Rule
     */
    @Nullable
    @ElementName( "JntVntrCatastropheOvhdRule" )
    private java.lang.String jntVntrCatastropheOvhdRule;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_CATASTROPHE_OVHD_RULE =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrCatastropheOvhdRule");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>JVAOvhdPercentProdg</b>
     * </p>
     * 
     * @return Percent 1 (% Producing U.S., % Regular Canada) (JVA)
     */
    @Nullable
    @ElementName( "JVAOvhdPercentProdg" )
    @DecimalDescriptor( precision = 5, scale = 2 )
    private BigDecimal jVAOvhdPercentProdg;
    public final static SimpleProperty.NumericDecimal<JntOpgAgrmt> JVA_OVHD_PERCENT_PRODG =
        new SimpleProperty.NumericDecimal<JntOpgAgrmt>(JntOpgAgrmt.class, "JVAOvhdPercentProdg");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JVAExclsnAcctSetPercentProdg</b>
     * </p>
     * 
     * @return Exclusion Set of Accounts - Percent 1 (JVA)
     */
    @Nullable
    @ElementName( "JVAExclsnAcctSetPercentProdg" )
    private java.lang.String jVAExclsnAcctSetPercentProdg;
    public final static SimpleProperty.String<JntOpgAgrmt> JVA_EXCLSN_ACCT_SET_PERCENT_PRODG =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JVAExclsnAcctSetPercentProdg");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>JVAOvhdPercentDev</b>
     * </p>
     * 
     * @return Percent 2 (% Development U.S., % Special Canada) (JVA)
     */
    @Nullable
    @ElementName( "JVAOvhdPercentDev" )
    @DecimalDescriptor( precision = 5, scale = 2 )
    private BigDecimal jVAOvhdPercentDev;
    public final static SimpleProperty.NumericDecimal<JntOpgAgrmt> JVA_OVHD_PERCENT_DEV =
        new SimpleProperty.NumericDecimal<JntOpgAgrmt>(JntOpgAgrmt.class, "JVAOvhdPercentDev");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JVAExclsnAcctSetPercentDev</b>
     * </p>
     * 
     * @return Exclusion Set of Accounts - Percent 2 (JVA)
     */
    @Nullable
    @ElementName( "JVAExclsnAcctSetPercentDev" )
    private java.lang.String jVAExclsnAcctSetPercentDev;
    public final static SimpleProperty.String<JntOpgAgrmt> JVA_EXCLSN_ACCT_SET_PERCENT_DEV =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JVAExclsnAcctSetPercentDev");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrExplorationOvhdRule</b>
     * </p>
     * 
     * @return Exploration Overhead Rule
     */
    @Nullable
    @ElementName( "JntVntrExplorationOvhdRule" )
    private java.lang.String jntVntrExplorationOvhdRule;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_EXPLORATION_OVHD_RULE =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrExplorationOvhdRule");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrDrillingOvhdRule</b>
     * </p>
     * 
     * @return Drilling Overhead Rule
     */
    @Nullable
    @ElementName( "JntVntrDrillingOvhdRule" )
    private java.lang.String jntVntrDrillingOvhdRule;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_DRILLING_OVHD_RULE =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrDrillingOvhdRule");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCapitalExclsnSet</b>
     * </p>
     * 
     * @return Set of Accounts to Exclude from Capital Overhead Calc.
     */
    @Nullable
    @ElementName( "JntVntrCapitalExclsnSet" )
    private java.lang.String jntVntrCapitalExclsnSet;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_CAPITAL_EXCLSN_SET =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrCapitalExclsnSet");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOvhdOffsetCostCtr</b>
     * </p>
     * 
     * @return Overhead Offset Cost Centre - JV
     */
    @Nullable
    @ElementName( "JntVntrOvhdOffsetCostCtr" )
    private java.lang.String jntVntrOvhdOffsetCostCtr;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_OVHD_OFFSET_COST_CTR =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrOvhdOffsetCostCtr");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtProdgWellThld</b>
     * </p>
     * 
     * @return Perform Producing Well Threshold Calculation at JOA Level
     */
    @Nullable
    @ElementName( "JntOpgAgrmtProdgWellThld" )
    private java.lang.Boolean jntOpgAgrmtProdgWellThld;
    public final static SimpleProperty.Boolean<JntOpgAgrmt> JNT_OPG_AGRMT_PRODG_WELL_THLD =
        new SimpleProperty.Boolean<JntOpgAgrmt>(JntOpgAgrmt.class, "JntOpgAgrmtProdgWellThld");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOvhdRecurringDoc</b>
     * </p>
     * 
     * @return Recurring Document Number - JV overheads
     */
    @Nullable
    @ElementName( "JntVntrOvhdRecurringDoc" )
    private java.lang.String jntVntrOvhdRecurringDoc;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_VNTR_OVHD_RECURRING_DOC =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrOvhdRecurringDoc");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrExpnIsEscalated</b>
     * </p>
     * 
     * @return Escalatable
     */
    @Nullable
    @ElementName( "JntVntrExpnIsEscalated" )
    private java.lang.Boolean jntVntrExpnIsEscalated;
    public final static SimpleProperty.Boolean<JntOpgAgrmt> JNT_VNTR_EXPN_IS_ESCALATED =
        new SimpleProperty.Boolean<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrExpnIsEscalated");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtClass</b>
     * </p>
     * 
     * @return Joint Operating Agreement Class
     */
    @Nullable
    @ElementName( "JntOpgAgrmtClass" )
    private java.lang.String jntOpgAgrmtClass;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_OPG_AGRMT_CLASS =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntOpgAgrmtClass");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtCreatedByUser</b>
     * </p>
     * 
     * @return User who Created
     */
    @Nullable
    @ElementName( "JntOpgAgrmtCreatedByUser" )
    private java.lang.String jntOpgAgrmtCreatedByUser;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_OPG_AGRMT_CREATED_BY_USER =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntOpgAgrmtCreatedByUser");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtCreationTime</b>
     * </p>
     * 
     * @return The jntOpgAgrmtCreationTime contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "JntOpgAgrmtCreationTime" )
    private LocalTime jntOpgAgrmtCreationTime;
    public final static SimpleProperty.Time<JntOpgAgrmt> JNT_OPG_AGRMT_CREATION_TIME =
        new SimpleProperty.Time<JntOpgAgrmt>(JntOpgAgrmt.class, "JntOpgAgrmtCreationTime");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtCreationDate</b>
     * </p>
     * 
     * @return The jntOpgAgrmtCreationDate contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "JntOpgAgrmtCreationDate" )
    private LocalDate jntOpgAgrmtCreationDate;
    public final static SimpleProperty.Date<JntOpgAgrmt> JNT_OPG_AGRMT_CREATION_DATE =
        new SimpleProperty.Date<JntOpgAgrmt>(JntOpgAgrmt.class, "JntOpgAgrmtCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtLastChangedByUser</b>
     * </p>
     * 
     * @return User who Last Changed
     */
    @Nullable
    @ElementName( "JntOpgAgrmtLastChangedByUser" )
    private java.lang.String jntOpgAgrmtLastChangedByUser;
    public final static SimpleProperty.String<JntOpgAgrmt> JNT_OPG_AGRMT_LAST_CHANGED_BY_USER =
        new SimpleProperty.String<JntOpgAgrmt>(JntOpgAgrmt.class, "JntOpgAgrmtLastChangedByUser");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtLastChangedTime</b>
     * </p>
     * 
     * @return The jntOpgAgrmtLastChangedTime contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "JntOpgAgrmtLastChangedTime" )
    private LocalTime jntOpgAgrmtLastChangedTime;
    public final static SimpleProperty.Time<JntOpgAgrmt> JNT_OPG_AGRMT_LAST_CHANGED_TIME =
        new SimpleProperty.Time<JntOpgAgrmt>(JntOpgAgrmt.class, "JntOpgAgrmtLastChangedTime");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtLastChangedDate</b>
     * </p>
     * 
     * @return The jntOpgAgrmtLastChangedDate contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "JntOpgAgrmtLastChangedDate" )
    private LocalDate jntOpgAgrmtLastChangedDate;
    public final static SimpleProperty.Date<JntOpgAgrmt> JNT_OPG_AGRMT_LAST_CHANGED_DATE =
        new SimpleProperty.Date<JntOpgAgrmt>(JntOpgAgrmt.class, "JntOpgAgrmtLastChangedDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPrioPerdDrillingIsCalc</b>
     * </p>
     * 
     * @return Calculate Drilling Days using prior period.
     */
    @Nullable
    @ElementName( "JntVntrPrioPerdDrillingIsCalc" )
    private java.lang.Boolean jntVntrPrioPerdDrillingIsCalc;
    public final static SimpleProperty.Boolean<JntOpgAgrmt> JNT_VNTR_PRIO_PERD_DRILLING_IS_CALC =
        new SimpleProperty.Boolean<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrPrioPerdDrillingIsCalc");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrWBSElmntOvhdIsCalc</b>
     * </p>
     * 
     * @return Calculate all WBS elements for overhead
     */
    @Nullable
    @ElementName( "JntVntrWBSElmntOvhdIsCalc" )
    private java.lang.Boolean jntVntrWBSElmntOvhdIsCalc;
    public final static SimpleProperty.Boolean<JntOpgAgrmt> JNT_VNTR_WBS_ELMNT_OVHD_IS_CALC =
        new SimpleProperty.Boolean<JntOpgAgrmt>(JntOpgAgrmt.class, "JntVntrWBSElmntOvhdIsCalc");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntOpgAgrmt, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntOpgAgrmt, SAP__Message>(
            JntOpgAgrmt.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_JntOpgAgrmtEquityGrp</b> for <b>JntOpgAgrmt</b> to multiple
     * <b>JntOpgAgrmtEquityTypeGrp</b>.
     * 
     */
    @ElementName( "_JntOpgAgrmtEquityGrp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JntOpgAgrmtEquityTypeGrp> to_JntOpgAgrmtEquityGrp;
    /**
     * Navigation property <b>_JntOpgAgrmtPnltyCatRcvry</b> for <b>JntOpgAgrmt</b> to multiple
     * <b>JntOpgAgrmtPnltyCatRcvry</b>.
     * 
     */
    @ElementName( "_JntOpgAgrmtPnltyCatRcvry" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JntOpgAgrmtPnltyCatRcvry> to_JntOpgAgrmtPnltyCatRcvry;
    /**
     * Navigation property <b>_JntOpgAgrmtText</b> for <b>JntOpgAgrmt</b> to multiple <b>JntOpgAgrmtText</b>.
     * 
     */
    @ElementName( "_JntOpgAgrmtText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JntOpgAgrmtText> to_JntOpgAgrmtText;
    /**
     * Use with available request builders to apply the <b>_JntOpgAgrmtEquityGrp</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JntOpgAgrmt, JntOpgAgrmtEquityTypeGrp> TO__JNT_OPG_AGRMT_EQUITY_GRP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JntOpgAgrmt, JntOpgAgrmtEquityTypeGrp>(
            JntOpgAgrmt.class,
            "_JntOpgAgrmtEquityGrp",
            JntOpgAgrmtEquityTypeGrp.class);
    /**
     * Use with available request builders to apply the <b>_JntOpgAgrmtPnltyCatRcvry</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JntOpgAgrmt, JntOpgAgrmtPnltyCatRcvry> TO__JNT_OPG_AGRMT_PNLTY_CAT_RCVRY =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JntOpgAgrmt, JntOpgAgrmtPnltyCatRcvry>(
            JntOpgAgrmt.class,
            "_JntOpgAgrmtPnltyCatRcvry",
            JntOpgAgrmtPnltyCatRcvry.class);
    /**
     * Use with available request builders to apply the <b>_JntOpgAgrmtText</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JntOpgAgrmt, JntOpgAgrmtText> TO__JNT_OPG_AGRMT_TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JntOpgAgrmt, JntOpgAgrmtText>(
            JntOpgAgrmt.class,
            "_JntOpgAgrmtText",
            JntOpgAgrmtText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<JntOpgAgrmt> getType()
    {
        return JntOpgAgrmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     */
    public void setJntOpgAgrmt( @Nullable final java.lang.String jntOpgAgrmt )
    {
        rememberChangedField("JntOpgAgrmt", this.jntOpgAgrmt);
        this.jntOpgAgrmt = jntOpgAgrmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrContractNmbr</b>
     * </p>
     * 
     * @param jntVntrContractNmbr
     *            JV Contract Number
     */
    public void setJntVntrContractNmbr( @Nullable final java.lang.String jntVntrContractNmbr )
    {
        rememberChangedField("JntVntrContractNmbr", this.jntVntrContractNmbr);
        this.jntVntrContractNmbr = jntVntrContractNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPayrollClearingSet</b>
     * </p>
     * 
     * @param jntVntrPayrollClearingSet
     *            Set of Accounts to Which Payroll Burden Clearing Applies
     */
    public void setJntVntrPayrollClearingSet( @Nullable final java.lang.String jntVntrPayrollClearingSet )
    {
        rememberChangedField("JntVntrPayrollClearingSet", this.jntVntrPayrollClearingSet);
        this.jntVntrPayrollClearingSet = jntVntrPayrollClearingSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrConstructionExclsnSet</b>
     * </p>
     * 
     * @param jntVntrConstructionExclsnSet
     *            Set of Accounts to Exclude from Construction Overhead Calc.
     */
    public void setJntVntrConstructionExclsnSet( @Nullable final java.lang.String jntVntrConstructionExclsnSet )
    {
        rememberChangedField("JntVntrConstructionExclsnSet", this.jntVntrConstructionExclsnSet);
        this.jntVntrConstructionExclsnSet = jntVntrConstructionExclsnSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCatastropheExclsnSet</b>
     * </p>
     * 
     * @param jntVntrCatastropheExclsnSet
     *            Set of Accounts to Exclude from Catastrophe Overhead Calc.
     */
    public void setJntVntrCatastropheExclsnSet( @Nullable final java.lang.String jntVntrCatastropheExclsnSet )
    {
        rememberChangedField("JntVntrCatastropheExclsnSet", this.jntVntrCatastropheExclsnSet);
        this.jntVntrCatastropheExclsnSet = jntVntrCatastropheExclsnSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrConstructionOvhdRule</b>
     * </p>
     * 
     * @param jntVntrConstructionOvhdRule
     *            Construction Overhead Rule
     */
    public void setJntVntrConstructionOvhdRule( @Nullable final java.lang.String jntVntrConstructionOvhdRule )
    {
        rememberChangedField("JntVntrConstructionOvhdRule", this.jntVntrConstructionOvhdRule);
        this.jntVntrConstructionOvhdRule = jntVntrConstructionOvhdRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCatastropheOvhdRule</b>
     * </p>
     * 
     * @param jntVntrCatastropheOvhdRule
     *            Catastrophe Overhead Rule
     */
    public void setJntVntrCatastropheOvhdRule( @Nullable final java.lang.String jntVntrCatastropheOvhdRule )
    {
        rememberChangedField("JntVntrCatastropheOvhdRule", this.jntVntrCatastropheOvhdRule);
        this.jntVntrCatastropheOvhdRule = jntVntrCatastropheOvhdRule;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>JVAOvhdPercentProdg</b>
     * </p>
     * 
     * @param jVAOvhdPercentProdg
     *            Percent 1 (% Producing U.S., % Regular Canada) (JVA)
     */
    public void setJVAOvhdPercentProdg( @Nullable final BigDecimal jVAOvhdPercentProdg )
    {
        rememberChangedField("JVAOvhdPercentProdg", this.jVAOvhdPercentProdg);
        this.jVAOvhdPercentProdg = jVAOvhdPercentProdg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JVAExclsnAcctSetPercentProdg</b>
     * </p>
     * 
     * @param jVAExclsnAcctSetPercentProdg
     *            Exclusion Set of Accounts - Percent 1 (JVA)
     */
    public void setJVAExclsnAcctSetPercentProdg( @Nullable final java.lang.String jVAExclsnAcctSetPercentProdg )
    {
        rememberChangedField("JVAExclsnAcctSetPercentProdg", this.jVAExclsnAcctSetPercentProdg);
        this.jVAExclsnAcctSetPercentProdg = jVAExclsnAcctSetPercentProdg;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>JVAOvhdPercentDev</b>
     * </p>
     * 
     * @param jVAOvhdPercentDev
     *            Percent 2 (% Development U.S., % Special Canada) (JVA)
     */
    public void setJVAOvhdPercentDev( @Nullable final BigDecimal jVAOvhdPercentDev )
    {
        rememberChangedField("JVAOvhdPercentDev", this.jVAOvhdPercentDev);
        this.jVAOvhdPercentDev = jVAOvhdPercentDev;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JVAExclsnAcctSetPercentDev</b>
     * </p>
     * 
     * @param jVAExclsnAcctSetPercentDev
     *            Exclusion Set of Accounts - Percent 2 (JVA)
     */
    public void setJVAExclsnAcctSetPercentDev( @Nullable final java.lang.String jVAExclsnAcctSetPercentDev )
    {
        rememberChangedField("JVAExclsnAcctSetPercentDev", this.jVAExclsnAcctSetPercentDev);
        this.jVAExclsnAcctSetPercentDev = jVAExclsnAcctSetPercentDev;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrExplorationOvhdRule</b>
     * </p>
     * 
     * @param jntVntrExplorationOvhdRule
     *            Exploration Overhead Rule
     */
    public void setJntVntrExplorationOvhdRule( @Nullable final java.lang.String jntVntrExplorationOvhdRule )
    {
        rememberChangedField("JntVntrExplorationOvhdRule", this.jntVntrExplorationOvhdRule);
        this.jntVntrExplorationOvhdRule = jntVntrExplorationOvhdRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrDrillingOvhdRule</b>
     * </p>
     * 
     * @param jntVntrDrillingOvhdRule
     *            Drilling Overhead Rule
     */
    public void setJntVntrDrillingOvhdRule( @Nullable final java.lang.String jntVntrDrillingOvhdRule )
    {
        rememberChangedField("JntVntrDrillingOvhdRule", this.jntVntrDrillingOvhdRule);
        this.jntVntrDrillingOvhdRule = jntVntrDrillingOvhdRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCapitalExclsnSet</b>
     * </p>
     * 
     * @param jntVntrCapitalExclsnSet
     *            Set of Accounts to Exclude from Capital Overhead Calc.
     */
    public void setJntVntrCapitalExclsnSet( @Nullable final java.lang.String jntVntrCapitalExclsnSet )
    {
        rememberChangedField("JntVntrCapitalExclsnSet", this.jntVntrCapitalExclsnSet);
        this.jntVntrCapitalExclsnSet = jntVntrCapitalExclsnSet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOvhdOffsetCostCtr</b>
     * </p>
     * 
     * @param jntVntrOvhdOffsetCostCtr
     *            Overhead Offset Cost Centre - JV
     */
    public void setJntVntrOvhdOffsetCostCtr( @Nullable final java.lang.String jntVntrOvhdOffsetCostCtr )
    {
        rememberChangedField("JntVntrOvhdOffsetCostCtr", this.jntVntrOvhdOffsetCostCtr);
        this.jntVntrOvhdOffsetCostCtr = jntVntrOvhdOffsetCostCtr;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtProdgWellThld</b>
     * </p>
     * 
     * @param jntOpgAgrmtProdgWellThld
     *            Perform Producing Well Threshold Calculation at JOA Level
     */
    public void setJntOpgAgrmtProdgWellThld( @Nullable final java.lang.Boolean jntOpgAgrmtProdgWellThld )
    {
        rememberChangedField("JntOpgAgrmtProdgWellThld", this.jntOpgAgrmtProdgWellThld);
        this.jntOpgAgrmtProdgWellThld = jntOpgAgrmtProdgWellThld;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOvhdRecurringDoc</b>
     * </p>
     * 
     * @param jntVntrOvhdRecurringDoc
     *            Recurring Document Number - JV overheads
     */
    public void setJntVntrOvhdRecurringDoc( @Nullable final java.lang.String jntVntrOvhdRecurringDoc )
    {
        rememberChangedField("JntVntrOvhdRecurringDoc", this.jntVntrOvhdRecurringDoc);
        this.jntVntrOvhdRecurringDoc = jntVntrOvhdRecurringDoc;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrExpnIsEscalated</b>
     * </p>
     * 
     * @param jntVntrExpnIsEscalated
     *            Escalatable
     */
    public void setJntVntrExpnIsEscalated( @Nullable final java.lang.Boolean jntVntrExpnIsEscalated )
    {
        rememberChangedField("JntVntrExpnIsEscalated", this.jntVntrExpnIsEscalated);
        this.jntVntrExpnIsEscalated = jntVntrExpnIsEscalated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtClass</b>
     * </p>
     * 
     * @param jntOpgAgrmtClass
     *            Joint Operating Agreement Class
     */
    public void setJntOpgAgrmtClass( @Nullable final java.lang.String jntOpgAgrmtClass )
    {
        rememberChangedField("JntOpgAgrmtClass", this.jntOpgAgrmtClass);
        this.jntOpgAgrmtClass = jntOpgAgrmtClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtCreatedByUser</b>
     * </p>
     * 
     * @param jntOpgAgrmtCreatedByUser
     *            User who Created
     */
    public void setJntOpgAgrmtCreatedByUser( @Nullable final java.lang.String jntOpgAgrmtCreatedByUser )
    {
        rememberChangedField("JntOpgAgrmtCreatedByUser", this.jntOpgAgrmtCreatedByUser);
        this.jntOpgAgrmtCreatedByUser = jntOpgAgrmtCreatedByUser;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtCreationTime</b>
     * </p>
     * 
     * @param jntOpgAgrmtCreationTime
     *            The jntOpgAgrmtCreationTime to set.
     */
    public void setJntOpgAgrmtCreationTime( @Nullable final LocalTime jntOpgAgrmtCreationTime )
    {
        rememberChangedField("JntOpgAgrmtCreationTime", this.jntOpgAgrmtCreationTime);
        this.jntOpgAgrmtCreationTime = jntOpgAgrmtCreationTime;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtCreationDate</b>
     * </p>
     * 
     * @param jntOpgAgrmtCreationDate
     *            The jntOpgAgrmtCreationDate to set.
     */
    public void setJntOpgAgrmtCreationDate( @Nullable final LocalDate jntOpgAgrmtCreationDate )
    {
        rememberChangedField("JntOpgAgrmtCreationDate", this.jntOpgAgrmtCreationDate);
        this.jntOpgAgrmtCreationDate = jntOpgAgrmtCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtLastChangedByUser</b>
     * </p>
     * 
     * @param jntOpgAgrmtLastChangedByUser
     *            User who Last Changed
     */
    public void setJntOpgAgrmtLastChangedByUser( @Nullable final java.lang.String jntOpgAgrmtLastChangedByUser )
    {
        rememberChangedField("JntOpgAgrmtLastChangedByUser", this.jntOpgAgrmtLastChangedByUser);
        this.jntOpgAgrmtLastChangedByUser = jntOpgAgrmtLastChangedByUser;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtLastChangedTime</b>
     * </p>
     * 
     * @param jntOpgAgrmtLastChangedTime
     *            The jntOpgAgrmtLastChangedTime to set.
     */
    public void setJntOpgAgrmtLastChangedTime( @Nullable final LocalTime jntOpgAgrmtLastChangedTime )
    {
        rememberChangedField("JntOpgAgrmtLastChangedTime", this.jntOpgAgrmtLastChangedTime);
        this.jntOpgAgrmtLastChangedTime = jntOpgAgrmtLastChangedTime;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtLastChangedDate</b>
     * </p>
     * 
     * @param jntOpgAgrmtLastChangedDate
     *            The jntOpgAgrmtLastChangedDate to set.
     */
    public void setJntOpgAgrmtLastChangedDate( @Nullable final LocalDate jntOpgAgrmtLastChangedDate )
    {
        rememberChangedField("JntOpgAgrmtLastChangedDate", this.jntOpgAgrmtLastChangedDate);
        this.jntOpgAgrmtLastChangedDate = jntOpgAgrmtLastChangedDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPrioPerdDrillingIsCalc</b>
     * </p>
     * 
     * @param jntVntrPrioPerdDrillingIsCalc
     *            Calculate Drilling Days using prior period.
     */
    public void setJntVntrPrioPerdDrillingIsCalc( @Nullable final java.lang.Boolean jntVntrPrioPerdDrillingIsCalc )
    {
        rememberChangedField("JntVntrPrioPerdDrillingIsCalc", this.jntVntrPrioPerdDrillingIsCalc);
        this.jntVntrPrioPerdDrillingIsCalc = jntVntrPrioPerdDrillingIsCalc;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrWBSElmntOvhdIsCalc</b>
     * </p>
     * 
     * @param jntVntrWBSElmntOvhdIsCalc
     *            Calculate all WBS elements for overhead
     */
    public void setJntVntrWBSElmntOvhdIsCalc( @Nullable final java.lang.Boolean jntVntrWBSElmntOvhdIsCalc )
    {
        rememberChangedField("JntVntrWBSElmntOvhdIsCalc", this.jntVntrWBSElmntOvhdIsCalc);
        this.jntVntrWBSElmntOvhdIsCalc = jntVntrWBSElmntOvhdIsCalc;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_JntOpgAgrmt";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("JntOpgAgrmt", getJntOpgAgrmt());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("JntOpgAgrmt", getJntOpgAgrmt());
        values.put("JntVntrContractNmbr", getJntVntrContractNmbr());
        values.put("JntVntrPayrollClearingSet", getJntVntrPayrollClearingSet());
        values.put("JntVntrConstructionExclsnSet", getJntVntrConstructionExclsnSet());
        values.put("JntVntrCatastropheExclsnSet", getJntVntrCatastropheExclsnSet());
        values.put("JntVntrConstructionOvhdRule", getJntVntrConstructionOvhdRule());
        values.put("JntVntrCatastropheOvhdRule", getJntVntrCatastropheOvhdRule());
        values.put("JVAOvhdPercentProdg", getJVAOvhdPercentProdg());
        values.put("JVAExclsnAcctSetPercentProdg", getJVAExclsnAcctSetPercentProdg());
        values.put("JVAOvhdPercentDev", getJVAOvhdPercentDev());
        values.put("JVAExclsnAcctSetPercentDev", getJVAExclsnAcctSetPercentDev());
        values.put("JntVntrExplorationOvhdRule", getJntVntrExplorationOvhdRule());
        values.put("JntVntrDrillingOvhdRule", getJntVntrDrillingOvhdRule());
        values.put("JntVntrCapitalExclsnSet", getJntVntrCapitalExclsnSet());
        values.put("JntVntrOvhdOffsetCostCtr", getJntVntrOvhdOffsetCostCtr());
        values.put("JntOpgAgrmtProdgWellThld", getJntOpgAgrmtProdgWellThld());
        values.put("JntVntrOvhdRecurringDoc", getJntVntrOvhdRecurringDoc());
        values.put("JntVntrExpnIsEscalated", getJntVntrExpnIsEscalated());
        values.put("JntOpgAgrmtClass", getJntOpgAgrmtClass());
        values.put("JntOpgAgrmtCreatedByUser", getJntOpgAgrmtCreatedByUser());
        values.put("JntOpgAgrmtCreationTime", getJntOpgAgrmtCreationTime());
        values.put("JntOpgAgrmtCreationDate", getJntOpgAgrmtCreationDate());
        values.put("JntOpgAgrmtLastChangedByUser", getJntOpgAgrmtLastChangedByUser());
        values.put("JntOpgAgrmtLastChangedTime", getJntOpgAgrmtLastChangedTime());
        values.put("JntOpgAgrmtLastChangedDate", getJntOpgAgrmtLastChangedDate());
        values.put("JntVntrPrioPerdDrillingIsCalc", getJntVntrPrioPerdDrillingIsCalc());
        values.put("JntVntrWBSElmntOvhdIsCalc", getJntVntrWBSElmntOvhdIsCalc());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmt") ) {
                final Object value = values.remove("JntOpgAgrmt");
                if( (value == null) || (!value.equals(getJntOpgAgrmt())) ) {
                    setJntOpgAgrmt(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrContractNmbr") ) {
                final Object value = values.remove("JntVntrContractNmbr");
                if( (value == null) || (!value.equals(getJntVntrContractNmbr())) ) {
                    setJntVntrContractNmbr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrPayrollClearingSet") ) {
                final Object value = values.remove("JntVntrPayrollClearingSet");
                if( (value == null) || (!value.equals(getJntVntrPayrollClearingSet())) ) {
                    setJntVntrPayrollClearingSet(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrConstructionExclsnSet") ) {
                final Object value = values.remove("JntVntrConstructionExclsnSet");
                if( (value == null) || (!value.equals(getJntVntrConstructionExclsnSet())) ) {
                    setJntVntrConstructionExclsnSet(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrCatastropheExclsnSet") ) {
                final Object value = values.remove("JntVntrCatastropheExclsnSet");
                if( (value == null) || (!value.equals(getJntVntrCatastropheExclsnSet())) ) {
                    setJntVntrCatastropheExclsnSet(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrConstructionOvhdRule") ) {
                final Object value = values.remove("JntVntrConstructionOvhdRule");
                if( (value == null) || (!value.equals(getJntVntrConstructionOvhdRule())) ) {
                    setJntVntrConstructionOvhdRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrCatastropheOvhdRule") ) {
                final Object value = values.remove("JntVntrCatastropheOvhdRule");
                if( (value == null) || (!value.equals(getJntVntrCatastropheOvhdRule())) ) {
                    setJntVntrCatastropheOvhdRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("JVAOvhdPercentProdg") ) {
                final Object value = values.remove("JVAOvhdPercentProdg");
                if( (value == null) || (!value.equals(getJVAOvhdPercentProdg())) ) {
                    setJVAOvhdPercentProdg(((BigDecimal) value));
                }
            }
            if( values.containsKey("JVAExclsnAcctSetPercentProdg") ) {
                final Object value = values.remove("JVAExclsnAcctSetPercentProdg");
                if( (value == null) || (!value.equals(getJVAExclsnAcctSetPercentProdg())) ) {
                    setJVAExclsnAcctSetPercentProdg(((java.lang.String) value));
                }
            }
            if( values.containsKey("JVAOvhdPercentDev") ) {
                final Object value = values.remove("JVAOvhdPercentDev");
                if( (value == null) || (!value.equals(getJVAOvhdPercentDev())) ) {
                    setJVAOvhdPercentDev(((BigDecimal) value));
                }
            }
            if( values.containsKey("JVAExclsnAcctSetPercentDev") ) {
                final Object value = values.remove("JVAExclsnAcctSetPercentDev");
                if( (value == null) || (!value.equals(getJVAExclsnAcctSetPercentDev())) ) {
                    setJVAExclsnAcctSetPercentDev(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrExplorationOvhdRule") ) {
                final Object value = values.remove("JntVntrExplorationOvhdRule");
                if( (value == null) || (!value.equals(getJntVntrExplorationOvhdRule())) ) {
                    setJntVntrExplorationOvhdRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrDrillingOvhdRule") ) {
                final Object value = values.remove("JntVntrDrillingOvhdRule");
                if( (value == null) || (!value.equals(getJntVntrDrillingOvhdRule())) ) {
                    setJntVntrDrillingOvhdRule(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrCapitalExclsnSet") ) {
                final Object value = values.remove("JntVntrCapitalExclsnSet");
                if( (value == null) || (!value.equals(getJntVntrCapitalExclsnSet())) ) {
                    setJntVntrCapitalExclsnSet(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrOvhdOffsetCostCtr") ) {
                final Object value = values.remove("JntVntrOvhdOffsetCostCtr");
                if( (value == null) || (!value.equals(getJntVntrOvhdOffsetCostCtr())) ) {
                    setJntVntrOvhdOffsetCostCtr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtProdgWellThld") ) {
                final Object value = values.remove("JntOpgAgrmtProdgWellThld");
                if( (value == null) || (!value.equals(getJntOpgAgrmtProdgWellThld())) ) {
                    setJntOpgAgrmtProdgWellThld(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrOvhdRecurringDoc") ) {
                final Object value = values.remove("JntVntrOvhdRecurringDoc");
                if( (value == null) || (!value.equals(getJntVntrOvhdRecurringDoc())) ) {
                    setJntVntrOvhdRecurringDoc(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrExpnIsEscalated") ) {
                final Object value = values.remove("JntVntrExpnIsEscalated");
                if( (value == null) || (!value.equals(getJntVntrExpnIsEscalated())) ) {
                    setJntVntrExpnIsEscalated(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtClass") ) {
                final Object value = values.remove("JntOpgAgrmtClass");
                if( (value == null) || (!value.equals(getJntOpgAgrmtClass())) ) {
                    setJntOpgAgrmtClass(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtCreatedByUser") ) {
                final Object value = values.remove("JntOpgAgrmtCreatedByUser");
                if( (value == null) || (!value.equals(getJntOpgAgrmtCreatedByUser())) ) {
                    setJntOpgAgrmtCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtCreationTime") ) {
                final Object value = values.remove("JntOpgAgrmtCreationTime");
                if( (value == null) || (!value.equals(getJntOpgAgrmtCreationTime())) ) {
                    setJntOpgAgrmtCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtCreationDate") ) {
                final Object value = values.remove("JntOpgAgrmtCreationDate");
                if( (value == null) || (!value.equals(getJntOpgAgrmtCreationDate())) ) {
                    setJntOpgAgrmtCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtLastChangedByUser") ) {
                final Object value = values.remove("JntOpgAgrmtLastChangedByUser");
                if( (value == null) || (!value.equals(getJntOpgAgrmtLastChangedByUser())) ) {
                    setJntOpgAgrmtLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtLastChangedTime") ) {
                final Object value = values.remove("JntOpgAgrmtLastChangedTime");
                if( (value == null) || (!value.equals(getJntOpgAgrmtLastChangedTime())) ) {
                    setJntOpgAgrmtLastChangedTime(((LocalTime) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtLastChangedDate") ) {
                final Object value = values.remove("JntOpgAgrmtLastChangedDate");
                if( (value == null) || (!value.equals(getJntOpgAgrmtLastChangedDate())) ) {
                    setJntOpgAgrmtLastChangedDate(((LocalDate) value));
                }
            }
            if( values.containsKey("JntVntrPrioPerdDrillingIsCalc") ) {
                final Object value = values.remove("JntVntrPrioPerdDrillingIsCalc");
                if( (value == null) || (!value.equals(getJntVntrPrioPerdDrillingIsCalc())) ) {
                    setJntVntrPrioPerdDrillingIsCalc(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrWBSElmntOvhdIsCalc") ) {
                final Object value = values.remove("JntVntrWBSElmntOvhdIsCalc");
                if( (value == null) || (!value.equals(getJntVntrWBSElmntOvhdIsCalc())) ) {
                    setJntVntrWBSElmntOvhdIsCalc(((java.lang.Boolean) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_JntOpgAgrmtEquityGrp") ) {
                final Object value = (values).remove("_JntOpgAgrmtEquityGrp");
                if( value instanceof Iterable ) {
                    if( to_JntOpgAgrmtEquityGrp == null ) {
                        to_JntOpgAgrmtEquityGrp = Lists.newArrayList();
                    } else {
                        to_JntOpgAgrmtEquityGrp = Lists.newArrayList(to_JntOpgAgrmtEquityGrp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JntOpgAgrmtEquityTypeGrp entity;
                        if( to_JntOpgAgrmtEquityGrp.size() > i ) {
                            entity = to_JntOpgAgrmtEquityGrp.get(i);
                        } else {
                            entity = new JntOpgAgrmtEquityTypeGrp();
                            to_JntOpgAgrmtEquityGrp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_JntOpgAgrmtPnltyCatRcvry") ) {
                final Object value = (values).remove("_JntOpgAgrmtPnltyCatRcvry");
                if( value instanceof Iterable ) {
                    if( to_JntOpgAgrmtPnltyCatRcvry == null ) {
                        to_JntOpgAgrmtPnltyCatRcvry = Lists.newArrayList();
                    } else {
                        to_JntOpgAgrmtPnltyCatRcvry = Lists.newArrayList(to_JntOpgAgrmtPnltyCatRcvry);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JntOpgAgrmtPnltyCatRcvry entity;
                        if( to_JntOpgAgrmtPnltyCatRcvry.size() > i ) {
                            entity = to_JntOpgAgrmtPnltyCatRcvry.get(i);
                        } else {
                            entity = new JntOpgAgrmtPnltyCatRcvry();
                            to_JntOpgAgrmtPnltyCatRcvry.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_JntOpgAgrmtText") ) {
                final Object value = (values).remove("_JntOpgAgrmtText");
                if( value instanceof Iterable ) {
                    if( to_JntOpgAgrmtText == null ) {
                        to_JntOpgAgrmtText = Lists.newArrayList();
                    } else {
                        to_JntOpgAgrmtText = Lists.newArrayList(to_JntOpgAgrmtText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JntOpgAgrmtText entity;
                        if( to_JntOpgAgrmtText.size() > i ) {
                            entity = to_JntOpgAgrmtText.get(i);
                        } else {
                            entity = new JntOpgAgrmtText();
                            to_JntOpgAgrmtText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return JointOperatingAgreementService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_JntOpgAgrmtEquityGrp != null ) {
            (values).put("_JntOpgAgrmtEquityGrp", to_JntOpgAgrmtEquityGrp);
        }
        if( to_JntOpgAgrmtPnltyCatRcvry != null ) {
            (values).put("_JntOpgAgrmtPnltyCatRcvry", to_JntOpgAgrmtPnltyCatRcvry);
        }
        if( to_JntOpgAgrmtText != null ) {
            (values).put("_JntOpgAgrmtText", to_JntOpgAgrmtText);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>JntOpgAgrmtEquityTypeGrp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_JntOpgAgrmtEquityGrp</b>.
     * <p>
     * If the navigation property for an entity <b>JntOpgAgrmt</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JntOpgAgrmtEquityGrp</b> is already loaded, the result
     *         will contain the <b>JntOpgAgrmtEquityTypeGrp</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JntOpgAgrmtEquityTypeGrp>> getJntOpgAgrmtEquityGrpIfPresent()
    {
        return Option.of(to_JntOpgAgrmtEquityGrp);
    }

    /**
     * Overwrites the list of associated <b>JntOpgAgrmtEquityTypeGrp</b> entities for the loaded navigation property
     * <b>_JntOpgAgrmtEquityGrp</b>.
     * <p>
     * If the navigation property <b>_JntOpgAgrmtEquityGrp</b> of a queried <b>JntOpgAgrmt</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>JntOpgAgrmtEquityTypeGrp</b> entities.
     */
    public void setJntOpgAgrmtEquityGrp( @Nonnull final List<JntOpgAgrmtEquityTypeGrp> value )
    {
        if( to_JntOpgAgrmtEquityGrp == null ) {
            to_JntOpgAgrmtEquityGrp = Lists.newArrayList();
        }
        to_JntOpgAgrmtEquityGrp.clear();
        to_JntOpgAgrmtEquityGrp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JntOpgAgrmtEquityTypeGrp</b> entities. This corresponds to the OData
     * navigation property <b>_JntOpgAgrmtEquityGrp</b>.
     * <p>
     * If the navigation property <b>_JntOpgAgrmtEquityGrp</b> of a queried <b>JntOpgAgrmt</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>JntOpgAgrmtEquityTypeGrp</b> entities.
     */
    public void addJntOpgAgrmtEquityGrp( JntOpgAgrmtEquityTypeGrp... entity )
    {
        if( to_JntOpgAgrmtEquityGrp == null ) {
            to_JntOpgAgrmtEquityGrp = Lists.newArrayList();
        }
        to_JntOpgAgrmtEquityGrp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>JntOpgAgrmtPnltyCatRcvry</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_JntOpgAgrmtPnltyCatRcvry</b>.
     * <p>
     * If the navigation property for an entity <b>JntOpgAgrmt</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JntOpgAgrmtPnltyCatRcvry</b> is already loaded, the result
     *         will contain the <b>JntOpgAgrmtPnltyCatRcvry</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JntOpgAgrmtPnltyCatRcvry>> getJntOpgAgrmtPnltyCatRcvryIfPresent()
    {
        return Option.of(to_JntOpgAgrmtPnltyCatRcvry);
    }

    /**
     * Overwrites the list of associated <b>JntOpgAgrmtPnltyCatRcvry</b> entities for the loaded navigation property
     * <b>_JntOpgAgrmtPnltyCatRcvry</b>.
     * <p>
     * If the navigation property <b>_JntOpgAgrmtPnltyCatRcvry</b> of a queried <b>JntOpgAgrmt</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>JntOpgAgrmtPnltyCatRcvry</b> entities.
     */
    public void setJntOpgAgrmtPnltyCatRcvry( @Nonnull final List<JntOpgAgrmtPnltyCatRcvry> value )
    {
        if( to_JntOpgAgrmtPnltyCatRcvry == null ) {
            to_JntOpgAgrmtPnltyCatRcvry = Lists.newArrayList();
        }
        to_JntOpgAgrmtPnltyCatRcvry.clear();
        to_JntOpgAgrmtPnltyCatRcvry.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JntOpgAgrmtPnltyCatRcvry</b> entities. This corresponds to the OData
     * navigation property <b>_JntOpgAgrmtPnltyCatRcvry</b>.
     * <p>
     * If the navigation property <b>_JntOpgAgrmtPnltyCatRcvry</b> of a queried <b>JntOpgAgrmt</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>JntOpgAgrmtPnltyCatRcvry</b> entities.
     */
    public void addJntOpgAgrmtPnltyCatRcvry( JntOpgAgrmtPnltyCatRcvry... entity )
    {
        if( to_JntOpgAgrmtPnltyCatRcvry == null ) {
            to_JntOpgAgrmtPnltyCatRcvry = Lists.newArrayList();
        }
        to_JntOpgAgrmtPnltyCatRcvry.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>JntOpgAgrmtText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_JntOpgAgrmtText</b>.
     * <p>
     * If the navigation property for an entity <b>JntOpgAgrmt</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JntOpgAgrmtText</b> is already loaded, the result will
     *         contain the <b>JntOpgAgrmtText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JntOpgAgrmtText>> getJntOpgAgrmtTextIfPresent()
    {
        return Option.of(to_JntOpgAgrmtText);
    }

    /**
     * Overwrites the list of associated <b>JntOpgAgrmtText</b> entities for the loaded navigation property
     * <b>_JntOpgAgrmtText</b>.
     * <p>
     * If the navigation property <b>_JntOpgAgrmtText</b> of a queried <b>JntOpgAgrmt</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>JntOpgAgrmtText</b> entities.
     */
    public void setJntOpgAgrmtText( @Nonnull final List<JntOpgAgrmtText> value )
    {
        if( to_JntOpgAgrmtText == null ) {
            to_JntOpgAgrmtText = Lists.newArrayList();
        }
        to_JntOpgAgrmtText.clear();
        to_JntOpgAgrmtText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JntOpgAgrmtText</b> entities. This corresponds to the OData navigation
     * property <b>_JntOpgAgrmtText</b>.
     * <p>
     * If the navigation property <b>_JntOpgAgrmtText</b> of a queried <b>JntOpgAgrmt</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>JntOpgAgrmtText</b> entities.
     */
    public void addJntOpgAgrmtText( JntOpgAgrmtText... entity )
    {
        if( to_JntOpgAgrmtText == null ) {
            to_JntOpgAgrmtText = Lists.newArrayList();
        }
        to_JntOpgAgrmtText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of JntOpgAgrmt instances.
     * 
     */
    public final static class JntOpgAgrmtBuilder
    {

        private List<JntOpgAgrmtEquityTypeGrp> to_JntOpgAgrmtEquityGrp = Lists.newArrayList();
        private List<JntOpgAgrmtPnltyCatRcvry> to_JntOpgAgrmtPnltyCatRcvry = Lists.newArrayList();
        private List<JntOpgAgrmtText> to_JntOpgAgrmtText = Lists.newArrayList();

        private JntOpgAgrmt.JntOpgAgrmtBuilder to_JntOpgAgrmtEquityGrp( final List<JntOpgAgrmtEquityTypeGrp> value )
        {
            to_JntOpgAgrmtEquityGrp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_JntOpgAgrmtEquityGrp</b> for <b>JntOpgAgrmt</b> to multiple
         * <b>JntOpgAgrmtEquityTypeGrp</b>.
         * 
         * @param value
         *            The JntOpgAgrmtEquityTypeGrps to build this JntOpgAgrmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmt.JntOpgAgrmtBuilder jntOpgAgrmtEquityGrp( JntOpgAgrmtEquityTypeGrp... value )
        {
            return to_JntOpgAgrmtEquityGrp(Lists.newArrayList(value));
        }

        private JntOpgAgrmt.JntOpgAgrmtBuilder to_JntOpgAgrmtPnltyCatRcvry( final List<JntOpgAgrmtPnltyCatRcvry> value )
        {
            to_JntOpgAgrmtPnltyCatRcvry.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_JntOpgAgrmtPnltyCatRcvry</b> for <b>JntOpgAgrmt</b> to multiple
         * <b>JntOpgAgrmtPnltyCatRcvry</b>.
         * 
         * @param value
         *            The JntOpgAgrmtPnltyCatRcvrys to build this JntOpgAgrmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmt.JntOpgAgrmtBuilder jntOpgAgrmtPnltyCatRcvry( JntOpgAgrmtPnltyCatRcvry... value )
        {
            return to_JntOpgAgrmtPnltyCatRcvry(Lists.newArrayList(value));
        }

        private JntOpgAgrmt.JntOpgAgrmtBuilder to_JntOpgAgrmtText( final List<JntOpgAgrmtText> value )
        {
            to_JntOpgAgrmtText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_JntOpgAgrmtText</b> for <b>JntOpgAgrmt</b> to multiple <b>JntOpgAgrmtText</b>.
         * 
         * @param value
         *            The JntOpgAgrmtTexts to build this JntOpgAgrmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmt.JntOpgAgrmtBuilder jntOpgAgrmtText( JntOpgAgrmtText... value )
        {
            return to_JntOpgAgrmtText(Lists.newArrayList(value));
        }

    }

}
