/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.JointOperatingAgreementService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Equity Group
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JntOpgAgrmtEquityTypeGrpType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class JntOpgAgrmtEquityTypeGrp extends VdmEntity<JntOpgAgrmtEquityTypeGrp> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_jntopgagrmt.v0001.A_JntOpgAgrmtEquityTypeGrpType";
    /**
     * Selector for all available fields of JntOpgAgrmtEquityTypeGrp.
     * 
     */
    public final static SimpleProperty<JntOpgAgrmtEquityTypeGrp> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<JntOpgAgrmtEquityTypeGrp> COMPANY_CODE =
        new SimpleProperty.String<JntOpgAgrmtEquityTypeGrp>(JntOpgAgrmtEquityTypeGrp.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @return Joint Operating Agreement
     */
    @Nullable
    @ElementName( "JntOpgAgrmt" )
    private java.lang.String jntOpgAgrmt;
    public final static SimpleProperty.String<JntOpgAgrmtEquityTypeGrp> JNT_OPG_AGRMT =
        new SimpleProperty.String<JntOpgAgrmtEquityTypeGrp>(JntOpgAgrmtEquityTypeGrp.class, "JntOpgAgrmt");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrp</b>
     * </p>
     * 
     * @return Equity Group - JOA level
     */
    @Nullable
    @ElementName( "JntOpgAgrmtEquityGrp" )
    private java.lang.String jntOpgAgrmtEquityGrp;
    public final static SimpleProperty.String<JntOpgAgrmtEquityTypeGrp> JNT_OPG_AGRMT_EQUITY_GRP =
        new SimpleProperty.String<JntOpgAgrmtEquityTypeGrp>(JntOpgAgrmtEquityTypeGrp.class, "JntOpgAgrmtEquityGrp");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrpText</b>
     * </p>
     * 
     * @return Equity Group Description
     */
    @Nullable
    @ElementName( "JntOpgAgrmtEquityGrpText" )
    private java.lang.String jntOpgAgrmtEquityGrpText;
    public final static SimpleProperty.String<JntOpgAgrmtEquityTypeGrp> JNT_OPG_AGRMT_EQUITY_GRP_TEXT =
        new SimpleProperty.String<JntOpgAgrmtEquityTypeGrp>(JntOpgAgrmtEquityTypeGrp.class, "JntOpgAgrmtEquityGrpText");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOperatedShare</b>
     * </p>
     * 
     * @return Operated Share
     */
    @Nullable
    @ElementName( "JntVntrOperatedShare" )
    @DecimalDescriptor( precision = 9, scale = 6 )
    private BigDecimal jntVntrOperatedShare;
    public final static SimpleProperty.NumericDecimal<JntOpgAgrmtEquityTypeGrp> JNT_VNTR_OPERATED_SHARE =
        new SimpleProperty.NumericDecimal<JntOpgAgrmtEquityTypeGrp>(
            JntOpgAgrmtEquityTypeGrp.class,
            "JntVntrOperatedShare");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNonOperatedShare</b>
     * </p>
     * 
     * @return Non-Operated Share
     */
    @Nullable
    @ElementName( "JntVntrNonOperatedShare" )
    @DecimalDescriptor( precision = 9, scale = 6 )
    private BigDecimal jntVntrNonOperatedShare;
    public final static SimpleProperty.NumericDecimal<JntOpgAgrmtEquityTypeGrp> JNT_VNTR_NON_OPERATED_SHARE =
        new SimpleProperty.NumericDecimal<JntOpgAgrmtEquityTypeGrp>(
            JntOpgAgrmtEquityTypeGrp.class,
            "JntVntrNonOperatedShare");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpIsSuspended</b>
     * </p>
     * 
     * @return Equity Group Suspended
     */
    @Nullable
    @ElementName( "JntVntrEquityGrpIsSuspended" )
    private java.lang.Boolean jntVntrEquityGrpIsSuspended;
    public final static SimpleProperty.Boolean<JntOpgAgrmtEquityTypeGrp> JNT_VNTR_EQUITY_GRP_IS_SUSPENDED =
        new SimpleProperty.Boolean<JntOpgAgrmtEquityTypeGrp>(
            JntOpgAgrmtEquityTypeGrp.class,
            "JntVntrEquityGrpIsSuspended");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpSuspendedPerd</b>
     * </p>
     * 
     * @return Equity Group Suspended Period
     */
    @Nullable
    @ElementName( "JntVntrEquityGrpSuspendedPerd" )
    private java.lang.String jntVntrEquityGrpSuspendedPerd;
    public final static SimpleProperty.String<JntOpgAgrmtEquityTypeGrp> JNT_VNTR_EQUITY_GRP_SUSPENDED_PERD =
        new SimpleProperty.String<JntOpgAgrmtEquityTypeGrp>(
            JntOpgAgrmtEquityTypeGrp.class,
            "JntVntrEquityGrpSuspendedPerd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpSuspendedYr</b>
     * </p>
     * 
     * @return JV Group Suspense Year
     */
    @Nullable
    @ElementName( "JntVntrEquityGrpSuspendedYr" )
    private java.lang.String jntVntrEquityGrpSuspendedYr;
    public final static SimpleProperty.String<JntOpgAgrmtEquityTypeGrp> JNT_VNTR_EQUITY_GRP_SUSPENDED_YR =
        new SimpleProperty.String<JntOpgAgrmtEquityTypeGrp>(
            JntOpgAgrmtEquityTypeGrp.class,
            "JntVntrEquityGrpSuspendedYr");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpIsNotSuspended</b>
     * </p>
     * 
     * @return JV Equity Group Unsuspensed
     */
    @Nullable
    @ElementName( "JntVntrEquityGrpIsNotSuspended" )
    private java.lang.Boolean jntVntrEquityGrpIsNotSuspended;
    public final static SimpleProperty.Boolean<JntOpgAgrmtEquityTypeGrp> JNT_VNTR_EQUITY_GRP_IS_NOT_SUSPENDED =
        new SimpleProperty.Boolean<JntOpgAgrmtEquityTypeGrp>(
            JntOpgAgrmtEquityTypeGrp.class,
            "JntVntrEquityGrpIsNotSuspended");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrGrpNotSuspendedPerd</b>
     * </p>
     * 
     * @return JV Group Unsuspensed Period
     */
    @Nullable
    @ElementName( "JntVntrGrpNotSuspendedPerd" )
    private java.lang.String jntVntrGrpNotSuspendedPerd;
    public final static SimpleProperty.String<JntOpgAgrmtEquityTypeGrp> JNT_VNTR_GRP_NOT_SUSPENDED_PERD =
        new SimpleProperty.String<JntOpgAgrmtEquityTypeGrp>(
            JntOpgAgrmtEquityTypeGrp.class,
            "JntVntrGrpNotSuspendedPerd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrGrpNotSuspendedYr</b>
     * </p>
     * 
     * @return JV Group Unsuspensed Year
     */
    @Nullable
    @ElementName( "JntVntrGrpNotSuspendedYr" )
    private java.lang.String jntVntrGrpNotSuspendedYr;
    public final static SimpleProperty.String<JntOpgAgrmtEquityTypeGrp> JNT_VNTR_GRP_NOT_SUSPENDED_YR =
        new SimpleProperty.String<JntOpgAgrmtEquityTypeGrp>(JntOpgAgrmtEquityTypeGrp.class, "JntVntrGrpNotSuspendedYr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNetProfitIntrstGrp</b>
     * </p>
     * 
     * @return JV Net Profit Interest Group
     */
    @Nullable
    @ElementName( "JntVntrNetProfitIntrstGrp" )
    private java.lang.String jntVntrNetProfitIntrstGrp;
    public final static SimpleProperty.String<JntOpgAgrmtEquityTypeGrp> JNT_VNTR_NET_PROFIT_INTRST_GRP =
        new SimpleProperty.String<JntOpgAgrmtEquityTypeGrp>(
            JntOpgAgrmtEquityTypeGrp.class,
            "JntVntrNetProfitIntrstGrp");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureType</b>
     * </p>
     * 
     * @return Venture Type
     */
    @Nullable
    @ElementName( "JointVentureType" )
    private java.lang.String jointVentureType;
    public final static SimpleProperty.String<JntOpgAgrmtEquityTypeGrp> JOINT_VENTURE_TYPE =
        new SimpleProperty.String<JntOpgAgrmtEquityTypeGrp>(JntOpgAgrmtEquityTypeGrp.class, "JointVentureType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntOpgAgrmtEquityTypeGrp, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntOpgAgrmtEquityTypeGrp, SAP__Message>(
            JntOpgAgrmtEquityTypeGrp.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_JntOpgAgrmt</b> for <b>JntOpgAgrmtEquityTypeGrp</b> to single <b>JntOpgAgrmt</b>.
     * 
     */
    @ElementName( "_JntOpgAgrmt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private JntOpgAgrmt to_JntOpgAgrmt;
    /**
     * Navigation property <b>_JntOpgAgrmtPartShr</b> for <b>JntOpgAgrmtEquityTypeGrp</b> to multiple
     * <b>JntOpgAgrmtPartShr</b>.
     * 
     */
    @ElementName( "_JntOpgAgrmtPartShr" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<JntOpgAgrmtPartShr> to_JntOpgAgrmtPartShr;
    /**
     * Use with available request builders to apply the <b>_JntOpgAgrmt</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JntOpgAgrmtEquityTypeGrp, JntOpgAgrmt> TO__JNT_OPG_AGRMT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JntOpgAgrmtEquityTypeGrp, JntOpgAgrmt>(
            JntOpgAgrmtEquityTypeGrp.class,
            "_JntOpgAgrmt",
            JntOpgAgrmt.class);
    /**
     * Use with available request builders to apply the <b>_JntOpgAgrmtPartShr</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JntOpgAgrmtEquityTypeGrp, JntOpgAgrmtPartShr> TO__JNT_OPG_AGRMT_PART_SHR =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<JntOpgAgrmtEquityTypeGrp, JntOpgAgrmtPartShr>(
            JntOpgAgrmtEquityTypeGrp.class,
            "_JntOpgAgrmtPartShr",
            JntOpgAgrmtPartShr.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<JntOpgAgrmtEquityTypeGrp> getType()
    {
        return JntOpgAgrmtEquityTypeGrp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     */
    public void setJntOpgAgrmt( @Nullable final java.lang.String jntOpgAgrmt )
    {
        rememberChangedField("JntOpgAgrmt", this.jntOpgAgrmt);
        this.jntOpgAgrmt = jntOpgAgrmt;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrp</b>
     * </p>
     * 
     * @param jntOpgAgrmtEquityGrp
     *            Equity Group - JOA level
     */
    public void setJntOpgAgrmtEquityGrp( @Nullable final java.lang.String jntOpgAgrmtEquityGrp )
    {
        rememberChangedField("JntOpgAgrmtEquityGrp", this.jntOpgAgrmtEquityGrp);
        this.jntOpgAgrmtEquityGrp = jntOpgAgrmtEquityGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrpText</b>
     * </p>
     * 
     * @param jntOpgAgrmtEquityGrpText
     *            Equity Group Description
     */
    public void setJntOpgAgrmtEquityGrpText( @Nullable final java.lang.String jntOpgAgrmtEquityGrpText )
    {
        rememberChangedField("JntOpgAgrmtEquityGrpText", this.jntOpgAgrmtEquityGrpText);
        this.jntOpgAgrmtEquityGrpText = jntOpgAgrmtEquityGrpText;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOperatedShare</b>
     * </p>
     * 
     * @param jntVntrOperatedShare
     *            Operated Share
     */
    public void setJntVntrOperatedShare( @Nullable final BigDecimal jntVntrOperatedShare )
    {
        rememberChangedField("JntVntrOperatedShare", this.jntVntrOperatedShare);
        this.jntVntrOperatedShare = jntVntrOperatedShare;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNonOperatedShare</b>
     * </p>
     * 
     * @param jntVntrNonOperatedShare
     *            Non-Operated Share
     */
    public void setJntVntrNonOperatedShare( @Nullable final BigDecimal jntVntrNonOperatedShare )
    {
        rememberChangedField("JntVntrNonOperatedShare", this.jntVntrNonOperatedShare);
        this.jntVntrNonOperatedShare = jntVntrNonOperatedShare;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpIsSuspended</b>
     * </p>
     * 
     * @param jntVntrEquityGrpIsSuspended
     *            Equity Group Suspended
     */
    public void setJntVntrEquityGrpIsSuspended( @Nullable final java.lang.Boolean jntVntrEquityGrpIsSuspended )
    {
        rememberChangedField("JntVntrEquityGrpIsSuspended", this.jntVntrEquityGrpIsSuspended);
        this.jntVntrEquityGrpIsSuspended = jntVntrEquityGrpIsSuspended;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpSuspendedPerd</b>
     * </p>
     * 
     * @param jntVntrEquityGrpSuspendedPerd
     *            Equity Group Suspended Period
     */
    public void setJntVntrEquityGrpSuspendedPerd( @Nullable final java.lang.String jntVntrEquityGrpSuspendedPerd )
    {
        rememberChangedField("JntVntrEquityGrpSuspendedPerd", this.jntVntrEquityGrpSuspendedPerd);
        this.jntVntrEquityGrpSuspendedPerd = jntVntrEquityGrpSuspendedPerd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpSuspendedYr</b>
     * </p>
     * 
     * @param jntVntrEquityGrpSuspendedYr
     *            JV Group Suspense Year
     */
    public void setJntVntrEquityGrpSuspendedYr( @Nullable final java.lang.String jntVntrEquityGrpSuspendedYr )
    {
        rememberChangedField("JntVntrEquityGrpSuspendedYr", this.jntVntrEquityGrpSuspendedYr);
        this.jntVntrEquityGrpSuspendedYr = jntVntrEquityGrpSuspendedYr;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityGrpIsNotSuspended</b>
     * </p>
     * 
     * @param jntVntrEquityGrpIsNotSuspended
     *            JV Equity Group Unsuspensed
     */
    public void setJntVntrEquityGrpIsNotSuspended( @Nullable final java.lang.Boolean jntVntrEquityGrpIsNotSuspended )
    {
        rememberChangedField("JntVntrEquityGrpIsNotSuspended", this.jntVntrEquityGrpIsNotSuspended);
        this.jntVntrEquityGrpIsNotSuspended = jntVntrEquityGrpIsNotSuspended;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrGrpNotSuspendedPerd</b>
     * </p>
     * 
     * @param jntVntrGrpNotSuspendedPerd
     *            JV Group Unsuspensed Period
     */
    public void setJntVntrGrpNotSuspendedPerd( @Nullable final java.lang.String jntVntrGrpNotSuspendedPerd )
    {
        rememberChangedField("JntVntrGrpNotSuspendedPerd", this.jntVntrGrpNotSuspendedPerd);
        this.jntVntrGrpNotSuspendedPerd = jntVntrGrpNotSuspendedPerd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrGrpNotSuspendedYr</b>
     * </p>
     * 
     * @param jntVntrGrpNotSuspendedYr
     *            JV Group Unsuspensed Year
     */
    public void setJntVntrGrpNotSuspendedYr( @Nullable final java.lang.String jntVntrGrpNotSuspendedYr )
    {
        rememberChangedField("JntVntrGrpNotSuspendedYr", this.jntVntrGrpNotSuspendedYr);
        this.jntVntrGrpNotSuspendedYr = jntVntrGrpNotSuspendedYr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNetProfitIntrstGrp</b>
     * </p>
     * 
     * @param jntVntrNetProfitIntrstGrp
     *            JV Net Profit Interest Group
     */
    public void setJntVntrNetProfitIntrstGrp( @Nullable final java.lang.String jntVntrNetProfitIntrstGrp )
    {
        rememberChangedField("JntVntrNetProfitIntrstGrp", this.jntVntrNetProfitIntrstGrp);
        this.jntVntrNetProfitIntrstGrp = jntVntrNetProfitIntrstGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureType</b>
     * </p>
     * 
     * @param jointVentureType
     *            Venture Type
     */
    public void setJointVentureType( @Nullable final java.lang.String jointVentureType )
    {
        rememberChangedField("JointVentureType", this.jointVentureType);
        this.jointVentureType = jointVentureType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_JntOpgAgrmtEquityTypeGrp";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("JntOpgAgrmt", getJntOpgAgrmt());
        entityKey.addKeyProperty("JntOpgAgrmtEquityGrp", getJntOpgAgrmtEquityGrp());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("JntOpgAgrmt", getJntOpgAgrmt());
        values.put("JntOpgAgrmtEquityGrp", getJntOpgAgrmtEquityGrp());
        values.put("JntOpgAgrmtEquityGrpText", getJntOpgAgrmtEquityGrpText());
        values.put("JntVntrOperatedShare", getJntVntrOperatedShare());
        values.put("JntVntrNonOperatedShare", getJntVntrNonOperatedShare());
        values.put("JntVntrEquityGrpIsSuspended", getJntVntrEquityGrpIsSuspended());
        values.put("JntVntrEquityGrpSuspendedPerd", getJntVntrEquityGrpSuspendedPerd());
        values.put("JntVntrEquityGrpSuspendedYr", getJntVntrEquityGrpSuspendedYr());
        values.put("JntVntrEquityGrpIsNotSuspended", getJntVntrEquityGrpIsNotSuspended());
        values.put("JntVntrGrpNotSuspendedPerd", getJntVntrGrpNotSuspendedPerd());
        values.put("JntVntrGrpNotSuspendedYr", getJntVntrGrpNotSuspendedYr());
        values.put("JntVntrNetProfitIntrstGrp", getJntVntrNetProfitIntrstGrp());
        values.put("JointVentureType", getJointVentureType());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmt") ) {
                final Object value = values.remove("JntOpgAgrmt");
                if( (value == null) || (!value.equals(getJntOpgAgrmt())) ) {
                    setJntOpgAgrmt(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtEquityGrp") ) {
                final Object value = values.remove("JntOpgAgrmtEquityGrp");
                if( (value == null) || (!value.equals(getJntOpgAgrmtEquityGrp())) ) {
                    setJntOpgAgrmtEquityGrp(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtEquityGrpText") ) {
                final Object value = values.remove("JntOpgAgrmtEquityGrpText");
                if( (value == null) || (!value.equals(getJntOpgAgrmtEquityGrpText())) ) {
                    setJntOpgAgrmtEquityGrpText(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrOperatedShare") ) {
                final Object value = values.remove("JntVntrOperatedShare");
                if( (value == null) || (!value.equals(getJntVntrOperatedShare())) ) {
                    setJntVntrOperatedShare(((BigDecimal) value));
                }
            }
            if( values.containsKey("JntVntrNonOperatedShare") ) {
                final Object value = values.remove("JntVntrNonOperatedShare");
                if( (value == null) || (!value.equals(getJntVntrNonOperatedShare())) ) {
                    setJntVntrNonOperatedShare(((BigDecimal) value));
                }
            }
            if( values.containsKey("JntVntrEquityGrpIsSuspended") ) {
                final Object value = values.remove("JntVntrEquityGrpIsSuspended");
                if( (value == null) || (!value.equals(getJntVntrEquityGrpIsSuspended())) ) {
                    setJntVntrEquityGrpIsSuspended(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrEquityGrpSuspendedPerd") ) {
                final Object value = values.remove("JntVntrEquityGrpSuspendedPerd");
                if( (value == null) || (!value.equals(getJntVntrEquityGrpSuspendedPerd())) ) {
                    setJntVntrEquityGrpSuspendedPerd(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrEquityGrpSuspendedYr") ) {
                final Object value = values.remove("JntVntrEquityGrpSuspendedYr");
                if( (value == null) || (!value.equals(getJntVntrEquityGrpSuspendedYr())) ) {
                    setJntVntrEquityGrpSuspendedYr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrEquityGrpIsNotSuspended") ) {
                final Object value = values.remove("JntVntrEquityGrpIsNotSuspended");
                if( (value == null) || (!value.equals(getJntVntrEquityGrpIsNotSuspended())) ) {
                    setJntVntrEquityGrpIsNotSuspended(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrGrpNotSuspendedPerd") ) {
                final Object value = values.remove("JntVntrGrpNotSuspendedPerd");
                if( (value == null) || (!value.equals(getJntVntrGrpNotSuspendedPerd())) ) {
                    setJntVntrGrpNotSuspendedPerd(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrGrpNotSuspendedYr") ) {
                final Object value = values.remove("JntVntrGrpNotSuspendedYr");
                if( (value == null) || (!value.equals(getJntVntrGrpNotSuspendedYr())) ) {
                    setJntVntrGrpNotSuspendedYr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrNetProfitIntrstGrp") ) {
                final Object value = values.remove("JntVntrNetProfitIntrstGrp");
                if( (value == null) || (!value.equals(getJntVntrNetProfitIntrstGrp())) ) {
                    setJntVntrNetProfitIntrstGrp(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVentureType") ) {
                final Object value = values.remove("JointVentureType");
                if( (value == null) || (!value.equals(getJointVentureType())) ) {
                    setJointVentureType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_JntOpgAgrmt") ) {
                final Object value = (values).remove("_JntOpgAgrmt");
                if( value instanceof Map ) {
                    if( to_JntOpgAgrmt == null ) {
                        to_JntOpgAgrmt = new JntOpgAgrmt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_JntOpgAgrmt.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_JntOpgAgrmtPartShr") ) {
                final Object value = (values).remove("_JntOpgAgrmtPartShr");
                if( value instanceof Iterable ) {
                    if( to_JntOpgAgrmtPartShr == null ) {
                        to_JntOpgAgrmtPartShr = Lists.newArrayList();
                    } else {
                        to_JntOpgAgrmtPartShr = Lists.newArrayList(to_JntOpgAgrmtPartShr);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        JntOpgAgrmtPartShr entity;
                        if( to_JntOpgAgrmtPartShr.size() > i ) {
                            entity = to_JntOpgAgrmtPartShr.get(i);
                        } else {
                            entity = new JntOpgAgrmtPartShr();
                            to_JntOpgAgrmtPartShr.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return JointOperatingAgreementService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_JntOpgAgrmt != null ) {
            (values).put("_JntOpgAgrmt", to_JntOpgAgrmt);
        }
        if( to_JntOpgAgrmtPartShr != null ) {
            (values).put("_JntOpgAgrmtPartShr", to_JntOpgAgrmtPartShr);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>JntOpgAgrmt</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_JntOpgAgrmt</b>.
     * <p>
     * If the navigation property for an entity <b>JntOpgAgrmtEquityTypeGrp</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JntOpgAgrmt</b> is already loaded, the result will contain
     *         the <b>JntOpgAgrmt</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<JntOpgAgrmt> getJntOpgAgrmtIfPresent()
    {
        return Option.of(to_JntOpgAgrmt);
    }

    /**
     * Overwrites the associated <b>JntOpgAgrmt</b> entity for the loaded navigation property <b>_JntOpgAgrmt</b>.
     * 
     * @param value
     *            New <b>JntOpgAgrmt</b> entity.
     */
    public void setJntOpgAgrmt( final JntOpgAgrmt value )
    {
        to_JntOpgAgrmt = value;
    }

    /**
     * Retrieval of associated <b>JntOpgAgrmtPartShr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_JntOpgAgrmtPartShr</b>.
     * <p>
     * If the navigation property for an entity <b>JntOpgAgrmtEquityTypeGrp</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JntOpgAgrmtPartShr</b> is already loaded, the result will
     *         contain the <b>JntOpgAgrmtPartShr</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<JntOpgAgrmtPartShr>> getJntOpgAgrmtPartShrIfPresent()
    {
        return Option.of(to_JntOpgAgrmtPartShr);
    }

    /**
     * Overwrites the list of associated <b>JntOpgAgrmtPartShr</b> entities for the loaded navigation property
     * <b>_JntOpgAgrmtPartShr</b>.
     * <p>
     * If the navigation property <b>_JntOpgAgrmtPartShr</b> of a queried <b>JntOpgAgrmtEquityTypeGrp</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>JntOpgAgrmtPartShr</b> entities.
     */
    public void setJntOpgAgrmtPartShr( @Nonnull final List<JntOpgAgrmtPartShr> value )
    {
        if( to_JntOpgAgrmtPartShr == null ) {
            to_JntOpgAgrmtPartShr = Lists.newArrayList();
        }
        to_JntOpgAgrmtPartShr.clear();
        to_JntOpgAgrmtPartShr.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>JntOpgAgrmtPartShr</b> entities. This corresponds to the OData
     * navigation property <b>_JntOpgAgrmtPartShr</b>.
     * <p>
     * If the navigation property <b>_JntOpgAgrmtPartShr</b> of a queried <b>JntOpgAgrmtEquityTypeGrp</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>JntOpgAgrmtPartShr</b> entities.
     */
    public void addJntOpgAgrmtPartShr( JntOpgAgrmtPartShr... entity )
    {
        if( to_JntOpgAgrmtPartShr == null ) {
            to_JntOpgAgrmtPartShr = Lists.newArrayList();
        }
        to_JntOpgAgrmtPartShr.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of JntOpgAgrmtEquityTypeGrp instances.
     * 
     */
    public final static class JntOpgAgrmtEquityTypeGrpBuilder
    {

        private JntOpgAgrmt to_JntOpgAgrmt;
        private java.lang.String jntOpgAgrmt = null;
        private List<JntOpgAgrmtPartShr> to_JntOpgAgrmtPartShr = Lists.newArrayList();

        private JntOpgAgrmtEquityTypeGrp.JntOpgAgrmtEquityTypeGrpBuilder to_JntOpgAgrmt( final JntOpgAgrmt value )
        {
            to_JntOpgAgrmt = value;
            return this;
        }

        /**
         * Navigation property <b>_JntOpgAgrmt</b> for <b>JntOpgAgrmtEquityTypeGrp</b> to single <b>JntOpgAgrmt</b>.
         * 
         * @param value
         *            The JntOpgAgrmt to build this JntOpgAgrmtEquityTypeGrp with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmtEquityTypeGrp.JntOpgAgrmtEquityTypeGrpBuilder jntOpgAgrmt( final JntOpgAgrmt value )
        {
            return to_JntOpgAgrmt(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
         * </p>
         * 
         * @param value
         *            The jntOpgAgrmt to build this JntOpgAgrmtEquityTypeGrp with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmtEquityTypeGrp.JntOpgAgrmtEquityTypeGrpBuilder jntOpgAgrmt( final java.lang.String value )
        {
            jntOpgAgrmt = value;
            return this;
        }

        private JntOpgAgrmtEquityTypeGrp.JntOpgAgrmtEquityTypeGrpBuilder to_JntOpgAgrmtPartShr(
            final List<JntOpgAgrmtPartShr> value )
        {
            to_JntOpgAgrmtPartShr.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_JntOpgAgrmtPartShr</b> for <b>JntOpgAgrmtEquityTypeGrp</b> to multiple
         * <b>JntOpgAgrmtPartShr</b>.
         * 
         * @param value
         *            The JntOpgAgrmtPartShrs to build this JntOpgAgrmtEquityTypeGrp with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmtEquityTypeGrp.JntOpgAgrmtEquityTypeGrpBuilder jntOpgAgrmtPartShr(
            JntOpgAgrmtPartShr... value )
        {
            return to_JntOpgAgrmtPartShr(Lists.newArrayList(value));
        }

    }

}
