/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.JointOperatingAgreementService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Partner Share
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JntOpgAgrmtPartShrType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class JntOpgAgrmtPartShr extends VdmEntity<JntOpgAgrmtPartShr> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_jntopgagrmt.v0001.A_JntOpgAgrmtPartShrType";
    /**
     * Selector for all available fields of JntOpgAgrmtPartShr.
     * 
     */
    public final static SimpleProperty<JntOpgAgrmtPartShr> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<JntOpgAgrmtPartShr> COMPANY_CODE =
        new SimpleProperty.String<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @return Joint Operating Agreement
     */
    @Nullable
    @ElementName( "JntOpgAgrmt" )
    private java.lang.String jntOpgAgrmt;
    public final static SimpleProperty.String<JntOpgAgrmtPartShr> JNT_OPG_AGRMT =
        new SimpleProperty.String<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntOpgAgrmt");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrp</b>
     * </p>
     * 
     * @return Equity Group - JOA level
     */
    @Nullable
    @ElementName( "JntOpgAgrmtEquityGrp" )
    private java.lang.String jntOpgAgrmtEquityGrp;
    public final static SimpleProperty.String<JntOpgAgrmtPartShr> JNT_OPG_AGRMT_EQUITY_GRP =
        new SimpleProperty.String<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntOpgAgrmtEquityGrp");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePartner</b>
     * </p>
     * 
     * @return JV partner
     */
    @Nullable
    @ElementName( "JointVenturePartner" )
    private java.lang.String jointVenturePartner;
    public final static SimpleProperty.String<JntOpgAgrmtPartShr> JOINT_VENTURE_PARTNER =
        new SimpleProperty.String<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JointVenturePartner");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityShare</b>
     * </p>
     * 
     * @return Equity Share
     */
    @Nullable
    @ElementName( "JntVntrEquityShare" )
    @DecimalDescriptor( precision = 9, scale = 6 )
    private BigDecimal jntVntrEquityShare;
    public final static SimpleProperty.NumericDecimal<JntOpgAgrmtPartShr> JNT_VNTR_EQUITY_SHARE =
        new SimpleProperty.NumericDecimal<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntVntrEquityShare");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrIsSuspended</b>
     * </p>
     * 
     * @return Owner Suspensed Flag
     */
    @Nullable
    @ElementName( "JntVntrOwnrIsSuspended" )
    private java.lang.Boolean jntVntrOwnrIsSuspended;
    public final static SimpleProperty.Boolean<JntOpgAgrmtPartShr> JNT_VNTR_OWNR_IS_SUSPENDED =
        new SimpleProperty.Boolean<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntVntrOwnrIsSuspended");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrSuspendedPerd</b>
     * </p>
     * 
     * @return JV Owner Suspensed
     */
    @Nullable
    @ElementName( "JntVntrOwnrSuspendedPerd" )
    private java.lang.String jntVntrOwnrSuspendedPerd;
    public final static SimpleProperty.String<JntOpgAgrmtPartShr> JNT_VNTR_OWNR_SUSPENDED_PERD =
        new SimpleProperty.String<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntVntrOwnrSuspendedPerd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrSuspendedYr</b>
     * </p>
     * 
     * @return JV Owner Suspensed Year
     */
    @Nullable
    @ElementName( "JntVntrOwnrSuspendedYr" )
    private java.lang.String jntVntrOwnrSuspendedYr;
    public final static SimpleProperty.String<JntOpgAgrmtPartShr> JNT_VNTR_OWNR_SUSPENDED_YR =
        new SimpleProperty.String<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntVntrOwnrSuspendedYr");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrIsNotSuspended</b>
     * </p>
     * 
     * @return JV Owner Unsuspensed
     */
    @Nullable
    @ElementName( "JntVntrOwnrIsNotSuspended" )
    private java.lang.Boolean jntVntrOwnrIsNotSuspended;
    public final static SimpleProperty.Boolean<JntOpgAgrmtPartShr> JNT_VNTR_OWNR_IS_NOT_SUSPENDED =
        new SimpleProperty.Boolean<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntVntrOwnrIsNotSuspended");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrNotSuspendedPerd</b>
     * </p>
     * 
     * @return JV Group Unsuspensed Period
     */
    @Nullable
    @ElementName( "JntVntrOwnrNotSuspendedPerd" )
    private java.lang.String jntVntrOwnrNotSuspendedPerd;
    public final static SimpleProperty.String<JntOpgAgrmtPartShr> JNT_VNTR_OWNR_NOT_SUSPENDED_PERD =
        new SimpleProperty.String<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntVntrOwnrNotSuspendedPerd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrNotSuspendedYr</b>
     * </p>
     * 
     * @return JV Group Unsuspensed Year
     */
    @Nullable
    @ElementName( "JntVntrOwnrNotSuspendedYr" )
    private java.lang.String jntVntrOwnrNotSuspendedYr;
    public final static SimpleProperty.String<JntOpgAgrmtPartShr> JNT_VNTR_OWNR_NOT_SUSPENDED_YR =
        new SimpleProperty.String<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntVntrOwnrNotSuspendedYr");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPayIsStppd</b>
     * </p>
     * 
     * @return JV Stop/Pay
     */
    @Nullable
    @ElementName( "JntVntrPayIsStppd" )
    private java.lang.Boolean jntVntrPayIsStppd;
    public final static SimpleProperty.Boolean<JntOpgAgrmtPartShr> JNT_VNTR_PAY_IS_STPPD =
        new SimpleProperty.Boolean<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntVntrPayIsStppd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOperatorAddressArea</b>
     * </p>
     * 
     * @return Operator address by area
     */
    @Nullable
    @ElementName( "JntVntrOperatorAddressArea" )
    private java.lang.String jntVntrOperatorAddressArea;
    public final static SimpleProperty.String<JntOpgAgrmtPartShr> JNT_VNTR_OPERATOR_ADDRESS_AREA =
        new SimpleProperty.String<JntOpgAgrmtPartShr>(JntOpgAgrmtPartShr.class, "JntVntrOperatorAddressArea");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntOpgAgrmtPartShr, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntOpgAgrmtPartShr, SAP__Message>(
            JntOpgAgrmtPartShr.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_JntOpgAgrmtEquityGrp</b> for <b>JntOpgAgrmtPartShr</b> to single
     * <b>JntOpgAgrmtEquityTypeGrp</b>.
     * 
     */
    @ElementName( "_JntOpgAgrmtEquityGrp" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private JntOpgAgrmtEquityTypeGrp to_JntOpgAgrmtEquityGrp;
    /**
     * Use with available request builders to apply the <b>_JntOpgAgrmtEquityGrp</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JntOpgAgrmtPartShr, JntOpgAgrmtEquityTypeGrp> TO__JNT_OPG_AGRMT_EQUITY_GRP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JntOpgAgrmtPartShr, JntOpgAgrmtEquityTypeGrp>(
            JntOpgAgrmtPartShr.class,
            "_JntOpgAgrmtEquityGrp",
            JntOpgAgrmtEquityTypeGrp.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<JntOpgAgrmtPartShr> getType()
    {
        return JntOpgAgrmtPartShr.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     */
    public void setJntOpgAgrmt( @Nullable final java.lang.String jntOpgAgrmt )
    {
        rememberChangedField("JntOpgAgrmt", this.jntOpgAgrmt);
        this.jntOpgAgrmt = jntOpgAgrmt;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrp</b>
     * </p>
     * 
     * @param jntOpgAgrmtEquityGrp
     *            Equity Group - JOA level
     */
    public void setJntOpgAgrmtEquityGrp( @Nullable final java.lang.String jntOpgAgrmtEquityGrp )
    {
        rememberChangedField("JntOpgAgrmtEquityGrp", this.jntOpgAgrmtEquityGrp);
        this.jntOpgAgrmtEquityGrp = jntOpgAgrmtEquityGrp;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePartner</b>
     * </p>
     * 
     * @param jointVenturePartner
     *            JV partner
     */
    public void setJointVenturePartner( @Nullable final java.lang.String jointVenturePartner )
    {
        rememberChangedField("JointVenturePartner", this.jointVenturePartner);
        this.jointVenturePartner = jointVenturePartner;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityShare</b>
     * </p>
     * 
     * @param jntVntrEquityShare
     *            Equity Share
     */
    public void setJntVntrEquityShare( @Nullable final BigDecimal jntVntrEquityShare )
    {
        rememberChangedField("JntVntrEquityShare", this.jntVntrEquityShare);
        this.jntVntrEquityShare = jntVntrEquityShare;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrIsSuspended</b>
     * </p>
     * 
     * @param jntVntrOwnrIsSuspended
     *            Owner Suspensed Flag
     */
    public void setJntVntrOwnrIsSuspended( @Nullable final java.lang.Boolean jntVntrOwnrIsSuspended )
    {
        rememberChangedField("JntVntrOwnrIsSuspended", this.jntVntrOwnrIsSuspended);
        this.jntVntrOwnrIsSuspended = jntVntrOwnrIsSuspended;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrSuspendedPerd</b>
     * </p>
     * 
     * @param jntVntrOwnrSuspendedPerd
     *            JV Owner Suspensed
     */
    public void setJntVntrOwnrSuspendedPerd( @Nullable final java.lang.String jntVntrOwnrSuspendedPerd )
    {
        rememberChangedField("JntVntrOwnrSuspendedPerd", this.jntVntrOwnrSuspendedPerd);
        this.jntVntrOwnrSuspendedPerd = jntVntrOwnrSuspendedPerd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrSuspendedYr</b>
     * </p>
     * 
     * @param jntVntrOwnrSuspendedYr
     *            JV Owner Suspensed Year
     */
    public void setJntVntrOwnrSuspendedYr( @Nullable final java.lang.String jntVntrOwnrSuspendedYr )
    {
        rememberChangedField("JntVntrOwnrSuspendedYr", this.jntVntrOwnrSuspendedYr);
        this.jntVntrOwnrSuspendedYr = jntVntrOwnrSuspendedYr;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrIsNotSuspended</b>
     * </p>
     * 
     * @param jntVntrOwnrIsNotSuspended
     *            JV Owner Unsuspensed
     */
    public void setJntVntrOwnrIsNotSuspended( @Nullable final java.lang.Boolean jntVntrOwnrIsNotSuspended )
    {
        rememberChangedField("JntVntrOwnrIsNotSuspended", this.jntVntrOwnrIsNotSuspended);
        this.jntVntrOwnrIsNotSuspended = jntVntrOwnrIsNotSuspended;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrNotSuspendedPerd</b>
     * </p>
     * 
     * @param jntVntrOwnrNotSuspendedPerd
     *            JV Group Unsuspensed Period
     */
    public void setJntVntrOwnrNotSuspendedPerd( @Nullable final java.lang.String jntVntrOwnrNotSuspendedPerd )
    {
        rememberChangedField("JntVntrOwnrNotSuspendedPerd", this.jntVntrOwnrNotSuspendedPerd);
        this.jntVntrOwnrNotSuspendedPerd = jntVntrOwnrNotSuspendedPerd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrNotSuspendedYr</b>
     * </p>
     * 
     * @param jntVntrOwnrNotSuspendedYr
     *            JV Group Unsuspensed Year
     */
    public void setJntVntrOwnrNotSuspendedYr( @Nullable final java.lang.String jntVntrOwnrNotSuspendedYr )
    {
        rememberChangedField("JntVntrOwnrNotSuspendedYr", this.jntVntrOwnrNotSuspendedYr);
        this.jntVntrOwnrNotSuspendedYr = jntVntrOwnrNotSuspendedYr;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPayIsStppd</b>
     * </p>
     * 
     * @param jntVntrPayIsStppd
     *            JV Stop/Pay
     */
    public void setJntVntrPayIsStppd( @Nullable final java.lang.Boolean jntVntrPayIsStppd )
    {
        rememberChangedField("JntVntrPayIsStppd", this.jntVntrPayIsStppd);
        this.jntVntrPayIsStppd = jntVntrPayIsStppd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOperatorAddressArea</b>
     * </p>
     * 
     * @param jntVntrOperatorAddressArea
     *            Operator address by area
     */
    public void setJntVntrOperatorAddressArea( @Nullable final java.lang.String jntVntrOperatorAddressArea )
    {
        rememberChangedField("JntVntrOperatorAddressArea", this.jntVntrOperatorAddressArea);
        this.jntVntrOperatorAddressArea = jntVntrOperatorAddressArea;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_JntOpgAgrmtPartShr";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("JntOpgAgrmt", getJntOpgAgrmt());
        entityKey.addKeyProperty("JntOpgAgrmtEquityGrp", getJntOpgAgrmtEquityGrp());
        entityKey.addKeyProperty("JointVenturePartner", getJointVenturePartner());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("JntOpgAgrmt", getJntOpgAgrmt());
        values.put("JntOpgAgrmtEquityGrp", getJntOpgAgrmtEquityGrp());
        values.put("JointVenturePartner", getJointVenturePartner());
        values.put("JntVntrEquityShare", getJntVntrEquityShare());
        values.put("JntVntrOwnrIsSuspended", getJntVntrOwnrIsSuspended());
        values.put("JntVntrOwnrSuspendedPerd", getJntVntrOwnrSuspendedPerd());
        values.put("JntVntrOwnrSuspendedYr", getJntVntrOwnrSuspendedYr());
        values.put("JntVntrOwnrIsNotSuspended", getJntVntrOwnrIsNotSuspended());
        values.put("JntVntrOwnrNotSuspendedPerd", getJntVntrOwnrNotSuspendedPerd());
        values.put("JntVntrOwnrNotSuspendedYr", getJntVntrOwnrNotSuspendedYr());
        values.put("JntVntrPayIsStppd", getJntVntrPayIsStppd());
        values.put("JntVntrOperatorAddressArea", getJntVntrOperatorAddressArea());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmt") ) {
                final Object value = values.remove("JntOpgAgrmt");
                if( (value == null) || (!value.equals(getJntOpgAgrmt())) ) {
                    setJntOpgAgrmt(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtEquityGrp") ) {
                final Object value = values.remove("JntOpgAgrmtEquityGrp");
                if( (value == null) || (!value.equals(getJntOpgAgrmtEquityGrp())) ) {
                    setJntOpgAgrmtEquityGrp(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVenturePartner") ) {
                final Object value = values.remove("JointVenturePartner");
                if( (value == null) || (!value.equals(getJointVenturePartner())) ) {
                    setJointVenturePartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrEquityShare") ) {
                final Object value = values.remove("JntVntrEquityShare");
                if( (value == null) || (!value.equals(getJntVntrEquityShare())) ) {
                    setJntVntrEquityShare(((BigDecimal) value));
                }
            }
            if( values.containsKey("JntVntrOwnrIsSuspended") ) {
                final Object value = values.remove("JntVntrOwnrIsSuspended");
                if( (value == null) || (!value.equals(getJntVntrOwnrIsSuspended())) ) {
                    setJntVntrOwnrIsSuspended(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrOwnrSuspendedPerd") ) {
                final Object value = values.remove("JntVntrOwnrSuspendedPerd");
                if( (value == null) || (!value.equals(getJntVntrOwnrSuspendedPerd())) ) {
                    setJntVntrOwnrSuspendedPerd(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrOwnrSuspendedYr") ) {
                final Object value = values.remove("JntVntrOwnrSuspendedYr");
                if( (value == null) || (!value.equals(getJntVntrOwnrSuspendedYr())) ) {
                    setJntVntrOwnrSuspendedYr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrOwnrIsNotSuspended") ) {
                final Object value = values.remove("JntVntrOwnrIsNotSuspended");
                if( (value == null) || (!value.equals(getJntVntrOwnrIsNotSuspended())) ) {
                    setJntVntrOwnrIsNotSuspended(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrOwnrNotSuspendedPerd") ) {
                final Object value = values.remove("JntVntrOwnrNotSuspendedPerd");
                if( (value == null) || (!value.equals(getJntVntrOwnrNotSuspendedPerd())) ) {
                    setJntVntrOwnrNotSuspendedPerd(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrOwnrNotSuspendedYr") ) {
                final Object value = values.remove("JntVntrOwnrNotSuspendedYr");
                if( (value == null) || (!value.equals(getJntVntrOwnrNotSuspendedYr())) ) {
                    setJntVntrOwnrNotSuspendedYr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrPayIsStppd") ) {
                final Object value = values.remove("JntVntrPayIsStppd");
                if( (value == null) || (!value.equals(getJntVntrPayIsStppd())) ) {
                    setJntVntrPayIsStppd(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrOperatorAddressArea") ) {
                final Object value = values.remove("JntVntrOperatorAddressArea");
                if( (value == null) || (!value.equals(getJntVntrOperatorAddressArea())) ) {
                    setJntVntrOperatorAddressArea(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_JntOpgAgrmtEquityGrp") ) {
                final Object value = (values).remove("_JntOpgAgrmtEquityGrp");
                if( value instanceof Map ) {
                    if( to_JntOpgAgrmtEquityGrp == null ) {
                        to_JntOpgAgrmtEquityGrp = new JntOpgAgrmtEquityTypeGrp();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_JntOpgAgrmtEquityGrp.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return JointOperatingAgreementService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_JntOpgAgrmtEquityGrp != null ) {
            (values).put("_JntOpgAgrmtEquityGrp", to_JntOpgAgrmtEquityGrp);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>JntOpgAgrmtEquityTypeGrp</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_JntOpgAgrmtEquityGrp</b>.
     * <p>
     * If the navigation property for an entity <b>JntOpgAgrmtPartShr</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JntOpgAgrmtEquityGrp</b> is already loaded, the result
     *         will contain the <b>JntOpgAgrmtEquityTypeGrp</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<JntOpgAgrmtEquityTypeGrp> getJntOpgAgrmtEquityGrpIfPresent()
    {
        return Option.of(to_JntOpgAgrmtEquityGrp);
    }

    /**
     * Overwrites the associated <b>JntOpgAgrmtEquityTypeGrp</b> entity for the loaded navigation property
     * <b>_JntOpgAgrmtEquityGrp</b>.
     * 
     * @param value
     *            New <b>JntOpgAgrmtEquityTypeGrp</b> entity.
     */
    public void setJntOpgAgrmtEquityGrp( final JntOpgAgrmtEquityTypeGrp value )
    {
        to_JntOpgAgrmtEquityGrp = value;
    }

    /**
     * Helper class to allow for fluent creation of JntOpgAgrmtPartShr instances.
     * 
     */
    public final static class JntOpgAgrmtPartShrBuilder
    {

        private JntOpgAgrmtEquityTypeGrp to_JntOpgAgrmtEquityGrp;
        private java.lang.String jntOpgAgrmtEquityGrp = null;

        private JntOpgAgrmtPartShr.JntOpgAgrmtPartShrBuilder to_JntOpgAgrmtEquityGrp(
            final JntOpgAgrmtEquityTypeGrp value )
        {
            to_JntOpgAgrmtEquityGrp = value;
            return this;
        }

        /**
         * Navigation property <b>_JntOpgAgrmtEquityGrp</b> for <b>JntOpgAgrmtPartShr</b> to single
         * <b>JntOpgAgrmtEquityTypeGrp</b>.
         * 
         * @param value
         *            The JntOpgAgrmtEquityTypeGrp to build this JntOpgAgrmtPartShr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmtPartShr.JntOpgAgrmtPartShrBuilder jntOpgAgrmtEquityGrp( final JntOpgAgrmtEquityTypeGrp value )
        {
            return to_JntOpgAgrmtEquityGrp(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 3
         * <p>
         * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrp</b>
         * </p>
         * 
         * @param value
         *            The jntOpgAgrmtEquityGrp to build this JntOpgAgrmtPartShr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmtPartShr.JntOpgAgrmtPartShrBuilder jntOpgAgrmtEquityGrp( final java.lang.String value )
        {
            jntOpgAgrmtEquityGrp = value;
            return this;
        }

    }

}
