/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.JointOperatingAgreementService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Penalty Category Recovery Percentage
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JntOpgAgrmtPnltyCatRcvryType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class JntOpgAgrmtPnltyCatRcvry extends VdmEntity<JntOpgAgrmtPnltyCatRcvry> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_jntopgagrmt.v0001.A_JntOpgAgrmtPnltyCatRcvryType";
    /**
     * Selector for all available fields of JntOpgAgrmtPnltyCatRcvry.
     * 
     */
    public final static SimpleProperty<JntOpgAgrmtPnltyCatRcvry> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<JntOpgAgrmtPnltyCatRcvry> COMPANY_CODE =
        new SimpleProperty.String<JntOpgAgrmtPnltyCatRcvry>(JntOpgAgrmtPnltyCatRcvry.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @return Joint Operating Agreement
     */
    @Nullable
    @ElementName( "JntOpgAgrmt" )
    private java.lang.String jntOpgAgrmt;
    public final static SimpleProperty.String<JntOpgAgrmtPnltyCatRcvry> JNT_OPG_AGRMT =
        new SimpleProperty.String<JntOpgAgrmtPnltyCatRcvry>(JntOpgAgrmtPnltyCatRcvry.class, "JntOpgAgrmt");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPenaltyCategory</b>
     * </p>
     * 
     * @return Penalty Category
     */
    @Nullable
    @ElementName( "JntVntrPenaltyCategory" )
    private java.lang.String jntVntrPenaltyCategory;
    public final static SimpleProperty.String<JntOpgAgrmtPnltyCatRcvry> JNT_VNTR_PENALTY_CATEGORY =
        new SimpleProperty.String<JntOpgAgrmtPnltyCatRcvry>(JntOpgAgrmtPnltyCatRcvry.class, "JntVntrPenaltyCategory");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNonSignatoryRcvryPct</b>
     * </p>
     * 
     * @return Non-signatory Recovery Percentage
     */
    @Nullable
    @ElementName( "JntVntrNonSignatoryRcvryPct" )
    @DecimalDescriptor( precision = 11, scale = 6 )
    private BigDecimal jntVntrNonSignatoryRcvryPct;
    public final static SimpleProperty.NumericDecimal<JntOpgAgrmtPnltyCatRcvry> JNT_VNTR_NON_SIGNATORY_RCVRY_PCT =
        new SimpleProperty.NumericDecimal<JntOpgAgrmtPnltyCatRcvry>(
            JntOpgAgrmtPnltyCatRcvry.class,
            "JntVntrNonSignatoryRcvryPct");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNonConsentRcvryPnltyPct</b>
     * </p>
     * 
     * @return Non-consent Recovery Penalty Percentage
     */
    @Nullable
    @ElementName( "JntVntrNonConsentRcvryPnltyPct" )
    @DecimalDescriptor( precision = 11, scale = 6 )
    private BigDecimal jntVntrNonConsentRcvryPnltyPct;
    public final static SimpleProperty.NumericDecimal<JntOpgAgrmtPnltyCatRcvry> JNT_VNTR_NON_CONSENT_RCVRY_PNLTY_PCT =
        new SimpleProperty.NumericDecimal<JntOpgAgrmtPnltyCatRcvry>(
            JntOpgAgrmtPnltyCatRcvry.class,
            "JntVntrNonConsentRcvryPnltyPct");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntOpgAgrmtPnltyCatRcvry, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntOpgAgrmtPnltyCatRcvry, SAP__Message>(
            JntOpgAgrmtPnltyCatRcvry.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_JntOpgAgrmt</b> for <b>JntOpgAgrmtPnltyCatRcvry</b> to single <b>JntOpgAgrmt</b>.
     * 
     */
    @ElementName( "_JntOpgAgrmt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private JntOpgAgrmt to_JntOpgAgrmt;
    /**
     * Use with available request builders to apply the <b>_JntOpgAgrmt</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JntOpgAgrmtPnltyCatRcvry, JntOpgAgrmt> TO__JNT_OPG_AGRMT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JntOpgAgrmtPnltyCatRcvry, JntOpgAgrmt>(
            JntOpgAgrmtPnltyCatRcvry.class,
            "_JntOpgAgrmt",
            JntOpgAgrmt.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<JntOpgAgrmtPnltyCatRcvry> getType()
    {
        return JntOpgAgrmtPnltyCatRcvry.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     */
    public void setJntOpgAgrmt( @Nullable final java.lang.String jntOpgAgrmt )
    {
        rememberChangedField("JntOpgAgrmt", this.jntOpgAgrmt);
        this.jntOpgAgrmt = jntOpgAgrmt;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPenaltyCategory</b>
     * </p>
     * 
     * @param jntVntrPenaltyCategory
     *            Penalty Category
     */
    public void setJntVntrPenaltyCategory( @Nullable final java.lang.String jntVntrPenaltyCategory )
    {
        rememberChangedField("JntVntrPenaltyCategory", this.jntVntrPenaltyCategory);
        this.jntVntrPenaltyCategory = jntVntrPenaltyCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNonSignatoryRcvryPct</b>
     * </p>
     * 
     * @param jntVntrNonSignatoryRcvryPct
     *            Non-signatory Recovery Percentage
     */
    public void setJntVntrNonSignatoryRcvryPct( @Nullable final BigDecimal jntVntrNonSignatoryRcvryPct )
    {
        rememberChangedField("JntVntrNonSignatoryRcvryPct", this.jntVntrNonSignatoryRcvryPct);
        this.jntVntrNonSignatoryRcvryPct = jntVntrNonSignatoryRcvryPct;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNonConsentRcvryPnltyPct</b>
     * </p>
     * 
     * @param jntVntrNonConsentRcvryPnltyPct
     *            Non-consent Recovery Penalty Percentage
     */
    public void setJntVntrNonConsentRcvryPnltyPct( @Nullable final BigDecimal jntVntrNonConsentRcvryPnltyPct )
    {
        rememberChangedField("JntVntrNonConsentRcvryPnltyPct", this.jntVntrNonConsentRcvryPnltyPct);
        this.jntVntrNonConsentRcvryPnltyPct = jntVntrNonConsentRcvryPnltyPct;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_JntOpgAgrmtPnltyCatRcvry";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("JntOpgAgrmt", getJntOpgAgrmt());
        entityKey.addKeyProperty("JntVntrPenaltyCategory", getJntVntrPenaltyCategory());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("JntOpgAgrmt", getJntOpgAgrmt());
        values.put("JntVntrPenaltyCategory", getJntVntrPenaltyCategory());
        values.put("JntVntrNonSignatoryRcvryPct", getJntVntrNonSignatoryRcvryPct());
        values.put("JntVntrNonConsentRcvryPnltyPct", getJntVntrNonConsentRcvryPnltyPct());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmt") ) {
                final Object value = values.remove("JntOpgAgrmt");
                if( (value == null) || (!value.equals(getJntOpgAgrmt())) ) {
                    setJntOpgAgrmt(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrPenaltyCategory") ) {
                final Object value = values.remove("JntVntrPenaltyCategory");
                if( (value == null) || (!value.equals(getJntVntrPenaltyCategory())) ) {
                    setJntVntrPenaltyCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrNonSignatoryRcvryPct") ) {
                final Object value = values.remove("JntVntrNonSignatoryRcvryPct");
                if( (value == null) || (!value.equals(getJntVntrNonSignatoryRcvryPct())) ) {
                    setJntVntrNonSignatoryRcvryPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("JntVntrNonConsentRcvryPnltyPct") ) {
                final Object value = values.remove("JntVntrNonConsentRcvryPnltyPct");
                if( (value == null) || (!value.equals(getJntVntrNonConsentRcvryPnltyPct())) ) {
                    setJntVntrNonConsentRcvryPnltyPct(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_JntOpgAgrmt") ) {
                final Object value = (values).remove("_JntOpgAgrmt");
                if( value instanceof Map ) {
                    if( to_JntOpgAgrmt == null ) {
                        to_JntOpgAgrmt = new JntOpgAgrmt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_JntOpgAgrmt.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return JointOperatingAgreementService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_JntOpgAgrmt != null ) {
            (values).put("_JntOpgAgrmt", to_JntOpgAgrmt);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>JntOpgAgrmt</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_JntOpgAgrmt</b>.
     * <p>
     * If the navigation property for an entity <b>JntOpgAgrmtPnltyCatRcvry</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JntOpgAgrmt</b> is already loaded, the result will contain
     *         the <b>JntOpgAgrmt</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<JntOpgAgrmt> getJntOpgAgrmtIfPresent()
    {
        return Option.of(to_JntOpgAgrmt);
    }

    /**
     * Overwrites the associated <b>JntOpgAgrmt</b> entity for the loaded navigation property <b>_JntOpgAgrmt</b>.
     * 
     * @param value
     *            New <b>JntOpgAgrmt</b> entity.
     */
    public void setJntOpgAgrmt( final JntOpgAgrmt value )
    {
        to_JntOpgAgrmt = value;
    }

    /**
     * Helper class to allow for fluent creation of JntOpgAgrmtPnltyCatRcvry instances.
     * 
     */
    public final static class JntOpgAgrmtPnltyCatRcvryBuilder
    {

        private JntOpgAgrmt to_JntOpgAgrmt;
        private java.lang.String jntOpgAgrmt = null;

        private JntOpgAgrmtPnltyCatRcvry.JntOpgAgrmtPnltyCatRcvryBuilder to_JntOpgAgrmt( final JntOpgAgrmt value )
        {
            to_JntOpgAgrmt = value;
            return this;
        }

        /**
         * Navigation property <b>_JntOpgAgrmt</b> for <b>JntOpgAgrmtPnltyCatRcvry</b> to single <b>JntOpgAgrmt</b>.
         * 
         * @param value
         *            The JntOpgAgrmt to build this JntOpgAgrmtPnltyCatRcvry with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmtPnltyCatRcvry.JntOpgAgrmtPnltyCatRcvryBuilder jntOpgAgrmt( final JntOpgAgrmt value )
        {
            return to_JntOpgAgrmt(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
         * </p>
         * 
         * @param value
         *            The jntOpgAgrmt to build this JntOpgAgrmtPnltyCatRcvry with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmtPnltyCatRcvry.JntOpgAgrmtPnltyCatRcvryBuilder jntOpgAgrmt( final java.lang.String value )
        {
            jntOpgAgrmt = value;
            return this;
        }

    }

}
