/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.JointOperatingAgreementService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Description
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JntOpgAgrmtTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class JntOpgAgrmtText extends VdmEntity<JntOpgAgrmtText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_jntopgagrmt.v0001.A_JntOpgAgrmtTextType";
    /**
     * Selector for all available fields of JntOpgAgrmtText.
     * 
     */
    public final static SimpleProperty<JntOpgAgrmtText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<JntOpgAgrmtText> COMPANY_CODE =
        new SimpleProperty.String<JntOpgAgrmtText>(JntOpgAgrmtText.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<JntOpgAgrmtText> LANGUAGE =
        new SimpleProperty.String<JntOpgAgrmtText>(JntOpgAgrmtText.class, "Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @return Joint Operating Agreement
     */
    @Nullable
    @ElementName( "JntOpgAgrmt" )
    private java.lang.String jntOpgAgrmt;
    public final static SimpleProperty.String<JntOpgAgrmtText> JNT_OPG_AGRMT =
        new SimpleProperty.String<JntOpgAgrmtText>(JntOpgAgrmtText.class, "JntOpgAgrmt");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtText</b>
     * </p>
     * 
     * @return JOA Description
     */
    @Nullable
    @ElementName( "JntOpgAgrmtText" )
    private java.lang.String jntOpgAgrmtText;
    public final static SimpleProperty.String<JntOpgAgrmtText> JNT_OPG_AGRMT_TEXT =
        new SimpleProperty.String<JntOpgAgrmtText>(JntOpgAgrmtText.class, "JntOpgAgrmtText");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtLongText</b>
     * </p>
     * 
     * @return JOA long text (80 Char)
     */
    @Nullable
    @ElementName( "JntOpgAgrmtLongText" )
    private java.lang.String jntOpgAgrmtLongText;
    public final static SimpleProperty.String<JntOpgAgrmtText> JNT_OPG_AGRMT_LONG_TEXT =
        new SimpleProperty.String<JntOpgAgrmtText>(JntOpgAgrmtText.class, "JntOpgAgrmtLongText");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntOpgAgrmtText, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntOpgAgrmtText, SAP__Message>(
            JntOpgAgrmtText.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_JntOpgAgrmt</b> for <b>JntOpgAgrmtText</b> to single <b>JntOpgAgrmt</b>.
     * 
     */
    @ElementName( "_JntOpgAgrmt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private JntOpgAgrmt to_JntOpgAgrmt;
    /**
     * Use with available request builders to apply the <b>_JntOpgAgrmt</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JntOpgAgrmtText, JntOpgAgrmt> TO__JNT_OPG_AGRMT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JntOpgAgrmtText, JntOpgAgrmt>(
            JntOpgAgrmtText.class,
            "_JntOpgAgrmt",
            JntOpgAgrmt.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<JntOpgAgrmtText> getType()
    {
        return JntOpgAgrmtText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
     * </p>
     * 
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     */
    public void setJntOpgAgrmt( @Nullable final java.lang.String jntOpgAgrmt )
    {
        rememberChangedField("JntOpgAgrmt", this.jntOpgAgrmt);
        this.jntOpgAgrmt = jntOpgAgrmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtText</b>
     * </p>
     * 
     * @param jntOpgAgrmtText
     *            JOA Description
     */
    public void setJntOpgAgrmtText( @Nullable final java.lang.String jntOpgAgrmtText )
    {
        rememberChangedField("JntOpgAgrmtText", this.jntOpgAgrmtText);
        this.jntOpgAgrmtText = jntOpgAgrmtText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtLongText</b>
     * </p>
     * 
     * @param jntOpgAgrmtLongText
     *            JOA long text (80 Char)
     */
    public void setJntOpgAgrmtLongText( @Nullable final java.lang.String jntOpgAgrmtLongText )
    {
        rememberChangedField("JntOpgAgrmtLongText", this.jntOpgAgrmtLongText);
        this.jntOpgAgrmtLongText = jntOpgAgrmtLongText;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_JntOpgAgrmtText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("Language", getLanguage());
        entityKey.addKeyProperty("JntOpgAgrmt", getJntOpgAgrmt());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("Language", getLanguage());
        values.put("JntOpgAgrmt", getJntOpgAgrmt());
        values.put("JntOpgAgrmtText", getJntOpgAgrmtText());
        values.put("JntOpgAgrmtLongText", getJntOpgAgrmtLongText());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmt") ) {
                final Object value = values.remove("JntOpgAgrmt");
                if( (value == null) || (!value.equals(getJntOpgAgrmt())) ) {
                    setJntOpgAgrmt(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtText") ) {
                final Object value = values.remove("JntOpgAgrmtText");
                if( (value == null) || (!value.equals(getJntOpgAgrmtText())) ) {
                    setJntOpgAgrmtText(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtLongText") ) {
                final Object value = values.remove("JntOpgAgrmtLongText");
                if( (value == null) || (!value.equals(getJntOpgAgrmtLongText())) ) {
                    setJntOpgAgrmtLongText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_JntOpgAgrmt") ) {
                final Object value = (values).remove("_JntOpgAgrmt");
                if( value instanceof Map ) {
                    if( to_JntOpgAgrmt == null ) {
                        to_JntOpgAgrmt = new JntOpgAgrmt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_JntOpgAgrmt.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return JointOperatingAgreementService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_JntOpgAgrmt != null ) {
            (values).put("_JntOpgAgrmt", to_JntOpgAgrmt);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>JntOpgAgrmt</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_JntOpgAgrmt</b>.
     * <p>
     * If the navigation property for an entity <b>JntOpgAgrmtText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JntOpgAgrmt</b> is already loaded, the result will contain
     *         the <b>JntOpgAgrmt</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<JntOpgAgrmt> getJntOpgAgrmtIfPresent()
    {
        return Option.of(to_JntOpgAgrmt);
    }

    /**
     * Overwrites the associated <b>JntOpgAgrmt</b> entity for the loaded navigation property <b>_JntOpgAgrmt</b>.
     * 
     * @param value
     *            New <b>JntOpgAgrmt</b> entity.
     */
    public void setJntOpgAgrmt( final JntOpgAgrmt value )
    {
        to_JntOpgAgrmt = value;
    }

    /**
     * Helper class to allow for fluent creation of JntOpgAgrmtText instances.
     * 
     */
    public final static class JntOpgAgrmtTextBuilder
    {

        private JntOpgAgrmt to_JntOpgAgrmt;
        private java.lang.String jntOpgAgrmt = null;

        private JntOpgAgrmtText.JntOpgAgrmtTextBuilder to_JntOpgAgrmt( final JntOpgAgrmt value )
        {
            to_JntOpgAgrmt = value;
            return this;
        }

        /**
         * Navigation property <b>_JntOpgAgrmt</b> for <b>JntOpgAgrmtText</b> to single <b>JntOpgAgrmt</b>.
         * 
         * @param value
         *            The JntOpgAgrmt to build this JntOpgAgrmtText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmtText.JntOpgAgrmtTextBuilder jntOpgAgrmt( final JntOpgAgrmt value )
        {
            return to_JntOpgAgrmt(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>JntOpgAgrmt</b>
         * </p>
         * 
         * @param value
         *            The jntOpgAgrmt to build this JntOpgAgrmtText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntOpgAgrmtText.JntOpgAgrmtTextBuilder jntOpgAgrmt( final java.lang.String value )
        {
            jntOpgAgrmt = value;
            return this;
        }

    }

}
