/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointventure;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.JointVentureService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Partner Share
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_JntVntrPartEquityShrType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class JntVntrPartEquityShr extends VdmEntity<JntVntrPartEquityShr> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_jointventure.v0001.A_JntVntrPartEquityShrType";
    /**
     * Selector for all available fields of JntVntrPartEquityShr.
     * 
     */
    public final static SimpleProperty<JntVntrPartEquityShr> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<JntVntrPartEquityShr> COMPANY_CODE =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     * 
     * @return Joint Venture
     */
    @Nullable
    @ElementName( "JointVenture" )
    private java.lang.String jointVenture;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JOINT_VENTURE =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JointVenture");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrp</b>
     * </p>
     * 
     * @return Equity Group
     */
    @Nullable
    @ElementName( "JntOpgAgrmtEquityGrp" )
    private java.lang.String jntOpgAgrmtEquityGrp;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_OPG_AGRMT_EQUITY_GRP =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntOpgAgrmtEquityGrp");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePartner</b>
     * </p>
     * 
     * @return JV partner
     */
    @Nullable
    @ElementName( "JointVenturePartner" )
    private java.lang.String jointVenturePartner;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JOINT_VENTURE_PARTNER =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JointVenturePartner");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePartnerShortText</b>
     * </p>
     * 
     * @return Name of Customer
     */
    @Nullable
    @ElementName( "JointVenturePartnerShortText" )
    private java.lang.String jointVenturePartnerShortText;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JOINT_VENTURE_PARTNER_SHORT_TEXT =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JointVenturePartnerShortText");
    /**
     * Constraints: Not nullable, Maximum length: 220
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePartnerLongText</b>
     * </p>
     * 
     * @return Customer Full Name
     */
    @Nullable
    @ElementName( "JointVenturePartnerLongText" )
    private java.lang.String jointVenturePartnerLongText;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JOINT_VENTURE_PARTNER_LONG_TEXT =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JointVenturePartnerLongText");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityShare</b>
     * </p>
     * 
     * @return Equity Share
     */
    @Nullable
    @ElementName( "JntVntrEquityShare" )
    @DecimalDescriptor( precision = 9, scale = 6 )
    private BigDecimal jntVntrEquityShare;
    public final static SimpleProperty.NumericDecimal<JntVntrPartEquityShr> JNT_VNTR_EQUITY_SHARE =
        new SimpleProperty.NumericDecimal<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrEquityShare");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrIsSuspended</b>
     * </p>
     * 
     * @return Owner Suspensed Flag
     */
    @Nullable
    @ElementName( "JntVntrOwnrIsSuspended" )
    private java.lang.Boolean jntVntrOwnrIsSuspended;
    public final static SimpleProperty.Boolean<JntVntrPartEquityShr> JNT_VNTR_OWNR_IS_SUSPENDED =
        new SimpleProperty.Boolean<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrOwnrIsSuspended");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrSuspendedPerd</b>
     * </p>
     * 
     * @return JV Owner Suspensed
     */
    @Nullable
    @ElementName( "JntVntrOwnrSuspendedPerd" )
    private java.lang.String jntVntrOwnrSuspendedPerd;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_VNTR_OWNR_SUSPENDED_PERD =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrOwnrSuspendedPerd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrSuspendedYr</b>
     * </p>
     * 
     * @return JV Owner Suspensed Year
     */
    @Nullable
    @ElementName( "JntVntrOwnrSuspendedYr" )
    private java.lang.String jntVntrOwnrSuspendedYr;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_VNTR_OWNR_SUSPENDED_YR =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrOwnrSuspendedYr");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrIsNotSuspended</b>
     * </p>
     * 
     * @return JV Owner Unsuspensed
     */
    @Nullable
    @ElementName( "JntVntrOwnrIsNotSuspended" )
    private java.lang.Boolean jntVntrOwnrIsNotSuspended;
    public final static SimpleProperty.Boolean<JntVntrPartEquityShr> JNT_VNTR_OWNR_IS_NOT_SUSPENDED =
        new SimpleProperty.Boolean<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrOwnrIsNotSuspended");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrNotSuspendedPerd</b>
     * </p>
     * 
     * @return JV Group Unsuspensed Period
     */
    @Nullable
    @ElementName( "JntVntrOwnrNotSuspendedPerd" )
    private java.lang.String jntVntrOwnrNotSuspendedPerd;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_VNTR_OWNR_NOT_SUSPENDED_PERD =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrOwnrNotSuspendedPerd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrNotSuspendedYr</b>
     * </p>
     * 
     * @return JV Group Unsuspensed Year
     */
    @Nullable
    @ElementName( "JntVntrOwnrNotSuspendedYr" )
    private java.lang.String jntVntrOwnrNotSuspendedYr;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_VNTR_OWNR_NOT_SUSPENDED_YR =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrOwnrNotSuspendedYr");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrInterestType</b>
     * </p>
     * 
     * @return Interest Type
     */
    @Nullable
    @ElementName( "JntVntrInterestType" )
    private java.lang.String jntVntrInterestType;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_VNTR_INTEREST_TYPE =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrInterestType");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrDrillingRcvryPercent</b>
     * </p>
     * 
     * @return JV Drilling Recovery Percentage
     */
    @Nullable
    @ElementName( "JntVntrDrillingRcvryPercent" )
    @DecimalDescriptor( precision = 9, scale = 6 )
    private BigDecimal jntVntrDrillingRcvryPercent;
    public final static SimpleProperty.NumericDecimal<JntVntrPartEquityShr> JNT_VNTR_DRILLING_RCVRY_PERCENT =
        new SimpleProperty.NumericDecimal<JntVntrPartEquityShr>(
            JntVntrPartEquityShr.class,
            "JntVntrDrillingRcvryPercent");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOpgRcvryPercent</b>
     * </p>
     * 
     * @return JV Operating Recovery Percentage
     */
    @Nullable
    @ElementName( "JntVntrOpgRcvryPercent" )
    @DecimalDescriptor( precision = 9, scale = 6 )
    private BigDecimal jntVntrOpgRcvryPercent;
    public final static SimpleProperty.NumericDecimal<JntVntrPartEquityShr> JNT_VNTR_OPG_RCVRY_PERCENT =
        new SimpleProperty.NumericDecimal<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrOpgRcvryPercent");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPayIsStppd</b>
     * </p>
     * 
     * @return JV Stop/Pay
     */
    @Nullable
    @ElementName( "JntVntrPayIsStppd" )
    private java.lang.Boolean jntVntrPayIsStppd;
    public final static SimpleProperty.Boolean<JntVntrPartEquityShr> JNT_VNTR_PAY_IS_STPPD =
        new SimpleProperty.Boolean<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrPayIsStppd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPartWrkgIntrstPerd</b>
     * </p>
     * 
     * @return Period when CI partner becomes Working interest
     */
    @Nullable
    @ElementName( "JntVntrPartWrkgIntrstPerd" )
    private java.lang.String jntVntrPartWrkgIntrstPerd;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_VNTR_PART_WRKG_INTRST_PERD =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrPartWrkgIntrstPerd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPartWrkgIntrstYr</b>
     * </p>
     * 
     * @return Year when CI partner becomes Working interest
     */
    @Nullable
    @ElementName( "JntVntrPartWrkgIntrstYr" )
    private java.lang.String jntVntrPartWrkgIntrstYr;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_VNTR_PART_WRKG_INTRST_YR =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrPartWrkgIntrstYr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCarriedIntrstGrp</b>
     * </p>
     * 
     * @return JV Carried Interest Group
     */
    @Nullable
    @ElementName( "JntVntrCarriedIntrstGrp" )
    private java.lang.String jntVntrCarriedIntrstGrp;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_VNTR_CARRIED_INTRST_GRP =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrCarriedIntrstGrp");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNetProfitIntrstGrp</b>
     * </p>
     * 
     * @return JV Net Profit Interest Group
     */
    @Nullable
    @ElementName( "JntVntrNetProfitIntrstGrp" )
    private java.lang.String jntVntrNetProfitIntrstGrp;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_VNTR_NET_PROFIT_INTRST_GRP =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrNetProfitIntrstGrp");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOperatorAddressArea</b>
     * </p>
     * 
     * @return Operator address by area
     */
    @Nullable
    @ElementName( "JntVntrOperatorAddressArea" )
    private java.lang.String jntVntrOperatorAddressArea;
    public final static SimpleProperty.String<JntVntrPartEquityShr> JNT_VNTR_OPERATOR_ADDRESS_AREA =
        new SimpleProperty.String<JntVntrPartEquityShr>(JntVntrPartEquityShr.class, "JntVntrOperatorAddressArea");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntVntrPartEquityShr, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<JntVntrPartEquityShr, SAP__Message>(
            JntVntrPartEquityShr.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_JointVentureEquityGroup</b> for <b>JntVntrPartEquityShr</b> to single
     * <b>JointVentureEquityGroup</b>.
     * 
     */
    @ElementName( "_JointVentureEquityGroup" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private JointVentureEquityGroup to_JointVentureEquityGroup;
    /**
     * Use with available request builders to apply the <b>_JointVentureEquityGroup</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JntVntrPartEquityShr, JointVentureEquityGroup> TO__JOINT_VENTURE_EQUITY_GROUP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<JntVntrPartEquityShr, JointVentureEquityGroup>(
            JntVntrPartEquityShr.class,
            "_JointVentureEquityGroup",
            JointVentureEquityGroup.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<JntVntrPartEquityShr> getType()
    {
        return JntVntrPartEquityShr.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     * 
     * @param jointVenture
     *            Joint Venture
     */
    public void setJointVenture( @Nullable final java.lang.String jointVenture )
    {
        rememberChangedField("JointVenture", this.jointVenture);
        this.jointVenture = jointVenture;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntOpgAgrmtEquityGrp</b>
     * </p>
     * 
     * @param jntOpgAgrmtEquityGrp
     *            Equity Group
     */
    public void setJntOpgAgrmtEquityGrp( @Nullable final java.lang.String jntOpgAgrmtEquityGrp )
    {
        rememberChangedField("JntOpgAgrmtEquityGrp", this.jntOpgAgrmtEquityGrp);
        this.jntOpgAgrmtEquityGrp = jntOpgAgrmtEquityGrp;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePartner</b>
     * </p>
     * 
     * @param jointVenturePartner
     *            JV partner
     */
    public void setJointVenturePartner( @Nullable final java.lang.String jointVenturePartner )
    {
        rememberChangedField("JointVenturePartner", this.jointVenturePartner);
        this.jointVenturePartner = jointVenturePartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePartnerShortText</b>
     * </p>
     * 
     * @param jointVenturePartnerShortText
     *            Name of Customer
     */
    public void setJointVenturePartnerShortText( @Nullable final java.lang.String jointVenturePartnerShortText )
    {
        rememberChangedField("JointVenturePartnerShortText", this.jointVenturePartnerShortText);
        this.jointVenturePartnerShortText = jointVenturePartnerShortText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 220
     * <p>
     * Original property name from the Odata EDM: <b>JointVenturePartnerLongText</b>
     * </p>
     * 
     * @param jointVenturePartnerLongText
     *            Customer Full Name
     */
    public void setJointVenturePartnerLongText( @Nullable final java.lang.String jointVenturePartnerLongText )
    {
        rememberChangedField("JointVenturePartnerLongText", this.jointVenturePartnerLongText);
        this.jointVenturePartnerLongText = jointVenturePartnerLongText;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrEquityShare</b>
     * </p>
     * 
     * @param jntVntrEquityShare
     *            Equity Share
     */
    public void setJntVntrEquityShare( @Nullable final BigDecimal jntVntrEquityShare )
    {
        rememberChangedField("JntVntrEquityShare", this.jntVntrEquityShare);
        this.jntVntrEquityShare = jntVntrEquityShare;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrIsSuspended</b>
     * </p>
     * 
     * @param jntVntrOwnrIsSuspended
     *            Owner Suspensed Flag
     */
    public void setJntVntrOwnrIsSuspended( @Nullable final java.lang.Boolean jntVntrOwnrIsSuspended )
    {
        rememberChangedField("JntVntrOwnrIsSuspended", this.jntVntrOwnrIsSuspended);
        this.jntVntrOwnrIsSuspended = jntVntrOwnrIsSuspended;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrSuspendedPerd</b>
     * </p>
     * 
     * @param jntVntrOwnrSuspendedPerd
     *            JV Owner Suspensed
     */
    public void setJntVntrOwnrSuspendedPerd( @Nullable final java.lang.String jntVntrOwnrSuspendedPerd )
    {
        rememberChangedField("JntVntrOwnrSuspendedPerd", this.jntVntrOwnrSuspendedPerd);
        this.jntVntrOwnrSuspendedPerd = jntVntrOwnrSuspendedPerd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrSuspendedYr</b>
     * </p>
     * 
     * @param jntVntrOwnrSuspendedYr
     *            JV Owner Suspensed Year
     */
    public void setJntVntrOwnrSuspendedYr( @Nullable final java.lang.String jntVntrOwnrSuspendedYr )
    {
        rememberChangedField("JntVntrOwnrSuspendedYr", this.jntVntrOwnrSuspendedYr);
        this.jntVntrOwnrSuspendedYr = jntVntrOwnrSuspendedYr;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrIsNotSuspended</b>
     * </p>
     * 
     * @param jntVntrOwnrIsNotSuspended
     *            JV Owner Unsuspensed
     */
    public void setJntVntrOwnrIsNotSuspended( @Nullable final java.lang.Boolean jntVntrOwnrIsNotSuspended )
    {
        rememberChangedField("JntVntrOwnrIsNotSuspended", this.jntVntrOwnrIsNotSuspended);
        this.jntVntrOwnrIsNotSuspended = jntVntrOwnrIsNotSuspended;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrNotSuspendedPerd</b>
     * </p>
     * 
     * @param jntVntrOwnrNotSuspendedPerd
     *            JV Group Unsuspensed Period
     */
    public void setJntVntrOwnrNotSuspendedPerd( @Nullable final java.lang.String jntVntrOwnrNotSuspendedPerd )
    {
        rememberChangedField("JntVntrOwnrNotSuspendedPerd", this.jntVntrOwnrNotSuspendedPerd);
        this.jntVntrOwnrNotSuspendedPerd = jntVntrOwnrNotSuspendedPerd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOwnrNotSuspendedYr</b>
     * </p>
     * 
     * @param jntVntrOwnrNotSuspendedYr
     *            JV Group Unsuspensed Year
     */
    public void setJntVntrOwnrNotSuspendedYr( @Nullable final java.lang.String jntVntrOwnrNotSuspendedYr )
    {
        rememberChangedField("JntVntrOwnrNotSuspendedYr", this.jntVntrOwnrNotSuspendedYr);
        this.jntVntrOwnrNotSuspendedYr = jntVntrOwnrNotSuspendedYr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrInterestType</b>
     * </p>
     * 
     * @param jntVntrInterestType
     *            Interest Type
     */
    public void setJntVntrInterestType( @Nullable final java.lang.String jntVntrInterestType )
    {
        rememberChangedField("JntVntrInterestType", this.jntVntrInterestType);
        this.jntVntrInterestType = jntVntrInterestType;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrDrillingRcvryPercent</b>
     * </p>
     * 
     * @param jntVntrDrillingRcvryPercent
     *            JV Drilling Recovery Percentage
     */
    public void setJntVntrDrillingRcvryPercent( @Nullable final BigDecimal jntVntrDrillingRcvryPercent )
    {
        rememberChangedField("JntVntrDrillingRcvryPercent", this.jntVntrDrillingRcvryPercent);
        this.jntVntrDrillingRcvryPercent = jntVntrDrillingRcvryPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOpgRcvryPercent</b>
     * </p>
     * 
     * @param jntVntrOpgRcvryPercent
     *            JV Operating Recovery Percentage
     */
    public void setJntVntrOpgRcvryPercent( @Nullable final BigDecimal jntVntrOpgRcvryPercent )
    {
        rememberChangedField("JntVntrOpgRcvryPercent", this.jntVntrOpgRcvryPercent);
        this.jntVntrOpgRcvryPercent = jntVntrOpgRcvryPercent;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPayIsStppd</b>
     * </p>
     * 
     * @param jntVntrPayIsStppd
     *            JV Stop/Pay
     */
    public void setJntVntrPayIsStppd( @Nullable final java.lang.Boolean jntVntrPayIsStppd )
    {
        rememberChangedField("JntVntrPayIsStppd", this.jntVntrPayIsStppd);
        this.jntVntrPayIsStppd = jntVntrPayIsStppd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPartWrkgIntrstPerd</b>
     * </p>
     * 
     * @param jntVntrPartWrkgIntrstPerd
     *            Period when CI partner becomes Working interest
     */
    public void setJntVntrPartWrkgIntrstPerd( @Nullable final java.lang.String jntVntrPartWrkgIntrstPerd )
    {
        rememberChangedField("JntVntrPartWrkgIntrstPerd", this.jntVntrPartWrkgIntrstPerd);
        this.jntVntrPartWrkgIntrstPerd = jntVntrPartWrkgIntrstPerd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrPartWrkgIntrstYr</b>
     * </p>
     * 
     * @param jntVntrPartWrkgIntrstYr
     *            Year when CI partner becomes Working interest
     */
    public void setJntVntrPartWrkgIntrstYr( @Nullable final java.lang.String jntVntrPartWrkgIntrstYr )
    {
        rememberChangedField("JntVntrPartWrkgIntrstYr", this.jntVntrPartWrkgIntrstYr);
        this.jntVntrPartWrkgIntrstYr = jntVntrPartWrkgIntrstYr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrCarriedIntrstGrp</b>
     * </p>
     * 
     * @param jntVntrCarriedIntrstGrp
     *            JV Carried Interest Group
     */
    public void setJntVntrCarriedIntrstGrp( @Nullable final java.lang.String jntVntrCarriedIntrstGrp )
    {
        rememberChangedField("JntVntrCarriedIntrstGrp", this.jntVntrCarriedIntrstGrp);
        this.jntVntrCarriedIntrstGrp = jntVntrCarriedIntrstGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrNetProfitIntrstGrp</b>
     * </p>
     * 
     * @param jntVntrNetProfitIntrstGrp
     *            JV Net Profit Interest Group
     */
    public void setJntVntrNetProfitIntrstGrp( @Nullable final java.lang.String jntVntrNetProfitIntrstGrp )
    {
        rememberChangedField("JntVntrNetProfitIntrstGrp", this.jntVntrNetProfitIntrstGrp);
        this.jntVntrNetProfitIntrstGrp = jntVntrNetProfitIntrstGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrOperatorAddressArea</b>
     * </p>
     * 
     * @param jntVntrOperatorAddressArea
     *            Operator address by area
     */
    public void setJntVntrOperatorAddressArea( @Nullable final java.lang.String jntVntrOperatorAddressArea )
    {
        rememberChangedField("JntVntrOperatorAddressArea", this.jntVntrOperatorAddressArea);
        this.jntVntrOperatorAddressArea = jntVntrOperatorAddressArea;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_JntVntrPartEquityShr";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CompanyCode", getCompanyCode());
        entityKey.addKeyProperty("JointVenture", getJointVenture());
        entityKey.addKeyProperty("JntOpgAgrmtEquityGrp", getJntOpgAgrmtEquityGrp());
        entityKey.addKeyProperty("JointVenturePartner", getJointVenturePartner());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("JointVenture", getJointVenture());
        values.put("JntOpgAgrmtEquityGrp", getJntOpgAgrmtEquityGrp());
        values.put("JointVenturePartner", getJointVenturePartner());
        values.put("JointVenturePartnerShortText", getJointVenturePartnerShortText());
        values.put("JointVenturePartnerLongText", getJointVenturePartnerLongText());
        values.put("JntVntrEquityShare", getJntVntrEquityShare());
        values.put("JntVntrOwnrIsSuspended", getJntVntrOwnrIsSuspended());
        values.put("JntVntrOwnrSuspendedPerd", getJntVntrOwnrSuspendedPerd());
        values.put("JntVntrOwnrSuspendedYr", getJntVntrOwnrSuspendedYr());
        values.put("JntVntrOwnrIsNotSuspended", getJntVntrOwnrIsNotSuspended());
        values.put("JntVntrOwnrNotSuspendedPerd", getJntVntrOwnrNotSuspendedPerd());
        values.put("JntVntrOwnrNotSuspendedYr", getJntVntrOwnrNotSuspendedYr());
        values.put("JntVntrInterestType", getJntVntrInterestType());
        values.put("JntVntrDrillingRcvryPercent", getJntVntrDrillingRcvryPercent());
        values.put("JntVntrOpgRcvryPercent", getJntVntrOpgRcvryPercent());
        values.put("JntVntrPayIsStppd", getJntVntrPayIsStppd());
        values.put("JntVntrPartWrkgIntrstPerd", getJntVntrPartWrkgIntrstPerd());
        values.put("JntVntrPartWrkgIntrstYr", getJntVntrPartWrkgIntrstYr());
        values.put("JntVntrCarriedIntrstGrp", getJntVntrCarriedIntrstGrp());
        values.put("JntVntrNetProfitIntrstGrp", getJntVntrNetProfitIntrstGrp());
        values.put("JntVntrOperatorAddressArea", getJntVntrOperatorAddressArea());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVenture") ) {
                final Object value = values.remove("JointVenture");
                if( (value == null) || (!value.equals(getJointVenture())) ) {
                    setJointVenture(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntOpgAgrmtEquityGrp") ) {
                final Object value = values.remove("JntOpgAgrmtEquityGrp");
                if( (value == null) || (!value.equals(getJntOpgAgrmtEquityGrp())) ) {
                    setJntOpgAgrmtEquityGrp(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVenturePartner") ) {
                final Object value = values.remove("JointVenturePartner");
                if( (value == null) || (!value.equals(getJointVenturePartner())) ) {
                    setJointVenturePartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVenturePartnerShortText") ) {
                final Object value = values.remove("JointVenturePartnerShortText");
                if( (value == null) || (!value.equals(getJointVenturePartnerShortText())) ) {
                    setJointVenturePartnerShortText(((java.lang.String) value));
                }
            }
            if( values.containsKey("JointVenturePartnerLongText") ) {
                final Object value = values.remove("JointVenturePartnerLongText");
                if( (value == null) || (!value.equals(getJointVenturePartnerLongText())) ) {
                    setJointVenturePartnerLongText(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrEquityShare") ) {
                final Object value = values.remove("JntVntrEquityShare");
                if( (value == null) || (!value.equals(getJntVntrEquityShare())) ) {
                    setJntVntrEquityShare(((BigDecimal) value));
                }
            }
            if( values.containsKey("JntVntrOwnrIsSuspended") ) {
                final Object value = values.remove("JntVntrOwnrIsSuspended");
                if( (value == null) || (!value.equals(getJntVntrOwnrIsSuspended())) ) {
                    setJntVntrOwnrIsSuspended(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrOwnrSuspendedPerd") ) {
                final Object value = values.remove("JntVntrOwnrSuspendedPerd");
                if( (value == null) || (!value.equals(getJntVntrOwnrSuspendedPerd())) ) {
                    setJntVntrOwnrSuspendedPerd(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrOwnrSuspendedYr") ) {
                final Object value = values.remove("JntVntrOwnrSuspendedYr");
                if( (value == null) || (!value.equals(getJntVntrOwnrSuspendedYr())) ) {
                    setJntVntrOwnrSuspendedYr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrOwnrIsNotSuspended") ) {
                final Object value = values.remove("JntVntrOwnrIsNotSuspended");
                if( (value == null) || (!value.equals(getJntVntrOwnrIsNotSuspended())) ) {
                    setJntVntrOwnrIsNotSuspended(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrOwnrNotSuspendedPerd") ) {
                final Object value = values.remove("JntVntrOwnrNotSuspendedPerd");
                if( (value == null) || (!value.equals(getJntVntrOwnrNotSuspendedPerd())) ) {
                    setJntVntrOwnrNotSuspendedPerd(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrOwnrNotSuspendedYr") ) {
                final Object value = values.remove("JntVntrOwnrNotSuspendedYr");
                if( (value == null) || (!value.equals(getJntVntrOwnrNotSuspendedYr())) ) {
                    setJntVntrOwnrNotSuspendedYr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrInterestType") ) {
                final Object value = values.remove("JntVntrInterestType");
                if( (value == null) || (!value.equals(getJntVntrInterestType())) ) {
                    setJntVntrInterestType(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrDrillingRcvryPercent") ) {
                final Object value = values.remove("JntVntrDrillingRcvryPercent");
                if( (value == null) || (!value.equals(getJntVntrDrillingRcvryPercent())) ) {
                    setJntVntrDrillingRcvryPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("JntVntrOpgRcvryPercent") ) {
                final Object value = values.remove("JntVntrOpgRcvryPercent");
                if( (value == null) || (!value.equals(getJntVntrOpgRcvryPercent())) ) {
                    setJntVntrOpgRcvryPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("JntVntrPayIsStppd") ) {
                final Object value = values.remove("JntVntrPayIsStppd");
                if( (value == null) || (!value.equals(getJntVntrPayIsStppd())) ) {
                    setJntVntrPayIsStppd(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("JntVntrPartWrkgIntrstPerd") ) {
                final Object value = values.remove("JntVntrPartWrkgIntrstPerd");
                if( (value == null) || (!value.equals(getJntVntrPartWrkgIntrstPerd())) ) {
                    setJntVntrPartWrkgIntrstPerd(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrPartWrkgIntrstYr") ) {
                final Object value = values.remove("JntVntrPartWrkgIntrstYr");
                if( (value == null) || (!value.equals(getJntVntrPartWrkgIntrstYr())) ) {
                    setJntVntrPartWrkgIntrstYr(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrCarriedIntrstGrp") ) {
                final Object value = values.remove("JntVntrCarriedIntrstGrp");
                if( (value == null) || (!value.equals(getJntVntrCarriedIntrstGrp())) ) {
                    setJntVntrCarriedIntrstGrp(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrNetProfitIntrstGrp") ) {
                final Object value = values.remove("JntVntrNetProfitIntrstGrp");
                if( (value == null) || (!value.equals(getJntVntrNetProfitIntrstGrp())) ) {
                    setJntVntrNetProfitIntrstGrp(((java.lang.String) value));
                }
            }
            if( values.containsKey("JntVntrOperatorAddressArea") ) {
                final Object value = values.remove("JntVntrOperatorAddressArea");
                if( (value == null) || (!value.equals(getJntVntrOperatorAddressArea())) ) {
                    setJntVntrOperatorAddressArea(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_JointVentureEquityGroup") ) {
                final Object value = (values).remove("_JointVentureEquityGroup");
                if( value instanceof Map ) {
                    if( to_JointVentureEquityGroup == null ) {
                        to_JointVentureEquityGroup = new JointVentureEquityGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_JointVentureEquityGroup.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return JointVentureService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_JointVentureEquityGroup != null ) {
            (values).put("_JointVentureEquityGroup", to_JointVentureEquityGroup);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>JointVentureEquityGroup</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_JointVentureEquityGroup</b>.
     * <p>
     * If the navigation property for an entity <b>JntVntrPartEquityShr</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_JointVentureEquityGroup</b> is already loaded, the result
     *         will contain the <b>JointVentureEquityGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<JointVentureEquityGroup> getJointVentureEquityGroupIfPresent()
    {
        return Option.of(to_JointVentureEquityGroup);
    }

    /**
     * Overwrites the associated <b>JointVentureEquityGroup</b> entity for the loaded navigation property
     * <b>_JointVentureEquityGroup</b>.
     * 
     * @param value
     *            New <b>JointVentureEquityGroup</b> entity.
     */
    public void setJointVentureEquityGroup( final JointVentureEquityGroup value )
    {
        to_JointVentureEquityGroup = value;
    }

    /**
     * Helper class to allow for fluent creation of JntVntrPartEquityShr instances.
     * 
     */
    public final static class JntVntrPartEquityShrBuilder
    {

        private JointVentureEquityGroup to_JointVentureEquityGroup;

        private JntVntrPartEquityShr.JntVntrPartEquityShrBuilder to_JointVentureEquityGroup(
            final JointVentureEquityGroup value )
        {
            to_JointVentureEquityGroup = value;
            return this;
        }

        /**
         * Navigation property <b>_JointVentureEquityGroup</b> for <b>JntVntrPartEquityShr</b> to single
         * <b>JointVentureEquityGroup</b>.
         * 
         * @param value
         *            The JointVentureEquityGroup to build this JntVntrPartEquityShr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public JntVntrPartEquityShr.JntVntrPartEquityShrBuilder jointVentureEquityGroup(
            final JointVentureEquityGroup value )
        {
            return to_JointVentureEquityGroup(value);
        }

    }

}
